      SUBROUTINE CAM_V5  (ILEV,      LEV,      ILG,      IL1,      IL2,
     1                     JLAT,   ITRVAR,    THROW,    RHROW,      LON,
     2                     XROW,   PRESSG,      SHJ,     SHTJ,      CAM,
     3                   DEGLAT,   DEGLON,     QROW,       IT,      ITR,
     3                    TSROW,     MODV,   RSFROW,     EPSI,     DLEV,
     4                       F1,       F2,        F,     WROW,    IREST,
     4                  TCSZROW,   CSZROW,      GMT,      MAE,      IGF,
     4                    TRACG,      NTR,      NTP,    KOUNT,      LUC,
     5                   SURFDG,   SURFWD, AEROSIZE,   RHSIZE,     RHOP,
     6                 AERONAME,    ISIZE,  ASO2ROW,  PSO2ROW,  ASO4ROW,
     7                  PSO4ROW,  DMSOROW,  DMSLROW,   H2SROW,     NSO4,
     1                    OHROW,  H2O2ROW,    O3ROW,   NO3ROW,   CO2ROW,
     9                   NH3ROW,  HNO3ROW,   TOTMAS,     NSUB,       ID,
     3                    PDIFF,    CLDCV,    ZMLWC,     WSUB,  SAVERAD,
     6                       QR,   RADCLD,    RGRID,  TRWTROW,   ROAROW,
     9                    RHOP0,  AERONUM,  SICNROW,  FSNOROW,   ZFPREC,
     A                    PXNEW,    PDEPV,    RTCOA,   RTICLD,   RTBCLD,
     B                    RTDRY,    RTVER,    THLEV,     DSHJ,    GDREM,
     C                       JD,    COLEF,   WETDEP,     IH2S,     IHPO,
     D                     IDMS,     ISO2,     ISO4,     IAE1,     ICAM,
     E                     ILWC,     IIWC,     ICDN,     ICLF,   CONDNU,
     6                   RTCOND,    RTSO2,    RTSO4,    RTDMS,    RTH2S,
     E                      VDG,   FSGROL,     IDAY,    GTROW,  SFCTROW,
     8                    FLAND,   RTNUCL,      RTH,      MSG,    IGFIJ,
     A                   RCRITS,   RCOEXS,      WRZ,      WRY,      WRX,   ! knut
     B                      WRW,      WRU,      WRA,       MU,       EU,   ! knut
     C                       DU,       MD,       MC,       ED,       DP,   ! knut
     D                       DZ,       MB,     EPS0,      ZFG,  DSUBCLD,   ! knut
     E                        Z,    IDEEP,       JT,     MAXG,      JDC,   ! knut
     F                  LENGATH,   NTRACA,    RTHPO,     BETA,   DELIQS,
     G                   RECRYS,   WPEVPA,   WRSCAV,   CLSIZE,   COAGFR,
     H                     PVOL,     TMIN,       NG,       NS,       ML,
     3                     PLLP,       Z0,      SCC,   RCW,   AC, CSPEC,
     4                      LAI,      RM0,      ZPD,    FCAP,   WP, RGW,
     5                     AEST,     GAMMA,     SOA,   ABCOEF,   SCCOEF,  
     6                   AODROW1,  AODROW2,  RHRROW,    LAMDA,    tcld3,
     7                   IVIS,IAMM1, IAMM2,IAMM3)
C------------------------------------------------------------------------
C     CAM - CANADIAN AEROSOL MODULE
C           VERSION 5.0b
C
C
C     HISTORY:
C     --------
c     * MAY 15/2008 - C.H. ZHOU   AMMONIA SCANVING
C     * DEC 22/2000 - S.L. GONG   SOIL DUST IS IMPLEMENTED WITH THE FRENCH
C     *                           SCHEME.
!     *                           GLOBAL 1x 1 SOIL TEXTURE DATA WAS
!     *                           USED FROM GCM12.
C     * JUN 20/1999 - S.L. GONG   ADPATED FOR USE IN AURAMS.
C     *
C     * JAN 01/1998 - S.L. GONG   CAM VERSION 1.0 WITH AEROSOL ACTIVATION
C     *                           AND CLOUD CHEMISTRY
C     *
C     * OCT 01/1997 - S.L. GONG   INTERFACED WITH ADOM GAS DRYDEPOSITION
C     *
C     * JUL 09/1997 - S.L. GONG   ADD SULPHATE AEROSOL
C     *
C     * JAN 19/1996 - S.L. GONG   VECTORIZED THE WHOLE PROGRAM
C     *                           INTERFACED WITH GCM11.
C     *
C     * SEP 05/1994 - S.L. GONG   FIRST VERSION WITH FIZ-C
C     *
C------------------------------------------------------------------------
C-----------------------------------------------------------------------
C        |                                      | T |            |     |
C NAME   |                                      | Y | DIMENSIONS | IN/ |
C        |                                      | P |            | OUT |
C________|______________________________________|_E_|____________|_____|
C AERONUM| NUMBER-CONCENTRATION OF AEROSOL      | R | ILGVSIZ *1 |  I  |
C        | PARTICLES       [#/kg_air]           |   |            |     |
C ASO2ROW| CONCENTRATION IN M**3/M**3 (area src)| R | ILG        |  I  |
C ASO4ROW| CONCENTRATION IN M**3/M**3 (area src)| R | ILG        |  I  |
C BETA   | working array                        | R | ILG*ILEV*  |  L  |
C        |                                      |   | ISIZE**2   |     |
C BLCROW | CONCENTRATION IN M**3/M**3           | R | ILG*5*2    |  I  |
C CAM    | version no. of cam,                  | R |            |  I  |
C        |  (CAM>10. for AURAMS)                |   |            |     |
C CLDCV  | Cloud cover,1-Strat,2-Convec. [0-1.] | R | ILG*ILEV*2 |  I  |
C CLSIZE | activated ambient aerosol wet        | R | ILGVSIZ #  |  O  |
C        |   radius  [m] (cf. RHSIZE)           |   |            |     |
C COAGFR | coagulation transformation ratio     | R | ISIZE^3    |     |
C CO2ROW | CARBON DIOXIDE CONCENTR. [M^3/M^3]   | R | ILG*ILEV   |  I  |
C COLEF  | working array                        | R | ILGVSIZ #  |  L  |
C CSZROW | cosine of solar zenith angle         | R | ILG        |  I  |
C DELIQS | working array                        | R | CILGVSIZ # |  L  |
C DEGLAT | Grid latitude value                  | I | ILG        |  I  |
C DEGLON | Grid longitude value                 | I | ILG        |  I  |
C DMSOROW| CONCENTRATION IN [M^3/M^3]           | R | ILG        |  I  |
C DMSLROW| CONCENTRATION IN [M^3/M^3]           | R | ILG        |  I  |
C DSHJ   | Sigma value difference between layers| R | ILG*ILEV   |  O  |
C DSUBCLD| layer thickness in mbs               | R | ILG        |  L  |
C        | (between LCL and MAXI)               |   |            |     |
C DU     | detrainment in updraft               | R | ILG*ILEV   |  L  |
C DP     | working array                        | R | ILG*ILEV   |  L  |
C DZ     | working array                        | R | ILG*ILEV   |  L  |
C ED     | entrainment in downdraft             | R | ILG*ILEV   |  L  |
C EPSI   | energy dissipation rate              | R | ILG*ILEV   |  L  |
C EPS0   | working array                        | R | ILG        |  L  |
C EU     | entrainment in updraft               | R | ILG*ILEV   |  L  |
C F      | working array (see S/R SUBVVEL)      | R |ILGVSUB*2 ##|  L  |
C F1     | working array (see S/R SUBVVEL)      | R | ILGVSUB ## |  L  |
C F2     | working array (see S/R SUBVVEL)      | R | ILGVSUB ## |  L  |
C FINT3D |   (not be used in aurams)            | I |            |  I  |
C FINTROW| working array                        | R | ILG*ISIZE*2|  L  |
C FLAND  | working array                        | R | ILG*LUC    |  L  |
C FSGROL | Ground solar irradiance (W/M**2)     | R | ILG        |  I  |
C FSNROW | snow fraction                        | R | ILG        |  I  |
C GC     | ground cover                         | R | ILG        |  I  |
C GCROW  | CONCENTRATION IN [M**3/M**3]         | R | ILG        |  I  |
C GDREM  | working array for total ground level | R | ILG*NTR*3  |  L  |
C        |      tendency                        |   |            |     |
C GMT    | Greenwich meridian time of the day[s]| R |            |  I  |
C GTROW  | Ground temperature     (k)           | R | ILG        |  I  |
C H2O2ROW| CONCENTRATION IN M**3/M**3           | R | ILG*ILEV   |  I  |
C H2SROW | CONCENTRATION IN M**3/M**3           | R | ILG        |  I  |
C HNO3ROW| CONCENTRATION IN M**3/M**3           | R | ILG*ILEV   |  I  |
C ICDN   | index of ccn                         | I |            |     |
C ICAM   | index of last tracer of CAM          |   |            |     |
C IDEEP  | holds position of gathered           | I | ILG        |  L  |
C        | points vs longitude index            |   |            |     |
C IDAY   | Julian day                           | I |            |  I  |
C IDEEP  | working array                        | R | ILG        |  L  |
C IL1    | starting point of x direction -- 1   | I |            |  I  |
C IL2    | ending point of x direction  -- nis  | I |            |  I  |
C ILEV   | Number of model level                | I |            |  I  |
C ILG    | Number of grid points in x-direction | I |            |  I  |
C ISIZE  | Number of aerosol size bins          | I |            |  I  |
C IREST  | restart switch for CAM               | I |            |     |
C JD     | GCM array (not be used in aurams)    | I |            |  I  |
C JDC    | GCM array (not be used in aurams)    | I |            |  I  |
C JT     | top level index of deep cumulus      | I | ILG        |  I  |
C        | convection                           |   |            |     |
C JLAT   | Number of grid points in y-direction | I |            |  I  |
C KOUNT  | Model counts    (time step)          | I |            |  I  |
C LEV    | ILEV+1                               | I |            |  I  |
C LON    | Number of grid points in x-direction | I |            |  I  |
C LENGATH| GCM array (not be used in aurams)    | I |            |  I  |
C MAXG   | gathered values of MAXI              | I | ILG        |  L  |
C MB     | cloud base mass flux                 | R | ILG        |  I  |
C MC     | net upward cloud mass flux           | R | ILG*ILEV   |  I  |
C MD     | downward cloud mass flux(positive up)| R | ILG*ILEV   |  I  |
C MODV   | wind speed     [m/s]                 | R | ILG*ILEV   |  I  |
C MSG    | number of missing moisture levels    | I |            |  L  |
C        | at the top of model                  |   |            |     |
C MU     | upward cloud mass flux (positive up) | R | ILG*ILEV   |  I  |
C NH3ROW | CONCENTRATION IN M**3/M**3           | R | ILG*ILEV   |  I  |
C NO3ROW | CONCENTRATION IN M**3/M**3           | R | ILG*ILEV   |  I  |
C NSUB   | No. of subgrid for caculating        | I |            |  I  |
C NTRACA | not define in AURAMS                 | I |            |  I  |
C NG     | No. of gases for dry deposition      | I |            |  I  |
C O3ROW  | CONCENTRATION IN M**3/M**3           | R | ILG*ILEV   |  I  |
C OHROW  | CONCENTRATION IN M**3/M**3           | R | ILG*ILEV   |  I  |
C OMCROW | CONCENTRATION IN M**3/M**3           | R | ILG*5*2    |  I  |
C PDEPV  | dry deposition at first level  [m/s] | R | ILGVSIZ #  |  L  |
C        | gravitional velocity at other levels |   |            |     |
C PVOL   | dry aerosol bin volume [m^3]         |   |            |     |
C PRESSG | Grid row of surface pressure [Pa]    | R | ILG        |  I  |
C PXNEW  | general working array                | R |ILG*ILEV*NTR|  L  |
C PSO2ROW| CONCENTRATION IN M^3/M^3 (point src) | R | ILG        |  I  |
C PSO4ROW| CONCENTRATION IN M^3/M^3 (point src) | R | ILG        |  I  |
C QR     | Precip rate, 1 stratifor 2 Convective| R | ILG*ILEV   |  I  |
C        |      (kg /m2 s)                      |   |            |     |
C QROW   | specific humidity                    | R | ILG*LEV    |  I  |
C RECRYS | working array                        | R | ILGVSIZ #  |  L  |
C RHOP   | bin-specific wet aerosol density     | R | ILGVSIZ #  |  I  |
C        |      [kg/m^3]                        |   |            |     |
C RHOP0  | mass density of aerosol chemical     |   |            |     |
C        |      components [kg/m^3]             |   |            |     |
C RADCLD | mean radius of cloud droplets  [um]  | R | ILG*ILEV   |  I  |
C RTDRY  | dry deposition tendency              | R |ILG*ILEV*NTR|  O  |
C RHROW  | Slice of relative humidity [%]       | R | ILG*LEV    |  I  |
C RHSIZE | unactivated ambient aerosol wet      | R | ILGVSIZ #  |  O  |
C        |      radius  [m] (cf. CLSIZE)        |   |            |     |
C RGRID  | working arrey for aerosol species-bin|   |            |     |
C        |      mass mixing ratio [kg/kg]       |   |            |     |
C ROAROW | AIR DENSITY    [KG M-3]              | R | ILG*ILEV   |  I  |
C RSFROW |  surface flux    [kg/m^2*s]          | R | ILG*NTR    |  L  |
C RCRITS | BIN NUMBER (+ FRACTION UN-ACTIVATED) | R | ILG*ILEV*2 |  I  |
C        | OF SMALLEST ACTIVATED BIN [1-isize]  |   |            |     |
C        |    1 -> STRATIFORM CLOUDS            |   |            |     |
C        |    2 -> CONVECTIVE CLOUDS            |   |            |     |
C RCOEXS | RADIUS OF UNACTIVATED AEROSOL  [m]   | R | ILG*ILEV*2 |  L  |
C        | PARTICLES FOR PARTIALLY ACTIVATED BIN|   |            |     |
C RTVER  | vertical tendency                    | R |ILG*ILEV*NTR|  L  |
C RTCOA  | COAGULATION TENDENCY                 | R |ILG*ILEV*NTR|  O  |
C RTBCLD | BELOW-CLOUD SCAVENGING TENDENCY      | R |ILG*ILEV*NTR|  O  |
C RTHPO  | working array                        | R | ILG*ILEV   |  L  |
C RTICLD | In-cloud scavenging TENDENCY         | R |ILG*ILEV*NTR|  O  |
C RTSO2  | SULPHUR DIOXIDE TENDENCY             | R | ILG*ILEV*2 |  L  |
C RTSO4  | TENDENCY                             | R | ILGVSIZ #  |  L  |
C RTDMS  | TENDENCY                             | R | ILG*ILEV   |  L  |
C RTH2S  | TENDENCY                             | R | ILG*ILEV   |  L  |
C RTNUCL | NUCLEATION TENDENCY                  | R | ILG*ILEV   |  L  |
C RTCOND | CONDENSATION TENDENCY                | R | ILGVSIZ #  |  L  |
C RTH    | working array                        | R | ILGVSIZ #  |  L  |
C RTPAR  | working array for particle diffusion | R | ILGVSIZ #  |  L  |
C        |      coefficient (cf. PDIFF)         |   |            |     |
C SFCTROW| Surface level temperature [K]        | R | ILG        |  I  |
C SIGMAT | sigma thermal height                 | R | ILG*ILEV   |  O  |
C SIGMAM | sigma momentum height                | R | ILG*ILEV   |  O  |
C SIGMATH| sigma height of first level          | R | ILG        |  O  |
C SHJ    | Local mid-layer sigma value          | R | ILG*ILEV   |  O  |
C SHTJ   | Local interface (top) sigma value    | R | ILG*LEV    |  O  |
C SICNROW| ice fraction                         | R | ILG        |  I  |
C SNOROW | Row of snow amount                   | R |            |  I  |
C SOA    | secondary organic aerosol            | R | ILG*ILEV   |  I  |
C SURFDG | surface drag coefficient CDM=(U*/U)^2| R | ILG        |  I  |
C SURFWD | surface wind                         | R | ILG        |  I  |
C TCSZROW| Daily total cosine solar zenith angle| R | ILG        |  I  |
C THLEV  | layer thickness [m]                  | R | ILG*ILEV   |  I  |
C THROW  | Grid slice of mid-layer tempt. [K]   | R | ILG*LEV    |  I  |
C TOTMAS | bin-specific total dry  mass         | R | ILGVSIZ #  |  I  |
C        |     mixing ratio [kg/kg]             |   |            |     |
C TRACG  | Grid slice of tracer amount  [kg/kg] | R |ILG,ILEV,NTR|  I  |
C TRWTROW| water content of each bin [kg/kg]    | R | ILGVSIZ #  |  I  |
C TSROW  | First level temperature [K]          | R | ILG*ILEV   | I/O |
C VDG    | gas dry deposition velocity  [m/s]   | R | ILG*NG     |  O  |
C WETDEP | working array for wet-deposition     | R | ILGVSIZ #  |  L  |
C WROW   | Model vertical wind speed            | R | ILG*ILEV   |  I  |
C XROW   | Tracer array              [kg/kg]    | R | ILG*LEV*NTR|  I  |
C WPEVPA | evaporation fraction of precip.[0-1] | R | ILG*ILEV   |  L  |
C WRSCAV | scavenge fraction of precip.   [0-1] | R | ILG*ILEV   |  L  |
C WSUB   | sub-grid vertical velocity           | R | ILGVSUB ## |  I  |
C WRA    | working array                        | R | ILG*ILEV*36|  L  |
C WRU    | working array                        | R | ILG*ILEV   |  L  |
C WRW    | working array                        | R | ILG*ILEV*  |  l  |
C        |                                      |   | NTR*9      |     |
C WRX    | working array                        | R | ILG        |  L  |
C WRY    | working array                        | R | ILG*ILEV*  |  L  |
C        |                                      |   | NTRACA*2   |     |
C WRZ    | working array                        | R | ILG*ILEV*  |  L  |
C        |                                      |   | ISIZE*2*2  |     |
C Z      | grid slice of ambient mid-layer      | R | ILG*ILEV   |  I  |
C        | height in meters                     |   |            |     |
C ZFG    | working array                        | R | ILG*ILEV   |  L  |
C ZMLWC  | Cloud liquid water [kg/kg]           | R | ILG*ILEV*2 |  I  |
C        | 1-stratiform 2-convective            |   |            |     |
C ZM     | momentum layer height                | R | ILG*ILEV   |  I  |
C ZT     | thermal layer height                 | R | ILG*ILEV   |  I  |
      COMMON /TIMES/DELT
      COMMON /AEROSWTH/ IDEBUG,   IMM,    IMA,   INU,  ICOB,IDRYDEP,   
     1                 ITUBMIX, ICOAG,I_SS,IINCLD,IBLCLD,ICCRN     

      REAL GTROW(ILG), SFCTROW(ILG)
      REAL DEGLAT(ILG), DEGLON(ILG), WETDEP(ILG,ILEV,ISIZE)
      REAL THLEV(ILG, ILEV), GDREM(ILG, NTR, 3)
      REAL THROW(ILG,LEV),RHROW(ILG,LEV),SHJ(ILG,ILEV),SHTJ(ILG,LEV)
      REAL FSNOROW(ILG), SICNROW(ILG)
      REAL QR(ILG,ILEV,2), RTVER(ILG,ILEV,NTR)
      REAL SURFDG(ILG),SURFWD(ILG),TOTMAS(ILG, ILEV,ISIZE)
      REAL RHSIZE(ILG,ILEV,ISIZE),CLSIZE(ILG,ILEV,ISIZE)
      REAL PDEPV(ILG,ILEV,ISIZE) ,ZFPREC(ILG,ILEV)
      REAL RHOP(ILG,ILEV,ISIZE), AEROSIZE(2,ISIZE), RHOP0(NTP)
      REAL RADCLD(ILG,ILEV),RGRID(ILG,ILEV,NTR),TRWTROW(ILG,ILEV,ISIZE)
      REAL RTDRY(ILG,ILEV,NTR), VDG(ILG, NG), FSGROL(ILG)
      REAL RTCOA(ILG,ILEV,NTR),RTBCLD(ILG,ILEV,NTR),RTICLD(ILG,ILEV,NTR)
      REAL RTSO2(ILG, ILEV,2),RTSO4(ILG,ILEV,ISIZE),RTDMS(ILG, ILEV)
      REAL RTH2S(ILG, ILEV), RTNUCL(ILG, ILEV),RTCOND(ILG, ILEV,ISIZE)
      REAL RTH(ILG,ILEV,ISIZE), PDIFF(ILG,ILEV,ISIZE)
      REAL PRESSG(ILG), DSHJ(ILG,ILEV), XROW(ILG,LEV,NTR)
      REAL TRACG  (ILG,ILEV,NTR)
      REAL PXNEW(ILG,ILEV,NTR), AERONUM(ILG,ILEV,ISIZE)
      REAL ROAROW(ILG,ILEV), COLEF(ILG,ILEV,ISIZE)
      REAL DELIQS(ILG, ILEV,ISIZE),   RECRYS(ILG, ILEV,ISIZE)
      REAL ASO2ROW(ILG), PSO2ROW(ILG)
      REAL ASO4ROW(ILG),PSO4ROW(ILG)
      REAl OUTARR1(ILG,ILEV,3), OUTARR2(ILG,ILEV,3)
      REAL DMSOROW(ILG),DMSLROW(ILG),H2SROW(ILG)
      REAL OHROW(ILG,ILEV), H2O2ROW(ILG,ILEV)
      REAL O3ROW(ILG,ILEV),  NO3ROW(ILG,ILEV)
      REAL CO2ROW(ILG,ILEV), NH3ROW(ILG,ILEV)
      REAL HNO3ROW(ILG,ILEV)
      REAL CLDCV(ILG,ILEV,2),ZMLWC(ILG,ILEV,2)
      REAL TSROW(ILG), QROW(ILG,LEV), MODV(ILG,ILEV), WROW(ILG,ILEV)
      REAL EPSI(ILG,ILEV), SOA(ILG,ILEV)
      REAL F1(ILG,ILEV,NSUB), F2(ILG,ILEV,NSUB)
      REAL WSUB(ILG,ILEV,NSUB)
      REAL BETA(ILG,ILEV,ISIZE*ISIZE)
      REAL WPEVPA(ILG,ILEV), WRSCAV(ILG,ILEV)
      REAL PVOL(ISIZE), COAGFR(ISIZE*ISIZE*ISIZE)
      INTEGER IGF(ISIZE),IGFIJ(ISIZE,ISIZE*ISIZE,2)

      REAL ABCOEF(ISIZE,13,NTP,14), RHRROW(ILG)
      REAL SCCOEF(ISIZE,13,NTP,14)
      REAL AODROW1(ILG,NTP,LAMDA),AODROW2(ILG,NTP,LAMDA)
           
      REAL TCSZROW(ILG),CSZROW(ILG)
      REAL FLAND(ILG,LUC), RSFROW(ILG,NTR)
      REAL RCRITS(ILG,ILEV,2),RCOEXS(ILG,ILEV,2)                        ! knut
      REAL WRA(ILG*ILEV*36)                                             ! knut
      REAL WRW(ILG,ILEV,NTR,9),WRX(ILG)                                 ! knut
      REAL WRY(ILG,ILEV,NTRACA,2),WRZ(ILG,ILEV,ISIZE,2,2)               ! knut
      REAL EPS0(ILG),MU(ILG,ILEV),EU(ILG,ILEV),DU(ILG,ILEV),MD(ILG,ILEV)! knut
      REAL MC(ILG,ILEV),ED(ILG,ILEV),DP(ILG,ILEV),DZ(ILG,ILEV),MB(ILG)  ! knut
      REAL ZFG(ILG,ILEV),DSUBCLD(ILG),RTHPO(ILG,ILEV)                   ! knut
      REAL Z(ILG,ILEV)                                                  ! knut
      REAL tcld3(ILG,ILEV)                                              ! FOR GEM-CAM

      REAL PLLP(LUC,NS),Z0(LUC,NS),SCC(NG), RCW(NG), AC(NG)
      REAL LAI(LUC,NS),RM0(NG), ZPD(LUC,NS)
      REAL FCAP(ML),WP(ML),RGW(NG)
      REAL AEST(LUC), GAMMA(LUC), CONDNU(15)
      CHARACTER*4 CSPEC(NG)

      LOGICAL WRU(ILG,ILEV), LSOA                                       ! knut
      INTEGER IDEEP(ILG),JT(ILG),MAXG(ILG),JDC(ILG),LENGATH             ! knut

      COMPLEX F(ILG,ILEV,2*NSUB)
      INTEGER  IDEBUG, DLEV,IVIS,IAMM1,IAMM2,IAMM3
      CHARACTER*8 AERONAME(NTP)

c      print*,'zhaisx prints at the begining of cam_v01'

       

czch      IF (IDEBUG .GE. 4 ) WRITE (*,*) ' CAM --> START'
C-----------------------------------------------------------------------
C      SECTION 0: IITIALIZATION
C
C-----------------------------------------------------------------------
      CALL PUTZERO (RTCOA,  ILG*ILEV*NTR)
      CALL PUTZERO (RTICLD, ILG*ILEV*NTR)
      CALL PUTZERO (RTBCLD, ILG*ILEV*NTR)
      CALL PUTZERO (PXNEW,  ILG*ILEV*NTR)
      CALL PUTZERO (GDREM,  ILG     *NTR*3)
      CALL PUTZERO (RTSO4,  ILG*ILEV*ISIZE)
c      CALL PUTZERO (RTSO2,  ILG*ILEV*2)
      CALL PUTZERO (RTCOND, ILG*ILEV*ISIZE)
      CALL PUTZERO (RTNUCL, ILG*ILEV)
      CALL PUTZERO (PDEPV,  ILG*ILEV*ISIZE)
      CALL PUTZERO (PDIFF,  ILG*ILEV*ISIZE)
      CALL PUTZERO (RTDRY,  ILG*ILEV*NTR)
      CALL PUTZERO (COLEF,  ILG*ILEV*ISIZE)
      ADT2=2.*DELT
      IZON=2
      LSOA=.TRUE.
c      print*,'cam_v01',ilg,is_x0(il1),ie_x0(il2)
      DO N=IAE1,ICAM
         DO L=1+MAE,ILEV
            DO I=IL1,IL2
                RGRID(I,L,N)=XROW(I,L+1,N)
                IF (RGRID(I,L,N) .GT. 0.1 .OR. 
     1              RGRID(I,L,N) .LT. 0.            )           THEN
                   IDEBUG=10
                   DLEV=L
                   ID=I
                   JD=JLAT
                   ITR=N
                   print *, 'overflow',XROW(I,L+1,N),I,L+1,N
c                   GOTO 150
                END IF
            END DO
          END DO
      END DO
!zch
      IF(KOUNT.eq.1) then
        call CONV_POINT (ILEV,LEV,ILG,NTR)
      ENDIF

c      print*,'cam_v05',ntp 
C----------------------------------------------------------------------
C      SECTION 1:  AEROSOL PROPERTIES OF CLEAR SKY
C
C                  A - AMBIENT RADIUS AND DENSITY
C                  B - NUMBER DENSITY
C----------------------------------------------------------------------
c       print*,'zhaisx prints before call aeroprop in cam_v01'
      CALL AEROPROP (NTR,      NTP,      ILG,     ILEV,     IL1,
     1               IL2,    ISIZE,   RHSIZE, AEROSIZE,    RHOP,
     2             RHOP0,    RHROW,    THROW,    RGRID, AERONUM,
     3            TOTMAS,    PXNEW,     IAE1, AERONAME, TRWTROW,
     4             RTCOA,   RTICLD,   RTBCLD,   RTCOND, SAVERAD,
     5             RTDRY,    RTSO4,    COLEF,       F1,      F2,
     6               RTH,     WSUB,   DELIQS,   RECRYS,  ROAROW,
     7               SHJ,   PRESSG,    PDIFF,    PDEPV,     MAE)
c       print *, 'end of aeropro'
      CALL PUTZERO (RTCOA,    ILG*ILEV*NTR)
      CALL PUTZERO (RTICLD,   ILG*ILEV*NTR)
      CALL PUTZERO (RTBCLD,   ILG*ILEV*NTR)
      CALL PUTZERO (RTCOND,   ILG*ILEV*ISIZE)
      CALL PUTZERO (COLEF,    ILG*ILEV*ISIZE)
      CALL PUTZERO (F1,       ILG*ILEV*NSUB)
      CALL PUTZERO (F2,       ILG*ILEV*NSUB)
      CALL PUTZERO (WSUB,     ILG*ILEV*NSUB)
      CALL PUTZERO (RTSO4,    ILG*ILEV*ISIZE)
      IF (IDEBUG .GE. 1 .AND. JLAT.EQ. JD)                    THEN
         WRITE (*,*) ' AEROPROP -> AERONUM  ', AERONUM(ID,DLEV,ISIZE)
         WRITE (*,*) ' AEROPROP -> TOTMAS   ', TOTMAS(ID,DLEV,ISIZE)
         WRITE (*,*) ' AEROPROP -> RSFROW   ', RSFROW(ID,ITR), NTP,ITR
         WRITE (*,*) ' AEROPROP -> XROW   ', XROW(ID,DLEV+1,ITR)
      END IF
C-----------------------------------------------------------------------
C       SECTION 2: AEROSOL-CLOUD INTERACTION
C
C                  A - AEROSOL ACTIVATION
C                  B - IN-CLOUD OXIDATION OF SO2
C                  C - IN-CLOUD SACVENGING OF AEROSOLS
C-----------------------------------------------------------------------
C      print*,'zhaisx prints before call aerocld in cam_v01'
      CALL AEROCLD(THROW,     XROW, AERONAME, AEROSIZE,
     1               LEV,     ILEV,      ILG,      IL1,      IL2,
     2               SHJ,   PRESSG,       QR,      MAE,
     3            RADCLD,    RGRID,   RTICLD,   ZFPREC,
     4             PXNEW,   RHSIZE,     RHOP,     IHPO,     DSHJ,
     5              SHTJ,     IAE1,  AERONUM,    O3ROW,  H2O2ROW,
     5               NTR,      NTP,    ISIZE,    THLEV,     ADT2,
     6             GDREM,   ROAROW,       ID,       JD,
     7              ILWC,     IIWC,     ICDN,     ICLF,    CLDCV,
     8             ZMLWC,   CO2ROW,  HNO3ROW,   NH3ROW,    KOUNT,
     9              NSUB,     WSUB,     MODV,     WROW,     EPSI,
     1                 F,       F1,       F2,     QROW,    TSROW,
     2             RTSO2,    RTSO4,     JLAT,      LON,     NSO4,
     3               CAM,       IT,      MSG,   WPEVPA,   WRSCAV,
     A            RCRITS,   RCOEXS,      WRZ,      WRY,      WRX,   ! knut
     B               WRW,      WRU,      WRA,       MU,       EU,   ! knut
     C               DU,        MD,       MC,       ED,       DP,   ! knut
     D               DZ,        MB,     EPS0,      ZFG,  DSUBCLD,   ! knut
     E                Z,     IDEEP,       JT,     MAXG,      JDC,   ! knut
     F          LENGATH,    NTRACA,    RTHPO,     ISO2,    RTCOA,
     G              RTH,COLEF(1,1,1), WETDEP,   IINCLD,
     +             COLEF(1,1,2),
     H           CLSIZE,    RTBCLD)

C         print*,'end of cld'
      CALL PUTZERO (RTH,      ILG*ILEV*ISIZE)
      CALL PUTZERO (RTCOA,    ILG*ILEV*NTR)
      CALL PUTZERO (F1,       ILG*ILEV*NSUB)
      CALL PUTZERO (F2,       ILG*ILEV*NSUB)
      CALL PUTZERO (WETDEP,   ILG*ILEV*ISIZE)

      IF (IDEBUG .GE. 1 .AND. JLAT.EQ. JD)                  THEN
         WRITE (*,*) ' AEROCLD -> RTICLD  ', RTICLD(ID,DLEV,ITR)
         WRITE (*,*) ' AEROCLD -> CLD FR  ', CLDCV(ID,DLEV,1),
     1                                                  CLDCV(ID,DLEV,2)
         WRITE (*,*) ' AEROCLD -> CLD WT  ', ZMLWC(ID,DLEV,1),
     1                                                  ZMLWC(ID,DLEV,2)
         WRITE (*,*) ' AEROCLD -> PRECIP  ', QR(ID,DLEV,1),QR(ID,DLEV,2)
         WRITE (*,*) ' AEROCLD -> EP & SV ', WPEVPA(ID,DLEV),
     1                                                 WRSCAV(ID,DLEV)
         WRITE (*,*) ' AEROCLD -> RTSO4   ', RTSO4(ID,DLEV,ISIZE)
         WRITE (*,*) ' AEROCLD -> RTSO2   ', RTSO2(ID,DLEV,2)
         WRITE (*,*) ' AEROCLD -> XROW   ', XROW(ID,DLEV+1,ITR)
      END IF
  100 CONTINUE
c----------------------------------------------------------------------
C       SECTION -3:  SULPHUR BEFORE SULPHUR CHEMISTRY
C----------------------------------------------------------------------
c1      DO NT=1,NTP
c1         IF (AERONAME(NT) .EQ. 'SULPHATE' )                   THEN
c1             CALL ADDMASS (XROW, NTP, AERONAME, IAE1, ISIZE,
c1     #              OUTARR1, ILG, LEV, NTR, ILEV, IL1,IL2)
c1	 ELSE
c1	 ENDIF
c1      END DO
c----------------------------------------------------------------------
C       SECTION 3:  SULPHUR PHYSICS AND CHEMISTRY [CLEAR SKY]
C                   SOA CONSENDATION
C
C                  A - SULPHUR CHEMISTRY
C                  B - NUCLEATION AND CONDENSATION
C----------------------------------------------------------------------
c      print*,'zhaisx prints before call sulfate in cam_v01'
      DO NT=1,NTP
!           print *, AERONAME(NT)
         IF (AERONAME(NT) .EQ. 'SULPHATE' )                   THEN
             CALL SULFATE ( LEV,     ILEV,      ILG,      IL1,    IL2,
     1                     IH2S,     IDMS,     ISO2,     ISO4,  RGRID,
     3                  AERONUM,     XROW,      NTR,      NTP, ROAROW,
     3       PRESSG,    THROW,    RHROW,      SHJ,PXNEW(1,1,1),
     4       OHROW,   NO3ROW,       NT,    KOUNT,PXNEW(1,1,2),
     5                   RHSIZE, AEROSIZE,  TCSZROW,   CSZROW,  JLAT,
     6                    ISIZE,     DELT,   RTNUCL,    RHOP0,   LON,
     7       RTCOND,    RTSO2,    RTDMS,    RTH2S, PXNEW(1,1,3),
     8               CLDCV,PXNEW(1,1,4), TOTMAS,     RTH, IAE1,
     9                PVOL,   TMIN,  COLEF, CAM, MAE,
     A                CONDNU)
           IF (IDEBUG .GE. 1 .AND. JLAT.EQ. JD)               THEN
               WRITE (*,*) ' SULFATE -> RTNUCL  ', RTNUCL(ID,DLEV)
               WRITE (*,*) ' SULFATE -> RTCON   ', RTCOND(ID,DLEV,ISIZE)
               WRITE (*,*) ' SULFATE -> RTSO2   ', RTSO2(ID,DLEV,1)
               WRITE (*,*) ' SULFATE -> XROW    ', XROW(ID,DLEV+1,ITR)
           END IF
         END IF
c          print *, 'zhaisx prints before condsoa in cam_v01'
         IF (AERONAME(NT) .EQ. 'OMCARBON' .AND. LSOA)         THEN
             CALL CONDSOA ( LEV,     ILEV,      ILG,      IL1,    IL2,
     1                    RGRID,  AERONUM,     XROW,      NTR,    NTP,
     2                   ROAROW,       NT, AEROSIZE,     JLAT,  ISIZE,
     3                     DELT,   RTCOND,      RTH,     IAE1,   PVOL,
     4                     TMIN,    COLEF,    RHOP0,      SOA,    CAM,
     5                      MAE)
         END IF
C          print *, 'end of SOA'
      END DO

C---------------------------------------------------------------------
C   SULFATE AFTER SULFATE CHEMISTRY
C
C --------------------------------------------------------------------
c1      CALL ADDMASS (XROW, NTP, AERONAME, IAE1, ISIZE,
c1     #        OUTARR2, ILG, LEV, NTR, ILEV, IL1,IL2)
C---------------------------------------------------------------------
C  SO2 CHANGE BY SO4 PRODUCTION
C 
C --------------------------------------------------------------------
c1      CALL SO2TRANS(XROW,OUTARR1,OUTARR2, NTP, AERONAME, IAE1, ISIZE,
c1     #        ILG, LEV, NTR, ILEV, IL1,IL2, ISO2)
C---------------------------------------------------------------------
C       SECTION 4: COAGULATION
C
C---------------------------------------------------------------------
c      print*,'cam',icoag,iblcld,idrydep
c       print*,'zhaisx prints before coagd in cam_v01'
      IF (ICOAG .EQ. 0) GOTO 110
      CALL COAGD   (   ILG,    IL1,    IL2,     ILEV, THROW,
     2               ISIZE, ROAROW,  RTCOA,   RHSIZE,TOTMAS,
     3             AERONUM,    NTR,    NTP,   COAGFR,  IAE1,
     4                  MU,     EU,     F1,    PXNEW, KOUNT,
     5                BETA,   ADT2,  ICOAG,    IREST,  XROW,
     6                PVOL, WETDEP,   JLAT,     ICOB,  TMIN,
     7               PDEPV,  PDIFF,  COLEF,      RTH,   MAE,
     8                 IGF,  IGFIJ,   RHOP, AEROSIZE, RECRYS)

      IF (IDEBUG .GE. 1 .AND. JLAT.EQ. JD)               THEN
         WRITE (*,*) ' COAGD -> RTCOA  ', RTCOA(ID,DLEV,ITR),ICOB
         WRITE (*,*) ' COAGD -> XROW   ', XROW(ID,DLEV+1,ITR)
      END IF
  110 CONTINUE
c        print *, 'end of coag'

c---------------------------------------------------------------------
C       AMMONIUM BEFORE SCANVING
C 
C---------------------------------------------------------------------
      CALL ADDMASS (XROW, NTP, AERONAME, IAE1, ISIZE,
     1        OUTARR1, ILG, LEV, NTR, ILEV, IL1,IL2)

C----------------------------------------------------------------------
C
C     SECTION 5: BELOW-CLOUD SCAVENGING OF AEROSOLS
C
C                  A - RAIN OR SNOW SCAVENGING
C---------------------------------------------------------------------
      IF (IBLCLD .EQ. 0)                                  GOTO 120
      CALL SCAVENG (THROW,    CLDCV,   XROW,      MAE,
     1                LEV,     ILEV,    ILG,      IL1,      IL2,
     2                SHJ,PRESSG,PDEPV,RCOEXS(1,1,1),
     +                RCRITS(1,1,1),
     3             RADCLD,       QR, RTBCLD,   RTICLD,
     4              PXNEW,   RHSIZE,   RHOP,     QROW,
     5               DSHJ,     IAE1,  PDIFF,     TMIN,     ISO2,
     5                NTR,      NTP, ISIZE,     THLEV,     ADT2,
     6              GDREM,   ROAROW,  COLEF,   WETDEP,    tcld3)
      IF (IDEBUG .GE. 1 .AND. JLAT.EQ. JD)                THEN
         WRITE (*,*) ' SCAVENG -> RTBCLD  ', RTBCLD(ID,DLEV,ITR)
         WRITE (*,*) ' SCAVENG -> XROW    ', XROW(ID,DLEV+1,ITR)
      END IF
c         print *, 'end of scaveng'
C---------------------------------------------------------------------
C
C       SECTION 6: SEDIMENTATION AND DRY DEPOSITION
C
C                  A - PARTICLE DRY DEPOSITION AND GRAVITATIONAL
C                          SETTLING
C                  B - GAS DRY DEPOSITION
C---------------------------------------------------------------------
  120 IF (IDRYDEP .EQ. 0) GOTO 150
c      print*,'zhaisx prints before drydepo in cam_v01' 
      CALL DRYDEPO(ILEV,      LEV,      ILG,      IL1,      IL2,
     1              VDG,   SURFWD,    GTROW,  SFCTROW,      MAE,
     2           FSGROL,   DEGLAT,F1(1,1,1),
     +           F1(1,1,2),F1(1,1,3),   
     3          SICNROW,  FSNOROW,    THROW,    ISIZE,      NTP,
     4              NTR,     ADT2,   PRESSG,      SHJ,     TMIN,
     5            THLEV,   ROAROW,     RHOP,   RHSIZE,     ISO2,
     6             IDMS,    FLAND,     XROW,   SURFDG,    PDEPV,
     7            RTDRY,    PXNEW,     DSHJ,    GDREM,     IAE1,
     8            CLDCV,    RHROW,     IDAY,     JLAT,    PDIFF,
     9              LUC,      CAM,       NG,       NS,       ML,
     3             PLLP,       Z0,      SCC,      RCW,      AC, CSPEC,
     4              LAI,      RM0,      ZPD,     FCAP,      WP, RGW,
     5             AEST,    GAMMA)
      IF (IDEBUG .GE. 1 .AND. JLAT.EQ. JD)              THEN
         WRITE (*,*) ' DRYDEPO -> RTDRY  ', RTDRY(ID,DLEV,ITR)
         WRITE (*,*) ' DRYDEPO -> XROW    ', XROW(ID,DLEV+1,ITR)
      END IF
c        print *, 'end of dry dep'
  150 CONTINUE
c---------------------------------------------------------------------
C       AMMONIUM AFTER SCANVING AND DEPOSTION
C
C---------------------------------------------------------------------
c
c      print*,'before addmass'
c      CALL ADDMASS (XROW, NTP, AERONAME, IAE1, ISIZE,
c     +        OUTARR2, ILG, LEV, NTR, ILEV, IL1,IL2)
c
cc      print*,'before outam'
c      CALL OUTAM(XROW,OUTARR1,OUTARR2,IL1,IL2,ILEV,MAE,
c     +        NTR,LEV,ILG,IAMM1,IAMM2,IAMM3)
cc     print*,'after outam'
cC----------------------------------------------------------------------
cC
cC       SECTION 7: OPTICAL CALCULATIONS
cC
cC---------------------------------------------------------------------
cc zch not used in current version 
cc      print*,'zhaisx prints befoer aodepth in cam_v01'
c      CALL AODEPTH ( XROW,RHOP0,ABCOEF,SCCOEF, AODROW1,AODROW2,
c     1         RHROW(1,2),  DSHJ,  PRESSG, 
c     +         PXNEW(1,1,1), 
c     +          AERONAME,
c     1         RHRROW,  RHSIZE, PXNEW(1,1,2), 
c     +          PXNEW(1,1,3),PXNEW(1,1,4),
c     1                       SHJ,  CLDCV,  EPS0,COLEF,RTCOND,
c     1                       ILG,  ILEV,     LEV, NTR, ISIZE, NTP,
c     1                      IAE1,   IL1,   IL2,
c     1            PXNEW(1,1,5), PXNEW(1,1,6),
c     +           PXNEW(1,1,7),LAMDA)
c
cC----------------------------------------------------------------------
cC
cC       SECTION 8: VISIBILITY  CALCULATIONS
cC
cC---------------------------------------------------------------------
cc      print *, IVIS,ILEV,LEV,NTR,NTP,IAE1,IL1,IL2,ISIZE,'IN CAM'
cc       print*,'zhaisx prints before visibility in cam_v01'
c      CALL VISIBILITY (XROW, ROAROW,RHROW, AERONAME,AEROSIZE,
c     1      PXNEW(1,1,1),ILG, IVIS,ILEV, LEV, NTR, NTP, 
c     +      IAE1,IL1,
c     2      IL2,ISIZE)
c
c      IF (IDEBUG .EQ. 10) THEN
cc          WRITE (*,*) ' TRACER CONCENTRATION IS TOO HIGH OR NEGATIVE'
cc          WRITE (*,*) ' OVERFLOW IS LIKELY. CAM STOPS '
cc          WRITE (*,*) ' TRACER ',ITR, '= ', RGRID(ID,DLEV,ITR)
cc          WRITE (*,*) ' DLEV    ID      JD    ITR      IT '
cc          WRITE (*,*) DLEV,    ID,      JD,    ITR,      IT
cc          CALL XIT                (' CAM_V05', -1)
c      END IF
c
      RETURN
      END
