      SUBROUTINE SFSS_B(trac, tracb, dshj, dshjb, ilg, lev, ilev, r1, 
     +                  r1b, r2, r2b, df0, df0b, df1, df1b, df2, df2b, 
     +                  i_ss, t, tb, ntr, nn, ntp, isize, luc, aerosize
     +                  , aerosizeb, surfwd, surfwdb, rhop0, rhop0b, 
     +                  rsfrow, rsfrowb, pressg, pressgb, gc, fland, 
     +                  flandb, fintrow, fintrowb, il1, il2, iae1, irest
     +)
      IMPLICIT NONE
C
C     (3)  SURF ZONE PRODUCTION
C
C
C     (2) SMITH'S SOURCE
C
C
C                                                                      
C    STATEMENT FUNCTIONS
C
C     (1) GONG-MONAHAN'S SOURCE                                        
C                                                                      
      REAL g
      REAL ww
      REAL tw
      REAL rgocp
      REAL rayon
      REAL cpres
      REAL rgoasq
      REAL rgas
      REAL asq
C----------------------------------------------------------------------
C     PURPOSE:
C     --------
C     A subroutine to evaluate the generation rate of sea salt aerosols
C     as a function of meteorologic conditions.
C
C     HISTORY:
C
C     * NOV 04/02 - S.L. GONG   A NEW SCHEME - GONG-MONAHAN [Global 
C                               Biogeochemical Cycles,2003]
C     *                         WAS USED RE REPLACE THE OLD MONAHAN'S
C     *                         SCHEME SO THAT THE APPLIABLE RANGE OF
C     *                         SEA-SALT PRODUCTION IS EXPANDED TO LESS
C     *                         THAN 0.1 MIRON.
C     * OCT 31/01 - S.L. GONG   THE PARTICLE MASS OF EACH SUB-DEVIDED
C     *                         BIN IS NOW COMPUTED IN THE DO IK=1,N*35
C     *                         LOOP: PMASS. IT WAS DONE ON AN AVERAGED
C     *                         MASS IN A BIN. VERSION 5C
C     *
C     * AUG 01/01 - S.L. GONG   THE SURF ZONE PRODUCTION OF SEA SPRAY
C     *                         FUNCTION OF de LEEUW ET AL (2001) WAS   
C     *                         ADDED WITH OCEAN COVER LESS THAN 20% GRID.
C     *
C     * SEP 02/99 - S.L. GONG   ADD THE SMITH'S SEA-SALT SURFACE FLUX
C     *                         FUNCTION. 
C     *
C     * JUN 11/98 - S.L. GONG   FLUX INTEGRATION OVER EACH SIZE BIN IS 
C     *                         DONE NOW WHEN MODEL STARTS OR RESTARTS. 
C     *                         THE INTEGRATED EFFICIENT IS SAVED IN  
C     *                         FINTROW.
C     *
C     * DEC 12/97 - S.L. GONG   NEW LANDUSE CATAGORY FLAND ARRAY IS USED
C     *                         TO REPLACE GC. THE FLAND IS BASED UPON
C     *                         EOS 1x1 km RESOLUTION DATA SETS. 
C     *
C     * DEC 19/96 - S.L. GONG   AS IN PREVIOUS SFSALT BUT
C     *                         OPTIMIZED BY VECTORIZATION
C     *
C     * NOV 21/94 - S.L. GONG   AEROSOL SURFACE FLUX COMPUTATION
C     *                         FOR SEA-SALT
C
C     METHOD:
C     -------
C     Monahan et al (Oceanic Whitecaps, E.C. Monahan
C     and G.Mac Niocail (eds), 1986)
C
C     Smith et al.
C     
C     Gong, Global Biogeochemical Cycles 2003
C
C     ARGUMENTS:
C     ----------
C     SUBROUTINE CALLED FROM SFFLUX
C
C----------------------------------------------------------------------
C
      COMMON /params/ ww, tw, rayon, asq, g, rgas, rgocp, rgoasq, cpres
      REAL cpresv
      REAL rgasv
      COMMON /params/ rgasv, cpresv
      INTEGER nsecs
      REAL delt
      INTEGER incd
      INTEGER mday
      INTEGER newrun
      INTEGER lday
      INTEGER ifdiff
      INTEGER iday
      INTEGER ktotal
      INTEGER ndays
      INTEGER kstart
      COMMON /times/ delt, ifdiff, kstart, ktotal, newrun, ndays, nsecs
     +, iday, lday, mday, incd
      INTEGER ntr
      INTEGER lev
      INTEGER ilg
      INTEGER ilev
      REAL trac(ilg, lev, ntr), dshj(ilg, ilev), t(ilg, lev), gc(ilg)
      REAL tracb(ilg, lev, ntr), dshjb(ilg, ilev), tb(ilg, lev)
      INTEGER ntp
      INTEGER isize
      REAL aerosize(2, isize), surfwd(ilg), rhop0(ntp), pressg(ilg)
      REAL aerosizeb(2, isize), surfwdb(ilg), rhop0b(ntp), pressgb(ilg)
      INTEGER luc
      REAL rsfrow(ilg, ntr), fland(ilg, luc), fintrow(ilg, isize, 3)
      REAL rsfrowb(ilg, ntr), flandb(ilg, luc), fintrowb(ilg, isize, 3)
      REAL r1(ilg), r2(ilg), df0(ilg), df1(ilg), df2(ilg)
      REAL r1b(ilg), r2b(ilg), df0b(ilg), df1b(ilg), df2b(ilg)
      REAL cc(4, 4)
      INTEGER n
      REAL rr1
      REAL rr1b
      REAL rr2
      REAL rr2b
      INTEGER i
      REAL cc3
      REAL cc3b
      INTEGER ik
      REAL del
      REAL delb
      REAL rwi
      REAL rwib
      REAL pvol
      REAL pvolb
      REAL pmass
      REAL pmassb
      REAL delr0
      REAL delr0b
      INTEGER np
      REAL a1
      REAL a1b
      REAL a2
      REAL a2b
      INTEGER arg1
      INTEGER branch
      INTEGER ad_to
      INTEGER il1
      REAL gb
      INTEGER il2
      INTEGER nn
      INTEGER irest
      REAL deltb
      INTEGER i_ss
      INTEGER iae1
      REAL temp3
      REAL*8 temp29
      REAL temp2
      REAL*8 temp28
      REAL temp1
      REAL*8 temp27
      REAL temp0
      REAL*8 temp26
      REAL*8 temp13b
      REAL*8 temp7b
      REAL*8 temp25
      REAL*8 temp24
      INTRINSIC EXP
      REAL*8 temp23
      REAL*8 temp22
      REAL*8 temp21
      REAL*8 temp20
      REAL temp32b
      REAL temp40b
      REAL temp27b
      REAL temp0b
      REAL tempb0
      REAL temp40b2
      REAL temp40b1
      REAL temp40b0
      REAL temp3b
      REAL*8 temp7b1
      REAL*8 temp7b0
      REAL*8 temp19
      REAL*8 temp18
      REAL*8 temp17
      REAL*8 temp16
      REAL*8 temp12b
      INTRINSIC FLOAT
      REAL*8 temp15
      REAL*8 temp14
      REAL*8 temp13
      REAL*8 temp11b0
      REAL*8 temp12
      REAL*8 temp11
      REAL*8 temp10
      REAL*8 temp9b
      REAL temp40
      REAL tempb
      REAL*8 temp37b
      REAL*8 temp11b
      INTRINSIC LOG
      REAL temp39
      REAL*8 temp38
      REAL*8 temp37
      REAL*8 temp36
      REAL*8 temp8b
      REAL*8 temp35
      REAL temp3b0
      REAL*8 temp34
      REAL*8 temp33
      REAL*8 temp32
      REAL*8 temp31
      REAL*8 temp30
      INTRINSIC LOG10
      REAL*8 temp27b0
      REAL*8 temp37b1
      REAL temp37b0
      INTRINSIC SQRT
      REAL temp
      REAL*8 temp9
      REAL*8 temp32b0
      REAL*8 temp8
      REAL temp39b
      REAL*8 temp7
      REAL*8 temp10b
      REAL temp6
      REAL temp4b
      REAL temp5
      REAL*8 temp10b0
      REAL temp4
      COMMON /times_b/ deltb
      COMMON /params_b/ gb
      DATA cc /0.7674, 3.079, 2.572e-11, -1.424, 0.3926, 3.101, 
     +     4.190e-11, -1.404, 0.2789, 3.115, 5.415e-11, -1.399, 0.4809, 
     +     3.082, 3.110e-11, -1.428/
C      print*,'sfss',is_x0(il1),ie_x0(il2)
C
C
C     FOR NON-START RUN, USE THE SAVED FINTROW TO COMPUTE FLUX
C
      IF (irest .EQ. 0) THEN
        CALL PUSHCONTROL1B(0)
      ELSE
C
C     OTHERWISE COMPUTE THE INTEGRATION OF SEA-SALT FOR THIS
C     MODEL RUN - FINTROW
C
        arg1 = ilg*isize*3
        CALL PUTZERO(fintrow, arg1)
C
        DO n=1,isize
          CALL PUSHreal8(rr1)
CFrom m to cm 
          rr1 = aerosize(1, n)*100.0
          CALL PUSHreal8(rr2)
          rr2 = aerosize(2, n)*100.0
          DO i=il1,il2
C                                                                      
C     * CONVERT THE DRY SIZE OF SEA-SALT AEROSOLS INTO WET SIZE BY     
C         TAKING RH INTO ACCOUNT. THE WET SIZE (80% RH) IS             
C         USED IN THE SURFACE FLUX CALCULATION.                        
C                                                                      
C     * TEMPERATURE EFFECT                                             
C                                                                      
            cc3 = cc(3, 1)*(1.0+0.004*(298.0-t(i, ilev+1)))
            CALL PUSHreal8(r1(i))
            r1(i) = (rr1**3+cc(1, 1)*rr1**cc(2, 1)/(cc3*rr1**cc(4, 1)-
     +        LOG10(0.8)))**(1./3.)*10000.00
            r2(i) = (rr2**3+cc(1, 1)*rr2**cc(2, 1)/(cc3*rr2**cc(4, 1)-
     +        LOG10(0.8)))**(1./3.)*10000.00
C                                                                     
C     * DF0 is for the indirect mechanism (via bubbles)               
C                                                                     
            df0(i) = 0.
            df1(i) = 0.
            df2(i) = 0.
          ENDDO
          DO ik=1,n*35
            DO i=il1,il2
C
C      GC(ILG) = 1 FOR SEA-ICE EXCLUDED FROM SEA-SALT PRODUCTION
C                                             
Cdel in cm
              del = (rr2-rr1)/FLOAT(n*35)
              CALL PUSHreal8(rwi)
Cfrom cm to m                   
              rwi = (rr1+del*FLOAT(ik-1))*1.e-2
              CALL PUSHreal8(pvol)
C                                                                      
C     * DRY VOLUME AND MASS OF AN AEROSOL PARTICLE OF SIZE RWI             
C                                                                      
              pvol = 4./3.*3.1415926*rwi**3
              CALL PUSHreal8(pmass)
              pmass = pvol*rhop0(nn)
              CALL PUSHreal8(delr0)
              delr0 = (r2(i)-r1(i))/FLOAT(n*35)
C
              IF (fland(i, 14) .GT. 0.0 .AND. gc(i) .NE. 1.0) THEN
                IF (i_ss .EQ. 1) THEN
CGONG'S SCHEME
                  df0(i) = df0(i) + delr0*pmass*(1.373*(r1(i)+delr0*
     +              FLOAT(ik-1))**(-(4.7*(1.+35.0*(r1(i)+delr0*FLOAT(ik-
     +              1)))**(-(0.017*(r1(i)+delr0*FLOAT(ik-1))**(-1.44))))
     +              )*(1.0+0.057*(r1(i)+delr0*FLOAT(ik-1))**3.45)*10.0**
     +              (1.607*EXP(-((0.433333-LOG10(r1(i)+delr0*FLOAT(ik-1)
     +              ))/0.433333*((0.433333-LOG10(r1(i)+delr0*FLOAT(ik-1)
     +              ))/0.433333)))))
                  CALL PUSHCONTROL1B(0)
                ELSE
CSMITH'S SCHEME
                  df0(i) = df0(i) + delr0*pmass*EXP(-(3.1*LOG((r1(i)+
     +              delr0*FLOAT(ik-1))/2.1)**2))
                  df1(i) = df1(i) + delr0*pmass*EXP(-(3.3*LOG((r1(i)+
     +              delr0*FLOAT(ik-1))/9.2)**2))
                  CALL PUSHCONTROL1B(1)
                END IF
C
C        SURF ZONE PRODUCTION
C
                IF (fland(i, 14) .LT. 1.0) THEN
                  df2(i) = df2(i) + delr0*2.0*pmass*(1.1*(r1(i)*2.0+
     +              delr0*2.0*FLOAT(ik-1))**(-1.65))
                  CALL PUSHCONTROL2B(2)
                ELSE
                  CALL PUSHCONTROL2B(1)
                END IF
              ELSE
                CALL PUSHCONTROL2B(0)
              END IF
            ENDDO
          ENDDO
          CALL PUSHINTEGER4(ik - 1)
          DO i=il1,il2
            fintrow(i, n, 1) = df0(i)
            fintrow(i, n, 2) = df1(i)
            fintrow(i, n, 3) = df2(i)
          ENDDO
        ENDDO
        CALL PUSHCONTROL1B(1)
      END IF
C
C                                                                     
C     *  INSERTION DU FLUX DE SURFACE                                 
C
C                                                                    
      DO n=1,isize
        CALL PUSHINTEGER4(np)
        np = isize*(nn-1) + n + (iae1-1)
        DO i=il1,il2
          IF (surfwd(i) .GT. 0.0 .AND. gc(i) .NE. 1.0 .AND. fland(i, 14)
     +        .GT. 0.0) THEN
            IF (i_ss .EQ. 1) THEN
              CALL PUSHreal8(rsfrow(i, np))
CGONG-MONAHAN'S SCHEME
              rsfrow(i, np) = fintrow(i, n, 1)*surfwd(i)**3.41*fland(i, 
     +          14)
              CALL PUSHCONTROL1B(0)
            ELSE
CSMITH'S SCHEME
              a1 = 10**(0.0676*surfwd(i)+2.430)
              CALL PUSHreal8(a2)
              a2 = 10**(0.9590*SQRT(surfwd(i))-1.476)
              CALL PUSHreal8(rsfrow(i, np))
              rsfrow(i, np) = (a1*fintrow(i, n, 1)+a2*fintrow(i, n, 2))*
     +          fland(i, 14)
              CALL PUSHCONTROL1B(1)
            END IF
C
C     ADDING SURFING PRODUCTION FLUX
C
            rsfrow(i, np) = rsfrow(i, np) + fintrow(i, n, 3)*EXP(0.23*
     +        surfwd(i))*fland(i, 14)
C   vertical diffusion moved to MRF in MM5
C         if(RSFROW(I,NP).gt.0) print *, RSFROW(I,NP),I,NP,'sea-salt'
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHCONTROL1B(1)
          END IF
        ENDDO
      ENDDO
      DO n=isize,1,-1
        DO i=il2,il1,-1
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            temp40 = dshj(i, ilev)*pressg(i)
            temp40b0 = g*2.*delt*tracb(i, ilev+1, np)/temp40
            temp40b1 = -(rsfrow(i, np)*temp40b0/temp40)
            rsfrowb(i, np) = rsfrowb(i, np) + temp40b0
            dshjb(i, ilev) = dshjb(i, ilev) + pressg(i)*temp40b1
            pressgb(i) = pressgb(i) + dshj(i, ilev)*temp40b1
            temp40b2 = EXP(0.23*surfwd(i))*rsfrowb(i, np)
            fintrowb(i, n, 3) = fintrowb(i, n, 3) + fland(i, 14)*
     +        temp40b2
            flandb(i, 14) = flandb(i, 14) + fintrow(i, n, 3)*temp40b2
            surfwdb(i) = surfwdb(i) + EXP(0.23*surfwd(i))*fintrow(i, n, 
     +        3)*fland(i, 14)*0.23*rsfrowb(i, np)
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPreal8(rsfrow(i, np))
              temp39b = surfwd(i)**3.41*rsfrowb(i, np)
              fintrowb(i, n, 1) = fintrowb(i, n, 1) + fland(i, 14)*
     +          temp39b
              flandb(i, 14) = flandb(i, 14) + fintrow(i, n, 1)*temp39b
              surfwdb(i) = surfwdb(i) + fintrow(i, n, 1)*fland(i, 14)*
     +          3.41*surfwd(i)**2.41*rsfrowb(i, np)
              rsfrowb(i, np) = 0.0
            ELSE
              a1 = 10**(0.0676*surfwd(i)+2.430)
              CALL POPreal8(rsfrow(i, np))
              temp40b = fland(i, 14)*rsfrowb(i, np)
              a1b = fintrow(i, n, 1)*temp40b
              fintrowb(i, n, 1) = fintrowb(i, n, 1) + a1*temp40b
              a2b = fintrow(i, n, 2)*temp40b
              fintrowb(i, n, 2) = fintrowb(i, n, 2) + a2*temp40b
              flandb(i, 14) = flandb(i, 14) + (a1*fintrow(i, n, 1)+a2*
     +          fintrow(i, n, 2))*rsfrowb(i, np)
              rsfrowb(i, np) = 0.0
              CALL POPreal8(a2)
              temp39 = SQRT(surfwd(i))
              IF (surfwd(i) .EQ. 0.0) THEN
                surfwdb(i) = surfwdb(i) + 10.**(0.0676*surfwd(i)+2.430)*
     +            LOG(10.)*0.0676*a1b
              ELSE
                surfwdb(i) = surfwdb(i) + 10.**(0.0676*surfwd(i)+2.430)*
     +           LOG(10.)*0.0676*a1b + 0.9590*10**(0.9590*temp39-1.476)*
     +           LOG(10.)*a2b/(2.0*temp39)
              END IF
            END IF
          END IF
        ENDDO
        CALL POPINTEGER4(np)
      ENDDO
      CALL POPCONTROL1B(branch)
      IF (branch .NE. 0) THEN
        DO n=isize,1,-1
          DO i=il2,il1,-1
            df2b(i) = df2b(i) + fintrowb(i, n, 3)
            fintrowb(i, n, 3) = 0.0
            df1b(i) = df1b(i) + fintrowb(i, n, 2)
            fintrowb(i, n, 2) = 0.0
            df0b(i) = df0b(i) + fintrowb(i, n, 1)
            fintrowb(i, n, 1) = 0.0
          ENDDO
          rr1b = 0.0
          rr2b = 0.0
          CALL POPINTEGER4(ad_to)
          DO ik=ad_to,1,-1
            DO i=il2,il1,-1
              CALL POPCONTROL2B(branch)
              IF (branch .EQ. 0) THEN
                delr0b = 0.0
                pmassb = 0.0
              ELSE
                IF (branch .EQ. 1) THEN
                  delr0b = 0.0
                  pmassb = 0.0
                ELSE
                  pvol = 4./3.*3.1415926*rwi**3
                  pmass = pvol*rhop0(nn)
                  temp38 = FLOAT(ik - 1)
                  temp37 = 2.0*r1(i) + 2.0*temp38*delr0
                  temp37b = 1.1*2.0*df2b(i)
                  temp37b0 = temp37**(-1.65)*temp37b
                  temp37b1 = -(delr0*pmass*1.65*temp37**(-2.65)*temp37b)
                  delr0b = temp38*2.0*temp37b1 + pmass*temp37b0
                  pmassb = delr0*temp37b0
                  r1b(i) = r1b(i) + 2.0*temp37b1
                END IF
                CALL POPCONTROL1B(branch)
                IF (branch .EQ. 0) THEN
                  temp26 = FLOAT(ik - 1)
                  temp13 = r1(i) + temp26*delr0
                  temp25 = -LOG10(temp13) + 0.433333
                  temp24 = -(temp25**2/0.433333**2)
                  temp23 = 1.607*EXP(temp24)
                  temp22 = 10.0**temp23
                  temp21 = FLOAT(ik - 1)
                  temp12 = r1(i) + temp21*delr0
                  temp20 = 0.057*temp12**3.45 + 1.0
                  temp11 = delr0*pmass*temp20
                  temp19 = FLOAT(ik - 1)
                  temp10 = r1(i) + temp19*delr0
                  temp18 = -(0.017*temp10**(-1.44))
                  temp17 = FLOAT(ik - 1)
                  temp16 = 35.0*(r1(i)+temp17*delr0) + 1.
                  temp9 = temp16**temp18
                  temp15 = -(4.7*temp9)
                  temp14 = FLOAT(ik - 1)
                  temp8 = r1(i) + temp14*delr0
                  temp7 = temp8**temp15
                  temp7b1 = 1.373*temp11*temp22*df0b(i)
                  IF (temp8 .LE. 0.0 .AND. (temp15 .EQ. 0.0 .OR. temp15 
     +                .NE. INT(temp15))) THEN
                    temp8b = 0.0
                  ELSE
                    temp8b = temp15*temp8**(temp15-1)*temp7b1
                  END IF
                  IF (temp8 .LE. 0.0) THEN
                    temp9b = 0.0
                  ELSE
                    temp9b = -(temp7*LOG(temp8)*4.7*temp7b1)
                  END IF
                  IF (temp16 .LE. 0.0 .AND. (temp18 .EQ. 0.0 .OR. temp18
     +                .NE. INT(temp18))) THEN
                    temp10b = 0.0
                  ELSE
                    temp10b = temp18*temp16**(temp18-1)*35.0*temp9b
                  END IF
                  IF (temp16 .LE. 0.0) THEN
                    temp10b0 = 0.0
                  ELSE
                    temp10b0 = 0.017*temp9*LOG(temp16)*1.44*temp10**(
     +                -2.44)*temp9b
                  END IF
                  temp11b = 1.373*temp7*df0b(i)
                  temp11b0 = temp22*temp11b
                  temp12b = 0.057*delr0*pmass*3.45*temp12**2.45*temp11b0
                  temp13b = 2*temp25*EXP(temp24)*1.607*temp22*temp11*
     +              temp11b/(0.433333**2*temp13)
                  r1b(i) = r1b(i) + temp13b + temp12b + temp10b0 + 
     +              temp10b + temp8b
                  delr0b = delr0b + temp26*temp13b + temp21*temp12b + 
     +              temp20*pmass*temp11b0 + temp19*temp10b0 + temp17*
     +              temp10b + temp14*temp8b
                  pmassb = pmassb + temp20*delr0*temp11b0
                ELSE
                  temp31 = FLOAT(ik - 1)
                  temp30 = r1(i) + temp31*delr0
                  temp27 = temp30/2.1
                  temp29 = LOG(temp27)
                  temp28 = -(3.1*temp29**2)
                  temp27b = EXP(temp28)*df0b(i)
                  temp27b0 = -(2*temp29*3.1*EXP(temp28)*delr0*pmass*df0b
     +              (i)/(temp27*2.1))
                  temp36 = FLOAT(ik - 1)
                  temp35 = r1(i) + temp36*delr0
                  temp32 = temp35/9.2
                  temp34 = LOG(temp32)
                  temp33 = -(3.3*temp34**2)
                  temp32b = EXP(temp33)*df1b(i)
                  temp32b0 = -(2*temp34*3.3*EXP(temp33)*delr0*pmass*df1b
     +              (i)/(temp32*9.2))
                  delr0b = delr0b + pmass*temp27b + temp31*temp27b0 + 
     +              temp36*temp32b0 + pmass*temp32b
                  pmassb = pmassb + delr0*temp27b + delr0*temp32b
                  r1b(i) = r1b(i) + temp27b0 + temp32b0
                END IF
              END IF
              CALL POPreal8(delr0)
              temp7b = delr0b/FLOAT(n*35)
              r2b(i) = r2b(i) + temp7b
              r1b(i) = r1b(i) - temp7b
              CALL POPreal8(pmass)
              pvolb = rhop0(nn)*pmassb
              rhop0b(nn) = rhop0b(nn) + pvol*pmassb
              CALL POPreal8(pvol)
              rwib = 3.1415926*4.*3*rwi**2*pvolb/3.
              CALL POPreal8(rwi)
              delb = 1.e-2*FLOAT(ik-1)*rwib
              temp7b0 = delb/FLOAT(n*35)
              rr1b = rr1b + 1.e-2*rwib - temp7b0
              rr2b = rr2b + temp7b0
            ENDDO
          ENDDO
          DO i=il2,il1,-1
            df2b(i) = 0.0
            df1b(i) = 0.0
            df0b(i) = 0.0
            cc3 = cc(3, 1)*(1.0+0.004*(298.0-t(i, ilev+1)))
            temp6 = rr2**cc(4, 1)
            temp4 = cc3*temp6 - LOG10(0.8)
            temp5 = rr2**cc(2, 1)
            temp3 = temp5/temp4
            IF (rr2**3 + cc(1, 1)*temp3 .LE. 0.0 .AND. (1.0/3. .EQ. 0.0 
     +          .OR. 1.0/3. .NE. INT(1.0/3.))) THEN
              temp3b = 0.0
            ELSE
              temp3b = 10000.00*(rr2**3+cc(1, 1)*temp3)**(1.0/3.-1)*r2b(
     +          i)/3.
            END IF
            temp3b0 = cc(1, 1)*temp3b/temp4
            temp4b = -(temp3*temp3b0)
            IF (rr2 .LE. 0.0 .AND. (cc(2, 1) .EQ. 0.0 .OR. cc(2, 1) .NE.
     +          INT(cc(2, 1)))) THEN
              rr2b = rr2b + 3*rr2**2*temp3b
            ELSE
              rr2b = rr2b + cc3*cc(4, 1)*rr2**(cc(4, 1)-1)*temp4b + cc(2
     +          , 1)*rr2**(cc(2, 1)-1)*temp3b0 + 3*rr2**2*temp3b
            END IF
            r2b(i) = 0.0
            CALL POPreal8(r1(i))
            temp2 = rr1**cc(4, 1)
            temp0 = cc3*temp2 - LOG10(0.8)
            temp1 = rr1**cc(2, 1)
            temp = temp1/temp0
            IF (rr1**3 + cc(1, 1)*temp .LE. 0.0 .AND. (1.0/3. .EQ. 0.0 
     +          .OR. 1.0/3. .NE. INT(1.0/3.))) THEN
              tempb = 0.0
            ELSE
              tempb = 10000.00*(rr1**3+cc(1, 1)*temp)**(1.0/3.-1)*r1b(i)
     +          /3.
            END IF
            tempb0 = cc(1, 1)*tempb/temp0
            temp0b = -(temp*tempb0)
            cc3b = temp2*temp0b + temp6*temp4b
            IF (rr1 .LE. 0.0 .AND. (cc(2, 1) .EQ. 0.0 .OR. cc(2, 1) .NE.
     +          INT(cc(2, 1)))) THEN
              rr1b = rr1b + 3*rr1**2*tempb
            ELSE
              rr1b = rr1b + cc3*cc(4, 1)*rr1**(cc(4, 1)-1)*temp0b + cc(2
     +          , 1)*rr1**(cc(2, 1)-1)*tempb0 + 3*rr1**2*tempb
            END IF
            r1b(i) = 0.0
            tb(i, ilev+1) = tb(i, ilev+1) - 0.004*cc(3, 1)*cc3b
          ENDDO
          CALL POPreal8(rr2)
          aerosizeb(2, n) = aerosizeb(2, n) + 100.0*rr2b
          CALL POPreal8(rr1)
          aerosizeb(1, n) = aerosizeb(1, n) + 100.0*rr1b
        ENDDO
        CALL PUTZERO_B(fintrow, fintrowb, arg1)
      END IF
      gb = 0.0
      deltb = 0.0
      END
