      SUBROUTINE SFSD (TRAC,  DSHJ,   ILG,   LEV,  ILEV,
     1               SURFDG,   NTR,    NN,   NTP, ISIZE,
     2             AEROSIZE, RHOP0,RSFROW,PRESSG, FLAND,
     3               SURFWD,ROAROW,   IL1,   IL2,  IAE1,
     4          ZSUB0,STOTAL, SREL,SOILZ0,SAND2ROW,CLAY2ROW,
     6                SOILW,WPRIME, USTAR,SANDROW,CLAYROW,
     5                  NS0,    Z0,   LUC, FSOIL,NATS,
     7                  NSOIL,   MODE, FEFF,SS,ZZ,FSNOW,
     8               FSOIL1,FSOIL2,FSOIL3,SAND6ROW, TBAR)
cz     8      FSOIL1,FSOIL2,FSOIL3,SAND6ROW, TBAR, RAINFALL)
!-----------------------------------------------------------------------
!                 
!     HISTORY:
!     * SEP 18/2000 - S.L. GONG   RECODED IN JAPAN FRONTIER
!     *           
!     * JAN 15/1998 - S.L. GONG   AEROSOL SOIL DUST SURFACE FLUX
!
!     METHOD:
!     -------
!     Marricorena and Bergametti, JGR 100, 1995
!
!     ARGUMENTS:
!     ----------
!     SUBROUTINE CALLED FROM SFFLUX
!
!-----------------------------------------------------------------------
      
      COMMON /PARAMS/ WW,TW,RAYON,ASQ,G,RGAS,RGOCP,RGOASQ,CPRES
      COMMON /PARAMS/ RGASV,CPRESV

      COMMON /NARCM/ AVNO, RGASi, AM, BOLTZK, PI, A
      COMMON /NARCM/ A0,RSN0,RCUT0,RCG0,P
 
      COMMON /TIMES/ DELT,IFDIFF,KSTART,KTOTAL,NEWRUN,
     1                NDAYS,NSECS,IDAY,LDAY,MDAY,INCD

      REAL TRAC   (ILG,LEV,NTR), DSHJ(ILG,ILEV), TBAR(ILG)
      REAL AEROSIZE(2,ISIZE),RHOP0(NTP),PRESSG(ILG)
      REAL RSFROW(ILG,NTR), SURFWD(ILG), SURFDG(ILG)
      REAL ROAROW(ILG,ILEV), USTAR(ILG,NATS)
      REAL SS(ILG,NSOIL), STOTAL(ILG), SREL(ILG,NSOIL,NATS)
      REAL FEFF(ILG,NATS), Z0(LUC,NS0)
      REAL SOILW(ILG), WPRIME(ILG),FSNOW(ILG)
      REAL RAINFALL(ILG)
      REAL CLAYROW(ILG),SANDROW(ILG),SAND6ROW(ILG,6)
      REAL CLAY2ROW(ILG,2),SAND2ROW(ILG,NATS)
      REAL FSOIL(ILG),SOILZ0(ILG,NATS)
      REAL FSOIL1(ILG),FSOIL2(ILG),FSOIL3(ILG)
      REAL FLAND(ILG,LUC),ZSUB0(ILG)
      REAL HH(15),ZZ(ILG,LUC)
      REAL FRAC1(100),FRAC2(100),FRAC3(100)
      REAL DP(152), MMD1(2), SIGMA1(2)
      REAL MMD(3,12),SIGMA(3,12),
     1     PCENT(3,12)
      DATA AEFF/0.35/, XEFF/10.0/, CONST/1.0/
      DATA VK/0.4/, UMIN/15./, INCLAY/0/
      DATA BETA/16300./
!
      DATA D1/1.99/,     D2/4.56/,     D3/7.68/
      DATA ASIGMA1/0.96/,ASIGMA2/0.62/,ASIGMA3/0.21/
      DATA E1/0.0453/,  E2/0.0450/,  E3/0.0447/
!     HH (CM) IS THE PHYSICAL HEIGHT OF ROUGHNESS ELEMENTS
!     OF 15 KINDS OF LUC 
      DATA HH/2000.,4000.,2000.,2000.,3000.,20.,20.,0.2,
     &        0.2,100.,2.,0.01,0.001,0.001,1000./ 
!
      DATA MMD/1000.0,  100.,   10.,
     &             690.0, 100.,   10.,
     &             520.0, 100,    5.,
     &             520.0, 100,    5.,
     &             520.0, 75.,   2.5,
     &             520.0, 75.,   2.5,
     &             210.0, 75.,   2.5,
     &             210.0, 50.,   2.5,
     &             125.0, 50.,  1.,
     &             100.0, 10.,  1.,
     &             100.0, 10.,  0.5,
     &             100.0, 10.,  0.5/
      DATA SIGMA/1.6,1.7,1.8,
     &             1.6,1.7,1.8,
     &             1.6,1.7,1.8,
     &             1.6,1.7,1.8,
     &             1.6,1.7,1.8,
     &             1.6,1.7,1.8,
     &             1.7,1.7,1.8,
     &             1.7,1.7,1.8,
     &             1.7,1.7,1.8,
     &             1.8,1.8,1.8,
     &             1.8,1.8,1.8,
     &             1.8,1.8,1.8/
      DATA PCENT/0.9,  0.1, 0.,
     &             0.6,  0.3, 0.1,
     &             0.6,  0.3, 0.1,
     &             0.5, 0.35,  0.15,
     &             0.45,0.4,0.15,
     &             0.35,0.5,0.15,
     &             0.3, 0.5, 0.2,
     &             0.3, 0.5, 0.2,
     &             0.2, 0.5,  0.3,
     &            0.65, 0.,0.35,
     &            0.6,  0.,0.40,
     &            0.5,  0.,0.50/
          real xzch
!     
!     THRESHOLD FRICTION VELOCITY FOR SMOOTH SURFACE
!        FOLLOWING cgs UNIT SYSTEM
!        UNITS: RHO - KG/M3, G - M/S2, D - CM
!               ROA - KG/M3
!     
c zhouchunhong change the following function into a file called :wq
c         G=9.8
c      B(D)=1331.647*D**1.561228+0.38194
c      PK(RHO,D,ROA)=SQRT(RHO*G*100.*D/ROA)*SQRT(1.+0.006/
c     1                                  (RHO*G*0.1*D**2.5))
c      UTH(RHO,D,ROA)=CVMGT(0.129*PK(RHO,D,ROA)*(1.-0.0858*
c     1                           EXP(-0.0617*(B(D)-10.0))),
c     2                     0.129*PK(RHO,D,ROA)/
c     3                           SQRT(1.928*B(D)**0.092-1.0),
c`     4                     B(D) .GT. 10.0)
!  
!      1/12 SOIL TYPE(S) OUT/IN CHINA.  IF INCLAY=1 OR 2 MAXMAL OR MINIMAL 
!      CLAYROW IN CHINA IS CONSIDERED. 
!     
c       print*,il1,il2,is_x0(il1),ie_x0(il2)
       DO I=IL1,IL2
c         print*,clay2row(i,1),clay2row(i,2)
         CLAYROW(I)=(CLAY2ROW(I,1)+CLAY2ROW(I,2))*0.5
CZ    IF CLAYROW IN CHINA IS CONSIDERED, CLAYROW=CLAYROW*100. FOR CHINESE AREA.
CZ       CLAYROW(I)=CLAYROW(I)*100.
CZ
         IF(INCLAY.EQ.1)  CLAYROW(I)=CLAY2ROW(I,1)
         IF(INCLAY.EQ.2)  CLAYROW(I)=CLAY2ROW(I,2)
         SANDROW(I)=SAND2ROW(I,1)
CZ1         IF(FLAND(I,8).GT.0..AND.FLAND(I,8).LE.0.1) 
CZ1     1   SOILW(I)=0.17+0.035*RAINFALL(I)
CZ1         IF(FLAND(I,8).GT.0.1.AND.FLAND(I,8).LE.0.4) 
CZ1     1   SOILW(I)=0.15+0.022*RAINFALL(I)
CZ1         IF(FLAND(I,8).GT.0.4.AND.FLAND(I,8).LE.0.7) 
CZ1     1   SOILW(I)=0.12+0.031*RAINFALL(I)
CZ1         IF(FLAND(I,8).GT.0.7.AND.FLAND(I,8).LE.0.99) 
CZ1     1   SOILW(I)=0.10+0.036*RAINFALL(I)
       END DO
c         print *,'do 1'
!
      DO NT=2,NATS
       DO I=IL1,IL2
c        print*,'sand',sand2row(i,nt),i,nt
         IF(SAND2ROW(I,2).GE.0.) THEN
           SANDROW(I)=SANDROW(I)+SAND2ROW(I,NT)
         ELSE
           SAND2ROW(I,1)=100.
         END IF
       END DO
      END DO
c         print *, 'do 2',LUC,IL1,IL2
!      SURFFACE ROUGHNESS LENGTH FOR 15 TYPES OF LUC
      DO NP=1,LUC
        DO I=IL1,IL2
c          print*,'sand',NP, I, FLAND(I,NP),hh(NP),Z0(NP,3)
c           write(*,*)NP, I, FLAND(I,NP),hh(NP),Z0(NP,3)
            IF(FLAND(I,NP).LT.0.11) THEN
              ZZ(I,NP)=(0.479*FLAND(I,NP)-0.001)*HH(NP)
              IF(ZZ(I,NP).LE.0.) ZZ(I,NP)=MAX(0.0001,Z0(NP,3)*100.) 
            ELSE
              ZZ(I,NP)=0.005*HH(NP)
            ENDIF
        END DO  
      END DO
!
c        print *, 'do 3'
      CALL PUTZERO (ZSUB0,ILG)
!
      DO NT=1,NATS
        DO I=IL1,IL2
c            print *,'sand', SAND2ROW(I,2),SAND6ROW(I,1),i
          IF(SAND2ROW(I,2).GE.0.) THEN
            IF(SAND6ROW(I,1).LT.0) THEN
              SOILZ0(I,NT)=1.73E-3
              IF(NT.LT.6) SOILZ0(I,NT)=2.3E-03
              IF(NT.GT.9) SOILZ0(I,NT)=7.0E-04
            ELSE
              SOILZ0(I,NT)=(SAND6ROW(I,2)*4.0E-03+
     1          (SAND6ROW(I,1)+SAND6ROW(I,6))*3.0E-03+
     2                SAND6ROW(I,5)*2.3E-03+
     3                SAND6ROW(I,4)*1.73E-03+
     4                SAND6ROW(I,3)*7.0E-04)*0.01
              IF(SOILZ0(I,NT).LE.0.) SOILZ0(I,NT)=1.73E-3
            END IF
          END IF
        END DO
      END DO
!
c        print *, 'do 4'
       DO NT=1,NATS
         DO I=IL1,IL2
!     * THE ROUGHNESS LENGTH OF THE ERODIBLE SMOOTH SURFACE IN CHINA
          IF(SAND2ROW(I,2).GE.0.)
     *    ZSUB0(I)=ZSUB0(I)+FLAND(I,8)*
     *    SAND2ROW(I,NT)*0.01*LOG(SOILZ0(I,NT))
         END DO
      END DO
c        print *, 'do 5'
      DO NP=1,LUC
        DO I=IL1,IL2
           IF (NP .NE. 8) THEN
!
!     * AVERAGED SURFACE ROUGHNESS LENGTH OF
!        NON-ERODIBLE FRACTION [cm]
!
              ZSUB0(I)=ZSUB0(I)+FLAND(I,NP)*LOG(ZZ(I,NP))
           ELSE
!     * THE ROUGHNESS LENGTH OF THE ERODIBLE SMOOTH SURFACE 
              IF(SAND2ROW(I,2).LT.0.) THEN   
                ZSUB0(I)=ZSUB0(I)+FLAND(I,NP)*LOG(1.73E-3)
              END IF
           END IF
        END DO   
      END DO
c         print *, 'do 6'
!
      DO I=IL1,IL2
         ZSUB0(I)=EXP(ZSUB0(I))
      END DO
!     
!        NOW, ONLY ONE SOIL TYPE IS CONSIDERED
!        WITH 2 MODES: SAND (D=500 - 50 m), SILT (50 - 1 m)
!
      DP(1)=0.0001   !CM
      DO IS=2,NSOIL
        DP(IS)=DP(IS-1)*EXP(0.0460517018598807)
      END DO
c      print*,'sfsd'

      CALL PUTZERO(SREL,      ILG*NSOIL*NATS)
c      print*,'sfsd1'
      CALL PUTZERO(FSOIL1,     ILG)
      CALL PUTZERO(FSOIL2,     ILG)
      CALL PUTZERO(FSOIL3,     ILG)
      CALL PUTZERO(SS,     ILG*NSOIL)
      CALL PUTZERO(STOTAL, ILG)
C     
c      print*,'hehehe'
      MMD1(1)=0.021       !MODE 1
      SIGMA1(1)=1.8
      MMD1(2)=0.069       !MODE 2
      SIGMA1(2)=1.6
c        print *,'do 0'
      DO NS=1, NSOIL              !SOIL SIZE SEGREGATOIN NO
        DO NM=1, 2                  !SOIL MODE = 2 OUT OF CHINA
           DO I=IL1,IL2
c              print*,'in sfsd',sandrow(i),clayrow(i),zsub0(i)
             IF (SANDROW(I) .GT. 0.0 .OR. CLAYROW(I).GT.0.0) THEN
                IF(SAND2ROW(I,2).LT.0.) THEN
                   IF (NM .EQ. 1) THEN
                      PD=1.0-(SANDROW(I)+CLAYROW(I))/100.0
                   ELSE
                      PD=SANDROW(I)/100.0
                   END IF
                   XK=PD/(SQRT(2.*PI)*LOG(SIGMA1(NM)))
                   XL=((LOG(DP(NS))-LOG(MMD1(NM)))**2)/
     1              (2.*(LOG(SIGMA1(NM)))**2)
                   XM=XK*EXP(-XL) 
                   XN=RHOP0(NN)*(2./3.)*(DP(NS)/2.)
                   DELDP=0.0460517018598807 !DP(2)-DP(1)
                   SS(I,NS)=SS(I,NS)+(XM*DELDP/XN) 
                END IF
             END IF 
           END DO
        END DO
        DO I=IL1,IL2
           STOTAL(I)=STOTAL(I)+SS(I,NS)
        END DO
      END DO
c         print *, 'do 7'
      DO NS=1,NSOIL
         DO I=IL1,IL2
            IF (STOTAL(I).GT. 0.0) THEN
               SREL(I,NS,1)=SS(I,NS)/STOTAL(I)
            END IF
         END DO
      END DO
!    
!   INSIDE OF CHINA    ELSE
c        print *, 'do 8'
      DO NT=1, NATS                     !SOIL TYPES
         CALL PUTZERO(SS,ILG*NSOIL)
         CALL PUTZERO(STOTAL,ILG)
         DO NS=1, NSOIL              !SOIL SIZE SEGREGATOIN NO
          DO NM=1, MODE                  !SOIL MODE = 3
           DO I=IL1,IL2
             IF(SAND2ROW(I,2).GE.0.) THEN
               XK=PCENT(NM,NT)/(SQRT(2.*PI)*LOG(SIGMA(NM,NT)))
               XL=((LOG(DP(NS))-LOG(MMD(NM,NT)*1.E-4))**2)/
     1            (2.*(LOG(SIGMA(NM,NT)))**2)
               XM=XK*EXP(-XL)
               XN=RHOP0(NN)*(2./3.)*(DP(NS)/2.)
               DELDP=0.0460517018598807  ! DP(2)-DP(1)
               SS(I,NS)=SS(I,NS)+(XM*DELDP/XN)
             END IF
           END DO
          END DO
          DO I=IL1,IL2
           IF(SAND2ROW(I,2).GE.0.) THEN
             STOTAL(I)=STOTAL(I)+SS(I,NS)
           END IF
          END DO
         END DO
         DO NS=1,NSOIL
           DO I=IL1,IL2
             IF(SAND2ROW(I,2).GE.0.) THEN
               IF (STOTAL(I) .GT. 0.0) 
     1           SREL(I,NS,NT)=SS(I,NS)/STOTAL(I)
             END IF
           END DO
         END DO
      END DO
!
!     COMPUTE THE EFFICIENT RATIO FOR THRESHOLD FRICTION VELOCITY.
!     THE ROUGHNESS HEIGHT WAS AVERAGED BY THE LAND-USE TYPES.
!     CLAYROW AND SANDROW ARE IN FRACTION.
!
!     COMPUTE THE EFFICIENT RATIO FOR THRESHOLD FRICTION VELOCITY.
!     THE ROUGHNESS HEIGHT WAS AVERAGED BY THE LAND-USE TYPES.
!     CLAYROW AND SANDROW ARE IN FRACTION.
!
c       print *, 'do 9'
         CALL PUTZERO(FEFF,ILG*NATS)
         CALL PUTZERO(USTAR,ILG*NATS)
      DO I=IL1,IL2
         IF ((SANDROW(I) .GT. 0.0 .OR. CLAYROW(I).GT.0.0)
     1                      .AND. ZSUB0(I) .GT. 0.0)  THEN
           IF(SAND2ROW(I,2).LT.0.) THEN
              AA=LOG(ZSUB0(I)/1.73E-03)
              BB=LOG(AEFF*(XEFF/1.73E-03)**0.8)
              FEFF(I,1)=MIN(1.0, MAX(1.-AA/BB,0.0))
           END IF
         END IF
      END DO
C
c         print *, 'do 10'
      DO NT=1,NATS
         DO I=IL1,IL2
           IF(SAND2ROW(I,2).GE.0.) THEN
             IF(SAND2ROW(I,NT).GT.0..AND.ZSUB0(I) .GT. 0.0) THEN
c         print*,'fefft',zsub0(i),soilz0(i,nt),i,nt
               AA=LOG(ZSUB0(I)/SOILZ0(I,NT))
               BB=LOG(AEFF*(XEFF/SOILZ0(I,NT))**0.8)
               FEFF(I,NT)=MIN(1.0, MAX(1.-AA/BB,0.0))
             END IF
           END IF
         END DO
      END DO
!     COMPUTE THE IMPACT OF SOIL MOISTURE CONTENT ON UTH
c        print *, 'do 11'
      DO NT=1,NATS
        DO I=IL1,IL2
           WPRIME(I)=(0.0014*CLAYROW(I)+0.17)*CLAYROW(I)
           TEMPD=MAX(0.00001, SOILW(I)*100.0-WPRIME(I))
c      print*,'cvmgt',tempd,soilw(i),wprime(i),i,nt
           RTW=CVMGT(SQRT(1.+1.21*TEMPD**0.68),
     1                 1.0, SOILW(I)*100. .GT. WPRIME(I))
c       print*,'cvmgt',tempd,soilw(i),wprime(i),i,nt,rtw
           FEFF(I,NT)=FEFF(I,NT)/RTW
!     COMPUTATION OF THE WIND FRICTION VELOCITY
!     ACCOUNTING FOR THE INCREASE OF THE ROUGHNESS LENGTH
!     DUE TO THE SALTATION LAYER (GILLETTE ETAL. JGR 103,
!     NO. D6, P6203-6209, 1998
           IF(FEFF(I,NT).GT.0..AND.ZSUB0(I) .GT. 0.0) THEN
             USTARNS=(VK*100.*SURFWD(I))/(LOG(1000./ZSUB0(I)))
             UTMIN=(UMIN/(100.*VK*FEFF(I,NT)))*LOG(1000./ZSUB0(I))
!     VK=0.4: KARMAN CONSTANT, AND 1000 CM =10 M:
!     THE HEIGHT OF WIND DEFINED LEVEL. UMIN: 21 CM/S:
!     THE MINIMAL THRESHOLD WIND FRICTION VELOCITY. 
             IF(SURFWD(I).GE.UTMIN) THEN
                  USTAR(I,NT)=USTARNS+0.3*(SURFWD(I)-UTMIN)
     &                                  *(SURFWD(I)-UTMIN)
             ELSE
                  USTAR(I,NT)=USTARNS
             ENDIF
           ENDIF  
        END DO         
      END DO 
!
!     SOIL DUST FLUX (HORIZONTAL) CALCULATIONS - ONLY ON DESERT GRID LUC=8
!     AND WHEN THE USTAR IS GREATER THAN THE THRESHOLD U*  
!     UNIT: G/CM/S
!
c         print *, 'do 12'
      DO NT=1,NATS
         DO NS=1, NSOIL
           DO I=IL1,IL2
c            print*,'feff',feff(i,nt),ustar(i,nt),i,nt,rtw
             IF (FEFF(I,NT).GT.0.0.AND.USTAR(I,NT).NE.0.) THEN
c              print *, RHOP0(NN),DP(NS),ROAROW(I,ILEV),
c     +                 FEFF(I,NT),USTAR(I,NT)
               UTHEFF=UTH(RHOP0(NN),DP(NS),ROAROW(I,ILEV))/
     1                                (FEFF(I,NT)*USTAR(I,NT))
c               print *,'sfsd', UTHEFF,FLAND(i,8),i
               IF (FLAND(I,8).GT.0.01.AND.UTHEFF.LT.1.) THEN
                  FDP1=USTAR(I,NT)**3*(1.0+UTHEFF*UTHEFF)
!                  IF(FDP1.LE.0.) FDP1=0.
                  FDP2=(1.0-UTHEFF)*CONST*(1.E-5)*ROAROW(I,ILEV)/G
!                  IF(FDP2.LE.0.) FDP2=0.
CZ Modified coastal deserts
                   IF(FLAND(I,14).GT.0.) FDP2=0.
CZ Modified coastal deserts
                  FSOIL(I)=SREL(I,NS,NT)*FDP1*FDP2*FLAND(I,8)
     &                    *SAND2ROW(I,NT)*0.01
!     0.01: BECAUSE SAND2ROW(I,NT) IS %
!     SIZE-DISTRIBUTED KINETIC ENERGY FLUX
                  DEC=FSOIL(I)*BETA
!     INDIVIDUAL KINETIC ENERGY FOR AN AGGREGATE OF SIZE DP
                  EC=(PI/3.)*1.E-1*RHOP0(NN)*(DP(NS)**3.)
     1                                       *(USTAR(I,NT)**2.)
!     APPORTIONMENT OF EC BETWEEN THE 3 AEROSOL POPULATIONS
                  IF(EC.GE.E3) THEN
                       TEST3=1.
                    ELSE
                       TEST3=0.
                    END IF
                  IF(EC.GE.E2) THEN
                    TEST2=1.
                  ELSE
                    TEST2=0.
                  END IF
                  IF(EC.GE.E1) THEN
                    TEST1=1.
                  ELSE
                    TEST1=0.
                  END IF
                  if(EC.EQ.E3) EC=E3+1.0E-8
                  P1=TEST1*(EC-E1)/(EC-E3)
                  P2=TEST2*(1-P1)*(EC-E2)/(EC-E3)
                  P3=TEST3*(1-P1-P2)
!     COMPUTATION FOR A GIVEN AGGREGATE SIZE, OF THE MASS FLUX
!     FOR EACH AEROSOL POPULATION (1.E-2 is for g/cm*cm.s to kg/m*m.s
!     because of RHOPO's unit: kg/m**3)
                  FSOIL1(I)=FSOIL1(I)+1.E-2*P1*(DEC/E1)*(PI/6.)*
     1                     RHOP0(NN)*((D1*1.E-04)**3.)
                  FSOIL2(I)=FSOIL2(I)+1.E-2*P2*(DEC/E2)*(PI/6.)*
     1                     RHOP0(NN)*((D2*1.E-04)**3.)
                  FSOIL3(I)=FSOIL3(I)+1.E-2*P3*(DEC/E3)*(PI/6.)*
     1                     RHOP0(NN)*((D3*1.E-04)**3.)
               END IF
             END IF
           END DO
         END DO
      END DO  
!
!     VERTICAL FLUX [KG M-2 S-1]
!
!     EFFECTS OF SNOW COVERS
c        print *,' do 13'
      DO I=IL1,IL2
c          if(fsnow(i).ne.0.) print *, fsnow(i),'snow'
        IF(TBAR(I) .GT. 268.0) THEN
           FSOIL1(I)=FSOIL1(I)* (1.-FSNOW(I))
             FSOIL2(I)=FSOIL2(I)* (1.-FSNOW(I))
             FSOIL3(I)=FSOIL3(I)* (1.-FSNOW(I))
        ELSE
           FSOIL1(I)=0.
           FSOIL2(I)=0.
           FSOIL3(I)=0.
        END IF
      END DO
!
      TOTV1=0.0
      TOTV2=0.0
      TOTV3=0.0
c           print *, 'do 14'
      DO N=6,ISIZE-1
          RWI = (AEROSIZE(1,N)+AEROSIZE(2,N))/2.0*1.E6
          ALOGDI = LOG10(2.*RWI)
          AMEAN1=LOG10(D1)
          AMEAN2=LOG10(D2)
          AMEAN3=LOG10(D3)
          FRAC1(N) = EXP (-(ALOGDI - AMEAN1)**2./ASIGMA1)
          FRAC2(N) = EXP (-(ALOGDI - AMEAN2)**2./ASIGMA2)
          FRAC3(N) = EXP (-(ALOGDI - AMEAN3)**2./ASIGMA3)
          TOTV1=TOTV1+FRAC1(N)
          TOTV2=TOTV2+FRAC2(N)
          TOTV3=TOTV3+FRAC3(N)
      END DO
      DO N=6,ISIZE-1
          FRAC1(N)=FRAC1(N)/TOTV1
          FRAC2(N)=FRAC2(N)/TOTV2
          FRAC3(N)=FRAC3(N)/TOTV3
          IF (FRAC1(N) .LT. 1.E-9)  FRAC1(N)=0.0
          IF (FRAC2(N) .LT. 1.E-9)  FRAC2(N)=0.0
          IF (FRAC3(N) .LT. 1.E-9)  FRAC3(N)=0.0
      END DO
!
!     *  INSERTION DU FLUX DE SURFACE
!
c          print *, 'do 15'
c      print*,'in sfsd',G,DELT
      DO 842 N = 1,ISIZE
         NP=ISIZE*(NN-1)+N+(IAE1-1)
         DO 842 I=IL1,IL2
c           print*,'in sfsd',fsoil1(i), fsoil2(i),i
           IF(N.LT.3) RSFROW(I,NP)=0.
           IF(N.EQ.3) RSFROW(I,NP)=(FSOIL1(I)+FSOIL2(I)+
     1                  FSOIL3(I))*0.02*0.01
           IF(N.EQ.4) RSFROW(I,NP)=(FSOIL1(I)+FSOIL2(I)+
     1                  FSOIL3(I))*0.02*0.24
           IF(N.EQ.5) RSFROW(I,NP)=(FSOIL1(I)+FSOIL2(I)+
     1                  FSOIL3(I))*0.02*0.75
      IF(N.GT.5.AND.N.LT.ISIZE) RSFROW(I,NP)=(FSOIL1(I)+FSOIL2(I)+
     1                  FSOIL3(I))*FRAC2(N)*0.68
            IF(N.GT.ISIZE-1) RSFROW(I,NP)=(FSOIL1(I)+FSOIL2(I)+
     1                  FSOIL3(I))*0.3
c        print*,'last test',RSFROW(i,np),dshj(i,ilev),i,np,n,ilev
c     +   ,pressg(i),g,delt 
           TRAC(I,ILEV+1,NP) = TRAC(I,ILEV+1,NP) + RSFROW(I,NP)
     1                       /(DSHJ(I,ILEV)*PRESSG(I)/G)*2.*DELT
!         if(RSFROW(I,NP).gt.0) print *, RSFROW(I,NP), I, NP,'SD'
c ---  to mix the source to the first 5 lays near to the surface in order to
c ---     to solve the advection prblem that PMDAT3 have which cannot send the tracer
c ---up enough to the upper layers
czch !!!!!!!!!!!!!!!
c          TRAC(I,ILEV+1,NP) = TRAC(I,ILEV+1,NP) + RSFROW(I,NP)
c     1                       /(DSHJ(I,ILEV)*PRESSG(I)/G)*2.*DELT
c        print*,'trac',trac(i,ilev+1,np),i,np
  842 CONTINUE
      RETURN
      END
