      SUBROUTINE SFRD (TRAC,  DSHJ,   ILG,   LEV,  ILEV,  HI,
     1                    T,   NTR,    NN,   NTP, ISIZE,ZHLEV,
     2             AEROSIZE, RHOP0,RSFROW,PRESSG,    FX,  MAE,
     3               BLCROW,   PBC,   IL1,   IL2,  IAE1)
C-----------------------------------------------------------------------
C
C     HISTORY:
C
C     * Sept 04 - C.H. ZHOU   for resuspended road dust 
C
C     METHOD:
C     -------
C
C     ARGUMENTS:
C     ----------
C     SUBROUTINE CALLED FROM SFFLUX
C
C-----------------------------------------------------------------------

      COMMON /PARAMS/ WW,TW,RAYON,ASQ,G,RGAS,RGOCP,RGOASQ,CPRES         
      COMMON /PARAMS/ RGASV,CPRESV                                      
      COMMON  /TIMES/ DELT,IFDIFF,KSTART,KTOTAL,NEWRUN,                 
     1                NDAYS,NSECS,IDAY,LDAY,MDAY,INCD                   
      REAL TRAC   (ILG,LEV,NTR), DSHJ(ILG,ILEV), T(ILG,LEV)             
      REAL AEROSIZE(2,ISIZE),RHOP0(NTP),PRESSG(ILG)
      REAL RSFROW(ILG,NTR), BLCROW(ILG,3,2)
      REAL PBC(ISIZE), FX(ILEV,ILEV), ZHLEV(ILG,ILEV), HI(ILG)
C
C     ASSUME THE INITIAL BC IS HYDROPHOBIC AND HAS A LOG-NORMAL
C     DISTRIBUTION WITH A MEAN DIAMETER OF 0.1 UM [BERNER ET AL. 1996]
C     HERE 1.33 = (2*3.1415926)^0.5*LN 1.7
C
      PTOT=0.0
      TT=1.E-3   !g/s to kg/s
      DO N=1, ISIZE
         RWI = (AEROSIZE(1,N)+AEROSIZE(2,N))/2.0
         PBC(N) = 1./1.33 *EXP (-(LOG(RWI)-LOG(1.5E-7))**2/
     1                          (2.0*(LOG(1.7))**2))
         PTOT=PTOT+PBC(N)
      END DO

C
C     *  INSERTION DU FLUX DE SURFACE
C
      CALL PUTZERO (FX, ILEV*ILEV)
      DO L=1+MAE,ILEV
         DO L1=L,ILEV-1
            IF( L1 .EQ. L) THEN
               FX(L1,L)=0.5
            ELSE
               FX(L1,L)=FX(L1-1,L)/2.0
            END IF
         END DO
         FX(ILEV,L)=FX(ILEV-1,L)
         IF(L.EQ.ILEV) FX(ILEV,L)=1.0
      END DO

      DO 900 IDP=1,3
         CALL PUTZERO(HI,ILG)
         DO L=ILEV,2,-1
           DO IL=IL1,IL2
             HII=BLCROW(IL,IDP,2)          !Fossil Fuel Height
c             if(BLCROW(IL,IDP,1).ne.0.) print *,BLCROW(IL,IDP,1)
c     +      ,BLCROW(IL,IDP,2),'zhouch in sfrd',IL,IDP
            IF (BLCROW(IL,IDP,1) .GT. 0.0 .AND. 
     1           HII.GT.ZHLEV(IL,L) .AND. HII.LE.ZHLEV(IL,L-1)) THEN
               HI(IL)=REAL(L-1)
             END IF
             IF (BLCROW(IL,IDP,1) .GT. 0.0 .AND. 
     1           HII.GT.0.0 .AND. HII.LE.ZHLEV(IL,ILEV))    THEN
               HI(IL)=REAL(ILEV)
c               print *, BLCROW(IL,IDP,1),HII
             END IF
           END DO
         END DO

         DO L=1+MAE,ILEV
         DO 842 N = 1,ISIZE
            NP=ISIZE*(NN-1)+N+(IAE1-1)
            DO 842 I=IL1,IL2
               IF (HI(I) .GT. 0. .AND. L .GE. INT(HI(I))) THEN      
                 TL=BLCROW(I,IDP,1)*PBC(N)/PTOT*FX(L,INT(HI(I)))*TT
                 RSFROW(I,NP)=RSFROW(I,NP)+TL
                  TRAC(I,L+1,NP) = TRAC(I,L+1,NP) + TL
     1                            /(DSHJ(I,L)*PRESSG(I)/G)*2.*DELT        
c              xzch=TL/(DSHJ(I,L)*PRESSG(I)/G)*2.*DELT
c                print *, xzch
               END IF
  842    CONTINUE  
         END DO
  900 CONTINUE                                                        
      RETURN                                                          

      END
