      SUBROUTINE SFNT_B(trac, tracb, dshj, dshjb, ilg, lev, ilev, mae, 
     +                  ntr, nn, isize, aerosize, ano3row, ano3rowb, 
     +                  pno3row, pno3rowb, pono3row, pono3rowb, pressg, 
     +                  pressgb, roarow, frac, fracb, rsfrow, rsfrowb, 
     +                  rgd, zhlev, il1, il2, iae1)
      IMPLICIT NONE
      REAL g
      REAL ww
      REAL tw
      REAL rgocp
      REAL rayon
      REAL cpres
      REAL rgoasq
      REAL rgas
      REAL asq
C------------------------------------------------------------------------------
C
C     HISTORY:
C     * AUG 27/2008 - M. XUE      ADDING PRIMARY NITRATE SIZE DISTRIBUTION
C     * JAN 02/2008 - C.H. ZHOU   PREVIOUS SULPHATE SFSF ROUTINE
C     *
C     * JAN 30/1998 - S.L. GONG   ADDING DMS OCEAN SURFACE CONCENTRATION
C     *                           AND FLUX FORMULATION. REPLACING PREVIOUS
C     *                           FLUX INPUT FILE
C     *
C     * MAY 26/1997 - S.L. GONG   FIRST IMPLEMENTED
C     *                           OPTIMIZED BY VECTORIZATION
C
C     ----------
C     SUBROUTINE CALLED FROM SFFLUX
C
C------------------------------------------------------------------------------
C
C          SF
      COMMON /params/ ww, tw, rayon, asq, g, rgas, rgocp, rgoasq, cpres
      REAL cpresv
      REAL rgasv
C          SF
      COMMON /params/ rgasv, cpresv
      INTEGER nsecs
      REAL delt
      INTEGER incd
      INTEGER mday
      INTEGER newrun
      INTEGER lday
      INTEGER ifdiff
      INTEGER iday
      INTEGER ktotal
      INTEGER ndays
      INTEGER kstart
C          SF
C          SF
      COMMON /times/ delt, ifdiff, kstart, ktotal, newrun, ndays, nsecs
     +, iday, lday, mday, incd
      INTEGER ntr
      INTEGER lev
      INTEGER ilg
      INTEGER ilev
      REAL trac(ilg, lev, ntr), dshj(ilg, ilev), gt(ilg)
      REAL tracb(ilg, lev, ntr), dshjb(ilg, ilev)
      REAL pressg(ilg), zhlev(ilg, ilev)
      REAL pressgb(ilg)
      INTEGER isize
      REAL rsfrow(ilg, ntr), aerosize(2, isize)
      REAL rsfrowb(ilg, ntr)
      REAL ano3row(ilg), pno3row(ilg)
      REAL ano3rowb(ilg), pno3rowb(ilg)
      REAL pono3row(ilg)
      REAL pono3rowb(ilg)
      REAL rgd(ilg, ilev, ntr), roarow(ilg, ilev)
      REAL frac(isize)
      REAL fracb(isize)
      REAL tt
      REAL tt1
      INTEGER n
      INTEGER nf
      INTEGER il
      INTEGER l
      INTEGER branch
      INTEGER il1
      REAL gb
      INTEGER il2
      INTEGER nn
      REAL deltb
      INTEGER iae1
      INTEGER mae
      REAL temp3
      REAL temp2
      REAL temp1
      REAL temp0
      REAL heightp
      REAL tempb0
      REAL temp0b
      REAL temp3b
      REAL temp2b0
      REAL tempb
      REAL temp0b0
      REAL temp2b
      REAL temp3b0
      REAL temp1b
      REAL temp
      REAL height
      REAL temp1b0
      COMMON /times_b/ deltb
      COMMON /params_b/ gb
      DATA height /5.0/
      DATA heightp /120.0/
C
C     * SURFACE FLUX - UNIT KG M-2 S-1
C       FACTOR TT CONVERTS EMISSION UNIT FROM MT M-2 SEASON-1
C       TO KG M-2 S-1
C
      tt = 1.0e-3
C
C   REF. XU, H.H. ET AL, SIZE DISTRIBUTIONS AND VERTICAL 
C        DISTRIBUTIONS OF WATER SOLUBLE IONS OF ATMOSPHERHIC AEROSOLS
C        IN BEIJING,ENVIRONMENTAL SCIENCE, 28(1), 14-19,2007
C
      frac(1) = 0.002815315
      frac(2) = 0.002815315
      frac(3) = 0.002815315
      frac(4) = 0.002815315
      frac(5) = 0.002815315
      frac(6) = 0.002815315
      frac(7) = 0.236486486
      frac(8) = 0.263513514
      frac(9) = 0.135135135
      frac(10) = 0.263513514
      frac(11) = 0.067567568
      frac(12) = 0.016891892
C
C        print *, 'FRAC=', FRAC
C
C
C     * FOR PRIMARY NITRATE AEROSOLS
C
      DO n=1,isize
        CALL PUSHINTEGER4(nf)
        nf = isize*(nn-1) + n + (iae1-1)
        DO il=il1,il2
          CALL PUSHREAL8(rsfrow(il, nf))
          rsfrow(il, nf) = ano3row(il)*frac(n)*tt
        ENDDO
C
C      * HIGHER POINT SOURCES
C
        DO l=ilev,2,-1
          DO il=il1,il2
            IF (height .GT. zhlev(il, l) .AND. height .LE. zhlev(il, l-1
     +          )) THEN
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (height .GT. 0.0 .AND. height .LE. zhlev(il, ilev)) THEN
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
          ENDDO
        ENDDO
C
C      * POWER POINT SOURCES
C
        DO l=ilev,2,-1
          DO il=il1,il2
            IF (heightp .GT. zhlev(il, l) .AND. heightp .LE. zhlev(il, l
     +          -1)) THEN
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (heightp .GT. 0.0 .AND. heightp .LE. zhlev(il, ilev)) 
     +      THEN
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
          ENDDO
        ENDDO
      ENDDO
      DO n=isize,1,-1
        DO l=2,ilev,1
          DO il=il2,il1,-1
            CALL POPCONTROL1B(branch)
            IF (branch .NE. 0) THEN
              temp3 = dshj(il, ilev)*pressg(il)
              temp3b = tt*2.*g*delt*tracb(il, lev, nf)/temp3
              temp3b0 = -(pono3row(il)*frac(n)*temp3b/temp3)
              pono3rowb(il) = pono3rowb(il) + frac(n)*temp3b
              fracb(n) = fracb(n) + pono3row(il)*temp3b
              dshjb(il, ilev) = dshjb(il, ilev) + pressg(il)*temp3b0
              pressgb(il) = pressgb(il) + dshj(il, ilev)*temp3b0
            END IF
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              temp2 = dshj(il, l-1)*pressg(il)
              temp2b = tt*2.*g*delt*tracb(il, l, nf)/temp2
              temp2b0 = -(pono3row(il)*frac(n)*temp2b/temp2)
              pono3rowb(il) = pono3rowb(il) + frac(n)*temp2b
              fracb(n) = fracb(n) + pono3row(il)*temp2b
              dshjb(il, l-1) = dshjb(il, l-1) + pressg(il)*temp2b0
              pressgb(il) = pressgb(il) + dshj(il, l-1)*temp2b0
            END IF
          ENDDO
        ENDDO
        DO l=2,ilev,1
          DO il=il2,il1,-1
            CALL POPCONTROL1B(branch)
            IF (branch .NE. 0) THEN
              temp1 = dshj(il, ilev)*pressg(il)
              temp1b = tt*2.*g*delt*tracb(il, lev, nf)/temp1
              temp1b0 = -(pno3row(il)*frac(n)*temp1b/temp1)
              pno3rowb(il) = pno3rowb(il) + frac(n)*temp1b
              fracb(n) = fracb(n) + pno3row(il)*temp1b
              dshjb(il, ilev) = dshjb(il, ilev) + pressg(il)*temp1b0
              pressgb(il) = pressgb(il) + dshj(il, ilev)*temp1b0
            END IF
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              temp0 = dshj(il, l-1)*pressg(il)
              temp0b = tt*2.*g*delt*tracb(il, l, nf)/temp0
              temp0b0 = -(pno3row(il)*frac(n)*temp0b/temp0)
              pno3rowb(il) = pno3rowb(il) + frac(n)*temp0b
              fracb(n) = fracb(n) + pno3row(il)*temp0b
              dshjb(il, l-1) = dshjb(il, l-1) + pressg(il)*temp0b0
              pressgb(il) = pressgb(il) + dshj(il, l-1)*temp0b0
            END IF
          ENDDO
        ENDDO
        DO il=il2,il1,-1
          pno3rowb(il) = pno3rowb(il) + tt*frac(n)*rsfrowb(il, nf)
          fracb(n) = fracb(n) + tt*pno3row(il)*rsfrowb(il, nf)
          temp = dshj(il, ilev)*pressg(il)
          tempb = g*2.*delt*tracb(il, ilev+1, nf)/temp
          tempb0 = -(rsfrow(il, nf)*tempb/temp)
          rsfrowb(il, nf) = rsfrowb(il, nf) + tempb
          dshjb(il, ilev) = dshjb(il, ilev) + pressg(il)*tempb0
          pressgb(il) = pressgb(il) + dshj(il, ilev)*tempb0
          CALL POPREAL8(rsfrow(il, nf))
          ano3rowb(il) = ano3rowb(il) + tt*frac(n)*rsfrowb(il, nf)
          fracb(n) = fracb(n) + tt*ano3row(il)*rsfrowb(il, nf)
          rsfrowb(il, nf) = 0.0
        ENDDO
        CALL POPINTEGER4(nf)
      ENDDO
      fracb(12) = 0.0
      fracb(11) = 0.0
      fracb(10) = 0.0
      fracb(9) = 0.0
      fracb(8) = 0.0
      fracb(7) = 0.0
      fracb(6) = 0.0
      fracb(5) = 0.0
      fracb(4) = 0.0
      fracb(3) = 0.0
      fracb(2) = 0.0
      fracb(1) = 0.0
      END
