      SUBROUTINE SFNT (TRAC,   DSHJ,    ILG,    LEV,    ILEV,   MAE,
     1                  NTR,     NN,  ISIZE,AEROSIZE, 
     2            ANO3ROW,PNO3ROW,PONO3ROW,
     +             PRESSG,ROAROW,
     3              FRAC,  RSFROW,   RGD,
     4                ZHLEV,    IL1,     IL2,  IAE1)
C------------------------------------------------------------------------------
C
C     HISTORY:
C     * AUG 27/2008 - M. XUE      ADDING PRIMARY NITRATE SIZE DISTRIBUTION
C     * JAN 02/2008 - C.H. ZHOU   PREVIOUS SULPHATE SFSF ROUTINE
c     *
C     * JAN 30/1998 - S.L. GONG   ADDING DMS OCEAN SURFACE CONCENTRATION
C     *                           AND FLUX FORMULATION. REPLACING PREVIOUS
C     *                           FLUX INPUT FILE
C     *
C     * MAY 26/1997 - S.L. GONG   FIRST IMPLEMENTED
C     *                           OPTIMIZED BY VECTORIZATION
C
C     ----------
C     SUBROUTINE CALLED FROM SFFLUX
C
C------------------------------------------------------------------------------

      COMMON /PARAMS/ WW,TW,RAYON,ASQ,G,RGAS,RGOCP,RGOASQ,CPRES         !          SF
      COMMON /PARAMS/ RGASV,CPRESV                                      !          SF
      COMMON /TIMES/ DELT,IFDIFF,KSTART,KTOTAL,NEWRUN,                  !          SF
     1                NDAYS,NSECS,IDAY,LDAY,MDAY,INCD                   !          SF
      REAL TRAC   (ILG,LEV,NTR), DSHJ(ILG,ILEV), GT(ILG)
      REAL PRESSG(ILG),ZHLEV(ILG,ILEV)
      REAL RSFROW(ILG,NTR), AEROSIZE (2,ISIZE)
      REAL ANO3ROW(ILG),PNO3ROW(ILG)
      REAl PONO3ROW(ILG)
      REAL RGD (ILG,ILEV,NTR), ROAROW(ILG,ILEV)
      REAL FRAC(ISIZE)
      DATA HEIGHT/5.0/
      DATA HEIGHTP/120.0/
C
C     * SURFACE FLUX - UNIT KG M-2 S-1
C       FACTOR TT CONVERTS EMISSION UNIT FROM MT M-2 SEASON-1
C       TO KG M-2 S-1
C
      TT=1.0e-3
      TT1=1.0e-3*64
C
C   REF. XU, H.H. ET AL, SIZE DISTRIBUTIONS AND VERTICAL 
C        DISTRIBUTIONS OF WATER SOLUBLE IONS OF ATMOSPHERHIC AEROSOLS
C        IN BEIJING,ENVIRONMENTAL SCIENCE, 28(1), 14-19,2007
C
      FRAC(1)=0.002815315
      FRAC(2)=0.002815315
      FRAC(3)=0.002815315
      FRAC(4)=0.002815315
      FRAC(5)=0.002815315
      FRAC(6)=0.002815315
      FRAC(7)=0.236486486
      FRAC(8)=0.263513514
      FRAC(9)=0.135135135
      FRAC(10)=0.263513514
      FRAC(11)=0.067567568
      FRAC(12)=0.016891892

c        print *, 'FRAC=', FRAC

C
C     * FOR PRIMARY NITRATE AEROSOLS
C
      DO N=1, ISIZE
         NF=ISIZE*(NN-1)+N+(IAE1-1)
         DO IL=IL1,IL2
            RSFROW(IL,NF) = ANO3ROW(IL)*FRAC(N)*TT
            TRAC(IL,ILEV+1,NF) = TRAC(IL,ILEV+1,NF) + RSFROW(IL,NF)
     1                      /(DSHJ(IL,ILEV)*PRESSG(IL)/G)*2.*DELT
            RSFROW(IL,NF) = RSFROW(IL,NF)+PNO3ROW(IL)*FRAC(N)*TT
         END DO
C
C      * HIGHER POINT SOURCES
C
         DO L=ILEV,2,-1
           DO IL=IL1,IL2
             IF(HEIGHT.GT.ZHLEV(IL,L).AND.HEIGHT.LE.ZHLEV(IL,L-1))THEN
                TRAC(IL,L,NF)=TRAC(IL,L,NF)+PNO3ROW(IL)*FRAC(N)*TT
     2                        /(DSHJ(IL,L-1)*PRESSG(IL)/G)*2.*DELT
             END IF
             IF(HEIGHT.GT.0.0.AND.HEIGHT.LE.ZHLEV(IL,ILEV))THEN
                TRAC(IL,LEV,NF)=TRAC(IL,LEV,NF)+PNO3ROW(IL)*FRAC(N)*TT
     2                        /(DSHJ(IL,ILEV)*PRESSG(IL)/G)*2.*DELT
             END IF
           END DO
         END DO
C
C      * POWER POINT SOURCES
C
         DO L=ILEV,2,-1
           DO IL=IL1,IL2
             IF(HEIGHTP.GT.ZHLEV(IL,L).AND.HEIGHTP.LE.ZHLEV(IL,L-1))THEN
                TRAC(IL,L,NF)=TRAC(IL,L,NF)+PONO3ROW(IL)*FRAC(N)*TT
     2                        /(DSHJ(IL,L-1)*PRESSG(IL)/G)*2.*DELT
             END IF
             IF(HEIGHTP.GT.0.0.AND.HEIGHTP.LE.ZHLEV(IL,ILEV))THEN
                TRAC(IL,LEV,NF)=TRAC(IL,LEV,NF)+PONO3ROW(IL)*FRAC(N)*TT
     2                        /(DSHJ(IL,ILEV)*PRESSG(IL)/G)*2.*DELT
             END IF
!        if(TRAC(IL,L,NF).gt.0.) print *, TRAC(IL,L,NF),IL,L,NF,'NT'
           END DO
         END DO
      END DO
      RETURN
      END
