

      SUBROUTINE INAero(AERONAME, AEROSIZE,   IAT,  ISZ,  RHOP0, ISCAM,
     1                        ID,       JD,    IT,  ITR,  ISLEV,   CAM,
     2                      DLEV,      LUC,    NG,   NS,     ML,
     3			    PLLP,       Z0,    SC,  RCW,     AC, CSPEC,
     4                       LAI,      RM0,   ZPD, FCAP,     WP,   RGW,
     5                      AEST,      GAMMA)

!--------------------------------------------------------------------------
!                                                                         !
!     PURPOSE                                                             !
!     -------                                                             !
!     - READ IN ALL PROPERTIES OF AEROSOLS AND CONTROLS                   !
!                                                                         !
!     HISTORY:                                                            !
!     --------                                                            !
!     * AUG 15/1999 - S.L. GONG   READ ALL DRY DEPOSITION                 !
!     *                           PARAMETERS FROM CONTROL FILE            !
!     *                           FOR NEW 15 LAND-USE TYPES.              !
!     *                                                                   !
!     * JUN 24/1999 - S.L. GONG   ADD CONSISTANCE CHECK                   !
!     *                           GAS DRY DEPOSITION PARAMETERS           !
!     *                                                                   !
!     * JAN  4/1997 - S.L. GONG   FIRST VERSION                           !
!     *                                                                   !
!     * OCT 26/2004 - H.Wang      China Version                           !
!     * MAY 11/2009 - C.H. ZHou   for 7 sorts of AEROSOL
!-------------------------------------------------------------------------!

! **********************************************************************
! 
!    PURPOSE ----ALL Non-change parameters for dry deposition subroutine.
!    
!         LEIMING ZHANG           JULY 20, 1997
!         
! **********************************************************************

! input : 
!         IAT,=aero_chem_np, kinds of calculatd aeorosol  	 
!		ISZ,= aero_nsize+1,number of particle bins 
!       
!         NG, number of gas species deposited
!         NS, number of seasons
!		LUC,landuse    
!		ML,	 number of classes that are land (not water...) not really used
!
! output:
!         AERONAME 
!         aerosize 
!          RHOP0,mass density of aerosol chemical 
! 	     ISCAM
!          ID                      
!          JD  
!          IT
!          ITR
!          ISLEV 
!          CAM
!          DLEV               
!          PLLP
!          Z0
!          SC,   
!          RCW,    
!          AC,
!          CSPEC,
!          LAI,      
!          RM0,   
!          ZPD,
!          FCAP,     
!          WP,   
!          RGW,
!          AEST,     
!          GAMMA
!
!-------------------------------------------------------------------------


      REAL PLLP(LUC,NS),Z0(LUC,NS),SC(NG), RCW(NG), AC(NG)
      REAL LAI(LUC,NS),RM0(NG), ZPD(LUC,NS)
      REAL FCAP(ML),WP(ML),RGW(NG)
      REAL AEST(LUC),GAMMA(LUC)
      CHARACTER*4 CSPEC(NG)
      CHARACTER AERONAME(6)*8
      CHARACTER*3 LAB                                                                
      CHARACTER*90 LINE, LIN                                                         
      LOGICAL OK                                                                     
                                                                                     
      REAL AEROSIZE(2,ISZ+1), RHOP0(IAT)
!     REAL AEROSIZE(2,ISZ), RHOP0(IAT)

      INTEGER DLEV                                                   

      COMMON /AEROSWTH/ IDEBUG,   IMM,    IMA,   INU,  ICOB,IDRYDEP,           
     1                 ITUBMIX, ICOAG,I_SS,IINCLD,IBLCLD,ICCRN     
      COMMON /NARCM/ AVNO,    RGASi,     AM,   BOLTZK,  PI,  A
      COMMON /NARCM/ A0,RSN0,RCUT0,RCG0,P
      COMMON /MACHTYP/ MACHINE,INTSIZE


!     AVNO     REAL AVOGADROS NUMBER.[MOL-1]                                        
!     RGASi    REAL UNIVERSAL ideal GAS CONSTANT.[J K-1 MOL-1]                      
!     AM       REAL MOLECULAR MASS OF AIR.[-]                                       
!     BOLTZK   REAL BOLTZMANNS CONSTANT.[J K-1]

!     DATA AVNO/6.022E23/,RGASi/8.314 /    
!     DATA   AM/28.97   /,   PI/3.1415926/ 
!     DATA    A/6371220.0/
      real  ::  AVNO=6.022E23,RGASi=8.314     
      real  ::  AM=28.97   ,   PI=3.1415926
      real  ::  A=6371220.0
        BOLTZK=RGASi/AVNO

!-----------------------------------------------------------------------------

! EVALUATE : 

                                                                                     
! READ MODEL CONTROL : 

          cam           = 10.0
          ICCRN         = 1         
          IDEBUG        = 0
          IMM           = 1
          IMA           = 0
          INU           = 0
          ICOB          = 12
          JD            = 11
          ID            = 35
          DLEV          = 30
          IT            = 0
          ITR           = 75     
          IIk           = 0
          IITRACER      = 75

          IINCLD        = 1
          IBLCLD        = 1
          IDRYDEP       = 1
          ICOAG         = 36
          ISCAM         = 1728                                    
          ISLEV         = 30   
          ITUBMIX       = 1
          I_SS          = 1

!   * READ IN MODEL PARAMETERS

!          ISIZE         = 12     
!          ICOM          = 6                                                                    
      AERONAME=(/'BLCARBON','OMCARBON',  
     &           'SOILDUST', 'SEA-SALT','SULPHATE','NITRATES'/ )
      RHOP0=(/ 1500.0, 1300.0, 2650.0, 2170.0, 1790.0, 1769.0/)   ![ kg m-3 ]

      AEROSIZE(1,:)=(/0.005, 0.01, 0.02, 0.04, 0.08,    
     &            0.16, 0.32, 0.64, 1.28, 2.56, 5.12, 10.24, 20.48/) 

      AEROSIZE(2,1:12)=AEROSIZE(1,2:13)

      AEROSIZE=AEROSIZE*1.E-6

       Z0= reshape ((/ 
     &  0.80, 2.65,  0.85,  1.05,  1.15,  0.10,  0.10,  0.04,  0.03,
     &  0.10, 0.03,  0.01,  0.00,  0.00,  1.00,  0.90,  2.65,  0.90,
     &  1.05, 1.15,  0.10,  0.10,  0.04,  0.03,  0.10,  0.03,  0.01,
     &  0.00, 0.00,  1.00,  0.90,  2.65,  0.80,  0.95,  1.15,  0.05,
     &  0.02, 0.04,  0.03,  0.10,  0.02,  0.01,  0.00,  0.00,  1.00,
     &  0.90, 2.65,  0.55,  0.55,  1.15,  0.02,  0.02,  0.04,  0.03,
     &  0.10, 0.02,  0.01,  0.00,  0.00,  1.00,  0.90,  2.65,  0.60,
     &  0.75, 1.15,  0.05,  0.05,  0.04,  0.03,  0.10,  0.03,  0.01,
     &  0.00, 0.00,  1.00/),(/LUC,NS/))

       ZPD= reshape ((/
     &  8.00,8.00,8.00,8.00,8.00,1.00,2.00,0.00,0.00,0.50,0.20,0.00,
     &  0.00,0.00,0.00,
     &  8.00,8.00,8.00,8.00,8.00,1.00,2.00,0.00,0.00,0.50,0.20,0.00,
     &  0.00,0.00,0.00,
     &  8.00,5.00,6.00,4.00,5.00,0.30,1.00,0.00,0.00,0.20,0.10,0.00,
     &  0.00,0.00,0.00,
     &  8.00,5.00,6.00,4.00,5.00,0.20,0.50,0.00,0.00,0.20,0.10,0.00,
     &  0.00,0.00,0.00,
     &  8.00,6.00,6.00,6.00,6.00,0.30,1.00,0.00,0.00,0.30,0.20,0.00,
     &  0.00,0.00,0.00/),
     &  (/LUC,NS/))

       LAI= reshape ((/
     &  5.30,4.50,1.10,3.40,4.50,2.00,2.00,0.10,0.10,0.50,0.20,0.00,
     &  0.00,0.00,0.30,
     &  5.30,4.50,0.80,1.90,3.50,1.50,1.50,0.10,0.10,2.50,0.20,0.00,
     &  0.00,0.00,0.20,
     &  4.70,4.50,0.30,0.10,2.30,1.00,1.00,0.10,0.10,1.50,0.10,0.00,
     &  0.00,0.00,0.10,
     &  5.50,4.50,0.00,0.00,2.30,0.50,0.00,0.00,0.10,1.20,0.00,0.00,
     &  0.00,0.00,0.00,
     &  5.30,4.50,0.40,0.80,3.30,1.00,1.00,0.10,0.10,0.50,0.10,0.00,
     &  0.00,0.00,0.20/),
     &  (/LUC,NS/))

       PLLP= reshape ((/
     &  2.00,5.00,2.00,5.00,5.00,2.00,2.00,-1.0,-1.0,10.0,10.0,-1.0,
     &  -1.0,-1.0,10.0,
     &  2.00,5.00,2.00,5.00,5.00,2.00,2.00,-1.0,-1.0,10.0,10.0,-1.0,
     &  -1.0,-1.0,10.0,
     &  2.00,5.00,5.00,10.0,5.00,5.00,10.0,-1.0,-1.0,10.0,10.0,-1.0,
     &  -1.0,-1.0,10.0,
     &  2.00,5.00,5.00,10.0,5.00,5.00,10.0,-1.0,-1.0,10.0,10.0,-1.0,
     &  -1.0,-1.0,10.0,
     &  2.00,5.00,2.00,5.00,5.00,2.00,2.00,-1.0,-1.0,10.0,10.0,-1.0,
     &  -1.0,-1.0,10.0/),
     &  (/LUC,NS/))

      AEST=(/1.00, 0.60, 1.10, 0.80, 0.80, 1.20, 1.20, 50.0,
     &       50.0, 1.30, 2.00, 50.0, 100., 100., 1.50/ )


      GAMMA=(/-.56, -.58, -.56, -.56, -.56, -.54, -.54, -.54,
     &        -.54, -.54, -.54, -.54, -.50, -.50, -.56/ )


      FCAP=(/9.00, 19.00, 27.00, 38.00, 34.00, 28.00, 
     &      38.00, 30.00, 33.00, 39.00,  0.00,  0.00 /  )

        WP=(/2.00, 7.00 , 11.00, 14.00, 13.00, 12.00,
     &      17.00, 16.00, 16.00, 19.00, 22.00,  0.00/   )

      CSPEC=(/'SO2 ','NO2 ','O3  ','H2O2','HNO3','PAN ',
     &        'HCHO','ALD2','MEK ','ROOH','RNO3','NH3 '/)

         SC=(/ 0.99, 0.91, 0.94, 0.62, 0.92, 1.36,
     &         0.64, 0.91, 1.20, 1.07, 1.36, 0.57/      )

         AC=(/ 8.0 , 8.0 , 15.0,  20.0 , 40.0,  4.0 ,
     &         4.0 , 4.0 ,  4.0,  12.0 ,  4.0, 10.0 /   )

        RGW=(/ 10. , 2000., 2000.,   10.,   10., 1000.,
     &         10. , 500. ,  300.,  100., 1000.,   10./ )

        RM0=(/ 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 2.0 ,
     &         0.0 , 0.0 , 0.0 , 0.0 , 2.0 , 0.0 /      )

        RCW=(/  50., 500., 500.,  10.,  10., 500.,
     &          50., 500., 500.,  50., 500.,  50./      )

        A0=  8.00
        p =  0.23E-07

        RSN0  =  300.00
        RCUT0 = 1700.00
        RCG0  =  500.00 



      END SUBROUTINE INAero

