      SUBROUTINE DRYPAR  (THROW,    LEV,   ILEV,     ILG,  ISIZE,  NTP,
     1                      IL1,    IL2,    NTR,    ADT2,   IAE1,  MAE,
     2                   PRESSG,    SHJ,  THLEV,  ROAROW,    ANU,PDIFF,
     2                     RHOP, RHSIZE,  FLAND,    XROW,   SCHM,  LUC,
     3                   SURFDG, SURFWD,  PDEPV,   RTDRY,   DSHJ,  VDP,
     4                     JLAT,  SEASN,     RA,     USI,   PLLP, AEST,
     5                       NS,  GAMMA)
C-----------------------------------------------------------------------
C
C     PURPOSE
C     -------
C     - CALCULATION OF DRY DEPOSITION OF AEROSOL PARTICLES.
C
C     HISTORY:
C     --------
C     * SEP 04/1999 - S.L. GONG   THE GRAVITATIONAL VELOCITY IS NOW 
C     *                           DONE IN AEROPROP.
C     *
C     * AUG 01/1999 - S.L. GONG   PASS ALL CONTROL VARIABLES FOR 15
C     *                           LAND-USE FROM THE CONTROL FILE.
C     *
C     * MAR 19/1998 - L.M. ZHANG  MODIFY DRY DEPOSITION PARAMETERIZATION
C     *
C     * DEC 19/1996 - S.L. GONG   VECTORIZED THE WHOLE PROGRAM AND ADD
C     *                           WORKING SPACES.
C     *
C     * AUG  4/1994 - S.L. GONG   FIRST VERSION
C     *
C
C     METHOD
C     ---------
C

C-----------------------------------------------------------------------
C        |                                      | T |            |     |
C NAME   |                                      | Y | DIMENSIONS | IN/ |
C        |                                      | P |            | OUT |
C________|______________________________________|_E_|____________|_____|
C IL1    | starting point of x direction -- 1   | I |            |  I  |
C IL2    | ending point of x direction  -- nis  | I |            |  I  |
C ILEV   | Number of model level                | I |            |  I  |
C ILG    | Number of grid points in x-direction | I |            |  I  |
C ISIZE  | Number of aerosol size bins          | I |            |  I  |
C RHOP   | bin-specific wet aerosol density     | R | ILGVSIZ #  |  I  |
C        |      [kg/m^3]                        |   |            |     |
C RHOP0  | mass density of aerosol chemical     |   |            |     |
C        |      components [kg/m^3]             |   |            |     |
C RADCLD | mean radius of cloud droplets  [um]  | R | ILG*ILEV   |  I  |
C RTDRY  | dry deposition tendency              | R |ILG*ILEV*NTR|  O  |
C RHROW  | Slice of relative humidity [%]       | R | ILG*LEV    |  I  |
C RHSIZE | unactivated ambient aerosol wet      | R | ILGVSIZ #  |  O  |
C THLEV  | layer thickness [m]                  | R | ILG*ILEV   |  I  |
C THROW  | Grid slice of mid-layer tempt. [K]   | R | ILG*LEV    |  I  |
C PRESSG | Grid row of surface pressure [Pa]    | R | ILG        |  I  |
C SURFDG | surface drag coefficient CDM=(U*/U)^2| R | ILG        |  I  |
C SURFWD | surface wind                         | R | ILG        |  I  |
C PDIFF  | Particle diffusion coefficient       | R | ILG*ISIZE  |  I  !
C PDEPV  | dry deposition at first level  [m/s] | R | ILGVSIZ #  |  O  |
C        | gravitional velocity at other levels | R |            |  I  |
C ROAROW | AIR DENSITY    [KG M-3]              | R | ILG*ILEV   |  I  |
C SHJ    | Local mid-layer sigma value          | R | ILG*ILEV   |  O  |
C FLAND  | 15 Land use categories               | R | ILG*LUC    |  L  | 
C XROW   | Tracer array              [kg/kg]    | R | ILG*LEV*NTR|  I  |
C DSHJ   | Sigma value difference between layers| R | ILG*ILEV   |  O  |
C RA     ! Aerodynamic resistance from DRYGAS   ! R | ILG        |  I  |
C USI    | Friction velocity from DRYGAS        ! R ! ILG        |  I  |

      COMMON /PARAMS/ WW,TW,RAYON,ASQ,G,RGAS,RGOCP,RGOASQ,CPRES
      COMMON /PARAMS/ RGASV,CPRESV
      COMMON /NARCM/ AVNO,    RGASi,     AM,   BOLTZK,  PI,  A
      COMMON /NARCM/ A0,RSN0,RCUT0,RCG0,P
C
C     * INPUT ARRAYS...
c
      REAL RHOP(ILG,ILEV,ISIZE),PDIFF(ILG,ILEV,ISIZE)
      REAL THROW(ILG,LEV), SHJ(ILG,ILEV), THLEV(ILG, ILEV)
      REAL RHSIZE(ILG,ILEV,ISIZE),PDEPV(ILG,ILEV,ISIZE)
      REAL SURFDG(ILG),SURFWD(ILG)
      REAL PRESSG (ILG), DSHJ(ILG,ILEV), FLAND(ILG,LUC)
      REAL XROW(ILG,LEV,NTR), RTDRY(ILG,ILEV,NTR)
      REAL VDP(ILG),PLLP(LUC,NS),SEASN(ILG),RA(ILG,LUC)
      REAL ROAROW(ILG,ILEV)
      REAL ANU(ILG), SCHM(ILG)
      REAL AEST(LUC),USI(ILG,LUC), GAMMA(LUC)
C-----------------------------------------------------------------------
C
C     * LOOP FOR THE NUMBER OF AEROSOLS (SIZE BINS)
C
C-----------------------------------------------------------------------
C--------------------------------------
C     * FOR THE SURFACE LAYER, DRY DEPOSITION IS CALCULATED.
C     * NOTE: THE GRAVITATIONAL VELOCITY WAS COMPUTED IN AEROPROP.
C--------------------------------------
      L=ILEV
      DO 4000 N=1,ISIZE
          DO I=IL1,IL2
            VDP(I)=0.0
          END DO
          DO 500 IC=1,LUC
           DO 400 I=IL1,IL2
              ISEA = INT(SEASN(I))
              IF (FLAND(I,IC).GE.0.005) THEN
C
C     * AIR'S DYNAMIC VISCOSITY
C
                 AMU=145.8*1.E-8*THROW(I,L+1)**1.5/(THROW(I,L+1)+110.4)
C     * AIR'S KINEMATIS VISCOSITY
C
                 ANU(I)=AMU/ROAROW(I,L)
                 SCHM(I)=ANU(I)/PDIFF(I,L,N)
C
C     * CALCULATE middle-variles needed for EB,EIN,EM, etc., then Ra, Rs, VDF
C
                 IF (PLLP(IC,ISEA).LE.0.) THEN
                      St=PDEPV(I,L,N)/G*USI(I,IC)*USI(I,IC)/ANU(I)
                 ELSE
                      St=PDEPV(I,L,N)/G*USI(I,IC)/PLLP(IC,ISEA)*1000.
                 END IF
                 EB= SCHM(I)**GAMMA(IC)
                 EIM=( St/(St+AEST(IC)))**2
                 EIM=AMIN1(EIM,0.8)
                 EIN=0.0
                 IF (PLLP(IC,ISEA) .GT. 0.01)
     &              EIN=(1000.0*2.*RHSIZE(I,L,N)/PLLP(IC,ISEA))**2*0.5
                 EIN=AMIN1(EIN,0.6)
                 R1= AMAX1(0.5,  EXP(-ST**0.5))
                 Rs= 1./3./USI(I,IC)/(EB+EIM+EIN)/R1
                 VDF = PDEPV(I,L,N) + 1./(RA(I,IC)+Rs)
                 VDP(I) = VDP(I)+VDF*FLAND(I,IC)
              END IF
400        CONTINUE
500       CONTINUE

          DO I=IL1,IL2
             PDEPV(I,L,N)=VDP(I)
          END DO
4000  CONTINUE

C--------------------------------------
C     * SECTION 3
C     * TENDENCY CALCULATION.
C--------------------------------------
C
C     * CREATE DEPOSITION TENDENCIES FOR EACH LAYER
C
      DO NN=1,NTP
        DO N = 1,ISIZE
          NP=ISIZE*(NN-1)+N+(IAE1-1)
          DO  L = ILEV, 1+MAE, -1
            DO I = IL1, IL2
                QCC = -PDEPV(I,L,N)*ADT2/THLEV(I,L)
                IF (L.EQ.ILEV) QCC = -PDEPV(I,L,N)*ADT2/(THLEV(I,L)*0.5)
                XXX = CVMGT(XROW(I,L+1,NP),0.0,
     1                               XROW(I,L+1,NP) .GT. 1.E-20)
                RTDRY(I,L,NP) = XXX*(EXP(QCC)-1.0)/ADT2
c           print*,'in par',I,L,N,pdepv(i,l,n)
            END DO
          END DO
        END DO
      END DO

      RETURN
      END
