      SUBROUTINE DRYGAS(ILG,      F,    VDG,    U2I,      Z2,  ILEV,
     1                   TS,     T2,   SRAD,   ZZ0,     LUC, 
     2                 GLAT,  SEASN,     RH,  CLDCV,    FCLD,
     3                 IDAY,    IL1,    IL2,  PICE,  PSNOW,
     4                   RA,    USI,   JLAT,    NG,       NS, NG0,
     3                   Z0,     SC,    RCW,   AC,
     4                  LAI,    RM0,    ZPD,    RGW)

      REAL F(ILG, LUC),VDG(ILG, NG)
      REAL ICECOV,K,KUI
      REAL LOGRATIO
      REAL Z0(LUC,NS),SC(NG), RCW(NG), AC(NG),A0
      REAL LAI(LUC,NS),RM0(NG),RGW(NG),ZPD(LUC,NS)
      REAL U2I(ILG),TS(ILG),T2(ILG),PSNOW(ILG),PICE(ILG)
      REAL SRAD(ILG),GLAT(ILG),RH(ILG),FCLD(ILG)
      REAL ZZ0(ILG)
      REAL CLDCV(ILG,ILEV,2), SEASN(ILG),RA(ILG,LUC),USI(ILG,LUC)

      COMMON /NARCM/ AVNO,    RGASi,     AM,   BOLTZK,  PI,  A
      COMMON /NARCM/ A0,RSN0,RCUT0,RCG0,P

      DATA K/0.4/,VI/0.15E-4/,G/9.81/,RAD/0.0174533/
C --- 10 MICRONS (RUTTER 1975)
      DATA BMAX /2.5E-6/
C --- 0.1 MICRONS
      DATA BMIN /0.1E-6/
C --- W/M**2  SOLAR CONSTANT
      DATA SCON /1380./
C
C --- COEFFICIENTS FOR CALCULATION OF SATURATION VAPOR PRESSURE
C --- PKK: 7/16/85
      DATA AA0/6.107799961/,AA1/4.436518521E-1/,AA2/1.428945805E-2/,
     1     AA3/2.650648471E-4/,AA4/3.031240396E-6/,AA5/2.034080948E-8/,
     2     AA6/6.136820929E-11/
C --- SEA LEVEL PRESSURE (MB)
      DATA PMB /1000./
C
C****************** HOURLY PARAMETER DEFINITIONS ********************
C     EL     - MONIN OBUKHOV LENGTH (M) - CALCULATED FOR EACH LAND
C                                         USE CATEGORY
C     USTAR  - FRICTION VELOCITY - CALCULATED FOR EACH LAND USE
C                                  CATEGORY
C     U2I    - WIND SPEED AT 10M. (M/S)
C     T2     - TEMPERATURE AT 10M. (DEG K)
C     Z2     - 10 M.
C     GLAT   - CENTER LATITUDE OF GRID CELL (DEG)
C     SRAD   - SOLAR IRRADIANCE AT THE GROUND (W/M**2)
C     FCLD   - CLOUD FRACTION (0-1)
C     TSW    - WATER SURFACE TEMPERATURE (DEG K)
C     TS     - SURFACE TEMPERATURE (DEG K)
C     PSNOW  - SNOW COVER (0.0-1.0)
C     PICE   - ICE COVER OF ENTIRE GRID CELL (0.0-1.0)
C     F      - FRACTION OF EACH LUC   (0.0-1.0)
C     PCWC   - CANOPY WATER CONTENT (0.0-1.0)
C     RH     - RELATIVE HUMIDITY OF AIR AT 10M. (0.0-1.0)
C********************************************************************
C
C      LAND USE CATEGORIES
C       1  EVERGREEN NEEDLELEAF FOREST
C       2  EVERGREEN BROADLEAF FOREST
C       3  DECIDUOUS NEEDLELEAF FOREST
C       4  DECIDUOUS BROADLEAF FOREST
C       5  MIXED FOREST 
C       6  GRASSLAND
C       7  CROPS, MIXED FARMING
C       8  DESERT
C       9  TUNDRA 
C       10 DWART TREES, SHRUBS WITH GROUND COVER 
C       11 WET LAND WITH PLANTS
C       12 ICE CAPS AND GLACIERS
C       13 INLAND WATER
C       14 OCEAN
C       15 URBAN
C------------------------------------------------------------

      ES(TEMP) = 6.108*EXP(17.27*(TEMP - 273.16)/(TEMP - 35.86))
C --- INITIALIZE DEPOSITION VELOCITY AND TOTAL RESISTANCE ARRAYS
      CALL PUTZERO (VDG,  ILG*NG)
      CALL PUTZERO (FCLD, ILG)
C
C     CLOUD COVER
C
      DO L=1,ILEV
         DO I=IL1,IL2
             FCLD(I)=FCLD(I)+ CLDCV(I,L,1)+CLDCV(I,L,2)
         END DO
      END DO
      DO I=IL1,IL2
         FCLD(I)=AMIN1(FCLD(I),1.0)
      END DO
C
C     define season category according to Julian Day and Latitude.
C
      DO 100 IL=IL1,IL2
C
C     FOR NOTHER HEMISPHERE
C
      IF (GLAT(IL) .GE. 0.0) THEN
      IF (IDAY.LE.59 .OR. IDAY.GE.335) THEN           !Jan. Feb. Dec.
         IF (GLAT(IL).LE.30.)                       SEASN(IL)=1.
         IF (GLAT(IL).GT.30. .AND. GLAT(IL).LE.35.) SEASN(IL)=5.
         IF (GLAT(IL).GT.35.)                       SEASN(IL)=4.
      END IF

      IF (IDAY.GE.60.AND. IDAY.LE.90)  THEN           !Mar.
         IF (GLAT(IL).LE.35.)                       SEASN(IL)=1.
         IF (GLAT(IL).GT.35. .AND. GLAT(IL).LE.40.) SEASN(IL)=5.
         IF (GLAT(IL).GT.40.)                       SEASN(IL)=4.
      END IF

      IF (IDAY.GE.91.AND. IDAY.LE.120) THEN           !Apr.
         IF (GLAT(IL).LE.35.)                       SEASN(IL)=1.
         IF (GLAT(IL).GT.35. .AND. GLAT(IL).LE.45.) SEASN(IL)=5.
         IF (GLAT(IL).GT.45.)                       SEASN(IL)=4.
      END IF

      IF (IDAY.GE.121.AND. IDAY.LE.151) THEN           !May.
         IF (GLAT(IL).LE.35.)                       SEASN(IL)=1.
         IF (GLAT(IL).GT.35. .AND. GLAT(IL).LE.60.) SEASN(IL)=5.
         IF (GLAT(IL).GT.60.)                       SEASN(IL)=4.
      END IF

      IF (IDAY.GE.152.AND. IDAY.LE.181) THEN           !Jun.
         IF (GLAT(IL).LE.55.)                       SEASN(IL)=1.
         IF (GLAT(IL).GT.55. .AND. GLAT(IL).LE.70.) SEASN(IL)=5.
         IF (GLAT(IL).GT.70.)                       SEASN(IL)=4.
      END IF

      IF (IDAY.GE.182.AND. IDAY.LE.212) THEN           !Jul.
         IF (GLAT(IL).LE.70.)                       SEASN(IL)=1.
         IF (GLAT(IL).GT.70. .AND. GLAT(IL).LE.80.) SEASN(IL)=5.
         IF (GLAT(IL).GT.80.)                       SEASN(IL)=4.
      END IF

      IF (IDAY.GE.213.AND. IDAY.LE.243) THEN           !Aug.
         IF (GLAT(IL).LE.45.)                       SEASN(IL)=1.
         IF (GLAT(IL).GT.45. .AND. GLAT(IL).LE.80.) SEASN(IL)=2.
         IF (GLAT(IL).GT.80.)                       SEASN(IL)=4.
      END IF

      IF (IDAY.GE.244.AND. IDAY.LE.273) THEN           !Sep.
         IF (GLAT(IL).LE.35.)                       SEASN(IL)=1.
         IF (GLAT(IL).GT.35. .AND. GLAT(IL).LE.65.) SEASN(IL)=2.
         IF (GLAT(IL).GT.65. .AND. GLAT(IL).LE.80.) SEASN(IL)=3.
         IF (GLAT(IL).GT.80.)                       SEASN(IL)=4.
      END IF

      IF (IDAY.GE.274.AND. IDAY.LE.304) THEN           !Oct.
         IF (GLAT(IL).LE.35.)                       SEASN(IL)=1.
         IF (GLAT(IL).GT.35. .AND. GLAT(IL).LE.45.) SEASN(IL)=2.
         IF (GLAT(IL).GT.45. .AND. GLAT(IL).LE.65.) SEASN(IL)=3.
         IF (GLAT(IL).GT.65.)                       SEASN(IL)=4.
      END IF

      IF (IDAY.GE.305.AND. IDAY.LE.334) THEN           !Nov.
         IF (GLAT(IL).LE.35.)                       SEASN(IL)=1.
         IF (GLAT(IL).GT.35. .AND. GLAT(IL).LE.40.) SEASN(IL)=2.
         IF (GLAT(IL).GT.40. .AND. GLAT(IL).LE.50.) SEASN(IL)=3.
         IF (GLAT(IL).GT.50.)                       SEASN(IL)=4.
      END IF

      ELSE
c
c     Southern hemisphere
c
      IF (IDAY.GE.152.AND. IDAY.LE.243) THEN           !Jun. Jul. Aug.
       IF (ABS(GLAT(IL)).LE.30.)                       SEASN(IL)=1. 
       IF (ABS(GLAT(IL)).GT.30. .AND. ABS(GLAT(IL)).LE.35.) SEASN(IL)=5.
       IF (ABS(GLAT(IL)).GT.35.)                       SEASN(IL)=4.
      END IF
       
      IF (IDAY.GE.244.AND. IDAY.LE.273) THEN           !SEp.
       IF (ABS(GLAT(IL)).LE.35.)                       SEASN(IL)=1. 
       IF (ABS(GLAT(IL)).GT.35. .AND. ABS(GLAT(IL)).LE.40.) SEASN(IL)=5.
       IF (ABS(GLAT(IL)).GT.40.)                       SEASN(IL)=4.
      END IF
       
      IF (IDAY.GE.274.AND. IDAY.LE.304) THEN           !Oct.
       IF (ABS(GLAT(IL)).LE.35.)                       SEASN(IL)=1. 
       IF (ABS(GLAT(IL)).GT.35. .AND. ABS(GLAT(IL)).LE.45.) SEASN(IL)=5.
       IF (ABS(GLAT(IL)).GT.45.)                       SEASN(IL)=4.
      END IF
       
      IF (IDAY.GE.305.AND. IDAY.LE.334) THEN           !Nov.
       IF (ABS(GLAT(IL)).LE.35.)                       SEASN(IL)=1. 
       IF (ABS(GLAT(IL)).GT.35. .AND. ABS(GLAT(IL)).LE.60.) SEASN(IL)=5.
       IF (ABS(GLAT(IL)).GT.60.)                       SEASN(IL)=4.
      END IF
      IF (IDAY.GE.335) THEN                            !Dec.
       IF (ABS(GLAT(IL)).LE.55.)                       SEASN(IL)=1. 
       IF (ABS(GLAT(IL)).GT.55. .AND. ABS(GLAT(IL)).LE.70.) SEASN(IL)=5. 
       IF (ABS(GLAT(IL)).GT.70.)                       SEASN(IL)=4.
      END IF
      
      IF (IDAY.LE.31) THEN                            !Jan.
       IF (ABS(GLAT(IL)).LE.70.)                       SEASN(IL)=1. 
       IF (ABS(GLAT(IL)).GT.70. .AND. ABS(GLAT(IL)).LE.80.) SEASN(IL)=5.
       IF (ABS(GLAT(IL)).GT.80.)                       SEASN(IL)=4.  
      END IF
      
      IF (IDAY.GE.32.AND. IDAY.LE.59) THEN           !Feb   
       IF (ABS(GLAT(IL)).LE.45.)                       SEASN(IL)=1.
       IF (ABS(GLAT(IL)).GT.45. .AND. ABS(GLAT(IL)).LE.80.) SEASN(IL)=2.
       IF (ABS(GLAT(IL)).GT.80.)                       SEASN(IL)=4. 
      END IF
      
      IF (IDAY.GE.60.AND. IDAY.LE.90)  THEN            !Mar.
       IF (ABS(GLAT(IL)).LE.35.)                       SEASN(IL)=1.
       IF (ABS(GLAT(IL)).GT.35. .AND. ABS(GLAT(IL)).LE.65.) SEASN(IL)=2.
       IF (ABS(GLAT(IL)).GT.65. .AND. ABS(GLAT(IL)).LE.80.) SEASN(IL)=3.
         IF (ABS(GLAT(IL)).GT.80.)                       SEASN(IL)=4.
      END IF
      
      IF (IDAY.GE.91.AND. IDAY.LE.120) THEN           !Apr.
       IF (ABS(GLAT(IL)).LE.35.)                       SEASN(IL)=1.
       IF (ABS(GLAT(IL)).GT.35. .AND. ABS(GLAT(IL)).LE.45.) SEASN(IL)=2.
       IF (ABS(GLAT(IL)).GT.45. .AND. ABS(GLAT(IL)).LE.65.) SEASN(IL)=3.
         IF (ABS(GLAT(IL)).GT.65.)                       SEASN(IL)=4.
      END IF

      IF (IDAY.GE.121.AND. IDAY.LE.151) THEN           !May.
       IF (ABS(GLAT(IL)).LE.35.)                       SEASN(IL)=1.
       IF (ABS(GLAT(IL)).GT.35. .AND. ABS(GLAT(IL)).LE.40.) SEASN(IL)=2.
       IF (ABS(GLAT(IL)).GT.40. .AND. ABS(GLAT(IL)).LE.50.) SEASN(IL)=3.
         IF (ABS(GLAT(IL)).GT.50.)                       SEASN(IL)=4.
      END IF

      END IF

      IF(SEASN(IL).EQ.3.AND.PSNOW(IL).GT.0.1) SEASN(IL)=4.
      IF(SEASN(IL).EQ.4.AND.PSNOW(IL).LT.0.1) SEASN(IL)=3.

100   CONTINUE

C
C J for species, I for LUC, IL for grids.
C
      DO 900 J=1,NG0
        DO 800 I=1,LUC
          DO 700 IL=IL1,IL2
             RA(IL,I)=0.0999
             ISEA = INT(SEASN(IL))
C
C --- CONSIDER ONLY LAND USE CATEGORIES .GT. 0.005
C
             IF (F(IL,I).LT.0.005) GO TO 700
C --- SET MIN. VALUES
             U2 = AMAX1(U2I(IL),1.0)
             ZZ0(IL)=Z0(I,ISEA)
C
C --- PERCENTAGE OF GRID AREA OVER WATER [SPECIFIC!!, CHANGE WITH LANDUSE]
C
             FW = F(IL,11) + F(IL,13) + F(IL,14)
C
C --- PERCENTAGE OF GRID AREA OVER LAND
C
             PLAND = 1. - FW
C
             PCWC=0.
             IF (RH(IL).GE.0.9) PCWC=0.3
C
C --- CELL SNOW .LE. CELL W/LAND
C
             SNCOV = PSNOW(IL)
             IF (PSNOW(IL).GT.PLAND) SNCOV = PLAND
             ICECOV=PICE(IL)
C --- CELL ICE .LE. CELL W/WATER
             IF (PICE(IL).GT.FW) ICECOV= FW
C
C --- STOMATAL APERTURE AS FUNCTION OF SOLAR IRRADIANCE AND
C --- SOIL MOISTURE
C
             SMAX=SCON*COS((GLAT(IL)-23.45)*RAD)
             B = BMAX * SRAD(IL) * (1. - 0.8*FCLD(IL)) / SMAX + BMIN
             IW=0
             IF(I.EQ.11.OR.I.EQ.13.OR.I.EQ.14) IW=1
C
C --- DETERMINE ICE FRACTION OF WATER CATEGORIES
C --- (NOTE THAT ICECOVER DATA IS ASSUMED TO BE IN FRACTIONS OF ENTIRE
C --- GRID CELL AREA AND NOT FRACTION OF WATER SURFACE AREA.  CHECK
C --- DATA FOR COMPATIBILITY)
C --- FICE IS FRACTION OF CELL WATER WITH ICE
C --- FSNOW IS FRACTION OF CELL LAND THAT IS SNOW
C
             IF(I.EQ.11.OR.I.EQ.13.OR.I.EQ.14)THEN
               FICE=ICECOV/FW
               FSNOW=0.0
             ELSE
               FICE=0.
               FSNOW=SNCOV/PLAND
             ENDIF
C
C --- POTENTIAL TEMPERATURE AT Z2  (DEG. K)
C
             T2P = T2(IL) + Z2 * 0.0098
C***********************************************************************
C       FROM OCD MODEL: FOR CALCULATIONS OVER WATER
C COMPUTE VALUES OF CRITICAL PROFILE VARIABLES: L AND USTAR
C
C***********************************************************************
C**************************BEGIN FOR WATER******************************
             IF(I.EQ.13.OR.I.EQ.14)THEN
C
C ---    VAPOUR PRESSURE AT Z2
C
                E = RH(IL) * ES(T2(IL))
C ---    WATER VAPOUR MIXING RATIO AT  Z2
                Q = 0.622 * E/(PMB-E)
C ---    VIRTUAL POTENTIAL TEMPERATURE AT Z2 (DEG. K)
                T2PV = T2P * (1. + 0.61 * Q)
C
C --- ASSUME RH AT WATER SURFACE IS 100%
C ***    E = ES(TSW-273.15) !SAT. VAP PRESS AT SURFACE
C ---    SATURATED VAPOUR PRESSURE AT SURFACE
C
                TSW=TS(IL)
                E = ES(TSW)
C
C ---    SATURATED MIXING RATIO AT SURFACE
C
                QS = 0.622 * E / (PMB - E)
C ---    VIRTUAL POTENTIAL TEMPERATURE AT SURFACE (DEG. K)
                TSV = TSW * (1. + 0.61 * QS)
                Z0WATER = 1.0E-4
C ---    * SCALET  :  NOT REQUIRED IF  Z2 = 10M
                DTHV = (T2PV - TSV)
C
C --- CALCULATE DRAG COEFFICIENT CUN WITH NEUTRAL CONDITION ASSUMPTION
C ---       -- GARRATT (1977)
C
                CUN=7.5E-4+6.7E-5*U2
C
                EL=9999.
                IF(ABS(DTHV).GT.1.0E-6)EL=T2PV*CUN**1.5*U2**2/(5.096E
     1                                     -3*DTHV)
                IF(EL.GT.0..AND.EL.LT.5.0) EL = 5.0
                IF(EL.GT.-5.0.AND.EL.LT.0) EL =-5.0
                ZDL = Z2/EL
                IF(ZDL.LT.0.0) THEN
C --- WIND SPEED
                   X=(1.0 - 15.0*ZDL)**0.25
                   PSIU=2.*ALOG(0.5*(1.0+X))+ALOG(0.5*(1.0+X*X))-
     1                     2.0*ATAN(X) + 0.5*PI
C --- POT TEMP
                   Y=SQRT(1.-9.*ZDL)
                   PSIT=2.*0.74*ALOG((1+Y)/2.)
                ELSE
                   PSIU = -4.7*ZDL
                   PSIT = PSIU
                ENDIF
                Z0WATER = 0.000002 * U2**2.5
                USTAR = K*U2/(ALOG(Z2/Z0WATER) - PSIU)
                THSTAR = K*(T2P-TS(IL))/(0.74*ALOG(Z2/Z0WATER)-PSIT)
                ZZ0(IL)=Z0WATER
C
             ELSE
C
C --- COMPUTE USTAR AND L FOR LAND USE CATEGORIES OTHER THAN WATER.
C --- USE LOUIS METHOD. !PKK 7/16/85
C --- FIND BULK RICHARDSON NUMBER.
C
                RIB = G*Z2*(T2P - TS(IL))/(TS(IL)*U2**2)
C
C --- ENSURE THAT CONDITIONS OVER LAND ARE NEVER STABLE WHEN THERE IS
C     INCOMING SOLAR RADIATIOM
C
                IF (SRAD(IL).GT.0.0.AND.RIB.GT.0.0) RIB = 1.E-15
                DELTAT = T2P - TS(IL)
                IF(ABS(DELTAT).LT.1.E-10)DELTAT=SIGN(1.E-10,DELTAT)
                TBAR = 0.5*(T2P + TS(IL))
                RATIOZ = Z2/ZZ0(IL)
                LOGRATIO = ALOG(RATIOZ)
                ASQ = 0.16/(LOGRATIO**2)
                IF(RIB.LE.0.)THEN
                   AA = ASQ*9.4*SQRT(RATIOZ)
                   CM = 7.4*AA
                   CH = 5.3*AA
                   FM = 1. - (9.4*RIB/(1. + CM*SQRT(ABS(RIB))))
                   FH = 1. - (9.4*RIB/(1. + CH*SQRT(ABS(RIB))))
                ELSE
                   FM = 1./((1. + 4.7*RIB)**2)
                   FH = FM
                ENDIF
                USTARSQ = ASQ*U2**2*FM
                UTSTAR = ASQ*U2*DELTAT*FH/0.74
                USTAR = SQRT(USTARSQ)
                THSTAR = UTSTAR/USTAR
                EL = TBAR*USTARSQ/(0.4*9.8*THSTAR)
C ***
             ENDIF
             KUI=1./(K*USTAR)
             USI(IL,I)=USTAR
C
C---------------COMPUTE RA---------------
             Z=Z2
             ZL=Z/EL
             IF(ZL.GE.0.) THEN
                RA(IL,I)=KUI*(.74*ALOG(Z/ZZ0(IL))+4.7*ZL)
             ELSE
                RA(IL,I)=KUI*.74*(ALOG(Z/ZZ0(IL))-
     1                         2*ALOG((1+SQRT(1-9.*ZL))*0.5))
             ENDIF
                RA(IL,I)=AMAX1(RA(IL,I),0.99)
                RA(IL,I)=AMIN1(RA(IL,I),999.9)

C----------------COMPUTE RD AND RC--------------
C
C --- RD FOR GASES
C
             RD=5./USI(IL,I)*SC(J)**.666667
C
C --- RC FOR GASES
C
C --- FOR VEGETATION
C
             D=VI/SC(J)
C
C --- STOMATAL PORE RESISTANCE
C
             RP=P/(B*D)
C
C --- MESOPHYLL RESISTANCE
C
             RM=RM0(J)
C
C --- TOTAL STOMATAL RESISTANCE
C
             RST=RP+RM
C
C --- CUTICLE RESISTANCE
C
             RCUT=A0/AC(J)*RCUT0
      IF((ISEA.LE.2.OR.ISEA.EQ.5).AND.(J.EQ.1.OR.J.EQ.3))
     1           RCUT = 3000. * A0 / AC(J)
C
C --- FOLIAGE RESISTANCE INCLUDING THE EFFECT OF WETTED LEAVES
C
       RCF=1./(1./RST+(1.-PCWC)/RCUT+PCWC/RCW(J)/(LAI(I,ISEA)+0.01))
C
C --- GROUND RESISTANCE (SOIL OR SNOW)
C
             RCG=A0/AC(J)*RCG0
             IF (J.EQ.1.OR.J.EQ.3) THEN
                RCG = 800.
              IF (ISEA.NE.4.OR.ISEA.NE.3)
     &             RCG = 1000.* A0 / AC(J)
             ENDIF
             RSN=A0/AC(J)*RSN0
             IF (J.EQ.1.OR.J.EQ.3) THEN
                 IF (ISEA.EQ.4.OR.ISEA.EQ.3) RSN = 1000.
             ENDIF

C
C --- TOTAL CANOPY RESISTANCE INCLUDING RESISTANCE TO WATER SUFACES,
C ---  FOLIAGE, BARE GROUND, AND SNOW OR ICE
C
             IF ((ISEA.EQ.3.OR.ISEA.EQ.4).AND.(J.EQ.1.OR.J.EQ.3)) THEN

C ---   RC=1./(FSNOW/RSN+(1.-FSNOW)/RCG+(TS+20.-273.)/(100.*(1.+PCWC)))
C
                 TSCENT = TS(IL) - 273.16
                 TSCENT = AMAX1(-15.,TSCENT)
                 TSCENT = AMIN1(20.,TSCENT)
                 RC=1./(FSNOW/RSN+(1.-FSNOW)/RCG+(TSCENT+20.)/
     1                                             (10000.*(1.+PCWC)))
             ELSE
                 RC=1./(LAI(I,ISEA)/RCF+IW*(1.-FICE)/RGW(J)+
     1                  (1-IW)*(1.-FSNOW)/RCG+((1-IW)*FSNOW+FICE)/RSN)
             ENDIF
C--------------------COMPUTE VD FOR GASES------------------
C --- AVERAGE DEPOSITION VELOCITIES OVER LAND USE CATEGORIES.
C
             VDF = 1./(RA(IL,I)+RD+RC)
             VDG(IL,J) = VDG(IL,J) + VDF*F(IL,I)
C --- END OF GRID LOOP
700        CONTINUE
C --- END OF LAND USE CATEGORY LOOP
800     CONTINUE
C --- END OF GAS SPECIES LOOP
900   CONTINUE
      RETURN                                                             
      END
