      SUBROUTINE COAGD (     ILG,    IL1,    IL2,     ILEV,  THROW, 
     2                     ISIZE, ROAROW,  RTCOA,   RHSIZE, TOTMAS,
     3                   AERONUM,    NTR,    NTP,        F,   IAE1,
     4                     DBSUM,  SGSUM,BINLOSS,   AEROP1,  KOUNT,
     5                      BETA,   ADT2,  ICOAG,    IREST,   XROW,
     6                         V,    VKP,   JLAT,     ICOB,   TMIN,
     7                     PDEPV,  PDIFF, CBAR12,       GX,    MAE, 
     8                       IGF,  IGFIJ,   RHOP, AEROSIZE,  RHOPD)

C-----------------------------------------------------------------------------
C     * MAY 12/00   S.L. GONG INTRDUCTION OF IGF AND IGFIJ TO SPPED
C     *                       UP THE CODE. THE PERCENTAGE OF COAGULATION
C     *                       IN GCMIII WEND DOWN FROM 17% TO 1% OF
C     *                       TOTAL CPU TIME.
C     * NOV 06/98   S.L. GONG ADAPT THE JACOBSON'S SCHEME TO
C     *                       CONSERVE VOLUME [MASS] OF EACH SPECIES
C     *                       AFTER COAGULATION.
C     *                       [JACOBSON ET.AL. ATM. ENV. 1994]
C     *
C     * OCT 01/97   S.L. GONG MODIFIED FOR MULTI-COMPONENT AEROSOLS.
C     *
C     *
C     * SEP 23/97 - S.L. GONG RECODE THE COAGULATION MODULE EXCEPT
C     *             E. GIRARD ADAPTING COAGULATION COEFFICIENTS FUNTION
C     *                       BETA FROM PREVIOUS CODE. FEATURING: 
C     *                         
C     *                       A. A UNIQUE DO LOOP TO HANDEL ALL THE
C     *                          COAGULATION PROCESSES AMONG SIZE BINS
C     *                          AND ELLIMINATE THE DUPLICATION OF    
C     *                          COMPUTING BOTH K(1,2) AND K(2,1) WHICH ARE
C     *                          EQUAL.  
C     *                       B. VECTORIZATION OF THE CODE FOR BEST 
C     *                          EFFICIENCY. 
C     *                       C. THE COEFFICIENTS ARE CALCULATED BASED ON
C     *                          THE REAL SIZE AND DENSITY OF PARTICLES. 
C     *                       D. SIMPLIFY THE INTEGRATION PROCEDURE TO
C     *                          BE RUN FOR A 3-D CLIMATE MODEL.
C     *                       E. TENDENCY CALCULATION IS BASED ON THE 
C     *                          ORIGINAL DYNAMICAL COAGULATION EQUATIONS
C     *                          WHERE PARTICLE NUMBER CONCENTRATIONS ARE
C     *                          PROGNOSTIC VARIABLES.
C     *                       F. PHYSICAL PROPERTIES SUCH AS MEAN FREE 
C     *                          PATH, VISCOSITY AND SETLLING VELOCITY ARE
C     *                          COMPUTED IN A CONSISTANT WAY AS IN OTHER
C     *                          AEROSOL ROUTINES.
C     *                       G. COAGC CAN NOW RUN EVERY TIME STEP FOR
C     *                          MUCH SMALLER OVERHEAD.
C     *                                                
C     * MAR 01/95 - E.GIRARD. PREVIOUS VERSION BASED ON GELBARD ET AL [1980]  
C     *
C     *                          SCHEME OF COAGULATION FROM GELBARD ET AL. 
C     *                          WITH PRE-CALCULATED COEFFICIENTS
C     *                          OF COAGULATION WAS USED.
C     *
C     *                          BROWNIAN, TURBULENT AND GRAVITATIONAL 
C     *                          COAGULATION ARE COMPUTED IN THIS MODULE.  
C-----------------------------------------------------------------------------
      IMPLICIT NONE
      INTEGER ILG ,ILEV,NTR, ISIZE, MAE,IREST,JLAT,KOUNT, N
      INTEGER ICOB,L,IL, IL1, IL2,I,J, K, NN, NTP ,IJ
      INTEGER IK, IAE1, IP, ICOAG ,NT,NO

      REAL DX, V1,DL3,GX0,DIFFX, DIFFY, DSUM,CBAR, GMEAN,AMU
      REAL STICK, XIAO, ADT2,OLDNUM,RTLOSS,CPRESV,RGASV,TURB1  
      REAL CPRES, RGOASQ, RGOCP, RGAS, G, ASQ, RAYON,TW,WW   
      REAL AVNO,    RGASi,     AM,   BOLTZK,  PI,  A,TURBDS

      REAL L1,TMIN, RWI
      COMMON /PARAMS/ WW,TW,RAYON,ASQ,G,RGAS,RGOCP,RGOASQ,CPRES
      COMMON /PARAMS/ RGASV,CPRESV
      COMMON /NARCM/    AVNO,    RGASi,     AM,   BOLTZK,  PI,  A

      REAL THROW(ILG,ILEV+1),ROAROW(ILG,ILEV),AEROSIZE (2,ISIZE)
      REAL RTCOA(ILG,ILEV,NTR),RHSIZE(ILG,ILEV,ISIZE)
      REAL V(ISIZE), BINLOSS(ILG,ILEV,ISIZE),RHOP(ILG,ILEV,ISIZE)
      REAL VKP(ILG,ILEV), BETA (ILG,ILEV,ISIZE,ISIZE)
      REAL F(ISIZE,ISIZE,ISIZE), SGSUM(ILG,ILEV), DBSUM(ILG,ILEV)
      REAL TOTMAS(ILG,ILEV,ISIZE), AERONUM(ILG,ILEV,ISIZE)
      REAL RHOPD(ILG,ILEV,ISIZE)
      REAL AEROP1(ILG,ILEV,ISIZE), XROW(ILG,ILEV+1,NTR)
      REAL PDIFF(ILG,ILEV,ISIZE),PDEPV(ILG,ILEV,ISIZE)
      REAL CBAR12(ILG,ILEV,ISIZE),GX(ILG,ILEV,ISIZE)

      INTEGER IGF(ISIZE), IGFIJ(ISIZE,ISIZE*ISIZE,2)

      DATA STICK/1.0/, TURBDS/0.002/
      DATA XIAO /1.E6/
C
C     NON START-RUN BEGINS 
C
      CALL PUTZERO(RTCOA,ILG*ILEV*NTR)      
      CALL PUTZERO(TOTMAS, ILG*ILEV*ISIZE)
C
C     UPDATE THE CURRENT AEROSOL NUMBER
C
      DO NT=1,NTP
         DO N=1,ISIZE
            NO= N+ISIZE*(NT-1)+(IAE1-1)
            DO L=1+MAE,ILEV
              DO I=IL1,IL2
                 TOTMAS(I,L,N)=TOTMAS(I,L,N)+XROW(I,L+1,NO)
              END DO
            END DO
         END DO
      END DO

      DO N=1,ISIZE
         RWI=(AEROSIZE(1,N)+AEROSIZE(2,N))/2.0
         DO L=1+MAE,ILEV
           DO I=IL1,IL2
              AERONUM(I,L,N)=TOTMAS(I,L,N)/(4.189*
     1                                   RWI*RWI*RWI*RHOPD(I,L,N))
           END DO
         END DO
      END DO
    

      IF (MOD(KOUNT,ICOAG) .EQ. 0 .OR. IREST .EQ. 1) THEN        !END IF 888

      IF (JLAT .EQ. 1) WRITE (*,555) KOUNT

      CALL PUTZERO(BETA,ILG*ILEV*ISIZE*ISIZE)
      DO N=1,ICOB
         RWI=(AEROSIZE(1,N)+AEROSIZE(2,N))/2.0
         DO L=1+MAE,ILEV
            DO IL=IL1,IL2
              DX=2.*RHSIZE(IL,L,N)
              V1=4.189*RWI*RWI*RWI*RHOP(IL,L,N)
              CBAR12(IL,L,N)=3.51568E-23*THROW(IL,L+1)/V1
              L1=2.5465*PDIFF(IL,L,N)/SQRT(CBAR12(IL,L,N))
              DL3=(DX+L1)*(DX+L1)*(DX+L1)
              GX0=(DL3-(DX*DX+L1*L1)**1.5)/(3.*DX*L1)-DX
              GX(IL,L,N)=GX0*GX0
            END DO
         END DO
      END DO 

      DO I=1,ICOB
        DO J=I,ICOB
          DO L=1+MAE,ILEV
            DO IL=IL1,IL2
C
C     * DIFFUSION COEFFICIENTS
C
              DIFFX=PDIFF(IL,L,I)
              DIFFY=PDIFF(IL,L,J)
C
C     * AIR'S DYNAMIC VISCOSITY
C
              AMU=145.8*1.E-8*THROW(IL,L+1)**1.5/
     1                             (THROW(IL,L+1)+110.4)              
              DSUM=2.*(RHSIZE(IL,L,I)+RHSIZE(IL,L,J))
C
C       BROWNIAN COAGULATION COEFFICIENT        [V1, V2, VR - PARTICLE MASS, KG] 
C
              CBAR =SQRT(CBAR12(IL,L,I)+CBAR12(IL,L,J))
              GMEAN=SQRT(GX(IL,L,I)+GX(IL,L,J))

              BETA(IL,L,I,J)=6.2832*(DIFFX+DIFFY)*DSUM/(DSUM/(DSUM
     1                        +2.*GMEAN)+8.*(DIFFX+DIFFY)/
     2                                  (CBAR*DSUM*STICK))
C
C       ADD GRAVITATIONAL COAGULATION
C
              BETA(IL,L,I,J)=BETA(IL,L,I,J)+0.7854*DSUM**2
     1                                 *ABS(PDEPV(IL,L,I)-PDEPV(IL,L,J))
              BETA(IL,L,J,I)=BETA(IL,L,I,J)

            END DO
          END DO
        END DO
      END DO
 888  END IF

      CALL PUTZERO(AEROP1,ILG*ILEV*ISIZE)
      DO K=1,ICOB
        CALL PUTZERO(DBSUM,ILG*ILEV)
        CALL PUTZERO(SGSUM,ILG*ILEV)
        CALL PUTZERO(BINLOSS,ILG*ILEV*ISIZE)

        DO J=1,ICOB
          DO L=1+MAE,ILEV
            DO IL=IL1,IL2
C
C       NUMBER LOSS OF K DUE TO COLLISION WITH J [1-ISIZE]
C              
                 OLDNUM=AERONUM(IL,L,J)*ROAROW(IL,L)
                 IF (OLDNUM .GT. XIAO) THEN
                    BINLOSS(IL,L,J)=(1.-F(K,J,K))*BETA(IL,L,K,J)*OLDNUM
                    SGSUM(IL,L)=SGSUM(IL,L)+BINLOSS(IL,L,J)
                 END IF
            END DO
          END DO
        END DO

        DO IJ=1,IGF(K)     !GETHERED POINTS FOR COAGFR
           I= IGFIJ(K,IJ,1)
           J= IGFIJ(K,IJ,2)
           DO L=1+MAE,ILEV
              DO IL=IL1,IL2
C
C       VOLUME GAIN OF K DUE TO COLLISION OF I AND J [=<K]-- [M3 S-1]
C
                  DBSUM(IL,L)=DBSUM(IL,L)+F(I,J,K)*BETA(IL,L,I,J)*V(I)
     1               *AEROP1(IL,L,I)*AERONUM(IL,L,J)*ROAROW(IL,L)
              END DO
          END DO
        END DO
C
C      TOTAL NUMBER OF K AFTER COAGULATION [# M-3]
C
        DO L=1+MAE,ILEV
          DO IL=IL1,IL2
            AEROP1(IL,L,K)=(ROAROW(IL,L)*AERONUM(IL,L,K)+ADT2/V(K)
     1                           *DBSUM(IL,L))/(1.+ADT2*SGSUM(IL,L))
          END DO
        END DO
C
C     MASS BALANCE FOR EACH SPECIES OF K
C       LOSS OF K IS THE SUM OF MASS GAINED BY ALL J
C       SGSUM  - DIMESIONLESS
C       AEROP1 - # M-3
C
        DO NN=1,NTP
           IK=(NN-1)*ISIZE+K+(IAE1-1)
           CALL PUTZERO(VKP, ILG*ILEV)
           DO L=1+MAE,ILEV
             DO IL=IL1,IL2
C
C        LOST TENDENCY OF K
C        AEROP1(IL,L,K) * SGSUM(IL,L) * V(K) IS THE VOLUME LOSS RATE OF
C        BIN K DUE TO THE COAGULATION. BY /(OLDNUM*V(K)) *XROW(IL,L+1,IK)
C        THE LOSS TENDENCY OF IK IS OBTAINED.
C         
C
                 OLDNUM=AERONUM(IL,L,K)*ROAROW(IL,L)
                 IF (OLDNUM .GT. XIAO) THEN
                    VKP(IL,L)=AEROP1(IL,L,K)/OLDNUM*XROW(IL,L+1,IK)
                    RTCOA(IL,L,IK)=RTCOA(IL,L,IK)-VKP(IL,L)*SGSUM(IL,L)
                 END IF
             END DO
           END DO
C
C        GAIN TENDENCY OF I DUE TO LOSS OF [K,J]
C
           DO J=1,ICOB
             DO I=MAX(J,K),ICOB
               IF (F(K,J,I) .GT. 0.) THEN
                 IP=(NN-1)*ISIZE+I+(IAE1-1)
                 DO L=1+MAE,ILEV   
                    DO IL=IL1,IL2
                       RTLOSS=VKP(IL,L)*BINLOSS(IL,L,J)*F(K,J,I)
                       RTCOA(IL,L,IP)=RTCOA(IL,L,IP)+RTLOSS 
                    END DO
                 END DO
               END IF
             END DO
           END DO
        END DO                                           !END OF NN LOOP
      END DO                                             !END OF K  LOOP
C
C      UPDATE TRACER DUE TO COAGULATIONS
C
      DO K=1,ISIZE                   !THE TENDENCY FOR K=ISIZE IS ADDED
                                     !DRY DEPOSITION
        DO NN=1,NTP
           IK=(NN-1)*ISIZE+K+(IAE1-1)
           DO L=1+MAE,ILEV
              DO IL=IL1,IL2
                 XROW(IL,L+1,IK)=AMAX1(TMIN,
     1                            XROW(IL,L+1,IK)+RTCOA(IL,L,IK)*ADT2)
c            print*,'in coagd',xrow(il,l+1,ik),il,l,ik
              END DO
           END DO
        END DO
      END DO


 555  FORMAT (' COAGD -> BETA COMPUTED @ ',I5)

      RETURN
      END
