      SUBROUTINE CAS (  T,    COLEF,    RHOP,  ROAROW,                  !
     1             RHSIZE,   PRESSG,      QR,     MAE,                         !
     2                ILG,     ILEV,     LEV,   ISIZE,
     3                IL1,     IL2,      VPR,   PDIFF,
     4              PDEPV,      SHJ,     RRM,   ALPHA)                  !
C-----------------------------------------------------------------------------
C     PURPOSE:
C     --------
C     THIS IS A MODULE OF CALCULATING THE COLLECTION EFFICIENCY OF
C     THE AEROSOLS OF TYPE N BY COLLECTOR DROPLETS OF RADIUS RCOL.
C
C     HISTORY:
C     --------
C     *
C     * DEC 19/96 - S.L. GONG   VECTORIZED THE WHOLE PROGRAM AND ADD SOME
C     *                         WORKING SPACES.
C     *
C     * JUL  8/94 - S.L. GONG   FIRST VERSION
C
C     METHOD:
C     -------
C-----------------------------------------------------------------------------

      COMMON /PARAMS/ WW,TW,RAYON,ASQ,G,RGAS,RGOCP,RGOASQ,CPRES         !
      COMMON /PARAMS/ RGASV,CPRESV                                      !
      COMMON /NARCM /   AVNO,    RGASi,     AM,   BOLTZK,  PI,  A       !
      COMMON /NARCM/ A0,RSN0,RCUT0,RCG0,PNON
      COMMON /HTCP  / T1S,T2S,AI,BI,AW,BW,SLP                           !
      REAL T(ILG,LEV), RHOP(ILG,ILEV,ISIZE), ROAROW(ILG,ILEV)
      REAL QR(ILG,ILEV), VPR(ILG)                                                 !
      REAL RHSIZE(ILG,ILEV,ISIZE)
      REAL COLEF(ILG,ILEV,ISIZE), PRESSG(ILG)
      REAL PDEPV(ILG,ILEV,ISIZE), SHJ(ILG,ILEV)
      REAL PDIFF(ILG,ILEV,ISIZE)                                        !
C
C     VECTORIZATION SPACES
C
      REAL RRM(ILG), ALPHA(ILG)                                         !
      DATA RHORAIN/1000.0/                                              !
      DATA  AA1/1.249/, AA2/0.42/, AA3/0.87/                            !
      AMUW = 1.002E-3                    !at 20 C [kg /m/sec]           !
      DO N=1,ISIZE
        DO L=1+MAE,ILEV                                                       !
          DO I=IL1,IL2                                                    !
C
C     * IN CASE OF PRECIPITATION
C
            VPR(I)=0.0
            IF (QR(I,L) .GT. 1.E-15) THEN                                    !
               TL=T(I,L+1)                                                !
               R=RHSIZE(I,L,N)                                          !   
C
C     * AIR'S DYNAMIC VISCOSITY
C
               AMU=145.8*1.E-8*TL**1.5/(TL+110.4)                         !
C
C     * MEAN MOLECULAR FREE PATH.
C       K.V. BEARD [1976], J ATM. SCI., 33
C
               AMFP=6.54E-8*(AMU/1.818E-5)*(1.013E5/(PRESSG(I)            !
     1              *SHJ(I,L)))*(TL/293.15)**(1./2.)                    !
C
C     * STOKES FRICTION AND DIFFUSION COEFFICIENTS.
C
               SCHM=AMU/PDIFF(I,L,N)/ROAROW(I,L)                                  !  !
C
C       COLLECTOR DROP SIZE
C
               IF (TL .GT. 273.15) THEN                                   !
C
C     * FOR RAIN
C
C     * MASS MEAN RAINDROP RADIUS RRM
C     * FACTOR 1.E-3 CONVERTS MM INTO M.
C
                 RRM(I)=0.35*(QR(I,L)*3600.)**0.25*1.E-3                !
                 PRII=2./9.*G/AMU                                       !
                 PRIIV=PRII*(RHORAIN-ROAROW(I,L))                       !
C
C     * CUNNINGHAM SLIP CORRECTION FACTOR
C       SETTLING VELOCITY
C
                 CFAC=1.+AMFP/RRM(I)*(AA1+AA2*EXP(-AA3*RRM(I)/AMFP))    !
                 VPR(I)=PRIIV*RRM(I)**2*CFAC                            !
               END IF                                                     !
               IF (TL.LE.T1S.AND.TL.GE.T1S-8.) THEN                       !
C
C     * NEEDLE SNOW SCAVENGING
C       DATA FROM SLINN(1984) IN ATMOSPHEIC SCIENCE AND POWER
C       PRODUCTION, ED. DARRYL RANDERSON.
C
C       FOR SNOW SCAVENGING, THE DNESITY OF SNOW IS SET AS
C       1/10 OF LIQUID WATER. THE FACTOR 1.0E-2 IN THE WETDEP
C       CALCULATION TAKES THIS INTO ACCOUNT PLUS THE UNIT CHANGE
C       INTO M S-1
C
                  VPR(I) = 50.0E-2               !AVERAGE SETTLING VELOCIT!Y [
                  RRM(I) = 10.E-6                !CHARACTERISTIC CAPTURE L!EHG
                  ALPHA(I) = 1.0                                          !
               END IF                                                     !
               IF (TL.LT.T1S-8..AND.TL.GE.T1S-25.) THEN                   !
C
C     * STELLER SNOW SCAVENGING
C
                  VPR(I) = 57.0E-2                                  !
                  RRM(I) = 100.E-6                                        !
                  ALPHA(I) = 0.5                                          !
               END IF                                                     !
               IF (TL .LT. T1S-25.) THEN                                  !
C
C     * GRAUPEL SCAVENGING
C
                 VPR(I) = 180.0E-2                                 !
                 RRM(I) = 1000.E-6                                       !
                 ALPHA(I) = 2./3.                                        !
               ENDIF                                                      !
C
C     * REYNOLD NUMBER
C
               RE=RRM(I)*VPR(I)*ROAROW(I,L)/AMU                   !
C
C     * STOKES NUMBER OF COLLECTED PARTICELS
C
               ST=2.*PDEPV(I,L,N)/G*(VPR(I) - PDEPV(I,L,N))
     1                                              /(2.*RRM(I))          !
C
C     * RATIO OF RADIUS OF COLLECTED PARTICEL AND COLLECTOR DROP
C
               RR = R/RRM(I)                                              !
               VR = AMUW/AMU                                              !
               SSTAR = (1.2+(1./12.)*LOG(1.+RE))/(1.+LOG(1.+RE))          !
               IF (ST .GT. SSTAR )                           THEN         !
                  COLIMP = ((ST-SSTAR)/(ST-SSTAR+2./3.))**(3./2.)         !
     1                   *SQRT(1000.0/RHOP(I,L,N))                              !
               ELSE                                                       !
                  COLIMP = 0.0                                            !
               END IF                                                     !
               IF (TL .GT. 273.15) THEN                                   !
C
C     * RAIN SCAVENGING EFFICIENCY
C
                 COLEF(I,L,N) = 4./(RE*SCHM)*(1.+0.4*SQRT(RE)*SCHM**
     1                      (1./3.)+0.16*SQRT(RE*SCHM)) + 4.*RR*(1./VR
     2                         + (1.+2.*SQRT(RE))*RR) + COLIMP             !
               ELSE                                                       !
C
C     * SNOW SCAVENGING EFFICIENCY
C
                 COLEF(I,L,N) = (1./SCHM)**ALPHA(I) +
     1                    (1.0-EXP(-(1+SQRT(RE))*RR**2)) + COLIMP       !
               ENDIF                                                      !
C
C     * SET THE UPBOUND FOR COLLECTION EFFICIENCY
C
               COLEF(I,L,N) = AMAX1(0.0,AMIN1(1.00,COLEF(I,L,N)))
            END IF                                                        !
          END DO                                                          !
        END DO
      END DO                                                            !
      RETURN                                                            !
      END                                                               !
