      SUBROUTINE BLCLD (   T,      QR,  RHSIZE,   COLEF, RCOEX,  RCRIT,
     +                 PDEPV,  PRESSG,     SHJ,  ROAROW,WETDEP,  PDIFF,
     1                  XROW,  RTBCLD,    RHOP,  RADCLD, CLDCV,    MAE,
     2                   NTR,     NTP,   ISIZE,     LEV,  IAE1,   TMIN,
     3                  ILEV,     ILG,     IL1,     IL2,  ADT2,  tcld3)
C-----------------------------------------------------------------------------
C     PURPOSE:
C     --------
C     BELOW CLOUD SCAVENGING CALCULATION BY RAIN AND SNOW
C
C     HISTORY:
C     --------
C     *
C     * DEC 19/96 - S.L. GONG   VECTORIZED THE WHOLE PROGRAM AND ADD SOME
C     *                         WORKING SPACES.
C     *
C     * JUL  8/94 - S.L. GONG   FIRST VERSION
C
C     METHOD:
C     -------
C     BY SLINN (1977) - WATER, AIR, AND SOIL POLLUTION 7(1977)
C------------------------------------------------------------------------------
      IMPLICIT NONE

      INTEGER ILG ,ILEV,NTR, ISIZE, LEV, MAE
      INTEGER L,IL1, IL2,I,NTP,N,NN,NP,IAE1

      REAL CPRES, RGOASQ, RGOCP, RGAS, G, ASQ, RAYON,TW,WW   
      REAL AVNO,    RGASi,     AM,   BOLTZK,  PI,  A, TL
      REAL T1S,T2S,AI,BI,AW,BW,SLP
      REAL RRM, BCRAIN,BCSNOW,XOLD,XNEW,ADT2,RGASV,CPRESV
      REAL TMIN,DM,TEND 

      REAL QR(ILG,ILEV,NTR),XROW(ILG,LEV,NTR)
      REAL T(ILG,LEV), RADCLD(ILG,ILEV)
      REAL PRESSG(ILG), SHJ(ILG, ILEV), ROAROW(ILG,ILEV)
      REAL PDEPV(ILG,ILEV,ISIZE), PDIFF(ILG,ILEV,ISIZE)
      REAL RTBCLD(ILG,ILEV,NTR)
      REAL RHSIZE(ILG,ILEV,ISIZE),RHOP(ILG,ILEV,ISIZE)
      REAL CLDCV(ILG,ILEV,2)
      REAL COLEF(ILG, ILEV, ISIZE), WETDEP(ILG,ILEV,ISIZE)
      REAL RCRIT(ILG,ILEV), RCOEX(ILG,ILEV)
      REAL tcld3(ILG,ILEV)

      COMMON /PARAMS/ WW,TW,RAYON,ASQ,G,RGAS,RGOCP,RGOASQ,CPRES
      COMMON /PARAMS/ RGASV,CPRESV
      COMMON /NARCM/    AVNO,    RGASi,     AM,   BOLTZK,  PI,  A
      COMMON /HTCP  / T1S,T2S,AI,BI,AW,BW,SLP

      DATA BCRAIN/0.5/, BCSNOW/0.8/
C
C  *********** BELOW CLOUD SCAVENGING *************
C
C     * CALL TO COMPUTE COLLECTION EFFICIENTCY COEFFICIENTS
C
      CALL CAS (  T,    COLEF,    RHOP,  ROAROW,
     1       RHSIZE,   PRESSG,  QR(1,1,1),  MAE,
     2          ILG,     ILEV,     LEV,   ISIZE,
     3          IL1,     IL2, QR(1,1,2), PDIFF,
     4        PDEPV,      SHJ,  WETDEP, QR(1,1,3))
      CALL PUTZERO(WETDEP,ILG*ILEV*ISIZE)
      DO N = 1, ISIZE
         DO L=1+MAE,ILEV
            DO I=IL1,IL2
               IF (QR(I,L,1) .GT. 1.E-20)                  THEN
                  TL = T(I,L+1)-T1S
                  IF(TL .GT. 0.) THEN
C
C     * RAIN SCAVENGING RATE
C     THE UNIT OF QR IS MM S-1
C     THE 1.0E-3 CONVERTS IT INTO M S-1
C
                    RRM=0.35*(QR(I,L,1)*3600.)**0.25*1.E-3
                    WETDEP(I,L,N)=BCRAIN*QR(I,L,1)*1.0E-3
     1                                             *COLEF(I,L,N)/RRM
                  END IF
                  IF (TL.LE.0.0.AND.TL.GE.-8.) THEN
C
C     FOR SNOW SCAVENGING, THE DNESITY OF SNOW IS SET AS
C       1/10 OF LIQUID WATER. THE FACTOR 1.0E-2 IN THE WETDEP
C     CALCULATION TAKES THIS INTO ACCOUNT PLUS THE UNIT CHANGE
C     INTO M S-1
C
                    DM = 3.8E-5                 !CHARACTERISTIC LEHGTH! SCALE [M]
                    WETDEP(I,L,N) = BCSNOW*QR(I,L,1)*1.0E-3
     1                                              *COLEF(I,L,N)/DM
                  END IF
                  IF (TL .LT. -8. .AND. TL .GE. -25.) THEN
C
C     * STELLER SNOW SCAVENGING
C
                    DM = 2.7E-5                                       !
                    WETDEP(I,L,N)=BCSNOW*QR(I,L,1)*1.0E-3
     1                                              *COLEF(I,L,N)/DM
                  END IF
                  IF (TL .LT. -25.) THEN
C
C     * GRAUPEL SCAVENGING
C
                    DM = 1.4E-4
                    WETDEP(I,L,N) = BCSNOW*QR(I,L,1)*1.0E-3
     1                                               *COLEF(I,L,N)/DM
                  ENDIF
               END IF
            END DO
         END DO
      END DO
C
C     * ADD THE BELOW-CLOUD SCAVENGING TEDENCY
C
      DO NN=1,NTP
        DO N = 1,ISIZE
          NP=ISIZE*(NN-1)+N+(IAE1-1)
          DO  L = ILEV, 1+MAE, -1
            DO I = IL1, IL2
                 XOLD = XROW(I,L+1,NP)
                 XNEW = XOLD*EXP(-ADT2*WETDEP(I,L,N))
!                TEND=AMIN1((XNEW-XOLD)/ADT2, 0.0)*CLDCV(I,L,1)
                 TEND=AMIN1((XNEW-XOLD)/ADT2, 0.0)   !*tcld3(I,L)    !FOR GEM-CAM
                 XROW(I,L+1,NP)=AMAX1(XROW(I,L+1,NP)+TEND*ADT2,
     1                                 TMIN)
                 RTBCLD(I,L,NP) = RTBCLD(I,L,NP)+TEND
     1                                    
            END DO
          END DO
        END DO
      END DO

      RETURN
      END
