      SUBROUTINE SULFATE (   LEV,     ILEV,      ILG,      IL1,    IL2,  
     1                      IH2S,     IDMS,     ISO2,     ISO4,  RGRID,    
     2                   AERONUM,     XROW,      NTR,    ICOMP, ROAROW,
     3                    PRESSG,        T,       RH,      SHJ,  TOTNU,
     4                     OHROW,   NO3ROW,       NN,    KOUNT,  TOTCD,
     5                    RHSIZE, AEROSIZE,  TCSZROW,   CSZROW,   JLAT,
     6                     ISIZE,     DELT,   RTNUCL,    RHOP0,    LON,
     7                    RTCOND,    RTSO2,    RTDMS,    RTH2S, TOTCDN,
     8                     CLDCV,   ACOEFC,   TOTMAS,      RTH,   IAE1,
     9                      PVOL,     TMIN,    PCOND,      CAM,    MAE,
     A                    CONDNU)                                        !SLG
C------------------------------------------------------------------------------
C     PURPOSE: 
C     --------
C     SULFATE AEROSOL FORMATION ROUTINE
C       (1) CALCULATE OH CONCENTRATION
C       (2) OXIDATION OF SO2 BY OH
C       (3) NUCLEATION, I.E. GENERATION OF NEW SULPHATE AEROSOLS
C
C     HISTORY:                                                                  
C     -------- 
C
C     * NOV 03/01 - S.L. GONG  THE MASS BALANCE OF SULPHUR WAS DONE TO
C     *                        RE-DISTRIBUTE THE NUCELATION AND CONDENSATION
C     *                        TENDENCIES. SO2 CONCENTRATION AND PRODUCTION
C     *                        RATES ARE NOW COMPUTED EVERY SUB TIME STEP.
C     *
C     * MAY 09/00 - S.L. GONG  COMBINE H2SO4 PRODUCTION, CONDENSATION
C     *                        AND NUCLEATION INTO AN APPROXIMATE
C     *                        SOLUTION WITH A NEW STATEMENT FUNCTION. 
C     *                                                            
C     * DEC 15/98 - S.L. GONG  NEW NUCLEATION SCHEME OF KULMALA [1998]
C     *         K, VON SALZEN  WAS INTRODUCED INTO THE COMBINED ANALYTICAL
C     *                        EQUATION.
C     *
C     * June 4/98 - S.L. GONG  COMBINE NUCLEATION AND CONDENSATION RATES
C     *                        INTO ONE DIFFERENTIAL EQUATION AND
C     *                        SOLVED ANALYTICALLY.
C     *                                                                            
C     * MAY 26/97 - S.L. GONG  VECTORIZATION AND ADD CHEMISTRY           
C     *                        CHEMICAL FIELDS OF OH, H2O2, O3 AND 
C     *                        NO3 FROM NCAR IMAGES MODEL ARE USED [DAILY
C     *                        AVERAGED]
C     *
C     * AUG 14/96 - S.L. GONG  FIRST VERSION
C
C     SUBROUTINE CALLED FROM CAM_V01
C  -----------------------------------------------------------------
      implicit none
      real y4pid3,so4mw,akb,ara,omega,expp,so4,adv
      real apard,apare,aconcr,apaarc,adelta,apara,aparb
      real aexp,frp,fn,an,dfso4,atuner,avesize,tclr
      integer n,inew,i
      real rk1,qoh,rkinf,rocon,rk,rk3,rh01,atempe,anw
      real so2pro,qno3,rto,rk4,so4t12,so4t13,so4t14,so4t11
      real so4t8,so4t9,so4t10,so4t15,totpar,a,w
      integer l,mae,iae1,isize,lon
      real dich,zc,adt2,cub,rk2,aparc,o2,adich,rk0,rvord
      real tfrez,pai,rcg0,p,ace,xiao,daylnt,hs,hv,so4t6
      real so4t7,so4t5,so4t3,so4t4,blg,condso4,totso4
      real xso2,xso4,so4t0,so2t0,d2,cond,dt,so4t1,so4t2
      real pp,c,avo,cpresv,rgasv,boltzk,airmw,rgasi
      real cpres,g,asq,rayon,rgoasq,rgocp,rgas,t0
      real tmin,cam,delt,a0,rsn0,rcut0,ar,ww,tw,pi
      integer il2,il1,ih2s,idms,lev,ilev,ilg,nn,kount
      integer jlat,icomp,iso2,iso4,ntr   
      COMMON /PARAMS/ WW,TW,RAYON,ASQ,G,RGAS,RGOCP,RGOASQ,CPRES
     +         ,RGASV,CPRESV                             
      COMMON /NARCM/  AVO, RGASi, AIRMW, BOLTZK,  PI,  AR
     +   ,A0,RSN0,RCUT0,RCG0,P

      COMMON /PARAM1/ PAI, RVORD, TFREZ,     HS,  HV, DAYLNT
!
!     FOR FLOATING-1 MACHINE.
!
!      REAL*8 EFACT, AFAK, B, D, EXPPP
      double precision EFACT, AFAK, B, D, EXPPP
      REAL*8 ACOEFC(ILG,ILEV,2)

!      REAL ACOEFC(ILG,ILEV,2)

      REAL TCSZROW(ILG),CSZROW(ILG), TOTNU(ILG), TOTCD(ILG,ILEV)
      REAL RH(ILG,LEV), TOTCDN(ILG,ILEV),PCOND(ILG,ILEV,ISIZE) 
      REAL T(ILG,LEV),SHJ(ILG,ILEV), PRESSG(ILG)
      REAL OHROW(ILG, ILEV), NO3ROW(ILG,ILEV),ROAROW(ILG,ILEV)
      REAL RGRID(ILG, ILEV, NTR),CLDCV(ILG,ILEV,2)                     !SLG
      REAL RTSO2(ILG, ILEV,2),RTDMS(ILG, ILEV), RTH(ILG,ILEV,ISIZE)   
      REAL RTH2S(ILG, ILEV), RTNUCL(ILG, ILEV),CONDNU(15)
      REAL XROW (ILG, LEV, NTR)
      REAL RHSIZE(ILG,ILEV,ISIZE), AEROSIZE(2,ISIZE)
      REAL KN, RTCOND(ILG, ILEV,ISIZE),TOTMAS(ILG,ILEV,ISIZE)
      REAL AERONUM(ILG,ILEV,ISIZE), RHOP0(ICOMP), PVOL(ISIZE)
      DATA ACE/0.02/, XIAO/1.0E3/
      PARAMETER (Y4PID3 = 4.18879)
      PARAMETER (SO4MW = 98.1E-03)
      PARAMETER (AKB = 1.380662E-23)
      PARAMETER (ARA = 1.)
C
C     STATEMENT FUNCTION OT COMPUTE SO4 CONCENTRATION DUE TO COMBINED
C     NUCLEATION AND CONDENSATION PROCESSES AS A FUNCTION OF TIME.
C      
      OMEGA(A,B,C,D)=A+B*C**(D-1.)
      EXPP(A,B,C,D,T0)=EXP(-OMEGA(A,B,C,D)*T0)
      SO4(A,B,C,D,PP,T0)=((1.-EXPP(A,B,C,D,T0))*PP+EXPP(A,B,C,D,T0)*
     1                     OMEGA(A,B,C,D)*C)/OMEGA(A,B,C,D)
C
C     STATEMENT FUNCTION FOR ATOMIC DIFFUSION VOLUME [CM3]
C     MAKAR ET AL, 1998
C
      ADV(W)=0.369*W+6.29
      ADT2=2.*DELT
C
C     ZERO WORKING ARRAYS
C
      CALL PUTZERO(TOTCD, ILG*ILEV)
      CALL PUTZERO(TOTCDN,ILG*ILEV)
      CALL PUTZERO(RTNUCL,ILG*ILEV)
      CALL PUTZERO(PCOND, ILG*ILEV*ISIZE)
      CALL PUTZERO(RTCOND,ILG*ILEV*ISIZE)
      CUB=1./3.
      ZC=0.000
      DO L = 1+MAE, ILEV
         DO I=IL1,IL2
           IF (CAM .LT. 10.0)   THEN     !FOR GCM OR RCM
C===============================================================
C
C       * CLEAR AIR CHEMISTRY
C
C          RK  - RATE FOR SO2+OH
C          RK1 - DMS+OH VIA H ABSTRACTION
C          RK2 - DMS+OH VIA OH ADDITION
C          RK3 - DMS+NO3
C          RK4 - H2S+OH
C
C===============================================================
C
C      TOTAL CLEAR SKY FRACTION
C
            TCLR=1.-AMIN1(1.0,AMAX1(CLDCV(I,L,1),CLDCV(I,L,2)))        !SLG
C
C     * A FACTOR TO CONVERT DAILY AVERAGE FILED TO DIUNAL CHANGED
C
            DICH=MAX(CSZROW(I),ZC)/TCSZROW(I)*DAYLNT/DELT
            ADICH=(1.0-MAX(CSZROW(I),ZC))/((DAYLNT/DELT)-TCSZROW(I))
     1                           *DAYLNT/DELT
C
C     * FOR SO2. THE REACTION RATE CONSTANT DeMore et al. [1992]
C 
C       (1) SO2 + OH --->
C           dC[SO2]/dt = -k C[OH] C[SO2]
C           C[SO2,t] = C[SO2,0]*exp(-k C[OH] t) 
C
            RK0 = 3.0E-31*(300.0/T(I,L+1))**3.3
            RKINF = 1.5E-12
            ROCON = AVO/AIRMW*1.0E-3          ! AIR KG/M3 ->MOL/CM3
            RK0 = RK0*ROAROW(I,L)*ROCON
            RK = (RK0/(1.0+RK0/RKINF))*0.6**(1./(1.0+
     1                         (LOG10(RK0/RKINF))**2))
C
C     QOH SHOULD BE THE CONCENTRATION OF OH IN THE UNIT OF
C         MOLECULES/CM3
C
C         MOZART OH IS IN THE UNIT OF VOLUME MIXING RATIO [CM3/CM3]
C         TO CONVERT TO MOLEC CM-3
C
C            USE: 273.15/T* P/1.0133E5*1.E-3  / 22.4136 * AVO
C                 --------------+------------   ---+---   ---
C                   TO STD STATE VOL LIT       TO G-MOLE  TO MOLECULES
C    
            ROCON=AVO*273.15/T(I,L+1)*PRESSG(I)*SHJ(I,L)/1.0133E5
     1                  *1.E-3/22.4136

            QOH = OHROW(I,L)*DICH*ROCON
C
C       SO2 OXIDATION RATE
C
            RTSO2(I,L,1)=RK*QOH
C
C     * FOR DMS. THE REACTION RATE CONSTANT
C 
C       [1] H ABSTRACTION      Atkinson et al. [1989]
C
C       [2] OH ADDITION   e.g. Pham et al [1995]
C
C       [3] NO3 NIGHT REACTION  Pham et al [1995]
C
C          k =  1.9e-13 exp(500/T) cm**3/(mol * s) 
C
C
            RK1=9.6E-12*EXP(-234./T(I,L+1))
            O2 =ROAROW(I,L)*AVO/AIRMW*1.0E-3*0.21       ! AIR KG/M3 ->MOL/CM3
            RK2=1.7E-42*EXP(7810./T(I,L+1))*O2/
     1                   (1.+5.5E-31*EXP(7460./T(I,L+1))*O2)
            RK3=1.9E-13*EXP(500./T(I,L+1))
            QNO3=NO3ROW(I,L)*ADICH*ROCON
             
            RTO=(EXP(-((RK1+RK2)*QOH+RK3*QNO3)*ADT2)-1.)/ADT2
            RTDMS(I,L)=XROW(I,L+1,IDMS)*RTO                            !SLG
             
            XROW(I,L+1,IDMS)=AMAX1(TMIN,
     1                          XROW(I,L+1,IDMS)+RTDMS(I,L)*ADT2*TCLR)
C      
C     * FOR H2S. THE REACTION RATE CONSTANT
C
            
            RK4=6.3E-12*EXP(-80./T(I,L+1))
            
            RTH2S(I,L)=XROW(I,L+1,IH2S)*(EXP(-RK4*QOH*ADT2)-1.0)       !SLG
     1                                                   /ADT2         !SLG
            XROW(I,L+1,IH2S)=AMAX1(TMIN,
     1                          XROW(I,L+1,IH2S)+RTH2S(I,L)*ADT2*TCLR)

            SO2PRO=-64.6*(RTH2S(I,L)/34.06+RTDMS(I,L)/62.13)*TCLR
            XROW(I,L+1,ISO2)=AMAX1(TMIN,
     1                             XROW(I,L+1,ISO2)+SO2PRO*ADT2)
           END IF
C===============================================================
C
C      * NUCLEATION
C
C        SCHEME BY KULMALA ET AL [1998]
C        THIS PORTION OF CODE WAS CONTRIBUTED BY KNUT VON SALZEN
C
C          FOR ALL MODELS - GCM, RCM OR AURAMS
C
            RH01 = MAX(MIN(RH(I,L+1),1.0),0.1)
            ATEMPE = MAX(MIN(T(I,L+1),298.),233.)
C
C---        water vapour concentration in 1/cm^3
            ANW = RH01*1.E-06 * EXP ( 77.34491296 - 7235.42451/ATEMPE
     1         - 8.2*LOG (ATEMPE) + 5.7113E-03*ATEMPE ) 
     2          / ( AKB * ATEMPE )
C
            ADELTA = ATEMPE / 273.15
            APARA = 25.1289 - 4890.8/ATEMPE - 2.2479*ADELTA*RH01
            APARB = 7643.4/ATEMPE - 1.9712*ADELTA/RH01
            APARC = -1743.3/ATEMPE
            APARD = 1.2233 - 0.0154*ARA / ( ARA + RH01 ) 
     1            - 0.0415*LOG(ANW) + 0.0016*ATEMPE
            APARE = 0.0102
C
C---        calculation of threshold H2SO4 concentration
            ACONCR = EXP (-14.5125 + 0.1335 * ATEMPE - 10.5462 * RH01 
     1             + 1958.4 * RH01 / ATEMPE )
C
            AEXP = APARA + APARB * APARE
            ATUNER = 1.
C
C      H2SO4 in kg/kg in combined equation and J in per cm^3/s
C
            EXPPP = AEXP*ALOG(AVO*ROAROW(I,L)/SO4MW*1.E-06) -
     1                                         APARA*ALOG(ACONCR)
            EFACT=DEXP(EXPPP)
            AFAK = EXP (APARB * APARD + APARC) *EFACT *ATUNER

            AVESIZE = AEROSIZE(1,1)
C      *  to kg/kg/s
            AFAK = AFAK * Y4PID3 * RHOP0(NN) *AVESIZE*AVESIZE*AVESIZE
     1                * 1.E+06 / ROAROW(I,L)                            !SLG
C
C---        nucleation coefficients 
            ACOEFC(I,L,1) = AFAK
            ACOEFC(I,L,2) = AEXP
         END DO
      END DO
C===============================================================
C
C
C      * CONDENSATION OF H2SO4 [G] TO EXSITING PARTICLES.
C        LOOP FOR SIZE SPECTRUM 
C
      DO N=1,ISIZE
         DO L=1+MAE,ILEV
           DO I=IL1,IL2
             IF( AERONUM(I,L,N)*ROAROW(I,L) .GT. XIAO) THEN
C
C   DIFFUSION COEFFICIENT OF H2SO4 [GAS] [PERRY AND GREEN, 1984]
C   [M2 S-1]
C   WHERE 0.21145 = [(Ma+Mg)/MaMg]^1/2, Ma=28.97, Mg=98.1 [H2SO4]
C
               DFSO4=1.E-7*T(I,L+1)**1.75*0.21145/(PRESSG(I)*SHJ(I,L)/
     1            1.01325E5*(ADV(AIRMW)**CUB+ADV(SO4MW*1.E3)**CUB)**2)
C
C  THE MEAN FREE PATH OF VAPOUR SULPHURIC ACID
C   
               FRP = 3.0*SQRT(PI*98.1/(8.E3*RGASi*T(I,L+1)))*DFSO4
C
C            ACE --> ACCOMMODATION COEFFICIENT ~0.02
C
               KN = FRP/RHSIZE(I,L,N)
               FN = (1.+KN)/(1.+1.71*KN+1.33*KN*KN)
               AN = 1./(1.+1.33*KN*FN*(1./ACE-1.))
C
C     * THE CONDENSATION COEFFICIENTS FOR COMBINED COMPUTATION NEXT.
C       THE AERONUM*ROAROW ACCOUNTS FOR ALL THE PARTICLES IN BIN N. 
C
               RTCOND(I,L,N)=4.*PI*RHSIZE(I,L,N)*DFSO4*FN*AN*
     1                                    AERONUM(I,L,N)*ROAROW(I,L)
               TOTCDN(I,L)=TOTCDN(I,L)+RTCOND(I,L,N)
             END IF
           END DO
         END DO
      END DO

C
C    FRACTIONAL CONDENSATION TO EACH BIN FOR USE IN SOA
C
      DO N=1,ISIZE
         DO L=1+MAE,ILEV
            DO I=IL1,IL2
                COND=TOTCDN(I,L)
                IF (COND .GT. 0. .AND. AERONUM(I,L,N)*ROAROW(I,L).GT.
     1                                                     XIAO) THEN
                   PCOND (I,L,N)=AMAX1(AMIN1(RTCOND(I,L,N)/COND,1.),0.)
                END IF 
            END DO
         END DO
      END DO

C
C       USE 10 TIME INTERVALS TO COMPUTE THE TENDENCIES
C
      DT=ADT2/10.0
      D2=DT/2.0
      DO L=1+MAE,ILEV
         DO I=IL1,IL2
             SO4T0=MAX(1.E-18,XROW(I,L+1,ISO4))
             SO2T0=MAX(1.E-18,XROW(I,L+1,ISO2))
             IF (SO4T0 .GE. 1.E-18 .AND. TOTCDN(I,L) .GT. 0.
     1           .AND. XROW(I,L+1,ISO2) .GE. 1.E-18) THEN
C
C      TOTAL CLEAR SKY FRACTION
C
               TCLR=1.-AMIN1(1.0,AMAX1(CLDCV(I,L,1),CLDCV(I,L,2))) 
               A=AMAX1(AMIN1(TOTCDN(I,L),0.025),0.0)
               B=ACOEFC(I,L,1)
               D=ACOEFC(I,L,2)

               W=-98.1/64.6
!
!      PP IS THE HSO4(GAS) PRODUCTION RATE FROM SO2 OXIDATION
!      IN THE TIME INTERVAL CONDNU( I)
!      SO2 CONCENTRASTION SO2T0 IS UPDATED IN EVERY CONDNU( I)
!
!--------------
               PP=W*SO2T0*(EXP(-RTSO2(I,L,1)*CONDNU( 1))-1.0)/CONDNU( 1)
               SO2T0=SO2T0+PP*CONDNU( 1)/W
               SO4T1  =MAX(AKB,SO4(A,B,SO4T0, D,PP,CONDNU( 1)))
!--------------
               PP=W*SO2T0*(EXP(-RTSO2(I,L,1)*CONDNU( 2))-1.0)/CONDNU( 2)
               SO2T0=SO2T0+PP*CONDNU( 2)/W
               SO4T2  =MAX(AKB,SO4(A,B,SO4T1, D,PP,CONDNU( 2)))
!--------------
               PP=W*SO2T0*(EXP(-RTSO2(I,L,1)*CONDNU( 3))-1.0)/CONDNU( 3)
               SO2T0=SO2T0+PP*CONDNU( 3)/W
               SO4T3  =MAX(AKB,SO4(A,B,SO4T2, D,PP,CONDNU( 3)))
!--------------
               PP=W*SO2T0*(EXP(-RTSO2(I,L,1)*CONDNU( 4))-1.0)/CONDNU( 4)
               SO2T0=SO2T0+PP*CONDNU( 4)/W
               SO4T4  =MAX(AKB,SO4(A,B,SO4T3, D,PP,CONDNU( 4)))
!--------------
               PP=W*SO2T0*(EXP(-RTSO2(I,L,1)*CONDNU( 5))-1.0)/CONDNU( 5)
               SO2T0=SO2T0+PP*CONDNU( 5)/W
               SO4T5  =MAX(AKB,SO4(A,B,SO4T4, D,PP,CONDNU( 5)))
!--------------
               PP=W*SO2T0*(EXP(-RTSO2(I,L,1)*CONDNU( 6))-1.0)/CONDNU( 6)
               SO2T0=SO2T0+PP*CONDNU( 6)/W
               SO4T6  =MAX(AKB,SO4(A,B,SO4T5, D,PP,CONDNU( 6)))
!--------------
               PP=W*SO2T0*(EXP(-RTSO2(I,L,1)*CONDNU( 7))-1.0)/CONDNU( 7)
               SO2T0=SO2T0+PP*CONDNU( 7)/W
               SO4T7  =MAX(AKB,SO4(A,B,SO4T6, D,PP,CONDNU( 7)))
!--------------
               PP=W*SO2T0*(EXP(-RTSO2(I,L,1)*CONDNU( 8))-1.0)/CONDNU( 8)
               SO2T0=SO2T0+PP*CONDNU( 8)/W
               SO4T8  =MAX(AKB,SO4(A,B,SO4T7, D,PP,CONDNU( 8)))
!--------------
               PP=W*SO2T0*(EXP(-RTSO2(I,L,1)*CONDNU( 9))-1.0)/CONDNU( 9)
               SO2T0=SO2T0+PP*CONDNU( 9)/W
               SO4T9  =MAX(AKB,SO4(A,B,SO4T8, D,PP,CONDNU( 9)))
!--------------
               PP=W*SO2T0*(EXP(-RTSO2(I,L,1)*CONDNU(10))-1.0)/CONDNU(10)
               SO2T0=SO2T0+PP*CONDNU(10)/W
               SO4T10 =MAX(AKB,SO4(A,B,SO4T9, D,PP,CONDNU(10)))
!--------------
               PP=W*SO2T0*(EXP(-RTSO2(I,L,1)*CONDNU(11))-1.0)/CONDNU(11)
               SO2T0=SO2T0+PP*CONDNU(11)/W
               SO4T11 =MAX(AKB,SO4(A,B,SO4T10,D,PP,CONDNU(11)))
!--------------
               PP=W*SO2T0*(EXP(-RTSO2(I,L,1)*CONDNU(12))-1.0)/CONDNU(12)
               SO2T0=SO2T0+PP*CONDNU(12)/W
               SO4T12 =MAX(AKB,SO4(A,B,SO4T11,D,PP,CONDNU(12)))
!--------------
               PP=W*SO2T0*(EXP(-RTSO2(I,L,1)*CONDNU(13))-1.0)/CONDNU(13)
               SO2T0=SO2T0+PP*CONDNU(13)/W
               SO4T13 =MAX(AKB,SO4(A,B,SO4T12,D,PP,CONDNU(13)))
!--------------
               PP=W*SO2T0*(EXP(-RTSO2(I,L,1)*CONDNU(14))-1.0)/CONDNU(14)
               SO2T0=SO2T0+PP*CONDNU(14)/W
               SO4T14 =MAX(AKB,SO4(A,B,SO4T13,D,PP,CONDNU(14)))
!--------------
               PP=W*SO2T0*(EXP(-RTSO2(I,L,1)*CONDNU(15))-1.0)/CONDNU(15)
               SO2T0=SO2T0+PP*CONDNU(15)/W
               SO4T15 =MAX(AKB,SO4(A,B,SO4T14,D,PP,CONDNU(15)))
!
!      TOTAL SO2 CONVERTED INTO SO4
!
               XSO2=XROW(I,L+1,ISO2)-SO2T0
               RTSO2(I,L,1)=XSO2/ADT2    !OXIDATION RATE
               XROW(I,L+1,ISO2)=SO2T0
!
!      GASEOUS SO4 CHANGE
!
               XSO4=(SO4T15-XROW(I,L+1,ISO4))/ADT2
!
!      RESULTING SO4
!                               IF GASEOUS SO4 IS REDUCED.
               TOTSO4= -XSO2*W + MAX(0.0,-XSO4*ADT2)  

               TOTNU(I)=0.0
C
C        FOR NUCLEATION 
C              
               IF (B .GT. 0.0) THEN
                 BLG=LOG(B) 
                 TOTNU(I)=1.0/ADT2 * (
     1                    CONDNU( 1)*EXP(BLG + D*LOG(SO4T0 )) +
     2                    CONDNU( 2)*EXP(BLG + D*LOG(SO4T1 )) +
     3                    CONDNU( 3)*EXP(BLG + D*LOG(SO4T2 )) +
     4                    CONDNU( 4)*EXP(BLG + D*LOG(SO4T3 )) +
     5                    CONDNU( 5)*EXP(BLG + D*LOG(SO4T4 )) +
     6                    CONDNU( 6)*EXP(BLG + D*LOG(SO4T5 )) +
     7                    CONDNU( 7)*EXP(BLG + D*LOG(SO4T6 )) +
     8                    CONDNU( 8)*EXP(BLG + D*LOG(SO4T7 )) +
     9                    CONDNU( 9)*EXP(BLG + D*LOG(SO4T8 )) +
     9                    CONDNU(10)*EXP(BLG + D*LOG(SO4T9)) +
     9                    CONDNU(11)*EXP(BLG + D*LOG(SO4T10)) +
     9                    CONDNU(12)*EXP(BLG + D*LOG(SO4T11)) +
     9                    CONDNU(13)*EXP(BLG + D*LOG(SO4T12)) +
     9                    CONDNU(14)*EXP(BLG + D*LOG(SO4T13)) +
     9                    CONDNU(15)*EXP(BLG + D*LOG(SO4T14)) )
               END IF

C
C     FOR CONDENSATION
C
               TOTCD(I,L)=A/ADT2* (
     1                    CONDNU( 1)*SO4T0 + CONDNU( 2)*SO4T1 +
     1                    CONDNU( 3)*SO4T2 + CONDNU( 4)*SO4T3 +
     1                    CONDNU( 5)*SO4T4 + CONDNU( 6)*SO4T5 +
     1                    CONDNU( 7)*SO4T6 + CONDNU( 8)*SO4T7 +
     1                    CONDNU( 9)*SO4T8 + CONDNU(10)*SO4T9 +
     1                    CONDNU(11)*SO4T10+ CONDNU(12)*SO4T11+
     1                    CONDNU(13)*SO4T12+ CONDNU(14)*SO4T13+
     1                    CONDNU(15)*SO4T14 )
               RTNUCL(I,L)=TOTNU(I)
!
!      TOTAL SO4 PRODUCTION RATE FROM THE SIPLIFIED SCHEME. IT IS POSSIBLE
!      THAT THE MASS MAY NOT BE BALANCED COMPARED TO THE TOTAL SO2
!      OXIDATED. THEREFORE, THE BALANCED RATE WAS SCALED ACCORDING TO
!      THE INIVIDUAL RATE AND THE CONVERTED AMMOUNT OF SO4: TOTSO4
!
               TOTPAR=TOTCD(I,L)+RTNUCL(I,L)

               TOTCD(I,L)=TOTCD(I,L)/TOTPAR*TOTSO4/ADT2
               RTNUCL(I,L)=RTNUCL(I,L)/TOTPAR*TOTSO4/ADT2

               XROW(I,L+1,ISO4)=SO4T15
C
C       * PRODUCTION OF NEW PARTICLES BY NUCLEATION
C
               INEW=ISIZE*(NN-1)+1+(IAE1-1)
               XROW(I,L+1,INEW)=XROW(I,L+1,INEW)+RTNUCL(I,L)*ADT2
             END IF
         END DO
      END DO
C
C     FOR CONDENSATION
C
      DO N=1,ISIZE
         DO L=1+MAE,ILEV
            DO I=IL1,IL2
                COND=TOTCDN(I,L)
                IF (COND .GT. 0. .AND. AERONUM(I,L,N)*ROAROW(I,L).GT.
     1                                                     XIAO) THEN


C
C      * PERCENTAGE OF SO4 CONDENSED TO EACH BIN
C
                   CONDSO4=AMAX1(AMIN1(RTCOND(I,L,N)/COND,1.),0.)
                   RTCOND(I,L,N)=CONDSO4*TOTCD(I,L)
                ELSE
                   RTCOND(I,L,N)=0.0
                END IF 
            END DO
         END DO
      END DO

C
C       * CALL TO COMPUTE THE INTERSECTIONAL TRANSPORT DUE TO
C         CONDENSATION PROCESS.
C

c======================================================================
      if(1.eq.2)  then
      call Check_Adj_intrsec( LEV,     ILEV,      ILG,      IL1,    IL2,
     1                XROW,    RGRID,      NTR,    ICOMP,   IAE1,
     3            AEROSIZE,      RTH,       NN,     ADT2,  RHOP0,XIAO,
     4               ISIZE,   RTCOND,  AERONUM,   ROAROW,   PVOL,MAE)
      end if
c======================================================================

      CALL INTRSEC (   LEV,     ILEV,      ILG,      IL1,    IL2,
     1                XROW,    RGRID,      NTR,    ICOMP,   IAE1,
     3            AEROSIZE,      RTH,       NN,     ADT2,  RHOP0,XIAO,
     4               ISIZE,   RTCOND,  AERONUM,   ROAROW,   PVOL,MAE)
      RETURN
      END
