!** S/R AEROEXE1

      subroutine aeroexe1(dt,trnch,kount,ni,nk,                   
     &              t,q,psfc,sig,hght,surfwd,
     &              fws,ROA,fmodv,flwc,fktm,ftsoil,
     &              ice,snow,ffdss,fdz,lat_deg,long_deg,
     &              sza,frclds,frcldc,qr,
     &              ntr,
     &              nats,nct,ndt,gnluc,num_emission,
     &              sand2row,clay2row,sand6row,frluc,
     &              blcrow,omcrow,aq_date2,fhs,aero_tr,RSFROW,
!xuemin
     &      aso2row,pso2row,poso2row,aso4row,pso4row,poso4row,      
     &      dmsorow,dmslrow,h2srow, 
     &      gdrem1,gdrem2,gdrem3,ANO3ROW,PNO3ROW,PONO3ROW,
     &      mu0,eu0,du0,md0,ed0,  
     &      prate_2d,wrscav_2d,zfprec_2d,wpevpa_2d,  
!zch  20100118
     +      ww1,mc,dp,mb,esp0,zfg,  
     +      dsubcld,ideep, jt, maxg, jd, lengath,
     +      PSO4,PSOA,RRDROW) 


      integer  ::   trnch,kount,ni,nj,nk
      integer  ::   ntr, nats,nct,ndt,gnluc,num_emission
      real     ::   dt, dt_half
      integer  ::   tr_loc(ntr)
      real     ::   aero_tr(ni,nk,ntr)
      real     ::   wrongaero(ni,nk,ntr)
      real     ::   long,lat

!     include "chem_setup.cdk"
!     include "chem_luc.cdk"

      include "consphy.cdk"
      include "dintern.cdk"
      include "fintern.cdk"

!     include "aq_emis.cdk"
!     include "aero_emis.cdk"
!      include "aq_emis_order.cdk"
!      include "aq_chem.cdk"
!      include "aq_chem_order.cdk"

!      include "aero_chem.cdk"
!      include "aero_emis_order.cdk"
      include "aero_chem_order.cdk"
      include "chem_nml_vars.cdk"
      include "cam_set_gem.cdk"
      include "cam_cons.cdk"


! -----------------------------Object-----------------------------------
! this is the main interface subroutine for the aerosol physics/chemistry
!
! ----------added by H.Wang in Nov.8, 2004-----------------
! Arguments
!   name(demension)|  type   |              describtion      
!   input:
!   dt             | integer | length of timestep [sec.] 
!   trnch          | integer | Number of grid points in y-direction(latitude),slice number
!   kount          | integer | timestep number   
!   ni             | integer | horizontal dimension on longitude              
!   nk             | integer | vertical dimension                
!   t(ni*nk)       |   real  | Temperature at grid slice of mid-layer[K] 
!   ftv(ni*nk)     |   real  | VIRTUAL TEMP. (STAGG. LEVELS)
!   q(ni*nk)       |   real  | specific humidity [g/g]                
!   psfc(NI)       |   real  | Surface pressure [Pa] 
!   sig (NI*NK)    |   real  | Local interface (top??) sigma value
!   hght (NI*NK)   |   real  | Height at the each interface level [m]    
!   surfwd  (ni)   |   real  | surface wind speed (at 10m hight)[m/s]  
!   fws(ni*nk)     |   real  | grid vertical velocity [m/s ]
!   fmodv (NI*NK)  |   real  | wind speed at grid     [m/s] 
!   flwc (NI*NK)   |   real  | Cloud liquid water[unit?]
!   ftsoil(ni)     |   real  | Soil Temperature [K]                 
!   ice (NI)       |   real  | ice cover[0-1.]
!   snow (NI)      |   real  | snow cover[0-1.]
!   ffdss(ni)      |   real  | Ground solar irradiance(W/M**2),not used a present!
!   fdz (NI*NK)    |   real  | layer thickness [m],   
!   lat_deg (NI    |   real  | Grid latitude value    
!   long_deg(NI)   |   real  | Grid longitude value     
!   sza (ni)       |   real  | solar zenith angle, not used at present
!   frclds(NI*NK)  |   real  | Cloud cover, Strat.  [0-1.]   
!   frcldc(NI*NK)  |   real  | Cloud cover, Convec. [0-1.] 
!   qr (ni*2)      |   real  | Precip rate, 1 stratifor 2 Convective (kg /m2 s)|
!   mu(ni*(nk-1))  |   real  | upward cloud mass flux (positive up)(kg/m2/s) 
!   eu(ni*(nk-1))  |   real  | entrainment in updraft         
!   ntr            |  integer| number of tracer used in grapes
!  aq_date2        |         | Julian day infamation from general model
!   fhs(NI)        |   real  | SOIL MOISTUR
!  ROA(NI,NK)      !   real  ! air density  

!   output:

! aero_tr(ni*nk*num) |   real  | tracer concentration [kg/kg]    
!   local:           |
!

! IMPLICITES
 
      integer i,k,n,indx,l
      integer ik,ISZ
      integer ID
!     fonction-formule pour faciliter le calcul des indices
!      ik(i,k) = (k-1)*ni + i -1

       real t (NI,NK    )
       real q (NI,NK    )
       real psfc (NI    )
       real sig (NI,NK  )
       real hght (NI,NK )
       real ROA (NI,NK  )
       real lat_deg (NI ) 
       real long_deg (NI) 
       real sza (NI     )
       real ice (NI     )
       real snow (NI    )
       real flwc (NI,NK )
       real fmodv(NI,NK )
       real fws(ni,nk)
       real frclds (NI,NK  )
       real frcldc (NI,NK  )
       real fdz (NI,NK    )
       real frluc(NI,gnluc)
       real ftv (NI,NK    )      
       real fktm (NI,NK    )
       real qr (ni,2)
       real tnd(NI,NK)
       real surfwd(ni)
       real sst(ni)
       real ftsoil(ni)
       real ffdss(ni)
       real fhs (NI       )
       real prate_2d(ni,nk-1,2)
! zch 20090509
       real mu0(ni,nk-1),mu(ni,nk-1)
       real eu0(ni,nk-1),eu(ni,nk-1)
       real du0(ni,nk-1),du(ni,nk-1)
       real md0(ni,nk-1),md(ni,nk-1)
       real mc(ni,nk-1)
       real ed0(ni,nk-1),ed(ni,nk-1)
       real dp0(ni,nk-1),dp(ni,nk-1)
       real mb(ni)
       real eps0(ni)
       real zfg(ni,nk)
       real ww1(ni,nk)
       real dsubcld(ni)
       integer ideep (ni)
       integer jt(ni)
       integer maxg(ni)
       integer jd(ni)
       integer aq_date2
       integer lengath
! zch 20100118 for pso4,psoa
       real PSO4(ni,nk),PSOA(ni,nk)
       Real RD1, RD2,RD3
       REAL RRDROW(NI,3,2)
!------------FOR SFFLUX-------------------------------------------------------------

       REAL DSHJ(NI,NK-1)
       REAL FINTROW(NI,aero_nsize,3)

       REAL ASO4ROW(NI)
       REAL PSO4ROW(NI)
       REAL POSO4ROW(NI)
       REAL ASO2ROW(NI)
       REAL PSO2ROW(NI)
       REAL POSO2ROW(NI)
       REAL DMSOROW(NI)
       REAL DMSLROW(NI)
       REAL H2SROW(NI)
       REAL VOLCROW(NI,2)
       REAL BLCROW(NI,3,2)
       REAL OMCROW(NI,3,2)
       REAL ANO3ROW(NI),PNO3ROW(NI),PONO3ROW(NI)

       INTEGER ICAM, IREST, MODE, NSOIL,  ik1, IL1, IL2
       PARAMETER (NSOIL=152,  MODE=2)
       REAL SAND2ROW(NI,NATS)
       REAL CLAY2ROW(NI,NCT)
       REAL SREL(NI,NSOIL,NATS)
       REAL SAND6ROW(NI,NDT)

       REAL SS(NI,NSOIL)
       REAL SOILW(NI)
       REAL GC1(NI)
       REAL TBAR(NI)


       REAL PXNEW(NI,NK-1,ntr)
       REAL RSFROW(NI,NTR)
       REAL ROAROW(NI,NK-1)
! Added for computation of sand flux .
       REAL ROAROW1(NI,nk-1),topROA(NI)


!---FOR CAM_V05 ONLY------------------------------------------------------------------

       REAL              RHOP0(aero_chem_np) 
       CHARACTER(len=8)  aeroname(aero_chem_np)

       CHARACTER stopfile*15
       INTEGER JLAT, LON, NSUB, isub, MSG, NTRACA
       PARAMETER (NSUB=32, NTRACA=5)
       REAL GMT, CONDNU(15), POP, POP1, TMIN
       REAL SHJ (NI,NK-1)
       REAL RHROW (NI,NK)
       REAL TSROW (NI)
       REAL MODV (NI,NK-1)
       REAL EPSI (NI,NK-1)
       REAL F1 (NI,NK-1,NSUB)
       REAL F2 (NI,NK-1,NSUB)
       REAL FFG (NI,NK-1,2*NSUB)
       REAL WROW (NI,NK-1)
       REAL RHSIZE (NI,NK-1,aero_nsize)
       REAL RHOP (NI,NK-1,aero_nsize)
       REAL OHROW (NI,NK-1)
       REAL H2O2ROW (NI,NK-1)
       REAL O3ROW (NI,NK-1)
       REAL NO3ROW (NI,NK-1)
       REAL CO2ROW (NI,NK-1)
       REAL NH3ROW (NI,NK-1)
       REAL HNO3ROW (NI,NK-1)
       REAL TOTMAS (NI,NK-1,aero_nsize)
       REAL PDIFF (NI,NK-1,aero_nsize)
       REAL CLDCV (NI,NK-1,2)
       REAL ZMLWC (NI,NK-1,2)
       REAL WSUB (NI,NK-1,NSUB)
       REAL PRETROW (NI,NK-1,2)
       REAL RADCLD (NI,NK-1)
       REAL RGRID (NI,NK-1,ntr)
       REAL TRWTROW (NI,NK-1,aero_nsize)
       REAL AERONUM (NI,NK-1,aero_nsize)
       REAL ZFPREC (NI,NK-1)
       REAL PDEPV (NI,NK-1,aero_nsize)
       REAL RTCOA (NI,NK-1,ntr)
       REAL RTDRY (NI,NK-1,ntr)
       REAL RTICLD (NI,NK-1,ntr)
       REAL RTBCLD (NI,NK-1,ntr)
       REAL THLEV (NI,NK-1)
       REAL GDREM (NI,ntr,3)
! wh 060629
       REAL GDREM1 (NI,ntr)
       REAL GDREM2 (NI,ntr)
       REAL GDREM3 (NI,ntr)

       REAL COLEF (NI,NK-1,aero_nsize)
       REAL WETDEP (NI,NK-1,aero_nsize)
       REAL RTCOND (NI,NK-1,aero_nsize)
       REAL RTSO2 (NI,NK-1,2)
       REAL RTSO4 (NI,NK-1,aero_nsize)
       REAL RTDMS (NI,NK-1)
       REAL RTH2S (NI,NK-1)
       REAL RTNUCL (NI,NK-1)
       REAL RTH (NI,NK-1,aero_nsize)
       REAL VDG (NI,NG)
       REAL RCRITS (NI,NK-1,2)
       REAL RCOEXS (NI,NK-1,2)
       REAL WRZ (NI,NK-1,aero_nsize,2,2)
       REAL WRY (NI,NK-1,NTRACA,2)
       REAL WRX (NI)
       REAL WRW (NI,NK-1,ntr,9)
       LOGICAL   WRU(NI,NK-1)
       REAL WRA (NI*(NK-1)*36)
       REAL DZ (NI,NK-1)
       REAL ZZ (NI,NK-1)
       REAL RTHPO (NI,NK-1)
       REAL BETA (NI,NK-1,aero_nsize*aero_nsize)
       REAL DELIQS (NI,NK-1,aero_nsize)
       REAL RECRYS (NI,NK-1,aero_nsize)
       REAL WPEVPA (NI,NK-1)
       REAL WRSCAV (NI,NK-1)
       REAL CLSIZE (NI,NK-1,aero_nsize)
       REAL SOA (NI,NK-1)

       INTEGER LAMDA
       PARAMETER (LAMDA=5)
       REAL ABCOEF (aero_nsize,13,aero_chem_np-1,14)
       REAL SCCOEF (aero_nsize,13,aero_chem_np-1,14)
       REAL AODROW1 (NI,aero_chem_np-1,LAMDA)
       REAL AODROW2 (NI,aero_chem_np-1,LAMDA)
       REAL RHRROW (NI)

!xuemin
       REAL WRSCAV_2d (NI,NK-1)
       REAL ZFPREC_2d (NI,NK-1)
       REAL WPEVPA_2d (NI,NK-1)
!---Arrays not be used in cam---------------------------------------------------------
       INTEGER NSO4, ITRVAR
       REAL SAVERAD
       REAL TCSZROW (NI)
       REAL CSZROW (NI)
       REAL SURFDG (NI)
       REAL RTVER (NI,NK-1,ntr)

       REAL TRACG (NI,NK-1,ntr)

       DATA TMIN /0.0/

!Added by wang to seolve fohra is divided by zero 
!       REAL EPS1,EPS2
!       EPS1 =.62194800221014  !RGASD/RGASV
!       EPS2 =.3780199778986 ! 1 - EPS1


!       prapare parameters for INAero, H.WANG, OCT 26/2004
!       ISZ=aero_nsize+1
!       parameter(luc=gnluc)

!        print*,'zhaisx prints at the beginning of aeroexe1'
!----------------------------------------------------------------------------------
!       print*,'-----begin aeroexe1----------'
        ICAM =NCAM
!        print *, 'ICAM=', ICAM, aero_chem_np
!        print*,' land,aerosize,type=',luc,aero_nsize,aero_chem_np
!        print *, '***********************************'
!        print *, flwc
!        print *, '************************************'
!        print *, frclds

	call INAero(AERONAME,AEROSIZE,aero_chem_np,aero_nsize,RHOP0,ISCAM, 
     &                        ID,       JD,    ITI,  ITR,  ISLEV,   CAM,
     &                      DLEV,      LUC,    NG,   NS,     ML,
     &                      PLLP,       Z0,    SCC,  RCW,     AC, CSPEC,
     &                      LAICAM,     RM0,   ZPD, FCAP,     WP,   RGW,
     &                      AEST,      GAMMA)


!-----------------------------------------------------------------

!	  DO L=1,LUC
!	    DO N=1,5
!	 	  Z0CAM(L,N)=Z0(L,N)
!	    ENDDO
!	  ENDDO



       CALL PUTZERO(FINTROW,NI*aero_nsize*3)
!      CALL PUTZERO(SAND2ROW,NI*NATS)
!      CALL PUTZERO(CLAY2ROW,NI*2)
       CALL PUTZERO(SREL,NI*NSOIL*NATS)
!      CALL PUTZERO(SAND6ROW,NI*6)
       CALL PUTZERO(SS,NI*NSOIL)
       CALL PUTZERO(SOILW,NI)
       CALL PUTZERO(GC1,NI)
       CALL PUTZERO(TBAR,NI)

       CALL PUTZERO(PXNEW,NI*(NK-1)*ntr)
       CALL PUTZERO(RSFROW,NI*NTR)
       CALL PUTZERO(ROAROW ,NI*(NK-1))
       CALL PUTZERO(ROAROW1,NI*(NK-1))
       CALL PUTZERO(SHJ,NI*(NK-1))
       CALL PUTZERO(RHROW,NI*NK)
       CALL PUTZERO(TSROW,NI)
       CALL PUTZERO(MODV,NI*(NK-1))
       CALL PUTZERO(EPSI,NI*(NK-1))
       CALL PUTZERO(F1,NI*(NK-1)*NSUB)
       CALL PUTZERO(F2,NI*(NK-1)*NSUB)
       CALL PUTZERO(WROW,NI*(NK-1))
       CALL PUTZERO(RHSIZE,NI*(NK-1)*aero_nsize)
       CALL PUTZERO(RHOP,NI*(NK-1)*aero_nsize)
       CALL PUTZERO(OHROW,NI*(NK-1))
       CALL PUTZERO(H2O2ROW,NI*(NK-1))
       CALL PUTZERO(O3ROW,NI*(NK-1))
       CALL PUTZERO(NO3ROW,NI*(NK-1))
       CALL PUTZERO(CO2ROW,NI*(NK-1))
       CALL PUTZERO(NH3ROW,NI*(NK-1))
       CALL PUTZERO(HNO3ROW,NI*(NK-1))
       CALL PUTZERO(TOTMAS,NI*(NK-1)*aero_nsize)
       CALL PUTZERO(PDIFF,NI*(NK-1)*aero_nsize)
       CALL PUTZERO(CLDCV,NI*(NK-1)*2)
       CALL PUTZERO(WSUB,NI*(NK-1)*NSUB)
       CALL PUTZERO(PRETROW,NI*(NK-1)*2)
       CALL PUTZERO(RADCLD,NI*(NK-1))
       CALL PUTZERO(RGRID,NI*(NK-1)*ntr)
       CALL PUTZERO(TRWTROW,NI*(NK-1)*aero_nsize)
       CALL PUTZERO(AERONUM,NI*(NK-1)*aero_nsize)
       CALL PUTZERO(ZFPREC,NI*(NK-1))
       CALL PUTZERO(PDEPV,NI*(NK-1)*aero_nsize)
       CALL PUTZERO(RTCOA,NI*(NK-1)*ntr)
       CALL PUTZERO(RTDRY,NI*(NK-1)*ntr)
       CALL PUTZERO(RTICLD,NI*(NK-1)*ntr)
       CALL PUTZERO(RTBCLD,NI*(NK-1)*ntr)
       CALL PUTZERO(THLEV,NI*(NK-1))
       CALL PUTZERO(GDREM,NI*ntr*3)
       CALL PUTZERO(COLEF,NI*(NK-1)*aero_nsize)
       CALL PUTZERO(WETDEP,NI*(NK-1)*aero_nsize)
       CALL PUTZERO(RTCOND,NI*(NK-1)*aero_nsize)
       CALL PUTZERO(RTSO2,NI*(NK-1)*2)
       CALL PUTZERO(RTSO4,NI*(NK-1)*aero_nsize)
       CALL PUTZERO(RTDMS,NI*(NK-1))
       CALL PUTZERO(RTH2S,NI*(NK-1))
       CALL PUTZERO(RTNUCL,NI*(NK-1))
       CALL PUTZERO(RTH,NI*(NK-1)*aero_nsize)
       CALL PUTZERO(VDG,NI*NG)
       CALL PUTZERO(RCRITS,NI*(NK-1)*2)
       CALL PUTZERO(RCOEXS,NI*(NK-1)*2)
       CALL PUTZERO(WRZ,NI*(NK-1)*aero_nsize*2*2)
       CALL PUTZERO(WRY,NI*(NK-1)*NTRACA*2)
       CALL PUTZERO(WRX,NI)
       CALL PUTZERO(WRW,NI*(NK-1)*ntr*9)
       CALL PUTZERO(WRA,NI*(NK-1)*36)
       CALL PUTZERO(DZ,NI*(NK-1))
       CALL PUTZERO(ZZ,NI*(NK-1))
       CALL PUTZERO(RTHPO,NI*(NK-1))   
       CALL PUTZERO(BETA,NI*(NK-1)*aero_nsize*aero_nsize)
       CALL PUTZERO(DELIQS,NI*(NK-1)*aero_nsize)
       CALL PUTZERO(RECRYS,NI*(NK-1)*aero_nsize)
       CALL PUTZERO(WPEVPA,NI*(NK-1))
       CALL PUTZERO(WRSCAV,NI*(NK-1))
       CALL PUTZERO(CLSIZE,NI*(NK-1)*aero_nsize)
       CALL PUTZERO(SOA,NI*(NK-1))
!----------------------------------------------------------------------------------

!      if (aero_chem_L) then

        if (kount.eq.20.and.trnch.eq.1) then
          if (IDEBUG.EQ.1) then
!            WRITE (*,*)
!     &            'CAM -> IDD,JDD,ITI,ISCAM,INT(CAM),IDEBUG,ISLEV,ICOB,
!     &     IAT,MAE'
!            WRITE (*,*)
!     &            '      ',IDD,JDD,ITI,ISCAM,INT(CAM),IDEBUG,ISLEV,ICOB,
!     &            aero_chem_np,MAE
            WRITE (*,1111)  (AERONAME(N),N=1,aero_chem_np)
            WRITE (*,2222)  (RHOP0(N),N=1,aero_chem_np)
            WRITE (*,*) '       CAM SIZE BIN CONFIGURATIONS '
            DO N=1,aero_nsize
              WRITE (*,*) AEROSIZE(1,N), '   ', AEROSIZE(2,N)
            END DO
          endif
        endif
        MAE=(nk-1)-ISLEV
        MSG=0                                       !HP  new  June 8, 2004

 1111 FORMAT (' AEROSOL TYPE(S) -> ', 7('| ',A8,' |',1X))
 2222 FORMAT ('     DENSITY(KG/M3) ', 7('  ',F8.2,'  ',1X))

!----------------------------------------------------------------------
!             AEROSOL SURFACE FLUXES MODULE
!
!                  A - SEA-SALT
!                  B - SULPHATE
!                  C - BLACK CARBON
!                  D - OC
!                  E - SOIL DUST
!----------------------------------------------------------------------
      
      DELT = 0.5*dt                                                 !HP
      G = GRAV                                                  !HP
      RGAS = RGASD                                              !HP
      RGASVP = RGASV                  !HP
 
!     PASS EMISSIOM DATA TO CAM EMISSION ARRAYS
!     END OFPASS EMISSIOM DATA TO CAM EMISSION ARRAYS
 
      if (aero_chem_L) then
        CALL PUTZERO(DSHJ,NI*(NK-1))

      endif
	 

         ftv =(1+0.608*q)*t

      do ik1=1,nk-1
         k = ik1 + 1
         SHJ(:,ik1)  = sig(:,k) 
         DSHJ(:,ik1) = sig(:,k)-sig(:,ik1)   !zhjh: from underside to upside.DSHJ>0.

         ROAROW (:,ik1) = psfc(:)*SHJ(:,ik1)/(RGASD*t(:,k)) 

         ROAROW1(:,ik1) = ROA(:,k)
!zch
!         MU(:,IK1)=MU0(:,K)
!         EU(:,IK1)=EU0(:,K)
!         DU(:,IK1)=DU0(:,K)
!         MD(:,IK1)=MD0(:,K)
!         ED(:,IK1)=ED0(:,K)
!         MC(:,IK1)=MU(:,IK1)+MD(:,IK1)
!         WROW(:,IK1)= WW1(:,K)
!zhaisx
         MU(:,IK1)=0.0
         EU(:,IK1)=0.0
         DU(:,IK1)=0.0
         MD(:,IK1)=0.0
         ED(:,IK1)=0.0
         MC(:,IK1)=MU(:,IK1)+MD(:,IK1)
         WROW(:,IK1)= WW1(:,K)
      enddo

!---------------------------------------------------------------------------------
!I_SS for using specified sea-salt flux in sub sfss.!HP, will move into a control file later
!IREST for calculating sea-salt flux in sub sfss    !HP, will set by restart control

       IL1=1
       IL2=ni
       I_SS = 1  
       IREST = 1 

!      GC1=0.0   !open sea for test only  !HP 

!      if (IDEBUG.EQ.1) write(*,*)'in aeroexe1 SO2 0i',IDD,trnch,ISLEV,
!     &	aero_tr(IDD,ISLEV,cncaSO2)


        TBAR(1:ni) = ftsoil(1:ni)   !zhjh: Taken from loop do i.


!     do i=1, ni
!        if (f(mg+i-1).GT.0.1) then
!          GC1(i) = -1.0            !HP
!        else  !if (f(mg+i-1).EQ.0.0) then
!          GC1(i) = 0.0             !HP
!        else !if (ice(i).GT.0.5) then
!          GC1(i) = 1.0             !HP
!   ---FOR SSFLUX( )--------------------------------------------------------------
!       endif
!      end do

!------------------------------------------------------------------------


! Move here from the rear of chem_trcdiff2 .
       do ik1=1,nk-1              !come form aero_chem_v1
          k = ik1 + 1
        do i=1,ni
          THLEV(i,ik1) = fdz(i,k) 
          dz(i,ik1)    = fdz(i,k) 
        enddo
       enddo


      do i=IL1, IL2
        do l=IAE1, ICAM !ntr-aero_diags                            !HP 
          RSFROW(i,l)=0.0
        enddo
          RSFROW(i,cncaDMS)=0.0
          RSFROW(i,cncaH2S)=0.0
          RSFROW(i,cncaSO2)=0.0
          RSFROW(i,cncaSO4)=0.0
          RSFROW(i,cncaH2O2)=0.0
      enddo

    
        DO N=13,24     !  only test dust aerosol wh 050225
             DO L=1+MAE,NK-1
                DO I=IL1,IL2
                IF (AERO_TR(I,L,N) .GT. 0.1) THEN
                WRITE (*,*) 'AERO_TR greater than 0.1 befroe  sfflux ' 
                WRITE (*,*) ' KOUNT     LEV      lat    long    ITR '
                WRITE (*,*)  KOUNT, L,  LAT_DEG(I),   LONG_DEG(I),  N
                WRITE (*,*) ' AERO_TR= ', AERO_TR(I,L,N)
                WRITE (*,*) ' SURF FLUX ',ITR, '= ', RSFROW(I,N)
                WRITE (*,*) ' SURF WIND ',ITR, '= ', SURFWD(I)
!                  AERO_TR(I,L,N)=0.09
                call XIT ('suff',-1)
                ENDIF
                enddo
              enddo
        enddo


!------------------------------------------------------------------------

      CALL SFFLUX(aero_tr, frluc,   DSHJ,    IL1,   IL2,   ni,    nk,
     1             nk-1,ntr,aero_chem_np,AERONAME, t,FINTROW,VOLCROW,
     2 ASO4ROW,PSO4ROW,POSO4ROW,BLCROW,DMSOROW,DMSLROW,H2SROW,t(1,nk),
     3 ASO2ROW,PSO2ROW,POSO2ROW,
     & aero_nsize,RHOP0,THLEV,PXNEW,aero_tr(1,2,1),
     4        AEROSIZE, SURFWD, RSFROW, psfc, ICAM, ROAROW, GC1,
     5            IAE1,cncaH2S,cncaDMS, cncaSO2, cncaSO4, IREST,gnluc,
     6            I_SS, OMCROW,SAND2ROW,CLAY2ROW, snow,  SREL,   NATS,
     7           NSOIL,   MODE,    MAE,  NS, Z0,  fhs,  SS, SURFDG,
     8                SAND6ROW,   TBAR, ANO3ROW,PNO3ROW,PONO3ROW,
     9            RRDROW) 
!           print *,'end of sfflux'
 
!------------------------------------------------------------------------
           write(34,*)'surface tracer : value = ',  maxval(aero_tr)
           write(34,*)'surface tracer : local = ',  maxloc(aero_tr)
!           print*,'aeroexe1 il1,il2=',il1,il2
         
          DO N=13,24     !  only test dust aerosol wh 050225
             DO L=1+MAE,NK-1
               DO I=IL1,IL2
               IF (AERO_TR(I,L,N) .GT. 0.1) THEN
                WRITE (*,*)   'AERO_TR greater than 0.1 after sfflux'
                WRITE (*,*) ' KOUNT     LEV      lat    long    ITR '
                WRITE (*,*)  KOUNT, L,  LAT_DEG(I),   LONG_DEG(I),  N
                WRITE (*,*) ' AERO_TR= ', AERO_TR(I,L,N)
                WRITE (*,*) ' SURF FLUX ',ITR, '= ', RSFROW(I,N) 
                WRITE (*,*) ' SURF WIND ',ITR, '= ', SURFWD(I)
!                  AERO_TR(I,L,N)=0.09 
                call XIT ('suff',-1)
               ENDIF
               IF (AERO_TR(I,L,N) .LT. 0.0) THEN
!                WRITE (*,*)   'AERO_TR negative  after sfflux'        
!                WRITE (*,*) ' KOUNT     LEV      lat    long    ITR '
!                WRITE (*,*)  KOUNT, L,  LAT_DEG(I),   LONG_DEG(I),  N
!                WRITE (*,*) ' AERO_TR= ', AERO_TR(I,L,N)
!                WRITE (*,*) ' SURF FLUX ',ITR, '= ', RSFROW(I,N)
!                WRITE (*,*) ' SURF WIND ',ITR, '= ', SURFWD(I)
                AERO_TR(I,L,N)=0.0 
               ENDIF

               ENDDO
             ENDDO
           ENDDO  


!------------------------------------------------------------------------
! apply vertical diffusion 
! preparing for subroutine chem_trvdiff2 
! added by H.Wang NOV. 25 2004      

        tr_loc=0
!        print*,'zhaisx print3 hght(1,1),hght(1,2)',hght(1,1),hght(1,2)
        call chem_trvdiff2(aero_tr,tr_loc,fktm,hght,dt,ni,nk,ntr,trnch)

!------------------------------------------------------------------------

          DO N=13,24     !  only test dust aerosol wh 050225
           DO L=1+MAE,NK-1
            DO I=IL1,IL2
               IF (AERO_TR(I,L,N) .GT. 0.1) THEN
                WRITE (*,*)   'AERO_TR greater than 0.1 after chem_trv'
                WRITE (*,*) '  KOUNT     LEV      lat    long    ITR '
                WRITE (*,*)  KOUNT, L,  LAT_DEG(I),   LONG_DEG(I),  N
                WRITE (*,*) ' AERO_TR= ', AERO_TR(I,L,N)
!                AERO_TR(I,L,N)=0.09
                call XIT ('chem_trvdiff',-1)
               ENDIF
               IF (AERO_TR(I,L,N) .LT. 0.0) THEN
!                WRITE (*,*)   'AERO_TR negative  after chem_trv'       
!                WRITE (*,*) '  KOUNT     LEV      lat    long    ITR '
!                WRITE (*,*)  KOUNT, L,  LAT_DEG(I),   LONG_DEG(I),  N
!                WRITE (*,*) ' AERO_TR= ', AERO_TR(I,L,N)
                AERO_TR(I,L,N)=0.0 
               ENDIF

             ENDDO
            ENDDO
          ENDDO


!--------------------------------------------------------------------------
!
!   * PREPARATION FOR CALL AEROSOL PHYSICS
!
!     load arrays to be passed to CAM subroutines 


      do ik1=1,nk-1              !come form aero_chem_v1
        k = ik1 + 1
        do i=1,ni

!zhjh: Comment off at 2005.03.17 .
!zhjh:    THLEV(i,ik1) = fdz(i,k) ! get form aero_chem_v1
!zhjh:    dz(i,ik1) = fdz(i,k)    ! was set in cldprp -- easier to set here to fdz !! check 
!  why don't use THLEV() instead of dz() ?  HP???
!zhjh:    SHJ(i,ik1) = sig(i,k)  ! use this way first, check it later HP???

          RHROW(i,k) = FOHRA(q(i,k),t(i,k),psfc(i)*sig(i,k))
 

          do l=1,NTR         !should be refer to the relative chemistry speceis?! HP
            rgrid(i,ik1,l) = aero_tr(i,k,l)  !instead of all tracers  HP!!!
          enddo

!  tr in volume mixing ratio !!!! fixing here (into mass mixing ratio) 

          rgrid(i,ik1,cncaOH) = rgrid(i,ik1,cncaOH) * 17./28.97
          rgrid(i,ik1,cncaO3) = rgrid(i,ik1,cncaO3) * 48./28.97
          rgrid(i,ik1,cncaH2O2) = rgrid(i,ik1,cncaH2O2) * 34./28.97

!P    rgrid(i,ik1,cncaSO2) = rgrid(i,ik1,cncaSO2) * 64./28.97             !if using geia_full emission data, stop this  HP


          rgrid(i,ik1,cncaHNO3) = rgrid(i,ik1,cncaHNO3) * 63./28.97

          OHROW(i,ik1) = rgrid(i,ik1,cncaOH)
          h2o2row(i,ik1) = rgrid(i,ik1,cncaH2O2)
          o3row(i,ik1) = rgrid(i,ik1,cncaO3)
          no3row(i,ik1) = rgrid(i,ik1,cncaNO3)
          co2row(i,ik1) = rgrid(i,ik1,cncaCO2)
          nh3row(i,ik1) = rgrid(i,ik1,cncaNH3)
          hno3row(i,ik1) = rgrid(i,ik1,cncaHNO3)
          cldcv(i,ik1,1) = frclds(i,k)
          cldcv(i,ik1,2) = frcldc(i,k)

! fudge for now - use cloud lwc and frac. strat/conv.     !come from aero_chem_v1.ftn
	
          IF ((frclds(i,k)+frcldc(i,k)).NE.0.) THEN
            ZMLWC(i,ik1,1) = flwc(i,k)*frclds(i,k)/(frclds(i,k)
     &		  +frcldc(i,k)) !strat.
            ZMLWC(i,ik1,2) = flwc(i,k)*frcldc(i,k)/(frclds(i,k)
     &		  +frcldc(i,k)) !conv.
!           print *, flwc(i,k),frclds(i,k),ZMLWC(i,ik1,1), 
!     &             ZMLWC(i,ik1,2), 'in aeroexe1 by zhouch'
          ELSE
            ZMLWC(i,ik1,1) = 0.0
            ZMLWC(i,ik1,2) = 0.0
          ENDIF
          MODV(i,ik1) = fmodv(i,k)


! NEED TO FIX THIS 
          PRETROW(i,ik1,1) = prate_2d(i,ik1,1)  ! 1 stratiform  units?
          PRETROW(i,ik1,2) = prate_2d(i,ik1,2)  ! 2 convective
         

!          PRETROW(i,ik1,1) = qr(i,1)/(nk-1)  ! 1 stratiform  units?

!          PRETROW(i,ik1,2) = qr(i,2)/(nk-1)  ! 2 convective          

          do isub=1, NSUB                !added this loop for sub-grid
           WSUB(i,ik1,isub) = fws(i,k)!now set its sub-grid with same wsub() !HP
          enddo
        enddo
      enddo

      do i=1,ni
        CSZROW(i) = cos(sza(i))   !use cosd() or sza() use radians !!?? HP
!        CSZROW(i) = f(cosas+i-1)  !use the cos( solar zenith angle ) directly  HP
        TSROW(i) = t(i,nk)        !come form aero_chem_v1
      enddo

      SAVERAD = 1.    ! to accumulate

 
!     * COMPUTE THE TOTAL DAILY SOLAR ZENITH ANGLE
!
!      IF (GMT .EQ.0.0 .OR. IREST .EQ. 1) THEN  !this part could be deleted, we use OH get
!         DO I=IL1,IL2                          !from aq_chem and it is instant concentration
!            TCSZROW(I)=0.0
!         END DO
!         CLOCK=0.0
!         DO ITN=1,INT(DAYLNT/dt)
!           DO  I=IL1,IL2
!               CSZR = SINJ(I)*SIND - COSJ(I)*COSD*
!     1                   COS(2.*PI*( CLOCK/DAYLNT +
!     2                   long_deg(I)/360.))
!               CSZR = MAX(CSZR,1.E-6)
!               TCSZROW(I)=TCSZROW(I)+CSZR
!           END DO
!           CLOCK=CLOCK+dt
!         END DO
!      END IF

!   *********************  START OF BOX MODEL TEST DATA  ********************HP
      DO I=IL1,IL2
          TCSZROW(I)= 0.12526E+02  !just give a data to test its function, it is not used any more
      END DO
      NSO4=2
      DO L=1,nk-1
         DO I=IL1,IL2              !apply these values for test only
           ZZ (I,L)= 0.39012E+02   !it is not used any more
!           ZFPREC(I,L)=1.E-9
!           WPEVPA(I,L)=0.5
!           WRSCAV(I,L)=0.5
!xuemin           
           ZFPREC(I,L)=PRETROW(i,L,1)/hght(i,L)
           WPEVPA(I,L)=WPEVPA_2d(I,L)
           WRSCAV(I,L)=WRSCAV_2d(I,L)
         END DO
      END DO
!zch 20100118
      do i=1,ni
        do k=1,nk-1
         RTSO2(i,k,1)=PSO4(i,k)
         SOA(i,k)=PSOA(i,k)
        end do
      end do
!   *********************  END OF BOX MODEL TEST DATA  *********************HP
!
!    COMPUTE THE CONDENSATION/NUCLEATION TIME INTERVALS
!
      DO I=1,15
         POP1=2.*dt/EXP(FLOAT(15-I)/1.7)
         IF (I .GE. 2) THEN
             CONDNU(I)=POP1-POP
             POP=POP1
         ELSE
             CONDNU(I)=POP1
             POP=POP1
         END IF
      END DO

      JLAT=trnch

!-------------added by H.Wang to PREPARE IGF,IGFIJ AND COAGFR	2004/11/11

      ISIZE=aero_nsize
	

      DO I=1,ISIZE
         RI=(AEROSIZE(1,I)+AEROSIZE(2,I))/2.0
         PVOL(I)=4.189*RI*RI*RI
      
	  END DO

      CALL PUTZERO(COAGFR,ISIZE*ISIZE*ISIZE)
      DO I=1,ICOB
        DO J=I,ICOB
           VOIJ=PVOL(I)+PVOL(J)
           DO K=J,ICOB
              VOK=PVOL(K)
              IF (K .EQ. ICOB .AND. VOIJ .GE. VOK) THEN
                 COAGFR(I,J,K)=1.0
              END IF
              IF (K .LT. ICOB) THEN
                 VOKP1=PVOL(K+1)
                 COAGFR(I,J,K)=CVMGT(VOK/VOIJ*(VOKP1-VOIJ)/(VOKP1-VOK),
     1              COAGFR(I,J,K), VOIJ .GE. VOK .AND. VOIJ .LT. VOKP1)
              END IF
              IF (K .GT. 1 ) THEN
                 VOKM1=PVOL(K-1)
                 COAGFR(I,J,K)=CVMGT(1.-COAGFR(I,J,K-1), COAGFR(I,J,K),
     1                   VOIJ .GT. VOKM1 .AND. VOIJ .LT. VOK)
              END IF
              COAGFR(J,I,K)=COAGFR(I,J,K)
           END DO
        ENDDO
      END DO

      DO K=1,ICOB
        ITOT=0
        DO J=1,ICOB
            DO I=1,ICOB
               IF (COAGFR(I,J,K) .GT. 0.0) THEN
                  ITOT=ITOT+1
                  IGFIJ(K,ITOT,1)=I
                  IGFIJ(K,ITOT,2)=J
               END IF
            END DO
        END DO
        IGF(K)=ITOT
      END DO

!    --------------------------------------------------------------------
!

!    * CALL AEROSOL PHYSICS

!        print *, 'begin cam_v05',trnch
      CALL CAM_V5   (nk-1,       nk,       ni,      IL1,      IL2,
     1               JLAT,   ITRVAR,        t,    RHROW,      LON,
     2            aero_tr,     psfc,      SHJ,      sig,      CAM,
     3            lat_deg, long_deg,        q,      ITI,      ITR,
     3              TSROW,     MODV,   RSFROW,     EPSI,     DLEV,
     4                 F1,       F2,      FFG,     WROW,    IREST,
     4            TCSZROW,   CSZROW,      GMT,      MAE,      IGF,
     4              TRACG,   ntr,aero_chem_np,    KOUNT,    gnluc,
     5             SURFDG,   SURFWD, AEROSIZE,   RHSIZE,     RHOP,
     6           AERONAME,aero_nsize,  ASO2ROW,  PSO2ROW,  ASO4ROW,
     7            PSO4ROW,  DMSOROW,  DMSLROW,   H2SROW,     NSO4,
     1              OHROW,  H2O2ROW,    O3ROW,   NO3ROW,   CO2ROW,
     9             NH3ROW,  HNO3ROW,   TOTMAS,     NSUB,      IDD,
     3              PDIFF,    CLDCV,    ZMLWC,     WSUB,  SAVERAD,
     6            PRETROW,   RADCLD,    RGRID,  TRWTROW,   ROAROW,
!050319: 
     9              RHOP0,  AERONUM,      ice,     snow,   ZFPREC,
     A              PXNEW,    PDEPV,    RTCOA,   RTICLD,   RTBCLD,
     B              RTDRY,    RTVER,    THLEV,     DSHJ,    GDREM,
     C                JDD,    COLEF,   WETDEP,  cncaH2S, cncaH2O2,
     D            cncaDMS,  cncaSO2,  cncaSO4,     IAE1,     ICAM,
     E            cncaLWC,  cncaIWC,  cncaCCN,  cncaCLF,   CONDNU,
     6             RTCOND,    RTSO2,    RTSO4,    RTDMS,    RTH2S,
     E                VDG,    FFDSS, AQ_DATE2,  T(1,NK),T(1,NK-1),  !if this aq_date2(2)=IDAY, have to check it  HP
     8              frluc,   RTNUCL,      RTH,      MSG,    IGFIJ,   !t(1,nk) as SFCTROW() needs to be checked    HP
     A             RCRITS,   RCOEXS,      WRZ,      WRY,      WRX,   ! knut
     B                WRW,      WRU,      WRA,       MU,       EU,   ! knut
     C                 DU,       MD,       MC,       ED,       DP,   ! knut
     D                 DZ,       MB,     EPS0,      ZFG,  DSUBCLD,   ! knut
     E                 ZZ,    IDEEP,       JT,     MAXG,       jd,   ! knut
     F            LENGATH,   NTRACA,    RTHPO,     BETA,   DELIQS,
     G             RECRYS,   WPEVPA,   WRSCAV,   CLSIZE,   COAGFR,
     H               PVOL,     TMIN,       NG,       NS,       NL,
     3                PLLP,    Z0,      scc,    RCW,   AC, CSPEC,
     4             LAICAM,      RM0,      ZPD,     FCAP,   WP, RGW,
     5               AEST,    GAMMA,      SOA,   ABCOEF,    SCCOEF,
     6            AODROW1,  AODROW2,   RHRROW,  LAMDA,tcld3,
     7            cncaVIS, cncaAM1,cncaAM2,cncaAM3)
!     ----------------------------------------------------------------------


!       endif
!   wh 060629
         do i=1,ni
         do m=1,ntr
             gdrem1(i,m)=gdrem(i,m,1)
             gdrem2(i,m)=gdrem(i,m,2)
             gdrem3(i,m)=gdrem(i,m,3)
         enddo
         enddo


c      if (IDEBUG.EQ.1) write(*,*)'in aeroexe1 SO2 2i',IDD,trnch,ISLEV,aero_tr(IDD,ISLEV,cncaSO2)
c      if (IDEBUG.EQ.1) write(*,*)'end of aeroexe1 kount,trnch=',kount,trnch

      return
      end

