      SUBROUTINE AEROACT (   ILEV,   ILG,    IL1,      IL2,    IIWC,
     1                      RCOEX,RADCLD, TOTNUM,   RHSIZE,    ILWC,
     2                        NTR, ISIZE,   RHOP,     ICDN,    WROW,
     3                       XROW,  WSUB,  RCRIT,     NSUB, AERONUM,
     4                      ZMLWC,ROAROW, CLSIZE,      CAM,    MAE)
C-----------------------------------------------------------------------
C
C     HISTORY:
C     --------
C     * JUN 14/2001 - S.L. GONG   THE AEROSOL NUMBER SIZE RANGE WAS 
C     *                           IMPOSED TO CALCULATE THE CLOUD
C     *                           DROPLET NUMBER. 
C     *
C     * DEC 02/1998 - S.L. GONG   THE CLOUD NUMBER DENSITY IS NOW 
C     *                           COMPUTED FROM JONES ET AL 1994
C     *                           PARAMETERIZATION WHICH RELATES THE
C     *                           TOTAL AEROSOL NUMBER TO CLOUD DROPLET
C     *                           NUMBER.
C     *
C     * JAN 12/1998 - S.L. GONG   A SIMPLIFIED VERSION OF GHAN 1993
C     *                           ACTIVATION PARAMETERIZATION SCHEME
C     *                           WITH CONSTANT d PARAMETER.
C     *
C     *
C     METHOD:
C     -------
C
C     VARIABLES:
C     ----------
C
C-----------------------------------------------------------------------
      REAL RADCLD (ILG,ILEV), TOTNUM(ILG,ILEV,ISIZE)
      REAL RHSIZE (ILG,ILEV,ISIZE), RHOP(ILG, ILEV,ISIZE)
      REAL CLSIZE (ILG,ILEV,ISIZE)
      REAL XROW (ILG,ILEV+1,NTR),WSUB(ILG,ILEV,NSUB), RCRIT(ILG,ILEV)
      REAL RCOEX (ILG,ILEV), WROW(ILG,ILEV), ROAROW(ILG,ILEV)
      REAL AERONUM(ILG,ILEV,ISIZE), ZMLWC(ILG,ILEV,2)
C
C     ACCUMULATE NUMBER OF AEROSOLS[/M^3] FOR EACH GRID
C     THE STARTING SIZE IS r=1.5 um.Bin = 9
C
      CALL PUTZERO(TOTNUM, ILG*ILEV*ISIZE)
      CALL PUTZERO(RCOEX, ILG*ILEV)
      DO N=9,1,-1
         DO N1=N,9
            DO L=1+MAE,ILEV
               DO I=IL1,IL2
                  TOTNUM(I,L,N) = TOTNUM(I,L,N)+AERONUM(I,L,N1)
     1                                               *ROAROW(I,L)
                  RCRIT(I,L)=FLOAT(ISIZE+1)
                  IF ((CAM .GT. 1.0 .AND. CAM .LT. 10.) .OR.
     1                (CAM .GT. 10. .AND. CAM .LT. 90.)) 
     2                XROW(I,L+1,ICDN)=0.0
               END DO
            END DO
         END DO
      END DO
C
C     COMPUTE THE CLOUD DROPLET NUMBER [1/M^3 AIR]
C     FOR THE CURRENT VERSION, d [M^4 S^-1] IS ASSUMED CONSTANT
C     --- A SUBROUTINE WILL BE INSERTED HERE LATER TO COMPUTE
C         d AS A FUNCTION OF AEROSOL SIZE DISTRIBUTION,
C         COMPOSITION AND OTHER PAPAMETERS.
C
      d = 3.4E-11
      CUB=1./3.
      IF (CAM .EQ. 1.0 .OR. CAM .EQ. 10.0) GOTO 100
      DO J=1,NSUB
         DO L=1+MAE,ILEV
            DO I=IL1,IL2
               WTOT=WSUB(I,L,J)+WROW(I,L)
               IF (WTOT .LT. 0.0) THEN
                  XROW(I,L+1,ICDN)=XROW(I,L+1,ICDN)+TOTNUM(I,L,1)/NSUB*
     1                            ABS(WTOT)/(ABS(WTOT)+ d*TOTNUM(I,L,1))
               END IF
            END DO
         END DO
      END DO
      GOTO 200
C
C     FIND THE ACTIVATED BIN NUMBER
C
C        DEFINE: RCRIT = BIN NUMBER + % UN-ACTIVED
C        E.G.    RCRIT = 4.3 MEANS BIN 4 AND OVER ARE ACTIVATED WITH
C                        30% UN-ACTIVATED IN BIN 4.
C
  100 CONTINUE
C
C    CLOUD DROPLET NUMBER DENSITY [1/M3] FROM JONES ET AL 1994
C    AEROSOL SIZE RANGE ARE IN r=0.05-1.5 um
C    For 12 size bin configuration, Bin 4 is the cut.
C
       DO L=1+MAE,ILEV
          DO I=IL1,IL2
             TONA=TOTNUM(I,L,4)*1.E-6
             XROW(I,L+1,ICDN)=375.E6*(1.-EXP(-2.5E-3*TONA))
          END DO
       END DO
  200 CONTINUE
      DO N=ISIZE,2, -1
         DO L=1+MAE,ILEV
            DO I=IL1,IL2
               IF (XROW(I,L+1,ICDN) .GT. TOTNUM(I,L,N) .AND.
     1             XROW(I,L+1,ICDN) .LE. TOTNUM(I,L,N-1))        THEN
                  RLEFT=(TOTNUM(I,L,N-1)-XROW(I,L+1,ICDN))/
     1                          (AERONUM(I,L,N-1)*ROAROW(I,L))
                  RCRIT(I,L)=FLOAT(N-1)+AMIN1(1.0,RLEFT)
               END IF
               IF (XROW(I,L+1,ICDN) .GT. TOTNUM(I,L,1))
     1                                     RCRIT(I,L)=1.0
            END DO
         END DO
      END DO
C
C     DISTRIBUTE CLOUD LIQUID WATER [KG/KG] INTO ACTIVATED BINS
C     ACCORDING TO THE CLOUD NUMBER DENSITY IN EACH ACTIVATED BIN
C     AND ESTIMATE CLOUD DROPLET RADIUS.
C
C     CLOUD DROPLET RADIUS AT THE INTERRUPTED BIN WHERE AEROSOL
C     AND CLOUD DROPLET CO-EXIST IS SAVED IN RCOEX(I,L).
C     FOR FULLY ACTVIATED BINS, THE RHSIZE IS UPDATED.
C
      RHOPW=1000.00
      DO N=1,ISIZE
         DO L=1+MAE,ILEV
            DO I=IL1,IL2
!         print *, INT(RCRIT(I,L)),XROW(I,L+1,ICDN),
!     +           ZMLWC(I,L,1)+ZMLWC(I,L,2),'IN AEROACT'
                IF (N .GE. INT(RCRIT(I,L))
     1                    .AND. XROW(I,L+1,ICDN) .GT. 0.0 .AND.
     2                    ZMLWC(I,L,1)+ZMLWC(I,L,2) .GT. 0.0)  THEN
                   H2O=(ZMLWC(I,L,1)+ZMLWC(I,L,2))/
     1                                (XROW(I,L+1,ICDN)/ROAROW(I,L))
                   RWI=RHSIZE(I,L,N)
                   IF (N .EQ. INT(RCRIT(I,L))) THEN
                      RCOEX(I,L)=RHSIZE(I,L,N)
                      CLSIZE(I,L,N)=RHSIZE(I,L,N)
!                    print *, RHSIZE(I,L,N),RCOEX(I,L),'in AEROACT'
                   ELSE
                      CLSIZE(I,L,N)=((RWI*RWI*RWI*RHOP(I,L,N)+
     1                                       H2O/4.189)/RHOPW)**CUB
!              print*, RWI,RHOP(I,L,N),H2O,RHOPW,CUB,CLSIZE(I,L,N)
                   END IF
                END IF
            END DO
         END DO
      END DO
      DO L=1+MAE,ILEV
         DO I=IL1,IL2
             IF (XROW(I,L+1,ICDN) .GT. 0.0 .AND.
     1                ZMLWC(I,L,1)+ZMLWC(I,L,2) .GT. 0.0) THEN
                H2O=(ZMLWC(I,L,1)+ZMLWC(I,L,2))/
     1                                (XROW(I,L+1,ICDN)/ROAROW(I,L))
                RADCLD(I,L) = ((H2O/4.189)/RHOPW)**CUB*1.0E6
             END IF
         END DO
      END DO
      RETURN
      END
