      SUBROUTINE INTRSEC (   LEV,     ILEV,      ILG,      IL1,    IL2,
     1                      XROW,    RGRID,      NTR,      NTP,   IAE1,
     3                  AEROSIZE,      RTH,    NN,   ADT2,  RHOP0,XIAO,
     4                     ISIZE,   RTCOND,  AERONUM,  ROAROW,  V, MAE)
C------------------------------------------------------------------------
C     PURPOSE
C     -------
C     - THIS MODULE COMPUTES INTERSECTIONAL TRANSPORT OF AEROSOLS DUE TO
C       COMDENSATION OR CLOUD PROCESSES
C                                                                                   
C     HISTORY:
C     --------
C     *
C     * AUG 11/97 - S.L. GONG   FIRST VERSION
C    
C    INPUT:  
C    ------
C
C    RTCOND - MASS TRANSFER RATE ONTO EACH PARTICLE SIZE BIN
C      XROW - TRACER CONCENTRATION IN EACH BIN BEFORE INTERSECTION TRANPORT
C    TOTMAS - TOTAL MASS OF AEROSOL IN EACH BIN
C     RGRID - INITIAL CONCENTRATION OF TRACERS IN EACH BIN
C
C    OUTPUT:
C    -------
C    
C      XROW - TRACER CONCENTRATION IN EACH BIN AFTER INTERSECTION TRANPORT 
C
C------------------------------------------------------------------------
      COMMON /PARAMS/ WW,TW,RAYON,ASQ,G,RGAS,RGOCP,RGOASQ,CPRES
      COMMON /PARAMS/ RGASV,CPRESV
      COMMON /NARCM/  AVO, RGASi, AIRMW, BOLTZK,  PI,  A
      COMMON /PARAM1/ PAI, RVORD, TFREZ,     HS,  HV, DAYLNT

      REAL AERONUM (ILG, ILEV,ISIZE), ROAROW(ILG,ILEV)      
      REAL RTCOND(ILG, ILEV,ISIZE)
      REAL XROW (ILG, LEV, NTR), RGRID(ILG, ILEV, NTR)
      REAL AEROSIZE(2,ISIZE), V(ISIZE) 
      REAL RTH(ILG,ILEV,ISIZE), RHOP0(NTP)
      DO K=1,ISIZE
        DO NP=1,NTP
           IK=(NP-1)*ISIZE+K+(IAE1-1)
           DO L=1+MAE,ILEV
              DO IL=IL1,IL2
                 RGRID(IL,L,IK)=XROW(IL,L+1,IK)
              END DO
           END DO
        END DO
      END DO
C
C     CONDENSATION RATE
C
      DO N=1,ISIZE
        CALL PUTZERO(RTH, ILG*ILEV*ISIZE)
        DO K=N,ISIZE
          DO L=1+MAE,ILEV
            DO I=IL1,IL2
              IF(AERONUM(I,L,N)*ROAROW(I,L) .GT. XIAO .AND.
     1                                 RTCOND(I,L,N) .GT. 0.0 ) THEN
                 RCOND=RTCOND(I,L,N)
C
C     NEW DRY VOLUME OF SIZE BIN N
C
c                 print *, AERONUM(I,L,N),RHOP0(NN),nn
                 VOIJ=V(N)+RCOND*ADT2/(AERONUM(I,L,N)*RHOP0(NN))
                 VOK=V(K)
                 IF (K .EQ. ISIZE .AND. VOIJ .GE. VOK) THEN
                    RTH(I,L,K)=1.0
                 END IF
                 IF (K .LT. ISIZE) THEN
                    VOKP1=V(K+1)
c                    print *, VOIJ,VOKP1,VOK
                    RTH(I,L,K)=CVMGT(VOK/VOIJ*(VOKP1-VOIJ)/(VOKP1-VOK),
     1                RTH(I,L,K), VOIJ .GE. VOK .AND. VOIJ .LT. VOKP1)
                 END IF
                 IF (K .GT. 1 ) THEN
                    VOKM1=V(K-1)
                    RTH(I,L,K)=CVMGT(1.-RTH(I,L,K-1), RTH(I,L,K),
     1                   VOIJ .GT. VOKM1 .AND. VOIJ .LT. VOK)
                 END IF
               END IF
            END DO
          END DO
          DO NT=1,NTP
            NO= N+ISIZE*(NT-1)+(IAE1-1)
            NK= K+ISIZE*(NT-1)+(IAE1-1)
            DO L=1+MAE,ILEV
              DO I=IL1,IL2
                IF (RTH(I,L,K) .GT. 0.0) THEN
C
C     ZERO BIN N FOR RE-DISTRIBUTION
C
                  IF (N.EQ.K) XROW(I,L+1,NO)=AMAX1(0.0,
     1                                     XROW(I,L+1,NO)-RGRID(I,L,NO))
C
C     DISTRIBUTED INTO BIN K ....
C
                  XROW(I,L+1,NK)=XROW(I,L+1,NK)+RGRID(I,L,NO)*RTH(I,L,K)
                  IF(NT .EQ. NN) XROW(I,L+1,NK)=XROW(I,L+1,NK)+
     1                                     RTH(I,L,K)*RTCOND(I,L,N)*ADT2       
                END IF
              END DO
            END DO
          END DO
        END DO
      END DO
      
      RETURN
      END
