      SUBROUTINE CONDSOA (   LEV,     ILEV,      ILG,      IL1,    IL2, 
     1                     RGRID,  AERONUM,     XROW,      NTR,    NTP,
     2                    ROAROW,       NN, AEROSIZE,     JLAT,  ISIZE,
     3                      DELT,   RTCOND,      RTH,     IAE1,   PVOL,
     4                      TMIN,    PCOND,    RHOP0,      SOA,    CAM,
     5                       MAE)
C------------------------------------------------------------------------------
C     PURPOSE: 
C     --------
C     SOA CONDENSATION ROUTINE
C     HISTORY:                                                                  
C     --------                                                                  
C     * AUG 29/99 - S.L. GONG  USE THE SAME FRACTION OF SUPHATE CONDENSATION
C     *                        INTO EACH BIN FOR THE TOTAL SOA.
C     *
C
C     SUBROUTINE CALLED FROM CAM_V01
C  -----------------------------------------------------------------
      IMPLICIT NONE
      INTEGER ILG, ILEV,ISIZE,NTR,LEV,NTP,N,L,I,IL1,IL2,IAE1,JLAT,NN,MAE

      REAL ADT2,DELT,COND,TMIN,CAM
      REAL PCOND(ILG,ILEV,ISIZE), RTCOND(ILG,ILEV,ISIZE)
      REAL RGRID(ILG, ILEV, NTR), RTH(ILG,ILEV,ISIZE)   
      REAL XROW (ILG, LEV, NTR)
      REAL SOA (ILG,ILEV), ROAROW (ILG,ILEV) 
      REAL AEROSIZE(2,ISIZE)
      REAL AERONUM(ILG,ILEV,ISIZE), RHOP0(NTP), PVOL(ISIZE)
      REAL XIAO
      DATA XIAO/1.E3/

      ADT2=2.*DELT
C
C     CONDENSATION RATE OF SOA FOR EACH BIN
C
      DO N=1,ISIZE
         DO L=1+MAE,ILEV
            DO I=IL1,IL2
                COND=SOA(I,L)
                IF (COND .GT. 0. .AND. AERONUM(I,L,N)*ROAROW(I,L).GT.
     1                                                     XIAO) THEN
C
C      * RATE OF SOA CONDENSED TO EACH BIN
C
                   RTCOND(I,L,N)=PCOND (I,L,N)*COND
                ELSE
                   RTCOND(I,L,N)=0.0
                END IF 
            END DO
         END DO
      END DO

C
C       * CALL TO COMPUTE THE INTERSECTIONAL TRANSPORT DUE TO
C         CONDENSATION PROCESS.
C
      CALL INTRSEC (   LEV,     ILEV,      ILG,      IL1,    IL2,
     1                XROW,    RGRID,      NTR,      NTP,   IAE1,
     3            AEROSIZE,      RTH,       NN,     ADT2,  RHOP0,XIAO,
     4               ISIZE,   RTCOND,  AERONUM,   ROAROW,   PVOL,MAE)
      RETURN
      END