SUBROUTINE AD_UPSTREAM_INTERP(config_flags,    &
                              xstw,xstwb,ystw,ystwb,zstw,zstwb,  &
                              tracer,tracerb,number_tracer,      &
                              ah_tracer,ah_tracerb,              &
                              al_tracer,al_tracerb,              &
                              ids,ide,jds,jde,kds,kde, &
                              ims,ime,jms,jme,kms,kme, &
                              its,ite,jts,jte,kts,kte)
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!zhaisx writes at 20140923
!according to upstream_interp
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

IMPLICIT NONE

   INTEGER,INTENT(IN) :: ims,ime,jms,jme,kms,kme, &
                         ids,ide,jds,jde,kds,kde, &
                         its,ite,jts,jte,kts,kte,&
                         number_tracer
   INTEGER :: config_flags
   INTEGER :: i,j,k,kk
!wangh
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer) :: tracer
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme) :: xstw,ystw,zstw
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer) :: al_tracer,ah_tracer
   REAL,DIMENSION(:,:,:),allocatable :: a,aa,b
   REAL,DIMENSION(:,:,:),allocatable :: x,y,z
!zhaisx for adjoint 
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer) :: tracerb
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme) :: xstwb,ystwb,zstwb
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer) :: al_tracerb,ah_tracerb
   REAL,DIMENSION(:,:,:),allocatable :: ab,aab,bb
   REAL,DIMENSION(:,:,:),allocatable :: xb,yb,zb

   ALLOCATE(a(ims:ime,kms:kme,jms:jme))
   ALLOCATE(aa(ims:ime,kms:kme,jms:jme))
   ALLOCATE(b(ims:ime,kms:kme,jms:jme))
   ALLOCATE(x(ims:ime,kms:kme,jms:jme))
   ALLOCATE(y(ims:ime,kms:kme,jms:jme))
   ALLOCATE(z(ims:ime,kms:kme,jms:jme))

!zhaisx for adjoint
   ALLOCATE(ab(ims:ime,kms:kme,jms:jme))
   ALLOCATE(aab(ims:ime,kms:kme,jms:jme))
   ALLOCATE(bb(ims:ime,kms:kme,jms:jme))
   ALLOCATE(xb(ims:ime,kms:kme,jms:jme))
   ALLOCATE(yb(ims:ime,kms:kme,jms:jme))
   ALLOCATE(zb(ims:ime,kms:kme,jms:jme))

   a = 0.  
   aa = 0.  
   b = 0.  
   x = 0.  
   y = 0.  
   z = 0.  
   print*,'beginning of ad_upstream_interp'

      DO j=jts,jte
         DO k=kts,kte+1
            DO i=its,ite
               x(i,k,j)=xstw(i,k,j)
               y(i,k,j)=ystw(i,k,j)
               z(i,k,j)=zstw(i,k,j)
            ENDDO
         ENDDO
      ENDDO  
      
      DO j=jts,jte
         DO i=its,ite
            x(i,kts,j)=xstw(i,kts,j)
            x(i,kte+1,j)=xstw(i,kte,j)
            y(i,kts,j)=ystw(i,kts,j)
            y(i,kte+1,j)=ystw(i,kte,j)
            z(i,kts,j)=float(kts)
            z(i,kte+1,j)=float(kte+1)
         ENDDO
      ENDDO  

      aab(ims:ime, kms:kme, jms:jme) = 0.0  
      xb(ims:ime, kms:kme, jms:jme) = 0.0  
      yb(ims:ime, kms:kme, jms:jme) = 0.0  
      zb(ims:ime, kms:kme, jms:jme) = 0.0  
      ab(ims:ime, kms:kme, jms:jme) = 0.0  
      bb(ims:ime, kms:kme, jms:jme) = 0.0  

      print*,'al_tracerb(163,3,49,1)=',al_tracerb(163,3,49,1)

       DO kk=number_tracer,1,-1  
           DO j=jme,jms,-1
            DO k=kte+1,kts,-1
               DO i=ime,ims,-1  
                bb(i, k, j) = bb(i, k, j) + al_tracerb(i, k, j, kk)  
                al_tracerb(i, k, j, kk) = 0.0
               END DO
            END DO  
           END DO  
        
!        IF(sum(bb).ne.0.0)then
!        print*,'sum(bb)=',sum(bb)
!        ENDIF

        CALL POPREAL8ARRAY(aa, (ime+1-ims)*(kme+1-kms)*(jme+1-jms))

        CALL AD_NK1_LINEAR_INTERP(x,y,z,            &  
                                  aa, aab, b, bb,                &  
                                  ims,ime,jms,jme,kms,kme,       &
                                  ids,ide,jds,jde,kds,kde,       &
                                  its,ite,jts,jte,kts,kte,2)

!        IF(sum(aab).ne.0.0)then
!        print*,'sum(aab)=',sum(aab)
!        ENDIF

        DO j=jme,jms,-1
           DO k=kte+1,kts,-1
              DO i=ime,ims,-1  
                ab(i, k, j) = ab(i, k, j) + ah_tracerb(i, k, j, kk)  
                ah_tracerb(i, k, j, kk) = 0.0
              END DO  
           END DO  
        END DO 

!        IF(sum(ab).ne.0.0)then
!        print*,'sum(ab)=',sum(ab)
!        ENDIF

        CALL POPREAL8ARRAY(aa, (ime+1-ims)*(kme+1-kms)*(jme+1-jms))

        CALL AD_NK1_LINE_INTERP(config_flags, x, xb, y, yb, z&  
&                         , zb, aa, aab, a, ab, ids, ide, jds, jde, kds&  
&                         , kde, ims, ime, jms, jme, kms, kme, its, ite&  
&                         , jts, jte, kts, kte) 

!        print*,'sum(aab)=',sum(aab)
        DO j=jme,jms,-1
           DO k=kte+1,kts,-1
              DO i=ime,ims,-1  
                tracerb(i, k, j,kk) = tracerb(i, k, j,kk) + aab(i, k, j)  
                aab(i,k,j) = 0.0
              END DO  
           END DO  
        END DO 

      ENDDO !!kk
END SUBROUTINE AD_UPSTREAM_INTERP

!!!!!!!!!!!zhaisx writes at 20140923
!the following AD_NK1_LINE_INTERP and its corresponding subroutines are from
!dyn_grapes_zhanglin_adj/module_ad_semi_lag.F

SUBROUTINE AD_NK1_LINE_INTERP(ideal_flags, x, xb, y, yb, z, zb, u0, u0b, &  
&  b, bb, ids, ide, jds, jde, kds, kde, ims, ime, jms, jme, kms, kme, &  
&  its, ite, jts, jte, kts, kte)  
  IMPLICIT NONE  
  INTEGER,INTENT(IN) :: ids,ide,ims,ime,its,ite
  INTEGER,INTENT(IN) :: ideal_flags  
  INTEGER,INTENT(IN) :: jds,jde,jms,jme,jts,jte    
  INTEGER,INTENT(IN) :: kds,kde,kms,kme,kts,kte
  REAL :: b(ims:ime, kms:kme, jms:jme), bb(ims:ime, kms:kme, jms:jme), &  
&  u0(ims:ime, kms:kme, jms:jme), u0b(ims:ime, kms:kme, jms:jme),      &  
&  x(ims:ime, kms:kme, jms:jme), xb(ims:ime, kms:kme, jms:jme),        &  
&  y(ims:ime, kms:kme, jms:jme), yb(ims:ime, kms:kme, jms:jme),        &  
&  z(ims:ime, kms:kme, jms:jme), zb(ims:ime, kms:kme, jms:jme)  
  INTEGER :: i, ix, iy, iz, j, k, kk  
  REAL :: f0max, f0maxb, f0min, f0minb, f1, f1b, f2, f2b, f3, f3b&  
&  , f4, f4b, f5, f5b, f6, f6b, f7, f7b, f8, f8b, ust, ustb, x0&  
&  , x0b, y0, y0b, z0, z0b
  
   REAL, DIMENSION(32) :: f,fb
   REAL, DIMENSION(12) :: ftemp
   INTEGER :: branch
!zhaisx
   REAL :: dc1
   dc1=1.0d0
          
!----------------------------adjoint--------------  
  fb(1:32) = 0.0  
  ustb = 0.0  
   DO j=jte,jts,-1
      DO k=kte+1,kts,-1
         DO i=ite,its,-1  
                                                
                                                CALL POPINTEGER4(iz)  
                        CALL POPINTEGER4(iy)  
                        CALL POPINTEGER4(ix)
                        
                        x0=x(i,k,j)-ix
            y0=y(i,k,j)-iy
            z0=z(i,k,j)-iz
            IF( ix == ide ) x0 = dc1
            IF( iy == jde ) y0 = dc1
                                                
            IF(ideal_flags == 2) THEN
                  IF(ix-1 >= ids .and. ix+2 <= ide &
                        .and. iz-1 >= kts .and.iz+2 <= kte)THEN                         
                        CALL POPREAL8(ust)
                        CALL POPREAL8ARRAY(ftemp,12)
                        f0max = MAXVAL(ftemp)
                f0min = MINVAL(ftemp)
                         
                        ustb = ustb + bb(i, k, j)  
                        bb(i, k, j) = 0.0  
  
                        IF (ust <= f0min) THEN  
                        f0minb = ustb  
                        ustb = 0.0  
                        END IF  
                        IF (ust >= f0max) THEN   
                        f0maxb = ustb  
                        ustb = 0.0  
                        END IF
                                                
                        fb(MAXLOC(ftemp)) = fb(MAXLOC(ftemp)) + f0maxb
                        fb(MINLOC(ftemp)) = fb(MINLOC(ftemp)) + f0minb
                        
                        z0b = 0.0  
                        x0b = 0.0 
                                                
                        CALL AD_QUSICUBIC2(ust, ustb, ix-1, ix, ix+1, ix+2, ix-1, ix&  
                                         , ix+1, ix+2, ix, ix+1, ix, ix+1, iz+1, iz+1, &  
                                         iz+1, iz+1, iz, iz, iz, iz, iz-1, iz-1, &  
                                         iz+2, iz+2, ftemp(1), fb(1), ftemp(2), fb(2), ftemp(3), &  
                                         fb(3), ftemp(4), fb(4), ftemp(5), fb(5), ftemp(6), fb(6), ftemp&  
                                         (7), fb(7), ftemp(8), fb(8), ftemp(9), fb(9), ftemp(10), fb&  
                                         (10), ftemp(11), fb(11), ftemp(12), fb(12), x0, x0b, z0&  
                                         , z0b, x(i, k, j), xb(i, k, j), z(i, k, j), zb(i, k, j))  
  
                        u0b(ix+1, iz+2, iy) = u0b(ix+1, iz+2, iy) + fb(12)  
                        fb(12) = 0.0  
                        u0b(ix, iz+2, iy) = u0b(ix, iz+2, iy) + fb(11)  
                        fb(11) = 0.0  
                        u0b(ix+1, iz-1, iy) = u0b(ix+1, iz-1, iy) + fb(10)  
                        fb(10) = 0.0  
                        u0b(ix, iz-1, iy) = u0b(ix, iz-1, iy) + fb(9)  
                        fb(9) = 0.0  
                        u0b(ix+2, iz, iy) = u0b(ix+2, iz, iy) + fb(8)  
                        fb(8) = 0.0  
                        u0b(ix+1, iz, iy) = u0b(ix+1, iz, iy) + fb(7)  
                        fb(7) = 0.0  
                        u0b(ix, iz, iy) = u0b(ix, iz, iy) + fb(6)  
                        fb(6) = 0.0  
                        u0b(ix-1, iz, iy) = u0b(ix-1, iz, iy) + fb(5)  
                        fb(5) = 0.0  
                        u0b(ix+2, iz+1, iy) = u0b(ix+2, iz+1, iy) + fb(4)  
                        fb(4) = 0.0  
                        u0b(ix+1, iz+1, iy) = u0b(ix+1, iz+1, iy) + fb(3)  
                        fb(3) = 0.0  
                        u0b(ix, iz+1, iy) = u0b(ix, iz+1, iy) + fb(2)  
                        fb(2) = 0.0  
                        u0b(ix-1, iz+1, iy) = u0b(ix-1, iz+1, iy) + fb(1)  
                        fb(1) = 0.0  
                        y0b = 0.0
              
                        ELSE  
          
                        ustb = ustb + bb(i, k, j)  
                        bb(i, k, j) = 0.0  
  
                        f1=u0(ix,iz,iy)
                f2=u0(ix+1,iz,iy)
                f3=u0(ix,iz,iy+1)
                f4=u0(ix+1,iz,iy+1)
                f5=u0(ix,iz+1,iy)
                f6=u0(ix+1,iz+1,iy)
                f7=u0(ix,iz+1,iy+1)
                f8=u0(ix+1,iz+1,iy+1)  
                        z0b = 0.0  
                        y0b = 0.0  
                        x0b = 0.0  
                        f8b = 0.0  
                        f7b = 0.0  
                        f6b = 0.0  
                        f5b = 0.0  
                        f4b = 0.0  
                        f3b = 0.0  
                        f2b = 0.0  
                        f1b = 0.0  
                        CALL AD_LINEARINPOLATION3(f1, f1b, f2, f2b, f3, f3b, f4, f4b&  
                &                               , f5, f5b, f6, f6b, f7, f7b, f8, f8b, x0&  
                &                               , x0b, y0, y0b, z0, z0b, ust, ustb)  
  
                        u0b(ix+1, iz+1, iy+1) = u0b(ix+1, iz+1, iy+1) + f8b  
                        u0b(ix, iz+1, iy+1) = u0b(ix, iz+1, iy+1) + f7b  
                        u0b(ix+1, iz+1, iy) = u0b(ix+1, iz+1, iy) + f6b  
                        u0b(ix, iz+1, iy) = u0b(ix, iz+1, iy) + f5b  
                        u0b(ix+1, iz, iy+1) = u0b(ix+1, iz, iy+1) + f4b  
                        u0b(ix, iz, iy+1) = u0b(ix, iz, iy+1) + f3b  
                        u0b(ix+1, iz, iy) = u0b(ix+1, iz, iy) + f2b  
                        u0b(ix, iz, iy) = u0b(ix, iz, iy) + f1b  
                        END IF
          ELSE 
                IF(ix-1 >= ids .and.ix+2 <= ide .and.  &
                  iy-1 >= jds .and.iy+2 <= jde .and.  &
                  iz-1 >= kts .and.iz+2 <= kte) THEN

                ustb = ustb + bb(i, k, j)  
                bb(i, k, j) = 0.0  
  
                CALL POPREAL8(ust)  
                CALL POPREAL8ARRAY(f, 32)  
        
                z0b = 0.0  
                y0b = 0.0  
                x0b = 0.0  
                CALL AD_QUSICUBIC3(ust, ustb, f, fb, ix, iy, iz, x(i, k, j), xb(i, k, j), &
                                   y(i, k, j), yb(i, k, j), z(i, k, j), zb(i, k, j), &
                                   x0, x0b, y0, y0b, z0, z0b)  



     
                u0b(ix+1, iz-1, iy+1) = u0b(ix+1, iz-1, iy+1) + fb(32)  
                fb(32) = 0.0  
                u0b(ix, iz-1, iy+1) = u0b(ix, iz-1, iy+1) + fb(31)  
                fb(31) = 0.0  
                u0b(ix+1, iz-1, iy) = u0b(ix+1, iz-1, iy) + fb(30)  
                fb(30) = 0.0  
                u0b(ix, iz-1, iy) = u0b(ix, iz-1, iy) + fb(29)  
                fb(29) = 0.0  
                u0b(ix+1, iz+2, iy+1) = u0b(ix+1, iz+2, iy+1) + fb(28)  
                fb(28) = 0.0  
                u0b(ix, iz+2, iy+1) = u0b(ix, iz+2, iy+1) + fb(27)  
                fb(27) = 0.0  
                u0b(ix+1, iz+2, iy) = u0b(ix+1, iz+2, iy) + fb(26)  
                fb(26) = 0.0  
                u0b(ix, iz+2, iy) = u0b(ix, iz+2, iy) + fb(25)  
                fb(25) = 0.0  
                u0b(ix+1, iz+1, iy+2) = u0b(ix+1, iz+1, iy+2) + fb(24)  
                fb(24) = 0.0  
                u0b(ix, iz+1, iy+2) = u0b(ix, iz+1, iy+2) + fb(23)  
                fb(23) = 0.0  
                u0b(ix+1, iz+1, iy-1) = u0b(ix+1, iz+1, iy-1) + fb(22)  
                fb(22) = 0.0  
                u0b(ix, iz+1, iy-1) = u0b(ix, iz+1, iy-1) + fb(21)  
                fb(21) = 0.0  
                u0b(ix+2, iz+1, iy) = u0b(ix+2, iz+1, iy) + fb(20)  
                fb(20) = 0.0  
                u0b(ix+1, iz+1, iy) = u0b(ix+1, iz+1, iy) + fb(19)  
                fb(19) = 0.0  
                u0b(ix, iz+1, iy) = u0b(ix, iz+1, iy) + fb(18)  
                fb(18) = 0.0  
                u0b(ix-1, iz+1, iy) = u0b(ix-1, iz+1, iy) + fb(17)  
                fb(17) = 0.0  
                u0b(ix+2, iz+1, iy+1) = u0b(ix+2, iz+1, iy+1) + fb(16)  
                fb(16) = 0.0  
                u0b(ix+1, iz+1, iy+1) = u0b(ix+1, iz+1, iy+1) + fb(15)  
                fb(15) = 0.0  
                u0b(ix, iz+1, iy+1) = u0b(ix, iz+1, iy+1) + fb(14)  
                fb(14) = 0.0  
                u0b(ix-1, iz+1, iy+1) = u0b(ix-1, iz+1, iy+1) + fb(13)  
                fb(13) = 0.0  
                u0b(ix+1, iz, iy+2) = u0b(ix+1, iz, iy+2) + fb(12)  
                fb(12) = 0.0  
                u0b(ix, iz, iy+2) = u0b(ix, iz, iy+2) + fb(11)  
                fb(11) = 0.0  
                u0b(ix+1, iz, iy-1) = u0b(ix+1, iz, iy-1) + fb(10)  
                fb(10) = 0.0  
                u0b(ix, iz, iy-1) = u0b(ix, iz, iy-1) + fb(9)  
                fb(9) = 0.0  
                u0b(ix+2, iz, iy) = u0b(ix+2, iz, iy) + fb(8)  
                fb(8) = 0.0  
                u0b(ix+1, iz, iy) = u0b(ix+1, iz, iy) + fb(7)  
                fb(7) = 0.0  
                u0b(ix, iz, iy) = u0b(ix, iz, iy) + fb(6)  
                fb(6) = 0.0  
                u0b(ix-1, iz, iy) = u0b(ix-1, iz, iy) + fb(5)  
                fb(5) = 0.0  
                u0b(ix+2, iz, iy+1) = u0b(ix+2, iz, iy+1) + fb(4)  
                fb(4) = 0.0  
                u0b(ix+1, iz, iy+1) = u0b(ix+1, iz, iy+1) + fb(3)  
                fb(3) = 0.0  
                u0b(ix, iz, iy+1) = u0b(ix, iz, iy+1) + fb(2)  
                fb(2) = 0.0  
                u0b(ix-1, iz, iy+1) = u0b(ix-1, iz, iy+1) + fb(1)  
                fb(1) = 0.0  
          
        ELSE  

        
          ustb = ustb + bb(i, k, j)  
          bb(i, k, j) = 0.0  
      
          f1=u0(ix,iz,iy)
          f2=u0(ix+1,iz,iy)
          f3=u0(ix,iz,iy+1)
          f4=u0(ix+1,iz,iy+1)
          f5=u0(ix,iz+1,iy)
          f6=u0(ix+1,iz+1,iy)
          f7=u0(ix,iz+1,iy+1)
          f8=u0(ix+1,iz+1,iy+1)   
          z0b = 0.0  
          y0b = 0.0  
          x0b = 0.0  
          f8b = 0.0  
          f7b = 0.0  
          f6b = 0.0  
          f5b = 0.0  
          f4b = 0.0  
          f3b = 0.0  
          f2b = 0.0  
          f1b = 0.0  
          CALL AD_LINEARINPOLATION3(f1, f1b, f2, f2b, f3, f3b, f4, f4b, &  
&                             f5, f5b, f6, f6b, f7, f7b, f8, f8b, x0, &  
&                             x0b, y0, y0b, z0, z0b, ust, ustb)  
  
          u0b(ix+1, iz+1, iy+1) = u0b(ix+1, iz+1, iy+1) + f8b  
          u0b(ix, iz+1, iy+1) = u0b(ix, iz+1, iy+1) + f7b  
          u0b(ix+1, iz+1, iy) = u0b(ix+1, iz+1, iy) + f6b  
          u0b(ix, iz+1, iy) = u0b(ix, iz+1, iy) + f5b  
          u0b(ix+1, iz, iy+1) = u0b(ix+1, iz, iy+1) + f4b  
          u0b(ix, iz, iy+1) = u0b(ix, iz, iy+1) + f3b  
          u0b(ix+1, iz, iy) = u0b(ix+1, iz, iy) + f2b  
          u0b(ix, iz, iy) = u0b(ix, iz, iy) + f1b  
        END IF
        END IF
  
        IF ( iy==jde ) y0b = 0.0  
        IF ( ix==ide ) x0b = 0.0  
  
        zb(i, k, j) = zb(i, k, j) + z0b  
        yb(i, k, j) = yb(i, k, j) + y0b  
        xb(i, k, j) = xb(i, k, j) + x0b  
  
      END DO  
    END DO  
  END DO  
    
END SUBROUTINE AD_NK1_LINE_INTERP


SUBROUTINE ad_qusicubic3(ust, ustb, f, fb, ix, iy, iz, xp, xpb, yp, ypb, &  
&  zp, zpb, x0, x0b, y0, y0b, z0,z0b)  
  IMPLICIT NONE  
  REAL, DIMENSION(32),INTENT(IN) :: f  
  INTEGER,INTENT(IN) :: ix  
  INTEGER,INTENT(IN) :: iy  
  INTEGER,INTENT(IN) :: iz  
  REAL,INTENT(OUT) :: ust  
  REAL,INTENT(IN) :: x0  
  REAL,INTENT(IN) :: xp  
  REAL :: fb(32), ustb, x0b, xpb, y0b, ypb, zpb  
  REAL,INTENT(IN) :: y0  
  REAL,INTENT(IN) :: yp  
  REAL,INTENT(IN) :: z0  
  REAL,INTENT(IN) :: zp  
  REAL z0b  
  
  REAL :: ust1, ust1b, ust2, ust2b, ust3, ust3b, ust4, ust4b  
  
  CALL POPREAL8(ust)
  CALL POPREAL8(ust4)
  CALL POPREAL8(ust3)
  CALL POPREAL8(ust2)
  CALL POPREAL8(ust1)
    
  ust4b = 0.0  
  ust3b = 0.0  
  ust2b = 0.0  
  ust1b = 0.0
  
  CALL ad_maxmin(ust, ustb, f, fb)  
    
  CALL AD_CUBICLAGRANGIAN(ust, ustb, ust1, ust1b, ust2, ust2b, ust3, &  
&                   ust3b, ust4, ust4b, iz, iz + 1, iz + 2, iz - 1, zp, zpb)  
  
  CALL AD_LINEARINTERPOLATION2(ust4, ust4b, f(29), fb(29), f(30), fb(30)&  
&                        , f(31), fb(31), f(32), fb(32), x0, x0b, y0, &  
&                        y0b)  
  
  CALL AD_LINEARINTERPOLATION2(ust3, ust3b, f(25), fb(25), f(26), fb(26)&  
&                        , f(27), fb(27), f(28), fb(28), x0, x0b, y0, &  
&                        y0b)  
  
  CALL AD_QUSICUBIC2(ust2, ust2b, ix - 1, ix, ix + 1, ix + 2, ix - 1, ix, ix + 1, &  
&              ix + 2, ix, ix + 1, ix, ix + 1, iy + 1, iy + 1, iy + 1, iy + 1, iy, &  
&              iy, iy, iy, iy - 1, iy - 1, iy + 2, iy + 2, f(13), fb(13), f(&  
&              14), fb(14), f(15), fb(15), f(16), fb(16), f(17), fb(17)&  
&              , f(18), fb(18), f(19), fb(19), f(20), fb(20), f(21), fb(&  
&              21), f(22), fb(22), f(23), fb(23), f(24), fb(24), x0, x0b&  
&              , y0, y0b, xp, xpb, yp, ypb)  
  
  CALL AD_QUSICUBIC2(ust1, ust1b, ix - 1, ix, ix + 1, ix + 2, ix - 1, ix, ix + 1, &  
&              ix + 2, ix, ix + 1, ix, ix + 1, iy + 1, iy + 1, iy + 1, iy + 1, iy, &  
&              iy, iy, iy, iy - 1, iy - 1, iy + 2, iy + 2, f(1), fb(1), f(2)&  
&              , fb(2), f(3), fb(3), f(4), fb(4), f(5), fb(5), f(6), fb(&  
&              6), f(7), fb(7), f(8), fb(8), f(9), fb(9), f(10), fb(10)&  
&              , f(11), fb(11), f(12), fb(12), x0, x0b, y0, y0b, xp, xpb&  
&              , yp, ypb)  
END SUBROUTINE ad_qusicubic3



SUBROUTINE ad_qusicubic2(ust1, ust1b, x1, x2, x3, x4, x5, x6, x7, x8, x9&  
&  , x10, x11, x12, y1, y2, y3, y4, y5, y6, y7, y8, y9, y10, y11, y12, &  
&  f1, f1b, f2, f2b, f3, f3b, f4, f4b, f5, f5b, f6, f6b, f7, f7b, f8, &  
&  f8b, f9, f9b, f10, f10b, f11, f11b, f12, f12b, x0, x0b, y0,y0d, x, xb, y&  
&  , yb)  
  IMPLICIT NONE  
  REAL,INTENT(IN) :: f1  
  REAL,INTENT(IN) :: f10  
  REAL,INTENT(IN) :: f11  
  REAL,INTENT(IN) :: f12  
  REAL,INTENT(IN) :: f2  
  REAL,INTENT(IN) :: f3  
  REAL,INTENT(IN) :: f4  
  REAL,INTENT(IN) :: f5  
  REAL,INTENT(IN) :: f6  
  REAL :: f10b, f11b, f12b, f1b, f2b, f3b, f4b, f5b, f6b, f7b, f8b, f9b&  
&  , ust1b, x0b, xb, yb,y0d  
  REAL,INTENT(IN) :: f7  
  REAL,INTENT(IN) :: f8  
  REAL,INTENT(IN) :: f9  
  REAL,INTENT(OUT) :: ust1  
  REAL,INTENT(IN) :: x  
  REAL,INTENT(IN) :: x0  
  INTEGER,INTENT(IN) :: x1  
  INTEGER,INTENT(IN) :: x10  
  INTEGER,INTENT(IN) :: x11  
  INTEGER,INTENT(IN) :: x12  
  INTEGER,INTENT(IN) :: x2  
  INTEGER,INTENT(IN) :: x3  
  INTEGER,INTENT(IN) :: x4  
  INTEGER,INTENT(IN) :: x5  
  INTEGER,INTENT(IN) :: x6  
  INTEGER,INTENT(IN) :: x7  
  INTEGER,INTENT(IN) :: x8  
  INTEGER,INTENT(IN) :: x9  
  REAL,INTENT(IN) :: y  
  REAL,INTENT(IN) :: y0  
  INTEGER,INTENT(IN) :: y1  
  INTEGER,INTENT(IN) :: y10  
  INTEGER,INTENT(IN) :: y11  
  INTEGER,INTENT(IN) :: y12  
  INTEGER,INTENT(IN) :: y2  
  INTEGER,INTENT(IN) :: y3  
  INTEGER,INTENT(IN) :: y4  
  INTEGER,INTENT(IN) :: y5  
  INTEGER,INTENT(IN) :: y6  
  INTEGER,INTENT(IN) :: y7  
  INTEGER,INTENT(IN) :: y8  
  INTEGER,INTENT(IN) :: y9  
  REAL :: f1112, f1112b, f1234, f1234b, f5678, f5678b, f910, f910b  
  
!zhl added  

  CALL POPREAL8(f1112)
  CALL POPREAL8(f910)
  CALL POPREAL8(f5678)
  CALL POPREAL8(f1234)
  
  f1112b = 0.0  
  f910b = 0.0  
  f5678b = 0.0  
  f1234b = 0.0 
   
  CALL AD_CUBICLAGRANGIAN(ust1, ust1b, f1234, f1234b, f5678, f5678b, f910&  
&                   , f910b, f1112, f1112b, y1, y5, y9, y11, y, yb)  
  CALL AD_LINEARINPOLATION1(f1112, f1112b, f11, f11b, f12, f12b, x0, x0b)  
  CALL AD_LINEARINPOLATION1(f910, f910b, f9, f9b, f10, f10b, x0, x0b)  
  CALL AD_CUBICLAGRANGIAN(f5678, f5678b, f5, f5b, f6, f6b, f7, f7b, f8, &  
&                   f8b, x1, x2, x3, x4, x, xb)  
  CALL AD_CUBICLAGRANGIAN(f1234, f1234b, f1, f1b, f2, f2b, f3, f3b, f4, &  
&                   f4b, x1, x2, x3, x4, x, xb)  
END SUBROUTINE ad_qusicubic2

SUBROUTINE AD_CUBICLAGRANGIAN(f0, f0b, f1, f1b, f2, f2b, f3, f3b, f4, f4b&  
&  , x1, x2, x3, x4, x, xb)  
  IMPLICIT NONE  
  REAL,INTENT(OUT) :: f0  
  REAL,INTENT(IN) :: f1  
  REAL,INTENT(IN) :: f2  
  REAL :: f0b, f1b, f2b, f3b, f4b, xb  
  REAL,INTENT(IN) :: f3  
  REAL,INTENT(IN) :: f4  
  REAL,INTENT(IN) :: x  
  INTEGER,INTENT(IN) :: x1  
  INTEGER,INTENT(IN) :: x2  
  INTEGER,INTENT(IN) :: x3  
  INTEGER,INTENT(IN) :: x4  
  REAL :: a, ab, b, bb, c, cb, d, db, tempb, tempb0, tempb1, tempb10, &  
&  tempb2, tempb3, tempb4, tempb5, tempb6, tempb7, tempb8, tempb9  
  ab = f0b  
  bb = f0b  
  cb = f0b  
  db = f0b  
  tempb = db/((x4-x1)*(x4-x2)*(x4-x3))  
  tempb0 = (-x2+x)*(-x3+x)*tempb  
  tempb1 = (-x1+x)*f4*tempb  
  tempb2 = cb/((x3-x1)*(x3-x2)*(x3-x4))  
  tempb3 = (-x2+x)*(-x4+x)*tempb2  
  tempb4 = (-x1+x)*f3*tempb2  
  tempb5 = bb/((x2-x1)*(x2-x3)*(x2-x4))  
  tempb6 = (-x3+x)*(-x4+x)*tempb5  
  tempb7 = (-x1+x)*f2*tempb5  
  tempb8 = ab/((x1-x2)*(x1-x3)*(x1-x4))  
  tempb9 = (-x3+x)*(-x4+x)*tempb8  
  tempb10 = (-x2+x)*f1*tempb8  
  xb = xb + f1*tempb9 + (2*x-x3-x4)*tempb10 + f2*tempb6 + (2*x-x3-x4)*&  
&    tempb7 + f3*tempb3 + (2*x-x2-x4)*tempb4 + (2*x-x2-x3)*tempb1 + f4*&  
&    tempb0  
  f4b = f4b + (-x1+x)*tempb0  
  f3b = f3b + (-x1+x)*tempb3  
  f2b = f2b + (-x1+x)*tempb6  
  f1b = f1b + (-x2+x)*tempb9  
  f0b = 0.0  
END SUBROUTINE AD_CUBICLAGRANGIAN  

SUBROUTINE AD_LINEARINPOLATION1(f0, f0b, f1, f1b, f2, f2b, x0, x0b)  
  IMPLICIT NONE  
  REAL,INTENT(OUT) :: f0  
  REAL,INTENT(IN) :: f1  
  REAL,INTENT(IN) :: f2  
  REAL :: f0b, f1b, f2b, x0b  
  REAL,INTENT(IN) :: x0  
  x0b = x0b + (f2-f1)*f0b  
  f2b = f2b + x0*f0b  
  f1b = f1b + (1.+(-x0))*f0b  
  f0b = 0.0  
END SUBROUTINE AD_LINEARINPOLATION1  
  
SUBROUTINE ad_maxmin(f0, f0b, f, fb)  
  IMPLICIT NONE  
  REAL, DIMENSION(32),INTENT(IN) :: f  
  REAL,INTENT(INOUT) :: f0  
  REAL :: f0b 
  REAL :: max0, max0b, min0, min0b
  REAL, DIMENSION(32) :: fb
  
  max0 = MAXVAL(f)  
  min0 = MINVAL(f)
  
  IF (f0<min0) THEN  
    min0b = f0b  
    f0b = 0.0  
  ELSE  
    min0b = 0.0  
  END IF  
  IF (f0>max0) THEN
        max0b = f0b  
    f0b = 0.0       
  ELSE  
    max0b = 0.0  
  END IF

  fb(MAXLOC(f)) = fb(MAXLOC(f)) + max0b         
  fb(MINLOC(f)) = fb(MINLOC(f)) + min0b 
 
END SUBROUTINE ad_maxmin  

SUBROUTINE AD_LINEARINPOLATION3(f1, f1b, f2, f2b, f3, f3b, f4, f4b, f5, &  
&  f5b, f6, f6b, f7, f7b, f8, f8b, x0, x0b, y0, y0b, z0, z0b, f0, f0b)  
  IMPLICIT NONE  
  REAL,INTENT(OUT) :: f0  
  REAL,INTENT(IN) :: f1  
  REAL,INTENT(IN) :: f2  
  REAL,INTENT(IN) :: f3  
  REAL,INTENT(IN) :: f4  
  REAL,INTENT(IN) :: f5  
  REAL,INTENT(IN) :: f6  
  REAL,INTENT(IN) :: f7  
  REAL,INTENT(IN) :: f8  
  REAL,INTENT(IN) :: x0  
  REAL,INTENT(IN) :: y0  
  REAL,INTENT(IN) :: z0  
  REAL :: f0b, f1b, f2b, f3b, f4b, f5b, f6b, f7b, f8b, x0b, y0b, z0b  
  REAL :: t, t1, t1b, tb, u, u1, u1b, ub, v, v1, v1b, vb  
! 8 points surrounding to be interpolated  
! coorinates (0--1)to be interpolated  
!                     note: x0,y0,z0 must be >=0.  and  <1.  
! temp variable  
! -aint(x0)  
  t = x0  
! -aint(y0)  
  u = y0  
! -aint(z0)  
  v = z0  
  t1 = 1. - t  
  u1 = 1. - u  
  v1 = 1. - v  
  t1b = u*v*f7*f0b + u1*v*f5*f0b + u*v1*f3*f0b + u1*v1*f1*f0b  
  u1b = t*v*f6*f0b + t1*v*f5*f0b + t*v1*f2*f0b + t1*v1*f1*f0b  
  v1b = f4*t*u*f0b + f3*t1*u*f0b + f2*t*u1*f0b + f1*t1*u1*f0b  
  f1b = f1b + v1*t1*u1*f0b  
  tb = u*v*f8*f0b - t1b + u1*v*f6*f0b + u*v1*f4*f0b + u1*v1*f2*f0b  
  f2b = f2b + v1*t*u1*f0b  
  ub = t*v*f8*f0b - u1b + t1*v*f7*f0b + t*v1*f4*f0b + t1*v1*f3*f0b  
  f3b = f3b + v1*t1*u*f0b  
  f4b = f4b + v1*t*u*f0b  
  vb = f8*t*u*f0b - v1b + f7*t1*u*f0b + f6*t*u1*f0b + f5*t1*u1*f0b  
  f5b = f5b + v*t1*u1*f0b  
  f6b = f6b + v*t*u1*f0b  
  f7b = f7b + v*t1*u*f0b  
  f8b = f8b + v*t*u*f0b  
  z0b = z0b + vb  
  y0b = y0b + ub  
  x0b = x0b + tb  
  f0b = 0.0  
END SUBROUTINE AD_LINEARINPOLATION3  

SUBROUTINE AD_LINEARINTERPOLATION2(f0, f0b, f1, f1b, f2, f2b, f3, f3b, f4&  
&  , f4b, x0, x0b, y0, y0b)  
  IMPLICIT NONE  
  REAL,INTENT(OUT) :: f0  
  REAL,INTENT(IN) :: f1  
  REAL,INTENT(IN) :: f2  
  REAL :: f0b, f1b, f2b, f3b, f4b, x0b, y0b  
  REAL,INTENT(IN) :: f3  
  REAL,INTENT(IN) :: f4  
  REAL,INTENT(IN) :: x0  
  REAL,INTENT(IN) :: y0  
  REAL :: a, b, c, d  
  y0b = y0b + ((1.+(-x0))*f3-x0*f2-(1.+(-x0))*f1+f4*x0)*f0b  
  x0b = x0b + ((1.+(-y0))*f2-(1.+(-y0))*f1-y0*f3+f4*y0)*f0b  
  f4b = f4b + y0*x0*f0b  
  f3b = f3b + (1.+(-x0))*y0*f0b  
  f2b = f2b + (1.+(-y0))*x0*f0b  
  f1b = f1b + (1.+(-y0))*(1.+(-x0))*f0b  
  f0b = 0.0  
END SUBROUTINE AD_LINEARINTERPOLATION2    
