MODULE module_bs_qmsl

CONTAINS

SUBROUTINE BS_QMSL(dx,dy,&
                   ah_tracer,al_tracer,number_tracer,tracer,&
                   qmodify_tracer,&
                   xstw,ystw,zstw, &
                   ramdadw,phidw, &
                   ids,ide,jds,jde,kds,kde, &
                   ims,ime,jms,jme,kms,kme, &
                   its,ite,jts,jte,kts,kte)

IMPLICIT NONE
INTEGER, INTENT(IN) :: number_tracer
INTEGER, INTENT(IN) :: ids,ide,jds,jde,kds,kde, &
                       ims,ime,jms,jme,kms,kme, &
                       its,ite,jts,jte,kts,kte
!TYPE (grid_config_rec_type) , INTENT(IN) :: config_flags
REAL,DIMENSION(jms:jme),INTENT(in) :: dx,dy
REAL,DIMENSION(ims:ime,kms:kme,jms:jme), INTENT(IN) :: xstw,ystw,zstw
REAL,DIMENSION(ims:ime,kms:kme,jms:jme), INTENT(IN) :: ramdadw,phidw
!zhl added
REAL,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer), INTENT(IN) :: tracer
REAL,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer), INTENT(INOUT) :: ah_tracer,al_tracer
REAL,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer), INTENT(INOUT) :: qmodify_tracer

!Local working arrays

   INTEGER :: i,j,k
   INTEGER :: ix,iy,iz
   INTEGER :: ii,jj,kk,kkk
   INTEGER :: ist,ied,jst,jed,kst,ked
REAL,DIMENSION(:,:,:),allocatable :: x,y,z
!REAL,DIMENSION(:,:,:,:),allocatable :: rmax,rmin
!REAL,DIMENSION(:,:,:,:),allocatable :: QP,QM
!REAL,DIMENSION(:,:,:,:),allocatable :: PP,CCOEF
!REAL,DIMENSION(:,:,:,:),allocatable :: alfa_k
!REAL,DIMENSION(:,:,:),allocatable :: beta
!REAL,DIMENSION(:,:),allocatable :: ab
   REAL :: pi,xd,x0,yd,y0,ra
   REAL,DIMENSION(ids:ide) :: alon
   REAL,DIMENSION(jds:jde) :: alat
!
!zhl added
   REAL :: rmax_tracer,rmin_tracer,qp_tracer,qm_tracer,pp_tracer,CCOEF_tracer
!
   LOGICAL OFIRST
   data OFIRST/.true./
   INTEGER :: mrec
!
!
   ALLOCATE(x(ims:ime,kms:kme,jms:jme))
   ALLOCATE(y(ims:ime,kms:kme,jms:jme))
   ALLOCATE(z(ims:ime,kms:kme,jms:jme))
!   ALLOCATE(rmax(ims:ime,kms:kme,jms:jme,1:num_moist))
!   ALLOCATE(rmin(ims:ime,kms:kme,jms:jme,1:num_moist))
!
!   ALLOCATE(QP(ims:ime,kms:kme,jms:jme,1:num_moist))
!   ALLOCATE(QM(ims:ime,kms:kme,jms:jme,1:num_moist))
!   ALLOCATE(PP(ims:ime,kms:kme,jms:jme,1:num_moist))
!   ALLOCATE(CCOEF(ims:ime,kms:kme,jms:jme,1:num_moist))
!
   ra=6371000.
   pi = 4. * ATAN( 1. )
!   y0=config_flags%ys_sn
   y0=35.00
!   x0=config_flags%xs_we
   x0=15.25
!   yd=config_flags%yd
!   xd=config_flags%xd
   yd=0.5
   xd=0.5
   alon=0.0d0
   alat=0.0d0
!rmax=0.0d0
!rmin=0.0d0
x=0.0d0
y=0.0d0
z=0.0d0
!qp=0.0d0
!qm=0.0d0
!pp=0.0d0
!ccoef=0.0d0
!qmodify=0.0d0
!
   DO j=jds,jde
     alat(j)=(y0+(j-1)*yd)*PI/180.0+0.5*yd*PI/180.
   ENDDO
   DO i=ids,ide
     alon(i)=(x0+(i-1)*xd)*PI/180.0
   ENDDO
!
      DO j=jts,jte
         DO k=kts,kte+1
            DO i=its,ite
               x(i,k,j)=xstw(i,k,j)
               y(i,k,j)=ystw(i,k,j)
               z(i,k,j)=zstw(i,k,j)
            ENDDO
         ENDDO
      ENDDO
      DO j=jts,jte
         DO i=its,ite
            x(i,kts,j)=xstw(i,kts,j)
            x(i,kte+1,j)=xstw(i,kte,j)
            y(i,kts,j)=ystw(i,kts,j)
            y(i,kte+1,j)=ystw(i,kte,j)
            z(i,kts,j)=float(kts)
            z(i,kte+1,j)=float(kte+1)
         ENDDO
      ENDDO
!
!-------------------------------------------------------------
! DO kk=2,num_moist
!
   DO j=jts,jte
      DO k=kts,kte+1
         DO i=its,ite
!
            ix=int(x(i,k,j))
            iy=int(y(i,k,j))
            iz=min0(kte,int(z(i,k,j)))
!
            IF(ix < ids) ix = ids
            IF(ix > ide) ix = ide
            IF(iy < jds) iy = jds
            IF(iy > jde) iy = jde

            IF (iz.lt.kts) iz=kts
            IF ( ix==ide ) THEN
               ix=ide-1
            ENDIF
            IF ( iy==jde ) THEN
               iy=jde-1
            ENDIF
!
!Identify the grid element in which departure point is located
!
            IF(x(i,k,j)-ix>=0.0) THEN
               ist=ix
               ied=ix+1
            ELSE
               ist=ix-1
               ied=ix
            ENDIF
            IF(y(i,k,j)-iy>=0.0) THEN
               jst=iy
               jed=iy+1
            ELSE
               jst=iy-1
               jed=iy
            ENDIF
            IF(ix==ids) THEN
               ist=ids
               ied=ids+1
            ENDIF
            IF(ix==ide) THEN
               ist=ide-1
               ied=ide
            ENDIF
            IF(iy==jds) THEN
               jst=jds
               jed=jds+1
            ENDIF
            IF(iy==jde) THEN
               jst=jde-1
               jed=jde
            ENDIF
!
            IF(z(i,k,j)-iz>=0.0) THEN
               kst=iz
               ked=iz+1
            ELSE
               kst=iz-1
               ked=iz
            ENDIF
            IF(iz==kts) THEN
               kst=kts
               ked=kts+1
            ENDIF
            IF(iz==kte+1) THEN
               kst=kte
               ked=kte+1
            ENDIF
!
!Evaluate local Max and Min of tracer around the upstream position
!
!!zhl added
!      DO kk=1,num_moist
!        rmax(i,k,j,kk)=-1.0e-10
!        rmin(i,k,j,kk)=999999.0
!! DO kkk=kst,ked
!! DO ii=ist,ied
!! DO jj=jst,jed
!! if(moist(ii,kkk,jj,kk) >= rmax(i,k,j,kk)) &
!! rmax(i,k,j,kk)=moist(ii,kkk,jj,kk)
!! if(moist(ii,kkk,jj,kk) <= rmin(i,k,j,kk)) &
!! rmin(i,k,j,kk)=moist(ii,kkk,jj,kk)
!! ENDDO
!! ENDDO
!! ENDDO
!
!        DO ii=ist,ied
!           DO jj=jst,jed
!! rmax(i,k,j,kk)=amax1(moist(ix-1,k,iy-1,kk),moist(ix+1,k,iy-1,kk),&
!! moist(ix-1,k,iy+1,kk),moist(ix+1,k,iy+1,kk))
!! rmin(i,k,j,kk)=amin1(moist(ix-1,k,iy-1,kk),moist(ix+1,k,iy-1,kk),&
!! moist(ix-1,k,iy+1,kk),moist(ix+1,k,iy+1,kk))
!      if(moist(ii,k,jj,kk) >= rmax(i,k,j,kk)) &
!                               rmax(i,k,j,kk)=moist(ii,k,jj,kk)
!      if(moist(ii,k,jj,kk) <= rmin(i,k,j,kk)) &
!                               rmin(i,k,j,kk)=moist(ii,k,jj,kk)
!           ENDDO
!        ENDDO
!                               rmin(i,k,j,kk)=amax1(0.0,rmin(i,k,j,kk))
!
!!
!!QMSL
!!
!              qp(i,k,j,kk)=rmax(i,k,j,kk)-al(i,k,j,kk)
!              qm(i,k,j,kk)=rmin(i,k,j,kk)-al(i,k,j,kk)
!              pp(i,k,j,kk)=ah(i,k,j,kk)-al(i,k,j,kk)
!IF(pp(i,k,j,kk)>0.0d0) CCOEF(i,k,j,kk)=amin1(1.0,qp(i,k,j,kk)/pp(i,k,j,kk))
!IF(pp(i,k,j,kk)<0.0d0) CCOEF(i,k,j,kk)=amin1(1.0,qm(i,k,j,kk)/pp(i,k,j,kk))
!IF(pp(i,k,j,kk)==0.0d0) CCOEF(i,k,j,kk)=0.0d0
!!
!    qmodify(i,k,j,kk)=ccoef(i,k,j,kk)*(ah(i,k,j,kk)-al(i,k,j,kk))
!!zhl added
! ENDDO!---------------num_moist enddo
      DO kk=1,number_tracer
        rmax_tracer=-1.0e-10
        rmin_tracer=999999.0

        DO ii=ist,ied
           DO jj=jst,jed
      if(tracer(ii,k,jj,kk) >= rmax_tracer) &
                               rmax_tracer=tracer(ii,k,jj,kk)
      if(tracer(ii,k,jj,kk) <= rmin_tracer) &
                               rmin_tracer=tracer(ii,k,jj,kk)
           ENDDO
        ENDDO
                               rmin_tracer=amax1(0.0,rmin_tracer)
!
!QMSL
!
              qp_tracer=rmax_tracer-al_tracer(i,k,j,kk)
              qm_tracer=rmin_tracer-al_tracer(i,k,j,kk)
              pp_tracer=ah_tracer(i,k,j,kk)-al_tracer(i,k,j,kk)
IF(pp_tracer>0.0d0) CCOEF_tracer=amin1(1.0,qp_tracer/pp_tracer)
IF(pp_tracer<0.0d0) CCOEF_tracer=amin1(1.0,qm_tracer/pp_tracer)
IF(pp_tracer==0.0d0) CCOEF_tracer=0.0d0
!
    qmodify_tracer(i,k,j,kk)=ccoef_tracer*(ah_tracer(i,k,j,kk)-al_tracer(i,k,j,kk))
ENDDO  ! end number_tracer

!zhl added end

         ENDDO
      ENDDO
   ENDDO
!
! ENDDO !kk-loop
!<-- Shen

   DEALLOCATE(x)
   DEALLOCATE(y)
   DEALLOCATE(z)
!   DEALLOCATE(rmax)
!   DEALLOCATE(rmin)
!   DEALLOCATE(QP)
!   DEALLOCATE(QM)
!   DEALLOCATE(PP)
!   DEALLOCATE(CCOEF)
!

END SUBROUTINE BS_QMSL

END MODULE module_bs_qmsl
