SUBROUTINE upstream_interp(config_flags,   &
                           xstw,ystw,zstw, &
                           tracer,number_tracer, &
                           ah_tracer,al_tracer,  &
                           ids,ide,jds,jde,kds,kde, &
                           ims,ime,jms,jme,kms,kme, &
                           its,ite,jts,jte,kts,kte)

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!zhaisx 20140923
!zhaisx extracts from grapes_cuace_OK/dyn_grapes/module_semi_lag.F
!but adds two pushes due to the pops in AD_UPSTREAM_INTERP
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

   IMPLICIT NONE

   INTEGER,INTENT(IN) :: ims,ime,jms,jme,kms,kme, &
                         ids,ide,jds,jde,kds,kde, &
                         its,ite,jts,jte,kts,kte,&
                         number_tracer
!wangh
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer) :: tracer
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme) :: xstw,ystw,zstw
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer),INTENT(OUT) :: al_tracer,ah_tracer
   REAL,DIMENSION(:,:,:),allocatable :: a,aa,b
   REAL,DIMENSION(:,:,:),allocatable :: x,y,z
!zhaisx
   INTEGER :: config_flags,i,k,j,kk   

   ALLOCATE(a(ims:ime,kms:kme,jms:jme))
   ALLOCATE(aa(ims:ime,kms:kme,jms:jme))
   ALLOCATE(b(ims:ime,kms:kme,jms:jme))
   ALLOCATE(x(ims:ime,kms:kme,jms:jme))
   ALLOCATE(y(ims:ime,kms:kme,jms:jme))
   ALLOCATE(z(ims:ime,kms:kme,jms:jme))
   a=0.
   aa=0.
   b=0.
   x=0.
   y=0.
   z=0.


      DO j=jts,jte
         DO k=kts,kte+1
            DO i=its,ite
               x(i,k,j)=xstw(i,k,j)
               y(i,k,j)=ystw(i,k,j)
               z(i,k,j)=zstw(i,k,j)
            ENDDO
         ENDDO
      ENDDO
      DO j=jts,jte
         DO i=its,ite
            x(i,kts,j)=xstw(i,kts,j)
            x(i,kte+1,j)=xstw(i,kte,j)
            y(i,kts,j)=ystw(i,kts,j)
            y(i,kte+1,j)=ystw(i,kte,j)
            z(i,kts,j)=float(kts)
            z(i,kte+1,j)=float(kte+1)
         ENDDO
      ENDDO

   aa=0.
   a=0.
   b=0.
   al_tracer=0.
   ah_tracer=0.

     DO kk=1,number_tracer

            DO j=jms,jme
               DO k=kts,kte+1
                  DO i=ims,ime
                     aa(i,k,j)=tracer(i,k,j,kk)
                  END DO
               END DO
            END DO

            CALL nk1_line_interp(config_flags, &
                                 x,y,z,aa,a, &
                                 ids,ide,jds,jde,kds,kde, &
                                 ims,ime,jms,jme,kms,kme, &
                                 its,ite,jts,jte,kts,kte)

            CALL PUSHREAL8ARRAY(aa, (ime+1-ims)*(kte+3-kts)*(jme+1-jms))

!aa-a tracer upstream
!-->
            DO j=jms,jme
               DO k=kts,kte+1
                  DO i=ims,ime
                     ah_tracer(i,k,j,kk)=a(i,k,j)
                  END DO
               END DO
            END DO
            b=0.0d0
           CALL nk1_linear_interp(x,y,z,aa,b, &
                                 ims,ime,jms,jme,kms,kme, &
                                 ids,ide,jds,jde,kds,kde, &
                                 its,ite,jts,jte,kts,kte,2)

           CALL PUSHREAL8ARRAY(aa, (ime+1-ims)*(kme+1-kms)*(jme+1-jms))

            DO j=jms,jme
               DO k=kts,kte+1
                  DO i=ims,ime
                     al_tracer(i,k,j,kk)=b(i,k,j)
                  END DO
               END DO
            END DO
      ENDDO  !!!kk
   DEALLOCATE(a)
   DEALLOCATE(aa)
   DEALLOCATE(b)
   DEALLOCATE(x)
   DEALLOCATE(y)
   DEALLOCATE(z)

END SUBROUTINE upstream_interp


SUBROUTINE nk1_line_interp(ideal_flags,x,y,z,u0,b,    &
                           ids,ide,jds,jde,kds,kde,                      &
                           ims,ime,jms,jme,kms,kme,                      &
                           its,ite,jts,jte,kts,kte)

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!zhaisx 20140923
!zhaisx extract from dyn_grapes_zhanglin_adj/module_semi_lag.F
!becuace AD_NK1_LINE_INTERP has POPS, here we must correspondingly contain 
!PUSHS, thus extracting from dyn_grapes_zhanglin_adj
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   IMPLICIT NONE
   INTEGER,INTENT(IN)  :: ims,ime,jms,jme,kms,kme,     &
                          ids,ide,jds,jde,kds,kde,     &
                          its,ite,jts,jte,kts,kte
   INTEGER,INTENT(IN)  :: ideal_flags
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme) :: x,y,z,u0,b
   INTEGER :: i,j,k,kk,ix,iy,iz
   REAL :: x0,y0,z0,f1,f2,f3,f4,f5,f6,f7,f8,ust,f0max,f0min
   REAL, DIMENSION(32) :: f
   REAL, DIMENSION(12) :: ftemp
   REAL  :: dc1
   dc1= 1.0d0

   f=0.
   ftemp=0.

   DO j=jts,jte
      DO k=kts,kte+1
         DO i=its,ite

            ix=int(x(i,k,j))
            iy=int(y(i,k,j))
            iz=min0(kte,int(z(i,k,j)))
!
            IF(ix < ids) ix = ids
            IF(ix > ide) ix = ide
            IF(iy < jds) iy = jds
            IF(iy > jde) iy = jde

            IF( iz<kts ) iz=kts

            x0=x(i,k,j)-ix
            y0=y(i,k,j)-iy
            z0=z(i,k,j)-iz

            IF( ix == ide ) THEN
               ix = ide-1
               x0 = dc1
            ENDIF
            IF( iy==jde ) THEN
               iy=jde-1
               y0=dc1
            ENDIF
            
            IF(ideal_flags == 2) THEN
                IF(ix-1 >= ids .and. ix+2 <= ide &
                        .and. iz-1 >= kts .and.iz+2 <= kte)THEN
                  ftemp(1)=u0(ix-1,iz+1,iy)
                  ftemp(2)=u0(ix,iz+1,iy)
                  ftemp(3)=u0(ix+1,iz+1,iy)
                  ftemp(4)=u0(ix+2,iz+1,iy)
                  ftemp(5)=u0(ix-1,iz,iy)
                  ftemp(6)=u0(ix,iz,iy)
                  ftemp(7)=u0(ix+1,iz,iy)
                  ftemp(8)=u0(ix+2,iz,iy)
                  ftemp(9)=u0(ix,iz-1,iy)
                  ftemp(10)=u0(ix+1,iz-1,iy)
                  ftemp(11)=u0(ix,iz+2,iy)
                  ftemp(12)=u0(ix+1,iz+2,iy)
                  CALL qusicubic2(ust,ix-1,ix,ix+1,ix+2,ix-1,ix,ix+1,ix+2,&
                                  ix,ix+1,ix,ix+1,                    &
                                  iz+1,iz+1,iz+1,iz+1,iz,iz,iz,iz,    &
                                  iz-1,iz-1,iz+2,iz+2,                &
                                  ftemp(1),ftemp(2),ftemp(3),ftemp(4),ftemp(5),ftemp(6),ftemp(7), &
                                  ftemp(8),ftemp(9),ftemp(10),ftemp(11),ftemp(12),        &
                                  x0,z0,x(i,k,j),z(i,k,j))

                  
                  f0max = MAXVAL(ftemp)
                  f0min = MINVAL(ftemp)
                  ust = max(min(f0max, ust), f0min)
                  b(i,k,j)=ust
                  
                  CALL PUSHREAL8ARRAY(ftemp, 12)
                  CALL PUSHREAL8(ust)
                   
                ELSE
                  f1=u0(ix,iz,iy)
                  f2=u0(ix+1,iz,iy)
                  f3=u0(ix,iz,iy+1)
                  f4=u0(ix+1,iz,iy+1)
                  f5=u0(ix,iz+1,iy)
                  f6=u0(ix+1,iz+1,iy)
                  f7=u0(ix,iz+1,iy+1)
                  f8=u0(ix+1,iz+1,iy+1)                  

                  CALL Linearinpolation3(f1,f2,f3,f4,f5,f6,f7,f8,x0,y0,z0,ust)
                  b(i,k,j)=ust
                ENDIF
                
             ELSE 
                        IF(ix-1 >= ids .and.ix+2 <= ide .and.  &
                  iy-1 >= jds .and.iy+2 <= jde .and.  &
                  iz-1 >= kts .and.iz+2 <= kte) THEN

                  f(1)=u0(ix-1,iz,iy+1)
                  f(2)=u0(ix,iz,iy+1)
                  f(3)=u0(ix+1,iz,iy+1)
                  f(4)=u0(ix+2,iz,iy+1)
                  f(5)=u0(ix-1,iz,iy)
                  f(6)=u0(ix,iz,iy)
                  f(7)=u0(ix+1,iz,iy)
                  f(8)=u0(ix+2,iz,iy)
                  f(9)=u0(ix,iz,iy-1)
                  f(10)=u0(ix+1,iz,iy-1)
                  f(11)=u0(ix,iz,iy+2)
                  f(12)=u0(ix+1,iz,iy+2)
                  f(13)=u0(ix-1,iz+1,iy+1)
                  f(14)=u0(ix,iz+1,iy+1)
                  f(15)=u0(ix+1,iz+1,iy+1)
                  f(16)=u0(ix+2,iz+1,iy+1)
                  f(17)=u0(ix-1,iz+1,iy)
                  f(18)=u0(ix,iz+1,iy)
                  f(19)=u0(ix+1,iz+1,iy)
                  f(20)=u0(ix+2,iz+1,iy)
                  f(21)=u0(ix,iz+1,iy-1)
                  f(22)=u0(ix+1,iz+1,iy-1)
                  f(23)=u0(ix,iz+1,iy+2)
                  f(24)=u0(ix+1,iz+1,iy+2)
                  f(25)=u0(ix,iz+2,iy)
                  f(26)=u0(ix+1,iz+2,iy)
                  f(27)=u0(ix,iz+2,iy+1)
                  f(28)=u0(ix+1,iz+2,iy+1)
                  f(29)=u0(ix,iz-1,iy)
                  f(30)=u0(ix+1,iz-1,iy)
                  f(31)=u0(ix,iz-1,iy+1)
                  f(32)=u0(ix+1,iz-1,iy+1)
                  CALL  qusicubic3(ust, f, ix, iy,iz,x(i,k,j),y(i,k,j),z(i,k,j)&
                                   ,x0,y0,z0)
                                        CALL PUSHREAL8ARRAY(f, 32)  
                                        CALL PUSHREAL8(ust)
                  b(i,k,j)=ust
                  
                ELSE
                  f1=u0(ix,iz,iy)
                  f2=u0(ix+1,iz,iy)
                  f3=u0(ix,iz,iy+1)
                  f4=u0(ix+1,iz,iy+1)
                  f5=u0(ix,iz+1,iy)
                  f6=u0(ix+1,iz+1,iy)
                  f7=u0(ix,iz+1,iy+1)
                  f8=u0(ix+1,iz+1,iy+1)                  

                  CALL Linearinpolation3(f1,f2,f3,f4,f5,f6,f7,f8,x0,y0,z0,ust)
                  b(i,k,j)=ust
                  
                END IF
           END IF 
                
             CALL PUSHINTEGER4(ix)
             CALL PUSHINTEGER4(iy)
             CALL PUSHINTEGER4(iz)
               
         ENDDO
      ENDDO
   ENDDO

END SUBROUTINE nk1_line_interp
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!zhaisx 20140923
!the following subroutines used in nk1_line_interp are all from dyn_grapes_zhanglin_adj
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE qusicubic3(ust, f, ix, iy,iz,xp,yp,zp,x0,y0,z0)

   IMPLICIT NONE

   REAL,INTENT(IN) :: xp,yp,zp,x0,y0,z0
   INTEGER, INTENT(IN) :: ix,iy,iz
   REAL,DIMENSION(32),INTENT(IN) :: f
   REAL, INTENT(OUT) :: ust

   REAL :: ust1,ust2,ust3,ust4

         CALL qusicubic2(ust1,ix-1,ix,ix+1,ix+2,ix-1,ix,ix+1,ix+2,&
                  ix,ix+1,ix,ix+1,                    &
                  iy+1,iy+1,iy+1,iy+1,iy,iy,iy,iy,    &
                  iy-1,iy-1,iy+2,iy+2,                &
                  f(1),f(2),f(3),f(4),f(5),f(6),f(7)  &
                         ,f(8),f(9),f(10),f(11),f(12),&
                  x0,y0,xp,yp)
         CALL qusicubic2(ust2,ix-1,ix,ix+1,ix+2,ix-1,ix,ix+1,ix+2,&
                ix,ix+1,ix,ix+1,                    &
                iy+1,iy+1,iy+1,iy+1,iy,iy,iy,iy,    &
                iy-1,iy-1,iy+2,iy+2,                &
                f(13),f(14),f(15),f(16),f(17),f(18),f(19), &
                f(20),f(21),f(22),f(23),f(24),&
                x0,y0,xp,yp)
         CALL linearinterpolation2(ust3, f(25),f(26),f(27),f(28),x0,y0)
         CALL linearinterpolation2(ust4, f(29),f(30),f(31),f(32),x0,y0)
         CALL cubiclagrangian(ust,ust1,ust2,ust3,ust4,    &
                      iz,iz+1,iz+2,iz-1, zp)
         
         CALL PUSHREAL8(ust1)
         CALL PUSHREAL8(ust2)
         CALL PUSHREAL8(ust3)
         CALL PUSHREAL8(ust4)
         CALL PUSHREAL8(ust)
         
         CALL maxmin(ust,f)
         
END SUBROUTINE qusicubic3

SUBROUTINE qusicubic2(ust,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,x12,&
                          y1,y2,y3,y4,y5,y6,y7,y8,y9,y10,y11,y12,&
                          f1,f2,f3,f4,f5,f6,f7,f8,f9,f10,f11,f12, &
                          x0,y0,x,y)

IMPLICIT NONE
         INTEGER,INTENT(IN) :: x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,x12,&
                         y1,y2,y3,y4,y5,y6,y7,y8,y9,y10,y11,y12

         REAL,INTENT(IN) :: f1,f2,f3,f4,f5,f6,f7,f8,f9,f10,f11,f12,x0,y0,x,y
         REAL,INTENT(OUT) :: ust

   REAL :: f1234,f5678,f910,f1112
   REAL :: cublag,linear1
   
   cublag(f1,f2,f3,f4,x1,x2,x3,x4,x) =                                                                                          &
                                                                   (x-x2)*(x-x3)*(x-x4)/((x1-x2)*(x1-x3)*(x1-x4))*f1            &
                                                                 + (x-x1)*(x-x3)*(x-x4)/((x2-x1)*(x2-x3)*(x2-x4))*f2            &
                                                                 + (x-x1)*(x-x2)*(x-x4)/((x3-x1)*(x3-x2)*(x3-x4))*f3            &
                                                                 + (x-x1)*(x-x2)*(x-x3)/((x4-x1)*(x4-x2)*(x4-x3))*f4
   linear1(f1,f2,x0) = x0*f2+(1.-x0)*f1
   
   f1234 = cublag(f1,f2,f3,f4,x1,x2,x3,x4,x)
   
   f5678 = cublag(f5,f6,f7,f8,x1,x2,x3,x4,x)
   f910  = linear1(f9,f10,x0)
   f1112 = linear1(f11,f12,x0)
   ust   = cublag(f1234,f5678,f910,f1112,y1,y5,y9,y11,y)
   
   CALL PUSHREAL8(f1234)
         CALL PUSHREAL8(f5678)
         CALL PUSHREAL8(f910)
         CALL PUSHREAL8(f1112)

END SUBROUTINE qusicubic2

!----------------------------------------------------
SUBROUTINE cubiclagrangian(f0,f1,f2,f3,f4,x1,x2,x3,x4,x)
IMPLICIT NONE
REAL, INTENT(OUT) :: f0
REAL, INTENT(IN) :: f1,f2,f3,f4
INTEGER, INTENT(IN) :: x1,x2,x3,x4
REAL, INTENT(IN) :: x

REAL  :: a,b,c,d

a=(x-x2)*(x-x3)*(x-x4)/((x1-x2)*(x1-x3)*(x1-x4))*f1
b=(x-x1)*(x-x3)*(x-x4)/((x2-x1)*(x2-x3)*(x2-x4))*f2
c=(x-x1)*(x-x2)*(x-x4)/((x3-x1)*(x3-x2)*(x3-x4))*f3
d=(x-x1)*(x-x2)*(x-x3)/((x4-x1)*(x4-x2)*(x4-x3))*f4

f0=a+b+c+d


!zhl added CALL minmax1(f0,f1,f2,f3,f4)
END SUBROUTINE cubiclagrangian

SUBROUTINE minmax1(f0,f1,f2,f3,f4)
IMPLICIT NONE
REAL,INTENT(INOUT) :: f0
REAL,INTENT(IN) :: f1,f2,f3,f4
REAL,DIMENSION(4) :: f
INTEGER :: j
REAL :: fmin,fmax
f(1)=f1
f(2)=f2
f(3)=f3
f(4)=f4
fmin=f(1)
fmax=f(1)
DO j=2,4
   if(f(j) >= fmax) fmax=f(j)
   if(f(j) <= fmin) fmin=f(j)
ENDDO
  if(f0 >= fmax) f0=fmax
  if(f0 <= fmin) f0=fmin
END SUBROUTINE minmax1

SUBROUTINE linearinpolation1(f0,f1,f2,x0)

    IMPLICIT NONE

    REAL, INTENT(OUT) :: f0

    REAL,INTENT(IN) :: f1,f2,x0

    f0=x0*f2+(1.-x0)*f1


END SUBROUTINE linearinpolation1
!----------------------------------------
SUBROUTINE linearinterpolation2(f0, f1,f2,f3,f4,x0,y0)
 IMPLICIT NONE

 REAL, INTENT(IN) :: x0,y0,f1,f2,f3,f4
 REAL, INTENT(OUT) :: f0

 REAL :: a,b,c,d


   f0= y0*x0*f4+y0*(1.-x0)*f3+(1.-y0)*x0*f2+(1.-x0)*(1.-y0)*f1

 END SUBROUTINE linearinterpolation2
!--------------------------------------------------------
 SUBROUTINE maxmin(f0,f )

   IMPLICIT NONE
   REAL,DIMENSION(32),INTENT(IN) :: f
   REAL, INTENT(INOUT) :: f0
   REAL :: max0
   REAL :: min0         
        
   max0 = MAXVAL(f)
   min0 = MINVAL(f)
   
   f0 = min(max0, max(f0, min0))
   
END SUBROUTINE  maxmin

SUBROUTINE Linearinpolation3(f1,f2,f3,f4,f5,f6,f7,f8,x0,y0,z0,f0)
!     3 dimension linear interpolation
!         8 point locations:       f7  f8  
!                                                          f5  f6
!                                                                 *
!                                                          f3  f4         
!                                                          f1  f2
!          f1 is coordinated at (int(x0),int(y0),int(z0))
!

   IMPLICIT NONE
   REAL,INTENT(in)  :: f1,f2,f3,f4,f5,f6,f7,f8 
                                      ! 8 points surrounding to be interpolated
   REAL,INTENT(in)  :: x0,y0,z0   ! coorinates (0--1)to be interpolated
!                     note: x0,y0,z0 must be >=0.  and  <1.
   REAL,INTENT(out) :: f0
   REAL             :: t,u,v,t1,u1,v1  ! temp variable

   t=x0  ! -aint(x0)
   u=y0  ! -aint(y0)
   v=z0  ! -aint(z0)
   t1=1.-t
   u1=1.-u
   v1=1.-v

   f0=t1*u1*v1*f1+t*u1*v1*f2+t1*u*v1*f3+t*u*v1*f4   &
      +t1*u1*v*f5+t*u1*v*f6+t1*u*v*f7+t*u*v*f8

END SUBROUTINE Linearinpolation3



!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!zhaisx 20140923
!!!!the following nk1_linear_interp and corresponding codes are from 
!grapes_cuace_OK/dyn_grapes/module_semi_lag.F
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE nk1_linear_interp(x,y,z,u0,b, &
                           ims,ime,jms,jme,kms,kme, &
                           ids,ide,jds,jde,kds,kde, &
                           its,ite,jts,jte,kts,kte,nnn)
   IMPLICIT NONE
   INTEGER,INTENT(IN) :: ims,ime,jms,jme,kms,kme, &
                          ids,ide,jds,jde,kds,kde, &
                          its,ite,jts,jte,kts,kte,nnn
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme) :: x,y,z,u0,b
   INTEGER :: i,j,k,ix,iy,iz
   REAL :: x0,y0,z0,f1,f2,f3,f4,f5,f6,f7,f8,ust
   REAL :: dc1
   dc1 =1.0d0


   DO j=jts,jte
      DO k=kts,kte+1
         DO i=its,ite

            ix=int(x(i,k,j))

            iy=int(y(i,k,j))

            iz=min0(kte,int(z(i,k,j)))

            IF (iz.lt.kts) iz=kts

            x0=x(i,k,j)-ix
            y0=y(i,k,j)-iy
            z0=z(i,k,j)-iz

            IF ( ix==ite ) THEN
               ix=ite-1
               x0=dc1
            ENDIF
            IF ( iy==jte ) THEN
               iy=jte-1
               y0=dc1
            ENDIF

            f1=u0(ix,iz,iy)
            f2=u0(ix+1,iz,iy)
            f3=u0(ix,iz,iy+1)
            f4=u0(ix+1,iz,iy+1)
            f5=u0(ix,iz+1,iy)
            f6=u0(ix+1,iz+1,iy)
            f7=u0(ix,iz+1,iy+1)
            f8=u0(ix+1,iz+1,iy+1)


            CALL linear_intp(f1,f2,f3,f4,f5,f6,f7,f8,x0,y0,z0,ust)

            b(i,k,j)=ust


         ENDDO
      ENDDO
   ENDDO

END SUBROUTINE nk1_linear_interp

SUBROUTINE linear_intp(f1,f2,f3,f4,f5,f6,f7,f8,x0,y0,z0,f0)
! 3 dimension linear interpolation
! 8 point locations: f7 f8
! f5 f6
! *
! f3 f4
! f1 f2
! f1 is coordinated at (int(x0),int(y0),int(z0))
!

   IMPLICIT NONE
   REAL,INTENT(in) :: f1,f2,f3,f4,f5,f6,f7,f8
                                      ! 8 points surrounding to be interpolated
   REAL,INTENT(in) :: x0,y0,z0 ! coorinates (0--1)to be interpolated
! note: x0,y0,z0 must be >=0. and <1.
   REAL,INTENT(out) :: f0
   REAL :: t,u,v,t1,u1,v1 ! temp variable

   t=x0 ! -aint(x0)
   u=y0 ! -aint(y0)
   v=z0 ! -aint(z0)
   t1=1.-t
   u1=1.-u
   v1=1.-v

   f0=t1*u1*v1*f1+t*u1*v1*f2+t1*u*v1*f3+t*u*v1*f4 &
      +t1*u1*v*f5+t*u1*v*f6+t1*u*v*f7+t*u*v*f8

END SUBROUTINE linear_intp

