   !zhaisx writes at 2014.10.03 to prepare initialdata for adjoint model
   !PURPOSE: CONVERT SINGLE DATA TO DOUBLE DATA
!-----------------------------------------------------------------------------------------------------------   
   SUBROUTINE data_before_camaerosol(GSW,              &
                        ALBEDO,t_phy,               &
                        QV3D,QC3D,                  &
   !                     moist,      &
                        p_phy,p8w,dz8w,pi_phy,CLDFRA,      &
                        u_phy,v_phy,w, rho_phy,     & 
                        GMT,XTIME,DECLIN,SOLCON,   &
                        SNOW2D,ICE2D,                      &
                        prate1,prate2,raincv,rainncv,     & 
                        TMN,u10,v10,SMSTOT,fktm,           &
                        tracer,sfdust,  &
   ! wh for dust  
                        sand2,clay2,sand6,fland,emission,                 &
                        gdrem1,gdrem2,gdrem3,TU,                      &
                        umf3d,uer3d,udr3d,dmf3d,der3d,                  &
                        wrscav,zfprec,wpevpa,                           &
   !CSLG
                        cld_fn3d,ww3d,mc3d,dp3d, mb2d,esp02d,zfg3d,    &    
                        dsubcld2d,         &
   !zch 20100224 for PSO4 and PSOA
                        pso43d,psoa3d,                           &

                        ids,ide, jds,jde, kds,kde,                    &
                        ims,ime, jms,jme, kms,kme,                    &
                        its,ite, jts,jte, kts,kte,                    &
                        number_tracer,num_soil_texture,               &
                        num_clay,num_desert,                          &
                        num_landuse,num_emission,                     &
                        JULDAY,step) 
   
   INTEGER       ids,ide, jds,jde, kds,kde, &
                 ims,ime, jms,jme, kms,kme, &
                 its,ite, jts,jte, kts,kte

   INTEGER       number_tracer,num_tracer
   
   INTEGER       num_soil_texture

   INTEGER       num_clay
  
   INTEGER       num_desert 

   INTEGER       num_landuse

   INTEGER       num_emission

   INTEGER       JULDAY,itimestep  
  
   REAL*8, DIMENSION( ims:ime, jms:jme )                           &
          ::                                      GSW
   REAL*4, DIMENSION( ims:ime, jms:jme )                           &
          ::                                      GSW_s
   REAL*8, DIMENSION( ims:ime, jms:jme )                           &
          ::                                   &
                         u10,v10,TMN,SMSTOT,SNOW2D,ICE2D,albedo
   REAL*4, DIMENSION( ims:ime, jms:jme )                           &
          ::                                   &
                         u10_s,v10_s,TMN_s,SMSTOT_s,SNOW2D_s,ICE2D_s,albedo_s

   REAL*8, DIMENSION( ims:ime, kms:kme, jms:jme )  ::          &
                                                             p8w, &
                                                           p_phy, &
                                                          pi_phy, &
                                                           u_phy, &
                                                           v_phy, &
                                                               w, &
                                                         rho_phy, &
                                                          CLDFRA

   REAL*4, DIMENSION( ims:ime, kms:kme, jms:jme )  ::          &
                                                             p8w_s, &
                                                           p_phy_s, &
                                                          pi_phy_s, &
                                                           u_phy_s, &
                                                           v_phy_s, &
                                                               w_s, &
                                                         rho_phy_s, &
                                                          CLDFRA_s

   REAL*8,DIMENSION(ims:ime,jms:jme,num_soil_texture)              &
          ::                                     sand2
   REAL*4,DIMENSION(ims:ime,jms:jme,num_soil_texture)              &
          ::                                     sand2_s

   REAL*8,DIMENSION(ims:ime,jms:jme,num_clay)                      &
          ::                                     clay2
   REAL*4,DIMENSION(ims:ime,jms:jme,num_clay)                      &
          ::                                     clay2_s

   REAL*8,DIMENSION(ims:ime,jms:jme,num_desert)                    &
          ::                                     sand6
   REAL*4,DIMENSION(ims:ime,jms:jme,num_desert)                    &
          ::                                     sand6_s


   REAL*8,DIMENSION(ims:ime,jms:jme,num_landuse)                   &
          ::                                     fland
   REAL*4,DIMENSION(ims:ime,jms:jme,num_landuse)                   &
          ::                                     fland_s


   REAL*8,DIMENSION(ims:ime,jms:jme,num_emission)                   &
          ::                                     emission 
   REAL*4,DIMENSION(ims:ime,jms:jme,num_emission)                   &
          ::                                     emission_s 


   REAL*8, DIMENSION( ims:ime, kms:kme, jms:jme )       ::          &
                                                           t_phy, &
                                                             QV3D, &
                                                             QC3D  
   REAL*4, DIMENSION( ims:ime, kms:kme, jms:jme )       ::         &
                                                           t_phy_s, &
                                                             QV3D_s, &
                                                             QC3D_s  

   REAL*8,DIMENSION(ims:ime,kms:kme,jms:jme)                       &
          ::                                    umf3d, &
                                                           uer3d, &
                                                           udr3d, &
                                                           dmf3d, &
                                                           der3d
   REAL*4,DIMENSION(ims:ime,kms:kme,jms:jme)                       &
          ::                                    umf3d_s, &
                                                           uer3d_s, &
                                                           udr3d_s, &
                                                           dmf3d_s, &
                                                           der3d_s
   REAL*8,DIMENSION(ims:ime,kms:kme,jms:jme)                       &
          ::                                 cld_fn3d, &
                                                            ww3d, &
                                                            mc3d, &
                                                            dp3d, &
                                                           zfg3d, &
                                                           mc3db, &
                                                           dp3db, &
                                                          zfg3db 
   REAL*4,DIMENSION(ims:ime,kms:kme,jms:jme)                       &
          ::                                 cld_fn3d_s, &
                                                            ww3d_s, &
                                                            mc3d_s, &
                                                            dp3d_s, &
                                                           zfg3d_s, &
                                                           mc3db_s, &
                                                           dp3db_s, &
                                                          zfg3db_s 
   REAL*8, DIMENSION(ims:ime,kms:kme,jms:jme) ::   PSO43d
   REAL*8, DIMENSION(ims:ime,kms:kme,jms:jme) ::   PSOA3d
   REAL*4, DIMENSION(ims:ime,kms:kme,jms:jme) ::   PSO43d_s
   REAL*4, DIMENSION(ims:ime,kms:kme,jms:jme) ::   PSOA3d_s

   REAL*8,DIMENSION(ims:ime,jms:jme,number_tracer)                   &
          ::                                   sfdust,  &
                                                           gdrem1,  &
                                                           gdrem2,  &
                                                           gdrem3
   REAL*8, DIMENSION( ims:ime, kms:kme, jms:jme )                    &
          ::                                TU 
   REAL*4,DIMENSION(ims:ime,jms:jme,number_tracer)                   &
          ::                                   sfdust_s,  &
                                                           gdrem1_s,  &
                                                           gdrem2_s,  &
                                                           gdrem3_s
   REAL*4, DIMENSION( ims:ime, kms:kme, jms:jme )                    &
          ::                                TU_s 
   REAL*8, DIMENSION( ims:ime,  kms:kme,jms:jme )                &
          ::                                      prate1,&
                                                             prate2

   REAL*8, DIMENSION( ims:ime, kms:kme, jms:jme )              &
          ::                                wrscav,&
                                                       zfprec,&
                                                       wpevpa


   REAL*8, DIMENSION( ims:ime, jms:jme )                           &
          ::                                raincv,rainncv 
   REAL*4, DIMENSION( ims:ime,  kms:kme,jms:jme )                &
          ::                                      prate1_s,&
                                                             prate2_s

   REAL*4, DIMENSION( ims:ime, kms:kme, jms:jme )              &
          ::                                wrscav_s,&
                                                       zfprec_s,&
                                                       wpevpa_s


   REAL*4, DIMENSION( ims:ime, jms:jme )                           &
          ::                                raincv_s,rainncv_s

   REAL*8                                   GMT
   REAL*4                                   GMT_s 

   REAL*8, DIMENSION( ims:ime, jms:jme )                           &
          ::                             dsubcld2d,            &
                            esp02d,    mb2d
   REAL*4, DIMENSION( ims:ime, jms:jme )                           &
          ::                             dsubcld2d_s,            &
                            esp02d_s,    mb2d_s
   REAL*8        DEGRAD,             &
                                       XTIME,DECLIN,SOLCON
   REAL*4        DEGRAD_s,             &
                                       XTIME_s,DECLIN_s,SOLCON_s

   REAL*8,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer)            &
          ::           tracer  
   REAL*4,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer)            &
          ::           tracer_s  
   REAL*8, DIMENSION( ims:ime, kms:kme, jms:jme )::fktm,dz8w
   REAL*4, DIMENSION( ims:ime, kms:kme, jms:jme )::fktm_s,dz8w_s

   CHARACTER(LEN=3)::itimestepper

   write(itimestepper,'(i3)')step

   open(70,file='./../basic_fields/before_camaerosol'//trim(adjustl(itimestepper))//'.grd',form='unformatted')
          
               read(70)GSW_s,              &
                       ALBEDO_s,t_phy_s,               &
                       QV3D_s,QC3D_s,                  &
  !                     moist,      &
                       p_phy_s,p8w_s,dz8w_s,pi_phy_s,CLDFRA_s,      &
                       u_phy_s,v_phy_s,w_s, rho_phy_s,     & 
                       GMT_s,XTIME_s,DECLIN_s,SOLCON_s,   &
                       SNOW2D_s,ICE2D_s,                      &
                       prate1_s,prate2_s,raincv_s,rainncv_s,     & 
                       TMN_s,u10_s,v10_s,SMSTOT_s,fktm_s,           &
                       tracer_s,sfdust_s,  &
  ! wh for dust  
                       sand2_s,clay2_s,sand6_s,fland_s,emission_s,                 &
                       gdrem1_s,gdrem2_s,gdrem3_s,TU_s,                      &
                       umf3d_s,uer3d_s,udr3d_s,dmf3d_s,der3d_s,                  &
                       wrscav_s,zfprec_s,wpevpa_s,                           &
  !CSLG
                     cld_fn3d_s,ww3d_s,mc3d_s,dp3d_s, mb2d_s,esp02d_s,zfg3d_s,    &    
                     dsubcld2d_s,         &
  !zch 20100224 for PSO4 and PSOA
                        pso43d_s,psoa3d_s 
       close(70)
       
  GSW          =       GSW_s
  ALBEDO       =       ALBEDO_s
  t_phy        =       t_phy_s
  QV3D         =       QV3D_s 
  QC3D         =       QC3D_s
  p_phy        =       p_phy_s
  p8w          =       p8w_s
  dz8w         =       dz8w_s
  pi_phy       =       pi_phy_s
  CLDFRA       =       CLDFRA_s
  u_phy        =       u_phy_s
  v_phy        =       v_phy_s
  w            =       w_s
  rho_phy      =       rho_phy_s
  GMT          =       GMT_s
  XTIME        =       XTIME_s
  DECLIN       =       DECLIN_s
  SOLCON       =       SOLCON_s
  SNOW2D       =       SNOW2D_s
  ICE2D        =       ICE2D_s          
  prate1       =       prate1_s
  prate2       =       prate2_s
  raincv       =       raincv_s
  rainncv      =       rainncv_s   
  TMN          =       TMN_s
  u10          =       u10_s
  v10          =       v10_s
  SMSTOT       =       SMSTOT_s
  fktm         =       fktm_s     
  tracer       =       tracer_s
  sfdust       =       sfdust_s
  sand2        =       sand2_s
  clay2        =       clay2_s
  sand6        =       sand6_s
  fland        =       fland_s
  emission     =       emission_s               
  gdrem1=gdrem1_s
  gdrem2=gdrem2_s
  gdrem3=gdrem3_s
  TU     =      TU_s             
  umf3d=umf3d_s
  uer3d=uer3d_s
  udr3d=udr3d_s
  dmf3d=dmf3d_s
  der3d =    der3d_s               
  wrscav=wrscav_s
  zfprec=zfprec_s
  wpevpa =     wpevpa_s                       
  cld_fn3d=cld_fn3d_s
  ww3d=ww3d_s
  mc3d=mc3d_s
  dp3d =dp3d_s
  mb2d=mb2d_s
  esp02d=esp02d_s
  zfg3d  =     zfg3d_s   
  dsubcld2d =       dsubcld2d_s   
  pso43d=pso43d_s
  psoa3d =psoa3d_s

  END SUBROUTINE data_before_camaerosol

!-----------------------------------------------------------------------------------------------------------

  SUBROUTINE DATA_BEFORE_QMSL(ah_tracer,al_tracer,tracer,xstw,ystw,zstw,&
                        ids,ide, jds,jde, kds,kde,                    &
                        ims,ime, jms,jme, kms,kme,                    &
                        its,ite, jts,jte, kts,kte,                    &
                        number_tracer,num_soil_texture,               &
                        num_clay,num_desert,                          &
                        num_landuse,num_emission,                     &
                        JULDAY,step) 

   INTEGER       ids,ide, jds,jde, kds,kde, &
                 ims,ime, jms,jme, kms,kme, &
                 its,ite, jts,jte, kts,kte

   INTEGER       number_tracer,num_tracer
   
   INTEGER       num_soil_texture

   INTEGER       num_clay
  
   INTEGER       num_desert 

   INTEGER       num_landuse

   INTEGER       num_emission

   INTEGER       JULDAY,itimestep  

   REAL*8,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer) :: ah_tracer,al_tracer
   REAL*4,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer) :: ah_tracer_s,al_tracer_s
   REAL*8,DIMENSION(ims:ime,kms:kme,jms:jme) :: xstw,ystw,zstw
   REAL*4,DIMENSION(ims:ime,kms:kme,jms:jme) :: xstw_s,ystw_s,zstw_s

   CHARACTER(LEN=3)::itimestepper
   write(itimestepper,'(i3)')step

   open(71,file='./../basic_fields/before_qmsl'//trim(adjustl(itimestepper))//'.grd',form='unformatted')
   read(71)ah_tracer_s,al_tracer_s,tracer_s, & 
                  xstw_s,ystw_s,zstw_s
   close(71)
   ah_tracer=ah_tracer_s
   al_tracer=al_tracer_s
   tracer=tracer_s
   xstw=xstw_s
   ystw=ystw_s
   zstw=zstw_s

  END SUBROUTINE DATA_BEFORE_QMSL

!-----------------------------------------------------------------------------------------------------------

  SUBROUTINE DATA_BEFORE_PHY_PREP(tracer,   &
                        ids,ide, jds,jde, kds,kde,                    &
                        ims,ime, jms,jme, kms,kme,                    &
                        its,ite, jts,jte, kts,kte,                    &
                        number_tracer,num_soil_texture,               &
                        num_clay,num_desert,                          &
                        num_landuse,num_emission,                     &
                        JULDAY,step) 


   INTEGER       ids,ide, jds,jde, kds,kde, &
                 ims,ime, jms,jme, kms,kme, &
                 its,ite, jts,jte, kts,kte

   INTEGER       number_tracer,num_tracer
   
   INTEGER       num_soil_texture

   INTEGER       num_clay
  
   INTEGER       num_desert 

   INTEGER       num_landuse

   INTEGER       num_emission

   INTEGER       JULDAY,itimestep  

  REAL*8,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer)::tracer
  REAL*4,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer)::tracer_s

   CHARACTER(LEN=3)::itimestepper
   write(itimestepper,'(i3)')step
   open(72,file='./../basic_fields/before_phy_prep'//trim(adjustl(itimestepper))//'.grd',form='unformatted')
   read(72)tracer_s
   close(72)
  tracer=tracer_s
  END SUBROUTINE DATA_BEFORE_PHY_PREP

!-----------------------------------------------------------------------------------------------------------

  SUBROUTINE DATA_BEFORE_UPSTREAM_INTERP(xstw,ystw,zstw,tracer,ah_tracer,al_tracer,&
                        ids,ide, jds,jde, kds,kde,                    &
                        ims,ime, jms,jme, kms,kme,                    &
                        its,ite, jts,jte, kts,kte,                    &
                        number_tracer,num_soil_texture,               &
                        num_clay,num_desert,                          &
                        num_landuse,num_emission,                     &
                        JULDAY,step) 
  
   INTEGER       ids,ide, jds,jde, kds,kde, &
                 ims,ime, jms,jme, kms,kme, &
                 its,ite, jts,jte, kts,kte

   INTEGER       number_tracer,num_tracer
   
   INTEGER       num_soil_texture

   INTEGER       num_clay
  
   INTEGER       num_desert 

   INTEGER       num_landuse

   INTEGER       num_emission

   INTEGER       JULDAY,itimestep  

   REAL*8,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer) :: ah_tracer,al_tracer
   REAL*4,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer) :: ah_tracer_s,al_tracer_s
   REAL*8,DIMENSION(ims:ime,kms:kme,jms:jme) :: xstw,ystw,zstw
   REAL*4,DIMENSION(ims:ime,kms:kme,jms:jme) :: xstw_s,ystw_s,zstw_s

   CHARACTER(LEN=3)::itimestepper
   write(itimestepper,'(i3)')step
   open(73,file='./../basic_fields/before_upstream'//trim(adjustl(itimestepper))//'.grd',form='unformatted')
       read(73)xstw_s,ystw_s,zstw_s,tracer_s,ah_tracer_s,al_tracer_s
       close(73)

   ah_tracer=ah_tracer_s
   al_tracer=al_tracer_s
   tracer=tracer_s
   xstw=xstw_s
   ystw=ystw_s
   zstw=zstw_s

  END SUBROUTINE DATA_BEFORE_UPSTREAM_INTERP

