      SUBROUTINE OXISTR(     IL1,     IL2,    ILEV,    ILG,  ISIZE
     1                  ,    NTR,    ISO2,    IHPO,     NN,   IAE1
     2                  , ROAROW,  AGAMMA,  ASPECI, AGTSO2, AGTSO4
     3                  ,  AGTO3,  AGTCO2,  AGTNH3,AGTHNO3,  AGTNA
     4                  , AGTHO2,   AEQCA,   AEQCB,  AEQCC, AEQCBI
     5                  , AEQCHP,  AEQCHO,  AEQHNO, AEQNH3, AEQHCL
     6                  , AORHP1,  AORHP2,   AORHO, ANTSO2, ANTHO2
     7                  , ANTSO4,    XROW,  AOH2O2, ARESID,  ZMLWC
     8                  ,  CLDCV,   AFRAC,     AMH,  KCALC,  RTSO4
     9                  ,  RTHPO,   RCRIT, AMASPE, ASPRVA
     *                  , ASRSO2,  ASRHPO,    MAE)
C***********************************************************************
C     Calculates incloud-oxidation for stratiform clouds.
C***********************************************************************
C
C---  history
C     JANUARY 27, 1998 KNUT VON SALZEN     NEW SUBROUTINE
C     FEBRUARY 2, 1998 KNUT VON SALZEN     MODIFIED FOR GCM
C     FEBRUARY 4, 1998 S.L. GONG           VECTORIZED VERSION
C                                          EXTRACTED STRATIFORM PART
C     APRIL 20, 1998   KNUT VON SALZEN     CORRECTED
C
C-----------------------------------------------------------------------
C
      COMMON /TIMES/ DELT
C
      LOGICAL KCALC(ILG,ILEV)
      INTEGER INDTI,IND,IL,JK,N,NF
C
      INTEGER YSUB,YINDMX,ITERP
      PARAMETER ( YSUB   = 2 )
      PARAMETER ( YINDMX = 3 )
      PARAMETER ( ITERP = 3 )
      REAL YCOM3L,YRHOW
      PARAMETER ( YCOM3L = 1.E+03
     1           ,YRHOW  = 1.E+03 )
C
      REAL AMSO4,ATVAL,ADELTI,AFO3,AFH2O2,ATIMST,AMSO3
     1    ,AMNH4,AMNO3,AMNA,AMCL,AMO3,AGTHCL,ADELTA,AFRAH,AFRAS
     2    ,APARD,APARA,APARC,ATVALX,AMASPE(3)
      REAL AGAMMA(ILG,ILEV),CLDCV(ILG,ILEV)
     1    ,ARESID(ILG,ILEV),ASPECI(ILG,ILEV),AGTSO2(ILG,ILEV)
     2    ,AGTSO4(ILG,ILEV),AGTO3(ILG,ILEV),AGTCO2(ILG,ILEV)
     3    ,AGTNH3(ILG,ILEV),AGTHNO3(ILG,ILEV),AGTNA(ILG,ILEV)
     4    ,AGTHO2(ILG,ILEV),AEQCA(ILG,ILEV),AEQCB(ILG,ILEV)
     5    ,AEQCC(ILG,ILEV),AMH(ILG,ILEV)
     6    ,AEQCBI(ILG,ILEV),AEQCHP(ILG,ILEV),AEQCHO(ILG,ILEV)
     7    ,AEQHNO(ILG,ILEV),AEQNH3(ILG,ILEV),AEQHCL(ILG,ILEV)
     8    ,AORHP1(ILG,ILEV),AORHP2(ILG,ILEV),AORHO(ILG,ILEV)
     9    ,ANTSO2(ILG,ILEV),ANTHO2(ILG,ILEV),ANTSO4(ILG,ILEV)
      REAL ZMLWC(ILG,ILEV), RCRIT(ILG,ILEV), ROAROW(ILG,ILEV)
     1    ,AOH2O2(ILG,ILEV),AFRAC(ILG,ILEV,ISIZE)
     2    ,RTSO4(ILG,ILEV,ISIZE),RTHPO(ILG,ILEV)
     3    ,ASPRVA(ILG,ILEV),ASRSO2(ILG,ILEV),ASRHPO(ILG,ILEV)
      REAL XROW(ILG,ILEV+1,NTR)
C
C-----------------------------------------------------------------------
C
C     initial values and constants
C
C-----------------------------------------------------------------------
C
!      print *, 'call stroxi'
      ATIMST = 2. * DELT / REAL (YSUB)
      DO 5 K=1+MAE,ILEV
      DO 5 IL=IL1,IL2
         KCALC(IL,K) = .FALSE.
         AGAMMA(IL,K) = 0.
C         AMH(IL,K) = 0.1
         AMH(IL,K) = 1.
         ASRSO2(IL,K) = 0.
         ASRHPO(IL,K) = 0.
         ASPRVA(IL,K) = 0.
 5    CONTINUE
C
      DO 10 JK=1+MAE,ILEV
      DO 10 IL=IL1,IL2
C
C---     check for activation
c         ZMLWC(IL,JK)=1.e-2
c         CLDCV(IL,JK)=1.0
         IF (       (INT(RCRIT(IL,JK)) .GE. 1)
     1        .AND. (INT(RCRIT(IL,JK)) .LE. ISIZE)
     2        .AND. (ZMLWC(IL,JK) .GT. 1.E-06)
     3        .AND. (CLDCV(IL,JK) .GT. 1.E-03)         ) THEN
C     3        .AND. (CLDCV(IL,JK) .GT. 1.E-04)         ) THEN
            KCALC(IL,JK) = .TRUE.
            AGAMMA(IL,JK) = ZMLWC(IL,JK) * ROAROW(IL,JK) / YRHOW
!           print *, 'AGAMMA',ZMLWC(IL,JK),ROAROW(IL,JK),YRHOW,
!     +        AGAMMA(IL,JK),IL,JK, IL1, IL2,ILEV,mae
         END IF
 10   CONTINUE
C

      DO 30 JK=1+MAE,ILEV
      DO 30 IL=IL1,IL2
C
C---     sulphur dioxide. Conversion kg/kg -> mol/l
         ATVAL = XROW(IL,JK+1,ISO2) * ROAROW(IL,JK) / AMASPE(2)
         AGTSO2(IL,JK) = ATVAL / YCOM3L
!        if(XROW(IL,JK+1,ISO2).ne.0) then
!         print *, '11111', IL,JK,YCOM3L, AMASPE(2), 
!     +       ROAROW(IL,JK), XROW(IL,JK+1,ISO2),AGTHO2(IL,JK)
!           else
!           endif
C
C---     initial values EBI-method
         AOH2O2(IL,JK) = AGTHO2(IL,JK)
         ARESID(IL,JK) = 0.
         ASPECI(IL,JK) = 0.

!         print *, AGTHO2(IL,JK),AOH2O2(IL,JK),ARESID(IL,JK),
!     +        ASPECI(IL,JK)
 30   CONTINUE
C

      DO 35 N=1,ISIZE
         NF=ISIZE*(NN-1)+N+(IAE1-1)
         DO 36 L=1+MAE,ILEV
         DO 36 I=IL1,IL2
            IF ( KCALC(I,L) ) THEN
               IF (N .EQ. INT(RCRIT(I,L))) THEN
                  AGTSO4(I,L)= XROW(I,L+1,NF)*(1.-AMOD(RCRIT(I,L),1.))
     1                         *ROAROW(I,L) / AMASPE(1)/YCOM3L
               ELSE IF (N .GT. INT(RCRIT(I,L)))    THEN
                  AGTSO4(I,L)=AGTSO4(I,L)+XROW(I,L+1,NF)
     1                        *ROAROW(I,L) / AMASPE(1)/YCOM3L
               END IF

            END IF
 36      CONTINUE
 35   CONTINUE

C
C-----------------------------------------------------------------------
C
C     Euler Backward Iterations
C
C-----------------------------------------------------------------------
C
      DO 300 INDTI = 1, YSUB                  ! time
C
C---     initialization
         DO 310 JK=1+MAE,ILEV
         DO 310 IL=IL1,IL2
            IF ( KCALC(IL,JK) ) THEN
               ANTSO2(IL,JK) = AGTSO2(IL,JK)
               ANTHO2(IL,JK) = AGTHO2(IL,JK)
               ANTSO4(IL,JK) = AGTSO4(IL,JK)
!        if(AGTSO2(IL,JK).ne.0.and.IL.eq.28.and.JK.eq.30) then
!          print *,'22222', AGTSO2(IL,JK), ANTSO2(IL,JK)
!        endif
            END IF
 310     CONTINUE
C
C---     EBI-iteration
C
         DO 320 IND = 1, YINDMX            ! parameter update
         DO 320 JK=1+MAE,ILEV
         DO 320 IL=IL1,IL2
c --- zhouch add  AGAMMA(IL,JK).gt.0.
            IF ( KCALC(IL,JK) .and.AGAMMA(IL,JK).gt.0.) THEN
C
C---           approach for pH from Tremblay with additional iteration
               AMSO3 = 0.                             ! SO3(2-)
               AMNH4 = AGTNH3(IL,JK)  / AGAMMA(IL,JK) ! NH4(+)
               AMNO3 = AGTHNO3(IL,JK) / AGAMMA(IL,JK) ! NO3(-)
               AMSO4 = AGTSO4(IL,JK)  / AGAMMA(IL,JK) ! SO4(2-)
               AMNA  = AGTNA(IL,JK)   / AGAMMA(IL,JK) ! Na(+)
               AMCL  = MAX(AMNA - 2.E-06,0.)          ! Cl(-)
               AGTHCL = AMCL * AGAMMA(IL,JK)
!         print *,'0000', AGTNH3(IL,JK),AGTHNO3(IL,JK),
!     +          AGTSO4(IL,JK),AGTNA(IL,JK),AGAMMA(IL,JK),
!     +          IL, JK, IL1, IL2,ILEV 
C
C---           O3-concentrations
               ATVO3 = 1. / ( 1. + AGAMMA(IL,JK) * AEQCHO(IL,JK) )
               AMO3 = AGTO3(IL,JK) * ATVO3 * AEQCHO(IL,JK)
!          print *, '----',AGTO3(IL,JK),ATVO3 ,AEQCHO(IL,JK),
!     +         AMO3,AMNH4,AMNO3,AMSO4,AMNA,AMCL, IL,JK
C
C---           initial guess
               ADELTA = AMNO3 + 2. * (AMSO4 + AMSO3) + AMCL
     1                - AMNH4 - AMNA
               AMH(IL,JK) = 0.5 * ( ADELTA + SQRT (ADELTA**2
     1             + 4. * ( 1.E-14 + AEQCB(IL,JK) * AGTSO2(IL,JK)
     2             + AEQCBI(IL,JK) * AGTCO2(IL,JK) )) )
               AMH(IL,JK) = MAX (MIN(AMH(IL,JK),1.E-01), 1.E-10)
C
C---           SO2-, NH3-, and NO3-equilibrium parameters
               ATVAL = AEQCA(IL,JK) + AEQCB(IL,JK) / AMH(IL,JK)
     1               + AEQCC(IL,JK) / AMH(IL,JK)**2
               AFRAS = 1. / ( 1. + AGAMMA(IL,JK) * ATVAL )
               AFNH4 = (1.+AGTNH3(IL,JK)/(1./AEQNH3(IL,JK)
     1               + AGAMMA(IL,JK) * AMH(IL,JK)))**(-1)
               AFNO3 = AGTHNO3(IL,JK) / ( 1./AEQHNO(IL,JK)
     1               + AGAMMA(IL,JK) / AMH(IL,JK) )
C
C---           subsequent iterations for pH-calculation
               DO 1200 INDX = 1, ITERP
                  AFCL  = AGTHCL / ( 1./AEQHCL(IL,JK)
     1                  + AGAMMA(IL,JK) / AMH(IL,JK) )
                  AFHSO = AGTSO2(IL,JK) * AFRAS * AEQCB(IL,JK)
                  AFCO3 = AGTCO2(IL,JK) * AEQCBI(IL,JK)
                  AFOH  = 1.E-14
                  AMSO3 = ( AGTSO2(IL,JK) * AFRAS * AEQCC(IL,JK) )
     1                   / AMH(IL,JK)**2
                  ADELTA = AFNH4 * ( 2. * (AMSO4 + AMSO3) - AMNA )
                  AMH(IL,JK) = 0.5*(ADELTA + SQRT (ADELTA**2
     1                      + 4. * AFNH4 * (AFOH + AFCO3 + AFHSO
     2                      + AFNO3 + AFCL)))
C
C---              restrict pH to avoid numerical problems
                  AMH(IL,JK) = MAX (MIN(AMH(IL,JK),1.E-01), 1.E-10)
C
C---              SO2-, NH3-, and NO3-equilibrium parameters
                  ATVAL = AEQCA(IL,JK) + AEQCB(IL,JK) / AMH(IL,JK)
     1                  + AEQCC(IL,JK) / AMH(IL,JK)**2
                  AFRAS = 1. / ( 1. + AGAMMA(IL,JK) * ATVAL )
                  AFNH4 = (1.+AGTNH3(IL,JK)/(1./AEQNH3(IL,JK)
     1                  + AGAMMA(IL,JK) * AMH(IL,JK)))**(-1)
                  AFNO3 = AGTHNO3(IL,JK) / ( 1./AEQHNO(IL,JK)
     1                  + AGAMMA(IL,JK) / AMH(IL,JK) )
 1200          CONTINUE
C
C---           O3-oxidation rate parameter AFO3
               AFO3 = ( AORHP1(IL,JK) + AORHP2(IL,JK) / AMH(IL,JK) )
     1                * AMO3 * AFRAS * ATVAL
C
C---           H2O2-oxidation rate parameter AFH2O2
               AFRAH = 1. / ( 1. + AGAMMA(IL,JK) * AEQCHP(IL,JK) )
               AFH2O2 = ( AORHO(IL,JK) / (0.1 + AMH(IL,JK)) ) * AFRAS
     1                * AEQCA(IL,JK) * AFRAH * AEQCHP(IL,JK)
       
C
C              scavenging ratios
               ASRSO2(IL,JK) = 1. - AFRAS
               ASRHPO(IL,JK) = 1. - AFRAH
C
C---           new concentrations
               ATVAL = ATIMST * AGAMMA(IL,JK)
               APARD = AGTHO2(IL,JK)
               APARA = ( 1. + ATVAL * AFO3 ) * ATVAL * AFH2O2
               APARC = - AGTSO2(IL,JK)
!               print *, AGTSO2(IL,JK),  APARC, 'in ANTSO2'
               APARB = 1. + ATVAL * ( AFO3 + AFH2O2 * ( APARD + APARC) )
               ATVALX = - APARB / ( 2. * APARA )
!           print *,'ANTSO2', KCALC(IL,JK),ATIMST,AGAMMA(IL,JK),AFO3,
!     +           ATVAL,AFH2O2,APARD,APARC,APARA,IL,JK
               ANTSO2(IL,JK) = ATVALX
     1                       + SQRT ( ATVALX**2 - APARC / APARA )
             
!         if(AGTSO2(IL,JK).ne.0.and.IL.eq.28.and.JK.eq.30) then
!          print *, 'ANTSO2', ANTSO2(IL,JK),AGTSO2(IL,JK),IL,JK
!     +           , ATVALX,APARA,APARB,APARC
!         end if
               ANTHO2(IL,JK) = APARD
     1                      / ( 1. + ATVAL * AFH2O2 * ANTSO2(IL,JK) )
               ADELTA = AGTSO2(IL,JK) - ANTSO2(IL,JK)
               ANTSO4(IL,JK) = AGTSO4(IL,JK) + ADELTA
!            print *, 'ANTSO2',AGTSO2(IL,JK),ANTSO2(IL,JK),ATVALX, 
!     +        APARC, APARA,ADELTA
C
C---           diagnostic parameters
               ADELTI = ( (AFH2O2 * ANTHO2(IL,JK))
     1               / (AFH2O2 * ANTHO2(IL,JK) + AFO3) ) * ADELTA
               IF ( IND .EQ. YINDMX ) THEN
                  ASPECI(IL,JK) = ASPECI(IL,JK) + ADELTI
               END IF
            END IF
 320     CONTINUE
C
         DO 330 JK=1+MAE,ILEV
         DO 330 IL=IL1,IL2
            IF ( KCALC(IL,JK) ) THEN
               ADELTA =  AGTSO2(IL,JK) - ANTSO2(IL,JK)
!               print *, 
!     +  'in OXISTR', AGTSO2(IL,JK),ANTSO2(IL,JK),ADELTA
               ARESID(IL,JK) = ARESID(IL,JK) + ADELTA
C
C---           final concentrations after ATIMST
               AGTSO2(IL,JK) = ANTSO2(IL,JK)
               AGTHO2(IL,JK) = ANTHO2(IL,JK)
               AGTSO4(IL,JK) = ANTSO4(IL,JK)
            END IF
 330     CONTINUE
 300  CONTINUE
C
C-----------------------------------------------------------------------
C
C     results
C
C-----------------------------------------------------------------------
C
      DO 500 JK=1+MAE,ILEV
      DO 500 IL=IL1,IL2
         IF ( KCALC(IL,JK) ) THEN
C
C---        sulphate fraction produced by hydrogen peroxide
            ASPECI(IL,JK) = ASPECI(IL,JK) / MAX (ARESID(IL,JK),1.E-33)
            ASPECI(IL,JK) = MAX(ASPECI(IL,JK),0.)
C
C---        limitation of oxidation due to too low hydrogen peroxide
C---        concentrations
            IF ( AGTHO2(IL,JK) .LT. 0.) THEN
               print *, 
     +           'in OXISTR 2222',ARESID(IL,JK),AGTHO2(IL,JK)
               ARESID(IL,JK) = ARESID(IL,JK) + AGTHO2(IL,JK)
               AGTHO2(IL,JK) = 0.
            END IF
C
C---        limitation of oxidation due to too low sulphur dioxide
C---        concentrations
            ADELMS = XROW(IL,JK+1,ISO2) * ROAROW(IL,JK)
     1             / (AMASPE(2)*YCOM3L) - ARESID(IL,JK)
            IF ( ADELMS .LT. 0. ) THEN
!               print *, 'in OXISTR 3333',ADELMS
               ARESID(IL,JK) = ADELMS + ARESID(IL,JK)
            END IF
C
C---        additional sulphate in mol/kg
            ADELTA = CLDCV(IL,JK) * ARESID(IL,JK) * YCOM3L
     1             / ROAROW(IL,JK)
C
C---        sulphur dioxide in kg/kg/s
            ASPRVA(IL,JK) = - ( ADELTA * AMASPE(2) )
     1                     / ( 2. * DELT )
C
C---        hydrogen peroxide
            ADELTA = CLDCV(IL,JK) * (AGTHO2(IL,JK) - AOH2O2(IL,JK))
     1             * YCOM3L / ROAROW(IL,JK)
            RTHPO(IL,JK) = RTHPO(IL,JK) + ( ADELTA * AMASPE(3) )
     1                     / ( 2. * DELT )
         END IF
 500  CONTINUE
C
      DO N=1,ISIZE
         DO L=1+MAE,ILEV
            DO I=IL1,IL2
                IF (KCALC(I,L) .AND. (N .GE. INT(RCRIT(I,L))) .AND.
     1             XROW(I,L+1,ISO2) .GT. 0.0)    THEN
C
C---               sulphate in kg/kg/s
!       if(AFRAC(I,L,N).ne.0)  then 
!       print *, 'in OXISTR 1'
!       print *, I, L, AFRAC(I,L,N),CLDCV(I,L),ARESID(I,L),YCOM3L,
!     +          AMASPE(1),ROAROW(I,L),DELT
!       else
!       endif
!       if(ARESID(I,L).ne.0)  then 
!       print *, 'in OXISTR 2'
!       print *, I, L, AFRAC(I,L,N),CLDCV(I,L),ARESID(I,L),YCOM3L,
!     +          AMASPE(1),ROAROW(I,L),DELT
!       else
!       endif
                   RTSO4(I,L,N) = RTSO4(I,L,N) + ( AFRAC(I,L,N)
     1                            * CLDCV(I,L) * ARESID(I,L) * YCOM3L
     2                            * AMASPE(1) ) / ( ROAROW(I,L) * 2.
     3                            * DELT )
                END IF
            END DO
         END DO
      END DO
C
      RETURN
      END
