      SUBROUTINE OEQUIP (ILG,ILEV,IL1,IL2,AEQCA,AEQCB,AEQCC,AEQCAI
     1                  ,AEQCBI,AEQCHP,AEQCHO,AEQHNO,AEQNH3,AEQHCL
     2                  ,AORHP1,AORHP2,AORHO,ATEMP,MAE)
C***********************************************************************
C     Calculates Equilibrium Constants and Oxidation Rates.
C***********************************************************************
C
C---  history
C     FEBRUARY 2, 1998 KNUT VON SALZEN     NEW SUBROUTINE       
C
C-----------------------------------------------------------------------
C
      INTEGER JK,IL
      REAL AEQCA(ILG,ILEV),AEQCB(ILG,ILEV),AEQCC(ILG,ILEV)
     1    ,AEQCAI(ILG,ILEV),AEQCBI(ILG,ILEV),AEQCHP(ILG,ILEV)
     2    ,AEQCHO(ILG,ILEV),AEQHNO(ILG,ILEV),AEQNH3(ILG,ILEV)
     3    ,AEQHCL(ILG,ILEV),ATEMP(ILG,ILEV),AORHP1(ILG,ILEV)
     4    ,AORHP2(ILG,ILEV),AORHO(ILG,ILEV)
C
C-----------------------------------------------------------------------
C
      DO 100 JK=1+MAE,ILEV                                                      
      DO 100 IL=IL1,IL2                                 
         AEQCA(IL,JK)  = ATEMP(IL,JK) *
     1            1.0093E-01 * EXP (3120.*(1./ATEMP(IL,JK) - 1./298.))
         AEQCB(IL,JK)  = ATEMP(IL,JK) *
     1            1.7158E-03 * EXP (5210.*(1./ATEMP(IL,JK) - 1./298.))
         AEQCC(IL,JK)  = ATEMP(IL,JK) * 
     1            1.0295E-10 * EXP (6330.*(1./ATEMP(IL,JK) - 1./298.))
         AEQCAI(IL,JK) = ATEMP(IL,JK) *
     1            2.5520E-03 * EXP (2423.*(1./ATEMP(IL,JK) - 1./298.))
         AEQCBI(IL,JK) = ATEMP(IL,JK) *
     1            1.0973E-09 * EXP (1510.*(1./ATEMP(IL,JK) - 1./298.))
         AEQCHP(IL,JK) = ATEMP(IL,JK) *
     1            7.9595E+03 * EXP (6600.*(1./ATEMP(IL,JK) - 1./298.))
         AEQCHO(IL,JK) = ATEMP(IL,JK) *
     1            9.4366E-04 * EXP (2560.*(1./ATEMP(IL,JK) - 1./298.))
         AEQHNO(IL,JK) = ATEMP(IL,JK) *
     1           206.032E+03 * EXP ( 29.1657 * (298./ATEMP(IL,JK) - 1.) 
     2         + 16.8322 * (1. + ALOG (298./ATEMP(IL,JK)) 
     3                               - 298./ATEMP(IL,JK)) )
         AEQNH3(IL,JK) = ATEMP(IL,JK) *
     1           8.44851E+09 * EXP ( 34.8536 * (298./ATEMP(IL,JK) - 1.) 
     2          - 5.3930 * (1. + ALOG (298./ATEMP(IL,JK)) 
     3                               - 298./ATEMP(IL,JK)) )
         AEQHCL(IL,JK) = ATEMP(IL,JK) *
     1           161.675E+03 * EXP ( 30.2355 * (298./ATEMP(IL,JK) - 1.) 
     2         + 19.9083 * (1. + ALOG (298./ATEMP(IL,JK)) 
     3                               - 298./ATEMP(IL,JK)) )
         AORHP1(IL,JK) = 4.4E+11 * EXP ( -4131. / ATEMP(IL,JK) ) 
         AORHP2(IL,JK) = 2.6E+03 * EXP ( -966.  / ATEMP(IL,JK) )
         AORHO(IL,JK)  = 8.0E+04 
     1       * EXP ( -3650. * (1. / ATEMP(IL,JK) - 1. / 298.) )
 100  CONTINUE
C
      RETURN
      END
