C        Generated by TAPENADE     (INRIA, Tropics team)
C  Tapenade 3.5 (r3931) - 24 May 2011 16:28
C
C  Differentiation of drydepo in reverse (adjoint) mode:
C   gradient     of useful results: lai vdg pdepv rtdry ac usi
C                surfwd p throw gamma pdiff z0 ra pxnew gtrow xrow
C                thlev pllp fsnorow rcw dshj rsn0 rcg0 a0 rhsize
C                gdrem sfctrow rgw aest sicnrow rhrow adt2 rm0
C                scc rcut0 pressg roarow cldcv fland fsgrol seasn
C   with respect to varying inputs: lai vdg pdepv rtdry ac usi
C                surfwd p throw gamma pdiff z0 ra pxnew gtrow xrow
C                thlev pllp fsnorow rcw dshj rsn0 rcg0 a0 rhsize
C                gdrem sfctrow rgw aest sicnrow rhrow adt2 rm0
C                scc rcut0 pressg roarow cldcv fland fsgrol seasn
C   RW status of diff variables: lai:incr vdg:in-out pdepv:in-out
C                rtdry:in-out ac:incr usi:in-out surfwd:incr p:incr
C                throw:incr gamma:incr pdiff:incr z0:incr ra:in-out
C                pxnew:in-out gtrow:incr xrow:in-out thlev:incr
C                pllp:incr fsnorow:incr rcw:incr dshj:incr rsn0:incr
C                rcg0:incr a0:incr rhsize:incr gdrem:in-out sfctrow:incr
C                rgw:incr aest:incr sicnrow:incr rhrow:incr adt2:incr
C                rm0:incr scc:incr rcut0:incr pressg:incr roarow:incr
C                cldcv:incr fland:incr fsgrol:incr seasn:in-out
      SUBROUTINE DRYDEPO_B(ilev,    lev,    ilg,    il1,    il2,
     +                      vdg, surfwd,  gtrow,sfctrow,    mae,
     +                   fsgrol, deglat,  seasn,     ra,    usi,
     +                  sicnrow,fsnorow,  throw,  isize,    ntp,
     +                      ntr,   adt2, pressg,    shj,   tmin,
     +                    thlev, roarow,   rhop, rhsize,   iso2,
     +                     idms,  fland,   xrow, surfdg,  pdepv,
     +                    rtdry,  pxnew,   dshj,  gdrem,   iae1,
     +                    cldcv,  rhrow,   iday,   jlat,  pdiff,
     +                      luc,    cam,     ng,     ns,     ml, 
     +                     pllp,     z0,    scc,    rcw,     ac, 
     +                    cspec,    lai,    rm0,    zpd,   fcap,
     +                       wp,    rgw,   aest,  gamma,     a0,
     +                     rsn0,  rcut0,   rcg0,      p,                 
cccccccccccc  for ad model  ccccccccccccccccccc
     +                     vdgb,surfwdb, gtrowb,sfctrowb,  fsgrolb,
     +                   seasnb,    rab,   usib,sicnrowb, fsnorowb,
     +                   throwb,  adt2b,pressgb,  thlevb,  roarowb,
     +                  rhsizeb, flandb,  xrowb,  pdepvb,   rtdryb,
     +                   pxnewb,  dshjb, gdremb,  cldcvb,   rhrowb,
     +                   pdiffb,  pllpb,    z0b,    sccb,     rcwb,
     +                      acb,   laib,   rm0b,    rgwb,    aestb,
     +                   gammab,    a0b,  rsn0b,  rcut0b,    rcg0b,
     +                       pb)

      IMPLICIT NONE
      REAL rgas, g, rgocp, cpres, rgoasq, ww, tw, asq, rayon, qcc
      REAL qccb
      INTEGER ml, nn, n, l, np, ng0, i, isize, mae, ntp, ntr, lev
      REAL cpresv, rgasv, stdhi, adt2, cam, tmin
      REAL adt2b
      REAL avno, rgasi, am, boltzk, pi, a, a0, rsn0, rcut0, rcg0, p
      REAL a0b, rsn0b, rcut0b, rcg0b, pb
      INTEGER ilev, ilg, il1, il2, luc, jlat, ns, ng, iso2, idms, iday, 
     +        iae1
      COMMON /params/ ww, tw, rayon, asq, g, rgas, rgocp, rgoasq, cpres
     +, rgasv, cpresv
      REAL deglat(ilg), vdg(ilg, ng)
      REAL vdgb(ilg, ng)
      REAL thlev(ilg, ilev), gdrem(ilg, ntr, 3)
      REAL thlevb(ilg, ilev), gdremb(ilg, ntr, 3)
      REAL throw(ilg, lev), rhrow(ilg, lev), shj(ilg, ilev)
      REAL throwb(ilg, lev), rhrowb(ilg, lev)
      REAL fsnorow(ilg), cldcv(ilg, ilev, 2)
      REAL fsnorowb(ilg), cldcvb(ilg, ilev, 2)
C
      REAL surfdg(ilg), surfwd(ilg), fland(ilg, luc)
      REAL surfwdb(ilg), flandb(ilg, luc)
      REAL rhsize(ilg, ilev, isize), pdepv(ilg, ilev, isize)
      REAL rhsizeb(ilg, ilev, isize), pdepvb(ilg, ilev, isize)
      REAL rhop(ilg, ilev, isize), pdiff(ilg, ilev, isize)
      REAL pdiffb(ilg, ilev, isize)
      REAL rtdry(ilg, ilev, ntr)
      REAL rtdryb(ilg, ilev, ntr)
C
      REAL pressg(ilg), dshj(ilg, ilev), xrow(ilg, lev, ntr)
      REAL pressgb(ilg), dshjb(ilg, ilev), xrowb(ilg, lev, ntr)
C
      REAL pxnew(ilg, ilev, ntr)
      REAL pxnewb(ilg, ilev, ntr)
      REAL roarow(ilg, ilev), gtrow(ilg), sfctrow(ilg)
      REAL roarowb(ilg, ilev), gtrowb(ilg), sfctrowb(ilg)
      REAL fsgrol(ilg), sicnrow(ilg)
      REAL fsgrolb(ilg), sicnrowb(ilg)
C
      REAL seasn(ilg), ra(ilg, luc), usi(ilg, luc)
      REAL seasnb(ilg), rab(ilg, luc), usib(ilg, luc)
      REAL pllp(luc, ns), z0(luc, ns), scc(ng), rcw(ng), ac(ng)
      REAL pllpb(luc, ns), z0b(luc, ns), sccb(ng), rcwb(ng), acb(ng)
      REAL lai(luc, ns), rm0(ng), zpd(luc, ns)
      REAL laib(luc, ns), rm0b(ng)
      REAL fcap(ml), wp(ml), rgw(ng)
      REAL rgwb(ng)
      REAL aest(luc), gamma(luc)
      REAL aestb(luc), gammab(luc)
      CHARACTER*4 cspec(ng)
      EXTERNAL PUTZERO
      EXTERNAL PUTZERO_B
      INTEGER arg1
      INTEGER branch
      REAL y1b
      INTRINSIC EXP
      REAL tempb0
      REAL temp0b
      INTRINSIC ABS
      REAL x1
      REAL abs0b
      REAL tempb
      INTRINSIC AMAX1
      REAL temp0b0
      REAL x1b
      REAL abs0
      INTEGER ii1
      REAL temp
      REAL y1
      arg1 = ilg*ilev*ntr
      CALL PUSHINTEGER4(arg1)
      CALL PUSHREAL8ARRAY(rtdry, ilg*ilev*ntr)
      CALL PUTZERO(rtdry, arg1)
C
C     CALL TO VECTORIZED ADOM DRY GAS DEPOSITION SCHEME
C     NG0=1 for SO2 IN CAM ONLY. FOR ALL 12 SPECIES, NG0=NG
C
      IF (cam .LT. 10.0) THEN
        ng0 = 1
      ELSE
        ng0 = ng
      END IF
C
      stdhi = 10.0
      DO ii1=1,ilg
        CALL PUSHREAL8(pxnew(ii1, 1, 2))
      ENDDO
      CALL PUSHREAL8ARRAY(seasn, ilg)
      CALL PUSHREAL8ARRAY(vdg, ilg*ng)
      CALL PUSHINTEGER4(ilg)
      CALL DRYGAS(ilg, fland, vdg, surfwd, stdhi, ilev, gtrow, sfctrow, 
     +            fsgrol, pxnew(1, 1, 1), luc, deglat, seasn, rhrow(1, 
     +            lev), cldcv, pxnew(1, 1, 2), iday, il1, il2, sicnrow, 
     +            fsnorow, ra, usi, jlat, ng, ns, ng0, z0, scc, rcw, ac
     +            , lai, rm0, zpd, rgw, avno, rgasi, am, boltzk, pi, a, 
     +            a0, rsn0, rcut0, rcg0, p)
C
C     * SO2 DRY DEPOSITION TENDENCY
C
      DO i=il1,il2
        IF (vdg(i, 1) .GE. 0.) THEN
          CALL PUSHREAL8(abs0)
          abs0 = vdg(i, 1)
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHREAL8(abs0)
          abs0 = -vdg(i, 1)
          CALL PUSHCONTROL1B(1)
        END IF
        qcc = -(abs0/thlev(i, ilev)*adt2)
        rtdry(i, ilev, iso2) = xrow(i, lev, iso2)*(EXP(qcc)-1.0)/adt2
        y1 = xrow(i, ilev+1, iso2) + rtdry(i, ilev, iso2)*adt2
        IF (tmin .LT. y1) THEN
          CALL PUSHREAL8(xrow(i, ilev+1, iso2))
          xrow(i, ilev+1, iso2) = y1
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHREAL8(xrow(i, ilev+1, iso2))
          xrow(i, ilev+1, iso2) = tmin
          CALL PUSHCONTROL1B(1)
        END IF
      ENDDO
      DO ii1=1,ilg
        CALL PUSHREAL8(pxnew(ii1, 1, 3))
      ENDDO
      CALL PUSHREAL8ARRAY(rtdry, ilg*ilev*ntr)
      CALL PUSHREAL8ARRAY(pdepv, ilg*ilev*isize)
C
C
C     PARTICLE DRY DEPOSITION
C
      CALL DRYPAR(throw, lev, ilev, ilg, isize, ntp, il1, il2, ntr, adt2
     +            , iae1, mae, pressg, shj, thlev, roarow, pxnew(1, 1, 1
     +            ), pdiff, rhop, rhsize, fland, xrow, pxnew(1, 1, 2), 
     +            luc, surfdg, surfwd, pdepv, rtdry, dshj, pxnew(1, 1, 3
     +            ), jlat, seasn, ra, usi, pllp, aest, ns, gamma)
C
      DO nn=1,ntp
        DO n=1,isize
          CALL PUSHINTEGER4(np)
          np = isize*(nn-1) + n + (iae1-1)
          DO l=ilev,1+mae,-1
            DO i=il1,il2
              x1 = xrow(i, l+1, np) + rtdry(i, l, np)*adt2
              IF (x1 .LT. tmin) THEN
                CALL PUSHREAL8(xrow(i, l+1, np))
                xrow(i, l+1, np) = tmin
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHREAL8(xrow(i, l+1, np))
                xrow(i, l+1, np) = x1
                CALL PUSHCONTROL1B(1)
              END IF
            ENDDO
          ENDDO
        ENDDO
      ENDDO
      DO nn=ntp,1,-1
        DO n=isize,1,-1
          DO l=mae+1,ilev,1
            DO i=il2,il1,-1
              temp0b0 = pressg(i)*gdremb(i, np, 1)/g
              rtdryb(i, l, np) = rtdryb(i, l, np) + dshj(i, l)*temp0b0
              dshjb(i, l) = dshjb(i, l) + rtdry(i, l, np)*temp0b0
              pressgb(i) = pressgb(i) + rtdry(i, l, np)*dshj(i, l)*
     +          gdremb(i, np, 1)/g
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                CALL POPREAL8(xrow(i, l+1, np))
                xrowb(i, l+1, np) = 0.0
                x1b = 0.0
              ELSE
                CALL POPREAL8(xrow(i, l+1, np))
                x1b = xrowb(i, l+1, np)
                xrowb(i, l+1, np) = 0.0
              END IF
              xrowb(i, l+1, np) = xrowb(i, l+1, np) + x1b
              rtdryb(i, l, np) = rtdryb(i, l, np) + adt2*x1b
              adt2b = adt2b + rtdry(i, l, np)*x1b
            ENDDO
          ENDDO
          CALL POPINTEGER4(np)
        ENDDO
      ENDDO
      CALL POPREAL8ARRAY(pdepv, ilg*ilev*isize)
      CALL POPREAL8ARRAY(rtdry, ilg*ilev*ntr)
      DO ii1=ilg,1,-1
        CALL POPREAL8(pxnew(ii1, 1, 3))
      ENDDO
      CALL DRYPAR_B(throw, throwb, lev, ilev, ilg, isize, ntp, il1, il2
     +              , ntr, adt2, adt2b, iae1, mae, pressg, shj, thlev, 
     +              thlevb, roarow, roarowb, pxnew(1, 1, 1), pxnewb(1, 1
     +              , 1), pdiff, pdiffb, rhop, rhsize, rhsizeb, fland, 
     +              flandb, xrow, xrowb, pxnew(1, 1, 2), pxnewb(1, 1, 2)
     +              , luc, surfdg, surfwd, pdepv, pdepvb, rtdry, rtdryb
     +              , dshj, pxnew(1, 1, 3), pxnewb(1, 1, 3), jlat, seasn
     +              , ra, rab, usi, usib, pllp, pllpb, aest, aestb, ns, 
     +              gamma, gammab)
      DO i=il2,il1,-1
        temp0b = pressg(i)*gdremb(i, iso2, 1)/g
        rtdryb(i, ilev, iso2) = rtdryb(i, ilev, iso2) + dshj(i, ilev)*
     +    temp0b
        dshjb(i, ilev) = dshjb(i, ilev) + rtdry(i, ilev, iso2)*temp0b
        pressgb(i) = pressgb(i) + rtdry(i, ilev, iso2)*dshj(i, ilev)*
     +    gdremb(i, iso2, 1)/g
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          CALL POPREAL8(xrow(i, ilev+1, iso2))
          y1b = xrowb(i, ilev+1, iso2)
          xrowb(i, ilev+1, iso2) = 0.0
        ELSE
          CALL POPREAL8(xrow(i, ilev+1, iso2))
          xrowb(i, ilev+1, iso2) = 0.0
          y1b = 0.0
        END IF
        xrowb(i, ilev+1, iso2) = xrowb(i, ilev+1, iso2) + y1b
        rtdryb(i, ilev, iso2) = rtdryb(i, ilev, iso2) + adt2*y1b
        qcc = -(abs0/thlev(i, ilev)*adt2)
        tempb = (EXP(qcc)-1.0)*rtdryb(i, ilev, iso2)/adt2
        temp = xrow(i, lev, iso2)/adt2
        xrowb(i, lev, iso2) = xrowb(i, lev, iso2) + tempb
        qccb = temp*EXP(qcc)*rtdryb(i, ilev, iso2)
        rtdryb(i, ilev, iso2) = 0.0
        tempb0 = -(qccb/thlev(i, ilev))
        adt2b = adt2b + abs0*tempb0 - temp*tempb + rtdry(i, ilev, iso2)*
     +    y1b
        abs0b = adt2*tempb0
        thlevb(i, ilev) = thlevb(i, ilev) - abs0*adt2*tempb0/thlev(i, 
     +    ilev)
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          CALL POPREAL8(abs0)
          vdgb(i, 1) = vdgb(i, 1) + abs0b
        ELSE
          CALL POPREAL8(abs0)
          vdgb(i, 1) = vdgb(i, 1) - abs0b
        END IF
      ENDDO
      CALL POPINTEGER4(ilg)
      CALL POPREAL8ARRAY(vdg, ilg*ng)
      CALL POPREAL8ARRAY(seasn, ilg)
      DO ii1=ilg,1,-1
        CALL POPREAL8(pxnew(ii1, 1, 2))
      ENDDO
      CALL DRYGAS_B(ilg, fland, flandb, vdg, vdgb, surfwd, surfwdb, 
     +              stdhi, ilev, gtrow, gtrowb, sfctrow, sfctrowb, 
     +              fsgrol, fsgrolb, pxnew(1, 1, 1), pxnewb(1, 1, 1), 
     +              luc, deglat, seasn, seasnb, rhrow(1, lev), rhrowb(1
     +              , lev), cldcv, cldcvb, pxnew(1, 1, 2), pxnewb(1, 1, 
     +              2), iday, il1, il2, sicnrow, sicnrowb, fsnorow, 
     +              fsnorowb, ra, rab, usi, usib, jlat, ng, ns, ng0, z0
     +              , z0b, scc, sccb, rcw, rcwb, ac, acb, lai, laib, rm0
     +              , rm0b, zpd, rgw, rgwb, avno, rgasi, am, boltzk, pi
     +              , a, a0, a0b, rsn0, rsn0b, rcut0, rcut0b, rcg0, 
     +              rcg0b, p, pb)
      CALL POPREAL8ARRAY(rtdry, ilg*ilev*ntr)
      CALL POPINTEGER4(arg1)
      CALL PUTZERO_B(rtdry, rtdryb, arg1)
      END

C  Differentiation of drypar in reverse (adjoint) mode:
C   gradient     of useful results: pdepv rtdry usi vdp throw gamma
C                pdiff ra xrow schm thlev pllp anu rhsize aest
C                adt2 roarow fland
C   with respect to varying inputs: pdepv rtdry usi vdp throw gamma
C                pdiff ra xrow schm thlev pllp anu rhsize aest
C                adt2 roarow fland
      SUBROUTINE DRYPAR_B(throw, throwb, lev, ilev, ilg, isize, ntp, il1
     +                    , il2, ntr, adt2, adt2b, iae1, mae, pressg, 
     +                    shj, thlev, thlevb, roarow, roarowb, anu, anub
     +                    , pdiff, pdiffb, rhop, rhsize, rhsizeb, fland
     +                    , flandb, xrow, xrowb, schm, schmb, luc, 
     +                    surfdg, surfwd, pdepv, pdepvb, rtdry, rtdryb, 
     +                    dshj, vdp, vdpb, jlat, seasn, ra, rab, usi, 
     +                    usib, pllp, pllpb, aest, aestb, ns, gamma, 
     +                    gammab)
      IMPLICIT NONE
      REAL p, rcg0, rcut0, pi, boltzk, am, rsn0, a0, a
      integer ic
      INTEGER l, i, n, nn, np, isea, iae1, nte, jlat, luc, mae, il2, ilg
     +        , ilev
      INTEGER lev, il1, ntp, isize, ns, ntr
      REAL vdf, rs, xxx, qcc, r1, st, amu, ein, eim, eb, rgasi, adt2, 
     +     cpres
      REAL vdfb, rsb, xxxb, qccb, r1b, stb, amub, einb, eimb, ebb, adt2b
      REAL rgoasq, rgocp, avno, cpresv, rgasv, rgas, tw, ww, g, asq, 
     +     rayon
      COMMON /params/ ww, tw, rayon, asq, g, rgas, rgocp, rgoasq, cpres
     +, rgasv, cpresv
      COMMON /narcm/ avno, rgasi, am, boltzk, pi, a, a0, rsn0, rcut0, 
     +rcg0, p
C
C     * INPUT ARRAYS...
C
      REAL rhop(ilg, ilev, isize), pdiff(ilg, ilev, isize)
      REAL pdiffb(ilg, ilev, isize)
      REAL throw(ilg, lev), shj(ilg, ilev), thlev(ilg, ilev)
      REAL throwb(ilg, lev), thlevb(ilg, ilev)
      REAL rhsize(ilg, ilev, isize), pdepv(ilg, ilev, isize)
      REAL rhsizeb(ilg, ilev, isize), pdepvb(ilg, ilev, isize)
      REAL surfdg(ilg), surfwd(ilg)
      REAL pressg(ilg), dshj(ilg, ilev), fland(ilg, luc)
      REAL flandb(ilg, luc)
      REAL xrow(ilg, lev, ntr), rtdry(ilg, ilev, ntr)
      REAL xrowb(ilg, lev, ntr), rtdryb(ilg, ilev, ntr)
      REAL vdp(ilg), pllp(luc, ns), seasn(ilg), ra(ilg, luc)
      REAL vdpb(ilg), pllpb(luc, ns), rab(ilg, luc)
      REAL roarow(ilg, ilev)
      REAL roarowb(ilg, ilev)
      REAL anu(ilg), schm(ilg)
      REAL anub(ilg), schmb(ilg)
      REAL aest(luc), usi(ilg, luc), gamma(luc)
      REAL aestb(luc), usib(ilg, luc), gammab(luc)
      REAL CVMGT
      LOGICAL arg1
      INTEGER branch
      REAL temp3
      REAL temp2
      REAL y1b
      REAL temp1
      REAL temp0
      REAL temp7b
      INTRINSIC EXP
      REAL tempb2
      REAL tempb1
      REAL tempb0
      REAL temp3b
      REAL temp7b0
      REAL temp9b
      REAL temp5b0
      REAL tempb
      INTRINSIC AMAX1
      REAL temp2b
      REAL temp5b
      INTRINSIC INT
      INTRINSIC AMIN1
      REAL temp1b
      REAL temp
      REAL temp8
      REAL temp7
      REAL temp4b
      REAL temp6
      REAL temp5
      REAL y1
      REAL temp4
C-----------------------------------------------------------------------
C
C     * LOOP FOR THE NUMBER OF AEROSOLS (SIZE BINS)
C
C-----------------------------------------------------------------------
C--------------------------------------
C     * FOR THE SURFACE LAYER, DRY DEPOSITION IS CALCULATED.
C     * NOTE: THE GRAVITATIONAL VELOCITY WAS COMPUTED IN AEROPROP.
C--------------------------------------
      l = ilev
      DO n=1,isize
        DO i=il1,il2
          vdp(i) = 0.0
        ENDDO
        DO ic=1,luc
          DO i=il1,il2
            CALL PUSHINTEGER4(isea)
            isea = INT(seasn(i))
            IF (fland(i, ic) .GE. 0.005) THEN
C
C     * AIR'S DYNAMIC VISCOSITY
C
              amu = 145.8*1.e-8*throw(i, l+1)**1.5/(throw(i, l+1)+110.4)
              CALL PUSHREAL8(anu(i))
C     * AIR'S KINEMATIS VISCOSITY
C
              anu(i) = amu/roarow(i, l)
              CALL PUSHREAL8(schm(i))
              schm(i) = anu(i)/pdiff(i, l, n)
C
C     * CALCULATE middle-variles needed for EB,EIN,EM, etc., then Ra, Rs, VDF
C
              IF (pllp(ic, isea) .LE. 0.) THEN
                CALL PUSHREAL8(st)
                st = pdepv(i, l, n)/g*usi(i, ic)*usi(i, ic)/anu(i)
                CALL PUSHCONTROL1B(1)
              ELSE
                CALL PUSHREAL8(st)
                st = pdepv(i, l, n)/g*usi(i, ic)/pllp(ic, isea)*1000.
                CALL PUSHCONTROL1B(0)
              END IF
              eb = schm(i)**gamma(ic)
              CALL PUSHREAL8(eim)
              eim = (st/(st+aest(ic)))**2
              IF (eim .GT. 0.8) THEN
                eim = 0.8
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHCONTROL1B(1)
                eim = eim
              END IF
              CALL PUSHREAL8(ein)
              ein = 0.0
              IF (pllp(ic, isea) .GT. 0.01) THEN
                ein = (1000.0*2.*rhsize(i, l, n)/pllp(ic, isea))**2*0.5
                CALL PUSHCONTROL1B(1)
              ELSE
                CALL PUSHCONTROL1B(0)
              END IF
              IF (ein .GT. 0.6) THEN
                ein = 0.6
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHCONTROL1B(1)
                ein = ein
              END IF
              y1 = EXP(-(st**0.5))
              IF (0.5 .LT. y1) THEN
                CALL PUSHREAL8(r1)
                r1 = y1
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHREAL8(r1)
                r1 = 0.5
                CALL PUSHCONTROL1B(1)
              END IF
              rs = 1./3./usi(i, ic)/(eb+eim+ein)/r1
              vdf = pdepv(i, l, n) + 1./(ra(i, ic)+rs)
              vdp(i) = vdp(i) + vdf*fland(i, ic)
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
          ENDDO
        ENDDO
        DO i=il1,il2
          CALL PUSHREAL8(pdepv(i, l, n))
          pdepv(i, l, n) = vdp(i)
        ENDDO
      ENDDO
C
C--------------------------------------
C     * SECTION 3
C     * TENDENCY CALCULATION.
C--------------------------------------
C
C     * CREATE DEPOSITION TENDENCIES FOR EACH LAYER
C
      DO nn=1,ntp
        DO n=1,isize
          CALL PUSHINTEGER4(np)
          np = isize*(nn-1) + n + (iae1-1)
          CALL PUSHINTEGER4(l)
          DO l=ilev,1+mae,-1
            DO i=il1,il2
              arg1 = xrow(i, l+1, np) .GT. 1.e-20
              CALL PUSHREAL8(xxx)
              xxx = CVMGT(xrow(i, l+1, np), 0.0, arg1)
            ENDDO
          ENDDO
        ENDDO
      ENDDO
      DO nn=ntp,1,-1
        DO n=isize,1,-1
          DO l=mae+1,ilev,1
            DO i=il2,il1,-1
              qcc = -(pdepv(i, l, n)*adt2/thlev(i, l))
              temp9b = (EXP(qcc)-1.0)*rtdryb(i, l, np)/adt2
              qccb = xxx*EXP(qcc)*rtdryb(i, l, np)/adt2
              xxxb = temp9b
              rtdryb(i, l, np) = 0.0
              arg1 = xrow(i, l+1, np) .GT. 1.e-20
              temp8 = thlev(i, l)
              temp7 = adt2/temp8
              temp7b0 = -(pdepv(i, l, n)*qccb/temp8)
              adt2b = adt2b + temp7b0 - xxx*temp9b/adt2
              CALL POPREAL8(xxx)
              CALL CVMGT_B(xrow(i, l+1, np), xrowb(i, l+1, np), 0.0, 
     +                     0.0,arg1, xxxb)
              pdepvb(i, l, n) = pdepvb(i, l, n) - temp7*qccb
              thlevb(i, l) = thlevb(i, l) - temp7*temp7b0
            ENDDO
          ENDDO
          CALL POPINTEGER4(l)
          CALL POPINTEGER4(np)
        ENDDO
      ENDDO
      DO n=isize,1,-1
        DO i=il2,il1,-1
          CALL POPREAL8(pdepv(i, l, n))
          vdpb(i) = vdpb(i) + pdepvb(i, l, n)
          pdepvb(i, l, n) = 0.0
        ENDDO
        DO ic=luc,1,-1
          DO i=il2,il1,-1
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              eb = schm(i)**gamma(ic)
              rs = 1./3./usi(i, ic)/(eb+eim+ein)/r1
              vdf = pdepv(i, l, n) + 1./(ra(i, ic)+rs)
              vdfb = fland(i, ic)*vdpb(i)
              flandb(i, ic) = flandb(i, ic) + vdf*vdpb(i)
              temp7b = -(vdfb/(ra(i, ic)+rs)**2)
              pdepvb(i, l, n) = pdepvb(i, l, n) + vdfb
              rab(i, ic) = rab(i, ic) + temp7b
              rsb = temp7b
              temp6 = 3.*r1
              temp5 = usi(i, ic)*(eb+eim+ein)
              temp5b = -(rsb/(temp5**2*temp6**2))
              temp5b0 = temp6*usi(i, ic)*temp5b
              usib(i, ic) = usib(i, ic) + temp6*(eb+eim+ein)*temp5b
              ebb = temp5b0
              eimb = temp5b0
              einb = temp5b0
              r1b = temp5*3.*temp5b
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                CALL POPREAL8(r1)
                y1b = r1b
              ELSE
                CALL POPREAL8(r1)
                y1b = 0.0
              END IF
              stb = -(EXP(-(st**0.5))*0.5*st**(-0.5)*y1b)
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) einb = 0.0
              CALL POPCONTROL1B(branch)
              IF (branch .NE. 0) THEN
                temp4 = pllp(ic, isea)**2
                temp4b = 1000.0**2*0.5*2.**2*einb/temp4
                rhsizeb(i, l, n) = rhsizeb(i, l, n) + 2*rhsize(i, l, n)*
     +            temp4b
                pllpb(ic, isea) = pllpb(ic, isea) - rhsize(i, l, n)**2*2
     +            *pllp(ic, isea)*temp4b/temp4
              END IF
              CALL POPREAL8(ein)
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) eimb = 0.0
              CALL POPREAL8(eim)
              temp3 = st + aest(ic)
              temp2 = st/temp3
              temp2b = 2*temp2*eimb/temp3
              temp3b = -(temp2*temp2b)
              stb = stb + temp3b + temp2b
              aestb(ic) = aestb(ic) + temp3b
              IF (.NOT.(schm(i) .LE. 0.0 .AND. (gamma(ic) .EQ. 0.0 .OR. 
     +            gamma(ic) .NE. INT(gamma(ic))))) schmb(i) = schmb(i) +
     +            gamma(ic)*schm(i)**(gamma(ic)-1)*ebb
              IF (.NOT.schm(i) .LE. 0.0) gammab(ic) = gammab(ic) + schm(
     +            i)**gamma(ic)*LOG(schm(i))*ebb
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                CALL POPREAL8(st)
                temp1 = g*pllp(ic, isea)
                temp1b = 1000.*stb/temp1
                pdepvb(i, l, n) = pdepvb(i, l, n) + usi(i, ic)*temp1b
                usib(i, ic) = usib(i, ic) + pdepv(i, l, n)*temp1b
                pllpb(ic, isea) = pllpb(ic, isea) - pdepv(i, l, n)*usi(i
     +            , ic)*g*temp1b/temp1
              ELSE
                CALL POPREAL8(st)
                temp0 = g*anu(i)
                temp = pdepv(i, l, n)/temp0
                tempb2 = usi(i, ic)**2*stb/temp0
                usib(i, ic) = usib(i, ic) + temp*2*usi(i, ic)*stb
                pdepvb(i, l, n) = pdepvb(i, l, n) + tempb2
                anub(i) = anub(i) - temp*g*tempb2
              END IF
              CALL POPREAL8(schm(i))
              tempb = schmb(i)/pdiff(i, l, n)
              anub(i) = anub(i) + tempb
              pdiffb(i, l, n) = pdiffb(i, l, n) - anu(i)*tempb/pdiff(i, 
     +          l, n)
              schmb(i) = 0.0
              amu = 145.8*1.e-8*throw(i, l+1)**1.5/(throw(i, l+1)+110.4)
              CALL POPREAL8(anu(i))
              tempb0 = anub(i)/roarow(i, l)
              amub = tempb0
              roarowb(i, l) = roarowb(i, l) - amu*tempb0/roarow(i, l)
              anub(i) = 0.0
              tempb1 = 1.e-8*145.8*amub/(throw(i, l+1)+110.4)
              throwb(i, l+1) = throwb(i, l+1) + (1.5*throw(i, l+1)**0.5-
     +          throw(i, l+1)**1.5/(throw(i, l+1)+110.4))*tempb1
            END IF
            CALL POPINTEGER4(isea)
          ENDDO
        ENDDO
        DO i=il2,il1,-1
          vdpb(i) = 0.0
        ENDDO
      ENDDO
      END

C  Differentiation of drygas in reverse (adjoint) mode:
C   gradient     of useful results: lai vdg f ac usi ts p srad
C                z0 ra rh rcw t2 rsn0 rcg0 a0 sc rgw pice fcld
C                zz0 rm0 rcut0 psnow u2i cldcv seasn
C   with respect to varying inputs: lai vdg f ac usi ts p srad
C                z0 ra rh rcw t2 rsn0 rcg0 a0 sc rgw pice fcld
C                zz0 rm0 rcut0 psnow u2i cldcv seasn
      SUBROUTINE DRYGAS_B(ilg, f, fb, vdg, vdgb, u2i, u2ib, z2, ilev, ts
     +                    , tsb, t2, t2b, srad, sradb, zz0, zz0b, luc, 
     +                    glat, seasn, seasnb, rh, rhb, cldcv, cldcvb, 
     +                    fcld, fcldb, iday, il1, il2, pice, piceb, 
     +                    psnow, psnowb, ra, rab, usi, usib, jlat, ng, 
     +                    ns, ng0, z0, z0b, sc, scb, rcw, rcwb, ac, acb
     +                    , lai, laib, rm0, rm0b, zpd, rgw, rgwb, avno, 
     +                    rgasi, am, boltzk, pi, a, a0, a0b, rsn0, rsn0b
     +                    , rcut0, rcut0b, rcg0, rcg0b, p, pb)
      IMPLICIT NONE
C
C****************** HOURLY PARAMETER DEFINITIONS ********************
C     EL     - MONIN OBUKHOV LENGTH (M) - CALCULATED FOR EACH LAND
C                                         USE CATEGORY
C     USTAR  - FRICTION VELOCITY - CALCULATED FOR EACH LAND USE
C                                  CATEGORY
C     U2I    - WIND SPEED AT 10M. (M/S)
C     T2     - TEMPERATURE AT 10M. (DEG K)
C     Z2     - 10 M.
C     GLAT   - CENTER LATITUDE OF GRID CELL (DEG)
C     SRAD   - SOLAR IRRADIANCE AT THE GROUND (W/M**2)
C     FCLD   - CLOUD FRACTION (0-1)
C     TSW    - WATER SURFACE TEMPERATURE (DEG K)
C     TS     - SURFACE TEMPERATURE (DEG K)
C     PSNOW  - SNOW COVER (0.0-1.0)
C     PICE   - ICE COVER OF ENTIRE GRID CELL (0.0-1.0)
C     F      - FRACTION OF EACH LUC   (0.0-1.0)
C     PCWC   - CANOPY WATER CONTENT (0.0-1.0)
C     RH     - RELATIVE HUMIDITY OF AIR AT 10M. (0.0-1.0)
C********************************************************************
C
C      LAND USE CATEGORIES
C       1  EVERGREEN NEEDLELEAF FOREST
C       2  EVERGREEN BROADLEAF FOREST
C       3  DECIDUOUS NEEDLELEAF FOREST
C       4  DECIDUOUS BROADLEAF FOREST
C       5  MIXED FOREST 
C       6  GRASSLAND
C       7  CROPS, MIXED FARMING
C       8  DESERT
C       9  TUNDRA 
C       10 DWART TREES, SHRUBS WITH GROUND COVER 
C       11 WET LAND WITH PLANTS
C       12 ICE CAPS AND GLACIERS
C       13 INLAND WATER
C       14 OCEAN
C       15 URBAN
C------------------------------------------------------------
C
      REAL x, psiu, zdl, cun, el, y, rib, deltat, thstar, psit, ustar
      REAL xb, psiub, zdlb, cunb, elb, ribb, deltatb, thstarb, ustarb
      REAL dthv, t2p, e, fsnow, fice, q, tsv, z0water, qs, t2pv, tsw
      REAL dthvb, t2pb, eb, fsnowb, ficeb, qb, tsvb, z0waterb, qsb, 
     +     t2pvb, tswb
      REAL tbar, rst, rcut, rm, d, rp, rcf, rc, vdf, tscent, rcg, rsn
      REAL tbarb, rstb, rcutb, rmb, db, rpb, rcfb, rcb, vdfb, tscentb, 
     +     rcgb, rsnb
      INTEGER iw, luc, iday, ilev, ilg, il1, il2, ns, ng0, ng, jlat
      REAL rd, cm, ch, aa, ratioz, asq, fm, z, zl, utstar, fh, ustarsq
      REAL rdb, cmb, chb, aab, ratiozb, asqb, fmb, zlb, utstarb, fhb, 
     +     ustarsqb
      REAL pi, a, boltzk, rgasi, am, rsn0, vi, g, p, rcut0, rcg0, avno
      REAL rsn0b, pb, rcut0b, rcg0b
      REAL z2, rad, u2, fw, smax, b, sncov, pland, pcwc, aa0, aa1, scon
      REAL u2b, fwb, bb, sncovb, plandb
      INTEGER isea, i, j, il, l
      REAL bmax, bmin, aa2, aa6, pmb, aa5, aa3, aa4, es, temp
      REAL f(ilg, luc), vdg(ilg, ng)
      REAL fb(ilg, luc), vdgb(ilg, ng)
      REAL icecov, k, kui
      REAL icecovb, kuib
      REAL logratio
      REAL logratiob
      REAL z0(luc, ns), sc(ng), rcw(ng), ac(ng), a0
      REAL z0b(luc, ns), scb(ng), rcwb(ng), acb(ng), a0b
      REAL lai(luc, ns), rm0(ng), rgw(ng), zpd(luc, ns)
      REAL laib(luc, ns), rm0b(ng), rgwb(ng)
      REAL u2i(ilg), ts(ilg), t2(ilg), psnow(ilg), pice(ilg)
      REAL u2ib(ilg), tsb(ilg), t2b(ilg), psnowb(ilg), piceb(ilg)
      REAL srad(ilg), glat(ilg), rh(ilg), fcld(ilg)
      REAL sradb(ilg), rhb(ilg), fcldb(ilg)
      REAL zz0(ilg)
      REAL zz0b(ilg)
      REAL cldcv(ilg, ilev, 2), seasn(ilg), ra(ilg, luc), usi(ilg, luc)
      REAL cldcvb(ilg, ilev, 2), seasnb(ilg), rab(ilg, luc), usib(ilg, 
     +     luc)
      EXTERNAL PUTZERO
      EXTERNAL PUTZERO_B
      INTEGER arg1
      INTEGER branch
      REAL abs30
      REAL temp3
      REAL temp2
      REAL temp1
      REAL temp27
      REAL temp0
      REAL temp26
      INTRINSIC COS
      REAL temp7b
      REAL temp25
      REAL temp21b
      REAL temp24
      INTRINSIC EXP
      REAL temp23
      REAL temp22
      REAL temp9b0
      REAL temp21
      REAL temp20
      REAL temp16b
      REAL temp24b
      REAL temp19b
      REAL temp27b
      REAL temp0b
      REAL abs29
      REAL abs28
      REAL abs27
      REAL abs26
      INTRINSIC SIGN
      REAL abs25
      REAL abs24
      REAL abs23
      REAL temp16b4
      INTRINSIC ABS
      REAL abs22
      REAL temp16b3
      REAL abs21
      REAL temp7b0
      REAL temp16b2
      REAL abs20
      REAL temp16b1
      REAL temp19
      REAL temp16b0
      REAL temp18
      REAL temp17
      REAL temp12b
      REAL temp16
      REAL temp2b0
      REAL temp15
      REAL temp14
      REAL temp13
      REAL temp12
      REAL temp11
      INTRINSIC ALOG
      REAL temp10
      REAL temp9b
      REAL abs36b
      REAL temp23b
      REAL temp19b2
      REAL temp19b1
      REAL temp19b0
      REAL temp5b0
      REAL abs19
      REAL abs18
      REAL abs17
      REAL abs16
      INTRINSIC AMAX1
      REAL abs15
      REAL abs14
      REAL abs13
      REAL temp2b
      REAL abs12
      REAL abs49
      REAL abs11
      REAL abs48
      REAL abs10
      REAL abs47
      REAL abs46
      REAL abs45
      REAL abs44
      REAL abs43
      REAL temp5b
      REAL abs42
      INTRINSIC INT
      REAL abs41
      REAL abs40
      REAL abs9
      REAL temp14b
      REAL abs8
      REAL abs35b
      REAL temp22b
      REAL abs7
      REAL temp12b2
      REAL abs6
      REAL temp12b1
      REAL abs5
      REAL temp12b0
      REAL abs4
      REAL abs3
      INTRINSIC AMIN1
      INTRINSIC ATAN
      REAL abs2
      REAL temp17b
      REAL abs1
      REAL abs0
      REAL temp1b
      INTRINSIC SQRT
      REAL abs39
      REAL abs38
      REAL abs37
      REAL abs36
      REAL temp9
      REAL abs35
      REAL temp8
      REAL abs34
      REAL temp1b0
      REAL temp7
      REAL temp10b
      REAL abs33
      REAL temp6
      REAL abs32
      REAL temp5
      REAL temp10b0
      REAL abs31
      REAL temp4
C
C      COMMON /NARCM/ AVNO,    RGASi,     AM,   BOLTZK,  PI,  A
C     +         ,A0,RSN0,RCUT0,RCG0,P
C
      DATA k /0.4/
      DATA vi /0.15e-4/
      DATA g /9.81/
      DATA rad /0.0174533/
C --- 10 MICRONS (RUTTER 1975)
      DATA bmax /2.5e-6/
C --- 0.1 MICRONS
      DATA bmin /0.1e-6/
C --- W/M**2  SOLAR CONSTANT
      DATA scon /1380./
C
C --- COEFFICIENTS FOR CALCULATION OF SATURATION VAPOR PRESSURE
C --- PKK: 7/16/85
      DATA aa0 /6.107799961/
      DATA aa1 /4.436518521e-1/
      DATA aa2 /1.428945805e-2/
      DATA aa3 /2.650648471e-4/
      DATA aa4 /3.031240396e-6/
      DATA aa5 /2.034080948e-8/
      DATA aa6 /6.136820929e-11/
C --- SEA LEVEL PRESSURE (MB)
      DATA pmb /1000./
C --- INITIALIZE DEPOSITION VELOCITY AND TOTAL RESISTANCE ARRAYS
      arg1 = ilg*ng
      CALL PUSHINTEGER4(ilg)
      CALL PUSHREAL8ARRAY(fcld, ilg)
      CALL PUTZERO(fcld, ilg)
C
C     CLOUD COVER
C
      DO l=1,ilev
        DO i=il1,il2
          fcld(i) = fcld(i) + cldcv(i, l, 1) + cldcv(i, l, 2)
        ENDDO
      ENDDO
      DO i=il1,il2
        IF (fcld(i) .GT. 1.0) THEN
          fcld(i) = 1.0
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHCONTROL1B(1)
          fcld(i) = fcld(i)
        END IF
      ENDDO
C
C     define season category according to Julian Day and Latitude.
C
      DO il=il1,il2
C
C     FOR NOTHER HEMISPHERE
C
        IF (glat(il) .GE. 0.0) THEN
          IF (iday .LE. 59 .OR. iday .GE. 335) THEN
CJan. Feb. Dec.
            IF (glat(il) .LE. 30.) THEN
              seasn(il) = 1.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 30. .AND. glat(il) .LE. 35.) THEN
              seasn(il) = 5.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 35.) THEN
              seasn(il) = 4.
              CALL PUSHCONTROL2B(0)
            ELSE
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(2)
          END IF
C
          IF (iday .GE. 60 .AND. iday .LE. 90) THEN
CMar.
            IF (glat(il) .LE. 35.) THEN
              seasn(il) = 1.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 35. .AND. glat(il) .LE. 40.) THEN
              seasn(il) = 5.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 40.) THEN
              seasn(il) = 4.
              CALL PUSHCONTROL2B(0)
            ELSE
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(2)
          END IF
C
          IF (iday .GE. 91 .AND. iday .LE. 120) THEN
CApr.
            IF (glat(il) .LE. 35.) THEN
              seasn(il) = 1.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 35. .AND. glat(il) .LE. 45.) THEN
              seasn(il) = 5.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 45.) THEN
              seasn(il) = 4.
              CALL PUSHCONTROL2B(0)
            ELSE
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(2)
          END IF
C
          IF (iday .GE. 121 .AND. iday .LE. 151) THEN
CMay.
            IF (glat(il) .LE. 35.) THEN
              seasn(il) = 1.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 35. .AND. glat(il) .LE. 60.) THEN
              seasn(il) = 5.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 60.) THEN
              seasn(il) = 4.
              CALL PUSHCONTROL2B(0)
            ELSE
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(2)
          END IF
C
          IF (iday .GE. 152 .AND. iday .LE. 181) THEN
CJun.
            IF (glat(il) .LE. 55.) THEN
              seasn(il) = 1.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 55. .AND. glat(il) .LE. 70.) THEN
              seasn(il) = 5.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 70.) THEN
              seasn(il) = 4.
              CALL PUSHCONTROL2B(0)
            ELSE
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(2)
          END IF
C
          IF (iday .GE. 182 .AND. iday .LE. 212) THEN
CJul.
            IF (glat(il) .LE. 70.) THEN
              seasn(il) = 1.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 70. .AND. glat(il) .LE. 80.) THEN
              seasn(il) = 5.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 80.) THEN
              seasn(il) = 4.
              CALL PUSHCONTROL2B(0)
            ELSE
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(2)
          END IF
C
          IF (iday .GE. 213 .AND. iday .LE. 243) THEN
CAug.
            IF (glat(il) .LE. 45.) THEN
              seasn(il) = 1.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 45. .AND. glat(il) .LE. 80.) THEN
              seasn(il) = 2.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 80.) THEN
              seasn(il) = 4.
              CALL PUSHCONTROL2B(0)
            ELSE
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(2)
          END IF
C
          IF (iday .GE. 244 .AND. iday .LE. 273) THEN
CSep.
            IF (glat(il) .LE. 35.) THEN
              seasn(il) = 1.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 35. .AND. glat(il) .LE. 65.) THEN
              seasn(il) = 2.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 65. .AND. glat(il) .LE. 80.) THEN
              seasn(il) = 3.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 80.) THEN
              seasn(il) = 4.
              CALL PUSHCONTROL2B(0)
            ELSE
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(2)
          END IF
C
          IF (iday .GE. 274 .AND. iday .LE. 304) THEN
COct.
            IF (glat(il) .LE. 35.) THEN
              seasn(il) = 1.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 35. .AND. glat(il) .LE. 45.) THEN
              seasn(il) = 2.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 45. .AND. glat(il) .LE. 65.) THEN
              seasn(il) = 3.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 65.) THEN
              seasn(il) = 4.
              CALL PUSHCONTROL2B(0)
            ELSE
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(2)
          END IF
C
          IF (iday .GE. 305 .AND. iday .LE. 334) THEN
CNov.
            IF (glat(il) .LE. 35.) THEN
              seasn(il) = 1.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 35. .AND. glat(il) .LE. 40.) THEN
              seasn(il) = 2.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 40. .AND. glat(il) .LE. 50.) THEN
              seasn(il) = 3.
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (glat(il) .GT. 50.) THEN
              seasn(il) = 4.
              CALL PUSHCONTROL3B(0)
            ELSE
              CALL PUSHCONTROL3B(1)
            END IF
          ELSE
            CALL PUSHCONTROL3B(2)
          END IF
        ELSE
C
C
C     Southern hemisphere
C
          IF (iday .GE. 152 .AND. iday .LE. 243) THEN
            IF (glat(il) .GE. 0.) THEN
              abs0 = glat(il)
            ELSE
              abs0 = -glat(il)
            END IF
CJun. Jul. Aug.
            IF (abs0 .LE. 30.) THEN
              seasn(il) = 1.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs1 = glat(il)
            ELSE
              abs1 = -glat(il)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs37 = glat(il)
            ELSE
              abs37 = -glat(il)
            END IF
            IF (abs1 .GT. 30. .AND. abs37 .LE. 35.) THEN
              seasn(il) = 5.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs2 = glat(il)
            ELSE
              abs2 = -glat(il)
            END IF
            IF (abs2 .GT. 35.) THEN
              seasn(il) = 4.
              CALL PUSHCONTROL2B(0)
            ELSE
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(2)
          END IF
          IF (iday .GE. 244 .AND. iday .LE. 273) THEN
            IF (glat(il) .GE. 0.) THEN
              abs3 = glat(il)
            ELSE
              abs3 = -glat(il)
            END IF
CSEp.
            IF (abs3 .LE. 35.) THEN
              seasn(il) = 1.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs4 = glat(il)
            ELSE
              abs4 = -glat(il)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs38 = glat(il)
            ELSE
              abs38 = -glat(il)
            END IF
            IF (abs4 .GT. 35. .AND. abs38 .LE. 40.) THEN
              seasn(il) = 5.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs5 = glat(il)
            ELSE
              abs5 = -glat(il)
            END IF
            IF (abs5 .GT. 40.) THEN
              seasn(il) = 4.
              CALL PUSHCONTROL2B(0)
            ELSE
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(2)
          END IF
          IF (iday .GE. 274 .AND. iday .LE. 304) THEN
            IF (glat(il) .GE. 0.) THEN
              abs6 = glat(il)
            ELSE
              abs6 = -glat(il)
            END IF
COct.
            IF (abs6 .LE. 35.) THEN
              seasn(il) = 1.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs7 = glat(il)
            ELSE
              abs7 = -glat(il)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs39 = glat(il)
            ELSE
              abs39 = -glat(il)
            END IF
            IF (abs7 .GT. 35. .AND. abs39 .LE. 45.) THEN
              seasn(il) = 5.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs8 = glat(il)
            ELSE
              abs8 = -glat(il)
            END IF
            IF (abs8 .GT. 45.) THEN
              seasn(il) = 4.
              CALL PUSHCONTROL2B(0)
            ELSE
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(2)
          END IF
          IF (iday .GE. 305 .AND. iday .LE. 334) THEN
            IF (glat(il) .GE. 0.) THEN
              abs9 = glat(il)
            ELSE
              abs9 = -glat(il)
            END IF
CNov.
            IF (abs9 .LE. 35.) THEN
              seasn(il) = 1.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs10 = glat(il)
            ELSE
              abs10 = -glat(il)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs40 = glat(il)
            ELSE
              abs40 = -glat(il)
            END IF
            IF (abs10 .GT. 35. .AND. abs40 .LE. 60.) THEN
              seasn(il) = 5.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs11 = glat(il)
            ELSE
              abs11 = -glat(il)
            END IF
            IF (abs11 .GT. 60.) THEN
              seasn(il) = 4.
              CALL PUSHCONTROL2B(0)
            ELSE
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(2)
          END IF
          IF (iday .GE. 335) THEN
            IF (glat(il) .GE. 0.) THEN
              abs12 = glat(il)
            ELSE
              abs12 = -glat(il)
            END IF
CDec.
            IF (abs12 .LE. 55.) THEN
              seasn(il) = 1.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs13 = glat(il)
            ELSE
              abs13 = -glat(il)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs41 = glat(il)
            ELSE
              abs41 = -glat(il)
            END IF
            IF (abs13 .GT. 55. .AND. abs41 .LE. 70.) THEN
              seasn(il) = 5.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs14 = glat(il)
            ELSE
              abs14 = -glat(il)
            END IF
            IF (abs14 .GT. 70.) THEN
              seasn(il) = 4.
              CALL PUSHCONTROL2B(0)
            ELSE
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(2)
          END IF
          IF (iday .LE. 31) THEN
            IF (glat(il) .GE. 0.) THEN
              abs15 = glat(il)
            ELSE
              abs15 = -glat(il)
            END IF
CJan.
            IF (abs15 .LE. 70.) THEN
              seasn(il) = 1.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs16 = glat(il)
            ELSE
              abs16 = -glat(il)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs42 = glat(il)
            ELSE
              abs42 = -glat(il)
            END IF
            IF (abs16 .GT. 70. .AND. abs42 .LE. 80.) THEN
              seasn(il) = 5.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs17 = glat(il)
            ELSE
              abs17 = -glat(il)
            END IF
            IF (abs17 .GT. 80.) THEN
              seasn(il) = 4.
              CALL PUSHCONTROL2B(0)
            ELSE
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(2)
          END IF
          IF (iday .GE. 32 .AND. iday .LE. 59) THEN
            IF (glat(il) .GE. 0.) THEN
              abs18 = glat(il)
            ELSE
              abs18 = -glat(il)
            END IF
CFeb   
            IF (abs18 .LE. 45.) THEN
              seasn(il) = 1.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs19 = glat(il)
            ELSE
              abs19 = -glat(il)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs43 = glat(il)
            ELSE
              abs43 = -glat(il)
            END IF
            IF (abs19 .GT. 45. .AND. abs43 .LE. 80.) THEN
              seasn(il) = 2.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs20 = glat(il)
            ELSE
              abs20 = -glat(il)
            END IF
            IF (abs20 .GT. 80.) THEN
              seasn(il) = 4.
              CALL PUSHCONTROL2B(0)
            ELSE
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(2)
          END IF
          IF (iday .GE. 60 .AND. iday .LE. 90) THEN
            IF (glat(il) .GE. 0.) THEN
              abs21 = glat(il)
            ELSE
              abs21 = -glat(il)
            END IF
CMar.
            IF (abs21 .LE. 35.) THEN
              seasn(il) = 1.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs22 = glat(il)
            ELSE
              abs22 = -glat(il)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs44 = glat(il)
            ELSE
              abs44 = -glat(il)
            END IF
            IF (abs22 .GT. 35. .AND. abs44 .LE. 65.) THEN
              seasn(il) = 2.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs23 = glat(il)
            ELSE
              abs23 = -glat(il)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs45 = glat(il)
            ELSE
              abs45 = -glat(il)
            END IF
            IF (abs23 .GT. 65. .AND. abs45 .LE. 80.) THEN
              seasn(il) = 3.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs24 = glat(il)
            ELSE
              abs24 = -glat(il)
            END IF
            IF (abs24 .GT. 80.) THEN
              seasn(il) = 4.
              CALL PUSHCONTROL2B(0)
            ELSE
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(2)
          END IF
          IF (iday .GE. 91 .AND. iday .LE. 120) THEN
            IF (glat(il) .GE. 0.) THEN
              abs25 = glat(il)
            ELSE
              abs25 = -glat(il)
            END IF
CApr.
            IF (abs25 .LE. 35.) THEN
              seasn(il) = 1.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs26 = glat(il)
            ELSE
              abs26 = -glat(il)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs46 = glat(il)
            ELSE
              abs46 = -glat(il)
            END IF
            IF (abs26 .GT. 35. .AND. abs46 .LE. 45.) THEN
              seasn(il) = 2.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs27 = glat(il)
            ELSE
              abs27 = -glat(il)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs47 = glat(il)
            ELSE
              abs47 = -glat(il)
            END IF
            IF (abs27 .GT. 45. .AND. abs47 .LE. 65.) THEN
              seasn(il) = 3.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs28 = glat(il)
            ELSE
              abs28 = -glat(il)
            END IF
            IF (abs28 .GT. 65.) THEN
              seasn(il) = 4.
              CALL PUSHCONTROL2B(0)
            ELSE
              CALL PUSHCONTROL2B(1)
            END IF
          ELSE
            CALL PUSHCONTROL2B(2)
          END IF
C
          IF (iday .GE. 121 .AND. iday .LE. 151) THEN
            IF (glat(il) .GE. 0.) THEN
              abs29 = glat(il)
            ELSE
              abs29 = -glat(il)
            END IF
CMay.
            IF (abs29 .LE. 35.) THEN
              seasn(il) = 1.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs30 = glat(il)
            ELSE
              abs30 = -glat(il)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs48 = glat(il)
            ELSE
              abs48 = -glat(il)
            END IF
            IF (abs30 .GT. 35. .AND. abs48 .LE. 40.) THEN
              seasn(il) = 2.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs31 = glat(il)
            ELSE
              abs31 = -glat(il)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs49 = glat(il)
            ELSE
              abs49 = -glat(il)
            END IF
            IF (abs31 .GT. 40. .AND. abs49 .LE. 50.) THEN
              seasn(il) = 3.
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
            IF (glat(il) .GE. 0.) THEN
              abs32 = glat(il)
            ELSE
              abs32 = -glat(il)
            END IF
            IF (abs32 .GT. 50.) THEN
              seasn(il) = 4.
              CALL PUSHCONTROL3B(3)
            ELSE
              CALL PUSHCONTROL3B(4)
            END IF
          ELSE
            CALL PUSHCONTROL3B(5)
          END IF
        END IF
C
C
        IF (seasn(il) .EQ. 3 .AND. psnow(il) .GT. 0.1) THEN
          seasn(il) = 4.
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHCONTROL1B(1)
        END IF
        IF (seasn(il) .EQ. 4 .AND. psnow(il) .LT. 0.1) THEN
          seasn(il) = 3.
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHCONTROL1B(1)
        END IF
      ENDDO
C
C
C
C J for species, I for LUC, IL for grids.
C
C
      DO j=1,ng0
        DO i=1,luc
          DO il=il1,il2
            CALL PUSHINTEGER4(isea)
            isea = INT(seasn(il))
C
C --- CONSIDER ONLY LAND USE CATEGORIES .GT. 0.005
C
            IF (f(il, i) .LT. 0.005) THEN
              CALL PUSHCONTROL1B(0)
            ELSE
              IF (u2i(il) .LT. 1.0) THEN
                CALL PUSHREAL8(u2)
                u2 = 1.0
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHREAL8(u2)
                u2 = u2i(il)
                CALL PUSHCONTROL1B(1)
              END IF
              CALL PUSHREAL8(zz0(il))
              zz0(il) = z0(i, isea)
C
C --- PERCENTAGE OF GRID AREA OVER WATER [SPECIFIC!!, CHANGE WITH LANDUSE]
C
              fw = f(il, 11) + f(il, 13) + f(il, 14)
C
C --- PERCENTAGE OF GRID AREA OVER LAND
C
              pland = 1. - fw
              CALL PUSHREAL8(pcwc)
C
              pcwc = 0.
              IF (rh(il) .GE. 0.9) pcwc = 0.3
              CALL PUSHREAL8(sncov)
C
C --- CELL SNOW .LE. CELL W/LAND
C
              sncov = psnow(il)
              IF (psnow(il) .GT. pland) THEN
                sncov = pland
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHCONTROL1B(1)
              END IF
              CALL PUSHREAL8(icecov)
              icecov = pice(il)
C --- CELL ICE .LE. CELL W/WATER
              IF (pice(il) .GT. fw) THEN
                icecov = fw
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHCONTROL1B(1)
              END IF
              CALL PUSHREAL8(smax)
C
C --- STOMATAL APERTURE AS FUNCTION OF SOLAR IRRADIANCE AND
C --- SOIL MOISTURE
C
              smax = scon*COS((glat(il)-23.45)*rad)
              b = bmax*srad(il)*(1.-0.8*fcld(il))/smax + bmin
              CALL PUSHINTEGER4(iw)
              iw = 0
              IF ((i .EQ. 11 .OR. i .EQ. 13) .OR. i .EQ. 14) iw = 1
C
C --- DETERMINE ICE FRACTION OF WATER CATEGORIES
C --- (NOTE THAT ICECOVER DATA IS ASSUMED TO BE IN FRACTIONS OF ENTIRE
C --- GRID CELL AREA AND NOT FRACTION OF WATER SURFACE AREA.  CHECK
C --- DATA FOR COMPATIBILITY)
C --- FICE IS FRACTION OF CELL WATER WITH ICE
C --- FSNOW IS FRACTION OF CELL LAND THAT IS SNOW
C
              IF ((i .EQ. 11 .OR. i .EQ. 13) .OR. i .EQ. 14) THEN
                CALL PUSHREAL8(fice)
                fice = icecov/fw
                CALL PUSHREAL8(fsnow)
                fsnow = 0.0
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHREAL8(fice)
                fice = 0.
                CALL PUSHREAL8(fsnow)
                fsnow = sncov/pland
                CALL PUSHCONTROL1B(1)
              END IF
              CALL PUSHREAL8(t2p)
C
C --- POTENTIAL TEMPERATURE AT Z2  (DEG. K)
C
              t2p = t2(il) + z2*0.0098
C***********************************************************************
C       FROM OCD MODEL: FOR CALCULATIONS OVER WATER
C COMPUTE VALUES OF CRITICAL PROFILE VARIABLES: L AND USTAR
C
C***********************************************************************
C**************************BEGIN FOR WATER******************************
              IF (i .EQ. 13 .OR. i .EQ. 14) THEN
                CALL PUSHREAL8(e)
C
C ---    VAPOUR PRESSURE AT Z2
C
                e = rh(il)*(6.108*EXP(17.27*(t2(il)-273.16)/(t2(il)-
     +            35.86)))
                CALL PUSHREAL8(q)
C ---    WATER VAPOUR MIXING RATIO AT  Z2
                q = 0.622*e/(pmb-e)
C ---    VIRTUAL POTENTIAL TEMPERATURE AT Z2 (DEG. K)
                t2pv = t2p*(1.+0.61*q)
C
C --- ASSUME RH AT WATER SURFACE IS 100%
C ***    E = ES(TSW-273.15) !SAT. VAP PRESS AT SURFACE
C ---    SATURATED VAPOUR PRESSURE AT SURFACE
C
                tsw = ts(il)
                CALL PUSHREAL8(e)
                e = 6.108*EXP(17.27*(tsw-273.16)/(tsw-35.86))
C
C ---    SATURATED MIXING RATIO AT SURFACE
C
                qs = 0.622*e/(pmb-e)
C ---    VIRTUAL POTENTIAL TEMPERATURE AT SURFACE (DEG. K)
                tsv = tsw*(1.+0.61*qs)
C ---    * SCALET  :  NOT REQUIRED IF  Z2 = 10M
                dthv = t2pv - tsv
                CALL PUSHREAL8(cun)
C
C --- CALCULATE DRAG COEFFICIENT CUN WITH NEUTRAL CONDITION ASSUMPTION
C ---       -- GARRATT (1977)
C
                cun = 7.5e-4 + 6.7e-5*u2
                CALL PUSHREAL8(el)
C
                el = 9999.
                IF (dthv .GE. 0.) THEN
                  abs33 = dthv
                ELSE
                  abs33 = -dthv
                END IF
                IF (abs33 .GT. 1.0e-6) THEN
                  el = t2pv*cun**1.5*u2**2/(5.096e-3*dthv)
                  CALL PUSHCONTROL1B(0)
                ELSE
                  CALL PUSHCONTROL1B(1)
                END IF
                IF (el .GT. 0. .AND. el .LT. 5.0) THEN
                  el = 5.0
                  CALL PUSHCONTROL1B(0)
                ELSE
                  CALL PUSHCONTROL1B(1)
                END IF
                IF (el .GT. -5.0 .AND. el .LT. 0) THEN
                  el = -5.0
                  CALL PUSHCONTROL1B(0)
                ELSE
                  CALL PUSHCONTROL1B(1)
                END IF
                zdl = z2/el
                IF (zdl .LT. 0.0) THEN
C --- WIND SPEED
                  x = (1.0-15.0*zdl)**0.25
                  CALL PUSHREAL8(psiu)
                  psiu = 2.*ALOG(0.5*(1.0+x)) + ALOG(0.5*(1.0+x*x)) - 
     +              2.0*ATAN(x) + 0.5*pi
C --- POT TEMP
                  CALL PUSHCONTROL1B(0)
                ELSE
                  CALL PUSHREAL8(psiu)
                  psiu = -(4.7*zdl)
                  CALL PUSHCONTROL1B(1)
                END IF
                z0water = 0.000002*u2**2.5
                CALL PUSHREAL8(ustar)
                ustar = k*u2/(ALOG(z2/z0water)-psiu)
                zz0(il) = z0water
C
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHREAL8(rib)
C
C --- COMPUTE USTAR AND L FOR LAND USE CATEGORIES OTHER THAN WATER.
C --- USE LOUIS METHOD. !PKK 7/16/85
C --- FIND BULK RICHARDSON NUMBER.
C
                rib = g*z2*(t2p-ts(il))/(ts(il)*u2**2)
C
C --- ENSURE THAT CONDITIONS OVER LAND ARE NEVER STABLE WHEN THERE IS
C     INCOMING SOLAR RADIATIOM
C
                IF (srad(il) .GT. 0.0 .AND. rib .GT. 0.0) THEN
                  rib = 1.e-15
                  CALL PUSHCONTROL1B(1)
                ELSE
                  CALL PUSHCONTROL1B(0)
                END IF
                CALL PUSHREAL8(deltat)
                deltat = t2p - ts(il)
                IF (deltat .GE. 0.) THEN
                  abs34 = deltat
                ELSE
                  abs34 = -deltat
                END IF
                IF (abs34 .LT. 1.e-10) THEN
                  deltat = SIGN(1.e-10, deltat)
                  CALL PUSHCONTROL1B(0)
                ELSE
                  CALL PUSHCONTROL1B(1)
                END IF
                CALL PUSHREAL8(tbar)
                tbar = 0.5*(t2p+ts(il))
                ratioz = z2/zz0(il)
                CALL PUSHREAL8(logratio)
                logratio = ALOG(ratioz)
                CALL PUSHREAL8(asq)
                asq = 0.16/logratio**2
                IF (rib .LE. 0.) THEN
                  aa = asq*9.4*SQRT(ratioz)
                  CALL PUSHREAL8(cm)
                  cm = 7.4*aa
                  CALL PUSHREAL8(ch)
                  ch = 5.3*aa
                  IF (rib .GE. 0.) THEN
                    CALL PUSHREAL8(abs35)
                    abs35 = rib
                    CALL PUSHCONTROL1B(0)
                  ELSE
                    CALL PUSHREAL8(abs35)
                    abs35 = -rib
                    CALL PUSHCONTROL1B(1)
                  END IF
                  CALL PUSHREAL8(fm)
                  fm = 1. - 9.4*rib/(1.+cm*SQRT(abs35))
                  IF (rib .GE. 0.) THEN
                    CALL PUSHREAL8(abs36)
                    abs36 = rib
                    CALL PUSHCONTROL1B(0)
                  ELSE
                    CALL PUSHREAL8(abs36)
                    abs36 = -rib
                    CALL PUSHCONTROL1B(1)
                  END IF
                  CALL PUSHREAL8(fh)
                  fh = 1. - 9.4*rib/(1.+ch*SQRT(abs36))
                  CALL PUSHCONTROL1B(0)
                ELSE
                  CALL PUSHREAL8(fm)
                  fm = 1./(1.+4.7*rib)**2
                  CALL PUSHREAL8(fh)
                  fh = fm
                  CALL PUSHCONTROL1B(1)
                END IF
                CALL PUSHREAL8(ustarsq)
                ustarsq = asq*u2**2*fm
                CALL PUSHREAL8(utstar)
                utstar = asq*u2*deltat*fh/0.74
                CALL PUSHREAL8(ustar)
                ustar = SQRT(ustarsq)
                CALL PUSHREAL8(thstar)
                thstar = utstar/ustar
                CALL PUSHREAL8(el)
                el = tbar*ustarsq/(0.4*9.8*thstar)
C ***
                CALL PUSHCONTROL1B(1)
              END IF
              kui = 1./(k*ustar)
              CALL PUSHREAL8(usi(il, i))
              usi(il, i) = ustar
C
C---------------COMPUTE RA---------------
              z = z2
              zl = z/el
              IF (zl .GE. 0.) THEN
                CALL PUSHREAL8(ra(il, i))
                ra(il, i) = kui*(.74*ALOG(z/zz0(il))+4.7*zl)
                CALL PUSHCONTROL1B(1)
              ELSE
                CALL PUSHREAL8(ra(il, i))
                ra(il, i) = kui*.74*(ALOG(z/zz0(il))-2*ALOG((1+SQRT(1-9.
     +            *zl))*0.5))
                CALL PUSHCONTROL1B(0)
              END IF
              IF (ra(il, i) .LT. 0.99) THEN
                ra(il, i) = 0.99
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHCONTROL1B(1)
                ra(il, i) = ra(il, i)
              END IF
              IF (ra(il, i) .GT. 999.9) THEN
                ra(il, i) = 999.9
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHCONTROL1B(1)
                ra(il, i) = ra(il, i)
              END IF
C
C----------------COMPUTE RD AND RC--------------
C
C --- RD FOR GASES
C
C
C --- RC FOR GASES
C
C --- FOR VEGETATION
C
              d = vi/sc(j)
C
C --- STOMATAL PORE RESISTANCE
C
              rp = p/(b*d)
C
C --- MESOPHYLL RESISTANCE
C
              rm = rm0(j)
C
C --- TOTAL STOMATAL RESISTANCE
C
              rst = rp + rm
              CALL PUSHREAL8(rcut)
C
C --- CUTICLE RESISTANCE
C
              rcut = a0/ac(j)*rcut0
              IF ((isea .LE. 2 .OR. isea .EQ. 5) .AND. (j .EQ. 1 .OR. j 
     +            .EQ. 3)) THEN
                rcut = 3000.*a0/ac(j)
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHCONTROL1B(1)
              END IF
              CALL PUSHREAL8(rcf)
C
C --- FOLIAGE RESISTANCE INCLUDING THE EFFECT OF WETTED LEAVES
C
              rcf = 1./(1./rst+(1.-pcwc)/rcut+pcwc/rcw(j)/(lai(i, isea)+
     +          0.01))
              CALL PUSHREAL8(rcg)
C
C --- GROUND RESISTANCE (SOIL OR SNOW)
C
              rcg = a0/ac(j)*rcg0
              IF (j .EQ. 1 .OR. j .EQ. 3) THEN
                rcg = 800.
                IF (isea .NE. 4 .OR. isea .NE. 3) THEN
                  rcg = 1000.*a0/ac(j)
                  CALL PUSHCONTROL2B(0)
                ELSE
                  CALL PUSHCONTROL2B(1)
                END IF
              ELSE
                CALL PUSHCONTROL2B(2)
              END IF
              CALL PUSHREAL8(rsn)
              rsn = a0/ac(j)*rsn0
              IF (j .EQ. 1 .OR. j .EQ. 3) THEN
                IF (isea .EQ. 4 .OR. isea .EQ. 3) THEN
                  rsn = 1000.
                  CALL PUSHCONTROL2B(0)
                ELSE
                  CALL PUSHCONTROL2B(1)
                END IF
              ELSE
                CALL PUSHCONTROL2B(2)
              END IF
C
C
C --- TOTAL CANOPY RESISTANCE INCLUDING RESISTANCE TO WATER SUFACES,
C ---  FOLIAGE, BARE GROUND, AND SNOW OR ICE
C
              IF ((isea .EQ. 3 .OR. isea .EQ. 4) .AND. (j .EQ. 1 .OR. j 
     +            .EQ. 3)) THEN
                CALL PUSHREAL8(tscent)
C ---   RC=1./(FSNOW/RSN+(1.-FSNOW)/RCG+(TS+20.-273.)/(100.*(1.+PCWC)))
C
                tscent = ts(il) - 273.16
                IF (-15. .LT. tscent) THEN
                  CALL PUSHCONTROL1B(0)
                  tscent = tscent
                ELSE
                  tscent = -15.
                  CALL PUSHCONTROL1B(1)
                END IF
                IF (20. .GT. tscent) THEN
                  CALL PUSHCONTROL1B(0)
                  tscent = tscent
                ELSE
                  tscent = 20.
                  CALL PUSHCONTROL1B(1)
                END IF
                CALL PUSHREAL8(rc)
                rc = 1./(fsnow/rsn+(1.-fsnow)/rcg+(tscent+20.)/(10000.*(
     +            1.+pcwc)))
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHREAL8(rc)
                rc = 1./(lai(i, isea)/rcf+iw*(1.-fice)/rgw(j)+(1-iw)*(1.
     +            -fsnow)/rcg+((1-iw)*fsnow+fice)/rsn)
                CALL PUSHCONTROL1B(1)
              END IF
              CALL PUSHCONTROL1B(1)
            END IF
          ENDDO
        ENDDO
      ENDDO
      DO j=ng0,1,-1
        DO i=luc,1,-1
          DO il=il2,il1,-1
            CALL POPCONTROL1B(branch)
            IF (branch .NE. 0) THEN
              rd = 5./usi(il, i)*sc(j)**.666667
              vdf = 1./(ra(il, i)+rd+rc)
              vdfb = f(il, i)*vdgb(il, j)
              fb(il, i) = fb(il, i) + vdf*vdgb(il, j)
              temp27 = ra(il, i) + rd + rc
              temp27b = -(vdfb/temp27**2)
              rab(il, i) = rab(il, i) + temp27b
              rdb = temp27b
              rcb = temp27b
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                CALL POPREAL8(rc)
                temp20 = (-fsnow+1.)/rcg
                temp19 = fsnow/rsn + temp20 + (tscent+20.)/(10000.*(pcwc
     +            +1.))
                temp19b2 = -(rcb/temp19**2)
                fsnowb = (1.0/rsn-1.0/rcg)*temp19b2
                rsnb = -(fsnow*temp19b2/rsn**2)
                rcgb = -(temp20*temp19b2/rcg)
                tscentb = temp19b2/(10000.*(pcwc+1.))
                CALL POPCONTROL1B(branch)
                IF (branch .NE. 0) tscentb = 0.0
                CALL POPCONTROL1B(branch)
                IF (branch .NE. 0) tscentb = 0.0
                CALL POPREAL8(tscent)
                tsb(il) = tsb(il) + tscentb
                rcfb = 0.0
                ficeb = 0.0
              ELSE
                CALL POPREAL8(rc)
                temp26 = (-iw+1)*fsnow + fice
                temp24 = temp26/rsn
                temp23 = (-fsnow+1.)/rcg
                temp22 = (-fice+1.)/rgw(j)
                temp25 = lai(i, isea)/rcf
                temp21 = temp25 + iw*temp22 + (-iw+1)*temp23 + temp24
                temp21b = -(rcb/temp21**2)
                temp22b = iw*temp21b/rgw(j)
                temp23b = (1-iw)*temp21b/rcg
                temp24b = temp21b/rsn
                laib(i, isea) = laib(i, isea) + temp21b/rcf
                rcfb = -(temp25*temp21b/rcf)
                ficeb = temp24b - temp22b
                rgwb(j) = rgwb(j) - temp22*temp22b
                fsnowb = (1-iw)*temp24b - temp23b
                rcgb = -(temp23*temp23b)
                rsnb = -(temp24*temp24b)
              END IF
              CALL POPCONTROL2B(branch)
              IF (branch .EQ. 0) rsnb = 0.0
              CALL POPREAL8(rsn)
              temp19b1 = rsnb/ac(j)
              a0b = a0b + rsn0*temp19b1
              rsn0b = rsn0b + a0*temp19b1
              acb(j) = acb(j) - a0*rsn0*temp19b1/ac(j)
              CALL POPCONTROL2B(branch)
              IF (branch .EQ. 0) THEN
                temp19b0 = 1000.*rcgb/ac(j)
                a0b = a0b + temp19b0
                acb(j) = acb(j) - a0*temp19b0/ac(j)
              ELSE IF (branch .NE. 1) THEN
                GOTO 100
              END IF
              rcgb = 0.0
 100          CALL POPREAL8(rcg)
              temp19b = rcgb/ac(j)
              a0b = a0b + rcg0*temp19b
              rcg0b = rcg0b + a0*temp19b
              acb(j) = acb(j) - a0*rcg0*temp19b/ac(j)
              d = vi/sc(j)
              rm = rm0(j)
              b = bmax*srad(il)*(1.-0.8*fcld(il))/smax + bmin
              rp = p/(b*d)
              rst = rp + rm
              CALL POPREAL8(rcf)
              temp17 = rcw(j)*(lai(i, isea)+0.01)
              temp18 = (-pcwc+1.)/rcut
              temp16 = 1.0/rst + temp18 + pcwc/temp17
              temp16b4 = -(rcfb/temp16**2)
              temp17b = -(pcwc*temp16b4/temp17**2)
              rstb = -(temp16b4/rst**2)
              rcutb = -(temp18*temp16b4/rcut)
              rcwb(j) = rcwb(j) + (lai(i, isea)+0.01)*temp17b
              laib(i, isea) = laib(i, isea) + rcw(j)*temp17b
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                temp16b3 = 3000.*rcutb/ac(j)
                a0b = a0b + temp16b3
                acb(j) = acb(j) - a0*temp16b3/ac(j)
                rcutb = 0.0
              END IF
              temp16b2 = 5.*rdb/usi(il, i)
              CALL POPREAL8(rcut)
              temp16b = rcutb/ac(j)
              a0b = a0b + rcut0*temp16b
              rcut0b = rcut0b + a0*temp16b
              acb(j) = acb(j) - a0*rcut0*temp16b/ac(j)
              rpb = rstb
              rmb = rstb
              rm0b(j) = rm0b(j) + rmb
              temp16b0 = rpb/(b*d)
              temp16b1 = -(p*temp16b0/(b*d))
              pb = pb + temp16b0
              bb = d*temp16b1
              db = b*temp16b1
              scb(j) = scb(j) + .666667*sc(j)**(-0.333333)*temp16b2 - vi
     +          *db/sc(j)**2
              usib(il, i) = usib(il, i) - sc(j)**.666667*temp16b2/usi(il
     +          , i)
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) rab(il, i) = 0.0
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) rab(il, i) = 0.0
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                z = z2
                kui = 1./(k*ustar)
                zl = z/el
                CALL POPREAL8(ra(il, i))
                temp15 = SQRT(-(9.*zl) + 1)
                temp14 = z/zz0(il)
                temp14b = .74*kui*rab(il, i)
                kuib = .74*(ALOG(temp14)-2*ALOG(0.5*(temp15+1)))*rab(il
     +            , i)
                zz0b(il) = zz0b(il) - temp14b/zz0(il)
                IF (1 - 9.*zl .EQ. 0.0) THEN
                  zlb = 0.0
                ELSE
                  zlb = 2*9.*temp14b/(2.0*temp15*(temp15+1))
                END IF
                rab(il, i) = 0.0
              ELSE
                z = z2
                kui = 1./(k*ustar)
                zl = z/el
                CALL POPREAL8(ra(il, i))
                temp13 = z/zz0(il)
                kuib = (.74*ALOG(temp13)+4.7*zl)*rab(il, i)
                zz0b(il) = zz0b(il) - .74*kui*rab(il, i)/zz0(il)
                zlb = kui*4.7*rab(il, i)
                rab(il, i) = 0.0
              END IF
              elb = -(z*zlb/el**2)
              CALL POPREAL8(usi(il, i))
              ustarb = usib(il, i) - kuib/(k*ustar**2)
              usib(il, i) = 0.0
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                z0water = 0.000002*u2**2.5
                CALL POPREAL8(ustar)
                temp6 = z2/z0water
                temp5 = ALOG(temp6) - psiu
                temp5b0 = k*ustarb/temp5
                temp5b = -(u2*temp5b0/temp5)
                z0waterb = zz0b(il) - temp5b/z0water
                zz0b(il) = 0.0
                u2b = 0.000002*2.5*u2**1.5*z0waterb + temp5b0
                psiub = -temp5b
                CALL POPCONTROL1B(branch)
                IF (branch .EQ. 0) THEN
                  zdl = z2/el
                  x = (1.0-15.0*zdl)**0.25
                  CALL POPREAL8(psiu)
                  xb = (2*x/(x**2+1.0)-2.0/(1.0+x**2)+2./(x+1.0))*psiub
                  zdlb = -(0.25*(1.0-15.0*zdl)**(-0.75)*15.0*xb)
                ELSE
                  CALL POPREAL8(psiu)
                  zdlb = -(4.7*psiub)
                END IF
                elb = elb - z2*zdlb/el**2
                CALL POPCONTROL1B(branch)
                IF (branch .EQ. 0) elb = 0.0
                CALL POPCONTROL1B(branch)
                IF (branch .EQ. 0) elb = 0.0
                qs = 0.622*e/(pmb-e)
                t2p = t2(il) + z2*0.0098
                tsw = ts(il)
                tsv = tsw*(1.+0.61*qs)
                t2pv = t2p*(1.+0.61*q)
                dthv = t2pv - tsv
                CALL POPCONTROL1B(branch)
                IF (branch .EQ. 0) THEN
                  temp4 = 5.096e-3*dthv
                  temp3 = t2pv*u2**2
                  temp2 = temp3/temp4
                  temp2b0 = cun**1.5*elb/temp4
                  cunb = temp2*1.5*cun**0.5*elb
                  t2pvb = u2**2*temp2b0
                  u2b = u2b + t2pv*2*u2*temp2b0
                  dthvb = -(temp2*5.096e-3*temp2b0)
                ELSE
                  dthvb = 0.0
                  cunb = 0.0
                  t2pvb = 0.0
                END IF
                CALL POPREAL8(el)
                CALL POPREAL8(cun)
                u2b = u2b + 6.7e-5*cunb
                t2pvb = t2pvb + dthvb
                tsvb = -dthvb
                qsb = tsw*0.61*tsvb
                temp2b = 0.622*qsb/(pmb-e)
                eb = (e/(pmb-e)+1.0)*temp2b
                CALL POPREAL8(e)
                temp1 = (tsw-273.16)/(tsw-35.86)
                temp1b = 17.27*EXP(17.27*temp1)*6.108*eb/(tsw-35.86)
                tswb = (1.0-temp1)*temp1b + (0.61*qs+1.)*tsvb
                tsb(il) = tsb(il) + tswb
                t2pb = (0.61*q+1.)*t2pvb
                qb = t2p*0.61*t2pvb
                CALL POPREAL8(q)
                temp1b0 = 0.622*qb/(pmb-e)
                eb = (e/(pmb-e)+1.0)*temp1b0
                CALL POPREAL8(e)
                temp0 = (t2(il)-273.16)/(t2(il)-35.86)
                temp0b = 17.27*EXP(17.27*temp0)*rh(il)*6.108*eb/(t2(il)-
     +            35.86)
                rhb(il) = rhb(il) + 6.108*EXP(17.27*temp0)*eb
                t2b(il) = t2b(il) + (1.0-temp0)*temp0b
              ELSE
                CALL POPREAL8(el)
                temp12 = 0.4*9.8*thstar
                temp12b = elb/temp12
                tbarb = ustarsq*temp12b
                thstarb = -(tbar*ustarsq*0.4*9.8*temp12b/temp12)
                CALL POPREAL8(thstar)
                utstarb = thstarb/ustar
                ustarb = ustarb - utstar*thstarb/ustar**2
                IF (ustarsq .EQ. 0.0) THEN
                  ustarsqb = tbar*temp12b
                ELSE
                  ustarsqb = ustarb/(2.0*SQRT(ustarsq)) + tbar*temp12b
                END IF
                CALL POPREAL8(ustar)
                CALL POPREAL8(utstar)
                temp12b0 = u2*deltat*utstarb
                temp12b1 = asq*fh*utstarb/0.74
                fhb = asq*temp12b0/0.74
                u2b = asq*fm*2*u2*ustarsqb + deltat*temp12b1
                deltatb = u2*temp12b1
                CALL POPREAL8(ustarsq)
                temp12b2 = u2**2*ustarsqb
                asqb = fm*temp12b2 + fh*temp12b0/0.74
                fmb = asq*temp12b2
                CALL POPCONTROL1B(branch)
                IF (branch .EQ. 0) THEN
                  CALL POPREAL8(fh)
                  temp10 = SQRT(abs36)
                  temp10b = -(9.4*fhb/(ch*temp10+1.))
                  temp10b0 = -(rib*temp10b/(ch*temp10+1.))
                  ribb = temp10b
                  chb = temp10*temp10b0
                  IF (abs36 .EQ. 0.0) THEN
                    abs36b = 0.0
                  ELSE
                    abs36b = ch*temp10b0/(2.0*temp10)
                  END IF
                  CALL POPCONTROL1B(branch)
                  IF (branch .EQ. 0) THEN
                    CALL POPREAL8(abs36)
                    ribb = ribb + abs36b
                  ELSE
                    CALL POPREAL8(abs36)
                    ribb = ribb - abs36b
                  END IF
                  CALL POPREAL8(fm)
                  temp9 = SQRT(abs35)
                  temp9b = -(9.4*fmb/(cm*temp9+1.))
                  temp9b0 = -(rib*temp9b/(cm*temp9+1.))
                  ribb = ribb + temp9b
                  cmb = temp9*temp9b0
                  IF (abs35 .EQ. 0.0) THEN
                    abs35b = 0.0
                  ELSE
                    abs35b = cm*temp9b0/(2.0*temp9)
                  END IF
                  CALL POPCONTROL1B(branch)
                  IF (branch .EQ. 0) THEN
                    CALL POPREAL8(abs35)
                    ribb = ribb + abs35b
                  ELSE
                    CALL POPREAL8(abs35)
                    ribb = ribb - abs35b
                  END IF
                  CALL POPREAL8(ch)
                  aab = 7.4*cmb + 5.3*chb
                  CALL POPREAL8(cm)
                  ratioz = z2/zz0(il)
                  temp8 = SQRT(ratioz)
                  asqb = asqb + 9.4*temp8*aab
                  IF (ratioz .EQ. 0.0) THEN
                    ratiozb = 0.0
                  ELSE
                    ratiozb = asq*9.4*aab/(2.0*temp8)
                  END IF
                ELSE
                  CALL POPREAL8(fh)
                  fmb = fmb + fhb
                  CALL POPREAL8(fm)
                  temp11 = 4.7*rib + 1.
                  ribb = -(2*4.7*fmb/temp11**3)
                  ratioz = z2/zz0(il)
                  ratiozb = 0.0
                END IF
                CALL POPREAL8(asq)
                logratiob = -(0.16*2*asqb/logratio**3)
                CALL POPREAL8(logratio)
                ratiozb = ratiozb + logratiob/ratioz
                zz0b(il) = zz0b(il) - z2*ratiozb/zz0(il)**2
                CALL POPREAL8(tbar)
                t2pb = 0.5*tbarb
                tsb(il) = tsb(il) + 0.5*tbarb
                CALL POPCONTROL1B(branch)
                IF (branch .EQ. 0) deltatb = 0.0
                CALL POPREAL8(deltat)
                t2pb = t2pb + deltatb
                tsb(il) = tsb(il) - deltatb
                CALL POPCONTROL1B(branch)
                IF (branch .NE. 0) ribb = 0.0
                CALL POPREAL8(rib)
                temp7 = ts(il)*u2**2
                temp7b = g*z2*ribb/temp7
                temp7b0 = -((t2p-ts(il))*temp7b/temp7)
                t2pb = t2pb + temp7b
                tsb(il) = tsb(il) + u2**2*temp7b0 - temp7b
                u2b = u2b + ts(il)*2*u2*temp7b0
              END IF
              CALL POPREAL8(t2p)
              t2b(il) = t2b(il) + t2pb
              fw = f(il, 11) + f(il, 13) + f(il, 14)
              pland = 1. - fw
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                CALL POPREAL8(fsnow)
                CALL POPREAL8(fice)
                icecovb = ficeb/fw
                fwb = -(icecov*ficeb/fw**2)
                plandb = 0.0
                sncovb = 0.0
              ELSE
                CALL POPREAL8(fsnow)
                sncovb = fsnowb/pland
                plandb = -(sncov*fsnowb/pland**2)
                CALL POPREAL8(fice)
                icecovb = 0.0
                fwb = 0.0
              END IF
              CALL POPINTEGER4(iw)
              sradb(il) = sradb(il) + (1.-0.8*fcld(il))*bmax*bb/smax
              fcldb(il) = fcldb(il) - srad(il)*bmax*0.8*bb/smax
              CALL POPREAL8(smax)
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                fwb = fwb + icecovb
                icecovb = 0.0
              END IF
              CALL POPREAL8(icecov)
              piceb(il) = piceb(il) + icecovb
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                plandb = plandb + sncovb
                sncovb = 0.0
              END IF
              CALL POPREAL8(sncov)
              psnowb(il) = psnowb(il) + sncovb
              CALL POPREAL8(pcwc)
              fwb = fwb - plandb
              fb(il, 11) = fb(il, 11) + fwb
              fb(il, 13) = fb(il, 13) + fwb
              fb(il, 14) = fb(il, 14) + fwb
              CALL POPREAL8(zz0(il))
              z0b(i, isea) = z0b(i, isea) + zz0b(il)
              zz0b(il) = 0.0
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                CALL POPREAL8(u2)
              ELSE
                CALL POPREAL8(u2)
                u2ib(il) = u2ib(il) + u2b
              END IF
            END IF
            CALL POPINTEGER4(isea)
            rab(il, i) = 0.0
          ENDDO
        ENDDO
      ENDDO
      DO il=il2,il1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) seasnb(il) = 0.0
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) seasnb(il) = 0.0
        CALL POPCONTROL3B(branch)
        IF (branch .LT. 3) THEN
          IF (branch .EQ. 0) THEN
            seasnb(il) = 0.0
          ELSE IF (branch .NE. 1) THEN
            GOTO 110
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
 110      CALL POPCONTROL2B(branch)
          IF (branch .EQ. 0) THEN
            seasnb(il) = 0.0
          ELSE IF (branch .NE. 1) THEN
            GOTO 120
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
 120      CALL POPCONTROL2B(branch)
          IF (branch .EQ. 0) THEN
            seasnb(il) = 0.0
          ELSE IF (branch .NE. 1) THEN
            GOTO 130
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
 130      CALL POPCONTROL2B(branch)
          IF (branch .EQ. 0) THEN
            seasnb(il) = 0.0
          ELSE IF (branch .NE. 1) THEN
            GOTO 140
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
 140      CALL POPCONTROL2B(branch)
          IF (branch .EQ. 0) THEN
            seasnb(il) = 0.0
          ELSE IF (branch .NE. 1) THEN
            GOTO 150
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
 150      CALL POPCONTROL2B(branch)
          IF (branch .EQ. 0) THEN
            seasnb(il) = 0.0
          ELSE IF (branch .NE. 1) THEN
            GOTO 160
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
 160      CALL POPCONTROL2B(branch)
          IF (branch .EQ. 0) THEN
            seasnb(il) = 0.0
          ELSE IF (branch .NE. 1) THEN
            GOTO 170
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
 170      CALL POPCONTROL2B(branch)
          IF (branch .EQ. 0) THEN
            seasnb(il) = 0.0
          ELSE IF (branch .NE. 1) THEN
            GOTO 180
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
 180      CALL POPCONTROL2B(branch)
          IF (branch .EQ. 0) THEN
            seasnb(il) = 0.0
          ELSE IF (branch .NE. 1) THEN
            GOTO 190
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
 190      CALL POPCONTROL2B(branch)
          IF (branch .EQ. 0) THEN
            seasnb(il) = 0.0
          ELSE IF (branch .NE. 1) THEN
            GOTO 290
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) seasnb(il) = 0.0
        ELSE
          IF (branch .EQ. 3) THEN
            seasnb(il) = 0.0
          ELSE IF (branch .NE. 4) THEN
            GOTO 200
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
 200      CALL POPCONTROL2B(branch)
          IF (branch .EQ. 0) THEN
            seasnb(il) = 0.0
          ELSE IF (branch .NE. 1) THEN
            GOTO 210
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
 210      CALL POPCONTROL2B(branch)
          IF (branch .EQ. 0) THEN
            seasnb(il) = 0.0
          ELSE IF (branch .NE. 1) THEN
            GOTO 220
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
 220      CALL POPCONTROL2B(branch)
          IF (branch .EQ. 0) THEN
            seasnb(il) = 0.0
          ELSE IF (branch .NE. 1) THEN
            GOTO 230
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
 230      CALL POPCONTROL2B(branch)
          IF (branch .EQ. 0) THEN
            seasnb(il) = 0.0
          ELSE IF (branch .NE. 1) THEN
            GOTO 240
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
 240      CALL POPCONTROL2B(branch)
          IF (branch .EQ. 0) THEN
            seasnb(il) = 0.0
          ELSE IF (branch .NE. 1) THEN
            GOTO 250
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
 250      CALL POPCONTROL2B(branch)
          IF (branch .EQ. 0) THEN
            seasnb(il) = 0.0
          ELSE IF (branch .NE. 1) THEN
            GOTO 260
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
 260      CALL POPCONTROL2B(branch)
          IF (branch .EQ. 0) THEN
            seasnb(il) = 0.0
          ELSE IF (branch .NE. 1) THEN
            GOTO 270
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
 270      CALL POPCONTROL2B(branch)
          IF (branch .EQ. 0) THEN
            seasnb(il) = 0.0
          ELSE IF (branch .NE. 1) THEN
            GOTO 280
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
 280      CALL POPCONTROL2B(branch)
          IF (branch .EQ. 0) THEN
            seasnb(il) = 0.0
          ELSE IF (branch .NE. 1) THEN
            GOTO 290
          END IF
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
          CALL POPCONTROL1B(branch)
          IF (branch .NE. 0) seasnb(il) = 0.0
        END IF
 290    CONTINUE
      ENDDO
      DO i=il2,il1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) fcldb(i) = 0.0
      ENDDO
      DO l=ilev,1,-1
        DO i=il2,il1,-1
          cldcvb(i, l, 1) = cldcvb(i, l, 1) + fcldb(i)
          cldcvb(i, l, 2) = cldcvb(i, l, 2) + fcldb(i)
        ENDDO
      ENDDO
      CALL POPREAL8ARRAY(fcld, ilg)
      CALL POPINTEGER4(ilg)
      CALL PUTZERO_B(fcld, fcldb, ilg)
      CALL PUTZERO_B(vdg, vdgb, arg1)
      END
