C        Generated by TAPENADE     (INRIA, Tropics team)
C  Tapenade 3.6 (r4159) - 21 Sep 2011 10:11
C
C  Differentiation of difuvd2 in reverse (adjoint) mode:
C   gradient     of useful results: d p delta a b c
C   with respect to varying inputs: d p delta a b c
Ccopyright (C) 2001  MSC-RPN COMM  %%%RPNPHY%%%
C**S/P DIFUVD2
C
      SUBROUTINE DIFUVD2_B(p, pb, a, ab0, b, bb, c, cb, d, db, delta, 
     +                     deltab, np, n, nk)
      IMPLICIT NONE
      INTEGER np, n, nk
      REAL p(np, nk), a(n, nk), b(n, nk), c(n, nk), d(n, nk), delta(n, 
     +     nk)
      REAL pb(np, nk), ab0(n, nk), bb(n, nk), cb(n, nk), db(n, nk), 
     +     deltab(n, nk)
      REAL ap, ab, bx
      REAL apb, abb, bxb
C
CAuthor
C          R. Benoit(Mar 89)
C
CObject
C          this is the transverse vectorization of the subroutine
C          ROSSR1
C
CArguments
C
C          - Output -
C P        result
C
C          - Input -
C A        lower-diagonal
C B        diagonal
C C        upper-diagonal
C D        right side
C DELTA    work space
C NP       1st dimension of P
C N        1st dimension of all other vectors
C NK       2nd dimension (order)
C
CNotes
C          This subroutine solves the tri-diagonal matrix problem
C          below using ROSSR:
C
C  *****                                      ****  ****     ***    ****
C  *****                                      ****  ****     ***    ****
C  ** B(1),C(1), 0  , 0  , 0  , - - - -  ,  0   **  **  P(1)  **    **D(
C  ** A(2),B(2),C(2), 0  , 0  , - - - -  ,  0   **  **  P(2)  **    **D(
C  **  0  ,A(3),B(3),C(3), 0  , - - - -  ,  0   **  **  P(3)  **    **
C  **  0  , 0  ,A(4),B(4),C(4), - - - -  ,  0   **  **  P(4)  **    **
C  **  0  , 0  , 0  ,A(5),B(5), - - - -  ,  0   **  **  P(5)  ** -- **
C  **  -                                    -   **  **    -   ** -- **
C  **  -                                    -   **  **    -   **    **
C  **  0  ,  , 0 ,A(NK-2),B(NK-2),C(NK-2),  0   **  ** P(NK-2)**    **
C  **  0  ,  , 0 ,  0   ,A(NK-1),B(NK-1),C(NK-1)**  ** P(NK-1)**    **
C  **  0  ,  , 0 ,  0   ,   0   , A(NK) , B(NK) **  **  P(NK) **    **D(
C  ****                                       ****  ****    ****    ****
C  ****                                       ****  ****    ****    ****
C
C          Delta is a working array of dimension NK.  If the array D
C          is not required subsequently then the call CALL ROSSR1(P.A,
C          B,C,D,D,NK) will reduce storage requirements.  If further
C          the array C is not required subsequently, then the call
C          will further reduce storage requirements.
C
C*
C
C-----------------------------------------------------------------------
C
      REAL x
      REAL xb
      INTEGER i, k
      INTEGER branch
      REAL tempb
C
C      print*,'------before 10 --------------'
C
      DO i=1,n
        CALL PUSHreal8(c(i, nk))
        c(i, nk) = 0.
        x = 1./b(i, 1)
        p(i, 1) = -(c(i, 1)*x)
        delta(i, 1) = d(i, 1)*x
      ENDDO
C
C
C      print*,'------before 20 --------------'
C       DO K=1,NK
C         DO I=1,N
C         PRINT*,'K=       ',K
C         PRINT*,'I=        ',I
C         print*, A(I,K),B(I,K),C(I,K),D(I,K)
C        ENDDO
C       ENDDO
C
      DO k=2,nk
        DO i=1,n
C      PRINT*,'K=',K
C      print*,'I=',I
C      PRINT*,'B',B(I,K)
C      PRINT*,'P',P(I,K-1)
C
C      PRINT*,'A',A(I,K)
C      PRINT*,'A*P',A(I,K)*P(I,K-1)
C      print*,'C',C(I,K)
          bx = b(i, k)
          ap = a(i, k)*p(i, k-1)
          ab = bx + ap
          IF (ab .NE. 0.0) THEN
            CALL PUSHreal8(x)
            x = 1./ab
            CALL PUSHCONTROL1B(0)
          ELSE
            CALL PUSHreal8(x)
            x = 0.0
            CALL PUSHCONTROL1B(1)
          END IF
          CALL PUSHreal8(p(i, k))
C      print*,'X',X
C
          p(i, k) = -(c(i, k)*x)
          CALL PUSHreal8(delta(i, k))
C       print*,'P',P(I,K)
          delta(i, k) = (d(i, k)-a(i, k)*delta(i, k-1))*x
        ENDDO
      ENDDO
C      print*,'delta=',DELTA(I,K)
C
C
C      print*,'------before 30 --------------'
C
      DO i=1,n
        CALL PUSHreal8(p(i, nk))
        p(i, nk) = delta(i, nk)
      ENDDO
      DO k=nk-1,1,-1
        DO i=1,n
          CALL PUSHreal8(p(i, k))
          p(i, k) = p(i, k)*p(i, k+1) + delta(i, k)
        ENDDO
      ENDDO
      DO k=1,nk-1,1
        DO i=n,1,-1
          CALL POPreal8(p(i, k))
          pb(i, k+1) = pb(i, k+1) + p(i, k)*pb(i, k)
          deltab(i, k) = deltab(i, k) + pb(i, k)
          pb(i, k) = p(i, k+1)*pb(i, k)
        ENDDO
      ENDDO
      DO i=n,1,-1
        CALL POPreal8(p(i, nk))
        deltab(i, nk) = deltab(i, nk) + pb(i, nk)
        pb(i, nk) = 0.0
      ENDDO
      DO k=nk,2,-1
        DO i=n,1,-1
          CALL POPreal8(delta(i, k))
          tempb = x*deltab(i, k)
          db(i, k) = db(i, k) + tempb
          ab0(i, k) = ab0(i, k) - delta(i, k-1)*tempb
          deltab(i, k-1) = deltab(i, k-1) - a(i, k)*tempb
          xb = (d(i, k)-a(i, k)*delta(i, k-1))*deltab(i, k) - c(i, k)*pb
     +      (i, k)
          deltab(i, k) = 0.0
          CALL POPreal8(p(i, k))
          cb(i, k) = cb(i, k) - x*pb(i, k)
          pb(i, k) = 0.0
          ap = a(i, k)*p(i, k-1)
          bx = b(i, k)
          ab = bx + ap
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            CALL POPreal8(x)
            abb = -(xb/ab**2)
          ELSE
            CALL POPreal8(x)
            abb = 0.0
          END IF
          bxb = abb
          apb = abb
          ab0(i, k) = ab0(i, k) + p(i, k-1)*apb
          pb(i, k-1) = pb(i, k-1) + a(i, k)*apb
          bb(i, k) = bb(i, k) + bxb
        ENDDO
      ENDDO
      DO i=n,1,-1
        x = 1./b(i, 1)
        db(i, 1) = db(i, 1) + x*deltab(i, 1)
        xb = d(i, 1)*deltab(i, 1) - c(i, 1)*pb(i, 1)
        deltab(i, 1) = 0.0
        cb(i, 1) = cb(i, 1) - x*pb(i, 1)
        pb(i, 1) = 0.0
        bb(i, 1) = bb(i, 1) - xb/b(i, 1)**2
        CALL POPreal8(c(i, nk))
        cb(i, nk) = 0.0
      ENDDO
      END
