      SUBROUTINE CLDCHEM (   IL1,      IL2,     ILEV,     ILG,    ISO2
     1                  ,   IHPO,       NN,      NTR,  NTRACA,   ISIZE
     2                  ,   IAE1,    RCRIT,    RCOEX,  CLSIZE,   CLDCV
     3                  ,  ZMLWC,  H2O2ROW,   ROAROW,      TH, HNO3ROW
     4                  , NH3ROW,    O3ROW,   CO2ROW,   RGRID,   RTHPO
     5                  ,  RTSO4,    RTSO2,   PRESSG,     SHJ, AERONUM
     6                  ,   GRAV,     DSHJ,    IDEEP,      JT,    MAXG
     7                  ,     JD,     EPS0,       MU,      EU,      DU
     8                  ,     MD,       MC,       ED,      DP,      DZ
     9                  ,     MB,      MSG,      ZFG, LENGATH, DSUBCLD
     *                  , ASPRVA,   AGAMMA,   ARESID,  ASPECI,  AGTSO2
     1                  , AGTSO4,    AGTO3,   AGTCO2,  AGTNH3, AGTHNO3
     2                  ,  AGTNA,   AGTHO2,   AOH2O2,   AEQCA,   AEQCB
     3                  ,  AEQCC,   AEQCAI,   AEQCBI,  AEQCHP,  AEQCHO
     4                  , AEQHNO,   AEQNH3,   AEQHCL,  AORHP1,  AORHP2
     5                  ,  AORHO,   ANTSO2,   ANTHO2,  ANTSO4,     AMH
     6                  ,HPOXROW,      MUR,      MDR,     DUR,     EUR
     7                  ,    EDR,    KCALC,        X,      XD,      XG
     8                  ,   DXDT,     XHAT,     DXDX,      XU,    FACX
     9                  ,     OU,    SUMDX,      XGA,     XUA,   AFRAC
     *                  , AFRACF,        Z,     XROW,   KOUNT,   PXNEW
     1                  ,     RU,      RUA,   ASRSO2,  ASRHPO,AEROSIZE
     2                  ,  THLEV,   RTBCLD,       ID,   GDREM, MAE)
C***********************************************************************
C     Calculates incloud-oxidation and hydrogen peroxide production
C     and cumulus transport of tracers
C***********************************************************************
C
C---  method
C     This subroutine calculates the modifications of sulphur dioxide
C     and aerosol-sulphate concentrations due to incloud-oxidation.
C     It also calculates modifications of hydrogen peroxide concentratio
C     due to in-cloud oxidation and quasi-gas-phase production.
C     Sub-grid-scale stratiform and sub-grid-scale convective clouds
C     are considered.
C     Stratiform clouds: Initial S-species-concentrations are given by m
C                        grid point values; oxidation is calculated at e
C                        grid point for "closed-box"-boundary-values wit
C                        variable concentrations.
C     Convective clouds: Zhang & McFarlane scheme (1995) for S-species
C                        and hydrogen peroxide with stationary source/si
C                        terms during the transport-time-step and consta
C                        concentrations within updraft.
C
C---  HISTORY
C
C     JANUARY 20, 1998 KNUT VON SALZEN     NEW SUBROUTINE
C     JANUARY 27, 1998 KNUT VON SALZEN     SIMPLIFIED VERSION
C     FEBRUARY 2, 1998 KNUT VON SALZEN     MODIFIED FOR GCM
C     FEBUUARY 4, 1998 S.L.  GONG          VECTORIZATION OF WHOLE CODES
C                                          STRUCTUREAL CHANGES
C     APRIL 20, 1998   KNUT VON SALZEN     CORRECTED
C
C---  some important parameters
C
C     AERONUM REAL    INPUT - NUMBER-CONCENTRATION OF AEROSOL PARTICLES
C     AEQCA   REAL    WORK ARRAY
C     AEQCAI  REAL    WORK ARRAY
C     AEQCB   REAL    WORK ARRAY
C     AEQCBI  REAL    WORK ARRAY
C     AEQCC   REAL    WORK ARRAY
C     AEQCHNO REAL    WORK ARRAY
C     AEQCHO  REAL    WORK ARRAY
C     AEQCHP  REAL    WORK ARRAY
C     AEQHCL  REAL    WORK ARRAY
C     AEQNH3  REAL    WORK ARRAY
C     AFRAC   REAL    WORK ARRAY
C     AFRACF  REAL    WORK ARRAY
C     AGAMMA  REAL    WORK ARRAY
C     AGTCO2  REAL    WORK ARRAY
C     AGTHO2  REAL    WORK ARRAY
C     AGTHNO3 REAL    WORK ARRAY
C     AGTNA   REAL    WORK ARRAY
C     AGTNH3  REAL    WORK ARRAY
C     AGTO3   REAL    WORK ARRAY
C     AGTSO2  REAL    WORK ARRAY
C     AGTSO4  REAL    WORK ARRAY
C     AMH     REAL    WORK ARRAY
C     ANTHO2  REAL    WORK ARRAY
C     ANTSO2  REAL    WORK ARRAY
C     ANTSO4  REAL    WORK ARRAY
C     AOH2O2  REAL    WORK ARRAY
C     AORHO   REAL    WORK ARRAY
C     AORHP1  REAL    WORK ARRAY
C     AORHP2  REAL    WORK ARRAY
C     ARESID  REAL    WORK ARRAY
C     ASPECI  REAL    WORK ARRAY
C     ASPRVA  REAL    WORK ARRAY
C     CLDCV   REAL    INPUT - CLOUD COVER (1 -> STRATIFORM CLOUDS,
C                                          2 -> CONVECTIVE CLOUDS), 0 <=
C     CO2ROW  REAL    INPUT - CARBON DIOXIDE CONCENTRATION IN M**3/M**3
C     DP      REAL    INPUT
C     DZ      REAL    INPUT
C     DSHJ    REAL    INPUT
C     DU      REAL    INPUT
C     DUR     REAL    WORK ARRAY
C     DSUBCLD REAL    INPUT
C     DXDT    REAL    WORK ARRAY
C     DXDX    REAL    WORK ARRAY
C     EPS0    REAL    INPUT
C     ED      REAL    INPUT
C     EDR     REAL    WORK ARRAY
C     EU      REAL    INPUT
C     EUR     REAL    WORK ARRAY
C     FACX    REAL    WORK ARRAY
C     GRAV    REAL    INPUT - GRAVITATIONAL ACCELARATION
C     HNO3ROW REAL    INPUT - NITRIC ACID CONCENTRATION IN M**3/M**3
C     HPOXROW REAL    WORK ARRAY - BACKGROUND HYDROGEN PEROXIDE CONCENTR
C                                  IN KG-H2O2/KG-AIR
C     H2O2ROW REAL    INPUT - BACKGROUND HYDROGEN PEROXIDE CONCENTRATION
C                             IN M**3/M**3
C     IAE1    INTEGER INPUT - START INDEX FOR AEROSOL TRACER
C     IDEEP   INTEGER INPUT
C     ILEV    INTEGER INPUT - VERTICAL GRID COORDINATE
C     ILG     INTEGER INPUT - HORIZONTAL GRID COORDINATE
C     IL1     INTEGER INPUT - HORIZONTAL GRID COORDINATE
C     IL2     INTEGER INPUT - HORIZONTAL GRID COORDINATE
C     IHPO    INTEGER INPUT - TRACER INDEX FOR HYDROGEN PEROXIDE
C     ISO2    INTEGER INPUT - TRACER INDEX FOR SULPHUR DIOXIDE
C     ISIZE   INTEGER INPUT - NUMBER OF BINS
C     JD      INTEGER INPUT
C     JT      INTEGER INPUT
C     KCALC   LOGICAL WORK ARRAY
C     LENGATH INTEGER INPUT
C     MAXG    INTEGER INPUT
C     MB      REAL    INPUT
C     MC      REAL    INPUT
C     MD      REAL    INPUT
C     MSG     INTEGER INPUT
C     NH3ROW  REAL    INPUT - AMMONIA CONCENTRATION IN M**3/M**3
C     NN      INTEGER INPUT - AEROSOL TRACER TYPE INDEX FOR SULPHATE
C     NTR     INTEGER INPUT - TRACER INDEX
C     NTRACA  INTEGER INPUT - TRACER INDEX
C     MD      REAL    INPUT
C     MDR     REAL    WORK ARRAY
C     MU      REAL    INPUT
C     MUR     REAL    WORK ARRAY
C     OU      REAL    WORK ARRAY
C     O3ROW   REAL    INPUT - OZONE CONCENTRATION IN M**3/M**3
C     PRESSG  REAL    INPUT
C     RCOEX   REAL    INPUT - RADIUS OF AEROSOL-PARTICLES FOR PARTIALLY
C                             ACTIVATED BIN IN M
C     RCRIT   REAL    INPUT - BIN NUMBER (+ FRACTION UN-ACTIVATED) OF SM
C                             ACTIVATED BIN (1 -> STRATIFORM CLOUDS,
C                                            2 -> CONVECTIVE CLOUDS)
C     RGRID   REAL    INPUT - WORK SPACES
C     CLSIZE  REAL    INPUT - ACTIVATED RADIUS OF AEROSOL-PARTICLES IN M
C     ROAROW  REAL    INPUT - AIR DENSITY KG M-3
C     RTHPO   REAL    INPUT/OUTPUT - HYDROGEN PEROXIDE TENDENCY
C     RTICLD  REAL    INPUT/OUTPUT - TRACER TENDENCY
C     RTSO2   REAL    INPUT/OUTPUT - SULPHUR DIOXIDE TENDENCY
C     SHJ     REAL    INPUT
C     SUMDX   REAL    WORK ARRAY
C     TH      REAL    INPUT - TEMPERATURE IN K
C     X       REAL    WORK ARRAY
C     XD      REAL    WORK ARRAY
C     XG      REAL    WORK ARRAY
C     XGA     REAL    WORK ARRAY
C     XU      REAL    WORK ARRAY - UPDRAFT TRACER ARRAY IN KG-SPECIES/KG
C     XUA     REAL    WORK ARRAY
C     ZFG     REAL    INPUT
C     ZMLWC   REAL    INPUT - LIQ. CLOUD WATER CONTENT (1 -> STRATIFORM
C                                                       2 -> CONVECTIVE
C                             IN KG-H2O/KG-AIR
C-----------------------------------------------------------------------
C
      COMMON /TIMES/ DELT
C
      LOGICAL KCALC(ILG,ILEV)
C
      INTEGER IDEEP(ILG),JT(ILG),MAXG(ILG),JD(ILG)
C
      REAL CLSIZE(ILG,ILEV,ISIZE),RCRIT(ILG,ILEV,2),XROW(ILG,ILEV+1,NTR)
     1    ,TH(ILG,ILEV+1),H2O2ROW(ILG,ILEV),XU(ILG,ILEV,NTR)
     2    ,HPOXROW(ILG,ILEV),O3ROW(ILG,ILEV),NH3ROW(ILG,ILEV)
     3    ,HNO3ROW(ILG,ILEV),CO2ROW(ILG,ILEV),RCOEX(ILG,ILEV,2)
     4    ,AERONUM(ILG,ILEV,ISIZE),CLDCV(ILG,ILEV,2),ZMLWC(ILG,ILEV,2)
     5    ,AFRAC(ILG,ILEV,ISIZE,2),AFRACF(ILG,ILEV,2),AEROSIZE(2,ISIZE)
     6    ,THLEV(ILG,ILEV),RTBCLD(ILG,ILEV,NTR),GDREM(ILG,NTR,3)
      REAL ROAROW(ILG,ILEV),AGAMMA(ILG,ILEV),AMASPE(3)
     1    ,ARESID(ILG,ILEV),ASPECI(ILG,ILEV),AGTSO2(ILG,ILEV)
     2    ,AGTSO4(ILG,ILEV),AGTO3(ILG,ILEV),AGTCO2(ILG,ILEV)
     3    ,AGTNH3(ILG,ILEV),AGTHNO3(ILG,ILEV),AGTNA(ILG,ILEV)
     4    ,AGTHO2(ILG,ILEV),AOH2O2(ILG,ILEV),AEQCA(ILG,ILEV)
     5    ,AEQCB(ILG,ILEV),AEQCC(ILG,ILEV),AEQCAI(ILG,ILEV)
     6    ,AEQCBI(ILG,ILEV),AEQCHP(ILG,ILEV),AEQCHO(ILG,ILEV)
     7    ,AEQHNO(ILG,ILEV),AEQNH3(ILG,ILEV),AEQHCL(ILG,ILEV)
     8    ,AORHP1(ILG,ILEV),AORHP2(ILG,ILEV),AORHO(ILG,ILEV)
     9    ,ANTSO2(ILG,ILEV),ANTHO2(ILG,ILEV),ANTSO4(ILG,ILEV)
      REAL DSHJ(ILG,ILEV),EPS0(ILG),MU(ILG,ILEV),EU(ILG,ILEV)
     1    ,DU(ILG,ILEV),MD(ILG,ILEV),MC(ILG,ILEV),ED(ILG,ILEV)
     2    ,DP(ILG,ILEV),DZ(ILG,ILEV),MB(ILG),DSUBCLD(ILG)
     3    ,X(ILG,ILEV,NTR),XD(ILG,ILEV,NTR),XG(ILG,ILEV,NTR)
     4    ,DXDT(ILG,ILEV,NTR),XHAT(ILG,ILEV,NTR),DXDX(ILG,ILEV,NTR)
     5    ,FACX(ILG,ILEV,NTR),SUMDX(ILG),OU(ILG,ILEV,NTR),MUR(ILG,ILEV)
     6    ,MDR(ILG,ILEV),DUR(ILG,ILEV),EUR(ILG,ILEV),EDR(ILG,ILEV)
     7    ,ZFG(ILG,ILEV), PXNEW(ILG,ILEV,NTR)
      REAL RGRID(ILG,ILEV,ISIZE),RTSO4(ILG,ILEV,ISIZE),RTSO2(ILG,ILEV,2)
     1    ,RTHPO(ILG,ILEV),PRESSG(ILG),AMH(ILG,ILEV),SHJ(ILG,ILEV)
     2    ,XUA(ILG,ILEV,NTRACA),XGA(ILG,ILEV,NTRACA),Z(ILG,ILEV)
     3    ,ASPRVA(ILG,ILEV),ASRSO2(ILG,ILEV),ASRHPO(ILG,ILEV)
      REAL RU(ILG,ILEV,NTR),RUA(ILG,ILEV,NTRACA)
      DATA AMASPE / 96.0576E-03, 64.0588E-03, 34.0146E-03 /
C
      PARAMETER ( YTAU   = 129600.
     1           ,YCOM3L = 1.E+03
     2           ,YGASC  = 8.31441 
     3           ,Y3LN10 = 6.90776 )
C
C-----------------------------------------------------------------------
C
C     (1) in-cloud production of sulphate
C
C-----------------------------------------------------------------------
C
C---  dimensions and initialization
      CALL OEQUIP (ILG,ILEV,IL1,IL2,AEQCA,AEQCB,AEQCC,AEQCAI,AEQCBI
     1            ,AEQCHP,AEQCHO,AEQHNO,AEQNH3,AEQHCL,AORHP1,AORHP2
     2            ,AORHO,TH(1,2),MAE)
C
C---  initial tendencies
      DO 90 JK=1+MAE,ILEV
      DO 90 IL=IL1,IL2
         RTHPO(IL,JK) = 0.
 90   CONTINUE
C
C---  initial concentrations
      DO 100 JK=1+MAE,ILEV
      DO 100 IL=IL1,IL2
C
C---     conversion from m**3/m**3 -> mol/l
         ROCO0 = (PRESSG(IL)*SHJ(IL,JK)) / (YGASC * TH(IL,JK+1))
         ROCON = ROCO0 / YCOM3L
         AGTHNO3(IL,JK) = HNO3ROW(IL,JK)*ROCON         ! nitric acid
         AGTNH3 (IL,JK) = NH3ROW(IL,JK) *ROCON         ! ammonia
         AGTO3  (IL,JK) = O3ROW(IL,JK)  *ROCON         ! ozone
         AGTCO2 (IL,JK) = CO2ROW(IL,JK) *ROCON         ! carbon dioxide
c         print *, XROW(IL,JK+1,IHPO), IHPO,ROAROW(IL,JK)
c     +          , H2O2ROW(IL,JK),'11111'
         AGTHO2(IL,JK)  = XROW(IL,JK+1,IHPO) * ROAROW(IL,JK)
     1                  / (AMASPE(3)*YCOM3L)           ! hydrogen peroxi
C
C---     conversion from m**3/m**3 -> kg/kg
         ROCON = ROCO0 * AMASPE(3) / ROAROW(IL,JK)
         HPOXROW(IL,JK) = H2O2ROW(IL,JK)*ROCON         ! hydrogen peroxi
C
C---     sodium concentration (for later applications)
         AGTNA(IL,JK) = 0.
 100  CONTINUE
C
C---  distribution of total produced sulphate on bins. AFRAC(I,L,N,NCT)
C---  is the volume of activated aerosol in bin N per total volume
C---  of activated aerosol for cloud type NCT
C
C     Note that only when the number density of a size bin is greater 
C       than 5 m-3, can it be serve as a activation bin to receive
C       cloud-produed sulphate.
C
      CALL PUTZERO(AFRACF,ILG*ILEV*2)
      CALL PUTZERO(AFRAC,ILG*ILEV*ISIZE*2)
      DO 150 NCT=1,2
      DO 150 N=1,ISIZE
         DO 160 L=1+MAE,ILEV
         DO 160 I=IL1,IL2
             IF (       (INT(RCRIT(I,L,NCT)) .GE. 1)
     1            .AND. (INT(RCRIT(I,L,NCT)) .LE. ISIZE)        )  THEN
                AERNO=AERONUM(I,L,N)*ROAROW(I,L)
               IF (N.EQ.INT(RCRIT(I,L,NCT)) .AND. AERNO .GT.1.E6) THEN
                   AFRAC(I,L,N,NCT) = AERONUM(I,L,N) * RCOEX(I,L,NCT)**3
     1                              * (1.-AMOD(RCRIT(I,L,NCT),1.))
                   AFRACF(I,L,NCT) = AFRAC(I,L,N,NCT)
!                  if(AFRAC(I,L,N,NCT).ne.0)
!     +               print *, AFRAC(I,L,N,NCT),'cldchem 1'
                ELSE IF (N .GT. INT(RCRIT(I,L,NCT)) 
     1                                     .AND. AERNO .GT. 1.E6)  THEN
                   AFRAC(I,L,N,NCT) = AERONUM(I,L,N) * CLSIZE(I,L,N)**3
                   AFRACF(I,L,NCT) = AFRACF(I,L,NCT) + AFRAC(I,L,N,NCT)
!                   if(AFRAC(I,L,N,NCT).ne.0)
!     +               print *, AFRAC(I,L,N,NCT),'cldchem 2'
                ELSE
                   AFRAC(I,L,N,NCT) = 0.
                END IF
                AFRACF(I,L,NCT) = MAX (AFRACF(I,L,NCT),1.E-33)
             END IF
 160      CONTINUE
 150  CONTINUE
      DO 170 NCT=1,2
      DO 170 N=1,ISIZE
      DO 170 L=1+MAE,ILEV
      DO 170 I=IL1,IL2
         IF (       (INT(RCRIT(I,L,NCT)) .GE. 1)
     1        .AND. (INT(RCRIT(I,L,NCT)) .LE. ISIZE)    ) THEN
              AFRAC(I,L,N,NCT) = AFRAC(I,L,N,NCT) / AFRACF(I,L,NCT)
!               if(AFRAC(I,L,N,NCT).ne.0)
!     +               print *, AFRAC(I,L,N,NCT),'cldchem 3'
         END IF
 170  CONTINUE
C
C---  call to perform stratiform cloud oxidation of sulphur dioxide
      CALL OXISTR(    IL1,      IL2,     ILEV,     ILG,  ISIZE
     1            ,   NTR,     ISO2,     IHPO,      NN,   IAE1
     2            ,ROAROW,   AGAMMA,   ASPECI,  AGTSO2, AGTSO4
     3             ,AGTO3,   AGTCO2,   AGTNH3, AGTHNO3,  AGTNA
     4            ,AGTHO2,    AEQCA,    AEQCB,   AEQCC, AEQCBI
     5            ,AEQCHP,   AEQCHO,   AEQHNO,  AEQNH3, AEQHCL
     6            ,AORHP1,   AORHP2,    AORHO,  ANTSO2, ANTHO2
     7            ,ANTSO4,     XROW,   AOH2O2,  ARESID,
     +            ZMLWC(1,1,1)
     8      ,CLDCV(1,1,1),AFRAC(1,1,1,1), AMH
     +      ,   KCALC
     +             , RTSO4
     9            ,RTHPO,RCRIT(1,1,1),AMASPE,ASPRVA
     *            ,ASRSO2,   ASRHPO, MAE)
C
C   UPDATE SO4
C
      DO N=1,ISIZE
         NF=ISIZE*(NN-1)+N+(IAE1-1)
         DO L=1+MAE,ILEV
            DO I=IL1,IL2
               XROW(I,L+1,NF)=XROW(I,L+1,NF)+2.*DELT*RTSO4(I,L,N)
            END DO
         END DO
      END DO
C
C   UPDATE SO2
C 
      DO L=1+MAE,ILEV
         DO I=IL1,IL2
            XROW(I,L+1,ISO2)=XROW(I,L+1,ISO2)+2.*DELT*ASPRVA(I,L)
            RTSO2(I,L,2) = ASPRVA(I,L)
         END DO
      END DO
         
C
C---  call tp perform convective cloud oxidation of sulphur dioxide
      CALL PUTZERO(RGRID,ILG*ILEV*ISIZE)
      CALL PUTZERO(ASPRVA,ILG*ILEV)
c1   zhouch  070902
c      print*,'before oxicon in cldchem'
      CALL OXICON(   IL1,    IL2,    NTR,    ILEV,      ID
     1          ,    ILG,   ISO2,   IHPO,      NN,   ISIZE
     2          ,   IAE1,RCRIT(1,1,2),AGTO3,AGTCO2, AGTNH3
     3          ,AGTHNO3,  AGTNA,  AEQCB,  AEQCBI,  AEQNH3
     4          , AEQHNO, AEQHCL,  AEQCC,   AEQCA,  AEQCHO
     5          , AEQCHP, AORHP1, AORHP2,   AORHO,  ROAROW
     6          ,AFRAC(1,1,1,2),CLDCV(1,1,2)
     +          ,ZMLWC(1,1,2),GRAV,DSHJ
     7          ,  IDEEP,   EPS0,     JT,    MAXG,      JD
     8          ,     DZ,     DP,     DU,      EU,      ED
     9          ,     MU,     MD,     MC,      MB,     MSG
     *          ,LENGATH,DSUBCLD,      X,      XU,      XD
     1          ,     XG,   XHAT,   DXDT,    DXDX,    FACX
     2          ,  SUMDX,     OU,    XGA,     XUA,  NTRACA
     3          , AGTSO4, AGTSO2, AGTHO2,  AGAMMA,    XROW
     4          ,    AMH,  KCALC,  RGRID,  ASPRVA,   RTHPO
     5          , AMASPE,    MUR,    MDR,     DUR,     EUR
     6        ,EDR, ZFG,PXNEW(1,1,1),PXNEW(1,1,2),
     +       PXNEW(1,1,3)
     7          ,     RU,    RUA, TH(1,2),  
     +               THLEV,  RTBCLD, MAE)
c      print*,'after oxicon'
C
C   UPDATE SO4
C
      DO N=1,ISIZE
         NF=ISIZE*(NN-1)+N+(IAE1-1)
         DO L=1+MAE,ILEV
            DO I=IL1,IL2
               XROW(I,L+1,NF)=XROW(I,L+1,NF)+2.*DELT*(RGRID(I,L,N)+
     1                                               RTBCLD(I,L,NF))             
               RTSO4(I,L,N)=RTSO4(I,L,N)+RGRID(I,L,N)
            if(XROW(I,L+1,NF).gt.0.0) then
            else
!             print *, 
!     +        'SO4', XROW(I,L+1,NF),RGRID(I,L,N),RTBCLD(I,L,NF)
!     +             , I, L, NF
            endif
            END DO
         END DO
      END DO
C
C   UPDATE SO2
C 
      DO L=1+MAE,ILEV
         DO I=IL1,IL2
            XROW(I,L+1,ISO2)=XROW(I,L+1,ISO2)+2.*DELT*(ASPRVA(I,L)+
     1                                               RTBCLD(I,L,ISO2))             
            GDREM(I,ISO2,2)=GDREM(I,ISO2,2)+RTBCLD(I,L,ISO2)*  
     1                                        DSHJ(I,L)*PRESSG(I)/GRAV
            RTSO2(I,L,2) = RTSO2(I,L,2)+ASPRVA(I,L)
        if(XROW(I,L+1,ISO2).gt.0.) then
        else
!        print *,'SO2',XROW(I,L+1,ISO2),ASPRVA(I,L),RTBCLD(I,L,ISO2)
!     +         , I, L, ISO2
        endif
         END DO
      END DO
c     print*,'zhaisx prints point1 cldchem'
C
C-----------------------------------------------------------------------
C
C     (2) hydrogen peroxide production
C
C-----------------------------------------------------------------------
C
      DO 300 L=1+MAE,ILEV
      DO 300 I=IL1,IL2
         RTHPO(I,L) = RTHPO(I,L) - ( 1. / YTAU )
     1                  * ( XROW(I,L+1,IHPO) - HPOXROW(I,L) )
         XROW(I,L+1,IHPO)=XROW(I,L+1,IHPO)+RTHPO(I,L)*2.*DELT
        if(XROW(I,L+1,ISO2).gt.0.) then
        else
!        print *,'H2O2',XROW(I,L+1,IHPO),ASPRVA(I,L),RTBCLD(I,L,IHPO)
!     +         , I, L, IHPO
        endif
300   CONTINUE
C
      RETURN
      END
