!------------------------------------------------------------!
!zhjh:050320! S=hght(m) , so as seloc(m)                     !
!zhjh:050320! Delete something related to sigma axis .       !
!------------------------------------------------------------!

       SUBROUTINE chem_trvdiff2(frtr,tr_loc,kt,S,
     &                          dt,gni,gnk,gntrnb,trnch)

!----------------------------------------------------------------------------
!     driver to perform vertical diffusion for tracers	
!----------------------------------------------------------------------------
       IMPLICIT NONE 

! #    include <model_macros_f.h>
! #    include "phy_macros_f.h"
!      include "impnone.cdk"
       include "consphy.cdk"

 
      INTEGER   :: gni,gnk,gntrnb,trnch,status
      REAL      :: kt(gni,gnk),S(gni,gnk)
      REAL      :: frtr(gni,gnk,gntrnb)
      INTEGER   :: tr_loc(gntrnb)
      REAL      :: dt
      REAL      :: rsg,gam0

      REAL      :: seloc(gni,gnk)
      REAL      :: tu(gni,gnk)  
      REAL      :: wka(gni,gnk)
      REAL      :: wkb(gni,gnk),wkc(gni,gnk), wkd(gni,gnk),ktx(gni,gnk)
      INTEGER   :: i,j,k,itr
 
!----------------------------------------------------------------------------
!zhjh: .true. to gain S on half levels .

         call difuvd9(seloc,.true.,S,gni,gnk,gnk)


       DO K=1,gnk-1
       DO i=1,gni
!          if(k.gt.gnk-2.and.KT(i,k).lt.0.1)          KT(i,k)=0.1            
           if(k.eq.gnk-1.and.kt(i,gnk).gt.kt(i,k))    kT(i,k)=kt(i,gnk) 
!          if(kt(i,k).lt.0.1.and.k.gt.19) write(*,*) 'KT-small',i,k, KT(i,k)

           KTx(i,k) = KT(i,k)
       END DO
       END DO
       

      DO itr=1,gntrnb
        call zero(tu,gni*gnk)

        IF (tr_loc(itr).eq.0) then
!        print*,'zhaisx print2 S(1,1),S(1,2)',S(1,1),S(1,2)
        call difvchem(frtr(1,1,itr),tu,ktx,S,seloc,wka,wkb,wkc,wkd,
     &                dt,gni,gnk)
        ENDIF
      END DO
	
      
!----------------------------------------------------------------------------
 
      RETURN
	
      END

C----------------------------------------------------------------------------

      SUBROUTINE DIFVCHEM(U,TU, KU, S, SK, A, B, C, D, TAU, N, NK)
 
      implicit none 
 
      INTEGER N, NK
      REAL TAU
      REAL U(N, NK)
      REAL TU(N, NK), KU(N, NK), S(N,NK), SK(N,NK)
      REAL A(N, NK), B(N, NK), C(N, NK), D(N, NK)
!     REAL  D1(N, NK),D2(N,NK)
 
!---------------------------------------------------------------------
*Author
*          R. Benoit (Mar 89)
*
*Revisions
* 001      R. Benoit (Aug 93) -Local sigma: s and sk become 2D
* 002      B. Bilodeau (Dec 94) - "IF" tests on integer 
*          instead of character.
* 003      D. Plummer (June 98) - stripped down version of difuvdfj
*          used for vertical diffusion of chemical tracers
*Object
*          to solve a vertical diffusion equation by finite
*          differences
*
*Arguments
*
*          - Output -
* TU       tendancy due to vertical diffusion
*
*          - Input -
* U        variable to diffuse (U,V,T,Q,E)
* KU       diffusion coefficient
* S        sigma coordinates of full levels
* SK       sigma coordinates of diffusion coefficient levels
* TAU      length of timestep
* A        work space (N,NK)
* B        work space (N,NK)
* C        work space (N,NK)
* D        work space (N,NK)
* N        horizontal dimension
* NK       vertical dimension
*
*Notes
*          D/DT U = D(U) + R
*          D(U) = D/DS J(U)
*          J(U) = KU*(D/DS U + GU)
*          Limiting Conditions where S=ST: J=0(for 'U'), D=0(for 'UT'
*          and ST=1)
*          U=0(for 'E')
*          Limiting Conditions where S=SB: J=ALFA+BETA*U(S(NK))(for
*          'U'/'UT'), J=0(for 'E')
*          ST = S(1)-1/2 (S(2)-S(1)) (except for 'TU')
*          SB = SK(NK)
*
**
!---------------------------------------------------------------------


      INTEGER I, K, NKX
      REAL SC,  HM, HP, HD, SCK1, F
!     Added by WH. 050128
      REAL ST(N),SB(N)
      EXTERNAL DIFUVD1, DIFUVD2


!=========

 
       DO I=1,N
       st(i)=s(i,1)
       sb(i)=sk(i,nk)
       ENDDO
!
!     These definitions hereunder for st, sb are always true.
!     so use as statement functions in code directly
!     to handle local sigma.
!     ST=S(1)
!     SB=SK(NK)
!
      SC=1
      NKX=NK
      SCK1=1
      F = 1.0

!      call flush (6)
!      call abort
 
!----------
 
*
* (1) CONSTRUIRE L'OPERATEUR TRIDIAGONAL DE DIFFUSION N=(A,B,C)
*                ET LE TERME CONTRE-GRADIENT (DANS D)
*
*     K=1
*

      HM=0
      DO 10 I=1,N
         HP=S(i,2)-S(i,1)
         HD=0.5*(S(i,1)+S(i,2))-ST(i)
         A(I,1)=0
!         print*,'zhaisx print,S(i,2),S(i,1)',S(i,2),S(i,1)
         IF (HP.NE.0.0.AND.HD.NE.0.0)THEN
           B(I,1)=-SCK1*KU(I,1)/(HP*HD)
         ELSE 
!           print*,'zhaisx print HP,HD',HP,HD
           print*,' Error in obtaining layers thickness.'
           print*,' In cam/chem_trvdiff2 . '
           stop
         ENDIF 
         C(I,1)=-SCK1*B(I,1)
         D(I,1)= 0.0
 10   CONTINUE
*
*     K=2...NK-1
*
      DO 11 K=2,NK-1,1
         DO 11 I=1,N
            HM=S(i,K)-S(i,K-1)
            HP=S(i,K+1)-S(i,K)
            HD=0.5*(HM+HP)
           IF (HP.NE.0.0.AND.HD.NE.0.0.AND.HM.NE.0.0)THEN
            A(I,K)=KU(I,K-1)/(HM*HD)
            
            B(I,K)=-(KU(I,K-1)/HM +KU(I,K)/HP)/HD
            C(I,K)=KU(I,K)/(HP*HD)
           ELSE
             A(I,K)=0.0
             B(I,K)=0.0 
             C(I,K)=0.0
           ENDIF
            D(I,K)= 0.0
 11   CONTINUE
*
*     K=NK
*
      HP=0
      DO 12 I=1,N
        
         HM=S(i,NK)-S(i,NK-1)
         HD=SB(i)-0.5*(S(i,NK-1)+S(i,NK))
         if (HM.NE.0.0.AND.HD.NE.0.0)THEN
         A(I,NK)=KU(I,NK-1)/(HM*HD)
         B(I,NK)=-(KU(I,NK-1)/HM + 0)/HD
         else
         A(I,NK)=0.0
         B(I,NK)=0.0
         endif 
         C(I,NK)=0.0
         D(I,NK)=0.0
 12   CONTINUE


*
* (2) CALCULER LE COTE DROIT D=TAU*(SC*N(U)+R+D/DS(KU*GU))
*

       CALL DIFUVD1 (D, SC, A, B, C, U, D, N, N, NKX)


      DO 20 K=1,NKX
         DO 20 I=1,N
20       D(I,K)=TAU*D(I,K) 
*
	
* (3) CALCULER OPERATEUR DU COTE GAUCHE
*
       
	
      DO 30 K=1,NKX
         DO 30 I=1,N
            A(I,K)= -F*TAU*A(I,K)
           
            B(I,K)=1-F*TAU*B(I,K)

            C(I,K)= -F*TAU*C(I,K)
            
30    CONTINUE    
*
* (4) RESOUDRE SYSTEME TRIDIAGONAL [A,B,C] X = D. METTRE X DANS TU.
*

      CALL DIFUVD2 (TU, A, B, C, D, D, N, N, NKX)


*
* (5) in the original code:  OBTENIR TENDANCE
!     original code in loop-40  TU(I,K)=TU(I,K)/TAU
!
!
!     for tracers in sef+c: ADD tendencies ... jwk 15.06.2000

      DO 40 K=1,NKX
         DO 40 I=1,N
            u(i,k)=u(i,k)+tu(i,k)   ! <------ jwk 15.06.2000
 40   CONTINUE
 
!      call flush (6)
!      call abort

!-----------

      RETURN
      END

!===================================================================

      SUBROUTINE print_dif(TU, U, KU, GU, R, ALFA, BETA, S, SK,
     &                    TAU, TYPE, F, A, B, C, D, NU, NR, N, NK)

      INTEGER   ::  NU, NR, N, NK
      REAL      ::  TU(NU,NK),U(NU,NK),KU(NR,NK),GU(NR,NK),R(NR,NK)
      REAL      ::  ALFA(N), BETA(N), S(n,NK), SK(n,NK), TAU, F
      INTEGER   ::  TYPE
      REAL      ::  A(N, NK), B(N, NK), C(N, NK), D(N, NK)
      INTEGER   ::  I, K, NKX
      REAL      ::  SC, SCTU, ST, SB, HM, HP, HD, KUM, KUP, SCK1
 
	j=1

	write(*,*) 'IN phys/cam/chem_trvdiff2 '
	write(*,*) 'start print_dif'
	write(*,*) 'TAU, TYPE, F=',TAU, TYPE, F
	write(*,*) 'NU, NR, N, NK =',NU, NR, N, NK
	write(*,*) 'k,(tu(j,k),u(j,k),ku(j,k),gu(j,k),r(j,k),s(j,k)
     &              ,sk(j,k)'

      RETURN
      END

!------------------------------------------------------------------------
      SUBROUTINE zero(a,n)
      real a(n)
       a=0.0
      return
      end
