!        Generated by TAPENADE     (INRIA, Tropics team)
!  Tapenade 3.6 (r4343) - 10 Feb 2012 10:52
!
!  Differentiation of camaerosol in reverse (adjoint) mode:
!   gradient     of useful results: u10 zfg3d emission dp3d p3d
!                gdrem1 gdrem2 gdrem3 tracer ice2d sfdust xlat
!                xlong mc3d mb2d t3d qv3d v10 gsw dsubcld2d p8w3d
!                snow2d fland
!   with respect to varying inputs: u10 zfg3d emission dp3d p3d
!                gdrem1 gdrem2 gdrem3 tracer ice2d sfdust xlat
!                xlong mc3d mb2d t3d qv3d v10 gsw dsubcld2d p8w3d
!                snow2d fland
!   RW status of diff variables: u10:incr zfg3d:incr emission:incr
!                dp3d:incr p3d:incr gdrem1:in-out gdrem2:in-out
!                gdrem3:in-out tracer:in-out ice2d:incr sfdust:in-out
!                xlat:incr xlong:incr mc3d:incr mb2d:incr t3d:incr
!                qv3d:incr v10:incr gsw:incr dsubcld2d:incr p8w3d:incr
!                snow2d:incr fland:incr
! For cumulus
! For blp & add fktm
! wh for dust
!xuemin For cumulus
!CSLG
!zch 20100224
SUBROUTINE CAMAEROSOL_B(itimestep, dt, gsw, gswb, xlat, xlatb, xlong, &
&  xlongb, alb, t3d, t3db, qv3d, qv3db, qc3d, p3d, p3db, p8w3d, p8w3db, &
&  dz8w, pi3d, cldfra3d, u3d, v3d, w3d, rho3d, gmt, julday, xtime, declin&
&  , solcon, snow2d, snow2db, ice2d, ice2db, prate1, prate2, raincv, &
&  rainncv, tmn, u10, u10b, v10, v10b, smstot, fktm, degrad, &
&  number_tracer, num_emission, tracer, tracerb, sfdust, sfdustb, &
&  num_soil_texture, num_clay, num_desert, num_landuse, sand2, clay2, &
&  sand6, fland, flandb, emission, emissionb, gdrem1, gdrem1b, gdrem2, &
&  gdrem2b, gdrem3, gdrem3b, tu, umf3d, uer3d, udr3d, dmf3d, der3d, &
&  wrscav, zfprec, wpevpa, cld_fn3d, ww3d, mc3d, mc3db, dp3d, dp3db, mb2d&
&  , mb2db, esp02d, zfg3d, zfg3db, dsubcld2d, dsubcld2db, ideep2d, jt2d, &
&  maxg2d, jd2d, lengath1d, pso43d, psoa3d, ids, ide, jds, jde, kds, kde&
&  , ims, ime, jms, jme, kms, kme, its, ite, jts, jte, kts, kte)
  IMPLICIT NONE
!------------------------------------------------------------------
  INTEGER :: ids, ide, jds, jde, kds, kde, ims, ime, jms, jme, kms, kme&
&  , its, ite, jts, jte, kts, kte
  INTEGER :: number_tracer,NUM_TR
  INTEGER :: num_soil_texture
  INTEGER :: num_clay
  INTEGER :: num_desert
  INTEGER :: num_landuse
  INTEGER :: num_emission
  INTEGER :: julday, itimestep
  REAL :: degrad, xtime, declin, solcon
!
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: p3d, p8w3d, pi3d, t3d, &
&  qv3d, qc3d, fktm, dz8w, u3d, v3d, w3d, rho3d, cldfra3d
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: p3db, p8w3db, t3db, &
&  qv3db
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme, number_tracer) :: tracer
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme, number_tracer) :: tracerb
!xuemin
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: umf3d, uer3d, udr3d, &
&  dmf3d, der3d
!CSLG
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: cld_fn3d, ww3d, mc3d, &
&  dp3d, zfg3d
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: mc3db, dp3db, zfg3db
!CSLG
  REAL, DIMENSION(ims:ime, jms:jme) :: dsubcld2d, esp02d, mb2d
  REAL, DIMENSION(ims:ime, jms:jme) :: dsubcld2db, mb2db
  INTEGER, DIMENSION(ims:ime, jms:jme) :: ideep2d, jt2d, maxg2d, jd2d
  INTEGER, DIMENSION(jms:jme) :: lengath1d
! zch 20100224
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: pso43d
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: psoa3d
  REAL, DIMENSION(ims:ime, jms:jme, num_soil_texture) :: sand2
  REAL, DIMENSION(ims:ime, jms:jme, num_clay) :: clay2
  REAL, DIMENSION(ims:ime, jms:jme, num_desert) :: sand6
  REAL, DIMENSION(ims:ime, jms:jme, num_landuse) :: fland
  REAL, DIMENSION(ims:ime, jms:jme, num_landuse) :: flandb
  REAL, DIMENSION(ims:ime, jms:jme, num_emission) :: emission
  REAL, DIMENSION(ims:ime, jms:jme, num_emission) :: emissionb
  REAL, DIMENSION(ims:ime, jms:jme, number_tracer) :: sfdust, gdrem1, &
&  gdrem2, gdrem3
  REAL, DIMENSION(ims:ime, jms:jme, number_tracer) :: sfdustb, gdrem1b, &
&  gdrem2b, gdrem3b
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: tu
  REAL, DIMENSION(ite - its + 1, num_soil_texture) :: sand2_2d
  REAL, DIMENSION(ite-its+1, num_soil_texture) :: sand2_2db
  REAL, DIMENSION(ite - its + 1, num_clay) :: clay2_2d
  REAL, DIMENSION(ite-its+1, num_clay) :: clay2_2db
  REAL, DIMENSION(ite - its + 1, num_desert) :: sand6_2d
  REAL, DIMENSION(ite-its+1, num_desert) :: sand6_2db
  REAL, DIMENSION(ite - its + 1, num_landuse) :: fland_2d
  REAL, DIMENSION(ite-its+1, num_landuse) :: fland_2db
  REAL, DIMENSION(ite - its + 1, 3, 2) :: blcrow
  REAL, DIMENSION(ite-its+1, 3, 2) :: blcrowb
  REAL, DIMENSION(ite - its + 1, 3, 2) :: omcrow
  REAL, DIMENSION(ite-its+1, 3, 2) :: omcrowb
!zch 20100224
  REAL, DIMENSION(ite - its + 1, 3, 2) :: rrdrow
  REAL, DIMENSION(ite-its+1, 3, 2) :: rrdrowb
  REAL, DIMENSION(ite - its + 1) :: aso2row
  REAL, DIMENSION(ite-its+1) :: aso2rowb
  REAL, DIMENSION(ite - its + 1) :: pso2row
  REAL, DIMENSION(ite-its+1) :: pso2rowb
  REAL, DIMENSION(ite - its + 1) :: poso2row
  REAL, DIMENSION(ite-its+1) :: poso2rowb
  REAL, DIMENSION(ite - its + 1) :: aso4row
  REAL, DIMENSION(ite-its+1) :: aso4rowb
  REAL, DIMENSION(ite - its + 1) :: pso4row
  REAL, DIMENSION(ite-its+1) :: pso4rowb
  REAL, DIMENSION(ite - its + 1) :: poso4row
  REAL, DIMENSION(ite-its+1) :: poso4rowb
  REAL, DIMENSION(ite - its + 1) :: dmsorow
  REAL, DIMENSION(ite-its+1) :: dmsorowb
  REAL, DIMENSION(ite - its + 1) :: dmslrow
  REAL, DIMENSION(ite-its+1) :: dmslrowb
  REAL, DIMENSION(ite - its + 1) :: h2srow
  REAL, DIMENSION(ite-its+1) :: h2srowb
  REAL, DIMENSION(ite - its + 1, 2) :: volcrow
  REAL, DIMENSION(ite - its + 1) :: ano3row
  REAL, DIMENSION(ite-its+1) :: ano3rowb
  REAL, DIMENSION(ite - its + 1) :: pno3row
  REAL, DIMENSION(ite-its+1) :: pno3rowb
  REAL, DIMENSION(ite - its + 1) :: pono3row
  REAL, DIMENSION(ite-its+1) :: pono3rowb
  REAL, DIMENSION(ite - its + 1, number_tracer) :: rsfdust, gdrem1_2d, &
&  gdrem2_2d, gdrem3_2d
  REAL, DIMENSION(ite-its+1, number_tracer) :: rsfdustb, gdrem1_2db, &
&  gdrem2_2db, gdrem3_2db
!
  REAL, DIMENSION(ims:ime, jms:jme) :: xlat, xlong, u10, v10, tmn, &
&  smstot, snow2d, ice2d, alb
  REAL, DIMENSION(ims:ime, jms:jme) :: xlatb, xlongb, u10b, v10b, &
&  snow2db, ice2db
! xuemin
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: prate1, prate2
  REAL, DIMENSION(ims:ime, kms:kme, jms:jme) :: wrscav, zfprec, wpevpa
  REAL, DIMENSION(ims:ime, jms:jme) :: raincv, rainncv
!
  REAL, DIMENSION(ims:ime, jms:jme) :: gsw
  REAL, DIMENSION(ims:ime, jms:jme) :: gswb
!
  REAL :: dt, gmt
  REAL :: dtb
!
! LOCAL VARS
  REAL, DIMENSION(ite - its + 1) :: ts, cosz, snow, ice, surfwd, ftsoil&
&  , ffdss, lat_deg, long_deg, fhs, psfc, albs
  REAL, DIMENSION(ite-its+1) :: coszb, snowb, iceb, surfwdb, ftsoilb, &
&  ffdssb, lat_degb, long_degb, fhsb, psfcb
!xuemin
  REAL, DIMENSION(ite - its + 1, kts:kte - 1, 2) :: prate_2d
  REAL, DIMENSION(ite-its+1, kts:kte-1, 2) :: prate_2db
  REAL, DIMENSION(ite - its + 1, kts:kte - 1) :: wrscav_2d, zfprec_2d, &
&  wpevpa_2d
  REAL, DIMENSION(ite-its+1, kts:kte-1) :: wrscav_2db, zfprec_2db, &
&  wpevpa_2db
!SLG
  REAL, DIMENSION(ite - its + 1) :: dsubcld, esp0, mb
  REAL, DIMENSION(ite-its+1) :: dsubcldb, esp0b, mbb
  INTEGER, DIMENSION(ite - its + 1) :: ideep, jt, maxg, jd
  INTEGER :: lengath
  REAL, DIMENSION(ite - its + 1, 2) :: qr
  REAL, DIMENSION(ite-its+1, 2) :: qrb
!   REAL, DIMENSION( ite-its+1,kts:kte-1 ) ::                mu,eu 
!
  REAL, DIMENSION(ite - its + 1, kts:kte) :: o3
!
  REAL, DIMENSION(ite - its + 1, kts:kte + 1) :: p8w2d
  REAL, DIMENSION(ite-its+1, kts:kte+1) :: p8w2db
  REAL, DIMENSION(ite - its + 1, kts:kte) :: sh2d, qc2d, p2d, t2d, u2d, &
&  v2d, w2d, rho2d, fktm2d, sig, hght, fmodv, fdz, frclds, frcldc, fcld2d
  REAL, DIMENSION(ite-its+1, kts:kte) :: sh2db, qc2db, p2db, t2db, w2db&
&  , rho2db, fktm2db, sigb, hghtb, fmodvb, fdzb, frcldsb, frcldcb
  REAL, DIMENSION(ite - its + 1, kts:kte - 1) :: umf, uer, udr, dmf, der
  REAL, DIMENSION(ite-its+1, kts:kte-1) :: umfb, uerb, udrb, dmfb, derb
!CSLG
  REAL, DIMENSION(ite - its + 1, kts:kte - 1) :: cld_fn, ww, mc, dp, zfg
  REAL, DIMENSION(ite-its+1, kts:kte-1) :: wwb, mcb, dpb, zfgb
  REAL, DIMENSION(ite - its + 1, kts:kte, number_tracer) :: aero_tr
  REAL, DIMENSION(ite-its+1, kts:kte, number_tracer) :: aero_trb
  REAL, DIMENSION(ite - its + 1, kts:kte) :: tu_2d
!zch 20100224
  REAL, DIMENSION(ite - its + 1, kts:kte) :: pso4, psoa
  REAL, DIMENSION(ite-its+1, kts:kte) :: pso4b, psoab
!
  INTEGER :: i, j, k, nk, l, n, ii, testid
  REAL :: xt24, tloctm, hrang, xxlat
  REAL :: xt24b, tloctmb, hrangb, xxlatb
  REAL :: inner
  EXTERNAL INITIAL
  EXTERNAL AEROEXE1
  EXTERNAL AEROEXE1_B
  REAL :: arg1
  REAL :: arg1b
  INTEGER :: arg10
  INTEGER :: arg2
  INTEGER :: branch
  INTEGER :: ad_to
  INTEGER :: ad_to0
  INTEGER :: ad_to1
  INTEGER :: ad_to2
  INTEGER :: ad_to3
  INTEGER :: ad_to4
  INTRINSIC COS
  INTRINSIC SIN
  REAL :: tempb2
  REAL :: tempb1
  REAL :: tempb0
  INTRINSIC MAX
  REAL :: tempb
  INTRINSIC SQRT
!  print*,'----before call aeroexe1-------------kts', kte
!    print *,ids,ide, jds,jde, kds,kde,                    &
!                    ims,ime, jms,jme, kms,kme,                    &
!                    its,ite, jts,jte, kts,kte  
  lengath1d = 0
  ideep2d = 0
  jt2d = 0
  maxg2d = 0
  jd2d = 0
!
!print*,'zhaisx camaerosol_b'
j_loop:DO j=jts,jte
    DO k=kts,kte
      DO i=its,ite
        ii = i - its + 1
        qc2d(ii, k) = 0.
        frclds(ii, k) = 0.
        frcldc(ii, k) = 0.
      END DO
    END DO
! reverse vars 
!
    DO k=kts,kte+1
      DO i=its,ite
        ii = i - its + 1
        nk = kte + 2 - k
! P8w2D is in Pa
        p8w2d(ii, k) = p8w3d(i, nk, j)
      END DO
    END DO
!
    DO k=kts,kte
      DO i=its,ite
        ii = i - its + 1
        nk = kte + 1 - k
        t2d(ii, k) = t3d(i, nk, j)
        fdz(ii, k) = dz8w(i, nk, j)
! SH2D specific humidity
        sh2d(ii, k) = qv3d(i, nk, j)/(1.+qv3d(i, nk, j))
        IF (0. .LT. sh2d(ii, k)) THEN
          CALL PUSHCONTROL1B(0)
          sh2d(ii, k) = sh2d(ii, k)
        ELSE
          sh2d(ii, k) = 0.
          CALL PUSHCONTROL1B(1)
        END IF
        qc2d(ii, k) = qc3d(i, nk, j)
        IF (0. .LT. qc2d(ii, k)) THEN
          CALL PUSHCONTROL1B(0)
          qc2d(ii, k) = qc2d(ii, k)
        ELSE
          qc2d(ii, k) = 0.
          CALL PUSHCONTROL1B(1)
        END IF
        CALL PUSHreal8(p2d(ii, k))
! P2D is in Pa
        p2d(ii, k) = p3d(i, nk, j)
        fcld2d(ii, k) = cldfra3d(i, nk, j)
        IF (qc2d(ii, k) .GT. 1.0e-6) THEN
          fcld2d(ii, k) = 1.0
        ELSE
          fcld2d(ii, k) = 0.0
        END IF
        frclds(ii, k) = fcld2d(ii, k)
        frcldc(ii, k) = fcld2d(ii, k)
        u2d(ii, k) = u3d(i, nk, j)
        v2d(ii, k) = v3d(i, nk, j)
        w2d(ii, k) = w3d(i, nk, j)
        rho2d(ii, k) = rho3d(i, nk, j)
        fktm2d(ii, k) = fktm(i, nk, j)
        fmodv(ii, k) = SQRT(u2d(ii, k)*u2d(ii, k) + v2d(ii, k)*v2d(ii, k&
&          ))
!        print*,'fmodv(',ii,',', k,')',fmodv(ii, k)
        pso4(ii, k) = pso43d(i, nk, j)
        psoa(ii, k) = psoa3d(i, nk, j)
      END DO
    END DO
!xuemin
    DO k=kts,kte-1
      DO i=its,ite
        ii = i - its + 1
!         NK=kme-1-K+kms
        nk = kte + 1 - k
        wrscav_2d(ii, k) = wrscav(i, nk, j)
        zfprec_2d(ii, k) = zfprec(i, nk, j)
        wpevpa_2d(ii, k) = wpevpa(i, nk, j)
        prate_2d(ii, k, 1) = prate1(i, nk, j)
        prate_2d(ii, k, 2) = prate2(i, nk, j)
      END DO
    END DO
    DO i=its,ite
      ii = i - its + 1
      snow(ii) = snow2d(i, j)
      ice(ii) = ice2d(i, j)
! Psfc is in Pa
      psfc(ii) = p8w2d(ii, kte+1)
      surfwd(ii) = SQRT(u10(i, j)*u10(i, j) + v10(i, j)*v10(i, j))
!      print*,'surfwd(',ii,')',surfwd(ii)
      ftsoil(ii) = tmn(i, j)
      ffdss(ii) = gsw(i, j)
! convert unit from mm to kg/m2s wh 060814
      qr(ii, 1) = rainncv(i, j)/dt
      qr(ii, 2) = raincv(i, j)/dt
!CSLG
      dsubcld(ii) = dsubcld2d(i, j)
      esp0(ii) = esp02d(i, j)
      ideep(ii) = ideep2d(i, j)
      jt(ii) = jt2d(i, j)
      maxg(ii) = maxg2d(i, j)
      jd(ii) = jd2d(i, j)
      mb(ii) = mb2d(i, j)
    END DO
!zch
    lengath = lengath1d(j)
    DO k=2,kte-1
      DO i=its,ite
        ii = i - its + 1
        nk = kte + 1 - k
        umf(ii, k) = umf3d(i, nk, j)
        uer(ii, k) = uer3d(i, nk, j)
        udr(ii, k) = udr3d(i, nk, j)
        dmf(ii, k) = dmf3d(i, nk, j)
        der(ii, k) = der3d(i, nk, j)
!CSLG
        ww(ii, k) = ww3d(i, nk, j)
        mc(ii, k) = mc3d(i, nk, j)
        dp(ii, k) = dp3d(i, nk, j)
        zfg(ii, k) = zfg3d(i, nk, j)
      END DO
    END DO
!zch
    DO i=its,ite
      DO k=2,kte-1
        ii = i - its + 1
        IF (mb(ii) .LT. 1.0e-33) THEN
          mb(ii) = umf(ii, k) + dmf(ii, k)
          CALL PUSHCONTROL1B(1)
        ELSE
          CALL PUSHCONTROL1B(0)
        END IF
      END DO
    END DO
! wh for dust data     
    DO l=1,num_soil_texture
      DO i=its,ite
        ii = i - its + 1
        sand2_2d(ii, l) = sand2(i, j, l)
      END DO
    END DO
    CALL PUSHINTEGER4(l - 1)
    DO l=1,num_clay
      DO i=its,ite
        ii = i - its + 1
        clay2_2d(ii, l) = clay2(i, j, l)
      END DO
    END DO
    CALL PUSHINTEGER4(l - 1)
    DO l=1,num_desert
      DO i=its,ite
        ii = i - its + 1
        sand6_2d(ii, l) = sand6(i, j, l)
      END DO
    END DO
    CALL PUSHINTEGER4(l - 1)
    DO l=1,num_landuse
      DO i=its,ite
        ii = i - its + 1
        fland_2d(ii, l) = fland(i, j, l)
      END DO
    END DO
    CALL PUSHINTEGER4(l - 1)
!  xuemin for emission
    DO i=its,ite
      ii = i - its + 1
      aso2row(ii) = emission(i, j, 25)
      pso2row(ii) = emission(i, j, 57)
      poso2row(ii) = emission(i, j, 89)
      aso4row(ii) = emission(i, j, 31)
      pso4row(ii) = emission(i, j, 63)
      poso4row(ii) = emission(i, j, 95)
      ano3row(ii) = emission(i, j, 29)
      pno3row(ii) = emission(i, j, 61)
      pono3row(ii) = emission(i, j, 93)
      blcrow(ii, 1, 1) = emission(i, j, 27)
      blcrow(ii, 1, 2) = 5.
      blcrow(ii, 2, 1) = emission(i, j, 59)
      blcrow(ii, 2, 2) = 50.
      blcrow(ii, 3, 1) = emission(i, j, 91)
      blcrow(ii, 3, 2) = 120.
      omcrow(ii, 1, 1) = emission(i, j, 30)
      omcrow(ii, 1, 2) = 5.
      omcrow(ii, 2, 1) = emission(i, j, 62)
      omcrow(ii, 2, 2) = 50.
      omcrow(ii, 3, 1) = emission(i, j, 94)
      omcrow(ii, 3, 2) = 120.
! zch 20100224
      rrdrow(ii, 1, 1) = emission(i, j, 28)
      rrdrow(ii, 1, 2) = 5.
      rrdrow(ii, 2, 1) = emission(i, j, 60)
      rrdrow(ii, 2, 2) = 50.
      rrdrow(ii, 3, 1) = emission(i, j, 92)
      rrdrow(ii, 3, 2) = 120.
      dmsorow(ii) = 0.
      dmslrow(ii) = 0.
      h2srow(ii) = 0.
    END DO
    DO k=kts,kte
      DO i=its,ite
        ii = i - its + 1
        sig(ii, k) = p2d(ii, k)/psfc(ii)
      END DO
    END DO
    DO i=its,ite
      ii = i - its + 1
      hght(ii, kte) = fdz(ii, kte)
    END DO
    DO k=2,kte
      DO i=its,ite
        ii = i - its + 1
        nk = kte + 1 - k
        hght(ii, nk) = hght(ii, nk+1) + dz8w(i, k, j)
      END DO
    END DO
    DO k=kts,kte
      DO i=its,ite
        ii = i - its + 1
        nk = kte + 1 - k
        DO l=1,number_tracer
          aero_tr(ii, k, l) = tracer(i, nk, j, l)
        END DO
        CALL PUSHINTEGER4(l - 1)
      END DO
    END DO
!
! ... Vertical profiles for ozone
!
! ... Solar zenith angle
!
    DO i=its,ite
      ii = i - its + 1
      arg1 = xtime + dt*0.5
      CALL PUSHreal8(arg1)
      xt24 = AMOD(arg1, 1440.)
      tloctm = gmt + xt24/60. + xlong(i, j)/15.
      CALL PUSHreal8(hrang)
      hrang = 15.*(tloctm-12.)*degrad
      xxlat = xlat(i, j)*degrad
      cosz(ii) = SIN(xxlat)*SIN(declin) + COS(xxlat)*COS(declin)*COS(&
&        hrang)
      lat_deg(ii) = xlat(i, j)
      long_deg(ii) = xlong(i, j)
!     fhs(ii)=SMSTOT(I,J)
      fhs(ii) = smstot(i, j)
    END DO
    arg10 = ite - its + 1
    arg2 = kte - kts + 1
    CALL PUSHreal8ARRAY(psfc, ite - its + 1)
    CALL PUSHINTEGER4(j)
    CALL PUSHreal8(dt)
    CALL PUSHreal8ARRAY(rrdrow, (ite-its+1)*3*2)
    CALL PUSHreal8ARRAY(psoa, (ite-its+1)*(kte-kts+1))
    CALL PUSHreal8ARRAY(pso4, (ite-its+1)*(kte-kts+1))
    CALL PUSHINTEGER4(lengath)
    CALL PUSHINTEGER4ARRAY(jd, ite - its + 1)
    CALL PUSHINTEGER4ARRAY(maxg, ite - its + 1)
    CALL PUSHINTEGER4ARRAY(jt, ite - its + 1)
    CALL PUSHINTEGER4ARRAY(ideep, ite - its + 1)
    CALL PUSHreal8ARRAY(dsubcld, ite - its + 1)
    CALL PUSHreal8ARRAY(zfg, (ite-its+1)*(kte-kts))
    CALL PUSHreal8ARRAY(esp0, ite - its + 1)
    CALL PUSHreal8ARRAY(mb, ite - its + 1)
    CALL PUSHreal8ARRAY(dp, (ite-its+1)*(kte-kts))
    CALL PUSHreal8ARRAY(mc, (ite-its+1)*(kte-kts))
    CALL PUSHreal8ARRAY(ww, (ite-its+1)*(kte-kts))
    CALL PUSHreal8ARRAY(wpevpa_2d, (ite-its+1)*(kte-kts))
    CALL PUSHreal8ARRAY(zfprec_2d, (ite-its+1)*(kte-kts))
    CALL PUSHreal8ARRAY(wrscav_2d, (ite-its+1)*(kte-kts))
    CALL PUSHreal8ARRAY(prate_2d, (ite-its+1)*(kte-kts)*2)
    CALL PUSHreal8ARRAY(der, (ite-its+1)*(kte-kts))
    CALL PUSHreal8ARRAY(dmf, (ite-its+1)*(kte-kts))
    CALL PUSHreal8ARRAY(udr, (ite-its+1)*(kte-kts))
    CALL PUSHreal8ARRAY(uer, (ite-its+1)*(kte-kts))
    CALL PUSHreal8ARRAY(umf, (ite-its+1)*(kte-kts))
    CALL PUSHreal8ARRAY(pono3row, ite - its + 1)
    CALL PUSHreal8ARRAY(pno3row, ite - its + 1)
    CALL PUSHreal8ARRAY(ano3row, ite - its + 1)
    CALL PUSHreal8ARRAY(gdrem3_2d, (ite-its+1)*number_tracer)
    CALL PUSHreal8ARRAY(gdrem2_2d, (ite-its+1)*number_tracer)
    CALL PUSHreal8ARRAY(gdrem1_2d, (ite-its+1)*number_tracer)
    CALL PUSHreal8ARRAY(h2srow, ite - its + 1)
    CALL PUSHreal8ARRAY(dmslrow, ite - its + 1)
    CALL PUSHreal8ARRAY(dmsorow, ite - its + 1)
    CALL PUSHreal8ARRAY(poso4row, ite - its + 1)
    CALL PUSHreal8ARRAY(pso4row, ite - its + 1)
    CALL PUSHreal8ARRAY(aso4row, ite - its + 1)
    CALL PUSHreal8ARRAY(poso2row, ite - its + 1)
    CALL PUSHreal8ARRAY(pso2row, ite - its + 1)
    CALL PUSHreal8ARRAY(aso2row, ite - its + 1)
    CALL PUSHreal8ARRAY(rsfdust, (ite-its+1)*number_tracer)
    CALL PUSHreal8ARRAY(aero_tr, (ite-its+1)*(kte-kts+1)*number_tracer)
    CALL PUSHreal8ARRAY(fhs, ite - its + 1)
    CALL PUSHINTEGER4(julday)
    CALL PUSHreal8ARRAY(omcrow, (ite-its+1)*3*2)
    CALL PUSHreal8ARRAY(blcrow, (ite-its+1)*3*2)
    CALL PUSHreal8ARRAY(fland_2d, (ite-its+1)*num_landuse)
    CALL PUSHreal8ARRAY(sand6_2d, (ite-its+1)*num_desert)
    CALL PUSHreal8ARRAY(clay2_2d, (ite-its+1)*num_clay)
    CALL PUSHreal8ARRAY(sand2_2d, (ite-its+1)*num_soil_texture)
    CALL PUSHINTEGER4(num_emission)
    CALL PUSHINTEGER4(num_landuse)
    CALL PUSHINTEGER4(num_desert)
    CALL PUSHINTEGER4(num_clay)
    CALL PUSHINTEGER4(num_soil_texture)
    CALL PUSHINTEGER4(number_tracer)
    CALL PUSHreal8ARRAY(qr, (ite-its+1)*2)
    CALL PUSHreal8ARRAY(frcldc, (ite-its+1)*(kte-kts+1))
    CALL PUSHreal8ARRAY(frclds, (ite-its+1)*(kte-kts+1))
    CALL PUSHreal8ARRAY(cosz, ite - its + 1)
    CALL PUSHreal8ARRAY(long_deg, ite - its + 1)
    CALL PUSHreal8ARRAY(lat_deg, ite - its + 1)
    CALL PUSHreal8ARRAY(fdz, (ite-its+1)*(kte-kts+1))
    CALL PUSHreal8ARRAY(ffdss, ite - its + 1)
    CALL PUSHreal8ARRAY(snow, ite - its + 1)
    CALL PUSHreal8ARRAY(ice, ite - its + 1)
    CALL PUSHreal8ARRAY(ftsoil, ite - its + 1)
    CALL PUSHreal8ARRAY(fktm2d, (ite-its+1)*(kte-kts+1))
    CALL PUSHreal8ARRAY(qc2d, (ite-its+1)*(kte-kts+1))
    CALL PUSHreal8ARRAY(fmodv, (ite-its+1)*(kte-kts+1))
    CALL PUSHreal8ARRAY(rho2d, (ite-its+1)*(kte-kts+1))
    CALL PUSHreal8ARRAY(w2d, (ite-its+1)*(kte-kts+1))
    CALL PUSHreal8ARRAY(surfwd, ite - its + 1)
    CALL PUSHreal8ARRAY(hght, (ite-its+1)*(kte-kts+1))
    CALL PUSHreal8ARRAY(sig, (ite-its+1)*(kte-kts+1))
    CALL PUSHreal8ARRAY(sh2d, (ite-its+1)*(kte-kts+1))
    CALL PUSHreal8ARRAY(t2d, (ite-its+1)*(kte-kts+1))
    CALL PUSHINTEGER4(arg2)
    CALL PUSHINTEGER4(arg10)
    CALL PUSHINTEGER4(itimestep)
!    print*,'zhaisx prints before call aeroexe1 in camaerosol_b.F'
    CALL AEROEXE1(dt, j, itimestep, arg10, arg2, t2d, sh2d, psfc, sig, &
&            hght, surfwd, w2d, rho2d, fmodv, qc2d, fktm2d, ftsoil, ice, &
&            snow, ffdss, fdz, lat_deg, long_deg, cosz, frclds, frcldc, &
&            qr, number_tracer, num_soil_texture, num_clay, num_desert, &
&            num_landuse, num_emission, sand2_2d, clay2_2d, sand6_2d, &
&            fland_2d, blcrow, omcrow, julday, fhs, aero_tr, rsfdust, &
&            aso2row, pso2row, poso2row, aso4row, pso4row, poso4row, &
&            dmsorow, dmslrow, h2srow, gdrem1_2d, gdrem2_2d, gdrem3_2d, &
&            ano3row, pno3row, pono3row, umf, uer, udr, dmf, der, &
&            prate_2d, wrscav_2d, zfprec_2d, wpevpa_2d, ww, mc, dp, mb, &
&            esp0, zfg, dsubcld, ideep, jt, maxg, jd, lengath, pso4, psoa&
&            , rrdrow)
!    print*,'zhaisx prints after call aeroexe1 in camaerosol_b.F'
    DO k=kts,kte
      DO i=its,ite
        ii = i - its + 1
        nk = kte + 1 - k
        DO l=1,number_tracer
          tracer(i, k, j, l) = aero_tr(ii, nk, l)
        END DO
        CALL PUSHINTEGER4(l - 1)
      END DO
    END DO
    CALL PUSHINTEGER4(j)
  END DO j_loop
  dtb = 0.0
  pso4b = 0.0
  dmslrowb = 0.0
  zfprec_2db = 0.0
  aso2rowb = 0.0
  lat_degb = 0.0
  ffdssb = 0.0
  zfgb = 0.0
  wwb = 0.0
  fktm2db = 0.0
  w2db = 0.0
  pso4rowb = 0.0
  dsubcldb = 0.0
  surfwdb = 0.0
  dpb = 0.0
  frcldsb = 0.0
  wpevpa_2db = 0.0
  qrb = 0.0
  umfb = 0.0
  sand6_2db = 0.0
  t2db = 0.0
  esp0b = 0.0
  rrdrowb = 0.0
  pso2rowb = 0.0
  poso4rowb = 0.0
  snowb = 0.0
  ano3rowb = 0.0
  h2srowb = 0.0
  ftsoilb = 0.0
  fdzb = 0.0
  psoab = 0.0
  derb = 0.0
  poso2rowb = 0.0
  clay2_2db = 0.0
  fmodvb = 0.0
  udrb = 0.0
  prate_2db = 0.0
  gdrem3_2db = 0.0
  rsfdustb = 0.0
  sand2_2db = 0.0
  p8w2db = 0.0
  sh2db = 0.0
  wrscav_2db = 0.0
  fhsb = 0.0
  gdrem2_2db = 0.0
  pno3rowb = 0.0
  coszb = 0.0
  psfcb = 0.0
  qc2db = 0.0
  sigb = 0.0
  gdrem1_2db = 0.0
  dmsorowb = 0.0
  iceb = 0.0
  fland_2db = 0.0
  mbb = 0.0
  omcrowb = 0.0
  mcb = 0.0
  rho2db = 0.0
  dmfb = 0.0
  uerb = 0.0
  p2db = 0.0
  pono3rowb = 0.0
  aso4rowb = 0.0
  hghtb = 0.0
  aero_trb = 0.0
  blcrowb = 0.0
  long_degb = 0.0
  frcldcb = 0.0

  DO j=jte,jts,-1
    CALL POPINTEGER4(j)
    DO l=73,1,-1
      DO i=ite,its,-1
        ii = i - its + 1
        gdrem3_2db(ii, l) = gdrem3_2db(ii, l) + gdrem3b(i, j, l)
        gdrem3b(i, j, l) = 0.0
        gdrem2_2db(ii, l) = gdrem2_2db(ii, l) + gdrem2b(i, j, l)
        gdrem2b(i, j, l) = 0.0
        gdrem1_2db(ii, l) = gdrem1_2db(ii, l) + gdrem1b(i, j, l)
        gdrem1b(i, j, l) = 0.0
        rsfdustb(ii, l) = rsfdustb(ii, l) + sfdustb(i, j, l)
        sfdustb(i, j, l) = 0.0
      END DO
    END DO
!    print*,'sum(blcrowb),j',sum(blcrowb),j
    DO k=kte,kts,-1
      DO i=ite,its,-1
        nk = kte + 1 - k
        ii = i - its + 1
        CALL POPINTEGER4(ad_to4)
        DO l=ad_to4,1,-1
          aero_trb(ii, nk, l) = aero_trb(ii, nk, l) + tracerb(i, k, j, l&
&            )
          tracerb(i, k, j, l) = 0.0
        END DO
      END DO
    END DO
!    print*,'before pop in camaerosol_b sum(blcrowb)=',sum(blcrowb)
    CALL POPINTEGER4(itimestep)
    CALL POPINTEGER4(arg10)
    CALL POPINTEGER4(arg2)
    CALL POPreal8ARRAY(t2d, (ite-its+1)*(kte-kts+1))
    CALL POPreal8ARRAY(sh2d, (ite-its+1)*(kte-kts+1))
    CALL POPreal8ARRAY(sig, (ite-its+1)*(kte-kts+1))
    CALL POPreal8ARRAY(hght, (ite-its+1)*(kte-kts+1))
    CALL POPreal8ARRAY(surfwd, ite - its + 1)
    CALL POPreal8ARRAY(w2d, (ite-its+1)*(kte-kts+1))
    CALL POPreal8ARRAY(rho2d, (ite-its+1)*(kte-kts+1))
    CALL POPreal8ARRAY(fmodv, (ite-its+1)*(kte-kts+1))
    CALL POPreal8ARRAY(qc2d, (ite-its+1)*(kte-kts+1))
    CALL POPreal8ARRAY(fktm2d, (ite-its+1)*(kte-kts+1))
    CALL POPreal8ARRAY(ftsoil, ite - its + 1)
    CALL POPreal8ARRAY(ice, ite - its + 1)
    CALL POPreal8ARRAY(snow, ite - its + 1)
    CALL POPreal8ARRAY(ffdss, ite - its + 1)
    CALL POPreal8ARRAY(fdz, (ite-its+1)*(kte-kts+1))
    CALL POPreal8ARRAY(lat_deg, ite - its + 1)
    CALL POPreal8ARRAY(long_deg, ite - its + 1)
    CALL POPreal8ARRAY(cosz, ite - its + 1)
    CALL POPreal8ARRAY(frclds, (ite-its+1)*(kte-kts+1))
    CALL POPreal8ARRAY(frcldc, (ite-its+1)*(kte-kts+1))
    CALL POPreal8ARRAY(qr, (ite-its+1)*2)
    CALL POPINTEGER4(number_tracer)
    CALL POPINTEGER4(num_soil_texture)
    CALL POPINTEGER4(num_clay)
    CALL POPINTEGER4(num_desert)
    CALL POPINTEGER4(num_landuse)
    CALL POPINTEGER4(num_emission)
    CALL POPreal8ARRAY(sand2_2d, (ite-its+1)*num_soil_texture)
    CALL POPreal8ARRAY(clay2_2d, (ite-its+1)*num_clay)
!    print*,'in pop1 in camaerosol_b sum(blcrowb)=',sum(blcrowb)
    CALL POPreal8ARRAY(sand6_2d, (ite-its+1)*num_desert)
    CALL POPreal8ARRAY(fland_2d, (ite-its+1)*num_landuse)
    CALL POPreal8ARRAY(blcrow, (ite-its+1)*3*2)

!    print*,'after popomcrow in camaerosol_b sum(blcrowb)=',sum(blcrowb)
    CALL POPreal8ARRAY(omcrow, (ite-its+1)*3*2)
!    print*,'after popomcrow in camaerosol_b sum(blcrowb)=',sum(blcrowb)

    CALL POPINTEGER4(julday)
!    print*,'after popjulday in camaerosol_b sum(blcrowb)=',sum(blcrowb)
    CALL POPreal8ARRAY(fhs, ite - its + 1)
    CALL POPreal8ARRAY(aero_tr, (ite-its+1)*(kte-kts+1)*number_tracer)
    CALL POPreal8ARRAY(rsfdust, (ite-its+1)*number_tracer)
!    print*,'in pop1_1 in camaerosol_b sum(blcrowb)=',sum(blcrowb)
    CALL POPreal8ARRAY(aso2row, ite - its + 1)
    CALL POPreal8ARRAY(pso2row, ite - its + 1)
    CALL POPreal8ARRAY(poso2row, ite - its + 1)
    CALL POPreal8ARRAY(aso4row, ite - its + 1)
    CALL POPreal8ARRAY(pso4row, ite - its + 1)
    CALL POPreal8ARRAY(poso4row, ite - its + 1)
    CALL POPreal8ARRAY(dmsorow, ite - its + 1)
!    print*,'in pop2 in camaerosol_b sum(blcrowb)=',sum(blcrowb)
    CALL POPreal8ARRAY(dmslrow, ite - its + 1)
    CALL POPreal8ARRAY(h2srow, ite - its + 1)
    CALL POPreal8ARRAY(gdrem1_2d, (ite-its+1)*number_tracer)
    CALL POPreal8ARRAY(gdrem2_2d, (ite-its+1)*number_tracer)
    CALL POPreal8ARRAY(gdrem3_2d, (ite-its+1)*number_tracer)
    CALL POPreal8ARRAY(ano3row, ite - its + 1)
    CALL POPreal8ARRAY(pno3row, ite - its + 1)
    CALL POPreal8ARRAY(pono3row, ite - its + 1)
    CALL POPreal8ARRAY(umf, (ite-its+1)*(kte-kts))
    CALL POPreal8ARRAY(uer, (ite-its+1)*(kte-kts))
    CALL POPreal8ARRAY(udr, (ite-its+1)*(kte-kts))
    CALL POPreal8ARRAY(dmf, (ite-its+1)*(kte-kts))
    CALL POPreal8ARRAY(der, (ite-its+1)*(kte-kts))
    CALL POPreal8ARRAY(prate_2d, (ite-its+1)*(kte-kts)*2)
    CALL POPreal8ARRAY(wrscav_2d, (ite-its+1)*(kte-kts))
    CALL POPreal8ARRAY(zfprec_2d, (ite-its+1)*(kte-kts))
    CALL POPreal8ARRAY(wpevpa_2d, (ite-its+1)*(kte-kts))
    CALL POPreal8ARRAY(ww, (ite-its+1)*(kte-kts))
    CALL POPreal8ARRAY(mc, (ite-its+1)*(kte-kts))
    CALL POPreal8ARRAY(dp, (ite-its+1)*(kte-kts))
    CALL POPreal8ARRAY(mb, ite - its + 1)
    CALL POPreal8ARRAY(esp0, ite - its + 1)
    CALL POPreal8ARRAY(zfg, (ite-its+1)*(kte-kts))
    CALL POPreal8ARRAY(dsubcld, ite - its + 1)
    CALL POPINTEGER4ARRAY(ideep, ite - its + 1)
    CALL POPINTEGER4ARRAY(jt, ite - its + 1)
    CALL POPINTEGER4ARRAY(maxg, ite - its + 1)
    CALL POPINTEGER4ARRAY(jd, ite - its + 1)
    CALL POPINTEGER4(lengath)
    CALL POPreal8ARRAY(pso4, (ite-its+1)*(kte-kts+1))
    CALL POPreal8ARRAY(psoa, (ite-its+1)*(kte-kts+1))
    CALL POPreal8ARRAY(rrdrow, (ite-its+1)*3*2)
    CALL LOOKreal8(dt)
    CALL LOOKINTEGER4(j)
    CALL LOOKreal8ARRAY(psfc, ite - its + 1)

!    print*,'before call aeroexe1_b sum(blcrowb)=',sum(blcrowb)
    CALL AEROEXE1_B(dt, j, itimestep, arg10, arg2, t2d, t2db, sh2d&
&              , sh2db, psfc, psfcb, sig, sigb, hght, surfwd, &
&              surfwdb, w2d,  rho2d, fmodv,  qc2d, &
&               fktm2d, ftsoil, ice, iceb, snow, &
&              snowb, ffdss, ffdssb, fdz, lat_deg,  lat_degb,&
&              long_deg, long_degb, cosz, frclds, frcldc&
&              , qr, number_tracer, num_soil_texture, &
&              num_clay, num_desert, num_landuse, num_emission, sand2_2d&
&              ,  clay2_2d,  sand6_2d,  &
&              fland_2d, fland_2db, blcrow, blcrowb, omcrow, omcrowb, &
&              julday, fhs,  aero_tr, aero_trb, rsfdust, rsfdustb, &
&              aso2row, aso2rowb, pso2row, pso2rowb, poso2row&
&              , aso4row, aso4rowb, pso4row, pso4rowb, poso4row, &
&              poso4rowb, dmsorow, dmsorowb, dmslrow, dmslrowb, h2srow, &
&              h2srowb, gdrem1_2d, gdrem1_2db, gdrem2_2d, gdrem2_2db, &
&              gdrem3_2d, gdrem3_2db, ano3row, ano3rowb, pno3row, &
&              pno3rowb, pono3row, pono3rowb, umf, uer, udr, &
&               dmf,  der,  prate_2d, wrscav_2d&
&              , zfprec_2d, wpevpa_2d&
&              , ww, mc, mcb, dp, dpb, mb, mbb, esp0, zfg, &
&              zfgb, dsubcld, dsubcldb, ideep, jt, maxg, jd, lengath, &
&              pso4,  psoa,  rrdrow, rrdrowb)
     print*,'after call aeroexe1_b sum(blcrowb)=',sum(blcrowb)
     print*,'after call aeroexe1_b blcrowb(24,1,1)=',blcrowb(24,1,1)
    CALL POPreal8(dt)
    CALL POPINTEGER4(j)
    CALL POPreal8ARRAY(psfc, ite - its + 1)
    DO i=ite,its,-1
      ii = i - its + 1
      fhsb(ii) = 0.0
      xxlat = xlat(i, j)*degrad
      tempb2 = COS(declin)*coszb(ii)
      xxlatb = SIN(declin)*COS(xxlat)*coszb(ii) - COS(hrang)*SIN(xxlat)*&
&        tempb2
      xlatb(i, j) = xlatb(i, j) + degrad*xxlatb + lat_degb(ii)
      lat_degb(ii) = 0.0
      hrangb = -(COS(xxlat)*SIN(hrang)*tempb2)
      coszb(ii) = 0.0
      CALL POPreal8(hrang)
      tloctmb = degrad*15.*hrangb
      xlongb(i, j) = xlongb(i, j) + tloctmb/15. + long_degb(ii)
      long_degb(ii) = 0.0
      xt24b = tloctmb/60.
      CALL POPreal8(arg1)
      arg1b = 0.0
!      CALL AMOD_B(arg1, arg1b, 1440., xt24b)
      arg1b=xt24b/1440.
      dtb = dtb + 0.5*arg1b
    END DO
    DO k=kte,kts,-1
      DO i=ite,its,-1
        nk = kte + 1 - k
        ii = i - its + 1
        CALL POPINTEGER4(ad_to3)
        DO l=ad_to3,1,-1
          tracerb(i, nk, j, l) = tracerb(i, nk, j, l) + aero_trb(ii, k, &
&            l)
          aero_trb(ii, k, l) = 0.0
        END DO
      END DO
    END DO
    DO k=kte,2,-1
      DO i=ite,its,-1
        nk = kte + 1 - k
        ii = i - its + 1
        hghtb(ii, nk+1) = hghtb(ii, nk+1) + hghtb(ii, nk)
        hghtb(ii, nk) = 0.0
      END DO
    END DO
    DO i=ite,its,-1
      ii = i - its + 1
      fdzb(ii, kte) = fdzb(ii, kte) + hghtb(ii, kte)
      hghtb(ii, kte) = 0.0
    END DO
    DO k=kte,kts,-1
      DO i=ite,its,-1
        ii = i - its + 1
        tempb1 = sigb(ii, k)/psfc(ii)
        p2db(ii, k) = p2db(ii, k) + tempb1
        psfcb(ii) = psfcb(ii) - p2d(ii, k)*tempb1/psfc(ii)
        sigb(ii, k) = 0.0
      END DO
    END DO
    DO i=ite,its,-1
      ii = i - its + 1
      h2srowb(ii) = 0.0
      dmslrowb(ii) = 0.0
      dmsorowb(ii) = 0.0
      rrdrowb(ii, 3, 2) = 0.0
      emissionb(i, j, 92) = emissionb(i, j, 92) + rrdrowb(ii, 3, 1)
      rrdrowb(ii, 3, 1) = 0.0
      rrdrowb(ii, 2, 2) = 0.0
      emissionb(i, j, 60) = emissionb(i, j, 60) + rrdrowb(ii, 2, 1)
      rrdrowb(ii, 2, 1) = 0.0
      rrdrowb(ii, 1, 2) = 0.0
      emissionb(i, j, 28) = emissionb(i, j, 28) + rrdrowb(ii, 1, 1)
      rrdrowb(ii, 1, 1) = 0.0
      omcrowb(ii, 3, 2) = 0.0
      emissionb(i, j, 94) = emissionb(i, j, 94) + omcrowb(ii, 3, 1)
      omcrowb(ii, 3, 1) = 0.0
      omcrowb(ii, 2, 2) = 0.0
      emissionb(i, j, 62) = emissionb(i, j, 62) + omcrowb(ii, 2, 1)
      omcrowb(ii, 2, 1) = 0.0
      omcrowb(ii, 1, 2) = 0.0
      emissionb(i, j, 30) = emissionb(i, j, 30) + omcrowb(ii, 1, 1)
      omcrowb(ii, 1, 1) = 0.0
      blcrowb(ii, 3, 2) = 0.0
      emissionb(i, j, 91) = emissionb(i, j, 91) + blcrowb(ii, 3, 1)
      blcrowb(ii, 3, 1) = 0.0
      blcrowb(ii, 2, 2) = 0.0
      emissionb(i, j, 59) = emissionb(i, j, 59) + blcrowb(ii, 2, 1)
      blcrowb(ii, 2, 1) = 0.0
      blcrowb(ii, 1, 2) = 0.0
      emissionb(i, j, 27) = emissionb(i, j, 27) + blcrowb(ii, 1, 1)
!      print*,'emissionb(i, j, 27),i,j',emissionb(i, j, 27),i,j
      blcrowb(ii, 1, 1) = 0.0
      emissionb(i, j, 93) = emissionb(i, j, 93) + pono3rowb(ii)
      pono3rowb(ii) = 0.0
      emissionb(i, j, 61) = emissionb(i, j, 61) + pno3rowb(ii)
      pno3rowb(ii) = 0.0
      emissionb(i, j, 29) = emissionb(i, j, 29) + ano3rowb(ii)
      ano3rowb(ii) = 0.0
      emissionb(i, j, 95) = emissionb(i, j, 95) + poso4rowb(ii)
      poso4rowb(ii) = 0.0
      emissionb(i, j, 63) = emissionb(i, j, 63) + pso4rowb(ii)
      pso4rowb(ii) = 0.0
      emissionb(i, j, 31) = emissionb(i, j, 31) + aso4rowb(ii)
      aso4rowb(ii) = 0.0
      emissionb(i, j, 89) = emissionb(i, j, 89) + poso2rowb(ii)
      poso2rowb(ii) = 0.0
      emissionb(i, j, 57) = emissionb(i, j, 57) + pso2rowb(ii)
      pso2rowb(ii) = 0.0
      emissionb(i, j, 25) = emissionb(i, j, 25) + aso2rowb(ii)
      aso2rowb(ii) = 0.0
    END DO
!    print*,'zhaisx in camaerosol_b.F sum(blcrowb)=',sum(blcrowb)
    CALL POPINTEGER4(ad_to2)
    DO l=ad_to2,1,-1
      DO i=ite,its,-1
        ii = i - its + 1
        flandb(i, j, l) = flandb(i, j, l) + fland_2db(ii, l)
        fland_2db(ii, l) = 0.0
      END DO
    END DO
    CALL POPINTEGER4(ad_to1)
    DO l=ad_to1,1,-1
      DO i=ite,its,-1
        ii = i - its + 1
        sand6_2db(ii, l) = 0.0
      END DO
    END DO
    CALL POPINTEGER4(ad_to0)
    DO l=ad_to0,1,-1
      DO i=ite,its,-1
        ii = i - its + 1
        clay2_2db(ii, l) = 0.0
      END DO
    END DO
    CALL POPINTEGER4(ad_to)
    DO l=ad_to,1,-1
      DO i=ite,its,-1
        ii = i - its + 1
        sand2_2db(ii, l) = 0.0
      END DO
    END DO
    DO i=ite,its,-1
      DO k=kte-1,2,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) THEN
          ii = i - its + 1
          umfb(ii, k) = umfb(ii, k) + mbb(ii)
          dmfb(ii, k) = dmfb(ii, k) + mbb(ii)
          mbb(ii) = 0.0
        END IF
      END DO
    END DO
    DO k=kte-1,2,-1
      DO i=ite,its,-1
        nk = kte + 1 - k
        ii = i - its + 1
        zfg3db(i, nk, j) = zfg3db(i, nk, j) + zfgb(ii, k)
        zfgb(ii, k) = 0.0
        dp3db(i, nk, j) = dp3db(i, nk, j) + dpb(ii, k)
        dpb(ii, k) = 0.0
        mc3db(i, nk, j) = mc3db(i, nk, j) + mcb(ii, k)
        mcb(ii, k) = 0.0
        wwb(ii, k) = 0.0
        derb(ii, k) = 0.0
        dmfb(ii, k) = 0.0
        udrb(ii, k) = 0.0
        uerb(ii, k) = 0.0
        umfb(ii, k) = 0.0
      END DO
    END DO
    DO i=ite,its,-1
      ii = i - its + 1
      mb2db(i, j) = mb2db(i, j) + mbb(ii)
      mbb(ii) = 0.0
      esp0b(ii) = 0.0
      dsubcld2db(i, j) = dsubcld2db(i, j) + dsubcldb(ii)
      dsubcldb(ii) = 0.0
      dtb = dtb - raincv(i, j)*qrb(ii, 2)/dt**2
      qrb(ii, 2) = 0.0
      dtb = dtb - rainncv(i, j)*qrb(ii, 1)/dt**2
      qrb(ii, 1) = 0.0
      gswb(i, j) = gswb(i, j) + ffdssb(ii)
      ffdssb(ii) = 0.0
      ftsoilb(ii) = 0.0
      IF (u10(i, j)**2 + v10(i, j)**2 .EQ. 0.0) THEN
        tempb0 = 0.0
      ELSE
        tempb0 = surfwdb(ii)/(2.0*SQRT(u10(i, j)**2+v10(i, j)**2))
      END IF
      u10b(i, j) = u10b(i, j) + 2*u10(i, j)*tempb0
      v10b(i, j) = v10b(i, j) + 2*v10(i, j)*tempb0
      surfwdb(ii) = 0.0
      p8w2db(ii, kte+1) = p8w2db(ii, kte+1) + psfcb(ii)
      psfcb(ii) = 0.0
      ice2db(i, j) = ice2db(i, j) + iceb(ii)
      iceb(ii) = 0.0
      snow2db(i, j) = snow2db(i, j) + snowb(ii)
      snowb(ii) = 0.0
    END DO
    DO k=kte-1,kts,-1
      DO i=ite,its,-1
        ii = i - its + 1
        prate_2db(ii, k, 2) = 0.0
        prate_2db(ii, k, 1) = 0.0
        wpevpa_2db(ii, k) = 0.0
        zfprec_2db(ii, k) = 0.0
        wrscav_2db(ii, k) = 0.0
      END DO
    END DO
    DO k=kte,kts,-1
      DO i=ite,its,-1
        nk = kte + 1 - k
        ii = i - its + 1
        psoab(ii, k) = 0.0
        pso4b(ii, k) = 0.0
        fmodvb(ii, k) = 0.0
        fktm2db(ii, k) = 0.0
        rho2db(ii, k) = 0.0
        w2db(ii, k) = 0.0
        frcldcb(ii, k) = 0.0
        frcldsb(ii, k) = 0.0
        CALL POPreal8(p2d(ii, k))
        p3db(i, nk, j) = p3db(i, nk, j) + p2db(ii, k)
        p2db(ii, k) = 0.0
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) qc2db(ii, k) = 0.0
        qc2db(ii, k) = 0.0
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) sh2db(ii, k) = 0.0
        tempb = sh2db(ii, k)/(qv3d(i, nk, j)+1.)
        qv3db(i, nk, j) = qv3db(i, nk, j) + (1.0-qv3d(i, nk, j)/(qv3d(i&
&          , nk, j)+1.))*tempb
        sh2db(ii, k) = 0.0
        fdzb(ii, k) = 0.0
        t3db(i, nk, j) = t3db(i, nk, j) + t2db(ii, k)
        t2db(ii, k) = 0.0
      END DO
    END DO
    DO k=kte+1,kts,-1
      DO i=ite,its,-1
        nk = kte + 2 - k
        ii = i - its + 1
        p8w3db(i, nk, j) = p8w3db(i, nk, j) + p8w2db(ii, k)
        p8w2db(ii, k) = 0.0
      END DO
    END DO
    DO k=kte,kts,-1
      DO i=ite,its,-1
        ii = i - its + 1
        frcldcb(ii, k) = 0.0
        frcldsb(ii, k) = 0.0
        qc2db(ii, k) = 0.0
      END DO
    END DO
  END DO

!  END DO j_loop

  print*,'zhaisx finish in CAMAEORSOL_B'
END SUBROUTINE CAMAEROSOL_B
