   SUBROUTINE CAMAEROSOL(itimestep,dt,                            &
                    GSW,XLAT,XLONG,                               &
                    ALB,T3D,QV3D,QC3D,                            &
                    P3D,P8W3D,dz8w,pi3D,CLDFRA3D,                 &
                    U3D,V3D,W3D,RHO3D,                            &
                    GMT,JULDAY,XTIME,DECLIN,SOLCON,               &
! For cumulus
                    SNOW2D,ICE2D,                                 &
                    prate1,prate2,raincv,rainncv,                 & 
! For blp & add fktm
                    TMN,u10,v10,SMSTOT,fktm,                      &
                    DEGRAD,number_tracer,num_emission, tracer, sfdust,     &
! wh for dust  
                    num_soil_texture, num_clay,                   &
                    num_desert, num_landuse,                      &
                    sand2, clay2, sand6, fland,emission,          &
                    gdrem1,gdrem2,gdrem3,TU,                      &
!xuemin For cumulus
                    umf3d,uer3d,udr3d,dmf3d,der3d,                & 
                    wrscav,zfprec,wpevpa,                           &
!CSLG
                   cld_fn3d,ww3d, mc3d,dp3d, mb2d,esp02d,zfg3d,   &  
                   dsubcld2d,ideep2d, jt2d, maxg2d, jd2d,         &
                                lengath1d,                        & 
!zch 20100224
                    PSO43d, PSOa3d,                               &
                    ids,ide, jds,jde, kds,kde,                    &
                    ims,ime, jms,jme, kms,kme,                    &
                    its,ite, jts,jte, kts,kte                     )
!------------------------------------------------------------------
   IMPLICIT NONE
!------------------------------------------------------------------

   INTEGER       ids,ide, jds,jde, kds,kde, &
                 ims,ime, jms,jme, kms,kme, &
                 its,ite, jts,jte, kts,kte
   INTEGER       number_tracer
   
   INTEGER       num_soil_texture

   INTEGER       num_clay
  
   INTEGER       num_desert 

   INTEGER       num_landuse

   INTEGER       num_emission

   INTEGER       JULDAY,itimestep  

   REAL        DEGRAD,             &
                                       XTIME,DECLIN,SOLCON
!
   REAL, DIMENSION( ims:ime, kms:kme, jms:jme )                  &
          ::                                   P3D, &
   			        	     		   P8W3D, &
					        	    pi3D, &
					        	     T3D, &
					        	    QV3D, &
					        	    QC3D, &
               	       fktm,dz8w,U3D,V3D,W3D,RHO3D,CLDFRA3D


   REAL,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer)            &
          ::                                    tracer  


!xuemin
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme)                       &
          ::                                    umf3d, &
                                                           uer3d, &
                                                           udr3d, &
                                                           dmf3d, &
                                                           der3d
!CSLG
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme)                       &
          ::                                 cld_fn3d, &
                                                            ww3d, &
                                                            mc3d, &
                                                            dp3d, &
                                                           zfg3d
!CSLG
   REAL, DIMENSION( ims:ime, jms:jme )                           &
          ::                             dsubcld2d, &
                            esp02d,    mb2d

   INTEGER, DIMENSION( ims:ime, jms:jme )                           &
           ::                               ideep2d , &
                                                            jt2d, &
                                                          maxg2d, &
                                                            jd2d
   INTEGER, DIMENSION(jms:jme )   ::     lengath1d

! zch 20100224
   REAL, DIMENSION(ims:ime,kms:kme,jms:jme) ::   PSO43d
   REAL, DIMENSION(ims:ime,kms:kme,jms:jme) ::   PSOA3d

   REAL,DIMENSION(ims:ime,jms:jme,num_soil_texture)              &
          ::                                     sand2
  
   REAL,DIMENSION(ims:ime,jms:jme,num_clay)                      &
          ::                                     clay2

   REAL,DIMENSION(ims:ime,jms:jme,num_desert)                    &
          ::                                     sand6

   REAL,DIMENSION(ims:ime,jms:jme,num_landuse)                   &
          ::                                     fland

   REAL,DIMENSION(ims:ime,jms:jme,num_emission)                   &
          ::                                     emission 

   REAL,DIMENSION(ims:ime,jms:jme,number_tracer)                   &
          ::                                   sfdust,  &
                                                           gdrem1,  &
                                                           gdrem2,  &
                                                           gdrem3
   REAL, DIMENSION( ims:ime, kms:kme, jms:jme )                    &
          ::                                TU 



   REAL,DIMENSION(ite-its+1,num_soil_texture) ::             sand2_2d      

   REAL,DIMENSION(ite-its+1,num_clay)         ::             clay2_2d       

   REAL,DIMENSION(ite-its+1,num_desert)       ::             sand6_2d

   REAL,DIMENSION(ite-its+1,num_landuse)      ::             fland_2d 
   
   REAL,DIMENSION(ite-its+1,3,2)              ::             BLCROW
   
   REAL,DIMENSION(ite-its+1,3,2)              ::             OMCROW
!zch 20100224
   REAL,DIMENSION(ite-its+1,3,2)              ::             RRDROW
   
   REAL,DIMENSION(ite-its+1)                  ::             ASO2ROW 
   REAL,DIMENSION(ite-its+1)                  ::             PSO2ROW 
   REAL,DIMENSION(ite-its+1)                  ::             POSO2ROW 
   REAL,DIMENSION(ite-its+1)                  ::             ASO4ROW 
   REAL,DIMENSION(ite-its+1)                  ::             PSO4ROW 
   REAL,DIMENSION(ite-its+1)                  ::             POSO4ROW 
   REAL,DIMENSION(ite-its+1)                  ::             DMSOROW 
   REAL,DIMENSION(ite-its+1)                  ::             DMSLROW 
   REAL,DIMENSION(ite-its+1)                  ::             H2SROW 
   REAL,DIMENSION(ite-its+1,2)                ::             VOLCROW 
   REAL,DIMENSION(ite-its+1)                  ::             ANO3ROW
   REAL,DIMENSION(ite-its+1)                  ::             PNO3ROW
   REAL,DIMENSION(ite-its+1)                  ::             PONO3ROW

   REAL,DIMENSION(ite-its+1,number_tracer)    ::             rsfdust, &
                                                             gdrem1_2d, &
                                                             gdrem2_2d, &
                                                             gdrem3_2d



!
   REAL, DIMENSION( ims:ime, jms:jme )                           &
          ::                                  XLAT, &
                                                           XLONG, &
                         u10,v10,TMN,SMSTOT,SNOW2D,ICE2D,ALB
! xuemin
   REAL, DIMENSION( ims:ime,  kms:kme,jms:jme )                &
          ::                                      prate1,&
                                                             prate2

   REAL, DIMENSION( ims:ime, kms:kme, jms:jme )              &
          ::                                wrscav,&
                                                       zfprec,&
                                                       wpevpa


   REAL, DIMENSION( ims:ime, jms:jme )                           &
          ::                                raincv,rainncv 

!
   REAL, DIMENSION( ims:ime, jms:jme )                           &
          ::                                      GSW
!
   REAL                                   dt,GMT
!
 
! LOCAL VARS
 
   REAL, DIMENSION( ite-its+1 ) ::                                  &
                                                              ts, &
                                                            cosz, &
          snow,ice,surfwd,ftsoil,ffdss,lat_deg,long_deg,fhs,psfc, &
                                                          albs
!xuemin
 REAL, DIMENSION( ite-its+1,kts:kte-1,2 ) ::              prate_2d
 REAL, DIMENSION( ite-its+1,kts:kte-1 )::              &
                                                       wrscav_2d,&
                                                       zfprec_2d,&
                                                       wpevpa_2d

!SLG
   REAL, DIMENSION( ite-its+1 ) ::                                &
                                                         dsubcld, &
                                       esp0,mb
   INTEGER, DIMENSION( ite-its+1 ) ::                           &
                                                         ideep, &
                                                            jt, &
                                                          maxg, &
                                                            jd
    INTEGER lengath

   REAL, DIMENSION( ite-its+1,2 ) ::                        qr
!   REAL, DIMENSION( ite-its+1,kts:kte-1 ) ::                mu,eu 
!
   REAL, DIMENSION( ite-its+1, kts:kte ) ::                     O3
!
   REAL, DIMENSION( ite-its+1, kts:kte+1 ) ::                    &
						           P8W2D
  
   REAL, DIMENSION( ite-its+1, kts:kte ) ::                       &
        						    SH2D, &
        						    QC2D, &
						             P2D, &
        						     T2D, &
        						     U2D, &
        						     V2D, &
        						     W2D, &
                                                           RHO2D, &
                         fktm2d,sig,hght,fmodv,fdz,frclds,frcldc, &
                                                          fcld2D

   REAL, DIMENSION(ite-its+1,kts:kte-1) :: umf,uer,udr,dmf,der   

!CSLG
   REAL, DIMENSION(ite-its+1,kts:kte-1) :: cld_fn,ww,mc,dp,zfg
   REAL, DIMENSION( ite-its+1, kts:kte,number_tracer) :: aero_tr
   REAL, DIMENSION( ite-its+1, kts:kte)               :: TU_2D  
!zch 20100224
   REAL, DIMENSION( ite-its+1, kts:kte) ::  pso4,psoa

!
   INTEGER :: i,j,k,nk,l,n,ii,testid
   REAL    :: xt24,tloctm,hrang,xxlat

   REAL INNER
   EXTERNAL Initial

!  print*,'----before call aeroexe1-------------kts', kte
!    print *,ids,ide, jds,jde, kds,kde,                    &
!                    ims,ime, jms,jme, kms,kme,                    &
!                    its,ite, jts,jte, kts,kte  

!print*,'zhaisx prints in camaerosol.F'

   do n=13,24
     do k=kts,kte
     do j=jts,jte
     do i=its,ite
     if (tracer(i,k,j,n).gt.0.1)then
     print*, 'tracer bigger than 0.1 before call aeroexe1'
     print*, 'i,k,j,num_tracer',i,k,j,n
     print*,'tracer=',tracer(i,k,j,n)
     endif
     enddo
     enddo
     enddo
   enddo
!
   j_loop: DO J=jts,jte
 
      testid=0
      if (j.eq.52)then
       testid=1
      endif
      if (j.eq.43)then
       testid=2
      endif

      DO K=kts,kte
      DO I=its,ite
        ii= i - its + 1
        QC2D(ii,k) = 0.
        frclds(ii,k) = 0.
        frcldc(ii,k) = 0.
      END DO
      END DO
! reverse vars 
!
      DO K=kts,kte+1
      DO I=its,ite
        ii= i - its + 1
         NK=kte+2-K
         P8W2D(ii,K)=P8W3D(I,NK,J)   ! P8w2D is in Pa
      ENDDO
      ENDDO
!
      DO K=kts,kte
      DO I=its,ite
        ii= i - its + 1
         NK=kte+1-K
         T2D(ii,K)=T3D(I,NK,J)
         fdz(ii,k)=dz8w(i,nk,j)
! SH2D specific humidity
         SH2D(ii,K)=QV3D(I,NK,J)/(1.+QV3D(I,NK,J))
         SH2D(ii,K)=max(0.,SH2D(II,K))
         QC2D(ii,K)=QC3D(I,NK,J)
         QC2D(ii,K)=max(0.,QC2D(II,K))

         P2D(ii,K)=P3D(I,NK,J)            ! P2D is in Pa
         fcld2D(ii,K)=CLDFRA3D(I,NK,J)
         if(qc2d(ii,k).gt.1.0e-6)  then  
            fcld2D(ii,K)=1.0
         else
            fcld2D(ii,K)=0.0
         end if
         frclds(ii,K)=fcld2D(ii,K)
         frcldc(ii,K)=fcld2D(ii,K)
         U2D(ii,K)=U3D(I,NK,J)
         V2D(ii,K)=V3D(I,NK,J)
         W2D(ii,K)=W3D(I,NK,J)
         RHO2D(ii,K)=RHO3D(I,NK,J)
         fktm2d(ii,K)=fktm(I,NK,J)
         fmodv(ii,k)=sqrt(U2D(ii,K)*U2D(ii,K)+V2D(ii,K)*V2D(ii,K))
         pso4(ii,k)=pso43d(i,nk,j)
         psoa(ii,k)=psoa3d(i,nk,j)
      ENDDO
      ENDDO

!xuemin
      DO K=kts,kte-1
      DO I=its,ite
        ii= i - its + 1
!         NK=kme-1-K+kms
         NK=kte+1-K
         wrscav_2d(ii,k)=wrscav(I,NK,J)
         zfprec_2d(ii,k)=zfprec(I,NK,J)
         wpevpa_2d(ii,k)=wpevpa(I,NK,J)
        prate_2d(ii,k,1)=prate1(I,NK,J)
        prate_2d(ii,k,2)=prate2(I,NK,J)

      ENDDO
      ENDDO

      DO I=its,ite
        ii= i - its + 1
         snow(ii)=snow2d(i,j)
         ice(ii)=ice2d(i,j)
         psfc(ii)=P8W2D(ii,kte+1)   ! Psfc is in Pa
         surfwd(ii)=sqrt(U10(I,J)*U10(I,J)+ v10(I,J)* v10(I,J))
         ftsoil(ii)=TMN(I,J)
         ffdss(ii)=GSW(I,J)
         qr(ii,1)=rainncv(i,j)/dt  ! convert unit from mm to kg/m2s wh 060814
         qr(ii,2)=raincv(i,j)/dt
!CSLG
         dsubcld(ii)=dsubcld2d(i,j)
         esp0(ii)=esp02d(i,j)
         ideep(ii)=ideep2d(i,j)
         jt(ii)=jt2d(i,j)
         maxg(ii)=maxg2d(i,j)
         jd(ii)=jd2d(i,j)
         mb(ii)=mb2d(i,j)
      ENDDO

!zch
        lengath =lengath1d(j)
      DO K=2,kte-1
      DO I=its,ite
        ii= i - its + 1
        NK=kte+1-K
         umf(ii,k)=umf3d(i,nk,j) 
         uer(ii,k)=uer3d(i,nk,j) 
         udr(ii,k)=udr3d(i,nk,j) 
         dmf(ii,k)=dmf3d(i,nk,j) 
         der(ii,k)=der3d(i,nk,j) 
!CSLG
         cld_fn(ii,k)=cld_fn3d(i,nk,j)
         ww(ii,k)=ww3d(i,nk,j)
         mc(ii,k)=mc3d(i,nk,j)
         dp(ii,k)=dp3d(i,nk,j)
         zfg(ii,k)=zfg3d(i,nk,j)

      ENDDO
      ENDDO
!zch
      DO I=its,ite
       DO K=2,kte-1      
       ii= i - its + 1
        NK=kte+1-K
        if(MB(ii).lt.1.0e-33) then
           MB(ii)=umf(ii,k)+dmf(ii,k)
        else
        endif
       enddo
      enddo

! wh for dust data     
      DO L=1,num_soil_texture
      DO I=its,ite
        ii= i - its + 1
          sand2_2d(ii,l)=sand2(i,j,l)
      ENDDO
      ENDDO
      DO L=1,num_clay
      DO I=its,ite
        ii= i - its + 1
          clay2_2d(ii,l)=clay2(i,j,l)
      ENDDO
      ENDDO
      DO L=1,num_desert
      DO I=its,ite
        ii= i - its + 1
          sand6_2d(ii,l)=sand6(i,j,l)
      ENDDO
      ENDDO
      DO L=1,num_landuse
      DO I=its,ite
        ii= i - its + 1
          fland_2d(ii,l)=fland(i,j,l)
      ENDDO
      ENDDO

!  xuemin for emission

      DO I=its,ite
        ii= i - its + 1

         ASO2ROW(ii)  = emission(i,j,25)
         PSO2ROW(ii)  = emission(i,j,57)
         POSO2ROW(ii) = emission(i,j,89)
         ASO4ROW(ii)  = emission(i,j,31)
         PSO4ROW(ii)  = emission(i,j,63)
         POSO4ROW(ii) = emission(i,j,95)
         
         ANO3ROW(ii) = emission(i,j,29)
         PNO3ROW(ii) = emission(i,j,61)
         PONO3ROW(ii) = emission(i,j,93)
         BLCROW(ii,1,1) = emission(i,j,27)
         BLCROW(ii,1,2) =  5.
         BLCROW(ii,2,1) = emission(i,j,59)
         BLCROW(ii,2,2) =  50.
         BLCROW(ii,3,1) = emission(i,j,91)
         BLCROW(ii,3,2) = 120.
         OMCROW(ii,1,1) = emission(i,j,30)
         OMCROW(ii,1,2) = 5.
         OMCROW(ii,2,1) = emission(i,j,62)
         OMCROW(ii,2,2) = 50.
         OMCROW(ii,3,1) = emission(i,j,94)
         OMCROW(ii,3,2) = 120.
! zch 20100224
         RRDROW(ii,1,1) =emission(i,j,28)
         RRDROW(ii,1,2) =  5.
         RRDROW(ii,2,1) =emission(i,j,60)
         RRDROW(ii,2,2) =  50.
         RRDROW(ii,3,1) =emission(i,j,92)
         RRDROW(ii,3,2) = 120.

         DMSOROW(ii) = 0.
         DMSLROW(ii) = 0.
         H2SROW(ii)  = 0.
         VOLCROW(ii,1)  = 0.
         VOLCROW(ii,2)  = 0.
      ENDDO

      DO K=kts,kte
      DO I=its,ite
        ii= i - its + 1
         sig(ii,k)= p2d(ii,k)/psfc(ii)
      ENDDO
      ENDDO
      DO I=its,ite
        ii= i - its + 1
        hght(ii,kte) = fdz(ii,kte)
      END DO
      DO K=2,kte
      DO I=its,ite
        ii= i - its + 1
        NK=kte+1-K
        hght(ii,nk)=hght(ii,nk+1)+dz8w(i,k,j)
      ENDDO
      ENDDO

      DO K=kts,kte
      DO I=its,ite
         ii= i - its + 1
         NK=kte+1-K
      DO L=1,number_tracer
         aero_tr(ii,k,l)=tracer(i,nk,j,l)
      ENDDO
         TU_2D(ii,k) = TU(i,nk,j)
      ENDDO
      ENDDO

!
! ... Vertical profiles for ozone
!
! ... Solar zenith angle
!
      do i = its,ite
        ii= i - its + 1
        xt24 = amod(xtime + dt * 0.5, 1440.)
        tloctm = GMT + xt24 / 60. + XLONG(i,j) / 15.
        hrang = 15. * (tloctm - 12.) * degrad
        xxlat = XLAT(i,j) * degrad
        cosz(ii) = sin(xxlat) * sin(declin) + &
                  cos(xxlat) * cos(declin) * cos(hrang)
        ALBS(ii) = ALB(i,j)
        lat_deg(ii)=XLAT(i,j)
        long_deg(ii)=XLONG(i,j)  
   !     fhs(ii)=SMSTOT(I,J)
        fhs(ii)=SMSTOT(I,J) 
      end do
    

!      if(1.eq.2)  then
!      call Check_Adj_aeroexe1(dt,J,itimestep,ite-its+1,kte-kts+1,              &
!                  t2d,sh2d,psfc,sig,hght,surfwd,                     &
!                  w2d,RHO2D,fmodv,qc2d,fktm2d,ftsoil,                &
!                   ice,snow,ffdss,fdz,lat_deg,long_deg,              &
!                   cosz,frclds,frcldc,qr,                            &
!                   number_tracer,                                    &
!                   num_soil_texture,num_clay,                        &
!                   num_desert,num_landuse,num_emission,              &
!                   sand2_2d,clay2_2d,sand6_2d,fland_2d,              & 
!                   blcrow,omcrow,julday,fhs,aero_tr,rsfdust,         &
!                   aso2row,pso2row,poso2row,aso4row,pso4row,poso4row,&
!                   dmsorow,dmslrow,h2srow,                           & 
!                   gdrem1_2d,gdrem2_2d,gdrem3_2d,ANO3ROW,PNO3ROW,PONO3ROW,&       
!                   umf,uer,udr,dmf,der,                              &        
!                   prate_2d,wrscav_2d,zfprec_2d,wpevpa_2d,            & 
!                   ww,mc,dp,mb,esp0,zfg,                             &
!                   dsubcld,ideep, jt, maxg, jd, lengath,             &
!                   PSO4,PSOA,RRDROW)
!      end if

      call aeroexe1(dt,J,itimestep,ite-its+1,kte-kts+1,              &
                  t2d,sh2d,psfc,sig,hght,surfwd,                     &
                  w2d,RHO2D,fmodv,qc2d,fktm2d,ftsoil,                &
                   ice,snow,ffdss,fdz,lat_deg,long_deg,              &
                   cosz,frclds,frcldc,qr,                            &
                   number_tracer,                                    &
                   num_soil_texture,num_clay,                        &
                   num_desert,num_landuse,num_emission,              &
                   sand2_2d,clay2_2d,sand6_2d,fland_2d,              & 
                   blcrow,omcrow,julday,fhs,aero_tr,rsfdust,         &
                   aso2row,pso2row,poso2row,aso4row,pso4row,poso4row,&
                   dmsorow,dmslrow,h2srow,                           & 
                   gdrem1_2d,gdrem2_2d,gdrem3_2d,ANO3ROW,PNO3ROW,PONO3ROW,&       
                   umf,uer,udr,dmf,der,                              &                    
                   prate_2d,wrscav_2d,zfprec_2d,wpevpa_2d,            & 
                   ww,mc,dp,mb,esp0,zfg,                             &
                   dsubcld,ideep, jt, maxg, jd, lengath,             &
                   PSO4,PSOA,RRDROW)
       
       DO K=kts,kte
       DO I=its,ite
         ii= i - its + 1
         NK=kte+1-K
       DO L=1,number_tracer
            tracer(i,k,j,l)=aero_tr(ii,nk,l)
!       if(L.le.60.and.L.ge.49.and.nk.eq.1.and.aero_tr(ii,nk,l).ne.0) print *,'after', aero_tr(ii,k,l),ii,k,l
       ENDDO
            TU(i,k,j)=TU_2D(ii,nk)  
       ENDDO
       ENDDO

       DO L=1,73
       DO I=its,ite
         ii= i - its + 1
            sfdust(i,j,l)=rsfdust(ii,l)
            gdrem1(i,j,l)=gdrem1_2d(ii,l)
            gdrem2(i,j,l)=gdrem2_2d(ii,l)
            gdrem3(i,j,l)=gdrem3_2d(ii,l)

       ENDDO
       ENDDO

     
   ENDDO j_loop                                          


   END
