      SUBROUTINE SFSS   (TRAC,  DSHJ,  ILG,   LEV,  ILEV,
     1                     R1,    R2,  DF0,   DF1,   DF2, I_SS,         
     2                      T,   NTR,   NN,   NTP, ISIZE,  LUC,            
     3               AEROSIZE,SURFWD,RHOP0,RSFROW,PRESSG,   GC,        
     4                  FLAND,FINTROW, IL1,   IL2,  IAE1,IREST)
!----------------------------------------------------------------------
!     PURPOSE:
!     --------
!     A subroutine to evaluate the generation rate of sea salt aerosols
!     as a function of meteorologic conditions.
!
!     HISTORY:
!
!     * NOV 04/02 - S.L. GONG   A NEW SCHEME - GONG-MONAHAN [Global 
!                               Biogeochemical Cycles,2003]
!     *                         WAS USED RE REPLACE THE OLD MONAHAN'S
!     *                         SCHEME SO THAT THE APPLIABLE RANGE OF
!     *                         SEA-SALT PRODUCTION IS EXPANDED TO LESS
!     *                         THAN 0.1 MIRON.
!     * OCT 31/01 - S.L. GONG   THE PARTICLE MASS OF EACH SUB-DEVIDED
!     *                         BIN IS NOW COMPUTED IN THE DO IK=1,N*35
!     *                         LOOP: PMASS. IT WAS DONE ON AN AVERAGED
!     *                         MASS IN A BIN. VERSION 5C
!     *
!     * AUG 01/01 - S.L. GONG   THE SURF ZONE PRODUCTION OF SEA SPRAY
!     *                         FUNCTION OF de LEEUW ET AL (2001) WAS   
!     *                         ADDED WITH OCEAN COVER LESS THAN 20% GRID.
!     *
!     * SEP 02/99 - S.L. GONG   ADD THE SMITH'S SEA-SALT SURFACE FLUX
!     *                         FUNCTION. 
!     *
!     * JUN 11/98 - S.L. GONG   FLUX INTEGRATION OVER EACH SIZE BIN IS 
!     *                         DONE NOW WHEN MODEL STARTS OR RESTARTS. 
!     *                         THE INTEGRATED EFFICIENT IS SAVED IN  
!     *                         FINTROW.
!     *
!     * DEC 12/97 - S.L. GONG   NEW LANDUSE CATAGORY FLAND ARRAY IS USED
!     *                         TO REPLACE GC. THE FLAND IS BASED UPON
!     *                         EOS 1x1 km RESOLUTION DATA SETS. 
!     *
!     * DEC 19/96 - S.L. GONG   AS IN PREVIOUS SFSALT BUT
!     *                         OPTIMIZED BY VECTORIZATION
!     *
!     * NOV 21/94 - S.L. GONG   AEROSOL SURFACE FLUX COMPUTATION
!     *                         FOR SEA-SALT
!
!     METHOD:
!     -------
!     Monahan et al (Oceanic Whitecaps, E.C. Monahan
!     and G.Mac Niocail (eds), 1986)
!
!     Smith et al.
!     
!     Gong, Global Biogeochemical Cycles 2003
!
!     ARGUMENTS:
!     ----------
!     SUBROUTINE CALLED FROM SFFLUX
!
!----------------------------------------------------------------------

      COMMON /PARAMS/ WW,TW,RAYON,ASQ,G,RGAS,RGOCP,RGOASQ,CPRES        
      COMMON /PARAMS/ RGASV,CPRESV                                     
      COMMON  /TIMES/ DELT,IFDIFF,KSTART,KTOTAL,NEWRUN,                
     1                NDAYS,NSECS,IDAY,LDAY,MDAY,INCD                  
      REAL TRAC   (ILG,LEV,NTR), DSHJ(ILG,ILEV), T(ILG,LEV), GC(ILG)   
      REAL AEROSIZE(2,ISIZE),SURFWD(ILG),RHOP0(NTP),PRESSG(ILG)
      REAL RSFROW(ILG,NTR), FLAND(ILG,LUC), FINTROW(ILG,ISIZE,3)          
      REAL R1(ILG), R2(ILG), DF0(ILG), DF1(ILG), DF2(ILG)                               
      REAL CC (4,4)                                                    
      DATA CC /0.7674, 3.079, 2.572E-11, -1.424,                       
     1         0.3926, 3.101, 4.190E-11, -1.404,                       
     2         0.2789, 3.115, 5.415E-11, -1.399,                       
     3         0.4809, 3.082, 3.110E-11, -1.428/                       
C                                                                      
C    STATEMENT FUNCTIONS
!
!     (1) GONG-MONAHAN'S SOURCE                                        
!                                                                      
      B(X)  = (0.433333-LOG10(X))/0.433333                                     

      FLX0(X)=1.373*X**(-4.7*(1.+35.0*X)**(-0.017*X**(-1.44)))*(1.0+        
     1                    0.057*X**3.45)*10.0**(1.607*EXP(-B(X)*B(X))) 
C
C     (2) SMITH'S SOURCE
C
      FLX1(X)=EXP(-3.1*(LOG(X/2.1))**2)
      FLX2(X)=EXP(-3.3*(LOG(X/9.2))**2)
C
C     (3)  SURF ZONE PRODUCTION
C
      FLX3(X)=1.1*X**(-1.65)
c      print*,'sfss',is_x0(il1),ie_x0(il2)

C
C     FOR NON-START RUN, USE THE SAVED FINTROW TO COMPUTE FLUX
C
      IF (IREST .EQ. 0) GOTO 100
C
C     OTHERWISE COMPUTE THE INTEGRATION OF SEA-SALT FOR THIS
C     MODEL RUN - FINTROW
C
      CALL PUTZERO (FINTROW, ILG*ISIZE*3)

      DO N = 1,ISIZE 
          RR1 = AEROSIZE(1, N)*100.0     !From m to cm 
          RR2 = AEROSIZE(2, N)*100.0                                   
          DO I=IL1,IL2                                                 
C                                                                      
C     * CONVERT THE DRY SIZE OF SEA-SALT AEROSOLS INTO WET SIZE BY     
C         TAKING RH INTO ACCOUNT. THE WET SIZE (80% RH) IS             
C         USED IN THE SURFACE FLUX CALCULATION.                        
C                                                                      
C     * TEMPERATURE EFFECT                                             
C                                                                      
             CC3 = CC(3,1)*(1.0+0.004*(298.0-T(I,ILEV+1)))             
             R1(I) = (RR1**3+CC(1,1)*RR1**CC(2,1)/                     
     1                (  CC3*RR1**CC(4,1) - LOG10(0.8)  )              
     3                )**(1./3.)*10000.00                          
             R2(I) = (RR2**3+CC(1,1)*RR2**CC(2,1)/                     
     1                (  CC3*RR2**CC(4,1) - LOG10(0.8)  )              
     3                )**(1./3.)*10000.00                       
C                                                                     
C     * DF0 is for the indirect mechanism (via bubbles)               
C                                                                     
             DF0(I)=0.                                                
             DF1(I)=0.
             DF2(I)=0.
          END DO                                                      
          DO IK=1,N*35                                                
             DO I=IL1,IL2
C
C      GC(ILG) = 1 FOR SEA-ICE EXCLUDED FROM SEA-SALT PRODUCTION
C                                             
                DEL = (RR2-RR1)/FLOAT(N*35)        !del in cm
                RWI = (RR1+DEL*FLOAT(IK-1))*1.E-2  !from cm to m                   
C                                                                      
C     * DRY VOLUME AND MASS OF AN AEROSOL PARTICLE OF SIZE RWI             
C                                                                      
                PVOL = 4./3.*3.1415926*RWI**3                                
                PMASS = PVOL*RHOP0(NN)                                       
                
                DELR0 = (R2(I)-R1(I))/FLOAT(N*35)

                IF (FLAND(I,14) .GT. 0.0 .AND. GC(I) .NE. 1.0) THEN 
                   IF (I_SS .EQ. 1) THEN      !GONG'S SCHEME
                     DF0(I) = DF0(I)+DELR0*PMASS*                            
     1                     FLX0(R1(I)+DELR0*FLOAT(IK-1))
                     
                   ELSE                       !SMITH'S SCHEME
                     DF0(I) = DF0(I)+DELR0*PMASS*
     1                     FLX1(R1(I)+DELR0*FLOAT(IK-1))
                     DF1(I) = DF1(I)+DELR0*PMASS*
     1                     FLX2(R1(I)+DELR0*FLOAT(IK-1))
                   END IF
C
C        SURF ZONE PRODUCTION
C
                   IF (FLAND(I,14) .LT. 1.0) THEN
                       DF2(I)=DF2(I)+DELR0*2.0*PMASS*
     1                     FLX3(R1(I)*2.0+DELR0*2.0*FLOAT(IK-1)) 
                   END IF            
                 END IF
             END DO                                                   
          END DO                                                      
          DO I=IL1,IL2
            FINTROW(I,N,1) = DF0(I)
            FINTROW(I,N,2) = DF1(I)
            FINTROW(I,N,3) = DF2(I)
          END DO                                                      
      END DO
  100 CONTINUE                                                        

!                                                                     
!     *  INSERTION DU FLUX DE SURFACE                                 
!
!                                                                    
      DO 842 N = 1,ISIZE
         NP=ISIZE*(NN-1)+N+(IAE1-1)
         DO 842 I=IL1,IL2 
           IF (SURFWD(I) .GT. 0.0 .AND. GC(I) .NE. 1.0 .AND. 
     1                                   FLAND(I,14) .GT. 0.0) THEN    
              IF (I_SS .EQ. 1) THEN      !GONG-MONAHAN'S SCHEME
                  RSFROW(I,NP) = FINTROW(I,N,1)*SURFWD(I)**3.41
     1                                                 *FLAND(I,14)
              ELSE                       !SMITH'S SCHEME
                  A1 = 10**(0.0676*SURFWD(I)+2.430)
                  A2 = 10**(0.9590*SQRT(SURFWD(I))-1.476)
                  RSFROW(I,NP) = (A1*FINTROW(I,N,1)+A2*FINTROW(I,N,2))
     1                           *FLAND(I,14)
              END IF
!
!     ADDING SURFING PRODUCTION FLUX
!
              RSFROW(I,NP) =RSFROW(I,NP)+ FINTROW(I,N,3)
     1                            *EXP(0.23*SURFWD(I))*FLAND(I,14)
c   vertical diffusion moved to MRF in MM5
              TRAC(I,ILEV+1,NP) = TRAC(I,ILEV+1,NP) + RSFROW(I,NP)
     1                  /(DSHJ(I,ILEV)*PRESSG(I)/G)*2.*DELT      
!         if(RSFROW(I,NP).gt.0) print *, RSFROW(I,NP),I,NP,'sea-salt'
              
           END IF
  842 CONTINUE                                                        
      RETURN                                                          
      END                                                             
