      SUBROUTINE SFSF_B(trac, tracb, dshj, dshjb, ilg, lev, ilev, mae, 
     +                  ntr, nn, isize, aerosize, aerosizeb, volcrow, 
     +                  aso4row, aso4rowb, pso4row, pso4rowb, poso4row, 
     +                  poso4rowb, aso2row, pso2row, poso2row, pressg, 
     +                  pressgb, roarow, dmsorow, dmslrow, h2srow, frac
     +                  , fracb, rsfrow, rsfrowb, rgd, surfwd, zhlev, 
     +                  fland, il1, il2, iae1, gt, ih2s, idms, iso2, luc
     +)
      IMPLICIT NONE
C
C     * FOR THE PRECUSORS DMS OF SULPHATE
C       FIRST USE WANNIKHOF MASS TRANSFER COEFFICIENT TO RELATE THE
C       DMS SURFACE FLUX WITH DMS OCEANIC CONCENTRATION
C       ZKL -- M S-1
C
C      DO IL=IL1,IL2
C         IF (FLAND (IL,14) .GT. 0.1) THEN
C            GTC=GT(IL)-273.0
C            SC=2674.0-147.12*GTC+3.726*GTC*GTC-
C     1                           0.038*GTC*GTC*GTC
C            SC=AMIN1(AMAX1(SC, 577.0), 2027.0)
C            CONV=0.01/3600.
C
C     WANNINKOF SCHEME
C
C            ZKL=0.31*SURFWD(IL)*SURFWD(IL)/SQRT(SC/660.0)*CONV
C
C     LISS AND MERLIVAT SCHEME
C
C            IF (SURFWD(IL) .LT. 3.6) THEN
C               ZKL=0.17*SURFWD(IL)*(SC/660.0)**(-2./3.)*CONV
C            END IF 
C            IF (SURFWD(IL) .GE. 3.6 .AND. SURFWD(IL) .LT. 13.) THEN
C               ZKL=(2.85*SURFWD(IL)-9.65)/SQRT(SC/660.0)*CONV
C            END IF            
C            IF (SURFWD(IL) .GE. 13.0 ) THEN
C               ZKL=(5.9*SURFWD(IL)-49.3)/SQRT(SC/660.0)*CONV
C            END IF
C
C     HENRY'S LAW CONSTANT FOR DMS
C
C            if(GT(IL).lt.100.) GT(IL)=285.
C            print *,' GT(IL)=',GT(IL), IL
C            H=EXP(-3547.0/GT(IL)+12.64)      !  [ATM L MOL-1]
C            print *, '0 H =', H
C            H=H/(0.08205*GT(IL))             !  [DIMENSIONLESS]
C            print *, '1 H =', H
C            RDMS=AMAX1(RGD(IL,ILEV,IDMS),0.0)
C            print *, 'DMS=',ZKL, DMSOROW(IL),RDMS,ROAROW(IL,ILEV),H
C            RSFROW(IL,IDMS)=ZKL*(DMSOROW(IL)*62.128E-9-
C     1                  RDMS*ROAROW(IL,ILEV)/H)
C            RSFROW(IL,IDMS)= AMAX1(RSFROW(IL,IDMS),0.0)*FLAND(IL,14)
C         END IF
C      END DO
C
C      DO IL=IL1,IL2
C         RSFROW(IL,IH2S)=H2SROW(IL)*TT*34.0/32.0
C         RSFROW(IL,IDMS)=RSFROW(IL,IDMS)+DMSLROW(IL)*TT*62.128/32.0
C         RSFROW(IL,ISO2)=(ASO2ROW(IL)+PSO2ROW(IL))*TT1
C         TRAC(IL,ILEV+1,IH2S)=TRAC(IL,ILEV+1,IH2S)+RSFROW(IL,IH2S)
C     1                     /(DSHJ(IL,ILEV)*PRESSG(IL)/G)*2.*DELT
C         TRAC(IL,ILEV+1,IDMS)=TRAC(IL,ILEV+1,IDMS)+RSFROW(IL,IDMS)
C     1                     /(DSHJ(IL,ILEV)*PRESSG(IL)/G)*2.*DELT
C         TRAC(IL,ILEV+1,ISO2)=TRAC(IL,ILEV+1,ISO2)+ASO2ROW(IL)*TT1
C     1                     /(DSHJ(IL,ILEV)*PRESSG(IL)/G)*2.*DELT
C      END DO
C
C      * HIGHER POINT SOURCES
C
C      DO L=ILEV,2+MAE,-1
C         DO IL=IL1,IL2
C           IF (HEIGHT.GT.ZHLEV(IL,L).AND.HEIGHT.LE.ZHLEV(IL,L-1)) THEN
C               TRAC(IL,L,ISO2)=TRAC(IL,L,ISO2)+PSO2ROW(IL)*TT1
C     1                        /(DSHJ(IL,L-1)*PRESSG(IL)/G)*2.*DELT
C           END IF
C           IF (HEIGHT.GT.0.0.AND.HEIGHT.LE.ZHLEV(IL,ILEV)) THEN
C               TRAC(IL,LEV,ISO2)=TRAC(IL,LEV,ISO2)+PSO2ROW(IL)*TT1
C     1                        /(DSHJ(IL,ILEV)*PRESSG(IL)/G)*2.*DELT
C           END IF
C         END DO
C      END DO
C
C     * POWER POINT SOURCES
C
C      DO L=ILEV,2+MAE,-1
C         DO IL=IL1,IL2
C           IF (HEIGHTP.GT.ZHLEV(IL,L).AND.HEIGHTP.LE.ZHLEV(IL,L-1)) THEN
C               TRAC(IL,L,ISO2)=TRAC(IL,L,ISO2)+POSO2ROW(IL)*TT1
C     1                        /(DSHJ(IL,L-1)*PRESSG(IL)/G)*2.*DELT
C           END IF
C           IF (HEIGHTP.GT.0.0.AND.HEIGHTP.LE.ZHLEV(IL,ILEV)) THEN
C               TRAC(IL,LEV,ISO2)=TRAC(IL,LEV,ISO2)+POSO2ROW(IL)*TT1
C     1                        /(DSHJ(IL,ILEV)*PRESSG(IL)/G)*2.*DELT
C           END IF
C         END DO
C      END DO
C
C
C     * VOLCANIC EMISSIONS [THIS PART OF THE CODE WAS MODIFIED FROM LOHMANN'S
C       ORIGINAL VOLCANO CODE, WITH THANKS]
C
C      JT=ISO2
C      DO L=1+MAE,ILEV
C         ZVOLCEMI=8.
C         ZVOLCEMI1=ZVOLCEMI*0.36
C         ZVOLCEMI2=ZVOLCEMI*0.36
C         ZVOLCEMI3=ZVOLCEMI*0.28
C         DO IL=IL1,IL2
C           HTV=VOLCROW(IL,2)
C           IF (HTV.GT.ZHLEV(IL,L).AND.HTV.LE.ZHLEV(IL,L-1)) THEN 
C              ZDP1 =G/(DSHJ(IL,L)*PRESSG(IL))
C              TRAC(IL,L+1,JT)=TRAC(IL,L+1,JT)+
C     1                    ZVOLCEMI1*VOLCROW(IL,1)*ZDP1 *2.*DELT
C           END IF
C         END DO
C         IF (L .EQ. ILEV) THEN
C           DO IL=IL1,IL2
C
C    VOLCANIC BACKGROUND EMISSIONS
C
C      ZVOLCEMI  TOTAL VOLCANIC EMISSION SCALED TO 8 TG/YR IN KG/M2/S
C
C            IF(VOLCROW(IL,2).GT.0.) THEN
C              ZDP13=G/(DSHJ(IL,13)*PRESSG(IL))
C              ZDP14=G/(DSHJ(IL,14)*PRESSG(IL))
C              ZDP18=G/(DSHJ(IL,25)*PRESSG(IL))
C              ZDP19=G/(DSHJ(IL,26)*PRESSG(IL))
C
C              RSFROW(IL,ISO2)=RSFROW(IL,ISO2)+VOLCROW(IL,1)*ZVOLCEMI
C              TRAC(IL,27,JT)=TRAC(IL,27,JT)+
C     1                0.5*ZVOLCEMI2*VOLCROW(IL,1)*ZDP19*2.*DELT
C              TRAC(IL,26,JT)=TRAC(IL,26,JT)+
C     1                0.5*ZVOLCEMI2*VOLCROW(IL,1)*ZDP18*2.*DELT
C              TRAC(IL,15,JT)=TRAC(IL,15,JT)+
C     1                0.5*ZVOLCEMI3*VOLCROW(IL,1)*ZDP14*2.*DELT
C              TRAC(IL,14,JT)=TRAC(IL,14,JT)+
C     1                0.5*ZVOLCEMI3*VOLCROW(IL,1)*ZDP13*2.*DELT
C            END IF
C           END DO
C         END IF
C      END DO
C
C      RETURN
      REAL g
      REAL ww
      REAL tw
      REAL rgocp
      REAL rayon
      REAL cpres
      REAL rgoasq
      REAL rgas
      REAL asq
C------------------------------------------------------------------------------
C
C     HISTORY:
C     * JAN 02/2008 - C.H. Zhou   ADDING CAWAS EMSSION INTO SFSF, REPLACE
C     *                           SO2 AND SO4 , AND KEEP DMS AND H2S
C     *
C     * JAN 30/1998 - S.L. GONG   ADDING DMS OCEAN SURFACE CONCENTRATION
C     *                           AND FLUX FORMULATION. REPLACING PREVIOUS
C     *                           FLUX INPUT FILE
C     *
C     * MAY 26/1997 - S.L. GONG   FIRST IMPLEMENTED
C     *                           OPTIMIZED BY VECTORIZATION
C
C     ----------
C     SUBROUTINE CALLED FROM SFFLUX
C
C------------------------------------------------------------------------------
C
C          SF
      COMMON /params/ ww, tw, rayon, asq, g, rgas, rgocp, rgoasq, cpres
      REAL cpresv
      REAL rgasv
C          SF
      COMMON /params/ rgasv, cpresv
      INTEGER nsecs
      REAL delt
      INTEGER incd
      INTEGER mday
      INTEGER newrun
      INTEGER lday
      INTEGER ifdiff
      INTEGER iday
      INTEGER ktotal
      INTEGER ndays
      INTEGER kstart
C          SF
C          SF
      COMMON /times/ delt, ifdiff, kstart, ktotal, newrun, ndays, nsecs
     +, iday, lday, mday, incd
      INTEGER ntr
      INTEGER lev
      INTEGER ilg
      INTEGER ilev
      REAL trac(ilg, lev, ntr), dshj(ilg, ilev), gt(ilg)
      REAL tracb(ilg, lev, ntr), dshjb(ilg, ilev)
      REAL pressg(ilg), zhlev(ilg, ilev), surfwd(ilg)
      REAL pressgb(ilg)
      INTEGER isize
      REAL rsfrow(ilg, ntr), aerosize(2, isize)
      REAL rsfrowb(ilg, ntr), aerosizeb(2, isize)
      REAL aso4row(ilg), pso4row(ilg), aso2row(ilg), pso2row(ilg)
      REAL aso4rowb(ilg), pso4rowb(ilg)
      REAL poso4row(ilg), poso2row(ilg)
      REAL poso4rowb(ilg)
      REAL dmsorow(ilg), dmslrow(ilg), h2srow(ilg), volcrow(ilg, 2)
      REAL rgd(ilg, ilev, ntr), roarow(ilg, ilev)
      INTEGER luc
      REAL frac(isize), fland(ilg, luc)
      REAL fracb(isize)
      REAL tt
      REAL tt1
      REAL totv
      REAL totvb
      INTEGER n
      REAL rwi
      REAL rwib
      REAL alogdi
      REAL alogdib
      REAL amean
      REAL asigma
      INTEGER nf
      INTEGER il
      INTEGER l
      INTEGER branch
      INTEGER il1
      REAL gb
      INTEGER il2
      INTEGER nn
      REAL deltb
      INTEGER idms
      INTEGER iae1
      INTEGER mae
      INTEGER iso2
      INTEGER ih2s
      REAL temp3
      REAL temp2
      REAL temp1
      REAL temp0
      REAL heightp
      INTRINSIC EXP
      REAL tempb1
      REAL tempb0
      REAL temp0b
      REAL temp3b
      REAL temp2b0
      REAL tempb
      REAL temp0b0
      REAL temp2b
      REAL temp3b0
      INTRINSIC LOG10
      REAL temp1b
      REAL temp
      REAL height
      REAL temp1b0
      COMMON /times_b/ deltb
      COMMON /params_b/ gb
      DATA height /5.0/
      DATA heightp /120.0/
C
C     * SURFACE FLUX - UNIT KG M-2 S-1
C       FACTOR TT CONVERTS EMISSION UNIT FROM MT M-2 SEASON-1
C       TO KG M-2 S-1
C
      tt = 1.0e-3
C
C     * SIZE DISTRIBUTION OF PRIMARY SULPHATE AEROSOLS
C       r=0.125 um, std dev=1.7
C
      totv = 0.0
      DO n=1,isize
        rwi = (aerosize(1, n)+aerosize(2, n))/2.0*1.e6
        CALL PUSHreal8(alogdi)
        alogdi = LOG10(2.*rwi)
        CALL PUSHreal8(amean)
C         MMD 0.25 um
        amean = LOG10(0.25)
        asigma = 0.17
        frac(n) = EXP(-((alogdi-amean)**2./asigma))
        totv = totv + frac(n)
      ENDDO
      DO n=1,isize
        CALL PUSHreal8(frac(n))
        frac(n) = frac(n)/totv
        IF (frac(n) .LT. 1.e-9) THEN
          frac(n) = 0.0
          CALL PUSHCONTROL1B(1)
        ELSE
          CALL PUSHCONTROL1B(0)
        END IF
      ENDDO
C        print *, 'FRAC=', FRAC
C
C
C     * FOR PRIMARY SULPHATE AEROSOLS
C
      DO n=1,isize
        CALL PUSHINTEGER4(nf)
        nf = isize*(nn-1) + n + (iae1-1)
        DO il=il1,il2
          CALL PUSHreal8(rsfrow(il, nf))
          rsfrow(il, nf) = aso4row(il)*frac(n)*tt
        ENDDO
C
C      * HIGHER POINT SOURCES
C
        DO l=ilev,2,-1
          DO il=il1,il2
            IF (height .GT. zhlev(il, l) .AND. height .LE. zhlev(il, l-1
     +          )) THEN
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (height .GT. 0.0 .AND. height .LE. zhlev(il, ilev)) THEN
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
          ENDDO
        ENDDO
C
C      * POWER POINT SOURCES
C
        DO l=ilev,2,-1
          DO il=il1,il2
            IF (heightp .GT. zhlev(il, l) .AND. heightp .LE. zhlev(il, l
     +          -1)) THEN
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (heightp .GT. 0.0 .AND. heightp .LE. zhlev(il, ilev)) 
     +      THEN
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
          ENDDO
        ENDDO
      ENDDO
      DO n=isize,1,-1
        DO l=2,ilev,1
          DO il=il2,il1,-1
            CALL POPCONTROL1B(branch)
            IF (branch .NE. 0) THEN
              temp3 = dshj(il, ilev)*pressg(il)
              temp3b = tt*2.*g*delt*tracb(il, lev, nf)/temp3
              temp3b0 = -(poso4row(il)*frac(n)*temp3b/temp3)
              poso4rowb(il) = poso4rowb(il) + frac(n)*temp3b
              fracb(n) = fracb(n) + poso4row(il)*temp3b
              dshjb(il, ilev) = dshjb(il, ilev) + pressg(il)*temp3b0
              pressgb(il) = pressgb(il) + dshj(il, ilev)*temp3b0
            END IF
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              temp2 = dshj(il, l-1)*pressg(il)
              temp2b = tt*2.*g*delt*tracb(il, l, nf)/temp2
              temp2b0 = -(poso4row(il)*frac(n)*temp2b/temp2)
              poso4rowb(il) = poso4rowb(il) + frac(n)*temp2b
              fracb(n) = fracb(n) + poso4row(il)*temp2b
              dshjb(il, l-1) = dshjb(il, l-1) + pressg(il)*temp2b0
              pressgb(il) = pressgb(il) + dshj(il, l-1)*temp2b0
            END IF
          ENDDO
        ENDDO
        DO l=2,ilev,1
          DO il=il2,il1,-1
            CALL POPCONTROL1B(branch)
            IF (branch .NE. 0) THEN
              temp1 = dshj(il, ilev)*pressg(il)
              temp1b = tt*2.*g*delt*tracb(il, lev, nf)/temp1
              temp1b0 = -(pso4row(il)*frac(n)*temp1b/temp1)
              pso4rowb(il) = pso4rowb(il) + frac(n)*temp1b
              fracb(n) = fracb(n) + pso4row(il)*temp1b
              dshjb(il, ilev) = dshjb(il, ilev) + pressg(il)*temp1b0
              pressgb(il) = pressgb(il) + dshj(il, ilev)*temp1b0
            END IF
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              temp0 = dshj(il, l-1)*pressg(il)
              temp0b = tt*2.*g*delt*tracb(il, l, nf)/temp0
              temp0b0 = -(pso4row(il)*frac(n)*temp0b/temp0)
              pso4rowb(il) = pso4rowb(il) + frac(n)*temp0b
              fracb(n) = fracb(n) + pso4row(il)*temp0b
              dshjb(il, l-1) = dshjb(il, l-1) + pressg(il)*temp0b0
              pressgb(il) = pressgb(il) + dshj(il, l-1)*temp0b0
            END IF
          ENDDO
        ENDDO
        DO il=il2,il1,-1
          pso4rowb(il) = pso4rowb(il) + tt*frac(n)*rsfrowb(il, nf)
          fracb(n) = fracb(n) + tt*pso4row(il)*rsfrowb(il, nf)
          temp = dshj(il, ilev)*pressg(il)
          tempb0 = g*2.*delt*tracb(il, ilev+1, nf)/temp
          tempb1 = -(rsfrow(il, nf)*tempb0/temp)
          rsfrowb(il, nf) = rsfrowb(il, nf) + tempb0
          dshjb(il, ilev) = dshjb(il, ilev) + pressg(il)*tempb1
          pressgb(il) = pressgb(il) + dshj(il, ilev)*tempb1
          CALL POPreal8(rsfrow(il, nf))
          aso4rowb(il) = aso4rowb(il) + tt*frac(n)*rsfrowb(il, nf)
          fracb(n) = fracb(n) + tt*aso4row(il)*rsfrowb(il, nf)
          rsfrowb(il, nf) = 0.0
        ENDDO
        CALL POPINTEGER4(nf)
      ENDDO
      totvb = 0.0
      DO n=isize,1,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) fracb(n) = 0.0
        CALL POPreal8(frac(n))
        totvb = totvb - frac(n)*fracb(n)/totv**2
        fracb(n) = fracb(n)/totv
      ENDDO
      DO n=isize,1,-1
        fracb(n) = fracb(n) + totvb
        asigma = 0.17
        alogdib = -(EXP(-((alogdi-amean)**2./asigma))*2.*(alogdi-amean)*
     +    fracb(n)/asigma)
        fracb(n) = 0.0
        CALL POPreal8(amean)
        rwi = (aerosize(1, n)+aerosize(2, n))/2.0*1.e6
        CALL POPreal8(alogdi)
        rwib = alogdib/(rwi*LOG(10.0))
        tempb = 1.e6*rwib/2.0
        aerosizeb(1, n) = aerosizeb(1, n) + tempb
        aerosizeb(2, n) = aerosizeb(2, n) + tempb
      ENDDO
      gb = 0.0
      deltb = 0.0
      END
