      SUBROUTINE SFSF (TRAC,   DSHJ,    ILG,    LEV,    ILEV,   MAE,
     1                  NTR,     NN,  ISIZE,AEROSIZE, VOLCROW,
     2            ASO4ROW,PSO4ROW,POSO4ROW,ASO2ROW,PSO2ROW,POSO2ROW,
     +             PRESSG,ROAROW,
     3              DMSOROW,DMSLROW, H2SROW,   FRAC,  RSFROW,   RGD,
     4               SURFWD,  ZHLEV,  FLAND,    IL1,     IL2,  IAE1,
     5                   GT,   IH2S,   IDMS,   ISO2,     LUC)
C------------------------------------------------------------------------------
C
C     HISTORY:
C     * JAN 02/2008 - C.H. Zhou   ADDING CAWAS EMSSION INTO SFSF, REPLACE
C     *                           SO2 AND SO4 , AND KEEP DMS AND H2S
c     *
C     * JAN 30/1998 - S.L. GONG   ADDING DMS OCEAN SURFACE CONCENTRATION
C     *                           AND FLUX FORMULATION. REPLACING PREVIOUS
C     *                           FLUX INPUT FILE
C     *
C     * MAY 26/1997 - S.L. GONG   FIRST IMPLEMENTED
C     *                           OPTIMIZED BY VECTORIZATION
C
C     ----------
C     SUBROUTINE CALLED FROM SFFLUX
C
C------------------------------------------------------------------------------

      COMMON /PARAMS/ WW,TW,RAYON,ASQ,G,RGAS,RGOCP,RGOASQ,CPRES         !          SF
      COMMON /PARAMS/ RGASV,CPRESV                                      !          SF
      COMMON /TIMES/ DELT,IFDIFF,KSTART,KTOTAL,NEWRUN,                  !          SF
     1                NDAYS,NSECS,IDAY,LDAY,MDAY,INCD                   !          SF
      REAL TRAC   (ILG,LEV,NTR), DSHJ(ILG,ILEV), GT(ILG)
      REAL PRESSG(ILG),ZHLEV(ILG,ILEV),SURFWD(ILG)
      REAL RSFROW(ILG,NTR), AEROSIZE (2,ISIZE)
      REAL ASO4ROW(ILG),PSO4ROW(ILG),ASO2ROW(ILG),PSO2ROW(ILG)
      REAl POSO4ROW(ILG),POSO2ROW(ILG)
      REAL DMSOROW(ILG),DMSLROW(ILG),H2SROW(ILG), VOLCROW(ILG,2)
      REAL RGD (ILG,ILEV,NTR), ROAROW(ILG,ILEV)
      REAL FRAC(ISIZE), FLAND(ILG,LUC)
      DATA HEIGHT/5.0/
      DATA HEIGHTP/120.0/
C
C     * SURFACE FLUX - UNIT KG M-2 S-1
C       FACTOR TT CONVERTS EMISSION UNIT FROM MT M-2 SEASON-1
C       TO KG M-2 S-1
C
      TT=1.0e-3
      TT1=1.0e-3*64
C
C     * SIZE DISTRIBUTION OF PRIMARY SULPHATE AEROSOLS
C       r=0.125 um, std dev=1.7
C
      TOTV=0.0
      DO N=1,ISIZE
          RWI = (AEROSIZE(1,N)+AEROSIZE(2,N))/2.0*1.E6
          ALOGDI = LOG10(2.*RWI)
C         MMD 0.25 um
          AMEAN = LOG10(0.25)
          ASIGMA = 0.17
          FRAC(N) = EXP (-(ALOGDI - AMEAN)**2./ASIGMA)               
          TOTV=TOTV+FRAC(N)
      END DO
      DO N=1,ISIZE
          FRAC(N)=FRAC(N)/TOTV
          IF (FRAC(N) .LT. 1.E-9)  FRAC(N)=0.0
      END DO
c        print *, 'FRAC=', FRAC

C
C     * FOR PRIMARY SULPHATE AEROSOLS
C
      DO N=1, ISIZE
         NF=ISIZE*(NN-1)+N+(IAE1-1)
         DO IL=IL1,IL2
            RSFROW(IL,NF) = ASO4ROW(IL)*FRAC(N)*TT
            TRAC(IL,ILEV+1,NF) = TRAC(IL,ILEV+1,NF) + RSFROW(IL,NF)
     1                      /(DSHJ(IL,ILEV)*PRESSG(IL)/G)*2.*DELT
            RSFROW(IL,NF) = RSFROW(IL,NF)+PSO4ROW(IL)*FRAC(N)*TT
         END DO
C
C      * HIGHER POINT SOURCES
C
         DO L=ILEV,2,-1
           DO IL=IL1,IL2
             IF(HEIGHT.GT.ZHLEV(IL,L).AND.HEIGHT.LE.ZHLEV(IL,L-1))THEN
                TRAC(IL,L,NF)=TRAC(IL,L,NF)+PSO4ROW(IL)*FRAC(N)*TT
     2                        /(DSHJ(IL,L-1)*PRESSG(IL)/G)*2.*DELT
             END IF
             IF(HEIGHT.GT.0.0.AND.HEIGHT.LE.ZHLEV(IL,ILEV))THEN
                TRAC(IL,LEV,NF)=TRAC(IL,LEV,NF)+PSO4ROW(IL)*FRAC(N)*TT
     2                        /(DSHJ(IL,ILEV)*PRESSG(IL)/G)*2.*DELT
             END IF
           END DO
         END DO
C
C      * POWER POINT SOURCES
C
         DO L=ILEV,2,-1
           DO IL=IL1,IL2
             IF(HEIGHTP.GT.ZHLEV(IL,L).AND.HEIGHTP.LE.ZHLEV(IL,L-1))THEN
                TRAC(IL,L,NF)=TRAC(IL,L,NF)+POSO4ROW(IL)*FRAC(N)*TT
     2                        /(DSHJ(IL,L-1)*PRESSG(IL)/G)*2.*DELT
             END IF
             IF(HEIGHTP.GT.0.0.AND.HEIGHTP.LE.ZHLEV(IL,ILEV))THEN
                TRAC(IL,LEV,NF)=TRAC(IL,LEV,NF)+POSO4ROW(IL)*FRAC(N)*TT
     2                        /(DSHJ(IL,ILEV)*PRESSG(IL)/G)*2.*DELT
             END IF
           END DO
         END DO
      END DO
      RETURN
C
C     * FOR THE PRECUSORS DMS OF SULPHATE
C       FIRST USE WANNIKHOF MASS TRANSFER COEFFICIENT TO RELATE THE
C       DMS SURFACE FLUX WITH DMS OCEANIC CONCENTRATION
C       ZKL -- M S-1
C
c      DO IL=IL1,IL2
c         IF (FLAND (IL,14) .GT. 0.1) THEN
c            GTC=GT(IL)-273.0
c            SC=2674.0-147.12*GTC+3.726*GTC*GTC-
c     1                           0.038*GTC*GTC*GTC
c            SC=AMIN1(AMAX1(SC, 577.0), 2027.0)
c            CONV=0.01/3600.
C
C     WANNINKOF SCHEME
C
c            ZKL=0.31*SURFWD(IL)*SURFWD(IL)/SQRT(SC/660.0)*CONV
C
C     LISS AND MERLIVAT SCHEME
C
C            IF (SURFWD(IL) .LT. 3.6) THEN
C               ZKL=0.17*SURFWD(IL)*(SC/660.0)**(-2./3.)*CONV
C            END IF 
C            IF (SURFWD(IL) .GE. 3.6 .AND. SURFWD(IL) .LT. 13.) THEN
C               ZKL=(2.85*SURFWD(IL)-9.65)/SQRT(SC/660.0)*CONV
C            END IF            
C            IF (SURFWD(IL) .GE. 13.0 ) THEN
C               ZKL=(5.9*SURFWD(IL)-49.3)/SQRT(SC/660.0)*CONV
C            END IF
C
C     HENRY'S LAW CONSTANT FOR DMS
C
c            if(GT(IL).lt.100.) GT(IL)=285.
c            print *,' GT(IL)=',GT(IL), IL
c            H=EXP(-3547.0/GT(IL)+12.64)      !  [ATM L MOL-1]
c            print *, '0 H =', H
c            H=H/(0.08205*GT(IL))             !  [DIMENSIONLESS]
c            print *, '1 H =', H
c            RDMS=AMAX1(RGD(IL,ILEV,IDMS),0.0)
c            print *, 'DMS=',ZKL, DMSOROW(IL),RDMS,ROAROW(IL,ILEV),H
c            RSFROW(IL,IDMS)=ZKL*(DMSOROW(IL)*62.128E-9-
c     1                  RDMS*ROAROW(IL,ILEV)/H)
c            RSFROW(IL,IDMS)= AMAX1(RSFROW(IL,IDMS),0.0)*FLAND(IL,14)
c         END IF
c      END DO

c      DO IL=IL1,IL2
c         RSFROW(IL,IH2S)=H2SROW(IL)*TT*34.0/32.0
c         RSFROW(IL,IDMS)=RSFROW(IL,IDMS)+DMSLROW(IL)*TT*62.128/32.0
c         RSFROW(IL,ISO2)=(ASO2ROW(IL)+PSO2ROW(IL))*TT1
c         TRAC(IL,ILEV+1,IH2S)=TRAC(IL,ILEV+1,IH2S)+RSFROW(IL,IH2S)
c     1                     /(DSHJ(IL,ILEV)*PRESSG(IL)/G)*2.*DELT
c         TRAC(IL,ILEV+1,IDMS)=TRAC(IL,ILEV+1,IDMS)+RSFROW(IL,IDMS)
c     1                     /(DSHJ(IL,ILEV)*PRESSG(IL)/G)*2.*DELT
c         TRAC(IL,ILEV+1,ISO2)=TRAC(IL,ILEV+1,ISO2)+ASO2ROW(IL)*TT1
c     1                     /(DSHJ(IL,ILEV)*PRESSG(IL)/G)*2.*DELT
c      END DO
C
C      * HIGHER POINT SOURCES
C
c      DO L=ILEV,2+MAE,-1
c         DO IL=IL1,IL2
c           IF (HEIGHT.GT.ZHLEV(IL,L).AND.HEIGHT.LE.ZHLEV(IL,L-1)) THEN
c               TRAC(IL,L,ISO2)=TRAC(IL,L,ISO2)+PSO2ROW(IL)*TT1
c     1                        /(DSHJ(IL,L-1)*PRESSG(IL)/G)*2.*DELT
c           END IF
c           IF (HEIGHT.GT.0.0.AND.HEIGHT.LE.ZHLEV(IL,ILEV)) THEN
c               TRAC(IL,LEV,ISO2)=TRAC(IL,LEV,ISO2)+PSO2ROW(IL)*TT1
c     1                        /(DSHJ(IL,ILEV)*PRESSG(IL)/G)*2.*DELT
c           END IF
c         END DO
c      END DO
C
C     * POWER POINT SOURCES
c
c      DO L=ILEV,2+MAE,-1
c         DO IL=IL1,IL2
c           IF (HEIGHTP.GT.ZHLEV(IL,L).AND.HEIGHTP.LE.ZHLEV(IL,L-1)) THEN
c               TRAC(IL,L,ISO2)=TRAC(IL,L,ISO2)+POSO2ROW(IL)*TT1
c     1                        /(DSHJ(IL,L-1)*PRESSG(IL)/G)*2.*DELT
c           END IF
c           IF (HEIGHTP.GT.0.0.AND.HEIGHTP.LE.ZHLEV(IL,ILEV)) THEN
c               TRAC(IL,LEV,ISO2)=TRAC(IL,LEV,ISO2)+POSO2ROW(IL)*TT1
c     1                        /(DSHJ(IL,ILEV)*PRESSG(IL)/G)*2.*DELT
c           END IF
c         END DO
c      END DO

C
C     * VOLCANIC EMISSIONS [THIS PART OF THE CODE WAS MODIFIED FROM LOHMANN'S
C       ORIGINAL VOLCANO CODE, WITH THANKS]
C
c      JT=ISO2
c      DO L=1+MAE,ILEV
c         ZVOLCEMI=8.
c         ZVOLCEMI1=ZVOLCEMI*0.36
c         ZVOLCEMI2=ZVOLCEMI*0.36
c         ZVOLCEMI3=ZVOLCEMI*0.28
c         DO IL=IL1,IL2
c           HTV=VOLCROW(IL,2)
c           IF (HTV.GT.ZHLEV(IL,L).AND.HTV.LE.ZHLEV(IL,L-1)) THEN 
c              ZDP1 =G/(DSHJ(IL,L)*PRESSG(IL))
c              TRAC(IL,L+1,JT)=TRAC(IL,L+1,JT)+
c     1                    ZVOLCEMI1*VOLCROW(IL,1)*ZDP1 *2.*DELT
c           END IF
c         END DO
c         IF (L .EQ. ILEV) THEN
c           DO IL=IL1,IL2
C
C    VOLCANIC BACKGROUND EMISSIONS
C
C      ZVOLCEMI  TOTAL VOLCANIC EMISSION SCALED TO 8 TG/YR IN KG/M2/S
C
c            IF(VOLCROW(IL,2).GT.0.) THEN
c              ZDP13=G/(DSHJ(IL,13)*PRESSG(IL))
c              ZDP14=G/(DSHJ(IL,14)*PRESSG(IL))
c              ZDP18=G/(DSHJ(IL,25)*PRESSG(IL))
c              ZDP19=G/(DSHJ(IL,26)*PRESSG(IL))

c              RSFROW(IL,ISO2)=RSFROW(IL,ISO2)+VOLCROW(IL,1)*ZVOLCEMI
c              TRAC(IL,27,JT)=TRAC(IL,27,JT)+
c     1                0.5*ZVOLCEMI2*VOLCROW(IL,1)*ZDP19*2.*DELT
c              TRAC(IL,26,JT)=TRAC(IL,26,JT)+
c     1                0.5*ZVOLCEMI2*VOLCROW(IL,1)*ZDP18*2.*DELT
c              TRAC(IL,15,JT)=TRAC(IL,15,JT)+
c     1                0.5*ZVOLCEMI3*VOLCROW(IL,1)*ZDP14*2.*DELT
c              TRAC(IL,14,JT)=TRAC(IL,14,JT)+
c     1                0.5*ZVOLCEMI3*VOLCROW(IL,1)*ZDP13*2.*DELT
c            END IF
c           END DO
c         END IF
c      END DO

c      RETURN
      END
