      SUBROUTINE SFRD_B(trac, tracb, dshj, dshjb, ilg, lev, ilev, hi, 
     +                  hib, t, ntr, nn, ntp, isize, zhlev, aerosize, 
     +                  aerosizeb, rhop0, rsfrow, rsfrowb, pressg, 
     +                  pressgb, fx, fxb, mae, blcrow, blcrowb, pbc, 
     +                  pbcb, il1, il2, iae1)
      IMPLICIT NONE
C
      REAL g
      REAL ww
      REAL tw
      REAL rgocp
      REAL rayon
      REAL cpres
      REAL rgoasq
      REAL rgas
      REAL asq
C-----------------------------------------------------------------------
C
C     HISTORY:
C
C     * Sept 04 - C.H. ZHOU   for resuspended road dust 
C
C     METHOD:
C     -------
C
C     ARGUMENTS:
C     ----------
C     SUBROUTINE CALLED FROM SFFLUX
C
C-----------------------------------------------------------------------
C
      COMMON /params/ ww, tw, rayon, asq, g, rgas, rgocp, rgoasq, cpres
      REAL cpresv
      REAL rgasv
      COMMON /params/ rgasv, cpresv
      INTEGER nsecs
      REAL delt
      INTEGER incd
      INTEGER mday
      INTEGER newrun
      INTEGER lday
      INTEGER ifdiff
      INTEGER iday
      INTEGER ktotal
      INTEGER ndays
      INTEGER kstart
      COMMON /times/ delt, ifdiff, kstart, ktotal, newrun, ndays, nsecs
     +, iday, lday, mday, incd
      INTEGER ntr
      INTEGER lev
      INTEGER ilg
      INTEGER ilev
      REAL trac(ilg, lev, ntr), dshj(ilg, ilev), t(ilg, lev)
      REAL tracb(ilg, lev, ntr), dshjb(ilg, ilev)
      INTEGER ntp
      INTEGER isize
      REAL aerosize(2, isize), rhop0(ntp), pressg(ilg)
      REAL aerosizeb(2, isize), pressgb(ilg)
      REAL rsfrow(ilg, ntr), blcrow(ilg, 3, 2)
      REAL rsfrowb(ilg, ntr), blcrowb(ilg, 3, 2)
      REAL pbc(isize), fx(ilev, ilev), zhlev(ilg, ilev), hi(ilg)
      REAL pbcb(isize), fxb(ilev, ilev), hib(ilg)
      REAL ptot
      REAL ptotb
      REAL tt
      INTEGER n
      REAL rwi
      REAL rwib
      INTEGER l
      INTEGER l1
      INTEGER idp
      INTEGER il
      REAL hii
      INTEGER np
      INTEGER i
      REAL tl
      REAL tlb
      INTEGER arg1
      INTEGER ad_from
      INTEGER branch
      INTEGER il1
      REAL gb
      INTEGER il2
      INTEGER nn
      REAL deltb
      INTEGER iae1
      INTEGER mae
      REAL temp2
      REAL temp1
      REAL temp0
      INTRINSIC EXP
      REAL temp2b0
      INTRINSIC REAL
      REAL temp2b
      INTRINSIC LOG
      INTRINSIC INT
      REAL temp1b
      REAL temp
      REAL temp1b0
      COMMON /times_b/ deltb
      COMMON /params_b/ gb
C
C     ASSUME THE INITIAL BC IS HYDROPHOBIC AND HAS A LOG-NORMAL
C     DISTRIBUTION WITH A MEAN DIAMETER OF 0.1 UM [BERNER ET AL. 1996]
C     HERE 1.33 = (2*3.1415926)^0.5*LN 1.7
C
      ptot = 0.0
Cg/s to kg/s
      tt = 1.e-3
      DO n=1,isize
        rwi = (aerosize(1, n)+aerosize(2, n))/2.0
        pbc(n) = 1./1.33*EXP(-((LOG(rwi)-LOG(1.5e-7))**2/(2.0*LOG(1.7)**
     +    2)))
        ptot = ptot + pbc(n)
      ENDDO
C
C
C     *  INSERTION DU FLUX DE SURFACE
C
      arg1 = ilev*ilev
      CALL PUTZERO(fx, arg1)
      DO l=1+mae,ilev
        ad_from = l
        DO l1=ad_from,ilev-1
          IF (l1 .EQ. l) THEN
            fx(l1, l) = 0.5
            CALL PUSHCONTROL1B(1)
          ELSE
            fx(l1, l) = fx(l1-1, l)/2.0
            CALL PUSHCONTROL1B(0)
          END IF
        ENDDO
        CALL PUSHINTEGER4(ad_from)
        fx(ilev, l) = fx(ilev-1, l)
        IF (l .EQ. ilev) THEN
          fx(ilev, l) = 1.0
          CALL PUSHCONTROL1B(1)
        ELSE
          CALL PUSHCONTROL1B(0)
        END IF
      ENDDO
C
      DO idp=1,3
        CALL PUSHreal8ARRAY(hi, ilg)
        CALL PUTZERO(hi, ilg)
        DO l=ilev,2,-1
          DO il=il1,il2
CFossil Fuel Height
            hii = blcrow(il, idp, 2)
            IF (blcrow(il, idp, 1) .GT. 0.0 .AND. hii .GT. zhlev(il, l) 
     +          .AND. hii .LE. zhlev(il, l-1)) THEN
              hi(il) = REAL(l - 1)
            END IF
            IF (blcrow(il, idp, 1) .GT. 0.0 .AND. hii .GT. 0.0 .AND. hii
     +          .LE. zhlev(il, ilev)) THEN
              hi(il) = REAL(ilev)
            END IF
          ENDDO
        ENDDO
C
        DO l=1+mae,ilev
          DO n=1,isize
            CALL PUSHINTEGER4(np)
            np = isize*(nn-1) + n + (iae1-1)
            DO i=il1,il2
              IF (hi(i) .GT. 0. .AND. l .GE. INT(hi(i))) THEN
                CALL PUSHreal8(tl)
                tl = blcrow(i, idp, 1)*pbc(n)/ptot*fx(l, INT(hi(i)))*tt
C              xzch=TL/(DSHJ(I,L)*PRESSG(I)/G)*2.*DELT
C                print *, xzch
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHCONTROL1B(1)
              END IF
            ENDDO
          ENDDO
        ENDDO
      ENDDO
      ptotb = 0.0
      DO idp=3,1,-1
        CALL PUTZERO(hi, ilg)
        DO l=ilev,2,-1
          DO il=il1,il2
CFossil Fuel Height
            hii = blcrow(il, idp, 2)
            IF (blcrow(il, idp, 1) .GT. 0.0 .AND. hii .GT. zhlev(il, l) 
     +          .AND. hii .LE. zhlev(il, l-1)) THEN
              hi(il) = REAL(l - 1)
            END IF
            IF (blcrow(il, idp, 1) .GT. 0.0 .AND. hii .GT. 0.0 .AND. hii
     +          .LE. zhlev(il, ilev)) THEN
              hi(il) = REAL(ilev)
            END IF
          ENDDO
        ENDDO
       print*,'sfrd sum(blcrowb)=',sum(blcrowb)
        DO l=ilev,1+mae,-1
          DO n=isize,1,-1
            DO i=il2,il1,-1
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                temp2 = dshj(i, l)*pressg(i)
                temp2b = g*2.*delt*tracb(i, l+1, np)/temp2
                temp2b0 = -(tl*temp2b/temp2)
                tlb = rsfrowb(i, np) + temp2b
                dshjb(i, l) = dshjb(i, l) + pressg(i)*temp2b0
                pressgb(i) = pressgb(i) + dshj(i, l)*temp2b0
                CALL POPreal8(tl)
                temp1 = pbc(n)/ptot
                temp1b = tt*fx(l, INT(hi(i)))*tlb
                temp1b0 = blcrow(i, idp, 1)*temp1b/ptot
                blcrowb(i, idp, 1) = blcrowb(i, idp, 1) + temp1*temp1b
                pbcb(n) = pbcb(n) + temp1b0
                ptotb = ptotb - temp1*temp1b0
                fxb(l, INT(hi(i))) = fxb(l, INT(hi(i))) + tt*blcrow(i, 
     +            idp, 1)*temp1*tlb
              END IF
            ENDDO
            CALL POPINTEGER4(np)
          ENDDO
        ENDDO
        CALL POPreal8ARRAY(hi, ilg)
        CALL PUTZERO_B(hi, hib, ilg)
      ENDDO
      DO l=ilev,1+mae,-1
        CALL POPCONTROL1B(branch)
        IF (branch .NE. 0) fxb(ilev, l) = 0.0
        fxb(ilev-1, l) = fxb(ilev-1, l) + fxb(ilev, l)
        fxb(ilev, l) = 0.0
        CALL POPINTEGER4(ad_from)
        DO l1=ilev-1,ad_from,-1
          CALL POPCONTROL1B(branch)
          IF (branch .EQ. 0) THEN
            fxb(l1-1, l) = fxb(l1-1, l) + fxb(l1, l)/2.0
            fxb(l1, l) = 0.0
          ELSE
            fxb(l1, l) = 0.0
          END IF
        ENDDO
      ENDDO
      CALL PUTZERO_B(fx, fxb, arg1)
      DO n=isize,1,-1
        pbcb(n) = pbcb(n) + ptotb
        rwi = (aerosize(1, n)+aerosize(2, n))/2.0
        temp0 = 2.0*LOG(1.7)**2
        temp = LOG(rwi) - LOG(1.5e-7)
        rwib = -(2*temp*EXP(-(temp**2/temp0))*pbcb(n)/(temp0*1.33*rwi))
        pbcb(n) = 0.0
        aerosizeb(1, n) = aerosizeb(1, n) + rwib/2.0
        aerosizeb(2, n) = aerosizeb(2, n) + rwib/2.0
      ENDDO
      gb = 0.0
      deltb = 0.0
      END
