      SUBROUTINE SFOC (TRAC,  DSHJ,   ILG,   LEV,  ILEV,  HI,
     1                    T,   NTR,    NN,   NTP, ISIZE,ZHLEV,
     2             AEROSIZE,RSFROW,PRESSG,    FX,   MAE,
     3               OMCROW,   PBC,   IL1,   IL2,  IAE1)
C-----------------------------------------------------------------------
C
C     HISTORY:
C
C     * MAR 11/199  - D. LAVOUE   DISTRIBUTE ORGANIC CARBON OF 5 TYPES
C     *               S.L. GONG   OVER THE INJECTION HEIGHT.
C     *                           ACCORDING TO:
C     *                                -----------------
C     *                                                   50.0%
C     *                                -----------------
C     *                                                   25.0%
C     *                                -----------------
C     *                                                   12.5%
C     *                                -----------------
C     *                                                   6.25%
C     *                                -----------------
C     *                                                    :
C     *                                -----------------
C     *
C
C     ARGUMENTS:
C     ----------
C     SUBROUTINE CALLED FROM SFFLUX
C
C-----------------------------------------------------------------------
      real delt 
      integer IFDIFF,KSTART,KTOTAL,NEWRUN,
     1                NDAYS,NSECS,IDAY,LDAY,MDAY,INCD
      COMMON /PARAMS/ WW,TW,RAYON,ASQ,G,RGAS,RGOCP,RGOASQ,CPRES         
      COMMON /PARAMS/ RGASV,CPRESV                                      
      COMMON  /TIMES/ DELT,IFDIFF,KSTART,KTOTAL,NEWRUN,                 
     1                NDAYS,NSECS,IDAY,LDAY,MDAY,INCD                   
      REAL TRAC   (ILG,LEV,NTR), DSHJ(ILG,ILEV), T(ILG,LEV)             
      REAL AEROSIZE(2,ISIZE),PRESSG(ILG)
      REAL RSFROW(ILG,NTR), OMCROW(ILG,3,2)
      REAL PBC(ISIZE), FX(ILEV,ILEV), ZHLEV(ILG,ILEV), HI(ILG)
C
C     ASSUME THE INITIAL BC IS HYDROPHOBIC AND HAS A LOG-NORMAL
C     DISTRIBUTION WITH A MEAN DIAMETER OF 0.1 UM [BERNER ET AL. 1996]
C     HERE 1.33 = (2*3.1415926)^0.5*LN 1.7
C
      PTOT=0.0
      TT=1.E-3   !k/s to kg/s
      DO N=1, ISIZE
         RWI = (AEROSIZE(1,N)+AEROSIZE(2,N))/2.0
         PBC(N) = 1./1.33 *EXP (-(LOG(RWI)-LOG(5.0E-8))**2/
     1                          (2.0*(LOG(1.7))**2))
         PTOT=PTOT+PBC(N)
      END DO

C
C     *  INSERTION DU FLUX DE SURFACE
C
      CALL PUTZERO (FX, ILEV*ILEV)
      DO L=1+MAE,ILEV
         DO L1=L,ILEV-1
            IF( L1 .EQ. L) THEN
               FX(L1,L)=0.5
            ELSE
               FX(L1,L)=FX(L1-1,L)/2.0
            END IF
         END DO
         FX(ILEV,L)=FX(ILEV-1,L)
         IF(L.EQ.ILEV) FX(ILEV,L)=1.0
      END DO

      DO 900 IDP=1,3
         CALL PUTZERO(HI,ILG)
         DO L=ILEV,2,-1
           DO IL=IL1,IL2
             IF (OMCROW(IL,IDP,1) .GT. 0.0 .AND. 
     1           OMCROW(IL,IDP,2).GT.ZHLEV(IL,L) .AND. 
     2           OMCROW(IL,IDP,2).LE.ZHLEV(IL,L-1))    THEN
               HI(IL)=REAL(L-1)
             END IF
             IF (OMCROW(IL,IDP,1) .GT. 0.0 .AND. 
     1           OMCROW(IL,IDP,2).GT.0.0 .AND. 
     2           OMCROW(IL,IDP,2).LE.ZHLEV(IL,ILEV))    THEN
               HI(IL)=REAL(ILEV)
             END IF
           END DO
         END DO

         DO L=1+MAE,ILEV
         DO 842 N = 1,ISIZE
            NP=ISIZE*(NN-1)+N+(IAE1-1)
!            print *, NP, ISIZE, NN,IAE1, 'in sfoc'
            DO 842 I=IL1,IL2
               IF (HI(I) .GT. 0. .AND. L .GE. INT(HI(I))) THEN      
                 TL=OMCROW(I,IDP,1)*PBC(N)/PTOT*FX(L,INT(HI(I)))*TT
                 RSFROW(I,NP)=RSFROW(I,NP)+TL
!         if(RSFROW(I,NP).gt.0.) 
!     +      print *, RSFROW(I,NP),I,NP,'SFOC'
c  add the vertical diffusion into MRF in MM5
                 TRAC(I,L+1,NP) = TRAC(I,L+1,NP) + TL
     1                            /(DSHJ(I,L)*PRESSG(I)/G)*2.*DELT        
               END IF
  842    CONTINUE  
         END DO
  900 CONTINUE                                                        
      RETURN                                                          

      END
