      SUBROUTINE SFFLUX (TRAC,  FLAND,  DSHJ,    IL1,    IL2,  ILG, LEV,
     1                   ILEV,    NTR, ICOMP,SUBNAME, T,FINTROW,VOLCROW,
     2       ASO4ROW,PSO4ROW,POSO4ROW,BLCROW,DMSOROW,DMSLROW,H2SROW, GT,
     3       ASO2ROW,PSO2ROW, POSO2ROW,ISIZE,  RHOP0,  ZHLEV, PXNEW,RGD,
     4               AEROSIZE, SURFWD,RSFROW, PRESSG,   ICAM,   ROA, GC,
     5                   IAE1,   IH2S,  IDMS,   ISO2,   ISO4, IREST,LUC,
     6                   I_SS, OMCROW,SAND2ROW,CLAY2ROW,FSNOW,SREL,NATS,
     7                 NSOIL,   MODE,   MAE,   NS,  Z0, SOILW,SS,SURFDG,
     8                 SAND6ROW, TBAR,ANO3ROW,PNO3ROW,PONO3ROW,
     +                  RRDROW)
cz1     8                SAND6ROW, TBAR,   RAINFALL)
!------------------------------------------------------------------------------
!     PURPOSE:
!     --------
!     CALCULATE SURFACE FLUXES FOR AEROSOLS
!
!     HISTORY:
!     --------
!
!     * DEC. 22/2000 S.L. GONG   SOIL DUST EMISSION SCHEME IS ADDED
!     *                          GLOBAL 1x 1?SOIL TEXTURE DATA WAS
!     *                          USED FROM GCM12.
!     * MAR. 13/99 - S.L. GONG   GLOBAL OM SURFACE EMISSION [1x 1]

!
!     * FEB. 17/98 - S.L. GONG   GLOBAL BLACK CARBON SURFACE EMISSION [1x 1]
!     *                          WAS ADDED.
!     * JAN. 20/98 - S.L. GONG   GLOBAL DMS OCEAN CONCENTRATION DATA IS ADDED
!     *                          THE FLUX IS CALCULATED BY MASS TRANSFER
!     *                          EQUATION
!     * DEC. 20/96 - S.L. GONG   VECTORIZED THE FLUX CALCULATION FOR SEA-SALT
!     *                          AEROSOLS
!     * NOV. 21/94 - S.L. GONG   AEROSOL SURFACE FLUX COMPUTATION
!     *                          FOR SEA-SALT
!     *
!
!------------------------------------------------------------------------------

      REAL T (ILG,LEV)       ,ZHLEV(ILG,ILEV), GT(ILG), GC(ILG)
      REAL FLAND(ILG,LUC), TRAC   (ILG,LEV,NTR), DSHJ   (ILG,ILEV)
      REAL ASO4ROW(ILG),PSO4ROW(ILG),BLCROW(ILG,3,2),RRDROW(ILG,3,2),
     +       OMCROW(ILG,3,2)
      REAL ASO2ROW(ILG),PSO2ROW(ILG), VOLCROW(ILG,2)
      REAL POSO4ROW(ILG),POSO2ROW(ILG)
      REAL ANO3ROW(ILG),PNO3ROW(ILG),PONO3ROW(ILG)
      REAL RGD(ILG,ILEV,NTR), ROA(ILG,ILEV), FINTROW(ILG,ISIZE,3)
      REAL DMSOROW(ILG),DMSLROW(ILG),H2SROW(ILG)
      REAL AEROSIZE(2,ISIZE),SURFWD(ILG),RHOP0(ICOMP)
      REAL RSFROW(ILG,NTR),PRESSG(ILG), PXNEW(ILG,ILEV,NTR)
      REAL SAND2ROW(ILG,NATS),CLAY2ROW(ILG,2),SREL(ILG,NSOIL,NATS)
      REAL Z0(LUC,NS), SS(ILG,NSOIL),SURFDG(ILG),SOILW(ILG)
      REAL FSNOW(ILG),SAND6ROW(ILG,6), TBAR(ILG)
      CHARACTER*8 SUBNAME(ICOMP)
      REAL RAINFALL(ILG)

C
C     * ZERO SURFACE FIELDS OF CAM COMPONENTS
C     
c      print*,'il1=',il1,'il2=',il2
      DO N = IAE1, ICAM
        DO I = IL1, IL2
          RSFROW(I,N) = 0.0
        END DO
      END DO
C
C     * SURFACE FLUX CALCULATION
C
      DO NN=1,ICOMP
C
C      * SULPHATE AEROSOLS
C-------------------------
          IF (SUBNAME(NN) .EQ. 'SULPHATE') THEN
               CALL SFSF (TRAC,   DSHJ,     ILG,    LEV,    ILEV,  MAE,
     1                     NTR,      NN,  ISIZE,AEROSIZE,VOLCROW,
     2   ASO4ROW,PSO4ROW,POSO4ROW, ASO2ROW,PSO2ROW,POSO2ROW,PRESSG,ROA,
     3                 DMSOROW,DMSLROW,  H2SROW,  PXNEW,  RSFROW,  RGD,
     4                  SURFWD,  ZHLEV,   FLAND,    IL1,     IL2, IAE1,
     5                      GT,   IH2S,    IDMS,   ISO2,  LUC)
          END IF

          IF (SUBNAME(NN) .EQ. 'NITRATES') THEN

               CALL SFNT (TRAC,   DSHJ,    ILG,    LEV,    ILEV,   MAE,
     1                  NTR,     NN,  ISIZE,AEROSIZE, 
     2            ANO3ROW,PNO3ROW,PONO3ROW,
     +             PRESSG,ROA,
     3              PXNEW,  RSFROW,   RGD,
     4                ZHLEV,    IL1,     IL2,  IAE1)
         END IF
c      print*,'1111111',subname(NN)
C
C      * SEA-SALT AEROSOLS
C-------------------------
          IF (SUBNAME(NN) .EQ. 'SEA-SALT') THEN
               CALL SFSS (TRAC,  DSHJ,  ILG,    LEV,  ILEV,
     1            PXNEW(1,1,1), PXNEW(1,1,2),PXNEW(1,1,3),PXNEW(1,1,4),
     2    PXNEW(1,1,5),  I_SS,  T,   NTR,   NN,  ICOMP, ISIZE, LUC,
     3                AEROSIZE,SURFWD,RHOP0, RSFROW,PRESSG,   GC,
     4                   FLAND,FINTROW, IL1,  IL2,    IAE1,IREST)
          END IF
C
C      * BLACK-CARBON AEROSOLS
C-------------------------
          IF (SUBNAME(NN) .EQ. 'BLCARBON') THEN
               CALL SFBC (TRAC,  DSHJ, ILG,  LEV,  ILEV,PXNEW(1,1,2),
     1                       T,   NTR,     NN,  ICOMP, ISIZE,ZHLEV,
     2                AEROSIZE,RHOP0,RSFROW,PRESSG,PXNEW(1,1,3),MAE,
     3                  BLCROW, PXNEW(1,1,1), IL1,    IL2,  IAE1)
          END IF
C
C      * ORGANIC-CARBON AEROSOLS
C-------------------------
          IF (SUBNAME(NN) .EQ. 'OMCARBON') THEN
               CALL SFOC (TRAC,  DSHJ, ILG,  LEV,  ILEV,PXNEW(1,1,2),
     1                       T,   NTR,     NN,  ICOMP, ISIZE,ZHLEV,
     2                AEROSIZE,RSFROW, PRESSG,PXNEW(1,1,3), MAE,
     3                  OMCROW, PXNEW(1,1,1), IL1,    IL2,  IAE1)
          END IF

C
C     * SOLID DUSTS AEROSOLS
C--------------------------
C    
          IF (SUBNAME(NN) .EQ. 'SOILDUST') THEN
c           print*,'test00'
c               CALL SFSD (TRAC,  DSHJ,   ILG,   LEV,  ILEV,
c     1                  SURFDG,   NTR,    NN, ICOMP, ISIZE,
c     2                AEROSIZE, RHOP0,RSFROW,PRESSG, FLAND,
c     3                  SURFWD,   ROA,   IL1,   IL2,  IAE1,
c     4         PXNEW(1,1,1),PXNEW(1,1,2),  SREL,PXNEW(1,1,3),
c     5     SAND2ROW,CLAY2ROW,SOILW,PXNEW(1,1,4),PXNEW(1,1,5),
c     6         PXNEW(1,1,7),PXNEW(1,1,8),
c     5                  NS,  Z0,   LUC, PXNEW(1,1,6),  NATS,
c     7         NSOIL, MODE,PXNEW(1,1,9),SS, PXNEW(1,1,10),
c     8     FSNOW,PXNEW(1,1,11),PXNEW(1,1,12),PXNEW(1,1,13),
c     9     SAND6ROW, TBAR)
c    , RAINFALL)
c          print*,'test01'

               CALL SFRD (TRAC,  DSHJ, ILG,  LEV,  ILEV,PXNEW(1,1,2),
     1                       T,   NTR,     NN,  ICOMP, ISIZE,ZHLEV,
     2                AEROSIZE,RHOP0,RSFROW,PRESSG,PXNEW(1,1,3),MAE,
     3                  RRDROW, PXNEW(1,1,1), IL1,    IL2,  IAE1)
          END IF

      END DO
      RETURN
      END
