      SUBROUTINE SCAVENG (THROW,    CLDCV,   XROW,      MAE,
     1                      LEV,     ILEV,    ILG,      IL1,      IL2,
     2                        SHJ, PRESSG,    PDEPV,  RCOEX,    RCRIT,
     3                   RADCLD,       QR,   RTBCLD,   RTICLD,
     4                    PXNEW,   RHSIZE,   RHOP,     QROW,
     5                     DSHJ,     IAE1,  PDIFF,     TMIN,     ISO2,
     5                      NTR,      NTP,  ISIZE,    THLEV,     ADT2,
     6                    GDREM,   ROAROW,  COLEF,   WETDEP,    tcld3)
C-----------------------------------------------------------------------
C
C     HISTORY:
C     --------
C     * DEC 20/1998 - S.L. GONG   SEPARATE FROM INCLOUD PROCESSES
C     *                           TO DEAL THE BELOW-CLOUD SCAVENGING
C     *                           NAME CHANGED FROM WETREM TO SCAVENG.
C     *
C     * JAN 19/1996 - S.L. GONG   VECTORIZED THE WHOLE PROGRAM AND ADD
C     *                           WORKING SPACES.
C     *
C     * JUM  5/1994 - S.L. GONG   FIRST VERSION [WETREM]
C     *
C
C     METHOD:
C     -------
C
C     VARIABLES:
C     ----------
C
C-----------------------------------------------------------------------
      IMPLICIT NONE

      REAL WW,TW,RAYON,ASQ,G,RGAS,RGOCP,RGOASQ,CPRES
      REAL RGASV,CPRESV,DELT,TMIN,ZCONS1,ZCOLLEFF,PCONS2,VTMPC1
      REAL ZZEFF,AFACT,ZFTOM,ZRHO0,ZBCSCAV,ADT2,OLDSO2
      INTEGER ILG,ILEV,NTR,LEV,ISIZE,L,MAE,I,IL1,IL2,NT,NTP,N,NP
      INTEGER IAE1,JK,IL,ISO2
      COMMON /PARAMS/ WW,TW,RAYON,ASQ,G,RGAS,RGOCP,RGOASQ,CPRES
      COMMON /PARAMS/ RGASV,CPRESV
      COMMON /TIMES/DElt

      REAL PXNEW(ILG,ILEV,NTR), XROW(ILG,LEV,NTR)
      REAL PDEPV(ILG,ILEV,ISIZE), THLEV(ILG,ILEV), GDREM(ILG,NTR,3)
      REAL THROW(ILG,LEV), PDIFF(ILG,ILEV,ISIZE)
      REAL CLDCV(ILG,ILEV,2)
      REAL PRESSG(ILG), SHJ(ILG,ILEV), DSHJ(ILG,ILEV)
      REAL ROAROW(ILG,ILEV), QROW(ILG,LEV)
      REAL COLEF(ILG,ILEV,ISIZE),WETDEP(ILG,ILEV,ISIZE)
      REAL RCRIT(ILG,ILEV), RCOEX(ILG,ILEV)
      REAL RADCLD(ILG,ILEV),QR(ILG,ILEV,2)
      REAL RTBCLD(ILG,ILEV,NTR),RTICLD(ILG,ILEV,NTR)

      REAL RHSIZE(ILG,ILEV,ISIZE),RHOP(ILG,ILEV,ISIZE)
      REAL tcld3(ILG,ILEV)

C
C . . . . SUM UP PRECIPITATION [STRATIFORM ONLY]
C
      CALL PUTZERO (PXNEW, ILG*ILEV*NTR)
      DO L=1+MAE,ILEV
         DO I=IL1,IL2
          PXNEW(I,L,1) = AMAX1(QR(I,L,1)+QR(I,L,2),0.0)
czch          PXNEW(I,L,1) = AMAX1(QR(I,L,1),0.0)
         END DO
      END DO
C
C     * BELOW-CLOUD REMOVAL OF PARTICLES
C
      CALL PUTZERO (COLEF,ILG*ILEV*ISIZE)
      CALL BLCLD ( THROW,  PXNEW,   RHSIZE,     COLEF,  RCOEX, RCRIT,
     +             PDEPV,  PRESSG,     SHJ,    ROAROW, WETDEP, PDIFF,
     1              XROW,  RTBCLD,    RHOP,    RADCLD,  CLDCV,   MAE,
     2               NTR,     NTP,   ISIZE,       LEV,   IAE1,  TMIN,
     3              ILEV,     ILG,     IL1,       IL2,   ADT2, tcld3)
C
C      ADD GROUND REMOVAL
C
      DO NT=1,NTP
        DO N=1,ISIZE
          NP=ISIZE*(NT-1)+N+(IAE1-1)
          DO L=1+MAE,ILEV
            DO I=IL1,IL2
c             print*,'scaveng',xrow(i,l+1,np),i,l,np
               IF (XROW(I,L+1,NP) .GT. TMIN) THEN
                  GDREM(I,NP,2)=GDREM(I,NP,2)+ RTBCLD(I,L,NP)*  
     1                               DSHJ(I,L)*PRESSG(I)/G
               END IF
            END DO
          END DO
        END DO
      END DO
C
C     BELOW-CLOUD SCAVENGING OF SO2
C     THIS PROTION OF THE CODE WAS ADAPTED
C     FROM THE GCM ROUTINE WETDEP.
C
      ZCONS1=5.2
      ZCOLLEFF=0.1
      PCONS2=1./(2.*DELT*G)
      VTMPC1=RGASV/RGAS-1.
      ZZEFF=ZCOLLEFF*3.
      AFACT=1./(2.*DELT*0.001)        !CONVERT QR FROM M TO KG/KG/S

      DO 120 JK=1+MAE,ILEV
        DO 100 IL=IL1,IL2
          ZFTOM=1./(DSHJ(IL,JK)*PRESSG(IL)*PCONS2)
          ZRHO0=PRESSG(IL)*SHJ(IL,JK)/(RGAS*THROW(IL,JK+1)
     1             *(1.+VTMPC1*QROW(IL,JK+1)))
          ZBCSCAV=ZCONS1*ZZEFF*QR(IL,JK,1)*ZFTOM*ZRHO0*AFACT
          ZBCSCAV=MIN(1.,ZBCSCAV)
          ZBCSCAV=MAX(0.,ZBCSCAV)
          OLDSO2=XROW(IL,JK+1,ISO2)
          XROW(IL,JK+1,ISO2)=XROW(IL,JK+1,ISO2)*(1.-ZBCSCAV)
          RTBCLD(IL,JK,ISO2) = RTBCLD(IL,JK,ISO2)+(XROW(IL,JK+1,ISO2)-
     1                                         OLDSO2)/ADT2
          GDREM(IL,ISO2,2)=GDREM(IL,ISO2,2)+ RTBCLD(IL,JK,ISO2)*  
     1                               DSHJ(IL,JK)*PRESSG(IL)/G

 100    CONTINUE
 120  CONTINUE
      RETURN
      END
