      SUBROUTINE DRYDEPO(ILEV,      LEV,      ILG,      IL1,     IL2,
     1                    VDG,   SURFWD,    GTROW,  SFCTROW,     MAE,
     2                 FSGROL,   DEGLAT,    SEASN,       RA,     USI,
     3                SICNROW,  FSNOROW,    THROW,    ISIZE,     NTP,
     4                    NTR,     ADT2,   PRESSG,     SHJ,     TMIN,
     5                  THLEV,   ROAROW,     RHOP,   RHSIZE,    ISO2,
     6                   IDMS,    FLAND,     XROW,   SURFDG,   PDEPV,
     7                  RTDRY,    PXNEW,     DSHJ,    GDREM,    IAE1,
     8                  CLDCV,    RHROW,     IDAY,     JLAT,   PDIFF,
     9                    LUC,      CAM,       NG,       NS,      ML,
     3                   PLLP,       Z0,      SCC,    RCW, AC, CSPEC,
     4                    LAI,      RM0,      ZPD,     FCAP, WP, RGW,
     5                   AEST,    GAMMA)
C-----------------------------------------------------------------------
C     HISTORY:
C     --------
C     * AUG 01/1999 - S.L. GONG   PASS ALL CONTROL VARIABLES FOR 15
C                               LAND-USE FROM THE CONTROL FILE.
C
C     * JUN 29/1999 - S.L. GONG   INTRODUCED CAM SWITCH TO BE USED FOR:
C     *                             CAM < 10.0 - FOR RCM OR GCM
C     *                             CAM > 10.0 - FOR AURAMS
C     *
C     * JAN 15/1998 - L.M. ZHANG  REFINED PARAMETERIZATION FOR PARTICLES
C     *                           COMPARED WITH EMPIRICAL MODEL RESUTLS.
C     *
C     * JAN 02/1998 - L.M. ZHANG  ADD ADOM GAS DRY DEPOSITION
C     *               S.L.  GONG  COMBINE BOTH PARTICLE AND GAS
C     *                           DRYDEPOSITION INTO A UNIFIED INTEREFACE.
C     *
C     * DEC 19/1996 - S.L. GONG   VECTORIZED THE WHOLE PROGRAM AND ADD
C     *                           WORKING SPACES.
C     *                           FVEG, CD012, CVOCDL, AEXP
C     *
C     * AUG  4/1994 - S.L. GONG   FIRST VERSION
C     *
C
C     METHOD
C     ---------                 
C     - PARAMETERIZATION OF DRY DEPOSITION SCHEME BY FILIPPO GIORGI
C       [JGR, 91(D9), 1986] WAS USED.
C     - TWO LAYER MODEL.
C
C----------------------------------------------------------------------
      COMMON /PARAMS/ WW,TW,RAYON,ASQ,G,RGAS,RGOCP,RGOASQ,CPRES
      COMMON /PARAMS/ RGASV,CPRESV

      REAL DEGLAT(ILG), VDG(ILG,NG)
      REAL THLEV(ILG, ILEV), GDREM(ILG, NTR, 3)
      REAL THROW(ILG,LEV),RHROW(ILG,LEV),SHJ(ILG,ILEV)
      REAL FSNOROW(ILG), CLDCV(ILG,ILEV,2)

      REAL SURFDG(ILG),SURFWD(ILG),FLAND(ILG,LUC)
      REAL RHSIZE(ILG,ILEV,ISIZE),PDEPV(ILG,ILEV,ISIZE)
      REAL RHOP(ILG,ILEV,ISIZE),PDIFF(ILG,ILEV,ISIZE)
      REAL RTDRY(ILG,ILEV,NTR)

      REAL PRESSG(ILG), DSHJ(ILG,ILEV), XROW(ILG,LEV,NTR)

      REAL PXNEW(ILG,ILEV,NTR)
      REAL ROAROW(ILG,ILEV), GTROW(ILG) , SFCTROW(ILG)
      REAL FSGROL(ILG), SICNROW(ILG)

      REAL SEASN(ILG),RA(ILG,LUC),USI(ILG,LUC)
      REAL PLLP(LUC,NS),Z0(LUC,NS),SCC(NG), RCW(NG), AC(NG)
      REAL LAI(LUC,NS),RM0(NG), ZPD(LUC,NS) 
      REAL FCAP(ML),WP(ML),RGW(NG)
      REAL AEST(LUC), GAMMA(LUC)
      CHARACTER*4 CSPEC(NG)

      CALL PUTZERO (RTDRY,ILG*ILEV*NTR)
C
C     CALL TO VECTORIZED ADOM DRY GAS DEPOSITION SCHEME
C     NG0=1 for SO2 IN CAM ONLY. FOR ALL 12 SPECIES, NG0=NG
C
      IF (CAM .LT. 10.0) THEN 
         NG0=1
      ELSE
         NG0=NG
      END IF

      STDHi=10.0
      CALL DRYGAS (ILG,   FLAND,    VDG,  SURFWD, STDHi, ILEV,
     1           GTROW, SFCTROW,  FSGROL,PXNEW(1,1,1), LUC, 
     2          DEGLAT, SEASN,RHROW(1,LEV),CLDCV,PXNEW(1,1,2),
     3            IDAY,     IL1,    IL2, SICNROW,    FSNOROW,
     4              RA,     USI,   JLAT,     NG,    NS,   NG0,
     3              Z0,      SCC,    RCW,    AC, 
     4              LAI,      RM0,      ZPD,   RGW)
C
C     * NH3 DRY DEPOSITION TENDENCY
C

c      DO I = IL1, IL2
c       QCC=-ABS(VDG(I,12))/THLEV(I,ILEV)*ADT2
c       RTDRY(I,ILEV,cncaNH3) = 
c     +                    XROW(I,LEV,cncaNH3)*(EXP(QCC)-1.0)/ADT2
c       print*,'adt2',adt2,rtdry(i,ilev,iso2),thlev(i,ilev)
c       XROW(I,ILEV+1,cncaNH3)=AMAX1(TMIN,XROW(I,ILEV+1,cncaNH3)
c     1                                 +RTDRY(I,ILEV,cncaNH3)*ADT2)
c       GDREM(I,cncaNH3,1)=GDREM(I,cncaNH3,1)+ RTDRY(I,ILEV,cncaNH3)*  
c     1                               DSHJ(I,ILEV)*PRESSG(I)/G

c      END DO
  200 CONTINUE
C
C     PARTICLE DRY DEPOSITION
C
      CALL DRYPAR  (THROW,   LEV,    ILEV,     ILG,  ISIZE,  NTP,
     1                IL1,    IL2,    NTR,    ADT2, IAE1,   MAE,
     2             PRESSG,SHJ,  THLEV,ROAROW,PXNEW(1,1,1),PDIFF,
     2              RHOP, RHSIZE,  FLAND,     XROW, PXNEW(1,1,2),LUC,
     3             SURFDG, SURFWD,  PDEPV,   RTDRY, DSHJ,PXNEW(1,1,3),
     4               JLAT,  SEASN,     RA,     USI, PLLP, AEST,
     5                 NS,  GAMMA)

      DO NN=1,NTP
        DO N = 1,ISIZE
          NP=ISIZE*(NN-1)+N+(IAE1-1)
          DO  L = ILEV, 1+MAE, -1
            DO I = IL1, IL2
c          print*,'dry 1',xrow(i,l+1,np),i,l,np  
                 XROW(I,L+1,NP)=AMAX1(XROW(I,L+1,NP)+RTDRY(I,L,NP)*ADT2,
     1                                 TMIN)
                 GDREM(I,NP,1) = GDREM(I,NP,1) + RTDRY(I,L,NP)*
     1                           DSHJ(I,L)*PRESSG(I)/G
c        print*,'dry 2',xrow(i,l+1,np),i,l,np,rtdry(i,l,np),adt2,tmin
            END DO
          END DO
        END DO
      END DO

      RETURN
      END
