      SUBROUTINE AEROPROP (NTR,      NTP,      ILG,     ILEV,      IL1,
     1                     IL2,    ISIZE,   RHSIZE, AEROSIZE,     RHOP,
     2                   RHOP0,    RHROW,    THROW,    RGRID,  AERONUM,
     3                  TOTMAS,     PHIX,     IAE1, AERONAME,  TRWTROW,  
     4                     FMO,     FMSO,   PHIAW1,      AMW,  SAVERAD,
     5                     ANU,        A,     BMIX,      FR1,       FC,
     6                     FRC,      AWX,   DELIQS,   RECRYS,   ROAROW,
     7                     SHJ,   PRESSG,    PDIFF,    PDEPV,      MAE)
C-----------------------------------------------------------------------
C     PURPOSE:
C     --------
C     AEROSOL PROPERTY CALCULATION                                     
C
C     HISTORY:
C     --------
C     * OCT 21/02 - G. GONG     TAKE THE DRY DENSITY OUT OF THIS ROUTINE TO
C                               BE USED IN COAGD BY RECRYS ARRAY.
C     * SEP 4/99  - G. GONG     ADD THE AEROSOL GRAVITATIONAL SETTLING
C     *                         VELOCITY CALCULATION WHICH WAS DONE
C     *                         SEVERAL TIMES IN OTHER PLACES. 
C     * MAY  5/99 - G. LESINS   ADDED ORGANIC AEROSOL TYPE - TREATED AS SULPHATE
C     * JUN 19/98 - G. LESINS   ADDED NITRATE, BC, DUST
C     *                         ADDED DELIQUESCENCE & RECRYST DATA
C     * MAR 13/98 - G. LESINS   MODIFIED PARAMETERIZATION
C     *                         VALID FOR ALL SIZES AND RH
C     *                         USES EMPIRICAL OSMOTIC COEFFICIENTS
C     * JUN 25/97 - S.L. GONG   COMBINE PREVIOUS AERODEN AND GROWTH
C     *                         ROUTINES TO COMPUTE THE AEROSOL
C     *                         AMBIENT PROPERTIES.
C     *
C     * JAN 19/96 - S.L. GONG   VECTORIZED THE WHOLE PROGRAM AND ADD
C     *                         WORKING SPACES.
C     *
C     * DEC  5/94 - S.L. GONG   FIRST VERSION
C     *
C
C     ARGUMENT LIST
C     NTR - TOTAL NUMBER OF TRACE SUBSTANCES (GASES AND AEROSOLS)
C     NTP - NUMBER OF AEROSOL TYPES
C     ILG - NUMBER OF LONGITUDE GRID POINTS
C     ILEV - NUMBER OF VERTICAL LEVELS
C     IL1 - MINIMUM INDEX FOR ILG
C     IL2 - MAXIMUM INDEX FOR ILG
C     ISIZE - NUMBER OF SIZE BINS
C     RHSIZE - WET RADIUS ***OUTPUT***
C     AEROSIZE - DRY RADIUS
C     RHOP - FINAL WET DENSITY ***OUTPUT***
C     RHOP0 - DENSITY FOR EACH AEROSOL TYPE
C     RHROW - RELATIVE HUMIDITY
C     THROW - TEMP
C     RGRID - MASS MIXING RATIO FOR EACH TRACE SUBSTANCE
C     AERONUM - NUMBER CONCONCENRATION (#/KG)  ***OUTPUT***
C     TOTMAS - TOTAL MASS MIXING RATIO FOR EACH BIN (ALL COMPONENTS)
C     TRWTROW - AEROSOL LIQUID WATER CONTENT FOR EACH BIN. 
C                 ***OUTPUT***
C     IAE1 - INDEX OF FIRST AEROSOL IN TRACE SUBSTANCE LIST (NTR)
C     AERONAME - NAME OF EACH AEROSOL TYPE
C     THE REMAINING ARGUMENTS ARE WORKING ARRAYS ADDED BY LESINS
C     PHIX - OSMOTIC COEFFICIENT
C     FMO - MASS FRACTION OF EACH DRY COMPONENT
C     FMSO - MASS FRACTION OF TOTAL SOLUBLE PART
C     PHIAW1 - OSMOTIC COEFFICIENT AT WATER ACTIVITY=1
C     AMW - AVERAGE MOLECULAR WEIGHT OF SOLUBLE PART
C     ANU - AVERAGE NU (ION NUMBER) OF SOLUBLE PART
C     A - SURFACE TENSION COEFFICIENT IN KOHLER EQUATION
C     BMIX - SOLUTE COEFFICIENT IN KOHLER EQUATION
C     FR1 - ESTIMATED RADIUS RATIO AT RELATIVE HUMIDITY=1
C     FC - CRITICAL RELATIVE HUMIDITY (SUPERSATURATED)
C     FRC - CRITICAL RADIUS RATIO
C     AWX - ITERATED VALUE FOR WATER ACTIVITY
C     DELIQS - AVERAGE DELIQUESCENCE POINTS FOR MIXTURE
C     RECRYS - AVERAGE RECRYSTALLIZATION POINTS FOR MIXTURE
C
C     *
C-----------------------------------------------------------------------     
C
C IN THE PARAMETER STATEMENT:
C   NUMSOL = TOTAL NUMBER OF SOLUBLE AEROSOL TYPES POSSIBLE
C   NUMINS = TOTAL NUMBER OF INSOLUBLE AEROSOL TYPES POSSIBLE
      PARAMETER (NUMSOL=4, NUMINS=2, NUMTYPES=NUMSOL+NUMINS)
      REAL RHROW(ILG,ILEV+1), THROW(ILG,ILEV+1), RHOPD(ILG,ILEV,ISIZE)
      REAL RHSIZE(ILG,ILEV,ISIZE),RHOP(ILG,ILEV,ISIZE), RHOP0(NTP)
      REAL AEROSIZE (2,ISIZE),RGRID(ILG,ILEV,NTR),TOTMAS(ILG,ILEV,ISIZE)
      REAL AERONUM(ILG,ILEV,ISIZE),TRWTROW(ILG,ILEV,ISIZE)
      CHARACTER*8 AERONAME(NTP), SORTNAME(NUMTYPES)
      
C FOLLOWING SECTION CONTAINS DATA ARRAYS FOR ALL AEROSOL TYPES
      REAL NU(NUMTYPES),MW(NUMTYPES),PHIK(NUMTYPES),B(NUMTYPES)
      REAL DELIQ(NUMTYPES),RECRY(NUMTYPES)
      REAL PHIT(11,NUMSOL)
      REAL NU_(NUMTYPES),MW_(NUMTYPES)
      REAL DELIQ_(NUMTYPES),RECRY_(NUMTYPES)
      REAL PHIT_(11,NUMSOL)
      CHARACTER*8 NAMSOL(NUMSOL), NAMINS(NUMINS)

C FOLLOWING SECTION CONTAINS WORKING ARRAYS   
      REAL AVESIZE(100)
      REAL FMO(ILG,ILEV,ISIZE,NTP),FMSO(ILG,ILEV,ISIZE)
      REAL PHIAW1(ILG,ILEV,ISIZE),AMW(ILG,ILEV,ISIZE)
      REAL ANU(ILG,ILEV,ISIZE),A(ILG,ILEV,ISIZE)
      REAL BMIX(ILG,ILEV,ISIZE),FR1(ILG,ILEV,ISIZE)
      REAL FC(ILG,ILEV,ISIZE),FRC(ILG,ILEV,ISIZE)
      REAL AWX(ILG,ILEV,ISIZE,2), PHIX(ILG,ILEV,ISIZE)
      REAL DELIQS(ILG,ILEV,ISIZE),RECRYS(ILG,ILEV,ISIZE)

      REAL PDIFF(ILG,ILEV,ISIZE),PDEPV(ILG,ILEV,ISIZE)
      REAL PRESSG(ILG),SHJ(ILG,ILEV),ROAROW(ILG,ILEV)      
      REAL MWW,RW,DENW,SFCTEN
      REAL*8 R,Q,D
      INTEGER NTPS, NUMITER, SORTNUM(NUMTYPES), LN(NUMTYPES)
      LOGICAL DELIQCRY

      COMMON /PARAMS/ WW,TW,RAYON,ASQ,G,RGAS,RGOCP,RGOASQ,CPRES
      COMMON /PARAMS/ RGASV,CPRESV
      COMMON /NARCM/ AVNO,    RGASi,     AM,   BOLTZK,  PI, Aa
      COMMON /NARCM/ A0,RSN0,RCUT0,RCG0,P
C AEROSOL TYPE DATA ARE IN THE FOLLOWING ORDER:
C  1. SEA SALT
C  2. (NH4)2SO4
C  3. NH4NO3
C  4. ORGANIC
C  5. BLACK CARBON
C  6. SOIL DUST
C
C NAMSOL ARE THE PERMITTED SOLUBLE AEROSOL NAMES
      DATA NAMSOL/'SEA-SALT','SULPHATE','NITRATES','OMCARBON'/
c NAMINS ARE THE PERMITTED INSOLUBLE AEROSOL NAMES
      DATA NAMINS/'BLCARBON','SOILDUST'/
      
C MW ARE THE MOLECULAR WEIGHTS OF THE DRY AEROSOL COMPONENTS      
      DATA MW_ /67.180, 132.1342, 80.0435, 132.1342, 12.011, 60.08/
C      
C NU ARE THE IONS PER SOLUTE MOLECULE
      DATA NU_ /2.165, 3.0, 2.0, 3.0, 0., 0./

C DELIQ IS THE DELIQUESCENCE RELATIVE HUMIDITY
C RECRY IS THE RECRYSTALLIZATION RELATIVE HUMIDITY
      DATA DELIQ_/0.74, 0.80, 0.62, 0.80, 1.1, 1.1/
      DATA RECRY_/0.45, 0.37, 0.25, 0.37, 1.1, 1.1/
C      
C MWW IS THE MOLECULAR WEIGHT OF WATER 
      DATA MWW/18.015/
C      
C RW IS THE GAS CONSTANT FOR WATER VAPOUR ( J/(KG K) )
      DATA RW/461.51/
C     
C DENW IS THE DENSITY OF WATER ( KG / M^3 )
      DATA DENW/1000./
C      
C SFCTEN IS THE SURFACE TENSION BETWEEN WATER AND AIR ( J / M^2 )
      DATA SFCTEN/0.076/
C
C NTPS IS THE INDEX NUMBER OF THE LAST SOLUBLE AEROSOL TYPE (<= NTP)
C IF NTPS=NTP THEN THERE ARE NO INSOLUBLE COMPONENTS
C      
C NUMITER IS THE NUMBER OF ITERATIONS PERFORMED FOR KOHLER EQUATION
C NUMITER=2 SHOULD GIVE BETTER THAN 1% ACCURACY
C NUMITER MUST NOT EXCEED THE DECLARED SIZE OF THE LAST INDEX IN AWX
      DATA NUMITER/2/
C
C OCFACTOR IS A FACTOR USED TO MULTIPLY THE ORGANIC CARBON OSMOTIC
C   COEFFICIENTS TO FORCE A DIFFERENCE FROM SULPHATE
      DATA OCFACTOR/0.54/
C
C PHIT(J,I) is the phi(aw) table of coefficients
C I is the solute index:
C     1 = sea salt
C     2 = (NH4)2SO4
C     3 = NH4NO3
C     4 = organic
C I MUST BE DIMENSIONED TO EQUAL NTPS
C J is the data :
C  1 = minimum aw for polynomial fit
C  2 = aw break point between two polynomials
C  3 = x^3 coef for aw > awbreak
C  4 = x^2 coef
C  5 = x^1 coef
C  6 = x^0 coef
C  7 = x^4 coef for aw <= awbreak
C  8 = x^3 coef
C  9 = x^2 coef
C  10= x^1 coef
C  11= x^0 coef
      DATA PHIT_/0.44,0.92, 410.74729, -1138.2693, 1049.2792,-320.74562,
     1 -5.79690208, 17.7685336, -22.5253540, 11.8087027, -0.48210984,
     2 0.39, 0.92, 457.060777, -1280.47495, 1194.81750, -370.739425,
     3 -1.62440470, 4.07342346, -5.61205075, 3.873682106, -0.216021389,
     4 0.275, 0.81, 7.6174049, -19.354181, 17.103802, -4.5561686,
     5 -1.1108526, 3.7035588, -5.1408203, 4.0788267, -0.77326108,
     6 0.39, 0.92, 457.060777, -1280.47495, 1194.81750, -370.739425,
     7 -1.62440470, 4.07342346, -5.61205075, 3.873682106, -0.216021389/
C
C  DELIQCRY IS A LOGICAL SWITCH TO HANDLE SIZE IF RH IS BETWEEN
C    CRYSTALLIZATION AND DELIQUESCENCE.  IF =.TRUE. THEN FINAL SIZE IS
C    WEIGHTED AVERAGE BETWEEN DRY AND DELIQUESCED SIZES.  IF =.FALSE.
C    THEN FINAL SIZE IS THE FULLY DELIQUESCED SIZE.
      DATA DELIQCRY/.FALSE./
      DATA AA1/1.257/, AA2/0.4/, AA3/1.1/
C
c      print*,'aeroprop 1',ntp
      CALL PUTZERO(RHOP,   ILG*ILEV*ISIZE)
      CALL PUTZERO(TOTMAS, ILG*ILEV*ISIZE)
      CALL PUTZERO(FMO,    ILG*ILEV*ISIZE*NTP)
      CALL PUTZERO(FMSO,   ILG*ILEV*ISIZE)
      CALL PUTZERO(PHIAW1, ILG*ILEV*ISIZE)
      CALL PUTZERO(AMW,    ILG*ILEV*ISIZE)
      CALL PUTZERO(ANU,    ILG*ILEV*ISIZE)
      CALL PUTZERO(DELIQS, ILG*ILEV*ISIZE)
      CALL PUTZERO(RECRYS, ILG*ILEV*ISIZE)

      CUB=1./3.
c      print*,'aeroprop',ilg,is_x0(il1),ie_x0(il2)
      
C        SORT THE AEROSOL NAMES (SOLUBLES FIRST, THEN INSOLUBLES)
      INEXT=1
      ILAST=NTP
c      print*,'aeroprop ntp',ntp 
      DO NT=1,NTP
         IFOUND=0
         DO J=1,NUMSOL
            IF (AERONAME(NT) .EQ. NAMSOL(J)) THEN
               SORTNAME(INEXT) = AERONAME(NT)
               SORTNUM(INEXT) = J
               LN(INEXT) = NT
               INEXT = INEXT + 1
               IFOUND = 1
            ENDIF
         ENDDO
         IF (IFOUND .EQ. 0) THEN
            DO J=1,NUMINS
               IF (AERONAME(NT) .EQ. NAMINS(J)) THEN
                  SORTNAME(ILAST) = AERONAME(NT)
                  SORTNUM(ILAST) = J + NUMSOL
                  LN(ILAST) = NT
                  ILAST = ILAST - 1
                  IFOUND = 1
               ENDIF
            ENDDO
         ENDIF
c         print*,nt,numsol
         IF (IFOUND .EQ. 0) THEN
            WRITE(6,*) '***ERROR*** UNKNOWN AEROSOL NAME'
            STOP
         ENDIF
         IF (NT .EQ. NTP) NTPS = INEXT - 1
      ENDDO
C
C      DO NT=1,NTP
C         WRITE(6,600) AERONAME(NT),LN(NT),SORTNAME(NT),SORTNUM(NT)
C 600     FORMAT(1X,A8,5X,I1,5X,A8,5X,I1)
C      ENDDO
C
C
C  ADJUST OSMOTIC COEFFICIENTS FOR ORGANIC CARBON
      DO J=3,11
         PHIT_(J,4)=OCFACTOR*PHIT_(J,4)
      ENDDO
        
C  ARRANGE THE DATA ARRAYS IN THE CORRECT ORDER
      DO NT=1,NTP
         MW(NT)=MW_(SORTNUM(NT))
         NU(NT)=NU_(SORTNUM(NT))
         DELIQ(NT)=DELIQ_(SORTNUM(NT))
         RECRY(NT)=RECRY_(SORTNUM(NT))
      ENDDO
      DO NT=1,NTPS
         DO J=1,11
            PHIT(J,NT)=PHIT_(J,SORTNUM(NT))
         ENDDO
      ENDDO

C
C     * TOTAL DRY MASS MIXING RATIO & DRY AEROSOL COMPOSITE DENSITY
C       OF AEROSOL IN EACH BIN
C
C                    m1+m2+m3  
C       RHO = -------------------------
C              m1/rho1+m2/rho2+m3/rho3
C
C       IN THIS DO LOOP, RHOP(*,*,*) IS ONLY HOLDING THE DENOMINATOR
C       OF THIS EQUATION

      DO NT=1,NTP
         NT0=LN(NT)
         DO N=1,ISIZE
            NO= N+ISIZE*(NT0-1)+(IAE1-1)
            DO L=1+MAE,ILEV
              DO I=IL1,IL2
                 TRAMASS=AMAX1(1.0E-33, RGRID(I,L,NO))
                 TOTMAS(I,L,N)=TOTMAS(I,L,N)+TRAMASS
                 RHOP(I,L,N)=RHOP(I,L,N)+TRAMASS/RHOP0(NT0)
              END DO
            END DO
         END DO
      END DO
C
C COMPUTE THE MASS FRACTION OF EACH DRY AEROSOL COMPONENT, FMO 
C     
      DO NT=1,NTP
         NT0=LN(NT)
         DO N=1,ISIZE
            NO= N+ISIZE*(NT0-1)+(IAE1-1)
            DO L=1+MAE,ILEV
              DO I=IL1,IL2
                 TRAMASS=AMAX1(1.0E-33, RGRID(I,L,NO))
                 FMO(I,L,N,NT)=TRAMASS/TOTMAS(I,L,N)
              END DO
            END DO
         END DO
      END DO
C
C      COMPUTE PHI AT AW=1 FOR EACH SOLUTE
C      COMPUTE KOHLER B FACTOR FOR EACH SOLUTE
C
      DO NT=1,NTPS
         PHIK(NT)=PHIT(3,NT)+PHIT(4,NT)+PHIT(5,NT)+PHIT(6,NT)
         B(NT)=NU(NT)*PHIK(NT)*MWW*RHOP0(LN(NT))/(MW(NT)*DENW)
      END DO
C      
C COMPUTE THE SOLUTE MASS FRACTION, FMSO      
C COMPUTE AVERAGE NU AND AVERAGE MOLECULAR WEIGHT OF SOLUBLE PART
C COMPUTE PHI AT AW=1 FOR THE MIXED AEROSOL
C COMPUTE AVERAGE DELIQUESCENCE AND RECRYSTALLIZATION POINTS
      DO NT=1,NTPS
      DO N=1,ISIZE
         DO L=1+MAE,ILEV
           DO I=IL1,IL2
              FMSO(I,L,N)=FMSO(I,L,N)+FMO(I,L,N,NT)
              AMW(I,L,N)=AMW(I,L,N)+FMO(I,L,N,NT)/MW(NT)
              ANU(I,L,N)=ANU(I,L,N)+NU(NT)*FMO(I,L,N,NT)/MW(NT)
              PHIAW1(I,L,N)=PHIAW1(I,L,N)+PHIK(NT)*NU(NT)*FMO(I,L,N,NT)
     1                        /MW(NT)
              DELIQS(I,L,N)=DELIQS(I,L,N)+FMO(I,L,N,NT)*DELIQ(NT)
              RECRYS(I,L,N)=RECRYS(I,L,N)+FMO(I,L,N,NT)*RECRY(NT)
           END DO
         END DO
      END DO
      END DO
C
C COMPUTE THE AVERAGE DRY AEROSOL RADIUS, AVESIZE
C
      DO N=1,ISIZE
         RWI=(AEROSIZE(1,N)+AEROSIZE(2,N))/2.0
         R3D=4.189*RWI*RWI*RWI
         AVESIZE(N)=RWI
         DO L=1+MAE,ILEV
           DO I=IL1,IL2
              RHOP(I,L,N)=TOTMAS(I,L,N)/RHOP(I,L,N)
              IF (FMSO(I,L,N) .NE. 0.) THEN
                 AMW(I,L,N)=FMSO(I,L,N)/AMW(I,L,N)
                 ANU(I,L,N)=ANU(I,L,N)*AMW(I,L,N)/FMSO(I,L,N)
                 PHIAW1(I,L,N)=PHIAW1(I,L,N)*AMW(I,L,N)/(FMSO(I,L,N)*
     1                        ANU(I,L,N))
                 DELIQS(I,L,N)=DELIQS(I,L,N)/FMSO(I,L,N)
                 RECRYS(I,L,N)=RECRYS(I,L,N)/FMSO(I,L,N)
              ELSE
                 DELIQS(I,L,N)=1.1
                 RECRYS(I,L,N)=1.1
              END IF
C
C     * AEROSOL NUMBER CONCENTRATION (#/KG_AIR)
C      NOTE:  4.189 = 4 * PI / 3
C
              AERONUM(I,L,N)=TOTMAS(I,L,N)/(R3D*RHOP(I,L,N))
           END DO
         END DO
      END DO
C      WRITE(6,*) 'FMO:'
C      WRITE(6,*) (FMO(1,1,1,M),M=1,NTP)
C      WRITE(6,*) 'FMSO= ',FMSO(1,1,1)
C      WRITE(6,*) 'MW:'
C      WRITE(6,*) (MW(M),M=1,NTP)
C      WRITE(6,*) 'AMW= ',AMW(1,1,1)
C      WRITE(6,*) 'NU:'
C      WRITE(6,*) (NU(M),M=1,NTP)
C      WRITE(6,*) 'ANU= ',ANU(1,1,1)
C      WRITE(6,*) 'RHOP0:'
C      WRITE(6,*) (RHOP0(LN(M)),M=1,NTP)
      
C
C  COMPUTE KOHLER A' FACTOR AND B FACTOR FOR MIXTURE
C  COMPUTE RADIUS RATIO AT RH=1 (FR1)
C  COMPUTE CRITICAL RADUS RATIO (FRC)
C  COMPUTE CRITICAL RELATIVE HUMIDITY (FC)    
C
      DO N=1,ISIZE
         DO L=1+MAE,ILEV
           DO I=IL1,IL2
              A(I,L,N)=2.0*SFCTEN/(DENW*RW*THROW(I,L+1)*AVESIZE(N))
              IF (AMW(I,L,N) .NE. 0) THEN
                 BMIX(I,L,N)=ANU(I,L,N)*PHIAW1(I,L,N)*MWW*RHOP(I,L,N)*
     1                     FMSO(I,L,N)/(AMW(I,L,N)*DENW)
              ELSE
                 BMIX(I,L,N)=0.0
              END IF
              Q=-BMIX(I,L,N)/(3.0*A(I,L,N))
C              R=0.5
              D=Q*Q*Q+0.25
              IF(D .LT. 0.0 .AND. Q .LT. 0.0) THEN
                 THETA=ACOS(0.5/SQRT(-Q*Q*Q))
                 FR1(I,L,N)=2.0*SQRT(-Q)*COS(THETA/3.0)
              ELSE
                 DSR=SQRT(D)
                 FR1(I,L,N)=(0.5+DSR)**CUB+(0.5-DSR)**CUB
              END IF

C*******************
C  THIS SECTION CAN BE COMMENTED OUT IF YOU ARE NOT INTERESTED
C    IN COMPUTING THE CRITICAL RADIUS AND CRITICAL RELATIVE HUMIDITY

              Q=Q*3.0
C              R=1.0
              D=Q*Q*Q+1.0
              IF(D .LT. 0.0 .AND. Q .LT. 0.0) THEN
                 THETA=ACOS(1.0/SQRT(-Q*Q*Q))
                 FRC(I,L,N)=2.0*SQRT(-Q)*COS(THETA/3.0)
              ELSE
                 DSR=SQRT(D)
                 FRC(I,L,N)=(1.0+DSR)**CUB+(1.0-DSR)**CUB
              END IF
              FRCTEST=FRC(I,L,N)**3.0
              IF (FRCTEST .EQ. 1.0) THEN
                 FC(I,L,N)=1.0
              ELSE
                 FC(I,L,N)=EXP(A(I,L,N)/FRC(I,L,N)-BMIX(I,L,N)/
     1                  (FRCTEST-1.0))
              END IF
C*********************
C
           END DO
         END DO
      END DO
C
C SOLVE FOR THE WET RADIUS AFTER WATER UPTAKE
      DO ITER=1,NUMITER
         IF (ITER.EQ.1) THEN
            ITRx=1
         ELSE
            ITRx=ITER-1
         END IF
         CALL PUTZERO(PHIX, ILG*ILEV*ISIZE)
         DO NT=1,NTPS
          PPT=NU(NT)/MW(NT)
          DO N=1,ISIZE
            DO L=1+MAE,ILEV
               DO I=IL1,IL2
                 RH=AMIN1(1.0,AMAX1(0.0,RHROW(I,L+1)))
                 IF(ITER .EQ. 1)
     1               AWX(I,L,N,ITER)=MIN(1.0,
     1                     RH*EXP(-A(I,L,N)/(0.8*FR1(I,L,N))))
                 AWX1=AWX(I,L,N,ITRx)
                 AW2=AWX1*AWX1
                 AW3=AWX1*AWX1*AWX1
                 AW4=AW3*AWX1
                 POP=CVMGT(0.,1.,AWX1 .GT. PHIT(2,NT))
                 
                 PHIX(I,L,N)=PHIX(I,L,N)+
     1                       (1.0-POP)*(PHIT(3,NT)*AW3+
     1                     PHIT(4,NT)*AW2 +PHIT(5,NT)*AWX1 +
     2                      PHIT(6,NT))*PPT*FMO(I,L,N,NT) +
     1                     POP*(PHIT(7,NT)*AW4+PHIT(8,NT)*AW3 +
     2                      PHIT(9,NT)*AW2 + PHIT(10,NT)*AWX1 +
     3                      PHIT(11,NT))*PPT*FMO(I,L,N,NT)

               END DO
            END DO
          END DO
         END DO

         DO N=1,ISIZE
            DO L=1+MAE,ILEV
              DO I=IL1,IL2
                 RH=AMIN1(1.0,AMAX1(0.0,RHROW(I,L+1)))
                 AWX1=AWX(I,L,N,ITRx)
                 IF (FMSO(I,L,N) .NE. 0. .AND. AWX1 .GT. 0.0) THEN
                    PHIX(I,L,N)=PHIX(I,L,N)*AMW(I,L,N)/(FMSO(I,L,N)
     1                                       *ANU(I,L,N))
                    FRX1=(1.0-ANU(I,L,N)*PHIX(I,L,N)*MWW*RHOP(I,L,N)*
     1                  FMSO(I,L,N)/(AMW(I,L,N)*DENW*LOG(AWX1)))**CUB
                 ELSE
                    PHIX(I,L,N)=0.
                    FRX1=1.0
                 END IF
C
C*********************
C  THIS SECTION GREATLY IMPROVES ACCURACY FOR RH ~ 1    
C  IT CAN BE COMMENTED OUT IF SPEED IS MORE IMPORTANT THAN ACCURACY
C 
                 IF(RH .GT. 0.98 .AND. FRX1 .GT. 1.0) THEN
                    FRX3=FRX1*FRX1*FRX1
                    BPR=ANU(I,L,N)*PHIX(I,L,N)*MWW*RHOP(I,L,N)*
     1                   FMSO(I,L,N)*FRX3/(AMW(I,L,N)*DENW*(FRX3-1.0))
                    Q=-A(I,L,N)/(3.0*BPR)
                    R=-LOG(RH)/(2.0*BPR)
                    D=Q*Q*Q+R*R
                    IF(D .LT. 0.0 .AND. Q .LT. 0.0) THEN
                       THETA=ACOS(R/SQRT(-Q*Q*Q))
                       FRX1=1.0/(2.0*SQRT(-Q)*COS(THETA/3.0))
                    ELSE
                       vv=ABS(R+SQRT(D))  
                       dd=ABS(R-SQRT(D))
                       FRX1=1.0/((vv)**CUB + (dd)**CUB)
                    END IF
                 END IF
C**********************
C                 
                 AWX(I,L,N,ITER)=RH*EXP(-A(I,L,N)/FRX1)
                 RHSIZE(I,L,N)=AVESIZE(N)*FRX1
              END DO
            END DO
         END DO
      END DO
C
C ADJUST SIZE IF RH < DELIQUESCENCE POINT
C COMPUTE THE MEAN DENSITY OF THE WET AEROSOL
C
      DO N=1,ISIZE
         DO L=1+MAE,ILEV
           DO I=IL1,IL2
              RH=RHROW(I,L+1)
              IF( RH .LT. DELIQS(I,L,N)) THEN
                 IF( RH .LT. RECRYS(I,L,N)) THEN
                    RHSIZE(I,L,N)=AVESIZE(N)
                 ELSE
                    IF( DELIQCRY ) RHSIZE(I,L,N)=AVESIZE(N)+
     1                 (RHSIZE(I,L,N)-AVESIZE(N))*
     2                 (RH-RECRYS(I,L,N))/(DELIQS(I,L,N)-RECRYS(I,L,N))
                 END IF
              END IF
              FF=AVESIZE(N)/RHSIZE(I,L,N)
              
              RECRYS(I,L,N)=RHOP(I,L,N)  !Assign dry rhop the value for coagd use
              RHOP(I,L,N)=DENW+AMAX1(0.,FF*FF*FF*(RHOP(I,L,N)-DENW))

C
C COMPUTE THE AEROSOL LIQUID WATER CONTENT OF EACH SIZE BIN: WATE
C ACCUMULATE IT FOR OUTPUT [KG/KG AIR]
C

              WMAS=4.189*RHSIZE(I,L,N)**3*AERONUM(I,L,N)*RHOP(I,L,N)
              WATE=AMAX1(0.,WMAS - TOTMAS(I,L,N))
              TRWTROW(I,L,N)=WATE
C
C    AEROSOL GRAVITATIONAL SETTLING VELOCITY
C    AND DIFFUSION COEFFICIENT
C
C     * AIR'S DYNAMIC VISCOSITY
C
              AMU=145.8*1.E-8*THROW(I,L+1)**1.5/(THROW(I,L+1)+110.4)
C . . . . MID LAYER PRESSURE IN [PASCAL].
              PRE = PRESSG(I)*SHJ(I,L)
C
C     * MEAN MOLECULAR FREE PATH.
C       K.V. BEARD [1976], J ATM. SCI., 33
C
              AMFP=6.54E-8*(AMU/1.818E-5)*(1.013E5/PRE)*
     1                          (THROW(I,L+1)/293.15)**(1./2.)
              PRII=2./9.*G/AMU
              PRIIV=PRII*(RHOP(I,L,N)-ROAROW(I,L))
C
C     * CUNNINGHAM SLIP CORRECTION FACTOR AND RELAXATION TIME = vg/Grav.
C
              CFAC=1.+AMFP/RHSIZE(I,L,N)*(AA1+AA2*
     1                                EXP(-AA3*RHSIZE(I,L,N)/AMFP))
              TAUREL=AMAX1(PRIIV*RHSIZE(I,L,N)**2*CFAC/G,0.0)
c        print*,'aeroprop',throw(i,l+1)
C
C     * STOKES FRICTION AND DIFFUSION COEFFICIENTS.
C
              AMOB=6.*PI*AMU*RHSIZE(I,L,N)/CFAC
              PDIFF(I,L,N)=BOLTZK*THROW(I,L+1)/AMOB
C
C     * GRAVITATIONAL SETTLING VELOCITY.
C
              PDEPV(I,L,N) =TAUREL*G
           END DO
         END DO
      END DO

      RETURN
      END
