      SUBROUTINE AODEPTH ( XROW, RHOP,ABCOEF,SCCOEF, AODROW1,AODROW2,
     1                     RHROW,  DSHJ,  PRESSG, IRH, AERONAME,
     1                    RHRROW,  RHSIZE, FRBIN, IBIN,TOTOPT,
     1                       SHJ,  CLDCV,  PRESSC,COLEF,RTCOND,
     1                       ILG,  ILEV,     LEV, NTR, ISIZE, NTP,
     1                      IAE1,   IL1,     IL2, ATERM,ATERMB,
     1                     PRESS, LAMDA)

!       Subroutine to compute the aerosol optical depth for each 
!       size bin and level given a column of mass mixing ratios 
!       and relative humidities at ILEV levels. AODEPTH 
!       is designed to be called by Sunling Gong's GCMIII/CAM 
!       version of the Canadian GCM.
!      
!       AUTHOR   S. THULASIRAMAN, CARTEL, University of Sherbrooke, Sherbrooke, Canada.
!       REVISED: G.L. GONG,       MSC, GCM IMPLEMENTATION AND VECTORIZATION.
!
!     AODROW | aerosol optical depth                     
!     EXCOEF | Extinction cross section [m^2]               
!     DSHJ   | Sigma value difference between layers     
!     GRAV   | gravitational constant [m/s^2]
!     NTP    | number of aerosol types (5)                   
!     NTR    | maximum number of tracers,
!                tracer # 5 corresponds to the 1st of 12 seasalt size bins
!                tracer #17 correponds to the 1st of 12 sulphate size bins .... etc.  
!     PRESSG | Grid row of surface pressure [Pa]         
!     RH     | The nominal relative humidity values at which cross sections are computed
!     RHOP   | bin-specific dry aerosol density [kg/m^3] 
!     RHROW  | relative humidity matrix [0 to .99]            
!     ROAROW | air density    [kg m^-3]
!     IRH    | relative index.                   

      COMMON /PARAMS/ WW,TW,RAYON,ASQ,GRAV,RGAS,RGOCP,RGOASQ,CPRES
      COMMON /PARAMS/ RGASV,CPRESV
      REAL ATERM(ILG), ATERMB(ILG), PRESS(ILG)
      REAL XROW(ILG,ILEV+1,NTR),RHOP(NTP),PRESSC(ILG),SHJ(ILG,ILEV)
      REAL AODROW1(ILG,NTP,LAMDA),RHROW(ILG,ILEV),DSHJ(ILG,ILEV)
      REAL AODROW2(ILG,NTP,LAMDA),PRESSG(ILG), FRBIN(ILG,ILEV)
      REAL RHP(13), RHRROW(ILG), RHSIZE(ILG,ILEV,ISIZE)
      INTEGER IRH(ILG,ILEV), WA, IBIN(ILG,ILEV), IWAVE(5)
      REAL ABCOEF(ISIZE,13,NTP,14),RTCOND(ILG,ILEV,ISIZE)
      REAL SCCOEF(ISIZE,13,NTP,14),COLEF(ILG,ILEV,ISIZE)
      REAL TOTOPT(ILG, ILEV),CLDCV(ILG,ILEV,2)
      
      
      CHARACTER*8 AEROTYPE(5)                                      !SLG
      CHARACTER*8 AERONAME(NTP)                                    !SLG
      DATA RHP/0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 
     1        0.95, 0.98, 0.99/
      DATA IWAVE/ 4, 6, 7, 9, 6/
      DATA AEROTYPE/'SEA-SALT','SULPHATE','BLCARBON','OMCARBON'
     1            ,'SOILDUST'/                                     !SLG
      
!        The following section deals with extinction cross sections
!        (um^2). The cross sections were computed by M. Aube using 
!        a variant of B. Evans' Mie code. The Input file for this 
!        section crosssections.txt is a file containing for 13 rows 
!        of R.H and 12 columns of size bins. First 13 rows (and 12
!        columns) are cross sections (340nm) for seasalt aerosols. 
!        Second array (13x12) is for sulphate and then black carbon,
!        organic carbon and dust aerosols (all 340 nm wavelength).
!        After this data continues in the same format for other 
!        thirteen wavelengths, namely 380, 440, 470, 500, 550, 670, 
!        860, 870, 940, 1020, 1240, 1640, 2130. The following is the 
!        main part of AOD calculation. The equation for this is given
!        in the word document by Norm O'Neill (quadrature.doc). 
!        Briefly, for each bin, each level and each component, we 
!        calculate the optical depth = [sigma/v] * M/rho_component*dP/g
!        where sigma = wet volume extinction cross section
!              v = dry volume of a single particle
!              M = mass density = mass mixing ratio (RGRID) * rho_air
!              rho_component is the dry aerosol density of each component (RHOP)
!              dP = pressure change across the current level (= DSHJ * PRESSG)
!              g = gravitational constant (GRAV)

!        The RH data are the nominal relative humidity values at 
!        which cross sections are computed.

   
      GRAVI=1./GRAV
!SLG
!   FIND THE RELATIVE INDEX FIRST
!     The loop below works to find the interval which contains the current 
!     relative humdity.
!     (preparation for interpolating EXCOEF in terms of relative humidity 
!     across the interval)
!
      IRH=1
      DO L=1,ILEV
         DO J=1,12
           DO I=IL1,IL2
             RH0=AMIN1(0.99,AMAX1(0.0,RHROW(I,L)))
             IF (RH0 .GE. RHP(J) .AND. RH0 .LE. RHP(J+1)) THEN
               IRH(I,L)=J
             END IF
           END DO
         END DO
         
         IBIN=7
         FRBIN=0.0
         DO N=1,ISIZE-1
            DO I=IL1,IL2
              IF (RHSIZE(I,L,N) .LT. 1.0E-6 .AND. 
     1                       RHSIZE(I,L,N+1) .GE. 1.0E-6) THEN
                IBIN(I,L)=N
                FRBIN(I,L)= (RHSIZE(I,L,N+1)-1.0E-6)/
     1                         (RHSIZE(I,L,N+1)-RHSIZE(I,L,N))
              END IF
            END DO
         END DO         
      END DO 

      TOTOPT=0.0
      AODROW1=0.0
      AODROW2=0.0
      COLEF=0.0
      RTCOND=0.0
      
      NJ=0
      DO NT=1,NTP
         DO J=1,5
           IF (AERONAME(NT) .EQ. AEROTYPE(J)) NJ=J
         END DO
         IF (NJ .EQ. 0) CALL XIT (' AODEPTH', -NT) 
         
         DO IW=1,LAMDA-1    !IW 1-4: 440, 550, 670, 870 NM TOTAL OPT
           WA=IWAVE(IW)     !IW   5: 550 NM ABSORPTION ONLY
           DO NB=1,ISIZE
             NN=IAE1+(NT-1)*ISIZE+NB-1
             DO L=ILEV,1,-1
               DO I=IL1,IL2
!SLG
!       The first three lines of this expression are used to compute
!       the cross section (actually it is extinction cross sections/
!       dry volume) interpolated to the current relative humidity 
!       (interpolated between the two interval limits found in 
!       previous loop). The last line (fourth) is for concentration
!       (kg/kg) multiplied by air density i.e. concentration in kg/m3
!       all divided by RHOP(NT)*1.E-3)
!
                   COEF_AB=((ABCOEF(NB,IRH(I,L)+1,NJ,WA)-
     1                        ABCOEF(NB,IRH(I,L),NJ,WA))/
     1                       (RHP(IRH(I,L)+1)-RHP(IRH(I,L)))*
     2                       (RHROW(I,L)-RHP(IRH(I,L)))+
     3                        ABCOEF(NB,IRH(I,L),NJ,WA))             ! [sigma/v]

                   COEF_SC=((SCCOEF(NB,IRH(I,L)+1,NJ,WA)-
     1                        SCCOEF(NB,IRH(I,L),NJ,WA))/
     1                       (RHP(IRH(I,L)+1)-RHP(IRH(I,L)))*
     2                       (RHROW(I,L)-RHP(IRH(I,L)))+
     3                        SCCOEF(NB,IRH(I,L),NJ,WA))             ! [sigma/v]
          
! [sigma/v]*[delta(M)/rho_air]/rho_component 
!
                    ATERM(I) = (COEF_AB+COEF_SC)*XROW(I,L+1,NN)/RHOP(NJ)          

                    PRESS(I)=GRAVI*DSHJ(I,L)*PRESSG(I)
! FOR 550 nm TOTAL OPTICAL DEPTH
                    IF (WA .EQ. 6) TOTOPT(I,L)=
     1                                     TOTOPT(I,L)+ATERM(I)*PRESS(I)
                   
                    IF (NB .LE. IBIN(I,L)) THEN                       !SUB-MICRON (wet)
                      AODROW1(I,NT,IW)=AODROW1(I,NT,IW)
     1                                                +ATERM(I)*PRESS(I)   ! ATERM*dP/g
                    ELSE
                      AODROW2(I,NT,IW)=AODROW2(I,NT,IW)
     1                                                +ATERM(I)*PRESS(I)   ! ATERM*dP/g                      
                    END IF
!
!           WET SIZE SEPARATIONS
!                    
                    IF (NB .EQ. IBIN(I,L)) THEN
                      IF (FRBIN(I,L) .GT. 0.5) THEN
                        TEMPDIV=(FRBIN(I,L) - 0.5)*ATERM(I)*PRESS(I)
                        AODROW2(I,NT,IW)=AODROW2(I,NT,IW)+TEMPDIV                     
                        AODROW1(I,NT,IW)=AODROW1(I,NT,IW)-TEMPDIV
                      END IF
                    END IF
                    IF (NB .EQ. IBIN(I,L)+1) THEN
                      IF (FRBIN(I,L) .LE. 0.5) THEN
                        TEMPDIV=(0.5-FRBIN(I,L))*ATERM(I)*PRESS(I)
                        AODROW2(I,NT,IW)=AODROW2(I,NT,IW)-TEMPDIV                     
                        AODROW1(I,NT,IW)=AODROW1(I,NT,IW)+TEMPDIV
                      END IF
                    END IF
                    
                    IF (WA .EQ. 6) THEN   !SAPCE FOR ABSORTION NOT FOR THE LAST WAVE LENGTH
                        ATERMB(I) = COEF_AB*XROW(I,L+1,NN)/RHOP(NJ)
                        AODROW1(I,NT,LAMDA)=AODROW1(I,NT,LAMDA)+
     1                                               ATERMB(I)*PRESS(I)
                    END IF
                    IF (CLDCV(I,L,1)+CLDCV(I,L,2) .LT. 0.01      
     1                                    .AND. WA .EQ. 6) THEN   !CLOUD FREE 550 NM
                       COLEF(I,L,NT) =COLEF(I,L,NT)+ATERMB(I)*PRESS(I)   !ABSORPTION
                       RTCOND(I,L,NT)=RTCOND(I,L,NT)+ATERM(I)*PRESS(I)   !TOTAL OPT. DEP.
                    END IF
               ENDDO
             ENDDO
           ENDDO
         ENDDO
      ENDDO    
!
!    optical weighted RH and pressure BY 550 NM
!     
      FRBIN=1.E-20
      PRESSC=0.0
      RHRROW=0.0
      
      DO L=1,ILEV
         DO I=IL1,IL2
            RHRROW(I)=RHRROW(I)+RHROW(I,L)*TOTOPT(I,L)
            PRESSC(I)=PRESSC(I)+SHJ(I,L) * PRESSG(I) * 0.01*TOTOPT(I,L) !mb
            FRBIN(I,1)=FRBIN(I,1)+TOTOPT(I,L)         !collum integrated opt. dep.       
         END DO
      END DO
      
      DO I=IL1,IL2
        IF (FRBIN(I,1) .GT. 1.E-20) THEN 
           RHRROW(I)=RHRROW(I)/FRBIN(I,1)
           PRESSC(I)=PRESSC(I)/FRBIN(I,1)
        END IF
      END DO
        
      RETURN
      END
