      SUBROUTINE VISIBILITY (XROW, ROA, RHROW, AERONAME,AEROSIZE,
     1           AERO_INIT,ILG,iVis,ILEV, LEV, NTR, NTP, IAE1,IL1,
     2           IL2,NSIZE)
!----------------------------------------------------------------------
!
!     HISTORY:
!     --------
!     * JUL 02/2008 - S.L. GONG   COMPUTE THE VISIBILITY ACCORDING TO
!     *                           IMPROVE SCHEME.
!     * REFERENCES:                          
!     * (1) Guidance for Estimating Natural Visibility Conditions Under 
!     *     the Regional Haze Program, US EPA,Publication No. EPA-454/B-03-005
!     * (2) J.W. Boylan, A.G. Russell, PM and light extinction model 
!     *     performance metrics, goals, and criteria for three-dimensional 
!     *     air quality models 
!     *     Atmospheric Environment 40 (2006) 4946C4959
!   
!----------------------------------------------------------------------     
      IMPLICIT NONE
      INTEGER ILG, ILEV, LEV, NTR, NTP, IAE1,NSIZE, J, NP,N
      INTEGER I,L, IL1,IL2, IRH, iVis, N25, NM
      REAL XROW(ILG, LEV, NTR), ROA(ILG,ILEV), RHROW(ILG,LEV)
      REAL AE_EXT, FRA, AEROSIZE(2,NSIZE+1)
      REAL COEFF(100), AERO_INIT(ILG,7)
      CHARACTER*8 AE_NAME(6), AERONAME(NTP)
      
      DATA COEFF /
     1   1  ,1  ,1  ,1  ,1  ,1  ,1  ,1  ,1  ,1  ,1  ,1  ,1  ,1  ,1  ,
     2   1  ,1  ,1  ,1  ,1  ,1  ,1  ,1  ,1  ,1  ,1  ,1  ,1  ,1  ,1  ,
     3   1  ,1  ,1  ,1  ,1  ,1  ,1.02 ,1.04 ,1.06 ,1.08 ,1.1  ,1.13 ,
     4   1.15 ,1.18 ,1.2  ,1.23 ,1.26 ,1.28 ,1.31 ,1.34 ,1.37 ,1.41 ,
     5   1.44 ,1.47 ,1.51 ,1.54 ,1.58 ,1.62 ,1.66 ,1.7  ,1.74 ,1.79 ,
     6   1.83 ,1.88 ,1.93 ,1.98 ,2.03 ,2.08 ,2.14 ,2.19 ,2.25 ,2.31 ,
     7   2.37 ,2.43 ,2.5  ,2.56 ,2.63 ,2.7  ,2.78 ,2.86 ,2.94 ,3.03 ,
     8   3.12 ,3.22 ,3.33 ,3.45 ,3.58 ,3.74 ,3.93 ,4.16 ,4.45 ,4.84 ,
     9   5.37 ,6.16 ,7.4  ,9.59 ,14.1 ,26.4 , 26.4 , 26.4/

      DATA AE_NAME/'SULPHATE','NITRATES', 'OMCARBON', 
     1               'BLCARBON','SOILDUST', 'SEA-SALT'/     
         
      CALL PUTZERO(AERO_INIT, ILG*7)
!
!    SEEK THE PM2.5 BOUNDARY
!   
      FRA=0.0
      DO N=1,NSIZE
        IF ((AEROSIZE(1,N)*2 .GE. 2.5E-6) .AND. 
     1                (AEROSIZE(1,N-1)*2 .LT. 2.5E-6)) THEN
           N25=N-1
           FRA=(2.5E-6-AEROSIZE(1,N25)*2)/
     1              (AEROSIZE(2,N25)*2-AEROSIZE(1,N25)*2)
        END IF
      END DO
!
!     Total aerosol mass of each type.in AERO_INIT
!     Unit: ug/m3
!
      DO J=1,6 
         DO NP = 1,NTP 
           IF (AE_NAME(J).EQ.AERONAME(NP)) THEN
              DO N= IAE1+(NP-1)*NSIZE, NP*NSIZE +(IAE1-1)
                NM=N-IAE1-(NP-1)*NSIZE+1
                DO I=IL1,IL2              
                   IF (NM .LT. N25) THEN
                     AERO_INIT(I,J)= 
     1                AERO_INIT(I,J)+XROW(I,LEV,N)*ROA(I,ILEV)*1.E9
                   ELSE
                     AERO_INIT(I,J)= 
     1                AERO_INIT(I,J)+XROW(I,LEV,N)*ROA(I,ILEV)*1.E9
     2                                                         *FRA
!
!      PM MASS > PM2.5
!
                     AERO_INIT(I,7)= 
     1                AERO_INIT(I,7)+XROW(I,LEV,N)*ROA(I,ILEV)*1.E9
     2                                                    *(1.0-FRA)
                   END IF
                ENDDO
              END DO
           ENDIF
         END DO
      END DO
     
      DO I=IL1,IL2
         IRH= RHROW(I,LEV)*100.0
         AE_EXT =      3.0*COEFF(IRH)*AERO_INIT(I,1) +             !SF
     1                 3.0*COEFF(IRH)*AERO_INIT(I,2) +             !NI
     2                 4.0           *AERO_INIT(I,3) +             !OC   
     3                 1.0           *AERO_INIT(I,5) +             !SD
     4                 10.           *AERO_INIT(I,4) +             !BC 
     5                 0.6           *AERO_INIT(I,7) +             !CM
c     6                 10.0                                        !GASES       
c zch rayley scattering modifed for China, should be smaller when 
c       the aerosol are all right

     6                 40.0                                        !GASES     
     
         
         IF (AE_EXT .GT. 0.0) THEN
            XROW(I,LEV,IVIS)=3912.0/AE_EXT
         ELSE
            XROW(I,LEV,IVIS)=100.0                                 !DEFAULT VISIBILITY: 400 KM
         END IF
      END DO
      RETURN
      END
