!------------------------------------------------------------------
!                      MAIN PROGRAM FOR CUACE_ADJ
!
!  HISTORY:
!  
!  1.2014.6.2    ZHAISHIXIAN, JINMIN, ANXINGQIN 
!
!                AEROSOL_DRIVER.OK.DOUBLE IS A WELL BUILT MAIN PROGRAM, 
!                BUT WITHOUT TRANSPORT PROCESSES FROM THE DYN_GRAPES.
!
!  2.2014.6.12   ZHAISHIXIAN, JINMIN, ANXINGQIN
!
!                START TO INSERT TRANSPORT PROCESSES FROM DYN_GRAPES
!                INTO THIS DIR
!
!  3.2014.9.30   ZHAISHIXIAN, JINMIN, ANXINGQIN 
!               
!                THE ADJOINT CODES OF TRANSPORTATION PROCESSES HAVE
!                BEEN SUCCESSFULLY BUILT.
!                INCLUDING:
!
!  Four initial data:
!                     before_camaerosol[itimestep].grd,
!                     before_phy_prep[itimestep].grd,
!                     before_qmsl[itimestep].grd,
!                     before_upstream[itimestep].grd
!  Six SUBROUTINEs: 
!                     CALL phy_prep
!                     CALL ad_phy_prep
!                     CALL AD_BS_QMSL
!                     CALL upstream_interp
!                     CALL AD_UPSTREAM_INTERP
!                     CALL ad_phy_post_back
!  
!  NOTES:  CHANGES MIGHT HAVE BEEN MADE FOR DIFFERENT SIMULATIONS
!                          
!------------------------------------------------------------------
   PROGRAM AEROSOL_DRIVER 

   IMPLICIT NONE

   INTEGER       ids,ide, jds,jde, kds,kde, &
                 ims,ime, jms,jme, kms,kme, &
                 its,ite, jts,jte, kts,kte

   INTEGER       number_tracer,num_tracer
   
   INTEGER       num_soil_texture

   INTEGER       num_clay
  
   INTEGER       num_desert 

   INTEGER       num_landuse

   INTEGER       num_emission

   INTEGER       JULDAY,itimestep  


!   PARAMETER(ids =1,ide =230, jds =1,jde =100, kds =1,kde =32,&
!             ims =55,ime =91, jms =83,jme =97, kms =0,kme =32,&
!             its =59,ite =87, jts =87,jte =93, kts =1,kte =31)
!!!!!!!!!!!!!!!!!4*32cpu
!    PARAMETER(ids =1,ide =230, jds =1,jde =100, kds =1,kde =32,&
!              ims =140,ime =176, jms =41,jme =54, kms =0,kme =32,&
!              its =144,ite =172, jts =45,jte =50, kts =1,kte =31)
!
     PARAMETER(ids =1,ide =41, jds =1,jde =23, kds =1,kde =32,&
               ims =-3,ime =45, jms =-3,jme =27, kms =0,kme =32,&
               its =1,ite =41, jts =1,jte= 23, kts =1,kte =31)
!!!!!!!!!!!4*8cpu
!      PARAMETER(ids =1,ide =230, jds =1,jde =100, kds =1,kde =32,&
!                ims =112,ime =176, jms =35,jme =54, kms =0,kme =32,&
!                its =116,ite =172, jts =39,jte =50, kts =1,kte =31)
       PARAMETER(number_tracer =150,num_soil_texture =12,&
                 num_clay =2,num_desert =6,&
                 num_landuse =15,num_emission =96,&
                 JULDAY =183)                                          !jinmin 20110702

   REAL        DEGRAD,             &
                                       XTIME,DECLIN,SOLCON
!
   REAL, DIMENSION( ims:ime, kms:kme, jms:jme )                  &
          ::                                   P3D,p3db, &
					        	    pi3D, &
					t_phyb ,         t_phy, &
					 qv3db,       	    QV3D, &
					 qc3db,       	    QC3D, &
               	       fktm,dz8w,U3D,V3D,W3D,RHO3D,CLDFRA3D

   REAL, DIMENSION( ims:ime, kms:kme, jms:jme )  ::          &
                                                             p8w, &
                                                            p8wb, &
                                                           p_phy, &
                                                          p_phyb, &
                                                          pi_phy, &
                                                           u_phy, &
                                                           v_phy, &
                                                               w, &
                                                             t8w, &
                                                         rho_phy, &
                                                          CLDFRA


   REAL,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer)            &
          ::           tracer_post,tracer  


!xuemin
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme)                       &
          ::                                    umf3d, &
                                                           uer3d, &
                                                           udr3d, &
                                                           dmf3d, &
                                                           der3d
!CSLG
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme)                       &
          ::                                 cld_fn3d, &
                                                            ww3d, &
                                                            mc3d, &
                                                            dp3d, &
                                                           zfg3d, &
                                                           mc3db, &
                                                           dp3db, &
                                                          zfg3db 
!CSLG
   REAL, DIMENSION( ims:ime, jms:jme )                           &
          ::                             dsubcld2d,dsubcld2db, &
                            esp02d,    mb2d,mb2db

   INTEGER, DIMENSION( ims:ime, jms:jme )                           &
           ::                               ideep2d , &
                                                            jt2d, &
                                                          maxg2d, &
                                                            jd2d
   INTEGER, DIMENSION(jms:jme )   ::     lengath1d

! zch 20100224
   REAL, DIMENSION(ims:ime,kms:kme,jms:jme) ::   PSO43d
   REAL, DIMENSION(ims:ime,kms:kme,jms:jme) ::   PSOA3d

   REAL,DIMENSION(ims:ime,jms:jme,num_soil_texture)              &
          ::                                     sand2
  
   REAL,DIMENSION(ims:ime,jms:jme,num_clay)                      &
          ::                                     clay2

   REAL,DIMENSION(ims:ime,jms:jme,num_desert)                    &
          ::                                     sand6

   REAL,DIMENSION(ims:ime,jms:jme,num_landuse)                   &
          ::                                     fland

   REAL,DIMENSION(ims:ime,jms:jme,num_emission)                   &
          ::                                     emission 

   REAL,DIMENSION(ims:ime,jms:jme,number_tracer)                   &
          ::                                   sfdust,  &
                                                           gdrem1,  &
                                                           gdrem2,  &
                                                           gdrem3
   REAL, DIMENSION( ims:ime, kms:kme, jms:jme )                    &
          ::                                TU 



   REAL,DIMENSION(ite-its+1,num_soil_texture) ::             sand2_2d      

   REAL,DIMENSION(ite-its+1,num_clay)         ::             clay2_2d       

   REAL,DIMENSION(ite-its+1,num_desert)       ::             sand6_2d

   REAL,DIMENSION(ite-its+1,num_landuse)      ::             fland_2d 
   
   REAL,DIMENSION(ite-its+1,3,2)              ::             BLCROW
   
   REAL,DIMENSION(ite-its+1,3,2)              ::             OMCROW
!zch 20100224
   REAL,DIMENSION(ite-its+1,3,2)              ::             RRDROW
   
   REAL,DIMENSION(ite-its+1)                  ::             ASO2ROW 
   REAL,DIMENSION(ite-its+1)                  ::             PSO2ROW 
   REAL,DIMENSION(ite-its+1)                  ::             POSO2ROW 
   REAL,DIMENSION(ite-its+1)                  ::             ASO4ROW 
   REAL,DIMENSION(ite-its+1)                  ::             PSO4ROW 
   REAL,DIMENSION(ite-its+1)                  ::             POSO4ROW 
   REAL,DIMENSION(ite-its+1)                  ::             DMSOROW 
   REAL,DIMENSION(ite-its+1)                  ::             DMSLROW 
   REAL,DIMENSION(ite-its+1)                  ::             H2SROW 
   REAL,DIMENSION(ite-its+1,2)                ::             VOLCROW 
   REAL,DIMENSION(ite-its+1)                  ::             ANO3ROW
   REAL,DIMENSION(ite-its+1)                  ::             PNO3ROW
   REAL,DIMENSION(ite-its+1)                  ::             PONO3ROW

   REAL,DIMENSION(ite-its+1,number_tracer)    ::             rsfdust, &
                                                             gdrem1_2d, &
                                                             gdrem2_2d, &
                                                             gdrem3_2d



!
   REAL, DIMENSION( ims:ime, jms:jme )                           &
          ::                                  XLAT, &
                                                           XLONG, &
                         u10,v10,TMN,SMSTOT,SNOW2D,ICE2D,albedo,    &
                         snow2db,ice2db
! xuemin
   REAL, DIMENSION( ims:ime,  kms:kme,jms:jme )                &
          ::                                      prate1,&
                                                             prate2

   REAL, DIMENSION( ims:ime, kms:kme, jms:jme )              &
          ::                                wrscav,&
                                                       zfprec,&
                                                       wpevpa


   REAL, DIMENSION( ims:ime, jms:jme )                           &
          ::                                raincv,rainncv 

!
   REAL, DIMENSION( ims:ime, jms:jme )                           &
          ::                                      GSW
!
   REAL                                   dt,GMT
!
 
! LOCAL VARS
 
   REAL, DIMENSION( ite-its+1 ) ::                                  &
                                                              ts, &
                                                            cosz, &
          snow,ice,surfwd,ftsoil,ffdss,lat_deg,long_deg,fhs,psfc, &
                                                          albs
!xuemin
 REAL, DIMENSION( ite-its+1,kts:kte-1,2 ) ::              prate_2d
 REAL, DIMENSION( ite-its+1,kts:kte-1 )::              &
                                                       wrscav_2d,&
                                                       zfprec_2d,&
                                                       wpevpa_2d

!SLG
   REAL, DIMENSION( ite-its+1 ) ::                                &
                                                         dsubcld, &
                                       esp0,mb
   INTEGER, DIMENSION( ite-its+1 ) ::                           &
                                                         ideep, &
                                                            jt, &
                                                          maxg, &
                                                            jd
    INTEGER lengath

   REAL, DIMENSION( ite-its+1,2 ) ::                        qr
!   REAL, DIMENSION( ite-its+1,kts:kte-1 ) ::                mu,eu 
!
   REAL, DIMENSION( ite-its+1, kts:kte ) ::                     O3
!
   REAL, DIMENSION( ite-its+1, kts:kte+1 ) ::                    &
						           P8W2D
  
   REAL, DIMENSION( ite-its+1, kts:kte ) ::                       &
        						    SH2D, &
        						    QC2D, &
						             P2D, &
        						     T2D, &
        						     U2D, &
        						     V2D, &
        						     W2D, &
                                                           RHO2D, &
                         fktm2d,sig,hght,fmodv,fdz,frclds,frcldc, &
                                                          fcld2D

   REAL, DIMENSION(ite-its+1,kts:kte-1) :: umf,uer,udr,dmf,der   

!CSLG
   REAL, DIMENSION(ite-its+1,kts:kte-1) :: cld_fn,ww,mc,dp,zfg
   REAL, DIMENSION( ite-its+1, kts:kte,number_tracer) :: aero_tr
   REAL, DIMENSION( ite-its+1, kts:kte)               :: TU_2D  
!zch 20100224
   REAL, DIMENSION( ite-its+1, kts:kte) ::  pso4,psoa

   INTEGER :: i,j,k,nk,l,n,ii,testid
   REAL    :: xt24,tloctm,hrang,xxlat

!  added by zhaisx

   real,dimension(ims:ime,jms:jme) :: gswb,xlatb,xlongb,  &
                                      u10b,v10b

   REAL,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer)  &
      ::   tracerb,sfdustb,gdrem1b,gdrem2b,gdrem3b,       &
           tracer_full,tracer_fullb

   REAL,DIMENSION(ims:ime,jms:jme)&
      ::   tracer_ob

   REAL,DIMENSION(ims:ime,kms:kme,jms:jme,num_landuse)    &
      ::   flandb

   REAL,DIMENSION(ims:ime,jms:jme,num_emission)   &
      ::   emissionb

!zhaisx

   INTEGER n_moist,P_QV,P_QC,ADJ,OUTPUT
   PARAMETER(n_moist=4,P_QV=2,P_QC=3)

   REAL,DIMENSION(ims:ime,kms:kme,jms:jme,n_moist) ::  moist
   INTEGER KTOTAL,K_END
   INTEGER config_flags
   PARAMETER(config_flags = 0)

!zhaisx2014.3.19

   character*2 type(7)
   character*1,cnum
   DATA type/'BC','OC','SD','SS','SF','NT','AM'/
   integer itype,naero,ngas,isize,inum
   parameter(naero=6,ngas=5,isize=12)
   character(len=3)::itimestepper
   INTEGER step,num_emis,k_num

   PARAMETER(KTOTAL=864,K_END=1)

!   REAL,DIMENSION(ims:ime, jms:jme, num_emission,KTOTAL) :: emissionb_t
!   REAL,DIMENSION(ims:ime, kms:kme,jms:jme,number_tracer,KTOTAL)::tracerb_t
!object function definition
   INTEGER NTR_ST,NTR_ED,k_ob
   INTEGER i_ob1,j_ob1,i_ob2,j_ob2,i_ob3,j_ob3,i_ob4,j_ob4
   INTEGER i_ob5,j_ob5,i_ob6,j_ob6,i_ob7,j_ob7,i_ob8,j_ob8
!here set k_ob=3 is because 1000hPa level is k=3
   PARAMETER(NTR_ST=1,NTR_ED=12,K_OB=3)

   PARAMETER(i_ob1=22,j_ob1=16,i_ob2=23,j_ob2=16,i_ob3=23,j_ob3=17,i_ob4=24,j_ob4=16)
   PARAMETER(i_ob5=24,j_ob5=17,i_ob6=24,j_ob6=18,i_ob7=25,j_ob7=17,i_ob8=25,j_ob8=18)
!   PARAMETER(i_ob1=24,j_ob1=16,i_ob2=24,j_ob2=16,i_ob3=24,j_ob3=16,i_ob4=24,j_ob4=16)
!   PARAMETER(i_ob5=24,j_ob5=16,i_ob6=24,j_ob6=16,i_ob7=24,j_ob7=16,i_ob8=24,j_ob8=16)
   PARAMETER(ADJ=1,OUTPUT=1)
   character(len=3)::ktotaller


!   REAL,DIMENSION(ims:ime,kms:kme,jms:jme)                &
!      ::                                      zfg3db,     &
!                                              mc3db,      &
!                                              dp3db,      &   
!
   REAL INNER
   EXTERNAL Initial
!zhaisx BS_QMSL20140618
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme) :: xstw,ystw,zstw,&
                                            xstwb,ystwb,zstwb
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer) :: ah_tracer,al_tracer
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer) :: ah_tracerb,al_tracerb
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer) :: qmodify_tracer
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme,number_tracer) :: qmodify_tracerb
   
   
   INTEGER :: ix,iy,iz
   INTEGER :: jj,kk,kkk
   INTEGER :: ist,ied,jst,jed,kst,ked

   REAL,DIMENSION(:,:,:),allocatable :: x,y,z
      REAL :: pi,xd,x0,yd,y0,ra
      REAL,DIMENSION(ids:ide) :: alon
      REAL,DIMENSION(jds:jde) :: alat
 !
 !zhl added
    REAL :: rmax_tracer,rmin_tracer,qp_tracer,qm_tracer,pp_tracer,CCOEF_tracer
 !
    LOGICAL OFIRST
    data OFIRST/.true./
    INTEGER :: mrec

!  print*,'----before call aeroexe1-------------kts', kte
!    print *,ids,ide, jds,jde, kds,kde,                    &
!                    ims,ime, jms,jme, kms,kme,                    &
!                    its,ite, jts,jte, kts,kte  
     write(ktotaller,'(i3)')KTOTAL
     lengath1d=0
     ideep2d=0
     jt2d=0
     maxg2d=0
     jd2d=0

 !initial:the following initial Adj variables are same to that written by jinmin in aerosol_driver.F(adj)
 !these adj variables are the adj formal parameters 
       print*,'initial ADJ variables itimestep=',itimestep
        gswb=0.0
        xlatb = 0.0
        xlongb =0.0
        t_phyb = 0.0
!        moistb(ims,kms,jms,P_QV) = 0.0
        qv3db = 0.0
        p_phyb = 0.0
        p8wb = 0.0
        SNOW2DB = 0.0
        ICE2DB = 0.0
        u10b = 0.0
        v10b = 0.0
        sfdustb = 0.0
        flandb = 0.0
        gdrem1b = 0.0
        gdrem2b = 0.0
        gdrem3b = 0.0
        mc3db = 0.0
        dp3db = 0.0
        mb2db = 0.0
        zfg3db = 0.0
        dsubcld2db = 0.0

        emissionb = 0.0
!!!!BC belongs to the first 12 size bins
     outer: if(1.eq.1)then   !if 1.eq.0,then J=0,tracerb=0.0
        do j=jts,jte
        do k=kts,kte
         do i=its,ite
          do num_tracer=1,number_tracer 
!             if ((num_tracer.le.NTR_ED).and.(num_tracer.ge.NTR_ST).and.(i.eq.i_ob).and.(j.eq.j_ob).and.(k.eq.k_ob)) then
              if ((num_tracer.le.NTR_ED).and.(num_tracer.ge.NTR_ST).and.(k.eq.k_ob).and.&
!             if ((num_tracer.eq.1).and.&
                (((i.eq.i_ob1).and.(j.eq.j_ob1)).or.&
                 ((i.eq.i_ob2).and.(j.eq.j_ob2)).or.&
                 ((i.eq.i_ob3).and.(j.eq.j_ob3)).or.&
                 ((i.eq.i_ob4).and.(j.eq.j_ob4)).or.&
                 ((i.eq.i_ob5).and.(j.eq.j_ob5)).or.&
                 ((i.eq.i_ob6).and.(j.eq.j_ob6)).or.&
                 ((i.eq.i_ob7).and.(j.eq.j_ob7)).or.&
                 ((i.eq.i_ob8).and.(j.eq.j_ob8)).or.&
                 ((i.eq.i_ob7).and.(j.eq.j_ob4)).or.&
                 ((i.eq.i_ob2).and.(j.eq.j_ob6))).and.&
                  (k.eq.k_ob)) then
              tracer_fullb(i,k,j,num_tracer)=1.0
             else 
              tracer_fullb(i,k,j,num_tracer)=0.0
             endif 
          enddo
         enddo
        enddo
        enddo
          else
            tracer_fullb=0.0
     end if outer

     101 FORMAT(23(41E20.10/))
     102 FORMAT(31(49E30.10/))

     open(69,file='/cma/g5/Tzhoulx/grapes_cuace_OK/run/savedat/parame.grd',form='unformatted')
     read(69)dt,xlat,xlong
     close(69)

     open(50,file='./../result_data/emissionb1_12.grd',form='unformatted')
     open(51,file='./../result_data/tracerb.grd',form='unformatted')

     DO step = KTOTAL,K_END,-1

     print*,'-------------------------------------------------------------------------'
     print*,'step=',step
     write(itimestepper,'(i3)')step
     print*,'itimestepper',itimestepper
     print*,'trim(adjustl(itimestepper))',trim(adjustl(itimestepper))
     print*,'-------------------------------------------------------------------------'

!!------------------------------tracer_fullb --> tracerb------------------------------------------------!
       print*,'zhaisx before data_before_camaerosol sum(tracer_fullb)=',sum(tracer_fullb)
       CALL ad_phy_post_back (tracer_fullb,      & ! wangh for tracer
                       tracerb,                     &
                       number_tracer,                        &
                       ids, ide, jds, jde, kds, kde,         &
                       ims, ime, jms, jme, kms, kme,         &
                       its, ite, jts, jte, kts, kte   )             
      print*,'zhaisx before data_before_camaerosol sum(tracerb)=',sum(tracerb)
      CALL data_before_camaerosol(GSW,              &
                          ALBEDO,t_phy,               &
                          QV3D,QC3D,                  &
     !                     moist,      &
                          p_phy,p8w,dz8w,pi_phy,CLDFRA,      &
                          u_phy,v_phy,w, rho_phy,     & 
                          GMT,XTIME,DECLIN,SOLCON,   &
                          SNOW2D,ICE2D,                      &
                          prate1,prate2,raincv,rainncv,     & 
                          TMN,u10,v10,SMSTOT,fktm,           &
                          TRACER,sfdust,  &
     ! wh for dust  
                          sand2,clay2,sand6,fland,emission,                 &
                          gdrem1,gdrem2,gdrem3,TU,                      &
                          umf3d,uer3d,udr3d,dmf3d,der3d,                  &
                          wrscav,zfprec,wpevpa,                           &
     !CSLG
                        cld_fn3d,ww3d,mc3d,dp3d, mb2d,esp02d,zfg3d,    &    
                        dsubcld2d,         &
     !zch 20100224 for PSO4 and PSOA
                           pso43d,psoa3d,              &

                        ids,ide, jds,jde, kds,kde,                    &
                        ims,ime, jms,jme, kms,kme,                    &
                        its,ite, jts,jte, kts,kte,                    &
                        number_tracer,num_soil_texture,               &
                        num_clay,num_desert,                          &
                        num_landuse,num_emission,                     &
                        JULDAY,step) 


     print*,'dt=',dt
     print*,'DECLIN',DECLIN

!    only when itimestep is in increasing array can integration proceed
     itimestep=KTOTAL-step+1

               call CAMAEROSOL_B(itimestep, dt, gsw, gswb, xlat, xlatb, xlong, &
               xlongb,albedo,t_phy,t_phyb,qv3d,qv3db,   &
               qc3d,p_phy,p_phyb,p8w,p8wb,    &
               dz8w,pi_phy,cldfra,u_phy,v_phy,w, rho_phy,GMT,JULDAY,XTIME,      &
               DECLIN,SOLCON,SNOW2D,SNOW2DB,ICE2D,ICE2DB,prate1,prate2,raincv,  &
               rainncv,TMN,u10,u10b,v10,v10b,SMSTOT,fktm,DEGRAD,number_tracer,  &
               num_emission,TRACER,TRACERB,sfdust,sfdustb,num_soil_texture,     &
               num_clay,num_desert,num_landuse,sand2,clay2,sand6,fland,flandb,  &
               emission,emissionb,gdrem1,gdrem1b,gdrem2,gdrem2b,gdrem3,gdrem3b, &
               TU,umf3d,uer3d,udr3d,dmf3d,der3d,wrscav,zfprec,wpevpa, cld_fn3d, &
               ww3d,mc3d,mc3db,dp3d,dp3db,mb2d,mb2db,esp02d,zfg3d,zfg3db,       &
               dsubcld2d,dsubcld2db,ideep2d, jt2d, maxg2d, jd2d,lengath1d,      &
               pso43d,psoa3d,ids,ide, jds,jde, kds,kde,ims,ime, jms,jme, kms,   &
               kme,its,ite, jts,jte, kts,kte) 

!zhaisx 2014.9.30-------------------------------------------------------------------------------------------------------
!       open(31,file='/cma/g5/Tzhoulx/grapes_cuace_OK/run/savedat/phy_prep/before_phy_prep'//trim(adjustl(itimestepper))//'.grd',form='unformatted')
!       read(31)tracer_full
!       close(31)
!zhaisx 2014.10.04
       CALL DATA_BEFORE_PHY_PREP(tracer_full,&
                        ids,ide, jds,jde, kds,kde,                    &
                        ims,ime, jms,jme, kms,kme,                    &
                        its,ite, jts,jte, kts,kte,                    &
                        number_tracer,num_soil_texture,               &
                        num_clay,num_desert,                          &
                        num_landuse,num_emission,                     &
                        JULDAY,step) 
       
!zhaisx 2014.9.30------------------------ tracer_full --> tracer -------------------------------------------------------
       CALL phy_prep(tracer_full,tracer,    &
                     number_tracer,                            &
                     ids, ide, jds, jde, kds, kde,             &
                     ims, ime, jms, jme, kms, kme,             &
                     its, ite, jts, jte, kts, kte )

!zhaisx 2014.9.30 ------------------------ tracerb --> tracer_fullb ----------------------------------------------------
       CALL ad_phy_prep (tracer_fullb,tracerb,    &
                     number_tracer,                            &
                     ids, ide, jds, jde, kds, kde,             &
                     ims, ime, jms, jme, kms, kme,             &
                     its, ite, jts, jte, kts, kte )

!zhaisx 2014.6.14 ---------------------ajoint for transport begin---------------------------------!
!initial
         al_tracerb=0.0d0
         qmodify_tracerb=0.0d0
         ah_tracerb=0.0d0

!---------------------------tracer_fullb --> al_tracerb & qmodify_tracerb -------------------------!
!tracer(i,k,j,kk)=al_tracer(i,k,j,kk)+qmodify_tracer(i,k,j,kk)
               DO j=jts,jte
                  DO k=kts,kte+1
                     DO i=its,ite
                      DO kk=1,number_tracer
                        al_tracerb(i,k,j,kk)=al_tracerb(i,k,j,kk)+tracer_fullb(i,k,j,kk)
                        qmodify_tracerb(i,k,j,kk)=qmodify_tracerb(i,k,j,kk)+tracer_fullb(i,k,j,kk)
                        tracer_fullb(i,k,j,kk)=0.0
                      ENDDO
                     ENDDO
                  ENDDO
               ENDDO
!!zhaisx print
       
              print*,'al_tracerb(i_ob1,k_ob,j_ob1,1)',al_tracerb(i_ob1,k_ob,j_ob1,1)
              print*,'ah_tracerb(i_ob1,k_ob,j_ob1,1)',ah_tracerb(i_ob1,k_ob,j_ob1,1)
              print*,'qmodify_tracerb(i_ob1,k_ob,j_ob1,1)',qmodify_tracerb(i_ob1,k_ob,j_ob1,1)
      
!!!------------------------------------------------------------------------------------!
!       open(71,file='/cma/g5/Tzhoulx/grapes_cuace_OK/run/savedat/qmsl/before_qmsl'//trim(adjustl(itimestepper))//'.grd',form='unformatted')
!       read(71)ah_tracer,al_tracer,tracer, & 
!                      xstw,ystw,zstw
!       close(71)
        CALL DATA_BEFORE_QMSL(ah_tracer,al_tracer,tracer_full,xstw,ystw,zstw,&
                        ids,ide, jds,jde, kds,kde,                    &
                        ims,ime, jms,jme, kms,kme,                    &
                        its,ite, jts,jte, kts,kte,                    &
                        number_tracer,num_soil_texture,               &
                        num_clay,num_desert,                          &
                        num_landuse,num_emission,                     &
                        JULDAY,step) 


!----------------------in BS_QMSL: al_tracer & ah_tracer --> qmodify_tracer --------------------!
!!!--------------------AD_BS_QMSL: qmodify_tracerb --> al_tracerb & ah_tracerb-----------------------!

                CALL AD_BS_QMSL (ah_tracer,ah_tracerb,al_tracer,al_tracerb,&
                                 number_tracer,tracer_full,&
                                 qmodify_tracer,qmodify_tracerb,&
                                 xstw,ystw,zstw,&
                                 ids,ide,jds,jde,kds,kde, &
                                 ims,ime,jms,jme,kms,kme, &
                                 its,ite,jts,jte,kts,kte)
!!!zhaisx print

              print*,'al_tracerb(i_ob1,k_ob,j_ob1,1)',al_tracerb(i_ob1,k_ob,j_ob1,1)
              print*,'ah_tracerb(i_ob1,k_ob,j_ob1,1)',ah_tracerb(i_ob1,k_ob,j_ob1,1)
              print*,'qmodify_tracerb(i_ob1,k_ob,j_ob1,1)',qmodify_tracerb(i_ob1,k_ob,j_ob1,1)

!!!!-------------------------------------------------------------------------------------------------------------!
!       open(72,file='/cma/g5/Tzhoulx/grapes_cuace_OK/run/savedat/upstream/before_upstream'//trim(adjustl(itimestepper))//'.grd',form='unformatted')
!       read(72)xstw,ystw,zstw,tracer,ah_tracer,al_tracer
!       close(72)
       CALL DATA_BEFORE_UPSTREAM_INTERP(xstw,ystw,zstw,tracer_full,ah_tracer,al_tracer,&
                        ids,ide, jds,jde, kds,kde,                    &
                        ims,ime, jms,jme, kms,kme,                    &
                        its,ite, jts,jte, kts,kte,                    &
                        number_tracer,num_soil_texture,               &
                        num_clay,num_desert,                          &
                        num_landuse,num_emission,                     &
                        JULDAY,step) 

!       call PUSHREAL8ARRAY(tracer,(ime-ims+1)*(kme-kms+1)*(jme-jms+1)*number_tracer)
!       call PUSHREAL8ARRAY(ah_tracer,(ime-ims+1)*(kme-kms+1)*(jme-jms+1)*number_tracer)
!       call PUSHREAL8ARRAY(al_tracer,(ime-ims+1)*(kme-kms+1)*(jme-jms+1)*number_tracer)
!       there is no need to push and pop before upstream_interp and after upstream_interp

       print*,'tracer_full(i_ob1,k_ob,j_ob1,1)before upstream_interp',tracer_full(i_ob1,k_ob,j_ob1,1)
       print*,'tracer_full(i_ob1,k_ob,j_ob1,2)before upstream_interp',tracer_full(i_ob1,k_ob,j_ob1,2)

!!!!-------------------------------tracer_full --> ah_tracer & al_tracer ----------------------------------------!       
       CALL upstream_interp(config_flags,   &
                           xstw,ystw,zstw, &
                           tracer_full,number_tracer, &
                           ah_tracer,al_tracer,  &
                           ids,ide,jds,jde,kds,kde, &
                           ims,ime,jms,jme,kms,kme, &
                           its,ite,jts,jte,kts,kte)
      
       print*,'tracer(i_ob1,k_ob,j_ob1,1)after upstream_interp',tracer(i_ob1,k_ob,j_ob1,1)
       print*,'tracer(i_ob1,k_ob,j_ob1,2)after upstream_interp',tracer(i_ob1,k_ob,j_ob1,2)
!       call POPREAL8ARRAY(al_tracer,(ime-ims+1)*(kme-kms+1)*(jme-jms+1)*number_tracer)
!       call POPREAL8ARRAY(ah_tracer,(ime-ims+1)*(kme-kms+1)*(jme-jms+1)*number_tracer)
!       call POPREAL8ARRAY(tracer,(ime-ims+1)*(kme-kms+1)*(jme-jms+1)*number_tracer)

!-------------------------------ah_tracerb & al_tracerb --> tracer_fullb ----------------------------------------!       
       CALL AD_UPSTREAM_INTERP(config_flags,    &
                              xstw,xstwb,ystw,ystwb,zstw,zstwb,  &
                              tracer_full,tracer_fullb,number_tracer,      &
                              ah_tracer,ah_tracerb,              &
                              al_tracer,al_tracerb,              &
                              ids,ide,jds,jde,kds,kde, &
                              ims,ime,jms,jme,kms,kme, &
                              its,ite,jts,jte,kts,kte)
       print*,'after call ad_upstream_interp'

!-------------------------------------DATA SAVING-----------------------------------------------------------------
      write(50)(((emissionb(i,j,num_emis),i=its,ite),j=jts,jte),num_emis=1,num_emission)
!      write(51)((((tracerb(i,k,j,num_tracer),i=its,ite),k=kts,kte),j=jts,jte),num_emis=1,num_emission)          
        do i=ims,ime
         do j=jms,jme
          do num_emis=1,num_emission
!             emissionb_t(i,j,num_emis,step)=emissionb(i,j,num_emis)
             emissionb(i,j,num_emis)=0.0
          enddo
         enddo
        enddo

    if(step == 1)then
      close(50)
      close(51)
    endif

  ENDDO!step = KTOTAL,K_END,-1

!      open(10,file='emissionb_t.grd',form='unformatted')
!      do step= k_end,ktotal
!      do num_emis=1,num_emission
!      write(10)((emissionb_t(i,j,num_emis,step),i=ims,ime),j=jms,jme)
!      enddo
!      enddo
!      close(10)
!      open(10,file='./../result_data/emissionb_t.grd',form='unformatted')
!      write(10)emissionb_t
!      close(10)
!
!      open(10,file='./../result_data/tracerb_t.dat',form='unformatted')
!      do step= k_end,ktotal
!      write(10)((tracerb_t(i,k_ob,j,1,step),i=its,ite),j=jts,jte)
!      enddo
!      close(10)


   print*,'finish'


   END
