C        Generated by TAPENADE     (INRIA, Tropics team)
C  Tapenade 3.5 (r3931) - 24 May 2011 16:28
C
C  Differentiation of aeroprop in reverse (adjoint) mode:
C   gradient     of useful results: pdepv fr1 fmso phiaw1 phix
C                phit_ fmo amw aerosize pdiff awx nu_ mw_ aeronum
C                bmix anu recry_ frc rhsize deliq_ fc recrys rhop
C                deliqs totmas trwtrow a
C   with respect to varying inputs: pdepv fr1 fmso phiaw1 phix
C                phit_ fmo throw amw aerosize pdiff awx nu_ mw_
C                aeronum bmix anu shj recry_ rhop0 frc rhsize deliq_
C                fc recrys rhop rhrow deliqs rgrid totmas trwtrow
C                pressg roarow a
C   RW status of diff variables: pdepv:in-out fr1:in-out fmso:in-out
C                phiaw1:in-out phix:in-out phit_:in-out fmo:in-out
C                throw:out amw:in-out aerosize:incr pdiff:in-out
C                awx:in-out nu_:incr mw_:incr aeronum:in-out bmix:in-out
C                anu:in-out shj:out recry_:incr rhop0:out frc:in-out
C                rhsize:in-out deliq_:incr fc:in-out recrys:in-out
C                rhop:in-out rhrow:out deliqs:in-out rgrid:out
C                totmas:in-out trwtrow:in-out pressg:out roarow:out
C                a:in-out
      SUBROUTINE AEROPROP_B(ntr,       ntp,     ilg,      ilev,     il1,
     +                      il2,     isize,  rhsize,  aerosize,    rhop,
     +                    rhop0,     rhrow,   throw,     rgrid, aeronum, 
     +                   totmas,      phix,    iae1,  aeroname, trwtrow,
     +                      fmo,      fmso,  phiaw1,       amw, saverad,
     +                      anu,         a,    bmix,       fr1,      fc,
     +                      frc,       awx,  deliqs,    recrys,  roarow,
     +                      shj,    pressg,   pdiff,     pdepv,     mae,
c     +                    phit_,       mw_,     nu_,    deliq_,  recry_, 
ccccccccc  for ad model  ccccccccccccccc
     +                  rhsizeb, aerosizeb,   rhopb,    rhop0b,  rhrowb,
     +                   throwb,    rgridb,aeronumb,   totmasb,   phixb,
     +                 trwtrowb,      fmob,   fmsob,   phiaw1b,    amwb,
     +                     anub,        ab,   bmixb,      fr1b,     fcb,
     +                     frcb,      awxb, deliqsb,   recrysb, roarowb,
     +                     shjb,   pressgb,  pdiffb,    pdepvb)

c     +                     shjb,   pressgb,  pdiffb,    pdepvb,  phit_b,
c     +                     mw_b,      nu_b, deliq_b,   recry_b) 
      IMPLICIT NONE
      REAL dsr, r3d, frctest, theta, rh, awx1, ppt, rwi, tramass
      REAL dsrb, r3db, frctestb, thetab, rhb, awx1b, pptb, rwib, 
     +     tramassb
      INTEGER iter, itrx, j, nt0, nt, ifound, n, i, no, l
      REAL aw2, pre, amfp, wate, amu, priiv, cfac, prii, taurel
      REAL aw2b, preb, amfpb, wateb, amub, priivb, cfacb, priib, taurelb
      REAL amob, wmas, pop, frx1, aw3, aw4, frx3, dd, ff, bpr
      REAL amobb, wmasb, frx1b, aw3b, aw4b, frx3b, ddb, ffb, bprb
      REAL vv, rayon, asq, ww, tw, g, rgoasq, rgas, rgocp
      REAL vvb
      INTEGER numsol, numins, inext, ilast, il1, il2, isize, ilev
      REAL rsn0, rcut0, rcg0, a0, boltzk, pi, aa, p, cub, aa3, aa1, aa2
      REAL ocfactor, cpresv, avno, rgasi, rgasv, saverad
      INTEGER ntr, ntp, ilg, iae1, mae, numtypes
      REAL cpres, am
      PARAMETER (numsol=4, numins=2, numtypes=numsol+numins)
      REAL rhrow(ilg, ilev+1), throw(ilg, ilev+1), rhopd(ilg, ilev, 
     +     isize)
      REAL rhrowb(ilg, ilev+1), throwb(ilg, ilev+1)
      REAL rhsize(ilg, ilev, isize), rhop(ilg, ilev, isize), rhop0(ntp)
      REAL rhsizeb(ilg, ilev, isize), rhopb(ilg, ilev, isize), rhop0b(
     +     ntp)
      REAL aerosize(2, isize), rgrid(ilg, ilev, ntr), totmas(ilg, ilev, 
     +     isize)
      REAL aerosizeb(2, isize), rgridb(ilg, ilev, ntr), totmasb(ilg, 
     +     ilev, isize)
      REAL aeronum(ilg, ilev, isize), trwtrow(ilg, ilev, isize)
      REAL aeronumb(ilg, ilev, isize), trwtrowb(ilg, ilev, isize)
      CHARACTER*8 aeroname(ntp), sortname(numtypes)
C FOLLOWING SECTION CONTAINS DATA ARRAYS FOR ALL AEROSOL TYPES
      REAL nu(numtypes), mw(numtypes), phik(numtypes), b(numtypes)
      REAL nub(numtypes), mwb(numtypes), phikb(numtypes)
      REAL deliq(numtypes), recry(numtypes)
      REAL deliqb(numtypes), recryb(numtypes)
      REAL phit(11, numsol)
      REAL phitb(11, numsol)
      REAL nu_(numtypes), mw_(numtypes)
      REAL nu_b(numtypes), mw_b(numtypes)
      REAL deliq_(numtypes), recry_(numtypes)
      REAL deliq_b(numtypes), recry_b(numtypes)
      REAL phit_(11, numsol)
      REAL phit_b(11, numsol)
      CHARACTER*8 namsol(numsol), namins(numins)
C
C FOLLOWING SECTION CONTAINS WORKING ARRAYS   
      REAL avesize(100)
      REAL avesizeb(100)
      REAL fmo(ilg, ilev, isize, ntp), fmso(ilg, ilev, isize)
      REAL fmob(ilg, ilev, isize, ntp), fmsob(ilg, ilev, isize)
      REAL phiaw1(ilg, ilev, isize), amw(ilg, ilev, isize)
      REAL phiaw1b(ilg, ilev, isize), amwb(ilg, ilev, isize)
      REAL anu(ilg, ilev, isize), a(ilg, ilev, isize)
      REAL anub(ilg, ilev, isize), ab(ilg, ilev, isize)
      REAL bmix(ilg, ilev, isize), fr1(ilg, ilev, isize)
      REAL bmixb(ilg, ilev, isize), fr1b(ilg, ilev, isize)
      REAL fc(ilg, ilev, isize), frc(ilg, ilev, isize)
      REAL fcb(ilg, ilev, isize), frcb(ilg, ilev, isize)
      REAL awx(ilg, ilev, isize, 2), phix(ilg, ilev, isize)
      REAL awxb(ilg, ilev, isize, 2), phixb(ilg, ilev, isize)
      REAL deliqs(ilg, ilev, isize), recrys(ilg, ilev, isize)
      REAL deliqsb(ilg, ilev, isize), recrysb(ilg, ilev, isize)
C
      REAL pdiff(ilg, ilev, isize), pdepv(ilg, ilev, isize)
      REAL pdiffb(ilg, ilev, isize), pdepvb(ilg, ilev, isize)
      REAL pressg(ilg), shj(ilg, ilev), roarow(ilg, ilev)
      REAL pressgb(ilg), shjb(ilg, ilev), roarowb(ilg, ilev)
      REAL mww, rw, denw, sfcten
      REAL*8 r, q, d
      REAL*8 rb, qb, db
      INTEGER ntps, numiter, sortnum(numtypes), ln(numtypes)
      LOGICAL deliqcry
C
      COMMON /params/ ww, tw, rayon, asq, g, rgas, rgocp, rgoasq, cpres
     +, rgasv, cpresv
      COMMON /narcm/ avno, rgasi, am, boltzk, pi, aa, a0, rsn0, rcut0, 
     +rcg0, p
      REAL CVMGT
      INTEGER arg1
      LOGICAL arg10
      INTEGER ad_count
      INTEGER i0
      INTEGER branch
      REAL temp3
      REAL temp29
      REAL x3b
      REAL temp2
      REAL y1b
      REAL temp28
      REAL temp1
      REAL temp27
      REAL temp0
      REAL temp26
      INTRINSIC COS
      REAL temp21b
      REAL temp25
      REAL temp24
      INTRINSIC EXP
      REAL temp23
      REAL temp22
      REAL temp21
      REAL y4b
      REAL temp20
      REAL temp16b
      REAL temp24b
      REAL temp40b
      REAL temp30b1
      REAL temp30b0
      REAL temp50
      REAL temp19b
      REAL tempb2
      REAL tempb1
      REAL tempb0
      REAL temp0b
      REAL temp51b
      REAL temp23b0
      REAL x3
      REAL temp3b
      INTRINSIC ABS
      REAL*8 x2
      REAL*8 x1
      REAL temp19
      REAL*8 x2b
      REAL temp2b3
      REAL temp18
      REAL temp16b0
      REAL temp2b2
      REAL temp17
      REAL temp2b1
      REAL temp16
      REAL temp49b
      REAL temp2b0
      REAL temp6b
      REAL*8 temp15
      REAL*8 temp14
      REAL*8 temp13
      REAL*8 temp12
      REAL temp49
      REAL*8 temp11
      REAL y3b
      REAL temp48
      REAL*8 temp10
      REAL temp47
      REAL temp46
      REAL temp23b
      REAL temp45
      REAL temp31b
      REAL temp44
      REAL temp21b2
      REAL temp43
      REAL amax10
      REAL temp21b1
      REAL temp42
      REAL temp21b0
      REAL temp41
      REAL temp40
      REAL temp19b0
      REAL temp34b
      REAL tempb
      INTRINSIC AMAX1
      REAL temp2b
      REAL*8 x1b
      REAL temp41b0
      REAL temp48b
      INTRINSIC LOG
      REAL amax10b
      REAL temp39
      REAL y2b
      REAL*8 temp38
      REAL*8 temp37
      REAL*8 temp34b1
      REAL temp51b2
      REAL temp34b0
      REAL*8 temp36
      REAL temp51b1
      REAL temp3b1
      REAL*8 temp35
      REAL temp51b0
      REAL temp3b0
      REAL temp30b
      REAL*8 temp34
      REAL temp33
      REAL temp32
      INTRINSIC ACOS
      REAL temp31
      REAL temp30
      REAL temp44b3
      INTRINSIC AMIN1
      REAL temp44b2
      REAL temp25b
      REAL temp44b1
      REAL temp44b0
      REAL temp41b
      INTRINSIC MIN
      INTEGER ii4
      REAL*8 temp36b
      INTEGER ii3
      REAL temp44b
      INTEGER ii2
      INTEGER ii1
      INTRINSIC SQRT
      REAL temp
      REAL temp6b0
      REAL temp9
      REAL temp8
      REAL temp39b
      REAL y4
      REAL temp7
      REAL y3
      REAL temp4b
      REAL temp6
      REAL y2
      REAL temp5
      REAL y1
      REAL temp4
      real inner
C AEROSOL TYPE DATA ARE IN THE FOLLOWING ORDER:
C  1. SEA SALT
C  2. (NH4)2SO4
C  3. NH4NO3
C  4. ORGANIC
C  5. BLACK CARBON
C  6. SOIL DUST
C
C NAMSOL ARE THE PERMITTED SOLUBLE AEROSOL NAMES
      DATA namsol /'SEA-SALT', 'SULPHATE', 'NITRATES', 'OMCARBON'/
C NAMINS ARE THE PERMITTED INSOLUBLE AEROSOL NAMES
      DATA namins /'BLCARBON', 'SOILDUST'/
C MW ARE THE MOLECULAR WEIGHTS OF THE DRY AEROSOL COMPONENTS      
      DATA MW_ /67.180, 132.1342, 80.0435, 132.1342, 12.011, 60.08/
C      
C NU ARE THE IONS PER SOLUTE MOLECULE
      DATA NU_ /2.165, 3.0, 2.0, 3.0, 0., 0./
C
C DELIQ IS THE DELIQUESCENCE RELATIVE HUMIDITY
C RECRY IS THE RECRYSTALLIZATION RELATIVE HUMIDITY
      DATA DELIQ_/0.74, 0.80, 0.62, 0.80, 1.1, 1.1/
      DATA RECRY_/0.45, 0.37, 0.25, 0.37, 1.1, 1.1/
C      
C MWW IS THE MOLECULAR WEIGHT OF WATER 
      DATA mww /18.015/
C      
C RW IS THE GAS CONSTANT FOR WATER VAPOUR ( J/(KG K) )
      DATA rw /461.51/
C     
C DENW IS THE DENSITY OF WATER ( KG / M^3 )
      DATA denw /1000./
C      
C SFCTEN IS THE SURFACE TENSION BETWEEN WATER AND AIR ( J / M^2 )
      DATA sfcten /0.076/
C
C NTPS IS THE INDEX NUMBER OF THE LAST SOLUBLE AEROSOL TYPE (<= NTP)
C IF NTPS=NTP THEN THERE ARE NO INSOLUBLE COMPONENTS
C      
C NUMITER IS THE NUMBER OF ITERATIONS PERFORMED FOR KOHLER EQUATION
C NUMITER=2 SHOULD GIVE BETTER THAN 1% ACCURACY
C NUMITER MUST NOT EXCEED THE DECLARED SIZE OF THE LAST INDEX IN AWX
      DATA numiter /2/
C
C OCFACTOR IS A FACTOR USED TO MULTIPLY THE ORGANIC CARBON OSMOTIC
C   COEFFICIENTS TO FORCE A DIFFERENCE FROM SULPHATE
      DATA ocfactor /0.54/
C
C PHIT(J,I) is the phi(aw) table of coefficients
C I is the solute index:
C     1 = sea salt
C     2 = (NH4)2SO4
C     3 = NH4NO3
C     4 = organic
C I MUST BE DIMENSIONED TO EQUAL NTPS
C J is the data :
C  1 = minimum aw for polynomial fit
C  2 = aw break point between two polynomials
C  3 = x^3 coef for aw > awbreak
C  4 = x^2 coef
C  5 = x^1 coef
C  6 = x^0 coef
C  7 = x^4 coef for aw <= awbreak
C  8 = x^3 coef
C  9 = x^2 coef
C  10= x^1 coef
C  11= x^0 coef
      DATA PHIT_/0.44,0.92, 410.74729, -1138.2693, 1049.2792,-320.74562,
     1 -5.79690208, 17.7685336, -22.5253540, 11.8087027, -0.48210984,
     2 0.39, 0.92, 457.060777, -1280.47495, 1194.81750, -370.739425,
     3 -1.62440470, 4.07342346, -5.61205075, 3.873682106, -0.216021389,
     4 0.275, 0.81, 7.6174049, -19.354181, 17.103802, -4.5561686,
     5 -1.1108526, 3.7035588, -5.1408203, 4.0788267, -0.77326108,
     6 0.39, 0.92, 457.060777, -1280.47495, 1194.81750, -370.739425,
     7 -1.62440470, 4.07342346, -5.61205075, 3.873682106, -0.216021389/
C
C  DELIQCRY IS A LOGICAL SWITCH TO HANDLE SIZE IF RH IS BETWEEN
C    CRYSTALLIZATION AND DELIQUESCENCE.  IF =.TRUE. THEN FINAL SIZE IS
C    WEIGHTED AVERAGE BETWEEN DRY AND DELIQUESCED SIZES.  IF =.FALSE.
C    THEN FINAL SIZE IS THE FULLY DELIQUESCED SIZE.
      DATA deliqcry /.false./
      DATA aa1 /1.257/
      DATA aa2 /0.4/
      DATA aa3 /1.1/
      
      phit_b=0.0
      mw_b =0.0
      nu_b = 0.0
      deliq_b = 0.0
      recry_b = 0.0
C
      CALL PUTZERO(rhop, ilg*ilev*isize)
      CALL PUTZERO(totmas, ilg*ilev*isize)
      CALL PUTZERO(fmo, ilg*ilev*isize*ntp)
      CALL PUTZERO(fmso, ilg*ilev*isize)
      CALL PUTZERO(phiaw1, ilg*ilev*isize)
      CALL PUTZERO(amw, ilg*ilev*isize)
      CALL PUTZERO(anu, ilg*ilev*isize)
      CALL PUTZERO(deliqs, ilg*ilev*isize)
      CALL PUTZERO(recrys, ilg*ilev*isize)
C
C
      cub = 1./3.
C        SORT THE AEROSOL NAMES (SOLUBLES FIRST, THEN INSOLUBLES)
      inext = 1
      ilast = ntp
      ad_count = 1
      DO nt=1,ntp
        ifound = 0
        DO j=1,numsol
          IF (aeroname(nt) .EQ. namsol(j)) THEN
            sortnum(inext) = j
            ln(inext) = nt
            inext = inext + 1
            ifound = 1
          END IF
        ENDDO
        IF (ifound .EQ. 0) THEN
          DO j=1,numins
            IF (aeroname(nt) .EQ. namins(j)) THEN
              sortnum(ilast) = j + numsol
              ln(ilast) = nt
              ilast = ilast - 1
              ifound = 1
            END IF
          ENDDO
        END IF
        IF (ifound .EQ. 0) THEN
          GOTO 100
        ELSE
          IF (nt .EQ. ntp) ntps = inext - 1
          ad_count = ad_count + 1
        END IF
      ENDDO
      GOTO 110
 100  CALL PUSHCONTROL1B(1)
      CALL PUSHINTEGER4(ad_count)
      STOP
 110  CALL PUSHCONTROL1B(0)
      CALL PUSHINTEGER4(ad_count)
C
C      DO NT=1,NTP
C         WRITE(6,600) AERONAME(NT),LN(NT),SORTNAME(NT),SORTNUM(NT)
C 600     FORMAT(1X,A8,5X,I1,5X,A8,5X,I1)
C      ENDDO
C
C
C  ADJUST OSMOTIC COEFFICIENTS FOR ORGANIC CARBON
      DO j=3,11
        phit_(j, 4) = ocfactor*phit_(j, 4)
      ENDDO
C  ARRANGE THE DATA ARRAYS IN THE CORRECT ORDER
      DO nt=1,ntp
        mw(nt) = mw_(sortnum(nt))
        nu(nt) = nu_(sortnum(nt))
        deliq(nt) = deliq_(sortnum(nt))
        recry(nt) = recry_(sortnum(nt))
      ENDDO
      DO nt=1,ntps
        DO j=1,11
          phit(j, nt) = phit_(j, sortnum(nt))
        ENDDO
      ENDDO
C
C
C     * TOTAL DRY MASS MIXING RATIO & DRY AEROSOL COMPOSITE DENSITY
C       OF AEROSOL IN EACH BIN
C
C                    m1+m2+m3  
C       RHO = -------------------------
C              m1/rho1+m2/rho2+m3/rho3
C
C       IN THIS DO LOOP, RHOP(*,*,*) IS ONLY HOLDING THE DENOMINATOR
C       OF THIS EQUATION
C
      DO nt=1,ntp
        CALL PUSHINTEGER4(nt0)
        nt0 = ln(nt)
        DO n=1,isize
          CALL PUSHINTEGER4(no)
          no = n + isize*(nt0-1) + (iae1-1)
          DO l=1+mae,ilev
            DO i=il1,il2
              IF (1.0e-33 .LT. rgrid(i, l, no)) THEN
                CALL PUSHREAL8(tramass)
                tramass = rgrid(i, l, no)
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHREAL8(tramass)
                tramass = 1.0e-33
                CALL PUSHCONTROL1B(1)
              END IF
              totmas(i, l, n) = totmas(i, l, n) + tramass
              rhop(i, l, n) = rhop(i, l, n) + tramass/rhop0(nt0)
            ENDDO
          ENDDO
        ENDDO
      ENDDO
C
C
C COMPUTE THE MASS FRACTION OF EACH DRY AEROSOL COMPONENT, FMO 
C     
      DO nt=1,ntp
        CALL PUSHINTEGER4(nt0)
        nt0 = ln(nt)
        DO n=1,isize
          CALL PUSHINTEGER4(no)
          no = n + isize*(nt0-1) + (iae1-1)
          DO l=1+mae,ilev
            DO i=il1,il2
              IF (1.0e-33 .LT. rgrid(i, l, no)) THEN
                CALL PUSHREAL8(tramass)
                tramass = rgrid(i, l, no)
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHREAL8(tramass)
                tramass = 1.0e-33
                CALL PUSHCONTROL1B(1)
              END IF
              fmo(i, l, n, nt) = tramass/totmas(i, l, n)
            ENDDO
          ENDDO
        ENDDO
      ENDDO
C
C
C      COMPUTE PHI AT AW=1 FOR EACH SOLUTE
C      COMPUTE KOHLER B FACTOR FOR EACH SOLUTE
C
      DO nt=1,ntps
        phik(nt) = phit(3, nt) + phit(4, nt) + phit(5, nt) + phit(6, nt)
      ENDDO
C      
C COMPUTE THE SOLUTE MASS FRACTION, FMSO      
C COMPUTE AVERAGE NU AND AVERAGE MOLECULAR WEIGHT OF SOLUBLE PART
C COMPUTE PHI AT AW=1 FOR THE MIXED AEROSOL
C COMPUTE AVERAGE DELIQUESCENCE AND RECRYSTALLIZATION POINTS
C
      DO nt=1,ntps
        DO n=1,isize
          DO l=1+mae,ilev
            DO i=il1,il2
              fmso(i, l, n) = fmso(i, l, n) + fmo(i, l, n, nt)
              amw(i, l, n) = amw(i, l, n) + fmo(i, l, n, nt)/mw(nt)
              anu(i, l, n) = anu(i, l, n) + nu(nt)*fmo(i, l, n, nt)/mw(
     +          nt)
              phiaw1(i, l, n) = phiaw1(i, l, n) + phik(nt)*nu(nt)*fmo(i
     +          , l, n, nt)/mw(nt)
              deliqs(i, l, n) = deliqs(i, l, n) + fmo(i, l, n, nt)*deliq
     +          (nt)
              recrys(i, l, n) = recrys(i, l, n) + fmo(i, l, n, nt)*recry
     +          (nt)
            ENDDO
          ENDDO
        ENDDO
      ENDDO
C
C COMPUTE THE AVERAGE DRY AEROSOL RADIUS, AVESIZE
C
      DO n=1,isize
        CALL PUSHREAL8(rwi)
        rwi = (aerosize(1, n)+aerosize(2, n))/2.0
        CALL PUSHREAL8(r3d)
        r3d = 4.189*rwi*rwi*rwi
        avesize(n) = rwi
        DO l=1+mae,ilev
          DO i=il1,il2
            CALL PUSHREAL8(rhop(i, l, n))
            rhop(i, l, n) = totmas(i, l, n)/rhop(i, l, n)
            IF (fmso(i, l, n) .NE. 0.) THEN
              CALL PUSHREAL8(amw(i, l, n))
              amw(i, l, n) = fmso(i, l, n)/amw(i, l, n)
              CALL PUSHREAL8(anu(i, l, n))
              anu(i, l, n) = anu(i, l, n)*amw(i, l, n)/fmso(i, l, n)
              CALL PUSHREAL8(phiaw1(i, l, n))
              phiaw1(i, l, n) = phiaw1(i, l, n)*amw(i, l, n)/(fmso(i, l
     +          , n)*anu(i, l, n))
              CALL PUSHREAL8(deliqs(i, l, n))
              deliqs(i, l, n) = deliqs(i, l, n)/fmso(i, l, n)
              CALL PUSHREAL8(recrys(i, l, n))
              recrys(i, l, n) = recrys(i, l, n)/fmso(i, l, n)
              CALL PUSHCONTROL1B(0)
            ELSE
              deliqs(i, l, n) = 1.1
              recrys(i, l, n) = 1.1
              CALL PUSHCONTROL1B(1)
            END IF
C
C     * AEROSOL NUMBER CONCENTRATION (#/KG_AIR)
C      NOTE:  4.189 = 4 * PI / 3
C
            aeronum(i, l, n) = totmas(i, l, n)/(r3d*rhop(i, l, n))
          ENDDO
        ENDDO
      ENDDO
C
C
C      WRITE(6,*) 'FMO:'
C      WRITE(6,*) (FMO(1,1,1,M),M=1,NTP)
C      WRITE(6,*) 'FMSO= ',FMSO(1,1,1)
C      WRITE(6,*) 'MW:'
C      WRITE(6,*) (MW(M),M=1,NTP)
C      WRITE(6,*) 'AMW= ',AMW(1,1,1)
C      WRITE(6,*) 'NU:'
C      WRITE(6,*) (NU(M),M=1,NTP)
C      WRITE(6,*) 'ANU= ',ANU(1,1,1)
C      WRITE(6,*) 'RHOP0:'
C      WRITE(6,*) (RHOP0(LN(M)),M=1,NTP)
C
C  COMPUTE KOHLER A' FACTOR AND B FACTOR FOR MIXTURE
C  COMPUTE RADIUS RATIO AT RH=1 (FR1)
C  COMPUTE CRITICAL RADUS RATIO (FRC)
C  COMPUTE CRITICAL RELATIVE HUMIDITY (FC)    
C
C
      DO n=1,isize
        DO l=1+mae,ilev
          DO i=il1,il2
            a(i, l, n) = 2.0*sfcten/(denw*rw*throw(i, l+1)*avesize(n))
            IF (amw(i, l, n) .NE. 0) THEN
              bmix(i, l, n) = anu(i, l, n)*phiaw1(i, l, n)*mww*rhop(i, l
     +          , n)*fmso(i, l, n)/(amw(i, l, n)*denw)
              CALL PUSHCONTROL1B(0)
            ELSE
              bmix(i, l, n) = 0.0
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(q)
            q = -(bmix(i, l, n)/(3.0*a(i, l, n)))
C              R=0.5
            d = q*q*q + 0.25
            IF (d .LT. 0.0 .AND. q .LT. 0.0) THEN
              CALL PUSHREAL8(theta)
              theta = ACOS(0.5/SQRT(-(q*q*q)))
              fr1(i, l, n) = 2.0*SQRT(-q)*COS(theta/3.0)
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(dsr)
              dsr = SQRT(d)
              fr1(i, l, n) = (0.5+dsr)**cub + (0.5-dsr)**cub
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(q)
C
C*******************
C  THIS SECTION CAN BE COMMENTED OUT IF YOU ARE NOT INTERESTED
C    IN COMPUTING THE CRITICAL RADIUS AND CRITICAL RELATIVE HUMIDITY
C
            q = q*3.0
C              R=1.0
            d = q*q*q + 1.0
            IF (d .LT. 0.0 .AND. q .LT. 0.0) THEN
              CALL PUSHREAL8(theta)
              theta = ACOS(1.0/SQRT(-(q*q*q)))
              frc(i, l, n) = 2.0*SQRT(-q)*COS(theta/3.0)
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHREAL8(dsr)
              dsr = SQRT(d)
              frc(i, l, n) = (1.0+dsr)**cub + (1.0-dsr)**cub
              CALL PUSHCONTROL1B(1)
            END IF
            frctest = frc(i, l, n)**3.0
            IF (frctest .EQ. 1.0) THEN
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
          ENDDO
        ENDDO
      ENDDO
C*********************
C
C
C SOLVE FOR THE WET RADIUS AFTER WATER UPTAKE
C
      DO iter=1,numiter
        IF (iter .EQ. 1) THEN
          CALL PUSHINTEGER4(itrx)
          itrx = 1
          CALL PUSHCONTROL1B(0)
        ELSE
          CALL PUSHINTEGER4(itrx)
          itrx = iter - 1
          CALL PUSHCONTROL1B(1)
        END IF
        arg1 = ilg*ilev*isize
        CALL PUSHREAL8ARRAY(phix, ilg*ilev*isize)
        CALL PUTZERO(phix, arg1)
        DO nt=1,ntps
          CALL PUSHREAL8(ppt)
          ppt = nu(nt)/mw(nt)
          DO n=1,isize
            DO l=1+mae,ilev
              DO i=il1,il2
                IF (0.0 .LT. rhrow(i, l+1)) THEN
                  y1 = rhrow(i, l+1)
                  CALL PUSHCONTROL1B(0)
                ELSE
                  CALL PUSHCONTROL1B(1)
                  y1 = 0.0
                END IF
                IF (1.0 .GT. y1) THEN
                  CALL PUSHREAL8(rh)
                  rh = y1
                  CALL PUSHCONTROL1B(0)
                ELSE
                  CALL PUSHREAL8(rh)
                  rh = 1.0
                  CALL PUSHCONTROL1B(1)
                END IF
                IF (iter .EQ. 1) THEN
                  y2 = rh*EXP(-(a(i, l, n)/(0.8*fr1(i, l, n))))
                  IF (1.0 .GT. y2) THEN
                    awx(i, l, n, iter) = y2
                    CALL PUSHCONTROL2B(2)
                  ELSE
                    awx(i, l, n, iter) = 1.0
                    CALL PUSHCONTROL2B(1)
                  END IF
                ELSE
                  CALL PUSHCONTROL2B(0)
                END IF
                CALL PUSHREAL8(awx1)
                awx1 = awx(i, l, n, itrx)
                aw2 = awx1*awx1
                aw3 = awx1*awx1*awx1
                aw4 = aw3*awx1
                arg10 = awx1 .GT. phit(2, nt)
                CALL PUSHREAL8(pop)
                pop = CVMGT(0., 1., arg10)
                phix(i, l, n) = phix(i, l, n) + (1.0-pop)*(phit(3, nt)*
     +            aw3+phit(4, nt)*aw2+phit(5, nt)*awx1+phit(6, nt))*ppt*
     +            fmo(i, l, n, nt) + pop*(phit(7, nt)*aw4+phit(8, nt)*
     +            aw3+phit(9, nt)*aw2+phit(10, nt)*awx1+phit(11, nt))*
     +            ppt*fmo(i, l, n, nt)
              ENDDO
            ENDDO
          ENDDO
        ENDDO
C
C
        DO n=1,isize
          DO l=1+mae,ilev
            DO i=il1,il2
              IF (0.0 .LT. rhrow(i, l+1)) THEN
                y3 = rhrow(i, l+1)
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHCONTROL1B(1)
                y3 = 0.0
              END IF
              IF (1.0 .GT. y3) THEN
                CALL PUSHREAL8(rh)
                rh = y3
                CALL PUSHCONTROL1B(0)
              ELSE
                CALL PUSHREAL8(rh)
                rh = 1.0
                CALL PUSHCONTROL1B(1)
              END IF
              CALL PUSHREAL8(awx1)
              awx1 = awx(i, l, n, itrx)
              IF (fmso(i, l, n) .NE. 0. .AND. awx1 .GT. 0.0) THEN
                CALL PUSHREAL8(phix(i, l, n))
                phix(i, l, n) = phix(i, l, n)*amw(i, l, n)/(fmso(i, l, n
     +            )*anu(i, l, n))
                CALL PUSHREAL8(frx1)
                frx1 = (1.0-anu(i, l, n)*phix(i, l, n)*mww*rhop(i, l, n)
     +            *fmso(i, l, n)/(amw(i, l, n)*denw*LOG(awx1)))**cub
                CALL PUSHCONTROL1B(0)
              ELSE
                phix(i, l, n) = 0.
                CALL PUSHREAL8(frx1)
                frx1 = 1.0
                CALL PUSHCONTROL1B(1)
              END IF
C
C*********************
C  THIS SECTION GREATLY IMPROVES ACCURACY FOR RH ~ 1    
C  IT CAN BE COMMENTED OUT IF SPEED IS MORE IMPORTANT THAN ACCURACY
C 
              IF (rh .GT. 0.98 .AND. frx1 .GT. 1.0) THEN
                frx3 = frx1*frx1*frx1
                CALL PUSHREAL8(bpr)
                bpr = anu(i, l, n)*phix(i, l, n)*mww*rhop(i, l, n)*fmso(
     +            i, l, n)*frx3/(amw(i, l, n)*denw*(frx3-1.0))
                CALL PUSHREAL8(q)
                q = -(a(i, l, n)/(3.0*bpr))
                CALL PUSHREAL8(r)
                r = -(LOG(rh)/(2.0*bpr))
                d = q*q*q + r*r
                IF (d .LT. 0.0 .AND. q .LT. 0.0) THEN
                  CALL PUSHREAL8(theta)
                  theta = ACOS(r/SQRT(-(q*q*q)))
                  CALL PUSHREAL8(frx1)
                  frx1 = 1.0/(2.0*SQRT(-q)*COS(theta/3.0))
                  CALL PUSHCONTROL2B(0)
                ELSE
                  x1 = r + SQRT(d)
                  IF (x1 .GE. 0.) THEN
                    CALL PUSHREAL8(vv)
                    vv = x1
                    CALL PUSHCONTROL1B(0)
                  ELSE
                    CALL PUSHREAL8(vv)
                    vv = -x1
                    CALL PUSHCONTROL1B(1)
                  END IF
                  x2 = r - SQRT(d)
                  IF (x2 .GE. 0.) THEN
                    CALL PUSHREAL8(dd)
                    dd = x2
                    CALL PUSHCONTROL1B(0)
                  ELSE
                    CALL PUSHREAL8(dd)
                    dd = -x2
                    CALL PUSHCONTROL1B(1)
                  END IF
                  CALL PUSHREAL8(frx1)
                  frx1 = 1.0/(vv**cub+dd**cub)
                  CALL PUSHCONTROL2B(1)
                END IF
              ELSE
                CALL PUSHCONTROL2B(2)
              END IF
C**********************
C                 
              awx(i, l, n, iter) = rh*EXP(-(a(i, l, n)/frx1))
              rhsize(i, l, n) = avesize(n)*frx1
            ENDDO
          ENDDO
        ENDDO
      ENDDO
C
C
C
C ADJUST SIZE IF RH < DELIQUESCENCE POINT
C COMPUTE THE MEAN DENSITY OF THE WET AEROSOL
C
C
      DO n=1,isize
        DO l=1+mae,ilev
          DO i=il1,il2
            CALL PUSHREAL8(rh)
            rh = rhrow(i, l+1)
            IF (rh .LT. deliqs(i, l, n)) THEN
              IF (rh .LT. recrys(i, l, n)) THEN
                rhsize(i, l, n) = avesize(n)
                CALL PUSHCONTROL2B(3)
              ELSE IF (deliqcry) THEN
                CALL PUSHREAL8(rhsize(i, l, n))
                rhsize(i, l, n) = avesize(n) + (rhsize(i, l, n)-avesize(
     +            n))*(rh-recrys(i, l, n))/(deliqs(i, l, n)-recrys(i, l
     +            , n))
                CALL PUSHCONTROL2B(2)
              ELSE
                CALL PUSHCONTROL2B(1)
              END IF
            ELSE
              CALL PUSHCONTROL2B(0)
            END IF
            ff = avesize(n)/rhsize(i, l, n)
CAssign dry rhop the value for coagd use
            y4 = ff*ff*ff*(rhop(i, l, n)-denw)
            IF (0. .LT. y4) THEN
              amax10 = y4
              CALL PUSHCONTROL1B(0)
            ELSE
              amax10 = 0.
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(rhop(i, l, n))
            rhop(i, l, n) = denw + amax10
C
C COMPUTE THE AEROSOL LIQUID WATER CONTENT OF EACH SIZE BIN: WATE
C ACCUMULATE IT FOR OUTPUT [KG/KG AIR]
C
C
            wmas = 4.189*rhsize(i, l, n)**3*aeronum(i, l, n)*rhop(i, l, 
     +        n)
            IF (0. .LT. wmas - totmas(i, l, n)) THEN
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            CALL PUSHREAL8(amu)
C    AEROSOL GRAVITATIONAL SETTLING VELOCITY
C    AND DIFFUSION COEFFICIENT
C
C     * AIR'S DYNAMIC VISCOSITY
C
            amu = 145.8*1.e-8*throw(i, l+1)**1.5/(throw(i, l+1)+110.4)
C . . . . MID LAYER PRESSURE IN [PASCAL].
            pre = pressg(i)*shj(i, l)
C
C     * MEAN MOLECULAR FREE PATH.
C       K.V. BEARD [1976], J ATM. SCI., 33
C
            amfp = 6.54e-8*(amu/1.818e-5)*(1.013e5/pre)*(throw(i, l+1)/
     +        293.15)**(1./2.)
            CALL PUSHREAL8(prii)
            prii = 2./9.*g/amu
            CALL PUSHREAL8(priiv)
            priiv = prii*(rhop(i, l, n)-roarow(i, l))
            CALL PUSHREAL8(cfac)
C
C     * CUNNINGHAM SLIP CORRECTION FACTOR AND RELAXATION TIME = vg/Grav.
C
            cfac = 1. + amfp/rhsize(i, l, n)*(aa1+aa2*EXP(-(aa3*rhsize(i
     +        , l, n)/amfp)))
            x3 = priiv*rhsize(i, l, n)**2*cfac/g
            IF (x3 .LT. 0.0) THEN
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
          ENDDO
        ENDDO
      ENDDO

      DO ii1=1,ilev+1
        DO ii2=1,ilg
c          throwb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
      DO ii1=1,ilev
        DO ii2=1,ilg
c          shjb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
      DO ii1=1,ilev+1
        DO ii2=1,ilg
c          rhrowb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
      DO ii1=1,ilg
c        pressgb(ii1) = 0.0
      ENDDO
      DO ii1=1,ilev
        DO ii2=1,ilg
c          roarowb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
      DO ii1=1,100
        avesizeb(ii1) = 0.0
      ENDDO
!jinmin
!      RHSIZEB=0.0
!      pdepvb=0.0
      DO n=isize,1,-1
        DO l=ilev,1+mae,-1
          DO i=il2,il1,-1
            taurelb = g*pdepvb(i, l, n)
            pdepvb(i, l, n) = 0.0
            amob = 6.*pi*amu*rhsize(i, l, n)/cfac
            temp51b0 = boltzk*pdiffb(i, l, n)/amob
            throwb(i, l+1) = throwb(i, l+1) + temp51b0
            amobb = -(throw(i, l+1)*temp51b0/amob)
            pdiffb(i, l, n) = 0.0
            temp51b1 = pi*6.*amobb
            temp51b2 = rhsize(i, l, n)*temp51b1/cfac
            rhsizeb(i, l, n) = rhsizeb(i, l, n) + amu*temp51b1/cfac
            amub = temp51b2
            cfacb = -(amu*temp51b2/cfac)
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              x3b = 0.0
            ELSE
              x3b = taurelb
            END IF
            temp51b = rhsize(i, l, n)**2*x3b/g
            priivb = cfac*temp51b
            cfacb = cfacb + priiv*temp51b
            pre = pressg(i)*shj(i, l)
            amfp = 6.54e-8*(amu/1.818e-5)*(1.013e5/pre)*(throw(i, l+1)/
     +        293.15)**(1./2.)
            temp50 = rhsize(i, l, n)
            temp49 = amfp/temp50
            temp48 = rhsize(i, l, n)/amfp
            temp48b = -(aa3*EXP(-(aa3*temp48))*aa2*temp49*cfacb/amfp)
            temp49b = (aa1+aa2*EXP(-(aa3*temp48)))*cfacb/temp50
            rhsizeb(i, l, n) = rhsizeb(i, l, n) + temp48b - temp49*
     +        temp49b + priiv*cfac*2*rhsize(i, l, n)*x3b/g
            CALL POPREAL8(cfac)
            amfpb = temp49b - temp48*temp48b
            CALL POPREAL8(priiv)
            priib = (rhop(i, l, n)-roarow(i, l))*priivb
            rhopb(i, l, n) = rhopb(i, l, n) + prii*priivb
            roarowb(i, l) = roarowb(i, l) - prii*priivb
            CALL POPREAL8(prii)
            temp47 = 1.818e-5*pre
            temp44 = amu/temp47
            temp46 = 1.0/2.
            temp45 = throw(i, l+1)/293.15
            temp44b2 = 1.013e5*6.54e-8*amfpb
            temp44b1 = temp45**temp46*temp44b2/temp47
            amub = amub + temp44b1 - g*2.*priib/(9.*amu**2)
            preb = -(temp44*1.818e-5*temp44b1)
            pressgb(i) = pressgb(i) + shj(i, l)*preb
            shjb(i, l) = shjb(i, l) + pressg(i)*preb
            CALL POPREAL8(amu)
            temp44b3 = 1.e-8*145.8*amub/(throw(i, l+1)+110.4)
            IF (temp45 .LE. 0.0 .AND. (temp46 .EQ. 0.0 .OR. temp46 .NE. 
     +          INT(temp46))) THEN
              throwb(i, l+1) = throwb(i, l+1) + (1.5*throw(i, l+1)**0.5-
     +          throw(i, l+1)**1.5/(throw(i, l+1)+110.4))*temp44b3
            ELSE
              throwb(i, l+1) = throwb(i, l+1) + (1.5*throw(i, l+1)**0.5-
     +          throw(i, l+1)**1.5/(throw(i, l+1)+110.4))*temp44b3 + 
     +          temp46*temp45**(temp46-1)*temp44*temp44b2/293.15
            END IF
            wateb = trwtrowb(i, l, n)
            trwtrowb(i, l, n) = 0.0
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              wmasb = wateb
              totmasb(i, l, n) = totmasb(i, l, n) - wateb
            ELSE
              wmasb = 0.0
            END IF
            temp44b0 = 4.189*rhsize(i, l, n)**3*wmasb
            rhsizeb(i, l, n) = rhsizeb(i, l, n) + aeronum(i, l, n)*rhop(
     +        i, l, n)*4.189*3*rhsize(i, l, n)**2*wmasb
            aeronumb(i, l, n) = aeronumb(i, l, n) + rhop(i, l, n)*
     +        temp44b0
            rhopb(i, l, n) = rhopb(i, l, n) + aeronum(i, l, n)*temp44b0
            ff = avesize(n)/rhsize(i, l, n)
            CALL POPREAL8(rhop(i, l, n))
            amax10b = rhopb(i, l, n)
            rhopb(i, l, n) = 0.0
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              y4b = amax10b
            ELSE
              y4b = 0.0
            END IF
            ffb = (rhop(i, l, n)-denw)*3*ff**2*y4b
            rhopb(i, l, n) = rhopb(i, l, n) + recrysb(i, l, n) + ff**3*
     +        y4b
            recrysb(i, l, n) = 0.0
            temp44b = ffb/rhsize(i, l, n)
            avesizeb(n) = avesizeb(n) + temp44b
            rhsizeb(i, l, n) = rhsizeb(i, l, n) - avesize(n)*temp44b/
     +        rhsize(i, l, n)
            CALL POPCONTROL2B(branch)
            IF (branch .LT. 2) THEN
              IF (branch .EQ. 0) THEN
                rhb = 0.0
              ELSE
                rhb = 0.0
              END IF
            ELSE IF (branch .EQ. 2) THEN
              rh = rhrow(i, l+1)
              CALL POPREAL8(rhsize(i, l, n))
              temp41 = deliqs(i, l, n) - recrys(i, l, n)
              temp41b = rhsizeb(i, l, n)/temp41
              temp43 = rh - recrys(i, l, n)
              temp42 = rhsize(i, l, n) - avesize(n)
              temp41b0 = -(temp42*temp43*temp41b/temp41)
              avesizeb(n) = avesizeb(n) + rhsizeb(i, l, n) - temp43*
     +          temp41b
              rhb = temp42*temp41b
              recrysb(i, l, n) = recrysb(i, l, n) - temp41b0 - temp42*
     +          temp41b
              deliqsb(i, l, n) = deliqsb(i, l, n) + temp41b0
              rhsizeb(i, l, n) = temp43*temp41b
            ELSE
              avesizeb(n) = avesizeb(n) + rhsizeb(i, l, n)
              rhsizeb(i, l, n) = 0.0
              rhb = 0.0
            END IF
            CALL POPREAL8(rh)
            rhrowb(i, l+1) = rhrowb(i, l+1) + rhb
          ENDDO
        ENDDO
      ENDDO
      DO ii1=1,numsol
        DO ii2=1,11
          phitb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
      DO ii1=1,numtypes
        nub(ii1) = 0.0
      ENDDO
      DO ii1=1,numtypes
        mwb(ii1) = 0.0
      ENDDO
      DO iter=numiter,1,-1
        DO n=isize,1,-1
          DO l=ilev,1+mae,-1
            DO i=il2,il1,-1
              temp40 = a(i, l, n)/frx1
              temp40b = -(EXP(-temp40)*rh*awxb(i, l, n, iter)/frx1)
              avesizeb(n) = avesizeb(n) + frx1*rhsizeb(i, l, n)
              frx1b = avesize(n)*rhsizeb(i, l, n) - temp40*temp40b
              rhsizeb(i, l, n) = 0.0
              rhb = EXP(-temp40)*awxb(i, l, n, iter)
              ab(i, l, n) = ab(i, l, n) + temp40b
              awxb(i, l, n, iter) = 0.0
              CALL POPCONTROL2B(branch)
              IF (branch .EQ. 0) THEN
                CALL POPREAL8(frx1)
                temp38 = COS(theta/3.0)
                temp37 = SQRT(-q)
                temp36 = 2.0*temp37*temp38
                temp36b = -(frx1b/temp36**2)
                IF (-q .EQ. 0.0) THEN
                  qb = 0.0
                ELSE
                  qb = -(temp38*temp36b/temp37)
                END IF
                thetab = -(SIN(theta/3.0)*2.0*temp37*temp36b/3.0)
                CALL POPREAL8(theta)
                temp35 = -(q**3)
                temp34 = SQRT(temp35)
                temp34b1 = -(thetab/(SQRT(1.0-(r/temp34)**2)*temp34))
                rb = temp34b1
                IF (.NOT.temp35 .EQ. 0.0) qb = qb + r*3*q**2*temp34b1/(
     +              2.0*temp34**2)
                db = 0.0
              ELSE IF (branch .EQ. 1) THEN
                CALL POPREAL8(frx1)
                temp39 = vv**cub + dd**cub
                temp39b = -(frx1b/temp39**2)
                IF (vv .LE. 0.0 .AND. (cub .EQ. 0.0 .OR. cub .NE. INT(
     +              cub))) THEN
                  vvb = 0.0
                ELSE
                  vvb = cub*vv**(cub-1)*temp39b
                END IF
                IF (dd .LE. 0.0 .AND. (cub .EQ. 0.0 .OR. cub .NE. INT(
     +              cub))) THEN
                  ddb = 0.0
                ELSE
                  ddb = cub*dd**(cub-1)*temp39b
                END IF
                CALL POPCONTROL1B(branch)
                IF (branch .EQ. 0) THEN
                  CALL POPREAL8(dd)
                  x2b = ddb
                ELSE
                  CALL POPREAL8(dd)
                  x2b = -ddb
                END IF
                q = -(a(i, l, n)/(3.0*bpr))
                d = q*q*q + r*r
                rb = x2b
                IF (d .EQ. 0.0) THEN
                  db = 0.0
                ELSE
                  db = -(x2b/(2.0*SQRT(d)))
                END IF
                CALL POPCONTROL1B(branch)
                IF (branch .EQ. 0) THEN
                  CALL POPREAL8(vv)
                  x1b = vvb
                ELSE
                  CALL POPREAL8(vv)
                  x1b = -vvb
                END IF
                rb = rb + x1b
                IF (.NOT.d .EQ. 0.0) db = db + x1b/(2.0*SQRT(d))
                qb = 0.0
              ELSE
                GOTO 120
              END IF
              qb = qb + 3*q**2*db
              rb = rb + 2*r*db
              CALL POPREAL8(r)
              temp34b = -(rb/(2.0*bpr))
              rhb = rhb + temp34b/rh
              CALL POPREAL8(q)
              temp34b0 = -(qb/(3.0*bpr))
              bprb = -(a(i, l, n)*temp34b0/bpr) - LOG(rh)*temp34b/bpr
              ab(i, l, n) = ab(i, l, n) + temp34b0
              frx3 = frx1*frx1*frx1
              CALL POPREAL8(bpr)
              temp31 = amw(i, l, n)*denw*(frx3-1.0)
              temp33 = phix(i, l, n)*rhop(i, l, n)
              temp30 = temp33/temp31
              temp32 = anu(i, l, n)
              temp30b = mww*bprb
              temp30b0 = temp30*fmso(i, l, n)*temp30b
              temp30b1 = temp32*frx3*fmso(i, l, n)*temp30b/temp31
              temp31b = -(temp30*temp30b1)
              anub(i, l, n) = anub(i, l, n) + frx3*temp30b0
              frx3b = amw(i, l, n)*denw*temp31b + temp32*temp30b0
              fmsob(i, l, n) = fmsob(i, l, n) + temp30*temp32*frx3*
     +          temp30b
              phixb(i, l, n) = phixb(i, l, n) + rhop(i, l, n)*temp30b1
              rhopb(i, l, n) = rhopb(i, l, n) + phix(i, l, n)*temp30b1
              amwb(i, l, n) = amwb(i, l, n) + denw*(frx3-1.0)*temp31b
              frx1b = 3*frx1**2*frx3b
 120          CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                CALL POPREAL8(frx1)
                temp29 = LOG(awx1)
                temp28 = denw*amw(i, l, n)
                temp25 = temp28*temp29
                temp27 = rhop(i, l, n)*fmso(i, l, n)
                temp26 = anu(i, l, n)*phix(i, l, n)
                temp24 = temp26*temp27/temp25
                IF (1.0 - mww*temp24 .LE. 0.0 .AND. (cub .EQ. 0.0 .OR. 
     +              cub .NE. INT(cub))) THEN
                  temp24b = 0.0
                ELSE
                  temp24b = -(mww*cub*(1.0-mww*temp24)**(cub-1)*frx1b/
     +              temp25)
                END IF
                temp25b = -(temp24*temp24b)
                anub(i, l, n) = anub(i, l, n) + temp27*phix(i, l, n)*
     +            temp24b
                phixb(i, l, n) = phixb(i, l, n) + temp27*anu(i, l, n)*
     +            temp24b
                rhopb(i, l, n) = rhopb(i, l, n) + temp26*fmso(i, l, n)*
     +            temp24b
                awx1b = temp28*temp25b/awx1
                CALL POPREAL8(phix(i, l, n))
                temp23 = fmso(i, l, n)*anu(i, l, n)
                temp23b0 = phixb(i, l, n)/temp23
                amwb(i, l, n) = amwb(i, l, n) + phix(i, l, n)*temp23b0 +
     +            temp29*denw*temp25b
                temp23b = -(phix(i, l, n)*amw(i, l, n)*temp23b0/temp23)
                fmsob(i, l, n) = fmsob(i, l, n) + anu(i, l, n)*temp23b +
     +            temp26*rhop(i, l, n)*temp24b
                anub(i, l, n) = anub(i, l, n) + fmso(i, l, n)*temp23b
                phixb(i, l, n) = amw(i, l, n)*temp23b0
              ELSE
                CALL POPREAL8(frx1)
                phixb(i, l, n) = 0.0
                awx1b = 0.0
              END IF
              CALL POPREAL8(awx1)
              awxb(i, l, n, itrx) = awxb(i, l, n, itrx) + awx1b
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                CALL POPREAL8(rh)
                y3b = rhb
              ELSE
                CALL POPREAL8(rh)
                y3b = 0.0
              END IF
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) rhrowb(i, l+1) = rhrowb(i, l+1) + y3b
            ENDDO
          ENDDO
        ENDDO
        DO nt=ntps,1,-1
          pptb = 0.0
          DO n=isize,1,-1
            DO l=ilev,1+mae,-1
              DO i=il2,il1,-1
                aw2 = awx1*awx1
                aw3 = awx1*awx1*awx1
                aw4 = aw3*awx1
                temp22 = fmo(i, l, n, nt)
                temp21b = (1.0-pop)*ppt*temp22*phixb(i, l, n)
                temp21b0 = (1.0-pop)*(phit(3, nt)*aw3+phit(4, nt)*aw2+
     +            phit(5, nt)*awx1+phit(6, nt))*phixb(i, l, n)
                temp21 = fmo(i, l, n, nt)
                temp21b1 = pop*ppt*temp21*phixb(i, l, n)
                temp21b2 = pop*(phit(7, nt)*aw4+phit(8, nt)*aw3+phit(9, 
     +            nt)*aw2+phit(10, nt)*awx1+phit(11, nt))*phixb(i, l, n)
                phitb(3, nt) = phitb(3, nt) + aw3*temp21b
                phitb(4, nt) = phitb(4, nt) + aw2*temp21b
                aw2b = phit(9, nt)*temp21b1 + phit(4, nt)*temp21b
                phitb(5, nt) = phitb(5, nt) + awx1*temp21b
                phitb(6, nt) = phitb(6, nt) + temp21b
                pptb = pptb + temp21*temp21b2 + temp22*temp21b0
                fmob(i, l, n, nt) = fmob(i, l, n, nt) + ppt*temp21b2 + 
     +            ppt*temp21b0
                phitb(7, nt) = phitb(7, nt) + aw4*temp21b1
                aw4b = phit(7, nt)*temp21b1
                aw3b = awx1*aw4b + phit(8, nt)*temp21b1 + phit(3, nt)*
     +            temp21b
                awx1b = aw3*aw4b + 2*awx1*aw2b + 3*awx1**2*aw3b + phit(
     +            10, nt)*temp21b1 + phit(5, nt)*temp21b
                phitb(8, nt) = phitb(8, nt) + aw3*temp21b1
                phitb(9, nt) = phitb(9, nt) + aw2*temp21b1
                phitb(10, nt) = phitb(10, nt) + awx1*temp21b1
                phitb(11, nt) = phitb(11, nt) + temp21b1
                CALL POPREAL8(pop)
                CALL POPREAL8(awx1)
                awxb(i, l, n, itrx) = awxb(i, l, n, itrx) + awx1b
                CALL POPCONTROL2B(branch)
                IF (branch .EQ. 0) THEN
                  rhb = 0.0
                ELSE
                  IF (branch .EQ. 1) THEN
                    awxb(i, l, n, iter) = 0.0
                    y2b = 0.0
                  ELSE
                    y2b = awxb(i, l, n, iter)
                    awxb(i, l, n, iter) = 0.0
                  END IF
                  temp20 = 0.8*fr1(i, l, n)
                  temp19 = a(i, l, n)/temp20
                  temp19b0 = -(EXP(-temp19)*rh*y2b/temp20)
                  rhb = EXP(-temp19)*y2b
                  ab(i, l, n) = ab(i, l, n) + temp19b0
                  fr1b(i, l, n) = fr1b(i, l, n) - temp19*0.8*temp19b0
                END IF
                CALL POPCONTROL1B(branch)
                IF (branch .EQ. 0) THEN
                  CALL POPREAL8(rh)
                  y1b = rhb
                ELSE
                  CALL POPREAL8(rh)
                  y1b = 0.0
                END IF
                CALL POPCONTROL1B(branch)
                IF (branch .EQ. 0) rhrowb(i, l+1) = rhrowb(i, l+1) + y1b
              ENDDO
            ENDDO
          ENDDO
          CALL POPREAL8(ppt)
          temp19b = pptb/mw(nt)
          nub(nt) = nub(nt) + temp19b
          mwb(nt) = mwb(nt) - nu(nt)*temp19b/mw(nt)
        ENDDO
        arg1 = ilg*ilev*isize
        CALL POPREAL8ARRAY(phix, ilg*ilev*isize)
        CALL PUTZERO_B(phix, phixb, arg1)
        CALL POPCONTROL1B(branch)
        IF (branch .EQ. 0) THEN
          CALL POPINTEGER4(itrx)
        ELSE
          CALL POPINTEGER4(itrx)
        END IF
      ENDDO

      DO n=isize,1,-1
        DO l=ilev,1+mae,-1
          DO i=il2,il1,-1
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              frctest = frc(i, l, n)**3.0
              temp16 = bmix(i, l, n)/(frctest-1.0)
              temp18 = frc(i, l, n)
              temp17 = a(i, l, n)/temp18
              temp16b = EXP(temp17-temp16)*fcb(i, l, n)
              temp16b0 = -(temp16b/(frctest-1.0))
              ab(i, l, n) = ab(i, l, n) + temp16b/temp18
              frcb(i, l, n) = frcb(i, l, n) - temp17*temp16b/temp18
              bmixb(i, l, n) = bmixb(i, l, n) + temp16b0
              frctestb = -(temp16*temp16b0)
              fcb(i, l, n) = 0.0
            ELSE
              fcb(i, l, n) = 0.0
              frctestb = 0.0
            END IF
            frcb(i, l, n) = frcb(i, l, n) + 3.0*frc(i, l, n)**2.0*
     +        frctestb
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              temp15 = SQRT(-q)
              IF (-q .EQ. 0.0) THEN
                qb = 0.0
              ELSE
                qb = -(COS(theta/3.0)*frcb(i, l, n)/temp15)
              END IF
              thetab = -(SIN(theta/3.0)*temp15*2.0*frcb(i, l, n)/3.0)
              frcb(i, l, n) = 0.0
              CALL POPREAL8(theta)
              temp14 = -(q**3)
              temp13 = SQRT(temp14)
              IF (.NOT.temp14 .EQ. 0.0) qb = qb - 3*q**2*thetab/(2.0*
     +            temp13**3*SQRT(1.0-(1.0/temp13)**2))
              db = 0.0
            ELSE
              IF (dsr + 1.0 .LE. 0.0 .AND. (cub .EQ. 0.0 .OR. cub .NE. 
     +            INT(cub))) THEN
                dsrb = 0.0
              ELSE
                dsrb = (cub*(dsr+1.0)**(cub-1)-cub*(1.0-dsr+1.0E-50)**             !jinmin  1.0E-50
     +            (cub-1))*frcb(i, l, n)
              END IF
              frcb(i, l, n) = 0.0
              d = q*q*q + 1.0
              CALL POPREAL8(dsr)
              IF (d .EQ. 0.0) THEN
                db = 0.0
              ELSE
                db = dsrb/(2.0*SQRT(d))
              END IF
              qb = 0.0
            END IF
            qb = qb + 3*q**2*db
            CALL POPREAL8(q)
            qb = 3.0*qb
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              temp12 = SQRT(-q)
              IF (.NOT.-q .EQ. 0.0) qb = qb - COS(theta/3.0)*fr1b(i, l, 
     +            n)/temp12
              thetab = -(SIN(theta/3.0)*temp12*2.0*fr1b(i, l, n)/3.0)
              fr1b(i, l, n) = 0.0
              CALL POPREAL8(theta)
              temp11 = -(q**3)
              temp10 = SQRT(temp11)
              IF (.NOT.temp11 .EQ. 0.0) qb = qb - 0.5*3*q**2*thetab/(2.0
     +            *temp10**3*SQRT(1.0-(0.5/temp10)**2))
              db = 0.0
            ELSE
              IF (dsr + 0.5 .LE. 0.0 .AND. (cub .EQ. 0.0 .OR. cub .NE. 
     +            INT(cub))) THEN
                dsrb = 0.0
              ELSE
                dsrb = (cub*(dsr+0.5)**(cub-1)-cub*(0.5-dsr+1.0E-50)**     !jinmin +1.0E-50 0.5-dsr=0.0
     +           (cub-1))*fr1b(i, l, n)
              END IF
              fr1b(i, l, n) = 0.0
              d = q*q*q + 0.25
              CALL POPREAL8(dsr)
              IF (d .EQ. 0.0) THEN
                db = 0.0
              ELSE
                db = dsrb/(2.0*SQRT(d))
              END IF
            END IF
            qb = qb + 3*q**2*db
            CALL POPREAL8(q)
            temp9 = 3.0*a(i, l, n)
            bmixb(i, l, n) = bmixb(i, l, n) - qb/temp9
            ab(i, l, n) = ab(i, l, n) + bmix(i, l, n)*3.0*qb/temp9**2
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              temp8 = denw*amw(i, l, n)
              temp7 = anu(i, l, n)*phiaw1(i, l, n)
              temp6 = temp7/temp8
              temp6b = mww*bmixb(i, l, n)
              temp6b0 = rhop(i, l, n)*fmso(i, l, n)*temp6b/temp8
              anub(i, l, n) = anub(i, l, n) + phiaw1(i, l, n)*temp6b0
              phiaw1b(i, l, n) = phiaw1b(i, l, n) + anu(i, l, n)*temp6b0
              amwb(i, l, n) = amwb(i, l, n) - temp6*denw*temp6b0
              rhopb(i, l, n) = rhopb(i, l, n) + temp6*fmso(i, l, n)*
     +          temp6b
              fmsob(i, l, n) = fmsob(i, l, n) + temp6*rhop(i, l, n)*
     +          temp6b
              bmixb(i, l, n) = 0.0
            ELSE
              bmixb(i, l, n) = 0.0
            END IF
            temp5 = denw*rw*avesize(n)
            temp4 = temp5*throw(i, l+1)
            temp4b = -(sfcten*2.0*ab(i, l, n)/temp4**2)
            avesizeb(n) = avesizeb(n) + throw(i, l+1)*denw*rw*temp4b
            throwb(i, l+1) = throwb(i, l+1) + temp5*temp4b
            ab(i, l, n) = 0.0
          ENDDO
        ENDDO
      ENDDO
      DO n=isize,1,-1
        r3db = 0.0
        DO l=ilev,1+mae,-1
          DO i=il2,il1,-1
            temp3 = r3d*rhop(i, l, n)
            temp3b1 = -(totmas(i, l, n)*aeronumb(i, l, n)/temp3**2)
            totmasb(i, l, n) = totmasb(i, l, n) + aeronumb(i, l, n)/
     +        temp3
            r3db = r3db + rhop(i, l, n)*temp3b1
            rhopb(i, l, n) = rhopb(i, l, n) + r3d*temp3b1
            aeronumb(i, l, n) = 0.0
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              CALL POPREAL8(recrys(i, l, n))
              temp3b = recrysb(i, l, n)/fmso(i, l, n)
              recrysb(i, l, n) = temp3b
              CALL POPREAL8(deliqs(i, l, n))
              temp3b0 = deliqsb(i, l, n)/fmso(i, l, n)
              deliqsb(i, l, n) = temp3b0
              CALL POPREAL8(phiaw1(i, l, n))
              temp2 = fmso(i, l, n)*anu(i, l, n)
              temp2b1 = phiaw1b(i, l, n)/temp2
              temp2b0 = -(phiaw1(i, l, n)*amw(i, l, n)*temp2b1/temp2)
              fmsob(i, l, n) = fmsob(i, l, n) + anu(i, l, n)*temp2b0 - 
     +          deliqs(i, l, n)*temp3b0/fmso(i, l, n) - recrys(i, l, n)*
     +          temp3b/fmso(i, l, n)
              anub(i, l, n) = anub(i, l, n) + fmso(i, l, n)*temp2b0
              phiaw1b(i, l, n) = amw(i, l, n)*temp2b1
              CALL POPREAL8(anu(i, l, n))
              temp2b2 = anub(i, l, n)/fmso(i, l, n)
              amwb(i, l, n) = amwb(i, l, n) + anu(i, l, n)*temp2b2 + 
     +          phiaw1(i, l, n)*temp2b1
              fmsob(i, l, n) = fmsob(i, l, n) - anu(i, l, n)*amw(i, l, n
     +          )*temp2b2/fmso(i, l, n)
              anub(i, l, n) = amw(i, l, n)*temp2b2
              CALL POPREAL8(amw(i, l, n))
              temp2b3 = amwb(i, l, n)/amw(i, l, n)
              fmsob(i, l, n) = fmsob(i, l, n) + temp2b3
              amwb(i, l, n) = -(fmso(i, l, n)*temp2b3/amw(i, l, n))
            ELSE
              recrysb(i, l, n) = 0.0
              deliqsb(i, l, n) = 0.0
            END IF
            CALL POPREAL8(rhop(i, l, n))
            temp2b = rhopb(i, l, n)/rhop(i, l, n)
            totmasb(i, l, n) = totmasb(i, l, n) + temp2b
            rhopb(i, l, n) = -(totmas(i, l, n)*temp2b/rhop(i, l, n))
          ENDDO
        ENDDO
        rwib = 4.189*3*rwi**2*r3db + avesizeb(n)
        avesizeb(n) = 0.0
        CALL POPREAL8(r3d)
        CALL POPREAL8(rwi)
        aerosizeb(1, n) = aerosizeb(1, n) + rwib/2.0
        aerosizeb(2, n) = aerosizeb(2, n) + rwib/2.0
      ENDDO
      DO ii1=1,numtypes
        deliqb(ii1) = 0.0
      ENDDO
      DO ii1=1,numtypes
        recryb(ii1) = 0.0
      ENDDO
      DO ii1=1,numtypes
        phikb(ii1) = 0.0
      ENDDO
      DO nt=ntps,1,-1
        DO n=isize,1,-1
          DO l=ilev,1+mae,-1
            DO i=il2,il1,-1
              tempb1 = amwb(i, l, n)/mw(nt)
              tempb2 = fmo(i, l, n, nt)*anub(i, l, n)/mw(nt)
              temp = nu(nt)/mw(nt)
              temp0b = phik(nt)*nu(nt)*phiaw1b(i, l, n)/mw(nt)
              fmob(i, l, n, nt) = fmob(i, l, n, nt) + deliq(nt)*deliqsb(
     +          i, l, n) + temp*anub(i, l, n) + fmsob(i, l, n) + tempb1 
     +          + temp0b + recry(nt)*recrysb(i, l, n)
              recryb(nt) = recryb(nt) + fmo(i, l, n, nt)*recrysb(i, l, n
     +          )
              deliqb(nt) = deliqb(nt) + fmo(i, l, n, nt)*deliqsb(i, l, n
     +          )
              temp1 = fmo(i, l, n, nt)
              temp0 = temp1/mw(nt)
              phikb(nt) = phikb(nt) + temp0*nu(nt)*phiaw1b(i, l, n)
              nub(nt) = nub(nt) + tempb2 + temp0*phik(nt)*phiaw1b(i, l, 
     +          n)
              mwb(nt) = mwb(nt) - temp*tempb2 - fmo(i, l, n, nt)*tempb1/
     +          mw(nt) - temp0*temp0b
            ENDDO
          ENDDO
        ENDDO
      ENDDO
      DO nt=ntps,1,-1
        phitb(3, nt) = phitb(3, nt) + phikb(nt)
        phitb(4, nt) = phitb(4, nt) + phikb(nt)
        phitb(5, nt) = phitb(5, nt) + phikb(nt)
        phitb(6, nt) = phitb(6, nt) + phikb(nt)
        phikb(nt) = 0.0
      ENDDO
      DO ii1=1,ntr
        DO ii2=1,ilev
          DO ii3=1,ilg
c            rgridb(ii3, ii2, ii1) = 0.0
          ENDDO
        ENDDO
      ENDDO
      DO nt=ntp,1,-1
        DO n=isize,1,-1
          DO l=ilev,1+mae,-1
            DO i=il2,il1,-1
              tempb0 = fmob(i, l, n, nt)/totmas(i, l, n)
              tramassb = tempb0
              totmasb(i, l, n) = totmasb(i, l, n) - tramass*tempb0/
     +          totmas(i, l, n)
              fmob(i, l, n, nt) = 0.0
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                CALL POPREAL8(tramass)
                rgridb(i, l, no) = rgridb(i, l, no) + tramassb
              ELSE
                CALL POPREAL8(tramass)
              END IF
            ENDDO
          ENDDO
          CALL POPINTEGER4(no)
        ENDDO
        CALL POPINTEGER4(nt0)
      ENDDO

      DO ii1=1,ntp
c        rhop0b(ii1) = 0.0
      ENDDO
      DO nt=ntp,1,-1
        DO n=isize,1,-1
          DO l=ilev,1+mae,-1
            DO i=il2,il1,-1
              tempb = rhopb(i, l, n)/rhop0(nt0)
              tramassb = totmasb(i, l, n) + tempb
              rhop0b(nt0) = rhop0b(nt0) - tramass*tempb/rhop0(nt0)
              CALL POPCONTROL1B(branch)
              IF (branch .EQ. 0) THEN
                CALL POPREAL8(tramass)
                rgridb(i, l, no) = rgridb(i, l, no) + tramassb
               tramassb=0.0
              ELSE
                CALL POPREAL8(tramass)
               tramassb=0.0
              END IF
            ENDDO
          ENDDO
          CALL POPINTEGER4(no)
        ENDDO
        CALL POPINTEGER4(nt0)
      ENDDO

      DO nt=ntps,1,-1
        DO j=11,1,-1
          phit_b(j,sortnum(nt))=phit_b(j,sortnum(nt)) + phitb(j,nt)
          phitb(j, nt) = 0.0
        ENDDO
      ENDDO
      DO nt=ntp,1,-1
        recry_b(sortnum(nt)) = recry_b(sortnum(nt)) + recryb(nt)
        recryb(nt) = 0.0
        deliq_b(sortnum(nt)) = deliq_b(sortnum(nt)) + deliqb(nt)
        deliqb(nt) = 0.0
        nu_b(sortnum(nt)) = nu_b(sortnum(nt)) + nub(nt)
        nub(nt) = 0.0
        mw_b(sortnum(nt)) = mw_b(sortnum(nt)) + mwb(nt)
        mwb(nt) = 0.0
      ENDDO
      DO j=11,3,-1
        phit_b(j, 4) = ocfactor*phit_b(j, 4)
      ENDDO
      CALL POPINTEGER4(ad_count)
      DO i0=1,ad_count
        IF (i0 .EQ. 1) CALL POPCONTROL1B(branch)
      ENDDO

      CALL PUTZERO_B(recrys, recrysb,ilg*ilev*isize)
      CALL PUTZERO_B(deliqs, deliqsb, ilg*ilev*isize)
      CALL PUTZERO_B(anu, anub, ilg*ilev*isize)
      CALL PUTZERO_B(amw, amwb, ilg*ilev*isize)
      CALL PUTZERO_B(phiaw1, phiaw1b, ilg*ilev*isize)
      CALL PUTZERO_B(fmso, fmsob, ilg*ilev*isize)
      CALL PUTZERO_B(fmo, fmob, ilg*ilev*isize*ntp)
      CALL PUTZERO_B(totmas, totmasb, ilg*ilev*isize)
      CALL PUTZERO_B(rhop, rhopb, ilg*ilev*isize)


      END


