      SUBROUTINE AEROEXE1_B(dt, trnch, kount, ni, nk, t, tb, q, qb, psfc
     +                      , psfcb, sig, sigb, hght, surfwd, surfwdb, 
     +                      fws, roa, fmodv, flwc, fktm, ftsoil, ice, 
     +                      iceb, snow, snowb, ffdss, ffdssb, fdz, 
     +                      lat_deg, lat_degb, long_deg, long_degb, sza
     +                      , frclds, frcldc, qr, ntr, nats, nct, ndt, 
     +                      gnluc, num_emission, sand2row, clay2row, 
     +                      sand6row, frluc, frlucb, blcrow, blcrowb, 
     +                      omcrow, omcrowb, aq_date2, fhs, aero_tr, 
     +                      aero_trb, rsfrow, rsfrowb, aso2row, aso2rowb
     +                      , pso2row, pso2rowb, poso2row, aso4row, 
     +                      aso4rowb, pso4row, pso4rowb, poso4row, 
     +                      poso4rowb, dmsorow, dmsorowb, dmslrow, 
     +                      dmslrowb, h2srow, h2srowb, gdrem1, gdrem1b, 
     +                      gdrem2, gdrem2b, gdrem3, gdrem3b, ano3row, 
     +                      ano3rowb, pno3row, pno3rowb, pono3row, 
     +                      pono3rowb, mu0, eu0, du0, md0, ed0, prate_2d
     +                      , wrscav_2d, zfprec_2d, wpevpa_2d, ww1, mc, 
     +                      mcb, dp, dpb, mb, mbb, esp0, zfg, zfgb, 
     +                      dsubcld, dsubcldb, ideep, jt, maxg, jd, 
     +                      lengath, pso4, psoa, rrdrow, rrdrowb)
      IMPLICIT NONE
      INTEGER trnch, kount, ni, nj, nk
      INTEGER ntr, nats, nct, ndt, gnluc, num_emission
      REAL dt, dt_half
      INTEGER tr_loc(ntr)
      REAL aero_tr(ni, nk, ntr)
      REAL aero_trb(ni, nk, ntr)
      REAL wrongaero(ni, nk, ntr)
      REAL long, lat
C
C     include "chem_setup.cdk"
C     include "chem_luc.cdk"
C
C     "consphy.cdk"    !jinmin
      REAL cpd, cpv, rgasd, rgasv, trpl, tcdk, rauw, eps1, eps2
      REAL delta, cappa, tgl, consol, grav, rayt, stefan, pi
      REAL omega
      REAL knams, stlo, karman, ric, chlc, chlf
      REAL t1s, t2s, aw, bw, ai, bi, slp
      LOGICAL init
      PARAMETER (init=.true.)
      PARAMETER (cpd=.100546e+4)
      PARAMETER (cpv=.186946e+4)
      PARAMETER (rgasd=.28705e+3)
      PARAMETER (rgasv=.46151e+3)
      PARAMETER (trpl=.27316e+3)
      PARAMETER (tcdk=.27315e+3)
      PARAMETER (rauw=.1e+4)
      PARAMETER (eps1=.62194800221014)
      PARAMETER (eps2=.3780199778986)
      PARAMETER (delta=.6077686814144)
      PARAMETER (cappa=.28549121795)
      PARAMETER (tgl=.27316e+3)
      PARAMETER (consol=.1367e+4)
      PARAMETER (grav=.980616e+1)
      PARAMETER (rayt=.637122e+7)
      PARAMETER (stefan=.566948e-7)
      PARAMETER (pi=.314159265359e+1)
      PARAMETER (knams=.514791)
      PARAMETER (stlo=.6628486583943e-3)
      PARAMETER (karman=.35)
      PARAMETER (ric=.2)
      PARAMETER (chlc=.2501e+7)
      PARAMETER (chlf=.334e+6)
      PARAMETER (t1s=.27316e+3)
      PARAMETER (t2s=.25816e+3)
      PARAMETER (aw=.3135012829948e+4)
      PARAMETER (bw=.2367075766316e+1)
      PARAMETER (ai=.2864887713087e+4)
      PARAMETER (bi=.166093131502)
      PARAMETER (slp=.6666666666667e-1)
C
C      "fintern.cdk"  !jinmin
      REAL ttt, prs, qqq
      REAL t00, pr0, tf, pf, fff, ddff
      REAL qsm, dlemx
      REAL*8 foew, fodle, foqst, fodqs, foefq, foqfe, fotvt, fottv, fohr
      REAL*8 folv, fols, fopoit, fopoip, fottvh, fotvht
      REAL*8 foewa, fodla, foqsa, fodqa, fohra
      REAL*8 fesi, fdlesi, fesmx, fdlesmx, fqsmx, fdqsmx
*   FONCTION DE VAPEUR SATURANTE (TETENS)
      FOEWA(TTT)=610.78D0*DEXP(17.269D0*(DBLE(TTT)-DBLE(TRPL))/
     W (DBLE(TTT)-35.86D0))

*   FONCTION CALCULANT TENSION VAP (EEE) FN DE HUM SP (QQQ) ET PRS

      FOEFQ(QQQ,PRS) = DMIN1(DBLE(PRS),(DBLE(QQQ)*DBLE(PRS)) /
     W (DBLE(EPS1) + DBLE(EPS2)*DBLE(QQQ)))

*   FONCTION CALCULANT L'HUMIDITE RELATIVE
c      FOHRA(QQQ,TTT,PRS)=DMIN1(DBLE(PRS),FOEFQ(QQQ,PRS))/FOEWA(TTT)

C jinmin FOEFQ(QQQ,PRS)  --->  DBLE(FOEFQ(QQQ,PRS))

      FOHRA(QQQ,TTT,PRS)=DMIN1(DBLE(PRS),DBLE(FOEFQ(QQQ,PRS)))
     +                   /FOEWA(TTT)

C
C     include "aq_emis.cdk"
C     include "aero_emis.cdk"
C      include "aq_emis_order.cdk"
C      include "aq_chem.cdk"
C      include "aq_chem_order.cdk"
C      include "aero_chem.cdk"
C      include "aero_emis_order.cdk"
C
C      "aero_chem_order.cdk"     !jinmin
      INTEGER, PARAMETER :: aero_chem_np=6, aero_nsize=12
      INTEGER cncass1, cncass2, cncass3, cncass4, cncass5, cncass6, 
     +        cncass7, cncass8, cncass9, cncass10, cncass11, cncass12, 
     +        cncasf1, cncasf2, cncasf3, cncasf4, cncasf5, cncasf6, 
     +        cncasf7, cncasf8, cncasf9, cncasf10, cncasf11, cncasf12, 
     +        cncabc1, cncabc2, cncabc3, cncabc4, cncabc5, cncabc6, 
     +        cncabc7, cncabc8, cncabc9, cncabc10, cncabc11, cncabc12, 
     +        cncaoc1, cncaoc2, cncaoc3, cncaoc4, cncaoc5, cncaoc6, 
     +        cncaoc7, cncaoc8, cncaoc9, cncaoc10, cncaoc11, cncaoc12, 
     +        cncasd1, cncasd2, cncasd3, cncasd4, cncasd5, cncasd6, 
     +        cncasd7, cncasd8, cncasd9, cncasd10, cncasd11, cncasd12, 
     +        cncant1, cncant2, cncant3, cncant4, cncant5, cncant6, 
     +        cncant7, cncant8, cncant9, cncant10, cncant11, cncant12, 
     +        cncano3, cncaoh, cncao3, cncaam1, cncaam2, cncaam3
      INTEGER cncavis, cncah2o2, cncaso2, cncadms, cncah2s, cncaso4, 
     +        cncaco2, cncahno3, cncanh3, cncaccn, cncalwc, cncaiwc, 
     +        cncaclf
      INTEGER iae1, iae2
      PARAMETER (cncabc1=1)
      PARAMETER (cncabc2=2)
      PARAMETER (cncabc3=3)
      PARAMETER (cncabc4=4)
      PARAMETER (cncabc5=5)
      PARAMETER (cncabc6=6)
      PARAMETER (cncabc7=7)
      PARAMETER (cncabc8=8)
      PARAMETER (cncabc9=9)
      PARAMETER (cncabc10=10)
      PARAMETER (cncabc11=11)
      PARAMETER (cncabc12=12)
      PARAMETER (cncaoc1=aero_nsize*1+1)
      PARAMETER (cncaoc2=aero_nsize*1+2)
      PARAMETER (cncaoc3=aero_nsize*1+3)
      PARAMETER (cncaoc4=aero_nsize*1+4)
      PARAMETER (cncaoc5=aero_nsize*1+5)
      PARAMETER (cncaoc6=aero_nsize*1+6)
      PARAMETER (cncaoc7=aero_nsize*1+7)
      PARAMETER (cncaoc8=aero_nsize*1+8)
      PARAMETER (cncaoc9=aero_nsize*1+9)
      PARAMETER (cncaoc10=aero_nsize*1+10)
      PARAMETER (cncaoc11=aero_nsize*1+11)
      PARAMETER (cncaoc12=aero_nsize*1+12)
      PARAMETER (cncasd1=aero_nsize*2+1)
      PARAMETER (cncasd2=aero_nsize*2+2)
      PARAMETER (cncasd3=aero_nsize*2+3)
      PARAMETER (cncasd4=aero_nsize*2+4)
      PARAMETER (cncasd5=aero_nsize*2+5)
      PARAMETER (cncasd6=aero_nsize*2+6)
      PARAMETER (cncasd7=aero_nsize*2+7)
      PARAMETER (cncasd8=aero_nsize*2+8)
      PARAMETER (cncasd9=aero_nsize*2+9)
      PARAMETER (cncasd10=aero_nsize*2+10)
      PARAMETER (cncasd11=aero_nsize*2+11)
      PARAMETER (cncasd12=aero_nsize*2+12)
      PARAMETER (cncass1=aero_nsize*3+1)
      PARAMETER (cncass2=aero_nsize*3+2)
      PARAMETER (cncass3=aero_nsize*3+3)
      PARAMETER (cncass4=aero_nsize*3+4)
      PARAMETER (cncass5=aero_nsize*3+5)
      PARAMETER (cncass6=aero_nsize*3+6)
      PARAMETER (cncass7=aero_nsize*3+7)
      PARAMETER (cncass8=aero_nsize*3+8)
      PARAMETER (cncass9=aero_nsize*3+9)
      PARAMETER (cncass10=aero_nsize*3+10)
      PARAMETER (cncass11=aero_nsize*3+11)
      PARAMETER (cncass12=aero_nsize*3+12)
      PARAMETER (cncasf1=aero_nsize*4+1)
      PARAMETER (cncasf2=aero_nsize*4+2)
      PARAMETER (cncasf3=aero_nsize*4+3)
      PARAMETER (cncasf4=aero_nsize*4+4)
      PARAMETER (cncasf5=aero_nsize*4+5)
      PARAMETER (cncasf6=aero_nsize*4+6)
      PARAMETER (cncasf7=aero_nsize*4+7)
      PARAMETER (cncasf8=aero_nsize*4+8)
      PARAMETER (cncasf9=aero_nsize*4+9)
      PARAMETER (cncasf10=aero_nsize*4+10)
      PARAMETER (cncasf11=aero_nsize*4+11)
      PARAMETER (cncasf12=aero_nsize*4+12)
      PARAMETER (cncant1=aero_nsize*5+1)
      PARAMETER (cncant2=aero_nsize*5+2)
      PARAMETER (cncant3=aero_nsize*5+3)
      PARAMETER (cncant4=aero_nsize*5+4)
      PARAMETER (cncant5=aero_nsize*5+5)
      PARAMETER (cncant6=aero_nsize*5+6)
      PARAMETER (cncant7=aero_nsize*5+7)
      PARAMETER (cncant8=aero_nsize*5+8)
      PARAMETER (cncant9=aero_nsize*5+9)
      PARAMETER (cncant10=aero_nsize*5+10)
      PARAMETER (cncant11=aero_nsize*5+11)
      PARAMETER (cncant12=aero_nsize*5+12)
      PARAMETER (cncaam1=aero_nsize*6+1)
      PARAMETER (iae1=cncabc1)
      PARAMETER (iae2=cncaam1)
      INTEGER ncam
      PARAMETER (ncam=iae2)
C
      INTEGER cgasno2, cgaso3p, cgasno, cgaso3, cgaso1d, cgashono, 
     +        cgasho, cgashno3, cgashno4, cgasho2, cgasno3, cgash2o2, 
     +        cgashcho, cgasco, cgasald, cgasmo2, cgasop1, cgasop2, 
     +        cgaspaa, cgasket, cgasaco3, cgasethp, cgasgly, cgasmgly, 
     +        cgasdcb, cgastco3, cgasonit, cgasn2o5, cgasso2, cgassulf, 
     +        cgassulaer, cgaseth, cgashc3, cgashc3p, cgashc5, cgashc5p
     +        , cgasxo2, cgashc8, cgashc8p, cgashc8aer, cgasol2, 
     +        cgasol2p, cgasolt, cgasoltp, cgasoli, cgasolip, cgasoliaer
     +        , cgastol, cgastolp, cgascsl, cgastolaer, cgasxyl, 
     +        cgasxylp, cgasxylaer, cgascslaer, cgasketp, cgaspan, 
     +        cgasiso, cgastpan, cgasoln, cgasxno2, cgasora1, cgasora2, 
     +        cgasterp, cgasterpaer, cgasair, cgasnh3
      PARAMETER (cgasno2=iae2+1)
      PARAMETER (cgaso3p=iae2+2)
      PARAMETER (cgasno=iae2+3)
      PARAMETER (cgaso3=iae2+4)
      PARAMETER (cgaso1d=iae2+5)
      PARAMETER (cgashono=iae2+6)
      PARAMETER (cgasho=iae2+7)
      PARAMETER (cgashno3=iae2+8)
      PARAMETER (cgashno4=iae2+9)
      PARAMETER (cgasho2=iae2+10)
      PARAMETER (cgasno3=iae2+11)
      PARAMETER (cgash2o2=iae2+12)
      PARAMETER (cgashcho=iae2+13)
      PARAMETER (cgasco=iae2+14)
      PARAMETER (cgasald=iae2+15)
      PARAMETER (cgasmo2=iae2+16)
      PARAMETER (cgasop1=iae2+17)
      PARAMETER (cgasop2=iae2+18)
      PARAMETER (cgaspaa=iae2+19)
      PARAMETER (cgasket=iae2+20)
      PARAMETER (cgasaco3=iae2+21)
      PARAMETER (cgasethp=iae2+22)
      PARAMETER (cgasgly=iae2+23)
      PARAMETER (cgasmgly=iae2+24)
      PARAMETER (cgasdcb=iae2+25)
      PARAMETER (cgastco3=iae2+26)
      PARAMETER (cgasonit=iae2+27)
      PARAMETER (cgasn2o5=iae2+28)
      PARAMETER (cgasso2=iae2+29)
      PARAMETER (cgassulf=iae2+30)
      PARAMETER (cgassulaer=iae2+31)
      PARAMETER (cgaseth=iae2+32)
      PARAMETER (cgashc3=iae2+33)
      PARAMETER (cgashc3p=iae2+34)
      PARAMETER (cgashc5=iae2+35)
      PARAMETER (cgashc5p=iae2+36)
      PARAMETER (cgasxo2=iae2+37)
      PARAMETER (cgashc8=iae2+38)
      PARAMETER (cgashc8p=iae2+39)
      PARAMETER (cgashc8aer=iae2+40)
      PARAMETER (cgasol2=iae2+41)
      PARAMETER (cgasol2p=iae2+42)
      PARAMETER (cgasolt=iae2+43)
      PARAMETER (cgasoltp=iae2+44)
      PARAMETER (cgasoli=iae2+45)
      PARAMETER (cgasolip=iae2+46)
      PARAMETER (cgasoliaer=iae2+47)
      PARAMETER (cgastol=iae2+48)
      PARAMETER (cgastolp=iae2+49)
      PARAMETER (cgascsl=iae2+50)
      PARAMETER (cgastolaer=iae2+51)
      PARAMETER (cgasxyl=iae2+52)
      PARAMETER (cgasxylp=iae2+53)
      PARAMETER (cgasxylaer=iae2+54)
      PARAMETER (cgascslaer=iae2+55)
      PARAMETER (cgasketp=iae2+56)
      PARAMETER (cgaspan=iae2+57)
      PARAMETER (cgasiso=iae2+58)
      PARAMETER (cgastpan=iae2+59)
      PARAMETER (cgasoln=iae2+60)
      PARAMETER (cgasxno2=iae2+61)
      PARAMETER (cgasora1=iae2+62)
      PARAMETER (cgasora2=iae2+63)
      PARAMETER (cgasterp=iae2+64)
      PARAMETER (cgasterpaer=iae2+65)
      PARAMETER (cgasair=iae2+66)
      PARAMETER (cgasnh3=iae2+67)
      PARAMETER (cncavis=iae2+68)
      PARAMETER (cncaam2=iae2+69)
      PARAMETER (cncaam3=iae2+70)
      PARAMETER (cncadms=iae2+71)
      PARAMETER (cncah2s=iae2+72)
      PARAMETER (cncaco2=iae2+73)
      PARAMETER (cncaccn=iae2+74)
      PARAMETER (cncalwc=iae2+75)
      PARAMETER (cncaiwc=iae2+76)
      PARAMETER (cncaclf=iae2+77)
      PARAMETER (cncaso2=cgasso2)
      PARAMETER (cncaso4=cncaco2)
      PARAMETER (cncanh3=cgasnh3)
      PARAMETER (cncano3=cgasno3)
      PARAMETER (cncaoh=cgasho)
      PARAMETER (cncao3=cgaso3)
      PARAMETER (cncah2o2=cgash2o2)
      PARAMETER (cncahno3=cgashno3)
C
C     "chem_nml_vars.cdk"  !jinmin
C ########### start chem_nml_vars.cdk #############
C
C logical switches for gas phase,  aerosol and stratospheric chemistry (not yet)         
C
      LOGICAL aq_chem_l, aero_chem_l, st_chem_l
      COMMON /chem_vars_l/ aq_chem_l, aero_chem_l, st_chem_l
C
C frequency (number of timesteps) to read in the emissions files
C (gas and aerosol)
      INTEGER gnemis_dt, gnaeroemis_dt, gnbioemis_dt, gncoemis_dt, 
     +        gnhgemis_dt
C
C number of gas phase and aerosol species (advected), and non-advected
      INTEGER aq_ad_ntr, aero_ad_ntr, chem_nonad_ntr, aq_diags, 
     +        aero_diags
C
      COMMON /chem_vars_i/ gnemis_dt, gnaeroemis_dt, aq_ad_ntr, 
     +aero_ad_ntr, gncoemis_dt, gnhgemis_dt, chem_nonad_ntr, aq_diags, 
     +aero_diags, gnbioemis_dt
C
C filenames for gas, aerosol emissions, landuse (full path)
      CHARACTER*256 aq_emis_file_s, aero_emis_file_s, chem_luc_file_s, 
     +              chem_jval_file_s, aq_ddep_s, aq_bio_emis_file_s, 
     +              aq_minor_sat_file_s, aq_minor_sun_file_s, 
     +              aq_minor_wd_file_s, aq_nonmob_sat_file_s, 
     +              aq_nonmob_sun_file_s, aq_nonmob_wd_file_s, 
     +              aq_olson_file_s, aq_gvi_file_s, aq_czcs_file_s, 
     +              aq_npp_file_s, aq_matthews_file_s, aero_soil_file_s(
     +              3)
C
      COMMON /chem_vars_c/ aq_emis_file_s, aero_emis_file_s, 
     +chem_luc_file_s, chem_jval_file_s, aq_ddep_s, aq_bio_emis_file_s, 
     +aero_soil_file_s, aq_minor_sat_file_s, aq_minor_sun_file_s, 
     +aq_minor_wd_file_s, aq_nonmob_sat_file_s, aq_nonmob_sun_file_s, 
     +aq_nonmob_wd_file_s, aq_olson_file_s, aq_gvi_file_s, 
     +aq_czcs_file_s, aq_npp_file_s, aq_matthews_file_s
C
C      "cam_set_gem.cdk"   !jinmin
C ########## start cam_set_gem.cdk ##########
C
C ----- need aero_chem.cdk, chem_luc.cdk first !!
C
C -----ARRAYS FOR CALL INAERO( )------------------------------------------
C, luc
      INTEGER iscam, islev
      INTEGER idd, iti, itr, dlev, jdd, mae
      REAL cam
      REAL camb
      REAL aerosize(2, aero_nsize+1), pvol(aero_nsize)
      REAL aerosizeb(2, aero_nsize+1), pvolb(aero_nsize)
      REAL coagfr(aero_nsize, aero_nsize, aero_nsize)
      REAL coagfrb(aero_nsize, aero_nsize, aero_nsize)
      INTEGER igf(aero_nsize)
      INTEGER igfij(aero_nsize, aero_nsize*aero_nsize, 2)
      COMMON /coag_r/ coagfr
      COMMON /coag_i/ igf, igfij
C
C ---------------- Dry Deposition Parameters ----------------------------- 
C number of gas species deposited
      INTEGER ng
C number of seasons
      INTEGER ns
C number of classes that are land not really used
      INTEGER nl
C number of classes that are land not really used
      INTEGER ml
Clanduse classes - should be same as gnluc !a shortcut
      INTEGER nluc
      PARAMETER (ng=12)
      PARAMETER (ns=5)
      PARAMETER (nl=12)
      PARAMETER (ml=12)
      INTEGER luc
      PARAMETER (luc=15)
C  (luc=gnluc=15) 
      REAL pllp(luc, ns), z0cam(luc, ns), scc(ng), rcw(ng), ac(ng)
      REAL pllpb(luc, ns), sccb(ng), rcwb(ng), acb(ng)
      REAL laicam(luc, ns), rm0(ng), zpd(luc, ns), z0(luc, ns)
      REAL laicamb(luc, ns), rm0b(ng), zpdb(luc, ns)
      REAL fcap(ml), wp(ml), rgw(ng)
      REAL fcapb(ml), wpb(ml), rgwb(ng)
      REAL aest(luc), gamma(luc)
      REAL aestb(luc), gammab(luc)
      CHARACTER*4 cspec(ng)
C
      COMMON /depo_r/ pllp, z0cam, scc, rcw, ac, laicam, rm0, zpd, fcap
     +, wp, rgw, aest, gamma
      COMMON /depo_c/ cspec
C
      INTEGER idebug, imm, ima, inu, icob, idrydep, itubmix, icoag, i_ss
     +        , iincld, iblcld, iccrn
      COMMON /aeroswth/ idebug, imm, ima, inu, icob, idrydep, itubmix, 
     +icoag, i_ss, iincld, iblcld, iccrn
C
C      --------------------------------------------------------------------
      COMMON /cam_i/ idd, jdd, iti, itr, iscam, islev, mae, dlev
C
C
C---FOR CAM_V05 ONLY------------------------------------------------------------------
C
      REAL rhop0(aero_chem_np)
      REAL rhop0b(aero_chem_np)
      COMMON /cam_r/ aerosize, cam, rhop0, pvol
      CHARACTER*8 aeroname(aero_chem_np)
      COMMON /cam_c/ aeroname
C      --------------------------------------------------------------------
C ########## end cam_set_gem.cdk ############
C
C
C      "cam_cons.cdk"   !jinmin
C     ------------------- start of cam_cons.cdk ------------------
C    2004 COMMONS CONSTANTS FOR CAM_V5 MSC-ARQM %%%CAM%%%
C
      INTEGER ifdiff, kstart, ktotal, newrun, ndays, nsecs, iday, lday, 
     +        mday, incd
C    &     RGOASQ,CPRES,RGASV,CPRESV 
      REAL delt, ww, tw, rayon, asq, g, rgas, rgocp, rgoasq, cpres, 
     +     rgasvp, cpresv
      REAL deltb, gb
C
      COMMON /params/ ww, tw, rayon, asq, g, rgas, rgocp, rgoasq, cpres
C      COMMON /PARAMS/ RGASV,CPRESV
      COMMON /params/ rgasvp, cpresv
C     'RGASV' HAE BEEN USED IN GEM, and 'CPRESV' NOT BE USED IN CAM
      COMMON /times/ delt, ifdiff, kstart, ktotal, newrun, ndays, nsecs
     +, iday, lday, mday, incd
C
      REAL pai, rvord, tfrez, hs_cam, hv_cam, daylnt
      COMMON /param1/ pai, rvord, tfrez, hs_cam, hv_cam, daylnt
C
C     -------------------- end of cam_cons.cdk -------------------
C
C
C
C -----------------------------Object-----------------------------------
C this is the main interface subroutine for the aerosol physics/chemistry
C
C ----------added by H.Wang in Nov.8, 2004-----------------
C Arguments
C   name(demension)|  type   |              describtion      
C   input:
C   dt             | integer | length of timestep [sec.] 
C   trnch          | integer | Number of grid points in y-direction(latitude),slice number
C   kount          | integer | timestep number   
C   ni             | integer | horizontal dimension on longitude              
C   nk             | integer | vertical dimension                
C   t(ni*nk)       |   real  | Temperature at grid slice of mid-layer[K] 
C   ftv(ni*nk)     |   real  | VIRTUAL TEMP. (STAGG. LEVELS)
C   q(ni*nk)       |   real  | specific humidity [g/g]                
C   psfc(NI)       |   real  | Surface pressure [Pa] 
C   sig (NI*NK)    |   real  | Local interface (top??) sigma value
C   hght (NI*NK)   |   real  | Height at the each interface level [m]    
C   surfwd  (ni)   |   real  | surface wind speed (at 10m hight)[m/s]  
C   fws(ni*nk)     |   real  | grid vertical velocity [m/s ]
C   fmodv (NI*NK)  |   real  | wind speed at grid     [m/s] 
C   flwc (NI*NK)   |   real  | Cloud liquid water[unit?]
C   ftsoil(ni)     |   real  | Soil Temperature [K]                 
C   ice (NI)       |   real  | ice cover[0-1.]
C   snow (NI)      |   real  | snow cover[0-1.]
C   ffdss(ni)      |   real  | Ground solar irradiance(W/M**2),not used a present!
C   fdz (NI*NK)    |   real  | layer thickness [m],   
C   lat_deg (NI    |   real  | Grid latitude value    
C   long_deg(NI)   |   real  | Grid longitude value     
C   sza (ni)       |   real  | solar zenith angle, not used at present
C   frclds(NI*NK)  |   real  | Cloud cover, Strat.  [0-1.]   
C   frcldc(NI*NK)  |   real  | Cloud cover, Convec. [0-1.] 
C   qr (ni*2)      |   real  | Precip rate, 1 stratifor 2 Convective (kg /m2 s)|
C   mu(ni*(nk-1))  |   real  | upward cloud mass flux (positive up)(kg/m2/s) 
C   eu(ni*(nk-1))  |   real  | entrainment in updraft         
C   ntr            |  integer| number of tracer used in grapes
C  aq_date2        |         | Julian day infamation from general model
C   fhs(NI)        |   real  | SOIL MOISTUR
C  ROA(NI,NK)      !   real  ! air density  
C
C   output:
C
C aero_tr(ni*nk*num) |   real  | tracer concentration [kg/kg]    
C   local:           |
C
C
C IMPLICITES
      INTEGER i, k, n, indx, l
      INTEGER ik, isz
      INTEGER id
C     fonction-formule pour faciliter le calcul des indices
C      ik(i,k) = (k-1)*ni + i -1
C
      REAL t(ni, nk)
      REAL tb(ni, nk)
      REAL q(ni, nk)
      REAL qb(ni, nk)
      REAL psfc(ni)
      REAL psfcb(ni)
      REAL sig(ni, nk)
      REAL sigb(ni, nk)
      REAL hght(ni, nk)
      REAL roa(ni, nk)
      REAL lat_deg(ni)
      REAL lat_degb(ni)
      REAL long_deg(ni)
      REAL long_degb(ni)
      REAL sza(ni)
      REAL ice(ni)
      REAL iceb(ni)
      REAL snow(ni)
      REAL snowb(ni)
      REAL flwc(ni, nk)
      REAL fmodv(ni, nk)
      REAL fws(ni, nk)
      REAL frclds(ni, nk)
      REAL frcldc(ni, nk)
      REAL fdz(ni, nk)
      REAL frluc(ni, gnluc)
      REAL frlucb(ni, gnluc)
      REAL ftv(ni, nk)
      REAL fktm(ni, nk)
      REAL qr(ni, 2)
      REAL tnd(ni, nk)
      REAL surfwd(ni)
      REAL surfwdb(ni)
      REAL sst(ni)
      REAL ftsoil(ni)
      REAL ffdss(ni)
      REAL ffdssb(ni)
      REAL fhs(ni)
      REAL prate_2d(ni, nk-1, 2)
C zch 20090509
      REAL mu0(ni, nk-1), mu(ni, nk-1)
      REAL eu0(ni, nk-1), eu(ni, nk-1)
      REAL du0(ni, nk-1), du(ni, nk-1)
      REAL md0(ni, nk-1), md(ni, nk-1)
      REAL mc(ni, nk-1)
      REAL mcb(ni, nk-1)
      REAL ed0(ni, nk-1), ed(ni, nk-1)
      REAL dp0(ni, nk-1), dp(ni, nk-1)
      REAL dpb(ni, nk-1)
      REAL mb(ni)
      REAL mbb(ni)
      REAL eps0(ni)
      REAL zfg(ni, nk)
      REAL zfgb(ni, nk)
      REAL ww1(ni, nk)
      REAL dsubcld(ni)
      REAL dsubcldb(ni)
      INTEGER ideep(ni)
      INTEGER jt(ni)
      INTEGER maxg(ni)
      INTEGER jd(ni)
      INTEGER aq_date2
      INTEGER lengath
C zch 20100118 for pso4,psoa
      REAL pso4(ni, nk), psoa(ni, nk)
      REAL rd1, rd2, rd3
      REAL rrdrow(ni, 3, 2)
      REAL rrdrowb(ni, 3, 2)
C------------FOR SFFLUX-------------------------------------------------------------
C
      REAL dshj(ni, nk-1)
      REAL fintrow(ni, aero_nsize, 3)
C
      REAL aso4row(ni)
      REAL aso4rowb(ni)
      REAL pso4row(ni)
      REAL pso4rowb(ni)
      REAL poso4row(ni)
      REAL poso4rowb(ni)
      REAL aso2row(ni)
      REAL aso2rowb(ni)
      REAL pso2row(ni)
      REAL pso2rowb(ni)
      REAL poso2row(ni)
      REAL dmsorow(ni)
      REAL dmsorowb(ni)
      REAL dmslrow(ni)
      REAL dmslrowb(ni)
      REAL h2srow(ni)
      REAL h2srowb(ni)
      REAL volcrow(ni, 2)
      REAL blcrow(ni, 3, 2)
      REAL blcrowb(ni, 3, 2)
      REAL omcrow(ni, 3, 2)
      REAL omcrowb(ni, 3, 2)
      REAL ano3row(ni), pno3row(ni), pono3row(ni)
      REAL ano3rowb(ni), pno3rowb(ni), pono3rowb(ni)
C
      INTEGER icam, irest, mode, nsoil, ik1, il1, il2
      PARAMETER (nsoil=152, mode=2)
      REAL sand2row(ni, nats)
      REAL clay2row(ni, nct)
      REAL srel(ni, nsoil, nats)
      REAL sand6row(ni, ndt)
C
      REAL ss(ni, nsoil)
      REAL soilw(ni)
      REAL gc1(ni)
      REAL tbar(ni)
C
C
      REAL pxnew(ni, nk-1, ntr)
      REAL rsfrow(ni, ntr)
      REAL rsfrowb(ni, ntr)
      REAL roarow(ni, nk-1)
C Added for computation of sand flux .
      REAL roarow1(ni, nk-1), toproa(ni)
C
      CHARACTER stopfile*15
      INTEGER jlat, lon, nsub, isub, msg, ntraca
      PARAMETER (nsub=32, ntraca=5)
      REAL gmt, condnu(15), pop, pop1, tmin
      REAL shj(ni, nk-1)
      REAL rhrow(ni, nk)
      REAL tsrow(ni)
      REAL modv(ni, nk-1)
      REAL epsi(ni, nk-1)
      REAL f1(ni, nk-1, nsub)
      REAL f2(ni, nk-1, nsub)
      REAL ffg(ni, nk-1, 2*nsub)
      REAL wrow(ni, nk-1)
      REAL rhsize(ni, nk-1, aero_nsize)
      REAL rhop(ni, nk-1, aero_nsize)
      REAL ohrow(ni, nk-1)
      REAL h2o2row(ni, nk-1)
      REAL o3row(ni, nk-1)
      REAL no3row(ni, nk-1)
      REAL co2row(ni, nk-1)
      REAL nh3row(ni, nk-1)
      REAL hno3row(ni, nk-1)
      REAL totmas(ni, nk-1, aero_nsize)
      REAL pdiff(ni, nk-1, aero_nsize)
      REAL cldcv(ni, nk-1, 2)
      REAL zmlwc(ni, nk-1, 2)
      REAL wsub(ni, nk-1, nsub)
      REAL pretrow(ni, nk-1, 2)
      REAL radcld(ni, nk-1)
      REAL rgrid(ni, nk-1, ntr)
      REAL trwtrow(ni, nk-1, aero_nsize)
      REAL aeronum(ni, nk-1, aero_nsize)
      REAL zfprec(ni, nk-1)
      REAL pdepv(ni, nk-1, aero_nsize)
      REAL rtcoa(ni, nk-1, ntr)
      REAL rtdry(ni, nk-1, ntr)
      REAL rticld(ni, nk-1, ntr)
      REAL rtbcld(ni, nk-1, ntr)
      REAL thlev(ni, nk-1)
      REAL gdrem(ni, ntr, 3)
C wh 060629
      REAL gdrem1(ni, ntr)
      REAL gdrem1b(ni, ntr)
      REAL gdrem2(ni, ntr)
      REAL gdrem2b(ni, ntr)
      REAL gdrem3(ni, ntr)
      REAL gdrem3b(ni, ntr)
C
      REAL colef(ni, nk-1, aero_nsize)
      REAL wetdep(ni, nk-1, aero_nsize)
      REAL rtcond(ni, nk-1, aero_nsize)
      REAL rtso2(ni, nk-1, 2)
      REAL rtso4(ni, nk-1, aero_nsize)
      REAL rtdms(ni, nk-1)
      REAL rth2s(ni, nk-1)
      REAL rtnucl(ni, nk-1)
      REAL rth(ni, nk-1, aero_nsize)
      REAL vdg(ni, ng)
      REAL rcrits(ni, nk-1, 2)
      REAL rcoexs(ni, nk-1, 2)
      REAL wrz(ni, nk-1, aero_nsize, 2, 2)
      REAL wry(ni, nk-1, ntraca, 2)
      REAL wrx(ni)
      REAL wrw(ni, nk-1, ntr, 9)
      LOGICAL wru(ni, nk-1)
      REAL wra(ni*(nk-1)*36)
      REAL dz(ni, nk-1)
      REAL zz(ni, nk-1)
      REAL rthpo(ni, nk-1)
      REAL beta(ni, nk-1, aero_nsize*aero_nsize)
      REAL deliqs(ni, nk-1, aero_nsize)
      REAL recrys(ni, nk-1, aero_nsize)
      REAL wpevpa(ni, nk-1)
      REAL wrscav(ni, nk-1)
      REAL clsize(ni, nk-1, aero_nsize)
      REAL soa(ni, nk-1)
C
      INTEGER lamda
      PARAMETER (lamda=5)
      REAL abcoef(aero_nsize, 13, aero_chem_np-1, 14)
      REAL sccoef(aero_nsize, 13, aero_chem_np-1, 14)
      REAL aodrow1(ni, aero_chem_np-1, lamda)
      REAL aodrow2(ni, aero_chem_np-1, lamda)
      REAL rhrrow(ni)
C
Cxuemin
      REAL wrscav_2d(ni, nk-1)
      REAL zfprec_2d(ni, nk-1)
      REAL wpevpa_2d(ni, nk-1)
C---Arrays not be used in cam---------------------------------------------------------
      INTEGER nso4, itrvar
      REAL saverad
      REAL tcszrow(ni)
      REAL cszrow(ni)
      REAL surfdg(ni)
      REAL rtver(ni, nk-1, ntr)
C
      REAL tracg(ni, nk-1, ntr)
c      EXTERNAL DMIN1
c      EXTERNAL DMIN1_B
      REAL DMIN1
      INTEGER isize
      REAL ri
      REAL rib
      INTEGER j
      REAL voij
      REAL voijb
      REAL vok
      REAL vokb
      REAL vokp1
      REAL vokp1b
      EXTERNAL CVMGT
      EXTERNAL CVMGT_B
      REAL CVMGT
      REAL vokm1
      INTEGER itot
      REAL tcld3
      EXTERNAL CAM_V5
      EXTERNAL CAM_V5_B
      INTEGER m
      INTEGER arg1
      REAL result1
      DOUBLE PRECISION arg10
      DOUBLE PRECISION arg10b
      DOUBLE PRECISION arg2
      DOUBLE PRECISION arg2b
      DOUBLE PRECISION arg3
      DOUBLE PRECISION arg3b
      REAL result11
      REAL result11b
      DOUBLE PRECISION arg4
      DOUBLE PRECISION arg4b
      REAL result2
      REAL result2b
      REAL arg11
      REAL arg11b
      LOGICAL arg20
      REAL arg12
      REAL arg12b
      REAL tmp
      REAL tmp0
      REAL tmp1
      INTEGER ad_to
      INTEGER ad_to0
      INTEGER ad_from
      INTEGER ad_to1
      INTEGER ad_from0
      INTEGER ad_to2
      INTEGER branch
      INTEGER ad_from1
      INTEGER ad_to3
      INTEGER ad_from2
      INTEGER ad_to4
      INTEGER ad_from3
      INTEGER ad_to5
      INTEGER ad_to6
      INTEGER ad_to7
      INTEGER ad_to8
      INTEGER ad_to9
      INTEGER ad_to10
      INTEGER ad_from4
      INTEGER ad_from5
      REAL esp0
      DOUBLE PRECISION temp3
      DOUBLE PRECISION temp2
      DOUBLE PRECISION temp1
      REAL temp0
      INTRINSIC COS
      REAL pxnewb(ni, nk-1, 
     +     ntr)
      INTRINSIC DEXP
      INTRINSIC EXP
      REAL dshjb(ni, nk-1)
      REAL shjb(ni, nk-1)
      REAL temp9b0
      REAL ohrowb(ni, nk-1)
      REAL hno3rowb(ni, 
     +     nk-1)
      REAL temp0b(ni)
      REAL tmpb
      REAL tmp0b
      REAL gdremb(ni, ntr, 3)
      REAL o3rowb(ni, nk-1)
      REAL tsrowb(ni)
      REAL no3rowb(ni, nk-1)
      INTRINSIC FLOAT
      REAL roarowb(ni, nk-1)
      REAL rgridb(ni, nk-1, 
     +     ntr)
      REAL temp9b
      INTRINSIC MAXLOC
      REAL co2rowb(ni, nk-1)
      REAL h2o2rowb(ni, 
     +     nk-1)
      REAL temp0b3
      REAL temp0b2
      REAL temp0b1
      DOUBLE PRECISION temp0b0
      REAL rhrowb(ni, nk)
      INTRINSIC MAXVAL
      DOUBLE PRECISION temp5b
      INTRINSIC DBLE

!jinmin
      real wrab(ni*(nk-1)*36) 
      real wrwb(ni, nk-1, ntr, 9) 
      real eps0b(ni) 
      real wrzb(ni, nk-1, aero_nsize, 2, 2)  
      real rcoexsb(ni, nk-1, 2)  
      real wrxb(ni)  
      real wryb(ni, nk-1, ntraca, 2)  
      real rthpob(ni, nk-1)  
      real aeronumb(ni, nk-1, aero_nsize)  
      real z0b(luc, ns)  
      real trwtrowb(ni, nk-1, aero_nsize)  
      real radcldb(ni, nk-1)  
      real deliqsb(ni, nk-1, aero_nsize)  
      real betab(ni, nk-1, aero_nsize*aero_nsize)  
      real clsizeb(ni, nk-1, aero_nsize)  
      real recrysb(ni, nk-1, aero_nsize)  
      real rcritsb(ni, nk-1, 2)  
      real pdiffb(ni, nk-1, aero_nsize)  
      real totmasb(ni, nk-1, aero_nsize)  
      real rhopb(ni, nk-1, aero_nsize)  
      real rtcoab(ni, nk-1, ntr)  
      real pdepvb(ni, nk-1, aero_nsize)  
      real saveradb  
      real f2b(ni, nk-1, nsub)  
      real f1b(ni, nk-1, nsub)  
      real epsib(ni, nk-1)  
      real rhsizeb(ni, nk-1, aero_nsize)  
      real surfdgb(ni)  
      real ffgb(ni, nk-1, 2*nsub)  
      real rticldb(ni, nk-1, ntr)  
      real rth2sb(ni, nk-1)  
      real rtdmsb(ni, nk-1)  
      real rtso4b(ni, nk-1, aero_nsize)  
      real rthb(ni, nk-1, aero_nsize)  
      real rtnuclb(ni, nk-1)  
      real vdgb(ni, ng)  
      real rtverb(ni, nk-1, ntr)  
      real rtdryb(ni, nk-1, ntr)  
      real rtbcldb(ni, nk-1, ntr)  
      real rtcondb(ni, nk-1, aero_nsize)  
      real wetdepb(ni, nk-1, aero_nsize)  
      real colefb(ni, nk-1, aero_nsize)
      real wrscavb(ni, nk-1) 
      real wpevpab(ni, nk-1)
      real dzb(ni, nk-1)
      real zfprecb(ni, nk-1)
      real soab(ni, nk-1)
      real edb(ni, nk-1)
      real cldcvb(ni, nk-1, 2)
      real zmlwcb(ni, nk-1, 2)
      real wsubb(ni, nk-1, nsub)
      real cszrowb(ni)
      real modvb(ni, nk-1)
      real wrowb(ni, nk-1)
      real tcszrowb(ni)
      real eub(ni, nk-1)
      real dub(ni, nk-1)
      real mdb(ni, nk-1)
      real mub(ni,nk-1)
      real thlevb(ni, nk-1)
      real condnub(15)
      real rtso2b(ni, nk-1, 2)
      real pretrowb(ni, nk-1, 2)
      real inner

      INTEGER ii3
      INTEGER ii2
      REAL nh3rowb(ni, nk-1)
      INTEGER ii1
      REAL temp(ni)
      DOUBLE PRECISION temp8
      REAL tmp1b
      DOUBLE PRECISION temp7
      DOUBLE PRECISION temp6
      DOUBLE PRECISION temp5
      DOUBLE PRECISION temp4
      COMMON /times_b/ deltb
      COMMON /params_b/ gb
      COMMON /cam_r_b/ aerosizeb, camb, rhop0b, pvolb
      COMMON /depo_r_b/ pllpb, sccb, rcwb, acb, laicamb, rm0b, zpdb, 
     +fcapb, wpb, rgwb, aestb, gammab
      COMMON /coag_r_b/ coagfrb
      DATA aq_chem_l /.false./
      DATA aero_chem_l /.true./
      DATA st_chem_l /.false./
      DATA rvord, tfrez, hs_cam, hv_cam, daylnt /0.622, 273.16, 2.834e6
     +     , 2.501e6, 86400./
C
      DATA tmin /0.0/

C
CAdded by wang to seolve fohra is divided by zero 
C       REAL EPS1,EPS2
C       EPS1 =.62194800221014  !RGASD/RGASV
C       EPS2 =.3780199778986 ! 1 - EPS1
C
C
C       prapare parameters for INAero, H.WANG, OCT 26/2004
C       ISZ=aero_nsize+1
C       parameter(luc=gnluc)
C
C
C----------------------------------------------------------------------------------
C       print*,'-----begin aeroexe1----------'
      icam = ncam
C        print *, 'ICAM=', ICAM, aero_chem_np
C        print*,' land,aerosize,type=',luc,aero_nsize,aero_chem_np
C        print *, '***********************************'
C        print *, flwc
C        print *, '************************************'
C        print *, frclds
C

C       print*,'in aeroexe1_b.F ni=',ni,'   nk=',nk,'   ntr=',ntr

C       print*,'at the beginning of aeroexe1_b.F sum(aero_trb)=',
C     +                                                sum(aero_trb)
C       print*,'at the beginning of aeroexe1_b.F sum(blcrowb)=',
C     +                                                 sum(blcrowb)

      CALL INAERO(aeroname, aerosize, aero_chem_np, aero_nsize, rhop0, 
     +            iscam, id, jd, iti, itr, islev, cam, dlev, luc, ng, ns
     +            , ml, pllp, z0, scc, rcw, ac, cspec, laicam, rm0, zpd
     +            , fcap, wp, rgw, aest, gamma)
C
C
C-----------------------------------------------------------------
C
C	  DO L=1,LUC
C	    DO N=1,5
C	 	  Z0CAM(L,N)=Z0(L,N)
C	    ENDDO
C	  ENDDO
C
C
C
      arg1 = ni*aero_nsize*3
      CALL PUTZERO(fintrow, arg1)
C      CALL PUTZERO(SAND2ROW,NI*NATS)
C      CALL PUTZERO(CLAY2ROW,NI*2)
C      CALL PUTZERO(SAND6ROW,NI*6)
      CALL PUTZERO(gc1, ni)
C
      arg1 = ni*(nk-1)*ntr
      CALL PUTZERO(pxnew, arg1)
      arg1 = ni*ntr
      CALL PUTZERO(rsfrow, arg1)
      CALL PUSHINTEGER4(arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(roarow, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(shj, arg1)
      arg1 = ni*nk
      CALL PUTZERO(rhrow, arg1)
      CALL PUTZERO(tsrow, ni)
      arg1 = ni*(nk-1)
      CALL PUTZERO(modv, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(epsi, arg1)
      arg1 = ni*(nk-1)*nsub
      CALL PUTZERO(f1, arg1)
      arg1 = ni*(nk-1)*nsub
      CALL PUTZERO(f2, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(wrow, arg1)
      arg1 = ni*(nk-1)*aero_nsize
      CALL PUTZERO(rhsize, arg1)
      arg1 = ni*(nk-1)*aero_nsize
      CALL PUTZERO(rhop, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(ohrow, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(h2o2row, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(o3row, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(no3row, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(co2row, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(nh3row, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(hno3row, arg1)
      arg1 = ni*(nk-1)*aero_nsize
      CALL PUTZERO(totmas, arg1)
      arg1 = ni*(nk-1)*aero_nsize
      CALL PUTZERO(pdiff, arg1)
      arg1 = ni*(nk-1)*2
      CALL PUTZERO(cldcv, arg1)
      arg1 = ni*(nk-1)*nsub
      CALL PUTZERO(wsub, arg1)
      arg1 = ni*(nk-1)*2
      CALL PUTZERO(pretrow, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(radcld, arg1)
      arg1 = ni*(nk-1)*ntr
      CALL PUTZERO(rgrid, arg1)
      arg1 = ni*(nk-1)*aero_nsize
      CALL PUTZERO(trwtrow, arg1)
      arg1 = ni*(nk-1)*aero_nsize
      CALL PUTZERO(aeronum, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(zfprec, arg1)
      arg1 = ni*(nk-1)*aero_nsize
      CALL PUTZERO(pdepv, arg1)
      arg1 = ni*(nk-1)*ntr
      CALL PUTZERO(rtcoa, arg1)
      arg1 = ni*(nk-1)*ntr
      CALL PUTZERO(rtdry, arg1)
      arg1 = ni*(nk-1)*ntr
      CALL PUTZERO(rticld, arg1)
      arg1 = ni*(nk-1)*ntr
      CALL PUTZERO(rtbcld, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(thlev, arg1)
      arg1 = ni*ntr*3
      CALL PUTZERO(gdrem, arg1)
      arg1 = ni*(nk-1)*aero_nsize
      CALL PUTZERO(colef, arg1)
      arg1 = ni*(nk-1)*aero_nsize
      CALL PUTZERO(wetdep, arg1)
      arg1 = ni*(nk-1)*aero_nsize
      CALL PUTZERO(rtcond, arg1)
      arg1 = ni*(nk-1)*2
      CALL PUTZERO(rtso2, arg1)
      arg1 = ni*(nk-1)*aero_nsize
      CALL PUTZERO(rtso4, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(rtdms, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(rth2s, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(rtnucl, arg1)
      arg1 = ni*(nk-1)*aero_nsize
      CALL PUTZERO(rth, arg1)
      arg1 = ni*ng
      CALL PUTZERO(vdg, arg1)
      arg1 = ni*(nk-1)*2
      CALL PUTZERO(rcrits, arg1)
      arg1 = ni*(nk-1)*2
      CALL PUTZERO(rcoexs, arg1)
      arg1 = ni*(nk-1)*aero_nsize*2*2
      CALL PUTZERO(wrz, arg1)
      arg1 = ni*(nk-1)*ntraca*2
      CALL PUTZERO(wry, arg1)
      CALL PUTZERO(wrx, ni)
      arg1 = ni*(nk-1)*ntr*9
      CALL PUTZERO(wrw, arg1)
      arg1 = ni*(nk-1)*36
      CALL PUTZERO(wra, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(dz, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(zz, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(rthpo, arg1)
      arg1 = ni*(nk-1)*aero_nsize*aero_nsize
      CALL PUTZERO(beta, arg1)
      arg1 = ni*(nk-1)*aero_nsize
      CALL PUTZERO(deliqs, arg1)
      arg1 = ni*(nk-1)*aero_nsize
      CALL PUTZERO(recrys, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(wpevpa, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(wrscav, arg1)
      arg1 = ni*(nk-1)*aero_nsize
      CALL PUTZERO(clsize, arg1)
      arg1 = ni*(nk-1)
      CALL PUTZERO(soa, arg1)
C       print*,'point 1  aeroexe1_b.F sum(aero_trb)=',
C     +                                                sum(aero_trb)
C----------------------------------------------------------------------------------
C
C      if (aero_chem_L) then
C
      mae = nk - 1 - islev
CHP  new  June 8, 2004
      msg = 0
C
C----------------------------------------------------------------------
C             AEROSOL SURFACE FLUXES MODULE
C
C                  A - SEA-SALT
C                  B - SULPHATE
C                  C - BLACK CARBON
C                  D - OC
C                  E - SOIL DUST
C----------------------------------------------------------------------
CHP
      delt = 0.5*dt
CHP
      g = grav
CHP
CHP
C     PASS EMISSIOM DATA TO CAM EMISSION ARRAYS
C     END OFPASS EMISSIOM DATA TO CAM EMISSION ARRAYS
      IF (aero_chem_l) THEN
        arg1 = ni*(nk-1)
        CALL PUTZERO(dshj, arg1)
C
      END IF
C
      DO ik1=1,nk-1
        k = ik1 + 1
        shj(:, ik1) = sig(:, k)
Czhjh: from underside to upside.DSHJ>0.
        dshj(:, ik1) = sig(:, k) - sig(:, ik1)
C
        roarow(:, ik1) = psfc(:)*shj(:, ik1)/(rgasd*t(:, k))
C
Czch
c       mu(:, ik1) = mu0(:, k)
c       eu(:, ik1) = eu0(:, k)
c       du(:, ik1) = du0(:, k)
c       md(:, ik1) = md0(:, k)
c       ed(:, ik1) = ed0(:, k)
c       mc(:, ik1) = mu(:, ik1) + md(:, ik1)
        mu(:, ik1) =0.0 
        eu(:, ik1) =0.0 
        du(:, ik1) =0.0
        md(:, ik1) =0.0 
        ed(:, ik1) =0.0 
        mc(:, ik1) = mu(:, ik1) + md(:, ik1)
        wrow(:, ik1) = ww1(:, k)
      ENDDO
      CALL PUSHINTEGER4(ik1 - 1)
C
C---------------------------------------------------------------------------------
CI_SS for using specified sea-salt flux in sub sfss.!HP, will move into a control file later
CIREST for calculating sea-salt flux in sub sfss    !HP, will set by restart control
C
      il1 = 1
      il2 = ni
      i_ss = 1
      irest = 1
C
C      GC1=0.0   !open sea for test only  !HP 
C
C      if (IDEBUG.EQ.1) write(*,*)'in aeroexe1 SO2 0i',IDD,trnch,ISLEV,
C     &	aero_tr(IDD,ISLEV,cncaSO2)
C
C
Czhjh: Taken from loop do i.
C
C
C     do i=1, ni
C        if (f(mg+i-1).GT.0.1) then
C          GC1(i) = -1.0            !HP
C        else  !if (f(mg+i-1).EQ.0.0) then
C          GC1(i) = 0.0             !HP
C        else !if (ice(i).GT.0.5) then
C          GC1(i) = 1.0             !HP
C   ---FOR SSFLUX( )--------------------------------------------------------------
C       endif
C      end do
C
C------------------------------------------------------------------------
C
C
C Move here from the rear of chem_trcdiff2 .
Ccome form aero_chem_v1
      DO ik1=1,nk-1
        k = ik1 + 1
        DO i=1,ni
          thlev(i, ik1) = fdz(i, k)
          dz(i, ik1) = fdz(i, k)
        ENDDO
      ENDDO
      ad_from = il1
C       print*,'point 2  aeroexe1_b.F sum(aero_trb)=',
C    +                                                sum(aero_trb)
C
C
      DO i=ad_from,il2
Cntr-aero_diags                            !HP 
        DO l=iae1,icam
          rsfrow(i, l) = 0.0
        ENDDO
        CALL PUSHINTEGER4(l - 1)
        rsfrow(i, cncadms) = 0.0
        rsfrow(i, cncah2s) = 0.0
        rsfrow(i, cncaso2) = 0.0
        rsfrow(i, cncaso4) = 0.0
        rsfrow(i, cncah2o2) = 0.0
      ENDDO
      CALL PUSHINTEGER4(i - 1)
      CALL PUSHINTEGER4(ad_from)
C
C
C------------------------------------------------------------------------
C
      arg1 = nk - 1
      CALL PUSHreal8ARRAY(rsfrow, ni*ntr)
      CALL PUSHreal8ARRAY(pxnew, ni*(nk-1)*ntr)
      CALL PUSHreal8ARRAY(fintrow, ni*12*3)
      CALL PUSHreal8ARRAY(aero_tr, ni*nk*ntr)
      CALL SFFLUX(aero_tr, frluc, dshj, il1, il2, ni, nk, arg1, ntr, 
     +            aero_chem_np, aeroname, t, fintrow, volcrow, aso4row, 
     +            pso4row, poso4row, blcrow, dmsorow, dmslrow, h2srow, t
     +            (1, nk), aso2row, pso2row, poso2row, aero_nsize, rhop0
     +            , thlev, pxnew, aero_tr(1, 2, 1), aerosize, surfwd, 
     +            rsfrow, psfc, icam, roarow, gc1, iae1, cncah2s, 
     +            cncadms, cncaso2, cncaso4, irest, gnluc, i_ss, omcrow
     +            , sand2row, clay2row, snow, srel, nats, nsoil, mode, 
     +            mae, ns, z0, fhs, ss, surfdg, sand6row, tbar, ano3row
     +            , pno3row, pono3row, rrdrow)
C------------------------------------------------------------------------
C           print*,'aeroexe1 il1,il2=',il1,il2
C       print*,'point 3  aeroexe1_b.F sum(aero_trb)=',
c    +                                                sum(aero_trb)
C  only test dust aerosol wh 050225
      DO n=13,24
        ad_from1 = 1 + mae
        DO l=ad_from1,nk-1
          ad_from0 = il1
          DO i=ad_from0,il2
            IF (aero_tr(i, l, n) .LT. 0.0) THEN
C                WRITE (*,*)   'AERO_TR negative  after sfflux'        
C                WRITE (*,*) ' KOUNT     LEV      lat    long    ITR '
C                WRITE (*,*)  KOUNT, L,  LAT_DEG(I),   LONG_DEG(I),  N
C                WRITE (*,*) ' AERO_TR= ', AERO_TR(I,L,N)
C                WRITE (*,*) ' SURF FLUX ',ITR, '= ', RSFROW(I,N)
C                WRITE (*,*) ' SURF WIND ',ITR, '= ', SURFWD(I)
              aero_tr(i, l, n) = 0.0
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
          ENDDO
          CALL PUSHINTEGER4(i - 1)
          CALL PUSHINTEGER4(ad_from0)
        ENDDO
        CALL PUSHINTEGER4(l - 1)
        CALL PUSHINTEGER4(ad_from1)
      ENDDO
C
C
C
C------------------------------------------------------------------------
C apply vertical diffusion 
C preparing for subroutine chem_trvdiff2 
C added by H.Wang NOV. 25 2004      
C
      tr_loc = 0
      CALL PUSHINTEGER4(ni)
      CALL PUSHreal8ARRAY(fktm, ni*nk)
      CALL PUSHreal8ARRAY(aero_tr, ni*nk*ntr)
C
      CALL CHEM_TRVDIFF2(aero_tr, tr_loc, fktm, hght, dt, ni, nk, ntr, 
     +                   trnch)
C       print*,'point 4  aeroexe1_b.F sum(aero_trb)=',
C     +                                                sum(aero_trb)
C
C------------------------------------------------------------------------
C
C  only test dust aerosol wh 050225
      DO n=13,24
        ad_from3 = 1 + mae
        DO l=ad_from3,nk-1
          ad_from2 = il1
          DO i=ad_from2,il2
            IF (aero_tr(i, l, n) .LT. 0.0) THEN
C                WRITE (*,*)   'AERO_TR negative  after chem_trv'       
C                WRITE (*,*) '  KOUNT     LEV      lat    long    ITR '
C                WRITE (*,*)  KOUNT, L,  LAT_DEG(I),   LONG_DEG(I),  N
C                WRITE (*,*) ' AERO_TR= ', AERO_TR(I,L,N)
              aero_tr(i, l, n) = 0.0
              CALL PUSHCONTROL1B(1)
            ELSE
              CALL PUSHCONTROL1B(0)
            END IF
          ENDDO
          CALL PUSHINTEGER4(i - 1)
          CALL PUSHINTEGER4(ad_from2)
        ENDDO
        CALL PUSHINTEGER4(l - 1)
        CALL PUSHINTEGER4(ad_from3)
      ENDDO
C
C
C
C--------------------------------------------------------------------------
C
C   * PREPARATION FOR CALL AEROSOL PHYSICS
C
C     load arrays to be passed to CAM subroutines 
C
C
Ccome form aero_chem_v1
      DO ik1=1,nk-1
        CALL PUSHINTEGER4(k)
        k = ik1 + 1
        DO i=1,ni
C
Czhjh: Comment off at 2005.03.17 .
Czhjh:    THLEV(i,ik1) = fdz(i,k) ! get form aero_chem_v1
Czhjh:    dz(i,ik1) = fdz(i,k)    ! was set in cldprp -- easier to set here to fdz !! check 
C  why don't use THLEV() instead of dz() ?  HP???
Czhjh:    SHJ(i,ik1) = sig(i,k)  ! use this way first, check it later HP???
C
c         !jinmin
c         arg10 = DBLE(psfc(i)*sig(i, k))
c         arg2 = DBLE(psfc(i)*sig(i, k))
c         arg3 = DBLE(q(i, k))*DBLE(psfc(i)*sig(i, k))/(DBLE(eps1)+DBLE(
c    +      eps2)*DBLE(q(i, k)))
c         CALL PUSHREAL8(arg3)
c         CALL PUSHREAL8(arg2)
c         result11 = DMIN1(arg2, arg3)
c         arg4 = DBLE(result11)
c         CALL PUSHREAL8(arg4)
c         CALL PUSHREAL8(arg10)
c         result2 = DMIN1(arg10, arg4)
c         rhrow(i, k) = result2/(610.78d0*DEXP(17.269d0*(DBLE(t(i, k))-
c    +      DBLE(trpl))/(DBLE(t(i, k))-35.86d0)))

          RHROW(i,k) = FOHRA(q(i,k),t(i,k),psfc(i)*sig(i,k))

C
Cshould be refer to the relative chemistry speceis?! HP
          DO l=1,ntr
Cinstead of all tracers  HP!!!
            rgrid(i, ik1, l) = aero_tr(i, k, l)
          ENDDO
          CALL PUSHINTEGER4(l - 1)
C
C  tr in volume mixing ratio !!!! fixing here (into mass mixing ratio) 
C
          rgrid(i, ik1, cncaoh) = rgrid(i, ik1, cncaoh)*17./28.97
          rgrid(i, ik1, cncao3) = rgrid(i, ik1, cncao3)*48./28.97
          rgrid(i, ik1, cncah2o2) = rgrid(i, ik1, cncah2o2)*34./28.97
C
CP    rgrid(i,ik1,cncaSO2) = rgrid(i,ik1,cncaSO2) * 64./28.97             !if using geia_full emission data, stop this  HP
C
C
          rgrid(i, ik1, cncahno3) = rgrid(i, ik1, cncahno3)*63./28.97
C
          ohrow(i, ik1) = rgrid(i, ik1, cncaoh)
          h2o2row(i, ik1) = rgrid(i, ik1, cncah2o2)
          o3row(i, ik1) = rgrid(i, ik1, cncao3)
          no3row(i, ik1) = rgrid(i, ik1, cncano3)
          co2row(i, ik1) = rgrid(i, ik1, cncaco2)
          nh3row(i, ik1) = rgrid(i, ik1, cncanh3)
          hno3row(i, ik1) = rgrid(i, ik1, cncahno3)
          cldcv(i, ik1, 1) = frclds(i, k)
          cldcv(i, ik1, 2) = frcldc(i, k)
C
C fudge for now - use cloud lwc and frac. strat/conv.     !come from aero_chem_v1.ftn
          IF (frclds(i, k) + frcldc(i, k) .NE. 0.) THEN
Cstrat.
            zmlwc(i, ik1, 1) = flwc(i, k)*frclds(i, k)/(frclds(i, k)+
     +        frcldc(i, k))
Cconv.
            zmlwc(i, ik1, 2) = flwc(i, k)*frcldc(i, k)/(frclds(i, k)+
     +        frcldc(i, k))
C           print *, flwc(i,k),frclds(i,k),ZMLWC(i,ik1,1), 
C     &             ZMLWC(i,ik1,2), 'in aeroexe1 by zhouch'
          ELSE
            zmlwc(i, ik1, 1) = 0.0
            zmlwc(i, ik1, 2) = 0.0
          END IF
          modv(i, ik1) = fmodv(i, k)
C
C
C NEED TO FIX THIS 
C 1 stratiform  units?
          pretrow(i, ik1, 1) = prate_2d(i, ik1, 1)
C 2 convective
          pretrow(i, ik1, 2) = prate_2d(i, ik1, 2)
C
C          PRETROW(i,ik1,1) = qr(i,1)/(nk-1)  ! 1 stratiform  units?
C
C          PRETROW(i,ik1,2) = qr(i,2)/(nk-1)  ! 2 convective          
C
Cadded this loop for sub-grid
          DO isub=1,nsub
Cnow set its sub-grid with same wsub() !HP
            wsub(i, ik1, isub) = fws(i, k)
          ENDDO
        ENDDO
        CALL PUSHINTEGER4(i - 1)
      ENDDO
      CALL PUSHINTEGER4(ik1 - 1)
C
      DO i=1,ni
Cuse cosd() or sza() use radians !!?? HP
        cszrow(i) = COS(sza(i))
C        CSZROW(i) = f(cosas+i-1)  !use the cos( solar zenith angle ) directly  HP
Ccome form aero_chem_v1
        tsrow(i) = t(i, nk)
      ENDDO
      CALL PUSHINTEGER4(i - 1)
C
C to accumulate
      saverad = 1.
C
C     * COMPUTE THE TOTAL DAILY SOLAR ZENITH ANGLE
C
C      IF (GMT .EQ.0.0 .OR. IREST .EQ. 1) THEN  !this part could be deleted, we use OH get
C         DO I=IL1,IL2                          !from aq_chem and it is instant concentration
C            TCSZROW(I)=0.0
C         END DO
C         CLOCK=0.0
C         DO ITN=1,INT(DAYLNT/dt)
C           DO  I=IL1,IL2
C               CSZR = SINJ(I)*SIND - COSJ(I)*COSD*
C     1                   COS(2.*PI*( CLOCK/DAYLNT +
C     2                   long_deg(I)/360.))
C               CSZR = MAX(CSZR,1.E-6)
C               TCSZROW(I)=TCSZROW(I)+CSZR
C           END DO
C           CLOCK=CLOCK+dt
C         END DO
C      END IF
C
C   *********************  START OF BOX MODEL TEST DATA  ********************HP
      DO i=il1,il2
Cjust give a data to test its function, it is not used any more
        tcszrow(i) = 0.12526e+02
      ENDDO
      nso4 = 2
      DO l=1,nk-1
Capply these values for test only
        DO i=il1,il2
Cit is not used any more
          zz(i, l) = 0.39012e+02
C           ZFPREC(I,L)=1.E-9
C           WPEVPA(I,L)=0.5
C           WRSCAV(I,L)=0.5
Cxuemin           
          zfprec(i, l) = pretrow(i, l, 1)/hght(i, l)
          wpevpa(i, l) = wpevpa_2d(i, l)
          wrscav(i, l) = wrscav_2d(i, l)
        ENDDO
      ENDDO
Czch 20100118
      DO i=1,ni
        CALL PUSHINTEGER4(k)
        DO k=1,nk-1
          rtso2(i, k, 1) = pso4(i, k)
          soa(i, k) = psoa(i, k)
        ENDDO
      ENDDO
      CALL PUSHINTEGER4(i - 1)
C   *********************  END OF BOX MODEL TEST DATA  *********************HP
C
C    COMPUTE THE CONDENSATION/NUCLEATION TIME INTERVALS
C
      DO i=1,15
        pop1 = 2.*dt/EXP(FLOAT(15-i)/1.7)
        IF (i .GE. 2) THEN
          condnu(i) = pop1 - pop
          pop = pop1
        ELSE
          condnu(i) = pop1
          pop = pop1
        END IF
      ENDDO
C
      jlat = trnch
C
C-------------added by H.Wang to PREPARE IGF,IGFIJ AND COAGFR	2004/11/11
C
      isize = aero_nsize
C
      DO i=1,isize
        ri = (aerosize(1, i)+aerosize(2, i))/2.0
        pvol(i) = 4.189*ri*ri*ri
      ENDDO
      CALL PUSHINTEGER4(arg1)
C
      arg1 = isize*isize*isize
      CALL PUTZERO(coagfr, arg1)
      DO i=1,icob
        ad_from5 = i
        DO j=ad_from5,icob
          CALL PUSHreal8(voij)
          voij = pvol(i) + pvol(j)
          ad_from4 = j
          CALL PUSHINTEGER4(k)
          DO k=ad_from4,icob
            CALL PUSHreal8(vok)
            vok = pvol(k)
            IF (k .EQ. icob .AND. voij .GE. vok) THEN
              coagfr(i, j, k) = 1.0
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (k .LT. icob) THEN
              CALL PUSHreal8(vokp1)
              vokp1 = pvol(k+1)
              arg11 = vok/voij*(vokp1-voij)/(vokp1-vok)
              arg20 = voij .GE. vok .AND. voij .LT. vokp1
              CALL PUSHBOOLEAN(arg20)
              CALL PUSHreal8(coagfr(i, j, k))
              CALL PUSHreal8(arg11)
              tmp = CVMGT(arg11, coagfr(i, j, k), arg20)
              coagfr(i, j, k) = tmp
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            IF (k .GT. 1) THEN
              vokm1 = pvol(k-1)
              arg12 = 1. - coagfr(i, j, k-1)
              arg20 = voij .GT. vokm1 .AND. voij .LT. vok
              CALL PUSHBOOLEAN(arg20)
              CALL PUSHreal8(coagfr(i, j, k))
              CALL PUSHreal8(arg12)
              tmp0 = CVMGT(arg12, coagfr(i, j, k), arg20)
              coagfr(i, j, k) = tmp0
              CALL PUSHCONTROL1B(0)
            ELSE
              CALL PUSHCONTROL1B(1)
            END IF
            tmp1 = coagfr(i, j, k)
            coagfr(j, i, k) = tmp1
          ENDDO
          CALL PUSHINTEGER4(ad_from4)
        ENDDO
        CALL PUSHINTEGER4(ad_from5)
      ENDDO
      CALL PUSHINTEGER4(k)
C
      DO k=1,icob
        itot = 0
        DO j=1,icob
          DO i=1,icob
            IF (coagfr(i, j, k) .GT. 0.0) THEN
              itot = itot + 1
              igfij(k, itot, 1) = i
              igfij(k, itot, 2) = j
            END IF
          ENDDO
        ENDDO
        igf(k) = itot
      ENDDO
C       print*,'point 5  aeroexe1_b.F sum(aero_trb)=',
C     +                                                sum(aero_trb)
C
C    --------------------------------------------------------------------
C
C
C    * CALL AEROSOL PHYSICS
C
C        print *, 'begin cam_v05',trnch
C050319: 
Cif this aq_date2(2)=IDAY, have to check it  HP
Ct(1,nk) as SFCTROW() needs to be checked    HP
C knut
C knut
C knut
C knut
C knut

      arg1 = nk - 1
      CALL PUSHreal8ARRAY(frluc, ni*gnluc)
      CALL PUSHreal8(t(1, nk-1))
      CALL PUSHreal8(t(1, nk))
      CALL PUSHINTEGER4(icam)
      CALL PUSHreal8ARRAY(dshj, ni*(nk-1))
      CALL PUSHreal8ARRAY(thlev, ni*(nk-1))
      CALL PUSHreal8ARRAY(rhop0, 6)
      CALL PUSHreal8ARRAY(pso4row, ni)
      CALL PUSHreal8ARRAY(aso4row, ni)
      DO ii1=1,6
        CALL PUSHCHARACTERARRAY(aeroname(ii1), 8)
      ENDDO
      CALL PUSHreal8ARRAY(aerosize, 2*13)
      CALL PUSHreal8ARRAY(surfwd, ni)
      CALL PUSHINTEGER4(gnluc)
      CALL PUSHINTEGER4(ntr)
      CALL PUSHINTEGER4(mae)
      CALL PUSHINTEGER4(irest)
      CALL PUSHreal8ARRAY(q, ni*nk)
      CALL PUSHreal8ARRAY(sig, ni*nk)
      CALL PUSHreal8ARRAY(shj, ni*(nk-1))
      CALL PUSHreal8ARRAY(psfc, ni)
      CALL PUSHreal8ARRAY(t, ni*nk)
      CALL PUSHINTEGER4(il2)
      CALL PUSHINTEGER4(il1)
      CALL PUSHINTEGER4(nk)
      CALL PUSHINTEGER4(nk)
      CALL PUSHreal8(tcld3)
      CALL PUSHreal8ARRAY(rhrrow, ni)
      CALL PUSHreal8ARRAY(aodrow2, ni*5**2)
      CALL PUSHreal8ARRAY(aodrow1, ni*5**2)
      CALL PUSHreal8ARRAY(sccoef, 12*13*5*14)
      CALL PUSHreal8ARRAY(abcoef, 12*13*5*14)
      CALL PUSHreal8ARRAY(soa, ni*(nk-1))
      CALL PUSHreal8ARRAY(gamma, 15)
      CALL PUSHreal8ARRAY(aest, 15)
      CALL PUSHreal8ARRAY(rgw, 12)
      CALL PUSHreal8ARRAY(wp, 12)
      CALL PUSHreal8ARRAY(fcap, 12)
      CALL PUSHreal8ARRAY(zpd, 15*5)
      CALL PUSHreal8ARRAY(rm0, 12)
      CALL PUSHreal8ARRAY(laicam, 15*5)
      DO ii1=1,12
        CALL PUSHCHARACTERARRAY(cspec(ii1), 4)
      ENDDO
      CALL PUSHreal8ARRAY(ac, 12)
      CALL PUSHreal8ARRAY(rcw, 12)
      CALL PUSHreal8ARRAY(scc, 12)
      CALL PUSHreal8ARRAY(z0, 15*5)
      CALL PUSHreal8ARRAY(pllp, 15*5)
      CALL PUSHreal8(tmin)
      CALL PUSHreal8ARRAY(pvol, 12)
      CALL PUSHreal8ARRAY(coagfr, 12**3)
      CALL PUSHreal8ARRAY(clsize, ni*(nk-1)*12)
      CALL PUSHreal8ARRAY(wrscav, ni*(nk-1))
      CALL PUSHreal8ARRAY(wpevpa, ni*(nk-1))
      CALL PUSHreal8ARRAY(recrys, ni*(nk-1)*12)
      CALL PUSHreal8ARRAY(deliqs, ni*(nk-1)*12)
      CALL PUSHreal8ARRAY(beta, ni*(nk-1)*144)
      CALL PUSHreal8ARRAY(rthpo, ni*(nk-1))
      CALL PUSHINTEGER4(lengath)
      CALL PUSHINTEGER4ARRAY(jd, ni)
      CALL PUSHINTEGER4ARRAY(maxg, ni)
      CALL PUSHINTEGER4ARRAY(jt, ni)
      CALL PUSHINTEGER4ARRAY(ideep, ni)
      CALL PUSHreal8ARRAY(zz, ni*(nk-1))
      CALL PUSHreal8ARRAY(dsubcld, ni)
      CALL PUSHreal8ARRAY(zfg, ni*nk)
      CALL PUSHreal8ARRAY(eps0, ni)
      CALL PUSHreal8ARRAY(mb, ni)
      CALL PUSHreal8ARRAY(dz, ni*(nk-1))
      CALL PUSHreal8ARRAY(dp, ni*(nk-1))
      CALL PUSHreal8ARRAY(ed, ni*(nk-1))
      CALL PUSHreal8ARRAY(mc, ni*(nk-1))
      CALL PUSHreal8ARRAY(md, ni*(nk-1))
      CALL PUSHreal8ARRAY(du, ni*(nk-1))
      CALL PUSHreal8ARRAY(eu, ni*(nk-1))
      CALL PUSHreal8ARRAY(mu, ni*(nk-1))
      CALL PUSHreal8ARRAY(wra, ni*(nk-1)*36)
      CALL PUSHBOOLEANARRAY(wru, ni*(nk-1))
      CALL PUSHreal8ARRAY(wrw, ni*(nk-1)*ntr*9)
      CALL PUSHreal8ARRAY(wrx, ni)
      CALL PUSHreal8ARRAY(wry, ni*(nk-1)*5*2)
      CALL PUSHreal8ARRAY(wrz, ni*(nk-1)*12*2**2)
      CALL PUSHreal8ARRAY(rcoexs, ni*(nk-1)*2)
      CALL PUSHreal8ARRAY(rcrits, ni*(nk-1)*2)
      CALL PUSHINTEGER4ARRAY(igfij, 12*144*2)
      CALL PUSHINTEGER4(msg)
      CALL PUSHreal8ARRAY(rth, ni*(nk-1)*12)
      CALL PUSHreal8ARRAY(rtnucl, ni*(nk-1))
      CALL PUSHINTEGER4(aq_date2)
      CALL PUSHreal8ARRAY(ffdss, ni)
      CALL PUSHreal8ARRAY(vdg, ni*12)
      CALL PUSHreal8ARRAY(rth2s, ni*(nk-1))
      CALL PUSHreal8ARRAY(rtdms, ni*(nk-1))
      CALL PUSHreal8ARRAY(rtso4, ni*(nk-1)*12)
      CALL PUSHreal8ARRAY(rtso2, ni*(nk-1)*2)
      CALL PUSHreal8ARRAY(rtcond, ni*(nk-1)*12)
      CALL PUSHreal8ARRAY(condnu, 15)
      CALL PUSHreal8ARRAY(wetdep, ni*(nk-1)*12)
      CALL PUSHreal8ARRAY(colef, ni*(nk-1)*12)
      CALL PUSHINTEGER4(jdd)
      CALL PUSHreal8ARRAY(gdrem, ni*ntr*3)
      CALL PUSHreal8ARRAY(rtver, ni*(nk-1)*ntr)
      CALL PUSHreal8ARRAY(rtdry, ni*(nk-1)*ntr)
      CALL PUSHreal8ARRAY(rtbcld, ni*(nk-1)*ntr)
      CALL PUSHreal8ARRAY(rticld, ni*(nk-1)*ntr)
      CALL PUSHreal8ARRAY(rtcoa, ni*(nk-1)*ntr)
      CALL PUSHreal8ARRAY(pdepv, ni*(nk-1)*12)
      CALL PUSHreal8ARRAY(pxnew, ni*(nk-1)*ntr)
      CALL PUSHreal8ARRAY(zfprec, ni*(nk-1))
      CALL PUSHreal8ARRAY(snow, ni)
      CALL PUSHreal8ARRAY(ice, ni)
      CALL PUSHreal8ARRAY(aeronum, ni*(nk-1)*12)
      CALL PUSHreal8ARRAY(roarow, ni*(nk-1))
      CALL PUSHreal8ARRAY(trwtrow, ni*(nk-1)*12)
      CALL PUSHreal8ARRAY(rgrid, ni*(nk-1)*ntr)
      CALL PUSHreal8ARRAY(radcld, ni*(nk-1))
      CALL PUSHreal8ARRAY(pretrow, ni*(nk-1)*2)
      CALL PUSHreal8(saverad)
      CALL PUSHreal8ARRAY(wsub, ni*(nk-1)*32)
      CALL PUSHreal8ARRAY(zmlwc, ni*(nk-1)*2)
      CALL PUSHreal8ARRAY(cldcv, ni*(nk-1)*2)
      CALL PUSHreal8ARRAY(pdiff, ni*(nk-1)*12)
      CALL PUSHINTEGER4(idd)
      CALL PUSHreal8ARRAY(totmas, ni*(nk-1)*12)
      CALL PUSHreal8ARRAY(hno3row, ni*(nk-1))
      CALL PUSHreal8ARRAY(nh3row, ni*(nk-1))
      CALL PUSHreal8ARRAY(co2row, ni*(nk-1))
      CALL PUSHreal8ARRAY(no3row, ni*(nk-1))
      CALL PUSHreal8ARRAY(o3row, ni*(nk-1))
      CALL PUSHreal8ARRAY(h2o2row, ni*(nk-1))
      CALL PUSHreal8ARRAY(ohrow, ni*(nk-1))
      CALL PUSHINTEGER4(nso4)
      CALL PUSHreal8ARRAY(h2srow, ni)
      CALL PUSHreal8ARRAY(dmslrow, ni)
      CALL PUSHreal8ARRAY(dmsorow, ni)
      CALL PUSHreal8ARRAY(pso2row, ni)
      CALL PUSHreal8ARRAY(aso2row, ni)
      CALL PUSHreal8ARRAY(rhop, ni*(nk-1)*12)
      CALL PUSHreal8ARRAY(rhsize, ni*(nk-1)*12)
      CALL PUSHreal8ARRAY(surfdg, ni)
      CALL PUSHINTEGER4(kount)
      CALL PUSHreal8ARRAY(tracg, ni*(nk-1)*ntr)
      CALL PUSHINTEGER4ARRAY(igf, 12)
      CALL PUSHreal8(gmt)
      CALL PUSHreal8ARRAY(cszrow, ni)
      CALL PUSHreal8ARRAY(tcszrow, ni)
      CALL PUSHreal8ARRAY(wrow, ni*(nk-1))
      CALL PUSHreal8ARRAY(ffg, ni*(nk-1)*64)
      CALL PUSHreal8ARRAY(f2, ni*(nk-1)*32)
      CALL PUSHreal8ARRAY(f1, ni*(nk-1)*32)
      CALL PUSHINTEGER4(dlev)
      CALL PUSHreal8ARRAY(epsi, ni*(nk-1))
      CALL PUSHreal8ARRAY(rsfrow, ni*ntr)
      CALL PUSHreal8ARRAY(modv, ni*(nk-1))
      CALL PUSHreal8ARRAY(tsrow, ni)
      CALL PUSHINTEGER4(itr)
      CALL PUSHINTEGER4(iti)
      CALL PUSHreal8ARRAY(long_deg, ni)
      CALL PUSHreal8ARRAY(lat_deg, ni)
      CALL PUSHreal8(cam)
      CALL PUSHreal8ARRAY(aero_tr, ni*nk*ntr)
      CALL PUSHINTEGER4(lon)
      CALL PUSHreal8ARRAY(rhrow, ni*nk)
      CALL PUSHINTEGER4(itrvar)
      CALL PUSHINTEGER4(jlat)
      CALL PUSHINTEGER4(ni)
      CALL PUSHINTEGER4(arg1)
C       print*,'point 6  aeroexe1_b.F sum(aero_trb)=',
C     +                                                sum(aero_trb)
      CALL CAM_V5(arg1, nk, ni, il1, il2, jlat, itrvar, t, rhrow, lon, 
     +            aero_tr, psfc, shj, sig, cam, lat_deg, long_deg, q, 
     +            iti, itr, tsrow, modv, rsfrow, epsi, dlev, f1, f2, ffg
     +            , wrow, irest, tcszrow, cszrow, gmt, mae, igf, tracg, 
     +            ntr, aero_chem_np, kount, gnluc, surfdg, surfwd, 
     +            aerosize, rhsize, rhop, aeroname, aero_nsize, aso2row
     +            , pso2row, aso4row, pso4row, dmsorow, dmslrow, h2srow
     +            , nso4, ohrow, h2o2row, o3row, no3row, co2row, nh3row
     +            , hno3row, totmas, nsub, idd, pdiff, cldcv, zmlwc, 
     +            wsub, saverad, pretrow, radcld, rgrid, trwtrow, roarow
     +            , rhop0, aeronum, ice, snow, zfprec, pxnew, pdepv, 
     +            rtcoa, rticld, rtbcld, rtdry, rtver, thlev, dshj, 
     +            gdrem, jdd, colef, wetdep, cncah2s, cncah2o2, cncadms
     +            , cncaso2, cncaso4, iae1, icam, cncalwc, cncaiwc, 
     +            cncaccn, cncaclf, condnu, rtcond, rtso2, rtso4, rtdms
     +            , rth2s, vdg, ffdss, aq_date2, t(1, nk), t(1, nk-1), 
     +            frluc, rtnucl, rth, msg, igfij, rcrits, rcoexs, wrz, 
     +            wry, wrx, wrw, wru, wra, mu, eu, du, md, mc, ed, dp, 
     +            dz, mb, eps0, zfg, dsubcld, zz, ideep, jt, maxg, jd, 
     +            lengath, ntraca, rthpo, beta, deliqs, recrys, wpevpa, 
     +            wrscav, clsize, coagfr, pvol, tmin, ng, ns, nl, pllp, 
     +            z0, scc, rcw, ac, cspec, laicam, rm0, zpd, fcap, wp, 
     +            rgw, aest, gamma, soa, abcoef, sccoef, aodrow1, 
     +            aodrow2, rhrrow, lamda)

C       print*,'before initial in aeroexe1_b.F sum(aero_trb)=',
C     +                                                 sum(aero_trb)
C       print*,'before initial in aeroexe1_b.F sum(blcrowb)=',
C     +                                                  sum(blcrowb)

      !jinmin
      tb=0.0
      qb=0.0
      psfcb= 0.0
      sigb=0.0
      surfwdb=0.0
      iceb=0.0
      snowb= 0.0
      lat_degb=0.0
      long_degb=0.0

      DO ii1=1,3
        DO ii2=1,ntr
          DO ii3=1,ni
            gdremb(ii3, ii2, ii1) = 0.0
          ENDDO
        ENDDO
      ENDDO
      DO i=ni,1,-1
        DO m=ntr,1,-1
          gdremb(i, m, 3) = gdremb(i, m, 3) + gdrem3b(i, m)
          gdrem3b(i, m) = 0.0
          gdremb(i, m, 2) = gdremb(i, m, 2) + gdrem2b(i, m)
          gdrem2b(i, m) = 0.0
          gdremb(i, m, 1) = gdremb(i, m, 1) + gdrem1b(i, m)
          gdrem1b(i, m) = 0.0
        ENDDO
      ENDDO
      CALL POPINTEGER4(arg1)
      CALL POPINTEGER4(ni)
      CALL POPINTEGER4(jlat)
      CALL POPINTEGER4(itrvar)
      CALL POPreal8ARRAY(rhrow, ni*nk)
      CALL POPINTEGER4(lon)
      CALL POPreal8ARRAY(aero_tr, ni*nk*ntr)
      CALL POPreal8(cam)
      CALL POPreal8ARRAY(lat_deg, ni)
      CALL POPreal8ARRAY(long_deg, ni)
      CALL POPINTEGER4(iti)
      CALL POPINTEGER4(itr)
      CALL POPreal8ARRAY(tsrow, ni)
      CALL POPreal8ARRAY(modv, ni*(nk-1))
      CALL POPreal8ARRAY(rsfrow, ni*ntr)
      CALL POPreal8ARRAY(epsi, ni*(nk-1))
      CALL POPINTEGER4(dlev)
      CALL POPreal8ARRAY(f1, ni*(nk-1)*32)
      CALL POPreal8ARRAY(f2, ni*(nk-1)*32)
      CALL POPreal8ARRAY(ffg, ni*(nk-1)*64)
      CALL POPreal8ARRAY(wrow, ni*(nk-1))
      CALL POPreal8ARRAY(tcszrow, ni)
      CALL POPreal8ARRAY(cszrow, ni)
      CALL POPreal8(gmt)
      CALL POPINTEGER4ARRAY(igf, 12)
      CALL POPreal8ARRAY(tracg, ni*(nk-1)*ntr)
      CALL POPINTEGER4(kount)
      CALL POPreal8ARRAY(surfdg, ni)
      CALL POPreal8ARRAY(rhsize, ni*(nk-1)*12)
      CALL POPreal8ARRAY(rhop, ni*(nk-1)*12)
      CALL POPreal8ARRAY(aso2row, ni)
      CALL POPreal8ARRAY(pso2row, ni)
      CALL POPreal8ARRAY(dmsorow, ni)
      CALL POPreal8ARRAY(dmslrow, ni)
      CALL POPreal8ARRAY(h2srow, ni)
      CALL POPINTEGER4(nso4)
      CALL POPreal8ARRAY(ohrow, ni*(nk-1))
      CALL POPreal8ARRAY(h2o2row, ni*(nk-1))
      CALL POPreal8ARRAY(o3row, ni*(nk-1))
      CALL POPreal8ARRAY(no3row, ni*(nk-1))
      CALL POPreal8ARRAY(co2row, ni*(nk-1))
      CALL POPreal8ARRAY(nh3row, ni*(nk-1))
      CALL POPreal8ARRAY(hno3row, ni*(nk-1))
      CALL POPreal8ARRAY(totmas, ni*(nk-1)*12)
      CALL POPINTEGER4(idd)
      CALL POPreal8ARRAY(pdiff, ni*(nk-1)*12)
      CALL POPreal8ARRAY(cldcv, ni*(nk-1)*2)
      CALL POPreal8ARRAY(zmlwc, ni*(nk-1)*2)
      CALL POPreal8ARRAY(wsub, ni*(nk-1)*32)
      CALL POPreal8(saverad)
      CALL POPreal8ARRAY(pretrow, ni*(nk-1)*2)
      CALL POPreal8ARRAY(radcld, ni*(nk-1))
      CALL POPreal8ARRAY(rgrid, ni*(nk-1)*ntr)
      CALL POPreal8ARRAY(trwtrow, ni*(nk-1)*12)
      CALL POPreal8ARRAY(roarow, ni*(nk-1))
      CALL POPreal8ARRAY(aeronum, ni*(nk-1)*12)
      CALL POPreal8ARRAY(ice, ni)
      CALL POPreal8ARRAY(snow, ni)
      CALL POPreal8ARRAY(zfprec, ni*(nk-1))
      CALL POPreal8ARRAY(pxnew, ni*(nk-1)*ntr)
      CALL POPreal8ARRAY(pdepv, ni*(nk-1)*12)
      CALL POPreal8ARRAY(rtcoa, ni*(nk-1)*ntr)
      CALL POPreal8ARRAY(rticld, ni*(nk-1)*ntr)
      CALL POPreal8ARRAY(rtbcld, ni*(nk-1)*ntr)
      CALL POPreal8ARRAY(rtdry, ni*(nk-1)*ntr)
      CALL POPreal8ARRAY(rtver, ni*(nk-1)*ntr)
      CALL POPreal8ARRAY(gdrem, ni*ntr*3)
      CALL POPINTEGER4(jdd)
      CALL POPreal8ARRAY(colef, ni*(nk-1)*12)
      CALL POPreal8ARRAY(wetdep, ni*(nk-1)*12)
      CALL POPreal8ARRAY(condnu, 15)
      CALL POPreal8ARRAY(rtcond, ni*(nk-1)*12)
      CALL POPreal8ARRAY(rtso2, ni*(nk-1)*2)
      CALL POPreal8ARRAY(rtso4, ni*(nk-1)*12)
      CALL POPreal8ARRAY(rtdms, ni*(nk-1))
      CALL POPreal8ARRAY(rth2s, ni*(nk-1))
      CALL POPreal8ARRAY(vdg, ni*12)
      CALL POPreal8ARRAY(ffdss, ni)
      CALL POPINTEGER4(aq_date2)
      CALL POPreal8ARRAY(rtnucl, ni*(nk-1))
      CALL POPreal8ARRAY(rth, ni*(nk-1)*12)
      CALL POPINTEGER4(msg)
      CALL POPINTEGER4ARRAY(igfij, 12*144*2)
      CALL POPreal8ARRAY(rcrits, ni*(nk-1)*2)
      CALL POPreal8ARRAY(rcoexs, ni*(nk-1)*2)
      CALL POPreal8ARRAY(wrz, ni*(nk-1)*12*2**2)
      CALL POPreal8ARRAY(wry, ni*(nk-1)*5*2)
      CALL POPreal8ARRAY(wrx, ni)
      CALL POPreal8ARRAY(wrw, ni*(nk-1)*ntr*9)
      CALL POPBOOLEANARRAY(wru, ni*(nk-1))
      CALL POPreal8ARRAY(wra, ni*(nk-1)*36)
      CALL POPreal8ARRAY(mu, ni*(nk-1))
      CALL POPreal8ARRAY(eu, ni*(nk-1))
      CALL POPreal8ARRAY(du, ni*(nk-1))
      CALL POPreal8ARRAY(md, ni*(nk-1))
      CALL POPreal8ARRAY(mc, ni*(nk-1))
      CALL POPreal8ARRAY(ed, ni*(nk-1))
      CALL POPreal8ARRAY(dp, ni*(nk-1))
      CALL POPreal8ARRAY(dz, ni*(nk-1))
      CALL POPreal8ARRAY(mb, ni)
      CALL POPreal8ARRAY(eps0, ni)
      CALL POPreal8ARRAY(zfg, ni*nk)
      CALL POPreal8ARRAY(dsubcld, ni)
      CALL POPreal8ARRAY(zz, ni*(nk-1))
      CALL POPINTEGER4ARRAY(ideep, ni)
      CALL POPINTEGER4ARRAY(jt, ni)
      CALL POPINTEGER4ARRAY(maxg, ni)
      CALL POPINTEGER4ARRAY(jd, ni)
      CALL POPINTEGER4(lengath)
      CALL POPreal8ARRAY(rthpo, ni*(nk-1))
      CALL POPreal8ARRAY(beta, ni*(nk-1)*144)
      CALL POPreal8ARRAY(deliqs, ni*(nk-1)*12)
      CALL POPreal8ARRAY(recrys, ni*(nk-1)*12)
      CALL POPreal8ARRAY(wpevpa, ni*(nk-1))
      CALL POPreal8ARRAY(wrscav, ni*(nk-1))
      CALL POPreal8ARRAY(clsize, ni*(nk-1)*12)
      CALL POPreal8ARRAY(coagfr, 12**3)
      CALL POPreal8ARRAY(pvol, 12)
      CALL POPreal8(tmin)
      CALL POPreal8ARRAY(pllp, 15*5)
      CALL POPreal8ARRAY(z0, 15*5)
      CALL POPreal8ARRAY(scc, 12)
      CALL POPreal8ARRAY(rcw, 12)
      CALL POPreal8ARRAY(ac, 12)
      DO ii1=12,1,-1
        CALL POPCHARACTERARRAY(cspec(ii1), 4)
      ENDDO
      CALL POPreal8ARRAY(laicam, 15*5)
      CALL POPreal8ARRAY(rm0, 12)
      CALL POPreal8ARRAY(zpd, 15*5)
      CALL POPreal8ARRAY(fcap, 12)
      CALL POPreal8ARRAY(wp, 12)
      CALL POPreal8ARRAY(rgw, 12)
      CALL POPreal8ARRAY(aest, 15)
      CALL POPreal8ARRAY(gamma, 15)
      CALL POPreal8ARRAY(soa, ni*(nk-1))
      CALL POPreal8ARRAY(abcoef, 12*13*5*14)
      CALL POPreal8ARRAY(sccoef, 12*13*5*14)
      CALL POPreal8ARRAY(aodrow1, ni*5**2)
      CALL POPreal8ARRAY(aodrow2, ni*5**2)
      CALL POPreal8ARRAY(rhrrow, ni)
      CALL POPreal8(tcld3)
      CALL LOOKINTEGER4(nk)
      CALL LOOKINTEGER4(nk)
      CALL LOOKINTEGER4(il1)
      CALL LOOKINTEGER4(il2)
      CALL LOOKreal8ARRAY(t, ni*nk)
      CALL LOOKreal8ARRAY(psfc, ni)
      CALL LOOKreal8ARRAY(shj, ni*(nk-1))
      CALL LOOKreal8ARRAY(sig, ni*nk)
      CALL LOOKreal8ARRAY(q, ni*nk)
      CALL LOOKINTEGER4(irest)
      CALL LOOKINTEGER4(mae)
      CALL LOOKINTEGER4(ntr)
      CALL LOOKINTEGER4(gnluc)
      CALL LOOKreal8ARRAY(surfwd, ni)
      CALL LOOKreal8ARRAY(aerosize, 2*13)
      DO ii1=6,1,-1
        CALL LOOKCHARACTERARRAY(aeroname(ii1), 8)
      ENDDO
      CALL LOOKreal8ARRAY(aso4row, ni)
      CALL LOOKreal8ARRAY(pso4row, ni)
      CALL LOOKreal8ARRAY(rhop0, 6)
      CALL LOOKreal8ARRAY(thlev, ni*(nk-1))
      CALL LOOKreal8ARRAY(dshj, ni*(nk-1))
      CALL LOOKINTEGER4(icam)
      CALL LOOKreal8(t(1, nk))
      CALL LOOKreal8(t(1, nk-1))
      CALL LOOKreal8ARRAY(frluc, ni*gnluc)
      DO ii1=1,nk
        DO ii2=1,ni
          rhrowb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
      DO ii1=1,nk-1
        DO ii2=1,ni
          shjb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
      DO ii1=1,ni
        tsrowb(ii1) = 0.0
      ENDDO
      DO ii1=1,nk-1
        DO ii2=1,ni
          ohrowb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
      DO ii1=1,nk-1
        DO ii2=1,ni
          h2o2rowb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
      DO ii1=1,nk-1
        DO ii2=1,ni
          o3rowb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
      DO ii1=1,nk-1
        DO ii2=1,ni
          no3rowb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
      DO ii1=1,nk-1
        DO ii2=1,ni
          co2rowb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
      DO ii1=1,nk-1
        DO ii2=1,ni
          nh3rowb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
      DO ii1=1,nk-1
        DO ii2=1,ni
          hno3rowb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
      DO ii1=1,ntr
        DO ii2=1,nk-1
          DO ii3=1,ni
            rgridb(ii3, ii2, ii1) = 0.0
          ENDDO
        ENDDO
      ENDDO
      DO ii1=1,nk-1
        DO ii2=1,ni
          roarowb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
      DO ii1=1,ntr
        DO ii2=1,nk-1
          DO ii3=1,ni
            pxnewb(ii3, ii2, ii1) = 0.0
          ENDDO
        ENDDO
      ENDDO
      DO ii1=1,nk-1
        DO ii2=1,ni
          dshjb(ii2, ii1) = 0.0
        ENDDO
      ENDDO
 
C      print*,'before cam_v5_b,sum(aero_trb)=',sum(aero_trb)
C      print*,'before cam_v5_b,sum(blcrowb)=',sum(blcrowb)

      CALL CAM_V5_B(       arg1,       nk,       ni,      il1,      il2, 
     4                     jlat,   itrvar,        t,    rhrow,      lon,
     3                  aero_tr,     psfc,      shj,      sig,      cam,
     1                  lat_deg, long_deg,        q,      iti,      itr,
     1                    tsrow,     modv,   rsfrow,     epsi,     dlev,
     2                       f1,       f2,      ffg,     wrow,    irest,
     3                  TCSZROW,   CSZROW,      GMT,      MAE,      IGF,
     4                   TRACG,      NTR, aero_chem_np,    KOUNT, gnluc,
     5                   SURFDG,   SURFWD, AEROSIZE,   RHSIZE,     RHOP,
     6            AERONAME,    aero_nsize,  ASO2ROW,  PSO2ROW,  ASO4ROW,
     7                  PSO4ROW,  DMSOROW,  DMSLROW,   H2SROW,     NSO4,
     1                    OHROW,  H2O2ROW,    O3ROW,   NO3ROW,   CO2ROW,
     9                   NH3ROW,  HNO3ROW,   TOTMAS,     NSUB,      IDD,
     3                    PDIFF,    CLDCV,    ZMLWC,     WSUB,  SAVERAD,
     6                  pretrow,   RADCLD,    RGRID,  TRWTROW,   ROAROW,
     9                    RHOP0,  AERONUM,  ice,  snow,   ZFPREC,
     A                    PXNEW,    PDEPV,    RTCOA,   RTICLD,   RTBCLD,
     B                    RTDRY,    RTVER,    THLEV,     DSHJ,    GDREM,
     C                     JDD,    COLEF,   WETDEP,cncah2s,    cncah2o2,
     D                     cncadms, cncaso2, cncaso4,    IAE1,     ICAM,
     E                     cncalwc, cncaiwc, cncaccn, cncaclf,   CONDNU,
     6                   RTCOND,    RTSO2,    RTSO4,    RTDMS,    RTH2S,
     E                   VDG,   ffdss,   aq_date2,  T(1,nk),  T(1,nk-1), 
     8                    frluc,   RTNUCL,      RTH,      MSG,    IGFIJ,
     A                   RCRITS,   RCOEXS,      WRZ,      WRY,      WRX,   ! knut
     B                      WRW,      WRU,      WRA,       MU,       EU,   ! knut
     C                       DU,       MD,       MC,       ED,       DP,   ! knut
     D                       DZ,       MB,     EPS0,      ZFG,  DSUBCLD,   ! knut
     E                       ZZ,    IDEEP,       JT,     MAXG,      JD,   ! knut
     F                  LENGATH,   NTRACA,    RTHPO,     BETA,   DELIQS,
     G                   RECRYS,   WPEVPA,   WRSCAV,   CLSIZE,   COAGFR,
     H                     PVOL,     TMIN,       NG,       NS,       NL,
     3                     PLLP,       Z0,      SCC,   RCW,   AC, CSPEC,
     4                   LAIcam,      RM0,      ZPD,    FCAP,   WP, RGW,
     5                     AEST,     GAMMA,     SOA,   ABCOEF,   SCCOEF,  
     6                   AODROW1,  AODROW2,  RHRROW,    LAMDA,
cccccccccccccc   for ad model  ccccccccccccc
     +               TB,    RHROWB,     aero_trB,   psfcB,        SHJB,
     +             sigb,     QB,    TSROWB,     MODVB, 
     +             EPSIB,       F1B,       F2B,       ffgB,       WROWB,
     +           TCSZROWB,   CSZROWB,   SURFDGB,   SURFWDB,   AEROSIZEB, 
     +            RHSIZEB,     RHOPB,    OHROWB,  H2O2ROWB,      O3ROWB,
     +            NO3ROWB,   CO2ROWB,   TOTMASB,    PDIFFB,      CLDCVB,
     +             ZMLWCB,     WSUBB,   ROAROWB,    PXNEWB,  
     +             PDEPVB,    RTCOAB,   RTICLDB,   RTBCLDB,      RTDRYB,
     +             THLEVB,     DSHJB,    GDREMB,    COLEFB,
     +            WETDEPB,   CONDNUB,   RTCONDB,    RTSO2B,      RTSO4B,
     +             RTDMSB,    RTH2SB,      VDGB,   ffdssB,     TB(1,nk), 
     +         TB(1,nk-1),    frlucB,   RTNUCLB,      RTHB,     RCRITSB,
     +            RCOEXSB,      WRZB,      WRYB,      WRXB,        WRWB, 
     +               WRAB,       MUB,       EUB,       DUB, 
     +                MDB,       MCB,       EDB,       DPB,         DZB,
     +                MBB,     EPS0B,      ZFGB,  DSUBCLDB,        
     +             RTHPOB,     BETAB,   DELIQSB,   RECRYSB,     WPEVPAB, 
     +            WRSCAVB,   CLSIZEB,   COAGFRB,     PVOLB,       PLLPB, 
     +                Z0B,      SCCB,      RCWB,       ACB,     
     +            LAIcamB,      RM0B,      ZPDB,     FCAPB,         WPB, 
     +               RGWB,     AESTB,    GAMMAB,    RHOP0B,    AERONUMB,
     +             rgridB,      SOAB,   ZFPRECB, 
     +           pretrowB,   radcldB,  trwtrowB,  iceB,   SNOWB,
     +           hno3rowb,   nh3rowb)

C      print*,'after cam_v5_b,sum(aero_trb)=',sum(aero_trb)
C      print*,'after cam_v5_b,sum(blcrowb)=',sum(blcrowb)


!jinmin
      wrab=0.0
      wrwb=0.0
      eps0b=0.0
      wrzb =0.0
      rcoexsb =0.0
      wrxb =0.0
      wryb =0.0
      rthpob =0.0
      aeronumb =0.0
      z0b =0.0
      trwtrowb =0.0
      radcldb =0.0
      deliqsb =0.0
      betab =0.0
      clsizeb =0.0
      recrysb =0.0
      rcritsb =0.0
      pdiffb =0.0
      totmasb =0.0
      rhopb =0.0
      rtcoab =0.0
      pdepvb =0.0
      saveradb =0.0
      f2b =0.0
      f1b =0.0
      epsib =0.0
      rhsizeb =0.0
      surfdgb =0.0
      ffgb =0.0
      rticldb =0.0
      rth2sb =0.0
      rtdmsb =0.0
      rtso4b =0.0
      rthb =0.0
      rtnuclb =0.0
      vdgb =0.0
      rtverb =0.0
      rtdryb =0.0
      rtbcldb =0.0
      rtcondb =0.0
      wetdepb =0.0
      colefb = 0.0
      pvolb=0.0
      coagfrb=0.0     
      deltb=0.0

      CALL POPINTEGER4(nk)
      CALL POPINTEGER4(nk)
      CALL POPINTEGER4(il1)
      CALL POPINTEGER4(il2)
      CALL POPreal8ARRAY(t, ni*nk)
      CALL POPreal8ARRAY(psfc, ni)
      CALL POPreal8ARRAY(shj, ni*(nk-1))
      CALL POPreal8ARRAY(sig, ni*nk)
      CALL POPreal8ARRAY(q, ni*nk)
      CALL POPINTEGER4(irest)
      CALL POPINTEGER4(mae)
      CALL POPINTEGER4(ntr)
      CALL POPINTEGER4(gnluc)
      CALL POPreal8ARRAY(surfwd, ni)
      CALL POPreal8ARRAY(aerosize, 2*13)
      DO ii1=6,1,-1
        CALL POPCHARACTERARRAY(aeroname(ii1), 8)
      ENDDO
      CALL POPreal8ARRAY(aso4row, ni)
      CALL POPreal8ARRAY(pso4row, ni)
      CALL POPreal8ARRAY(rhop0, 6)
      CALL POPreal8ARRAY(thlev, ni*(nk-1))
      CALL POPreal8ARRAY(dshj, ni*(nk-1))
      CALL POPINTEGER4(icam)
      CALL POPreal8(t(1, nk))
      CALL POPreal8(t(1, nk-1))
      CALL POPreal8ARRAY(frluc, ni*gnluc)

      CALL POPINTEGER4(k)
      DO i=icob,1,-1
        CALL POPINTEGER4(ad_from5)
        DO j=icob,ad_from5,-1
          voijb = 0.0
          CALL POPINTEGER4(ad_from4)
          DO k=icob,ad_from4,-1
            tmp1b = coagfrb(j, i, k)
            coagfrb(j, i, k) = 0.0
            coagfrb(i, j, k) = coagfrb(i, j, k) + tmp1b
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              tmp0b = coagfrb(i, j, k)
              coagfrb(i, j, k) = 0.0
              CALL POPreal8(arg12)
              CALL POPreal8(coagfr(i, j, k))
              CALL POPBOOLEAN(arg20)
              arg12b = 0.0
              CALL CVMGT_B(arg12, arg12b, coagfr(i, j, k), coagfrb(i, j
     +                     , k), arg20, tmp0b)
              coagfrb(i, j, k-1) = coagfrb(i, j, k-1) - arg12b
            END IF
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) THEN
              tmpb = coagfrb(i, j, k)
              coagfrb(i, j, k) = 0.0
              CALL POPreal8(arg11)
              CALL POPreal8(coagfr(i, j, k))
              CALL POPBOOLEAN(arg20)
              arg11b = 0.0
              CALL CVMGT_B(arg11, arg11b, coagfr(i, j, k), coagfrb(i, j
     +                     , k), arg20, tmpb)
              temp9b = arg11b/(voij*(vokp1-vok))
              temp9b0 = -(vok*(vokp1-voij)*temp9b/(voij*(vokp1-vok)))
              vokb = (vokp1-voij)*temp9b - voij*temp9b0
              vokp1b = voij*temp9b0 + vok*temp9b
              voijb = voijb + (vokp1-vok)*temp9b0 - vok*temp9b
              CALL POPreal8(vokp1)
              pvolb(k+1) = pvolb(k+1) + vokp1b
            ELSE
              vokb = 0.0
            END IF
            CALL POPCONTROL1B(branch)
            IF (branch .EQ. 0) coagfrb(i, j, k) = 0.0
            CALL POPreal8(vok)
            pvolb(k) = pvolb(k) + vokb
          ENDDO
          CALL POPINTEGER4(k)
          CALL POPreal8(voij)
          pvolb(i) = pvolb(i) + voijb
          pvolb(j) = pvolb(j) + voijb
        ENDDO
      ENDDO
      arg1 = isize*isize*isize
      CALL PUTZERO_B(coagfr, coagfrb, arg1)
      CALL POPINTEGER4(arg1)
      DO i=isize,1,-1
        ri = (aerosize(1, i)+aerosize(2, i))/2.0
        rib = 4.189*3*ri**2*pvolb(i)
        pvolb(i) = 0.0
        aerosizeb(1, i) = aerosizeb(1, i) + rib/2.0
        aerosizeb(2, i) = aerosizeb(2, i) + rib/2.0
      ENDDO
      CALL POPINTEGER4(ad_to10)
      DO i=ad_to10,1,-1
        CALL POPINTEGER4(k)
      ENDDO
      CALL POPINTEGER4(ad_to9)
      DO i=ad_to9,1,-1
        tb(i, nk) = tb(i, nk) + tsrowb(i)
        tsrowb(i) = 0.0
      ENDDO
      CALL POPINTEGER4(ad_to8)
      DO ik1=ad_to8,1,-1
        CALL POPINTEGER4(ad_to7)
        DO i=ad_to7,1,-1
          rgridb(i, ik1, cncahno3) = rgridb(i, ik1, cncahno3) + hno3rowb
     +      (i, ik1)
          hno3rowb(i, ik1) = 0.0
          rgridb(i, ik1, cncanh3) = rgridb(i, ik1, cncanh3) + nh3rowb(i
     +      , ik1)
          nh3rowb(i, ik1) = 0.0
          rgridb(i, ik1, cncaco2) = rgridb(i, ik1, cncaco2) + co2rowb(i
     +      , ik1)
          co2rowb(i, ik1) = 0.0
          rgridb(i, ik1, cncano3) = rgridb(i, ik1, cncano3) + no3rowb(i
     +      , ik1)
          no3rowb(i, ik1) = 0.0
          rgridb(i, ik1, cncao3) = rgridb(i, ik1, cncao3) + o3rowb(i, 
     +      ik1)
          o3rowb(i, ik1) = 0.0
          rgridb(i, ik1, cncah2o2) = rgridb(i, ik1, cncah2o2) + h2o2rowb
     +      (i, ik1)
          h2o2rowb(i, ik1) = 0.0
          rgridb(i, ik1, cncaoh) = rgridb(i, ik1, cncaoh) + ohrowb(i, 
     +      ik1)
          ohrowb(i, ik1) = 0.0
          rgridb(i, ik1, cncahno3) = 63.*rgridb(i, ik1, cncahno3)/28.97
          rgridb(i, ik1, cncah2o2) = 34.*rgridb(i, ik1, cncah2o2)/28.97
          rgridb(i, ik1, cncao3) = 48.*rgridb(i, ik1, cncao3)/28.97
          rgridb(i, ik1, cncaoh) = 17.*rgridb(i, ik1, cncaoh)/28.97
          CALL POPINTEGER4(ad_to6)
          DO l=ad_to6,1,-1
            aero_trb(i, k, l) = aero_trb(i, k, l) + rgridb(i, ik1, l)
            rgridb(i, ik1, l) = 0.0
          ENDDO
    !jinmin

          rhrowb(i, k) = 0.0

c         temp8 = DBLE(t(i, k)) - 35.86d0
c         temp7 = DBLE(t(i, k)) - DBLE(trpl)
c         temp5 = temp7/temp8
c         temp6 = 610.78d0*DEXP(17.269d0*temp5)
c         temp5b = -(17.269d0*DEXP(17.269d0*temp5)*610.78d0*result2*
c    +      rhrowb(i, k)/(temp6**2*temp8))
c         result2b = rhrowb(i, k)/temp6
c         tb(i, k) = tb(i, k) + (1.0-temp5)*temp5b
c         rhrowb(i, k) = 0.0
c         CALL POPREAL8(arg10)
c         CALL POPREAL8(arg4)
c         arg10b = 0.D0
c         arg4b = 0.D0
c         CALL DMIN1_B(arg10, arg10b, arg4, arg4b, result2b)
c         result11b = arg4b
c         CALL POPREAL8(arg2)
c         CALL POPREAL8(arg3)
c         arg2b = 0.D0
c         arg3b = 0.D0
c         CALL DMIN1_B(arg2, arg2b, arg3, arg3b, result11b)
c         temp4 = DBLE(eps2)
c         temp3 = DBLE(eps1) + temp4*DBLE(q(i, k))
c         temp0b0 = arg3b/temp3
c         temp0 = psfc(i)*sig(i, k)
c         temp2 = DBLE(temp0)
c         temp1 = DBLE(q(i, k))
c         temp0b1 = temp1*temp0b0
c         qb(i, k) = qb(i, k) + (temp2-temp4*temp1*temp2/temp3)*temp0b0
c         temp0b2 = arg2b
c         temp0b3 = arg10b
c         psfcb(i) = psfcb(i) + sig(i, k)*temp0b2 + sig(i, k)*temp0b3 + 
c    +      sig(i, k)*temp0b1
c         sigb(i, k) = sigb(i, k) + psfc(i)*temp0b2 + psfc(i)*temp0b3 + 
c    +      psfc(i)*temp0b1
        ENDDO
        CALL POPINTEGER4(k)
      ENDDO
      DO n=24,13,-1
        CALL POPINTEGER4(ad_from3)
        CALL POPINTEGER4(ad_to5)
        DO l=ad_to5,ad_from3,-1
          CALL POPINTEGER4(ad_from2)
          CALL POPINTEGER4(ad_to4)
          DO i=ad_to4,ad_from2,-1
            CALL POPCONTROL1B(branch)
            IF (branch .NE. 0) aero_trb(i, l, n) = 0.0
          ENDDO
        ENDDO
      ENDDO
      CALL POPreal8ARRAY(aero_tr, ni*nk*ntr)
      CALL POPreal8ARRAY(fktm, ni*nk)
      CALL POPINTEGER4(ni)
      CALL CHEM_TRVDIFF2_B(aero_tr, aero_trb, tr_loc, fktm, hght, dt, ni
     +                     , nk, ntr, trnch)
      DO n=24,13,-1
        CALL POPINTEGER4(ad_from1)
        CALL POPINTEGER4(ad_to3)
        DO l=ad_to3,ad_from1,-1
          CALL POPINTEGER4(ad_from0)
          CALL POPINTEGER4(ad_to2)
          DO i=ad_to2,ad_from0,-1
            CALL POPCONTROL1B(branch)
            IF (branch .NE. 0) aero_trb(i, l, n) = 0.0
          ENDDO
        ENDDO
      ENDDO
      CALL POPreal8ARRAY(aero_tr, ni*nk*ntr)
      CALL POPreal8ARRAY(fintrow, ni*12*3)
      CALL POPreal8ARRAY(pxnew, ni*(nk-1)*ntr)
      CALL POPreal8ARRAY(rsfrow, ni*ntr)
!         print*,'before call sfflux_b sum(blcrowb)=',sum(blcrowb)
      CALL SFFLUX_B(aero_tr, aero_trb, frluc, frlucb, dshj, dshjb, il1, 
     +              il2, ni, nk, arg1, ntr, aero_chem_np, aeroname, t, 
     +              tb, fintrow, volcrow, aso4row, aso4rowb, pso4row, 
     +              pso4rowb, poso4row, poso4rowb, blcrow, blcrowb, 
     +              dmsorow, dmslrow, h2srow, t(1, nk), aso2row, pso2row
     +              , poso2row, aero_nsize, rhop0, rhop0b, thlev, pxnew
     +              , pxnewb, aero_tr(1, 2, 1), aerosize, aerosizeb, 
     +              surfwd, surfwdb, rsfrow, rsfrowb, psfc, psfcb, icam
     +              , roarow, gc1, iae1, cncah2s, cncadms, cncaso2, 
     +              cncaso4, irest, gnluc, i_ss, omcrow, omcrowb, 
     +              sand2row, clay2row, snow, srel, nats, nsoil, mode, 
     +              mae, ns, z0, fhs, ss, surfdg, sand6row, tbar, 
     +              ano3row, ano3rowb, pno3row, pno3rowb, pono3row, 
     +              pono3rowb, rrdrow, rrdrowb)
        print*,'after call sfflux_b sum(blcrowb)=',sum(blcrowb)
        print*,'after call sfflux_b blcrowb(24,1,1)',blcrowb(24,1,1)
      CALL POPINTEGER4(ad_from)
      CALL POPINTEGER4(ad_to1)
      DO i=ad_to1,ad_from,-1
        rsfrowb(i, cncah2o2) = 0.0
        rsfrowb(i, cncaso4) = 0.0
        rsfrowb(i, cncaso2) = 0.0
        rsfrowb(i, cncah2s) = 0.0
        rsfrowb(i, cncadms) = 0.0
        CALL POPINTEGER4(ad_to0)
        DO l=ad_to0,iae1,-1
          rsfrowb(i, l) = 0.0
        ENDDO
      ENDDO
      CALL POPINTEGER4(ad_to)
      DO ik1=ad_to,1,-1
        k = ik1 + 1
        DO ii1=1,ni
          mcb(ii1, ik1) = 0.0
        ENDDO
        temp = rgasd*t(:, k)
        temp0b = roarowb(:, ik1)/temp
        DO ii1=1,ni
          psfcb(ii1) = psfcb(ii1) + shj(ii1, ik1)*temp0b(ii1)
        ENDDO
        DO ii1=1,ni
          shjb(ii1, ik1) = shjb(ii1, ik1) + psfc(ii1)*temp0b(ii1)
        ENDDO
        DO ii1=1,ni
          tb(ii1, k) = tb(ii1, k) - rgasd*psfc(ii1)*shj(ii1, ik1)*temp0b
     +      (ii1)/temp(ii1)
        ENDDO
        DO ii1=1,ni
          roarowb(ii1, ik1) = 0.0
        ENDDO
        DO ii1=1,ni
          sigb(ii1, k) = sigb(ii1, k) + dshjb(ii1, ik1)
        ENDDO
        DO ii1=1,ni
          sigb(ii1, ik1) = sigb(ii1, ik1) - dshjb(ii1, ik1)
        ENDDO
        DO ii1=1,ni
          dshjb(ii1, ik1) = 0.0
        ENDDO
        DO ii1=1,ni
          sigb(ii1, k) = sigb(ii1, k) + shjb(ii1, ik1)
        ENDDO
        DO ii1=1,ni
          shjb(ii1, ik1) = 0.0
        ENDDO
      ENDDO
      CALL POPINTEGER4(arg1)
      CALL PUTZERO_B(rsfrow, rsfrowb, arg1)
      CALL INAERO_B(aeroname, aerosize, aerosizeb, aero_chem_np, 
     +              aero_nsize, rhop0, iscam, id, jd, iti, itr, islev, 
     +              cam, dlev, luc, ng, ns, ml, pllp, z0, scc, rcw, ac, 
     +              cspec, laicam, rm0, zpd, fcap, wp, rgw, aest, gamma)
C
 1111 FORMAT(' AEROSOL TYPE(S) -> ',7('| ',a8,' |',1x))
 2222 FORMAT('     DENSITY(KG/M3) ',7('  ',f8.2,'  ',1x))
      END
