      SUBROUTINE AEROCLD(THROW,     XROW, AERONAME, AEROSIZE,
     1                     LEV,     ILEV,    ILG,      IL1,      IL2,
     2                     SHJ,   PRESSG,     QR,      MAE,
     3                  RADCLD,    RGRID, RTICLD,   ZFPREC,
     4                   PXNEW,   RHSIZE,   RHOP,     IHPO,     DSHJ,
     5                    SHTJ,     IAE1,AERONUM,    O3ROW,  H2O2ROW,
     5                     NTR,      NTP,  ISIZE,    THLEV,     ADT2,
     6                   GDREM,   ROAROW,     ID,       JD, 
     7                    ILWC,     IIWC,   ICDN,     ICLF,    CLDCV,
     8                   ZMLWC, CO2ROW,  HNO3ROW,   NH3ROW,    KOUNT,
     9                    NSUB,     WS,     MODV,     WROW,     EPSI,
     1                       F,      F1,      F2,     QROW,    TSROW,
     2                   RTSO2,   RTSO4,    JLAT,      LON,     NSO4,
     3                     CAM,      IT,     MSG,   WPEVPA,   WRSCAV,
     A                  RCRITS,  RCOEXS,     WRZ,      WRY,      WRX,
     B                     WRW,     WRU,     WRA,       MU,       EU,
     C                      DU,      MD,      MC,       ED,       DP,
     D                      DZ,      MB,    EPS0,      ZFG,  DSUBCLD,
     E                       Z,   IDEEP,      JT,     MAXG,      JDC,
     F                 LENGATH,  NTRACA,   RTHPO,     ISO2,       RU,
     G                     RUA,  ASRSO2,  ASRHPO,   IINCLD,   PRECTR,
     H                  CLSIZE,  RTBCLD)
C-----------------------------------------------------------------------
C
C     HISTORY:
C     --------
C     * DEC 02/1998 - S.L. GONG   THE IN-CLOUD REMOVAL DUE TO RAIN-OUT
C     *                           AND PRODUCTION DUE TO EVPORATION
C     *                           OF AEROSOLS AND GASES ARE PARAMETERIZED
C     *                           AS THE SAME FRACTION OF CLOUD WATER
C     *                           IS REMOVED OR PRODUCED IN A CLOUD .
C     *                           MODULE.
C     *
C     * JAN 11/1998 - S.L. GONG   AEROSOL-CLOUD INTERACTION MODULE:
C     *                           (1) SUB-GRID VERTICAL VELOCITY
C     *                               DISTRIBUTION.
C     *                           (2) AEROSOL ACTIVATION AND CLOUD
C     *                               SPECTRUM CALCULATION.
C     *                           (3) CLOUD CHEMISTRY OF SULPHATE
C     *                               OXIDATION
C     *
C     METHOD:
C     -------
C
C     VARIABLES:
C     ----------
C
C-----------------------------------------------------------------------
      REAL PXNEW(ILG,ILEV,NTR), XROW(ILG,LEV,NTR)
      REAL THLEV(ILG,ILEV), GDREM(ILG,NTR,3)
      REAL THROW(ILG,LEV), RTBCLD(ILG,ILEV,NTR)
      REAL PRESSG(ILG), SHJ(ILG,ILEV), SHTJ(ILG,LEV), DSHJ(ILG,ILEV)
      REAL ROAROW(ILG,ILEV), RTSO2(ILG,ILEV,2), RTSO4(ILG,ILEV,ISIZE)
      REAL RADCLD(ILG,ILEV), RGRID(ILG,ILEV,NTR)
      REAL RTICLD(ILG,ILEV,NTR),ZFPREC(ILG,ILEV)
      REAL RHSIZE(ILG,ILEV,ISIZE),RHOP(ILG,ILEV,ISIZE)
      REAL CLSIZE(ILG,ILEV,ISIZE)
      REAL AERONUM(ILG,ILEV,ISIZE)
      REAL H2O2ROW(ILG,ILEV), O3ROW(ILG,ILEV), CO2ROW(ILG,ILEV)
      REAL HNO3ROW(ILG,ILEV), NH3ROW(ILG,ILEV)
      REAL CLDCV(ILG,ILEV,2),ZMLWC(ILG,ILEV,2)
      REAL QR(ILG,ILEV,2), TSROW(ILG), QROW(ILG,LEV), WROW(ILG,ILEV)
      REAL WS (ILG, ILEV, NSUB), MODV(ILG,ILEV), F1(ILG,ILEV,NSUB)
      REAL F2(ILG,ILEV,NSUB),WPEVPA(ILG,ILEV), WRSCAV(ILG,ILEV)
      REAL EPSI(ILG,ILEV), PRECTR(ILG,NTR)
      REAL RCRITS(ILG,ILEV,2),RCOEXS(ILG,ILEV,2)
      REAL WRA(ILG*ILEV*36)
      REAL WRW(ILG,ILEV,NTR,9),WRX(ILG)
      REAL WRY(ILG,ILEV,NTRACA,2),WRZ(ILG,ILEV,ISIZE,2,2)
      REAL EPS0(ILG),MU(ILG,ILEV),EU(ILG,ILEV),DU(ILG,ILEV),MD(ILG,ILEV)
      REAL MC(ILG,ILEV),ED(ILG,ILEV),DP(ILG,ILEV),DZ(ILG,ILEV),MB(ILG)
      REAL ZFG(ILG,ILEV),DSUBCLD(ILG),RTHPO(ILG,ILEV)
      REAL RU(ILG,ILEV,NTR),RUA(ILG,ILEV,NTRACA)
      REAL ASRSO2(ILG,ILEV),ASRHPO(ILG,ILEV)
      REAL Z(ILG,ILEV)
      LOGICAL WRU(ILG,ILEV)
      INTEGER IDEEP(ILG),JT(ILG),MAXG(ILG),JDC(ILG),LENGATH
      INTEGER NFDM(12)
      REAL AEROSIZE (2, ISIZE)
      CHARACTER*8 AERONAME(NTP)
      INTEGER ID1,ID2,ID3,ID4,ID5,ID6,ID7,ID8,ID9,ID10,ID11,ID12,ID13,
     +        ID14,ID15,ID16,ID17,ID18,ID19,ID20,ID21,ID22,ID23,ID24,
     +        ID25,ID26,ID27,ID28,ID29,ID30,ID31,ID32,ID33,ID34,ID35,
     +        ID36,ID37,ID38,ID39,ID40,ID41,ID42,ID43,ID44,ID45,ID46,
     +        ID47,ID48,ID49,ID50,ID51,ID52,ID53,ID54,ID55,ID56,ID57,
     +        ID58,ID59,ID60,ID61,ID62,ID63,ID64,ID65,ID66,ID67,ID68,
     +        ID69,ID70,ID71,ID72,ID73,ID74,ID75,ID76,ID77,ID78,ID79,
     +        ID80,ID81,ID82,ID83,ID84,ID85,ID86,ID87,ID88,ID89,ID90,
     +        ID91,ID92,ID93,ID94,ID95,ID96,ID97,ID98,ID99
      COMMON /DCPOINT/  ID1, ID2, ID3, ID4, ID5, ID6, ID7, ID8, ID9,
     1                  ID10,ID11,ID12,ID13,ID14,ID15,ID16,ID17,ID18,
     2                  ID19,ID20,ID21,ID22,ID23,ID24,ID25,ID26,ID27,
     3                  ID28,ID29,ID30,ID31,ID32,ID33,ID34,ID35,ID36,
     4                  ID37,ID38,ID39,ID40,ID41,ID42,ID43,ID44,ID45,
     5                  ID46,ID47,ID48,ID49,ID50,ID51,ID52,ID53,ID54,
     6                  ID55,ID56,ID57,ID58,ID59,ID60,ID61,ID62,ID63,
     7                  ID64,ID65,ID66,ID67,ID68,ID69,ID70,ID71,ID72,
     8                  ID73,ID74,ID75,ID76,ID77,ID78,ID79,ID80,ID81,
     9                  ID82,ID83,ID84,ID85,ID86,ID87,ID88,ID89,ID90,
     A                  ID91,ID92,ID93,ID94,ID95,ID96,ID97,ID98,ID99
      COMPLEX F(ILG,ILEV,2*NSUB)
      COMMON /PARAMS/ WW,TW,RAYON,ASQ,G,RGAS,RGOCP,RGOASQ,CPRES
      COMMON /PARAMS/ RGASV,CPRESV
      COMMON /TIMES/ DELT,IFDIFF,KSTART,KTOTAL,NEWRUN,
     1                NDAYS,NSECS,IDAY,LDAY,MDAY,MDAYT,INCD

      DATA NFDM/  1, 32, 60, 91,121,152,182,213,244,274,305,335/ 
C
C    SECTION 1 CLOUD SUB-GRID VERTICAL VELOCITY [QUAM SCHEME]
C
      IF (CAM .EQ. 1.0 .OR. CAM .EQ. 10.0) GOTO 100
c zch not used in current version   2007.05.09
c      CALL SUBVVEL(  MODV,   EPSI, THROW,QROW,ZMLWC,  WS,    LEV,ILG,
c     1               DELT, ROAROW,    F1,  F2,    F,  SHJ,  SHTJ,
c     2              THLEV,  TSROW,PRESSG, IL1,  IL2, ILEV,  NSUB,MAE,
c     3              PXNEW(1,1,1), PXNEW(1,1,2),PXNEW(1,1,3),
c     4              PXNEW(1,1,4), PXNEW(1,1,5),PXNEW(1,1,6),
c     5              PXNEW(1,1,7), PXNEW(1,1,8),PXNEW(1,1,9)     )
C
C    SECTION 2 AEROSOL ACTIVATION AND CLOUD SPECTRUM [GHAN SCHEME]
C
 100  CALL AEROACT(    ILEV,   ILG,    IL1,    IL2,  IIWC,
     1        RCOEXS(1,1,1),RADCLD,  PXNEW, RHSIZE,  ILWC,
     2                  NTR, ISIZE,   RHOP,   ICDN,   WROW,
     3         XROW,    WS,RCRITS(1,1,1),   NSUB, AERONUM,
     4                ZMLWC,ROAROW, CLSIZE,    CAM,  MAE)
C
C    SECTION 3 CLOUD CHEMISTRY OF SULPHUR SPECIES [MCGILL SCHEME]
C
      DO NN=1,NTP
CZCH      IF (AERONAME(NN) .EQ. 'SULPHATE' .AND. CAM .LT. 10.)        THEN
      IF (AERONAME(NN) .EQ. 'SULPHATE' )        THEN
C
C---  activation in convective clouds
C--   this assumes complete activation in convective clouds due to
C---  the high upraft velocities in these clouds
C---  (parameters should be calculated by the new activation subroutine)
         DO L=1+MAE,ILEV
           DO I=IL1,IL2
             IF ( (ZMLWC(I,L,2).GT.0.).AND.(CLDCV(I,L,2).GT.0.) ) THEN
                RCRITS(I,L,2) = 1.
             ELSE
                RCRITS(I,L,2) = 0.0
             END IF
             RCOEXS(I,L,2) = RHSIZE(I,L,MIN(MAX(INT(RCRITS(I,L,2)),1)
     1                         ,ISIZE))
C
C---     CO2 concentration under rural conditions (in m**3/m**3)
C
             CO2ROW(I,L) = 3.3E-04
           END DO
         END DO
         CALL CLDCHEM ( IL1,      IL2,     ILEV,     ILG,    ISO2
     1                ,IHPO,       NN,      NTR,  NTRACA,   ISIZE
     2                ,IAE1,   RCRITS,   RCOEXS,  CLSIZE,   CLDCV
     3               ,ZMLWC,  H2O2ROW,   ROAROW,   THROW, HNO3ROW
     4              ,NH3ROW,    O3ROW,   CO2ROW,   RGRID,   RTHPO
     5              , RTSO4,    RTSO2,   PRESSG,     SHJ, AERONUM
     6              ,     G,     DSHJ,    IDEEP,      JT,    MAXG
     7              ,   JDC,     EPS0,       MU,      EU,      DU
     8              ,    MD,       MC,       ED,      DP,      DZ
     9              ,    MB,      MSG,      ZFG, LENGATH, DSUBCLD
     *           ,WRA(ID1 ),WRA(ID2 ),WRA(ID3 ),WRA(ID4 ),WRA(ID5 )
     1           ,WRA(ID6 ),WRA(ID7 ),WRA(ID8 ),WRA(ID9 ),WRA(ID10)
     2           ,WRA(ID11),WRA(ID12),WRA(ID13),WRA(ID14),WRA(ID15)
     3           ,WRA(ID16),WRA(ID17),WRA(ID18),WRA(ID19),WRA(ID20)
     4           ,WRA(ID21),WRA(ID22),WRA(ID23),WRA(ID24),WRA(ID25)
     5           ,WRA(ID26),WRA(ID27),WRA(ID28),WRA(ID29),WRA(ID30)
     6           ,WRA(ID31),WRA(ID32),WRA(ID33),WRA(ID34),WRA(ID35)
     7           ,WRA(ID36),WRU,WRW(1,1,1,1),WRW(1,1,1,2),WRW(1,1,1,3)
     8 ,WRW(1,1,1,4),WRW(1,1,1,5),WRW(1,1,1,6),WRW(1,1,1,7),WRW(1,1,1,8)
     9 ,WRW(1,1,1,9),WRX,WRY(1,1,1,1),WRY(1,1,1,2),WRZ(1,1,1,1,1)
     * ,WRZ(1,1,1,1,2),Z,XROW,KOUNT,PXNEW,RU,RUA,ASRSO2,ASRHPO,AEROSIZE
     2 ,THLEV, RTBCLD, ID, GDREM, MAE)
      END IF
      END DO
      IF (IINCLD .EQ. 0) RETURN
C
C    SECTION 4 RAIN-OUT AND EVPORATION OF AEROSOL PARTICLES AND SO2
C
      CALL       INCLD (   ILG,   ILEV,    LEV,    NTR,     IAE1,   
     1                   ISIZE,    MAE,    CAM,    IL1,      IL2,
     2                  PRECTR, RCRITS,   XROW, WRSCAV,     DELT,
     3                  WPEVPA, RTICLD,  GDREM, PRESSG,     DSHJ,
     4                    ISO2,   IHPO,   NSO4,      G,      NTP,
     5                  ZFPREC,  CLDCV, ASRSO2, ASRHPO )
      RETURN
      END
