SUBROUTINE ad_nk1_linear_interp(x,y,z,u0,u0b,b,bb, &
                           ims,ime,jms,jme,kms,kme, &
                           ids,ide,jds,jde,kds,kde, &
                           its,ite,jts,jte,kts,kte,nnn)
   IMPLICIT NONE
   INTEGER,INTENT(IN) :: ims,ime,jms,jme,kms,kme, &
                          ids,ide,jds,jde,kds,kde, &
                          its,ite,jts,jte,kts,kte,nnn
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme) :: x,y,z,u0,b
   INTEGER :: i,j,k,ix,iy,iz
   REAL :: x0,y0,z0,f1,f2,f3,f4,f5,f6,f7,f8,ust
!zhaisx
   REAL :: ustb,f1b,f2b,f3b,f4b,f5b,f6b,f7b,f8b
   REAL :: dc1
   REAL,DIMENSION(ims:ime,kms:kme,jms:jme) :: u0b,bb
   REAL :: x0b,y0b,z0b,f0b,f0
   dc1     =1.0d0
  
   ustb = 0.0d0
   u0b  = 0.0d0
   f1b  = 0.0d0
   f2b  = 0.0d0
   f3b  = 0.0d0
   f4b  = 0.0d0
   f5b  = 0.0d0
   f6b  = 0.0d0
   f7b  = 0.0d0
   f8b  = 0.0d0
   
   DO j=jte,jts,-1
    DO k=kte+1,kts,-1
     DO i=ite,its,-1

            ix=int(x(i,k,j))

            iy=int(y(i,k,j))

            iz=min0(kte,int(z(i,k,j)))

            IF (iz.lt.kts) iz=kts

            x0=x(i,k,j)-ix
            y0=y(i,k,j)-iy
            z0=z(i,k,j)-iz

            IF ( ix==ite ) THEN
               ix=ite-1
               x0=dc1
            ENDIF
            IF ( iy==jte ) THEN
               iy=jte-1
               y0=dc1
            ENDIF

            f1=u0(ix,iz,iy)
            f2=u0(ix+1,iz,iy)
            f3=u0(ix,iz,iy+1)
            f4=u0(ix+1,iz,iy+1)
            f5=u0(ix,iz+1,iy)
            f6=u0(ix+1,iz+1,iy)
            f7=u0(ix,iz+1,iy+1)
            f8=u0(ix+1,iz+1,iy+1)

          ustb = bb(i,k,j)
          bb(i,k,j) = 0.0d0

!          if(ustb.ne.0.0)then
!          print*,'ustb=',ustb
!          endif

          CALL ad_linear_intp(f1,f1b,f2,f2b,f3,f3b,f4,f4b,&
                 f5,f5b,f6,f6b,f7,f7b,f8,f8b,x0,x0b,y0,y0b,z0,z0b,ust,ustb)

          u0b(ix+1,iz+1,iy+1)=u0b(ix+1,iz+1,iy+1)+f8b
          f8b=0.0d0
          u0b(ix,iz+1,iy+1)=u0b(ix,iz+1,iy+1)+f7b
          f7b=0.0d0
          u0b(ix+1,iz+1,iy)=u0b(ix+1,iz+1,iy)+f6b
          f6b=0.0d0
          u0b(ix,iz+1,iy)=u0b(ix,iz+1,iy)+f5b
          f5b=0.0d0
          u0b(ix+1,iz,iy+1)=u0b(ix+1,iz,iy+1)+f4b
          f4b=0.0d0
          u0b(ix,iz,iy+1)=u0b(ix,iz,iy+1)+f3b
          f3b=0.0d0
          u0b(ix+1,iz,iy)=u0b(ix+1,iz,iy)+f2b
          f2b=0.0d0
          u0b(ix,iz,iy)=u0b(ix,iz,iy)+f1b
          f1b=0.0d0

     ENDDO
    ENDDO
   ENDDO

!          print*,'sum(u0b)=',sum(u0b)

END SUBROUTINE ad_nk1_linear_interp


SUBROUTINE ad_linear_intp(f1,f1b,f2,f2b,f3,f3b,f4,f4b,&
                 f5,f5b,f6,f6b,f7,f7b,f8,f8b,x0,x0b,y0,y0b,z0,z0b,f0,f0b)
  IMPLICIT NONE
     REAL,INTENT(in) :: f1,f2,f3,f4,f5,f6,f7,f8
                                      ! 8 points surrounding to be interpolated
   REAL,INTENT(in) :: x0,y0,z0 ! coorinates (0--1)to be interpolated
! note: x0,y0,z0 must be >=0. and <1.
   REAL,INTENT(out) :: f0
   REAL :: t,u,v,t1,u1,v1 ! temp variable
!zhaisx
   REAL :: f1b,f2b,f3b,f4b,f5b,f6b,f7b,f8b,x0b,y0b,z0b,f0b
   REAL :: tb,ub,vb,t1b,u1b,v1b ! temp variable

   t=x0 ! -aint(x0)
   u=y0 ! -aint(y0)
   v=z0 ! -aint(z0)
   t1=1.-t
   u1=1.-u
   v1=1.-v
   
   t1b = 0.0d0
   u1b = 0.0d0
   v1b = 0.0d0
   tb  = 0.0d0
   ub  = 0.0d0
   vb  = 0.0d0
   f1b = 0.0d0
   f2b = 0.0d0
   f3b = 0.0d0
   f4b = 0.0d0
   f5b = 0.0d0
   f6b = 0.0d0
   f7b = 0.0d0
   f8b = 0.0d0

!          if((f0b.gt.1.0e-10).or.(f0b.lt.-1.0e-10))then
!          print*,'f0b=',f0b
!          endif
   
   t1b=t1b+(u1*v1*f1+u*v1*f3+u1*v*f5+u*v*f7)*f0b
   u1b=u1b+(t1*v1*f1+t*v1*f2+t1*v*f5+t*v*f6)*f0b
   v1b=v1b+(t1*u1*f1+t*u1*f2+t1*u*f3+t*u*f4)*f0b
   tb= tb+(u1*v1*f2+u*v1*f4+u1*v*f6+u*v*f8)*f0b
   ub= ub+(t1*v1*f3+t*v1*f4+t1*v*f7+t*v*f8)*f0b
   vb= vb+(t1*u1*f5+t*u1*f6+t1*u*f7+t*u*f8)*f0b

   f1b= f1b+t1*u1*v1*f0b
   f2b= f2b+t*u1*v1*f0b
   f3b= f3b+t1*u*v1*f0b
   f4b= f4b+t*u*v1*f0b
   f5b= f5b+t1*u1*v*f0b
   f6b= f6b+t*u1*v*f0b
   f7b= f7b+t1*u*v*f0b
   f8b= f8b+t*u*v*f0b
   f0b=0.0d0
   
   vb=vb-v1b
   v1b=0.0d0
   ub=ub-u1b
   u1b=0.0d0
   tb=tb-t1b
   t1b=0.0d0

   z0b=z0b+vb
   vb=0.0d0
   y0b=y0b+ub
   ub=0.0d0
   x0b=x0b+tb
   tb=0.0d0
END SUBROUTINE ad_linear_intp

