/*--------------------------------------------------------------------
 * This file is part of the software for Fig 7 in the 
 * libRadtran-2.0 paper.
 *
 * Copyright (c) 2016 by Arve Kylling (arve.kylling@gmail.com)

 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License   
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.        
 * 
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the   
 * GNU General Public License for more details.                    
 * 
 * You should have received a copy of the GNU General Public License          
 * along with this program; if not, write to the Free Software                
 * Foundation, Inc., 59 Temple Place - Suite 330, 
 * Boston, MA 02111-1307, USA.
 *--------------------------------------------------------------------*/

import numpy as np
from matplotlib.colors import colorConverter
import math
import matplotlib.pyplot as plt
from matplotlib.legend import Legend 
from matplotlib.legend import rcParams
from matplotlib.ticker import MultipleLocator, FormatStrFormatter
from Scientific.IO.NetCDF import NetCDFFile as Dataset

def read_two_column(fn):

    f  = open(fn,'r')

    x  = []
    y = []
    for line in f:
        if line.find('#') != -1:
            next
        else:
            ary = map(float,line.split())
            x.append(ary[0])
            y.append(ary[1])

    f.close()
    x=np.array(x)
    y=np.array(y)
    return x,y

def read_output(fn):

    f  = open(fn,'r')

    wvl  = []
    edir = []
    uu   = []
    for line in f:
        ary = map(float,line.split())
        wvl.append(ary[0])
        edir.append(ary[1])
        uu.append(ary[3])

    f.close()
    wvl=np.array(wvl)
    edir=np.array(edir)
    uu=np.array(uu)
    return wvl,edir,uu

def conv(wvl,data,slit_function):
    out = 'tmp_conv'
    sav = 'tmp_sav'
    np.savetxt(sav,np.transpose((wvl,data)))
    cmd = home+'/libRadtran/bin/conv '+sav+' '+slit_function+ ' > ' + out
    p   = call(cmd,shell=True,stdin=PIPE,stdout=PIPE)
    data = np.loadtxt(out)
    data = data[:,1]
    return data

###########################################################################################

plot_type = 'LowerPlotFig7' # 'UpperPlotFig7' #

fsize=20
fact=1.
fig = plt.figure(figsize=(11*fact,7*fact))
pl_list = [] 

host = fig.add_subplot(111)

if plot_type == 'LowerPlotFig7':
    fig.subplots_adjust(top=0.94, bottom=0.13)
    fn1 = 'UVSPEC_FLUORESCENCE_670_700_fluor.OUTc_0.3' 
    fn2 = 'UVSPEC_FLUORESCENCE_670_700_nofluor.OUTc_0.3'
    fn3 = '../../../libRadtran-2.0/examples/UVSPEC_FLUORESCENCE.TOC'
    fn4 = '../../../libRadtran-2.0/examples/UVSPEC_FLUORESCENCE.FLU'
    (wvl,edir,uuo) = read_output(fn1)
    (wvl,edirc,uuc) = read_output(fn2)
    (wvla,alb) = read_two_column(fn3)
    (wvlf,flu) = read_two_column(fn4)
    par  = host.twinx()
    ylabel='L [photons/(s nm cm$^2$ sr)]'
    par.set_ylabel('Albedo', fontsize = fsize)
    col = 'b'
    x  = wvl
    y  = uuo
    pl, = host.plot(x, y, color=col)
    pl_list.append(pl) 
    col = 'm'
    x  = wvl
    y  = uuc
    pl, =host.plot(x, y, color=col)
    pl_list.append(pl) 
    col = 'r'
    x  = wvlf
    y  = flu*20
    pl, =host.plot(x, y, color=col)
    pl_list.append(pl) 
    ymin= 0.2e+13
    ymax= 1.1e+13
    ymaL=  .2e+13
    ymiL= 1.0e+12
    xmin=675
    xmax=700
    xmaL= 5
    xmiL= 1
    col = 'g'
    x  = wvla
    y  = alb
    pl, =par.plot(x, y, color=col)
    pl_list.append(pl) 
    bbx = 0.03
    bby = 0.99
    legend = plt.legend((pl_list[0], pl_list[1],pl_list[2], pl_list[3]),
                             ('With fluorescence',
                              'Without fluorescence',
                              'Fluorescence source (*20)',
                              'Albedo',),
                             'upper left',
                             bbox_to_anchor = [bbx, bby],
                             shadow = False)
    ymajorLocator   = MultipleLocator(0.1)
    par.yaxis.set_major_locator(ymajorLocator)
    yminorLocator   = MultipleLocator(0.02)
    par.yaxis.set_minor_locator(yminorLocator)
    par.set_ylim(0,0.2)
elif plot_type == 'UpperPlotFig7':
    fig.subplots_adjust(top=0.94, bottom=0.13)
    fn1 = 'UVSPEC_FLUORESCENCE_670_700_fluor.OUT' 
    fn2 = 'UVSPEC_FLUORESCENCE_670_700_fluor_trans.OUT' 

    ncfile = Dataset('../../../libRadtran-2.0/examples/UVSPEC_FLUORESCENCE_arts-640-810.nc','r')
    wvlt = ncfile.variables['wvl'][:]
    tau  = ncfile.variables['tau'][:]
    ncfile.close()
    taut=np.zeros(len(wvlt))
    i=0
    while i<len(wvlt):
        taut[i] = np.sum(tau[:,i])
        i=i+1
    (wvl,edir,uuo) = read_output(fn1)
    (wvl,edirc,uuc) = read_output(fn2)
    par  = host.twinx()
    ylabel='L [photons/(s nm cm$^2$ sr)]'
    par.set_ylabel('Transmittance', fontsize = fsize)
    col = 'r'
    x  = wvlt
    y  = np.exp(-taut)
    pl, =par.plot(x, y, color=col)
    pl_list.append(pl) 
    col = 'b'
    x  = wvl
    y  = uuo
    pl, = host.plot(x, y, color=col)
    pl_list.append(pl) 
    ymin= 0.0e+13
    ymax= 1.1e+13
    ymaL=  .2e+13
    ymiL= 1.0e+12
    xmin=675
    xmax=700
    xmaL= 5
    xmiL= 1
    bbx = 0.03
    bby = 0.85
    legend = plt.legend((pl_list[0], pl_list[1]),
                             ('Transmittance',
                              'Radiance',),
                             'upper left',
                             bbox_to_anchor = [bbx, bby],
                             shadow = False)
    ymajorLocator   = MultipleLocator(0.2)
    par.yaxis.set_major_locator(ymajorLocator)
    yminorLocator   = MultipleLocator(0.02)
    par.yaxis.set_minor_locator(yminorLocator)
    par.set_ylim(0,1.05)

rcParams.update({'font.size':fsize})

host.set_xlim(xmin,xmax)
host.set_ylim(ymin,ymax)
host.set_xlabel(r"Wavelength [nm]", fontsize = fsize)
host.set_ylabel(ylabel, fontsize = fsize)
xminorLocator   = MultipleLocator(xmiL)
xmajorLocator   = MultipleLocator(xmaL)
host.xaxis.set_minor_locator(xminorLocator)
host.xaxis.set_major_locator(xmajorLocator)

ymajorLocator   = MultipleLocator(ymaL)
host.yaxis.set_major_locator(ymajorLocator)
yminorLocator   = MultipleLocator(ymiL)
host.yaxis.set_minor_locator(yminorLocator)

plt.show()




