from pylab import *
import os
import subprocess                          

theta=array([5,30,45,60,70,80,85,88,90])
umus=-cos(theta*pi/180)
sza=array([88, 90, 92, 93, 94, 95, 96, 97.5, 99.])

wavelength=500

run_calc=1

if run_calc:
    rad=zeros((len(sza), len(umus), 4))         
    std=zeros((len(sza), len(umus), 4))         

    for j in range(len(sza)): 

        processes=set()                
        max_processes=9               

        for i in range(len(umus)):

            tmp = open('mystic_run.inp').read()
            inp = open('input/mystic%d.inp'%i, 'w')
            inp.write(tmp)
            inp.write('umu %g \n'%umus[i])
            inp.write('sza %g \n'%sza[j])
            inp.write('wavelength %f \n'%wavelength)
            inp.write('mc_basename output/%d_result \n'%i)
            inp.close()

            processes.add(subprocess.Popen(['uvspec', '-f', 'input/mystic%d.inp'%i]))

            if len(processes)>=max_processes:
                os.wait()
                # processes.difference_update(
                #    p for p in processes if p.poll() is not None)

        for p in processes:
            if p.poll() is None:
                p.wait();    

        for i in range(len(umus)): 
            rad[j,i,:]=loadtxt('output/%d_result.rad.spc'%i)[:,4]
            std[j,i,:]=loadtxt('output/%d_result.rad.std.spc'%i)[:,4]

        np.save('rad_%f.npy'%wavelength, rad)
        np.save('std_%f.npy'%wavelength, std) 


figure(1)
for j in range(len(sza)):
    semilogy(theta, pi*rad[j,:,0])
    ylabel(r'$\pi$I')
    xlabel(r'$\theta$')
    #errorbar(umus, pi*rad[j,:], pi*std[j,:])
    


