from pylab import *

rad_500=np.load('rad_500.npy')
rad_700=np.load('rad_700.npy')

theta=array([5,30,45,60,70,80,85,88,90])
sza=array([88, 90, 92, 93, 94, 95, 96, 97.5, 99.])

figure(1)
#suptitle('Radiance at twilight')
subplot(121)
for j in range(len(sza)):
    semilogy(theta, pi*rad_500[j,:,0], 'ko-', ms=4)
    ylabel(r'$\pi$L',  fontsize=14)
    xlabel(r'$\theta$ [$^\circ$]', fontsize=14)
    xlim(-20, 100)
    ylim(1e-7, 1)
    text(-5, pi*rad_500[j,0,0] , r'%.0f$^\circ$'%(sza[j]-90))
    title('500 nm')
    
subplot(122)
for j in range(len(sza)):
    semilogy(theta, pi*rad_700[j,:,0], 'ko-', ms=4)
    #ylabel(r'$\pi$I', fontsize=14)
    xlabel(r'$\theta$ [$^\circ$]', fontsize=14)
    xlim(-20, 100)
    text(-5, pi*rad_700[j,0,0] , r'%.0f$^\circ$'%(sza[j]-90))
    title('700 nm')
    ylim(1e-7, 1)

savefig('blaettner_fig5.pdf')

