from pylab import *

# Viewing angle
va=arange(-50., 1., 2., dtype='d')
umu=cos(va*pi/180.)

# Solar zenith angles
sza=[30.]

# Relative azimuth angles
phi=[0., 180.]
dphi=0

# wavelengths
lam=[443,670,865]

radiance=np.load('radiance.npy')
std=np.load('std.npy')


# plot results 
figure(1, figsize=(8,16))
isza=0
ilam=0

cases=[0,1,2,4,5,7]

colors=['b','g','r']
sts=['-','--','-.']
titles=[r'mol. atmosphere', r'ocean surface', r'aerosol desert', r'maritime', r'liquid water cloud', r'ice cloud smooth', r'ice plate smooth', r'ice cloud rough']

for ilam in range(3):
    i=0
    for case in cases:
        subplot(6,2,2*i+1)
        plot(va, radiance[:,isza,0,ilam,0,case], color=colors[ilam], ls=sts[ilam])
        plot(-va, radiance[:,isza,1,ilam,0,case], color=colors[ilam], ls=sts[ilam])  
        ylabel(titles[case])
        if i<len(cases)-1:
            xticks(arange(-50,51,25),'')
        if(i==len(cases)-1):
            xticks(arange(-50,51,25))
            xlabel(r'viewing angle [$^\circ$]')
        if(i==0):
            title(r'I')
            yticks(arange(0.,0.04,0.01))
            ylim(0,0.04)
        elif i==1:
            yticks(arange(0., 0.16, 0.04))
            ylim(0,0.16)
        elif i==2:
            yticks(arange(0.07,0.1,0.01))
            ylim(0.07, 0.1)
        elif i==3:
            yticks(arange(0.1,0.16,0.02))
            ylim(0.1,0.16)
        elif i==4:
            yticks(arange(0.02,0.18,0.04))
            ylim(0.02, 0.18)
        elif i==5:
            yticks(arange(0.02, 0.08, 0.02))
            ylim(0.02, 0.08)

        subplot(6,2,2*i+2)
        plot(va, radiance[:,isza,0,ilam,1,case], color=colors[ilam], ls=sts[ilam])
        plot(-va, radiance[:,isza,1,ilam,1,case], color=colors[ilam], ls=sts[ilam])
        
        if i<len(cases)-1:
            xticks(arange(-50,51,25),'')
        if(i==len(cases)-1):
            xticks(arange(-50,51,25))
            xlabel(r'viewing angle [$^\circ$]')
        if(i==0):
            title(r'Q')
            yticks(arange(-0.02,0.01, 0.01))
            ylim(-0.02,0.005)
        elif i==1:
            yticks(arange(-0.07,0.01, 0.02))
            ylim(-0.075, 0.005)
        elif i==2:
            yticks(arange(-0.02,0.01,0.01))
            ylim(-0.02,0.005)
        elif i==3:
            yticks(arange(-0.02,0.01, 0.01))
            ylim(-0.025, 0.01)
        elif i==4:
            yticks(arange(-0.01, 0.02, 0.01))
            ylim(-0.015,0.015)
        elif i==5:
            yticks(arange(-0.01,0.01, 0.01))
            ylim(-0.015,0.005)
            # subplot(6,3,3*i+3)
        # plot(va, radiance[:,isza,0,ilam,1,case]/radiance[:,isza,0,ilam,0,case], color=colors[ilam])
        # plot(-va, radiance[:,isza,1,ilam,1,case]/radiance[:,isza,1,ilam,0,case], color=colors[ilam])
        # if(case==len(cases)):
        #     xlabel('viewing angle [deg]')
        # if(case==0):
        #     title('Q')
        i+=1
    

subplots_adjust(wspace=0.25, hspace=0.05)

figure(1)
savefig('Fig_10.pdf')
