#!/bin/bash

export PFL_DIR=$SVAROOT/parflow
export PFL_LIB_SRC_DIR=$SVAROOT/parflow/pfsimulator/parflow_lib
export PFL_PFS_DIR=$PFL_DIR/pfsimulator
export PFL_PFT_DIR=$PFL_DIR/pftools


##################################################
# PARFLOW: modification for adopting PDAF
##################################################

# parflow_proto.h
sed "/void SetupRichards (PFModule .*this_module).*/i \\
// PDAF: this function is for initialization of OASIS only \\
void PseudoAdvanceRichards(PFModule *this_module, \\
                    double start_time,      /* Starting time */ \\
                    double stop_time,       /* Stopping time */ \\
                    PFModule *time_step_control, /* Use this module to control timestep if supplied */ \\
                    Vector *evap_trans,     /* Flux from land surface model */ \\
                    Vector **pressure_out,  /* Output vars */ \\
                    Vector **porosity_out, \\
                    Vector **saturation_out \\
   );
" -i $PFL_LIB_SRC_DIR/parflow_proto.h

# solver_richards.c
sed "s/.*CALL_oas_pfl_define.*//" -i $PFL_LIB_SRC_DIR/solver_richards.c
sed "/double  pfl_stop = GetDouble/a \\
\t// PDAF: getting start time\\
\tdouble pfl_start = GetDouble(\"TimingInfo.StartTime\");
" -i $PFL_LIB_SRC_DIR/solver_richards.c
sed "/void TeardownRichards/i \\
void PseudoAdvanceRichards(PFModule *this_module,\\
               double start_time,      /* Starting time */\\
               double stop_time,       /* Stopping time */\\
               PFModule *time_step_control, /* Use this module to control timestep if supplied */\\
               Vector *evap_trans,     /* Flux from land surface model */\\
               Vector **pressure_out,  /* Output vars */\\
               Vector **porosity_out,\\
               Vector **saturation_out\\
)\\
{\\
       printf(\"Pseudo richard for OAS init\\\n\");\\
\\
       PublicXtra   *public_xtra        = (PublicXtra *)PFModulePublicXtra(this_module);\\
       InstanceXtra *instance_xtra      = (InstanceXtra *)PFModuleInstanceXtra(this_module);\\
       Problem      *problem            = (public_xtra -> problem);\\
\\
       int           max_iterations      = (public_xtra -> max_iterations);\\
       int           print_satur         = (public_xtra -> print_satur);\\
       int           print_wells         = (public_xtra -> print_wells);\\
\\
       PFModule     *problem_saturation  = (instance_xtra -> problem_saturation);\\
       PFModule     *phase_density       = (instance_xtra -> phase_density);\\
       PFModule     *select_time_step    = (instance_xtra -> select_time_step);\\
       PFModule     *l2_error_norm       = (instance_xtra -> l2_error_norm);\\
       PFModule     *nonlin_solver       = (instance_xtra -> nonlin_solver);\\
\\
       ProblemData  *problem_data        = (instance_xtra -> problem_data);\\
\\
       int           start_count         = ProblemStartCount(problem);\\
       double        dump_interval       = ProblemDumpInterval(problem);\\
\\
       Vector       *porosity            = ProblemDataPorosity(problem_data);\\
       Vector       *evap_trans_sum      = instance_xtra -> evap_trans_sum;\\
       Vector       *overland_sum        = instance_xtra -> overland_sum;     /* sk: Vector of outflow at the boundary*/\\
#ifdef HAVE_OAS3\\
       Grid         *grid                = (instance_xtra -> grid);\\
       Subgrid      *subgrid;\\
       Subvector    *p_sub, *s_sub, *et_sub, *m_sub;\\
       double       *pp, *sp, *et, *ms;\\
       double       sw_lat = .0;\\
       double       sw_lon = .0;\\
#endif\\
\\
\\
       int           rank;\\
       int           any_file_dumped;\\
       int           clm_file_dumped;\\
       int           dump_files;\\
       int           clm_dump_files;\\
       int           retval;\\
       int           converged;\\
       int           take_more_time_steps;\\
       int           conv_failures;\\
       int           max_failures         = public_xtra -> max_convergence_failures;\\
\\
       double        t;\\
       double        dt = 0.0;\\
       double        ct = 0.0;\\
       double        cdt = 0.0;\\
       double        print_dt;\\
       double        print_cdt;\\
       double        dtmp, err_norm;\\
       double        gravity = ProblemGravity(problem);\\
\\
       VectorUpdateCommHandle   *handle;\\
\\
       char          dt_info;\\
       char          file_prefix[2048], file_type[2048], file_postfix[2048];\\
\\
       sprintf(file_prefix, \"%s\", GlobalsOutFileName);\\
\\
#ifdef HAVE_OAS3\\
\\
       int p = GetInt(\"Process.Topology.P\");\\
       int q = GetInt(\"Process.Topology.Q\");\\
       int r = GetInt(\"Process.Topology.R\");\\
       int nlon = GetInt(\"ComputationalGrid.NX\");\\
       int nlat = GetInt(\"ComputationalGrid.NY\");\\
       double  pfl_step = GetDouble(\"TimeStep.Value\");\\
       double  pfl_stop = GetDouble(\"TimingInfo.StopTime\");\\
       double pfl_start = GetDouble(\"TimingInfo.StartTime\");\\
       int is;\\
       ForSubgridI(is, GridSubgrids(grid))\\
       {\\
               double        dx,dy;\\
               int           nx,ny,ix,iy;\\
\\
               subgrid  = GridSubgrid(grid, is);\\
\\
               nx = SubgridNX(subgrid);\\
               ny = SubgridNY(subgrid);\\
\\
               ix = SubgridIX(subgrid);\\
               iy = SubgridIY(subgrid);\\
\\
               dx = SubgridDX(subgrid);\\
               dy = SubgridDY(subgrid);\\
\\
               // gw only init once\\
               // kuw\\
               //CALL_oas_pfl_define(nx,ny,dx,dy,ix,iy,sw_lon,sw_lat,nlon,nlat,pfl_step,pfl_stop);\\
               //if((start_time-pfl_start)<1e-12){\\
                       CALL_oas_pfl_define(nx,ny,dx,dy,ix,iy,sw_lon,sw_lat,nlon,nlat,pfl_step,pfl_stop);\\
       //      }\\
               // kuw end\\
                       // gw end\\
       }\\
       amps_Sync(amps_CommWorld);\\
\\
#endif     // end to HAVE_OAS3 CALL\\
}\\
" -i $PFL_LIB_SRC_DIR/solver_richards.c

if grep -qcm1 'GetPressureRichards' $PFL_LIB_SRC_DIR/solver_richards.c ; then
   echo 'GetPressureRichards already there'
else
echo "
Vector *GetPressureRichards(PFModule *this_module) {                                   
   InstanceXtra  *instance_xtra    = (InstanceXtra *)PFModuleInstanceXtra(this_module);
   return (instance_xtra -> pressure);                                                 
}                                                                                      
                                                                                       
Vector *GetSaturationRichards(PFModule *this_module) {                                 
   InstanceXtra  *instance_xtra    = (InstanceXtra *)PFModuleInstanceXtra(this_module);
   return (instance_xtra -> saturation);                                               
}                                                                                      
                                                                                       
Vector *GetDensityRichards(PFModule *this_module) {                                    
   InstanceXtra  *instance_xtra    = (InstanceXtra *)PFModuleInstanceXtra(this_module);
   return (instance_xtra -> density);                                                  
}" >> $PFL_LIB_SRC_DIR/solver_richards.c 
fi

# Parflow stand alone
if [ "$COUPLE_TYPE" = parflow_stand_alone ]; then
# copy da amps
cp -r amps_parflow_stand_alone/da  ../../parflow/pfsimulator/amps/
#add amps to config
sed "/\"\$with_amps\" in\s*/ a\
  da\)\\
    AMPS=da\\
  ;;
" -i $PFL_PFS_DIR/configure
sed "/\"\$with_amps\" in\s*/ a\
  da\)\\
    AMPS=da\\
  ;;
" -i $PFL_PFT_DIR/configure
# rm pre-build libs
rm $PFL_DIR/lib/*
# change comms in Hypre
sed "s/MPI_COMM_WORLD/amps_CommWorld/g" -i $PFL_LIB_SRC_DIR/pf_pfmg.c
sed "s/MPI_COMM_WORLD/amps_CommWorld/g" -i $PFL_LIB_SRC_DIR/pf_pfmg_octree.c
sed "s/MPI_COMM_WORLD/amps_CommWorld/g" -i $PFL_LIB_SRC_DIR/pf_smg.c
fi # End Parflow stand alone